/*
 * Decompiled with CFR 0.152.
 */
package ReceiptPrinter;

import ReceiptPrinter.Gen;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpos.PosUtils;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.basscom.utils.Utils;

public class PrintReceipt
implements AutoCloseable {
    private boolean saveSpaceOnDocket = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.SAVE_SPACE_ON_DOCKET);
    private static final int THAI_TOP = 1;
    private static final int THAI_ABOVE = 2;
    private static final int THAI_BASE = 3;
    private static final int THAI_BELOW = 4;
    private static final String GS = "\u001d";
    public static final String EPSON_barUPC_A = "\u0000";
    public static final String EPSON_barUPC_B = "\u0001";
    public static final String EPSON_barEAN13 = "\u0002";
    public static final String EPSON_barEAN8 = "\u0003";
    public static final String EPSON_barCODE39 = "\u0004";
    public static final String EPSON_barITF = "\u0005";
    public static final String EPSON_barCODABAR = "\u0006";
    public static final String EPSON_qrCodeCommand65 = "\u001d(k\u0004\u00001A2\u0000";
    public static final String EPSON_qrCodeCommand67 = "\u001d(k\u0003\u00001C:size";
    public static final String EPSON_qrCodeCommand69 = "\u001d(k\u0003\u00001E0";
    public static final String EPSON_qrCodeCommand80 = "\u001d(k:length\u00001P0";
    public static final String EPSON_qrCodeCommand81 = "\u001d(k\u0003\u00001Q0";
    public static final String jLeft = "\u001b\u0001";
    public static final String jCentre = "\u001b\u0002";
    public static final String jRight = "\u001b\u0003";
    public static final String fontANormal = "\u001b\u0004";
    public static final String fontBNormal = "\u001b\u0005";
    public static final String fontABold = "\u001b\u0006";
    public static final String fontBBold = "\u001b\u0007";
    public static final String fontAUnderline = "\u001b\b";
    public static final String fontBUnderline = "\u001b\t";
    public static final String fontABoldUnderline = "\u001b\u000b";
    public static final String fontBBoldUnderline = "\u001b\f";
    public static final String fontADoubleHeight = "\u001b\u000e";
    public static final String fontBDoubleHeight = "\u001b\u000f";
    public static final String fontADoubleWidth = "\u001b\u0010";
    public static final String fontBDoubleWidth = "\u001b\u0011";
    public static final String fontADoubleHeightAndWidth = "\u001b\u0012";
    public static final String fontBDoubleHeightAndWidth = "\u001b\u0013";
    public static final String sourceSlipPrinter = "\u001b\u0014";
    public static final String sourcePaperRollPrinter = "\u001b\u0015";
    public static final String upsideDownOn = "\u001b\u0016";
    public static final String upsideDownOff = "\u001b\u0017";
    public static final String pageMode = "\u001b\u0018";
    public static final String standardMode = "\u001b\u0019";
    public static final String enterUserSettingMode = "\u001b\u001a";
    public static final String endUserSettingMode = "\u001b\u001c";
    public static final String set2ClrModeOff = "\u001b\u001d";
    public static final String set2ClrModeOn = "\u001b\u001e";
    public static final String setClrBlack = "\u001b\u001f";
    public static final String setClrRed = "\u001b ";
    public static final String setPaperSize82_5 = "\u001b!";
    public static final String printImage = "\u001b#";
    public static final String languageEnglish = "\u001b$";
    public static final String languageThai42 = "\u001b%";
    public static final String languageThai11 = "\u001b&";
    public static final String languageThai13 = "\u001b'";
    public static final String languageThai14 = "\u001b(";
    public static final String languageThai16 = "\u001b)";
    public static final String languageThai17 = "\u001b*";
    public static final String languageThai18 = "\u001b+";
    public static final String lineSpaceDefault = "\u001b,";
    public static final String lineSpace24 = "\u001b-";
    public static final String paperCut = "\u001b.";
    public static final String openDrawer = "\u001b/";
    public static final String fullHorizontalLine = "________________________________________________________\n";
    public static final String halfHorizontalLine = "___________________________________\n";
    private StringBuffer sbThaiBuffer = new StringBuffer();
    private int nPrintLineWidth = 56;
    private Vector<String> vPrinterCommands = new Vector();
    private Vector<String> vUserCommands = new Vector();
    private FileOutputStream fw;
    private OutputStreamWriter outStream;
    private Language language;
    private static final String CODE_PAGE_US_EUROPE = "Cp437";
    private static final String CODE_PAGE_THAI = "Cp874";
    private static final String CODE_PAGE_NORDIC = "Cp865";

    public PrintReceipt(String sPort, String sFont) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (sFont.length() > 0 && sFont.startsWith("1B")) {
            for (int i = 0; i < sFont.length(); i += 2) {
                sb.append((char)Byte.decode("0x" + sFont.substring(i, i + 2)).intValue());
            }
        }
        this.language = sFont.equals("1B7415") ? Language.THAI : (sFont.equals("1B7405") ? Language.NORDIC : (sFont.equals("JAPANESE") ? Language.JAPANESE : Language.DEFAULT));
        this.loadPrintCommands();
        this.fw = new FileOutputStream(sPort);
        if (this.language == Language.THAI) {
            this.outStream = new OutputStreamWriter((OutputStream)this.fw, CODE_PAGE_THAI);
            this.outStream.write(sb.toString());
        } else if (this.language == Language.NORDIC) {
            this.outStream = new OutputStreamWriter((OutputStream)this.fw, CODE_PAGE_NORDIC);
            this.outStream.write(sb.toString());
        } else if (this.language == Language.JAPANESE) {
            this.outStream = new OutputStreamWriter((OutputStream)this.fw, "Shift_JIS");
            this.outStream.write("\u001bR\b");
            this.outStream.write("\u001cC\u0001");
        } else {
            this.outStream = new OutputStreamWriter((OutputStream)this.fw, CODE_PAGE_US_EUROPE);
            this.outStream.write(this.getPrintCommand(languageEnglish));
        }
    }

    @Override
    public void close() {
        if (this.outStream != null) {
            try {
                this.outStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.outStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outStream = null;
        }
        if (this.fw != null) {
            try {
                this.fw.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.fw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fw = null;
        }
    }

    private void loadPrintCommands() {
        this.vUserCommands.add(jLeft);
        this.vUserCommands.add(jCentre);
        this.vUserCommands.add(jRight);
        this.vPrinterCommands.add("\u001ba\u0000");
        this.vPrinterCommands.add("\u001ba\u0001");
        this.vPrinterCommands.add("\u001ba\u0002");
        this.vUserCommands.add(fontANormal);
        this.vUserCommands.add(fontBNormal);
        this.vUserCommands.add(fontABold);
        this.vUserCommands.add(fontBBold);
        this.vUserCommands.add(fontAUnderline);
        this.vUserCommands.add(fontBUnderline);
        this.vUserCommands.add(fontABoldUnderline);
        this.vUserCommands.add(fontBBoldUnderline);
        this.vUserCommands.add(fontADoubleHeight);
        this.vUserCommands.add(fontBDoubleHeight);
        this.vUserCommands.add(fontADoubleWidth);
        this.vUserCommands.add(fontBDoubleWidth);
        this.vUserCommands.add(fontADoubleHeightAndWidth);
        this.vUserCommands.add(fontBDoubleHeightAndWidth);
        this.vPrinterCommands.add("\u001b!\u0000");
        this.vPrinterCommands.add("\u001b!\u0001");
        this.vPrinterCommands.add("\u001b!\b");
        this.vPrinterCommands.add("\u001b!\t");
        this.vPrinterCommands.add("\u001b!\u0080");
        this.vPrinterCommands.add("\u001b!\u0081");
        this.vPrinterCommands.add("\u001b!\u0088");
        this.vPrinterCommands.add("\u001b!\u0089");
        this.vPrinterCommands.add("\u001b!\u0010");
        this.vPrinterCommands.add("\u001b!\u0011");
        this.vPrinterCommands.add("\u001b! ");
        this.vPrinterCommands.add("\u001b!!");
        this.vPrinterCommands.add("\u001b!0");
        this.vPrinterCommands.add("\u001b!1");
        this.vUserCommands.add(sourceSlipPrinter);
        this.vUserCommands.add(sourcePaperRollPrinter);
        this.vPrinterCommands.add("\u001bc0\u0004\u001bc40");
        this.vPrinterCommands.add("\u001bc0\u0001\u001bc4\u0004");
        this.vUserCommands.add(upsideDownOn);
        this.vUserCommands.add(upsideDownOff);
        this.vPrinterCommands.add("\u001b{\u0001");
        this.vPrinterCommands.add("\u001b{\u0000");
        this.vUserCommands.add(pageMode);
        this.vUserCommands.add(standardMode);
        this.vPrinterCommands.add("\u001bL");
        this.vPrinterCommands.add("\u001bS");
        this.vUserCommands.add(enterUserSettingMode);
        this.vUserCommands.add(endUserSettingMode);
        this.vUserCommands.add(set2ClrModeOff);
        this.vUserCommands.add(set2ClrModeOn);
        this.vUserCommands.add(setClrBlack);
        this.vUserCommands.add(setClrRed);
        this.vUserCommands.add(setPaperSize82_5);
        this.vUserCommands.add(printImage);
        this.vPrinterCommands.add("\u001d(E\u0003\u0000\u0001IN");
        this.vPrinterCommands.add("\u001d(E\u0004\u0000\u0002OUT");
        this.vPrinterCommands.add("\u001d(E\u0004\u0000\u0005t\u0001\u0000");
        this.vPrinterCommands.add("\u001d(E\u0004\u0000\u0005t\u0001\u0001");
        this.vPrinterCommands.add("\u001d(N\u0002\u000001");
        this.vPrinterCommands.add("\u001d(N\u0002\u000002");
        this.vPrinterCommands.add("\u001d(E\u0004\u0000\u0005\u0003\u0006\u0000");
        this.vPrinterCommands.add("\u001cp\u0001\u0000");
        this.vUserCommands.add(languageEnglish);
        this.vUserCommands.add(languageThai42);
        this.vUserCommands.add(languageThai11);
        this.vUserCommands.add(languageThai13);
        this.vUserCommands.add(languageThai14);
        this.vUserCommands.add(languageThai16);
        this.vUserCommands.add(languageThai17);
        this.vUserCommands.add(languageThai18);
        this.vPrinterCommands.add("\u001bt\u0000");
        this.vPrinterCommands.add("\u001bt\u0014");
        this.vPrinterCommands.add("\u001bt\u0015");
        this.vPrinterCommands.add("\u001bt\u0016");
        this.vPrinterCommands.add("\u001bt\u0017");
        this.vPrinterCommands.add("\u001bt\u0018");
        this.vPrinterCommands.add("\u001bt\u0019");
        this.vPrinterCommands.add("\u001bt\u001a");
        this.vUserCommands.add(lineSpaceDefault);
        this.vUserCommands.add(lineSpace24);
        this.vPrinterCommands.add("\u001b2");
        this.vPrinterCommands.add("\u001b3\u0018");
        this.vUserCommands.add(paperCut);
        this.vPrinterCommands.add("\u001bi");
        this.vUserCommands.add(openDrawer);
        this.vPrinterCommands.add("\u001bp\u0000\u0019\u00ff");
    }

    private String getPrintCommand(String sCommand) {
        try {
            int nIndex = this.vUserCommands.indexOf(sCommand);
            if (nIndex > -1) {
                if (sCommand.equals(fontABold) || sCommand.equals(fontABoldUnderline) || sCommand.equals(fontADoubleHeight) || sCommand.equals(fontANormal) || sCommand.equals(fontAUnderline)) {
                    this.nPrintLineWidth = 42;
                } else if (sCommand.equals(fontBBold) || sCommand.equals(fontBBoldUnderline) || sCommand.equals(fontBDoubleHeight) || sCommand.equals(fontBNormal) || sCommand.equals(fontBUnderline)) {
                    this.nPrintLineWidth = 56;
                } else if (sCommand.equals(fontADoubleWidth) || sCommand.equals(fontADoubleHeightAndWidth)) {
                    this.nPrintLineWidth = 21;
                } else if (sCommand.equals(fontBDoubleWidth) || sCommand.equals(fontBDoubleHeightAndWidth)) {
                    this.nPrintLineWidth = 28;
                }
                sCommand = this.vPrinterCommands.elementAt(nIndex);
            } else {
                sCommand = "";
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            sCommand = "";
        }
        return sCommand;
    }

    private void setLineWidth(String sCommand) {
        try {
            int nIndex = this.vUserCommands.indexOf(sCommand);
            if (nIndex > -1) {
                if (sCommand.equals(fontABold) || sCommand.equals(fontABoldUnderline) || sCommand.equals(fontADoubleHeight) || sCommand.equals(fontANormal) || sCommand.equals(fontAUnderline)) {
                    this.nPrintLineWidth = 42;
                } else if (sCommand.equals(fontBBold) || sCommand.equals(fontBBoldUnderline) || sCommand.equals(fontBDoubleHeight) || sCommand.equals(fontBNormal) || sCommand.equals(fontBUnderline)) {
                    this.nPrintLineWidth = 56;
                } else if (sCommand.equals(fontADoubleWidth) || sCommand.equals(fontADoubleHeightAndWidth)) {
                    this.nPrintLineWidth = 21;
                } else if (sCommand.equals(fontBDoubleWidth) || sCommand.equals(fontBDoubleHeightAndWidth)) {
                    this.nPrintLineWidth = 28;
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            sCommand = "";
        }
    }

    public int getLineWidth() {
        return this.nPrintLineWidth;
    }

    private String replaceUserCommands(String sText) {
        String sTmp = null;
        try {
            StringBuffer sb = new StringBuffer(sText);
            for (int i = 0; i < sb.length(); ++i) {
                if (!String.valueOf(sb.charAt(i)).equals("\u001b") || (sTmp = this.getPrintCommand("\u001b" + String.valueOf(sb.charAt(i + 1)))) == null || sTmp.equals("")) continue;
                sb.deleteCharAt(i);
                sb.deleteCharAt(i);
                sb.insert(i, sTmp);
                i += sTmp.length() - 1;
            }
            sText = sb.toString();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            sText = "";
        }
        return sText;
    }

    public void FeedAndCut() {
        int numberOfLines = 8;
        if (this.saveSpaceOnDocket) {
            numberOfLines = 4;
        }
        String lines = "";
        for (int i = 0; i < numberOfLines; ++i) {
            lines = lines + "\n";
        }
        try {
            this.PrintString(lines);
            this.outStream.write("\u001bi");
        }
        catch (IOException e) {
            PosUtils.logError(e);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void Feed(int numberOfLines) {
        this.Feed(numberOfLines, DocketFormat.BOTH);
    }

    public void Feed(int numberOfLines, DocketFormat docketFormat) {
        String lines = "";
        for (int i = 0; i < numberOfLines; ++i) {
            lines = lines + "\n";
        }
        this.PrintString(lines, docketFormat);
    }

    public void OpenCashDrawer() {
        try {
            this.outStream.write("\u001bp\u0000\u0019\u00ff");
        }
        catch (IOException e) {
            PosUtils.logError(e);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void PrintString(String sType) {
        this.PrintString(sType, DocketFormat.BOTH);
    }

    public void PrintString(String sType, DocketFormat docketFormat) {
        if (this.saveSpaceOnDocket && docketFormat == DocketFormat.LONG_ONLY || !this.saveSpaceOnDocket && docketFormat == DocketFormat.SHORT_ONLY) {
            return;
        }
        try {
            StringBuffer sb;
            if (sType.length() >= 2 && String.valueOf((sb = new StringBuffer(sType.substring(0, 2))).charAt(0)).equals("\u001b")) {
                this.setLineWidth("\u001b" + String.valueOf(sb.charAt(1)));
            }
            if (this.language == Language.THAI) {
                int nIndex = sType.indexOf("\n");
                while (nIndex != -1) {
                    this.sbThaiBuffer.append(sType.substring(0, nIndex));
                    sType = sType.substring(nIndex + 1, sType.length());
                    this.parseThai(this.sbThaiBuffer.toString());
                    this.sbThaiBuffer.setLength(0);
                    nIndex = sType.indexOf("\n");
                }
                this.sbThaiBuffer.append(sType);
            } else {
                sType = this.replaceUserCommands(sType);
                this.outStream.write(sType);
            }
        }
        catch (IOException e) {
            PosUtils.logError(e);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void PrintCommand(String sType) {
        try {
            this.outStream.write(sType);
        }
        catch (IOException e) {
            PosUtils.logError(e);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void PrintCommentString(String sComment) {
        try {
            List<String> qrTags;
            StringBuffer sb;
            sComment = sComment.replace(';', '\n');
            sComment = Utils.stringReplace(sComment, "<c>", jCentre);
            sComment = Utils.stringReplace(sComment, "<l>", jLeft);
            sComment = Utils.stringReplace(sComment, "<r>", jRight);
            sComment = Utils.stringReplace(sComment, "<1b>", fontABold);
            sComment = Utils.stringReplace(sComment, "<1u>", fontAUnderline);
            sComment = Utils.stringReplace(sComment, "<1n>", fontANormal);
            sComment = Utils.stringReplace(sComment, "<2b>", fontBBold);
            sComment = Utils.stringReplace(sComment, "<2u>", fontBUnderline);
            sComment = Utils.stringReplace(sComment, "<2n>", fontBNormal);
            if (sComment.length() >= 2 && String.valueOf((sb = new StringBuffer(sComment.substring(0, 2))).charAt(0)).equals("\u001b")) {
                this.setLineWidth("\u001b" + String.valueOf(sb.charAt(1)));
            }
            if (!(qrTags = this.getTags(sComment, "qr")).isEmpty()) {
                sComment = this.wordWrapAroundTag(sComment, "qr");
                for (String qrTag : qrTags) {
                    sComment = this.replaceWithQRCommand(sComment, qrTag);
                }
                this.PrintCommand(this.replaceUserCommands(sComment + "\n"));
            } else if (this.language == Language.THAI) {
                this.PrintString(this.FormatCentre(this.wordWrap(jLeft + sComment + jLeft, this.nPrintLineWidth), this.nPrintLineWidth));
            } else {
                this.PrintString(this.wordWrap(jCentre + sComment + jLeft + "\n", this.nPrintLineWidth));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private String wordWrapAroundTag(String comment, String tag) {
        String[] parts;
        Pattern pattern = Pattern.compile("<" + tag + "(:.*)>", 2);
        for (String part : parts = pattern.split(comment)) {
            if (StringUtils.isNullOrEmpty(part)) continue;
            comment = comment.replace(part, this.wordWrap(jCentre + part + jLeft, this.nPrintLineWidth));
        }
        return comment;
    }

    public String GetQRCommands(String qrText, int moduleSize) {
        StringBuilder builder = new StringBuilder();
        int qrTextLength = qrText.length();
        if (qrTextLength > 124) {
            qrText = qrText.substring(0, 124);
            qrTextLength = 124;
        }
        qrTextLength += 3;
        if (!StringUtils.isNullOrEmpty(qrText)) {
            builder.append(jCentre);
            builder.append(EPSON_qrCodeCommand65);
            builder.append(Utils.stringReplace(EPSON_qrCodeCommand67, ":size", Character.toString((char)moduleSize)));
            builder.append(EPSON_qrCodeCommand69);
            builder.append(Utils.stringReplace(EPSON_qrCodeCommand80, ":length", Character.toString((char)qrTextLength)));
            builder.append(qrText);
            builder.append(EPSON_qrCodeCommand81);
            builder.append(jLeft);
        }
        return builder.toString();
    }

    public void PrintBarcode(String barcodeType, String barcodeNumber, String sFont, boolean bHumanReadable) {
        sFont = sFont.equals("A") ? EPSON_barUPC_A : (sFont.equals("B") ? EPSON_barUPC_B : EPSON_barUPC_A);
        String sReadableFormat = bHumanReadable ? EPSON_barEAN13 : EPSON_barUPC_A;
        try {
            this.outStream.write(this.getPrintCommand(jCentre));
            this.outStream.write("\u001dH" + sReadableFormat);
            this.outStream.write("\u001df" + sFont);
            this.outStream.write("\u001dh0");
            this.outStream.write("\u001dw\u0002");
            this.outStream.write("\u001dk" + barcodeType + barcodeNumber + EPSON_barUPC_A);
            this.outStream.write(this.getPrintCommand(jLeft));
        }
        catch (IOException e) {
            PosUtils.logError(e);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public String wordWrap(String sText, int nLineWidth) {
        StringBuffer sbText = new StringBuffer(sText);
        int nLastSpace = -1;
        int nLineStart = 0;
        int nTmpLineWidth = nLineWidth;
        for (int i = 0; i < sbText.length(); ++i) {
            if (sbText.charAt(i) == ' ') {
                nLastSpace = i;
            }
            if (sbText.charAt(i) == '\n') {
                nLastSpace = -1;
                nLineStart = i + 1;
                nTmpLineWidth = nLineWidth;
            }
            if (String.valueOf(sbText.charAt(i)).equals("\u001b")) {
                nTmpLineWidth += 2;
                ++i;
            } else if (this.language == Language.THAI && this.getThaiCharLevel(sbText.charAt(i)) != 3) {
                ++nTmpLineWidth;
            }
            if (i <= nLineStart + nTmpLineWidth - 2) continue;
            if (nLastSpace != -1) {
                sbText.setCharAt(nLastSpace, '\n');
                nLineStart = nLastSpace + 1;
                nLastSpace = -1;
                i = nLineStart - 1;
            } else {
                sbText.insert(i, '-');
                sbText.insert(i + 1, '\n');
                nLineStart = i + 1;
            }
            nTmpLineWidth = nLineWidth;
        }
        return sbText.toString();
    }

    private void addSpacesIfInvalid(StringBuffer sbWhole) {
        int nCharLevel = 0;
        boolean bFoundBase = false;
        block5: for (int i = 0; i < sbWhole.length() && !bFoundBase; ++i) {
            nCharLevel = this.getThaiCharLevel(sbWhole.charAt(i));
            switch (nCharLevel) {
                case 1: {
                    sbWhole.insert(i, ' ');
                    ++i;
                    continue block5;
                }
                case 2: {
                    sbWhole.insert(i, ' ');
                    ++i;
                    continue block5;
                }
                case 4: {
                    sbWhole.insert(i, ' ');
                    ++i;
                    continue block5;
                }
                default: {
                    bFoundBase = true;
                }
            }
        }
    }

    public void parseThai(String sText) {
        if (sText == null) {
            return;
        }
        StringBuffer sbWhole = new StringBuffer(sText);
        StringBuffer sbTop = new StringBuffer();
        StringBuffer sbAbove = new StringBuffer();
        StringBuffer sbBase = new StringBuffer();
        StringBuffer sbBelow = new StringBuffer();
        this.addSpacesIfInvalid(sbWhole);
        boolean bPrintTop = false;
        boolean bPrintAbove = false;
        boolean bPrintBelow = false;
        int nCharLevel = 0;
        double nLineNum = 0.0;
        int i = 0;
        char c = ' ';
        String sTmp = null;
        boolean bJustAddedPrintCommand = false;
        try {
            while (i < sbWhole.length()) {
                bJustAddedPrintCommand = false;
                if (nLineNum >= 1.0 || sbWhole.charAt(i) == '\n') {
                    this.outStream.write(this.getPrintCommand(lineSpace24));
                    if (bPrintTop) {
                        this.outStream.write(sbTop.toString() + "\n");
                    }
                    if (bPrintAbove) {
                        this.outStream.write(sbAbove.toString() + "\n");
                    }
                    if (!bPrintBelow) {
                        this.outStream.write(this.getPrintCommand(lineSpaceDefault));
                    }
                    this.outStream.write(sbBase.toString() + "\n");
                    if (bPrintBelow) {
                        this.outStream.write(this.getPrintCommand(lineSpaceDefault));
                        this.outStream.write(sbBelow.toString() + "\n");
                    }
                    bPrintTop = false;
                    bPrintAbove = false;
                    bPrintBelow = false;
                    sbTop.setLength(0);
                    sbAbove.setLength(0);
                    sbBase.setLength(0);
                    sbBelow.setLength(0);
                    nLineNum = 0.0;
                }
                if (sbWhole.charAt(i) == '\n') continue;
                if (String.valueOf(sbWhole.charAt(i)).equals("\u001b") && (sTmp = this.getPrintCommand("\u001b" + String.valueOf(sbWhole.charAt(i + 1)))) != null && !sTmp.equals("")) {
                    sbWhole.deleteCharAt(i);
                    sbWhole.deleteCharAt(i);
                    sbTop.append(sTmp);
                    sbAbove.append(sTmp);
                    sbBase.append(sTmp);
                    sbBelow.append(sTmp);
                    bJustAddedPrintCommand = true;
                }
                if (bJustAddedPrintCommand) continue;
                c = sbWhole.charAt(i);
                nCharLevel = this.getThaiCharLevel(c);
                switch (nCharLevel) {
                    case 1: 
                    case 2: {
                        if (sbBase.length() <= 0) break;
                        if (sbAbove.charAt(sbBase.length() - 1) == ' ') {
                            bPrintAbove = true;
                            sbAbove.setCharAt(sbBase.length() - 1, sbWhole.charAt(i));
                            break;
                        }
                        bPrintTop = true;
                        sbTop.setCharAt(sbBase.length() - 1, sbWhole.charAt(i));
                        break;
                    }
                    case 4: {
                        if (sbBase.length() <= 0) break;
                        bPrintBelow = true;
                        sbBelow.setCharAt(sbBase.length() - 1, sbWhole.charAt(i));
                        break;
                    }
                    default: {
                        nLineNum += 1.0 / (double)this.nPrintLineWidth;
                        sbBase.append(sbWhole.charAt(i));
                        sbTop.append(' ');
                        sbAbove.append(' ');
                        sbBelow.append(' ');
                    }
                }
                ++i;
            }
            this.outStream.write(this.getPrintCommand(lineSpace24));
            if (bPrintTop) {
                this.outStream.write(sbTop.toString() + "\n");
            }
            if (bPrintAbove) {
                this.outStream.write(sbAbove.toString() + "\n");
            }
            if (!bPrintBelow) {
                this.outStream.write(this.getPrintCommand(lineSpaceDefault));
            }
            this.outStream.write(sbBase.toString() + "\n");
            if (bPrintBelow) {
                this.outStream.write(this.getPrintCommand(lineSpaceDefault));
                this.outStream.write(sbBelow.toString() + "\n");
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public int getThaiCharLevel(char c) {
        if (c == '\u0e48' || c == '\u0e49' || c == '\u0e4a' || c == '\u0e4b' || c == '\u0e4d' || c == '\u0e4c' || c == '\u0e47') {
            return 1;
        }
        if (c == '\u0e4e' || c == '\u0e34' || c == '\u0e31' || c == '\u0e36' || c == '\u0e35' || c == '\u0e37') {
            return 2;
        }
        if (c == '\u0e38' || c == '\u0e39' || c == '\u0e3a') {
            return 4;
        }
        return 3;
    }

    public boolean thaiDemoteTopLine(StringBuffer sbTop, StringBuffer sbAbove) {
        boolean bPrintTop = false;
        for (int i = 0; i < sbTop.length(); ++i) {
            if (sbTop.charAt(i) == ' ') continue;
            if (sbAbove.charAt(i) == ' ') {
                sbAbove.setCharAt(i, sbTop.charAt(i));
                sbTop.setCharAt(i, ' ');
                continue;
            }
            bPrintTop = true;
        }
        return bPrintTop;
    }

    public String FormatLeft(String s, int pad) {
        int length;
        pad = this.getPadding(s, pad);
        if (s == null) {
            s = "";
        }
        if ((length = s.length()) > pad) {
            s = s.substring(0, pad);
        } else {
            for (int count = length; count < pad; ++count) {
                s = s + " ";
            }
        }
        return s;
    }

    public String FormatRight(String s, int pad) {
        int length;
        pad = this.getPadding(s, pad);
        if (s == null) {
            s = "";
        }
        if ((length = s.length()) > pad) {
            s = s.substring(0, pad);
        } else {
            for (int count = length; count < pad; ++count) {
                s = " " + s;
            }
        }
        return s;
    }

    public String FormatCentre(String s, int pad) {
        String sTmp = null;
        int nTmp = 0;
        Vector<String> v = new Vector<String>();
        Utils.stringTokenize(s, "\n", v);
        s = "";
        for (int i = 0; i < v.size(); ++i) {
            sTmp = v.elementAt(i);
            nTmp = pad;
            if (sTmp == null) {
                sTmp = "";
            }
            nTmp = this.getPadding(sTmp, nTmp);
            int length = sTmp.length();
            if (length > nTmp) {
                sTmp = sTmp.substring(0, nTmp);
            } else {
                for (int count = length; count < nTmp; count += 2) {
                    sTmp = " " + sTmp;
                }
            }
            s = s + sTmp + "\n";
        }
        return s;
    }

    private int getPadding(String s, int pad) {
        if (s != null && !s.equals("")) {
            StringBuffer sb = new StringBuffer(s);
            int baseCnt = 0;
            int addSpace = 0;
            for (int n = 0; n < sb.length(); ++n) {
                if (String.valueOf(sb.charAt(n)).equals("\u001b")) {
                    addSpace += 2;
                    ++n;
                    continue;
                }
                if (this.language != Language.THAI) continue;
                if (this.getThaiCharLevel(sb.charAt(n)) == 3) {
                    ++baseCnt;
                } else {
                    ++addSpace;
                }
                if (baseCnt <= pad) continue;
                return n;
            }
            return addSpace + pad;
        }
        return pad;
    }

    public String FormatDetailHdr(String docket, String salesRep, String dateTime) {
        return this.FormatDetailHdr(docket, salesRep, null, dateTime);
    }

    public String FormatDetailHdr(String docket, String salesRep, String invoiceNum, String dateTime) {
        docket = Gen.NVLString(invoiceNum, "").equals("") ? this.FormatLeft(docket, 21) : this.FormatLeft(docket, 15);
        salesRep = this.FormatLeft(salesRep, 12);
        invoiceNum = Gen.NVLString(invoiceNum, "").equals("") ? this.FormatLeft(invoiceNum, 4) : this.FormatLeft(invoiceNum, 10);
        dateTime = this.FormatRight(dateTime, 19);
        return docket + salesRep + invoiceNum + dateTime;
    }

    public String translateCommand(String sEscChar) {
        String sCommandStr = "";
        return sCommandStr;
    }

    public String repeatChar(char c, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private String getTagText(String dataWithTag, String tag) {
        Pattern pattern = Pattern.compile("<" + tag + ":(.*)>", 2);
        String matchData = "";
        Matcher matcher = pattern.matcher(dataWithTag);
        if (matcher.find()) {
            matchData = matcher.group(1);
        }
        return matchData;
    }

    private List<String> getTags(String text, String tag) {
        Pattern pattern = Pattern.compile("<" + tag + "(:.*)>", 2);
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            if (StringUtils.isNullOrEmpty(matcher.group(0))) continue;
            matches.add(matcher.group(0));
        }
        return matches;
    }

    private String replaceWithQRCommand(String comment, String qrDataWithTag) {
        String commands = "";
        String url = this.getTagText(qrDataWithTag, "qr");
        if (!StringUtils.isNullOrEmpty(url)) {
            commands = this.GetQRCommands(url, 6);
        }
        return comment.replace(qrDataWithTag, commands);
    }

    private static enum Language {
        DEFAULT,
        THAI,
        NORDIC,
        JAPANESE;

    }

    public static enum DocketFormat {
        LONG_ONLY,
        SHORT_ONLY,
        BOTH;

    }
}

