/*
 * Decompiled with CFR 0.152.
 */
package ReceiptPrinter;

import ReceiptPrinter.Gen;
import ReceiptPrinter.IOErrorHandler;
import ReceiptPrinter.StoreDetails;
import ReceiptPrinter.ThreadReceipt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.Connection;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jpos.DlgMessage;
import jpos.PosUtils;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.User;
import jpos.ui.LabelSubHeading;
import org.jdom.Element;

public class Receipt
extends JDialog
implements AutoCloseable {
    private JPanel panel = new JPanel();
    private LabelSubHeading lText = new LabelSubHeading(){

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 100);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(400, 100);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(400, 100);
        }
    };
    private long nTransIdx = 0L;
    private Connection con;
    private String sDocNum = null;
    private String sTitle = null;
    private BorderLayout borderLayout = new BorderLayout();
    private long nOwnerWidx = 0L;
    private long nPrinterTimeout;
    private boolean reprint;
    private boolean printCustAddr = false;
    private User printedByUser = null;

    public Receipt(JDialog parent, String title, boolean modal, Connection con, long nTrIdx, boolean preprint) {
        super(parent, title, modal);
        this.commonConstruct(title, con, nTrIdx, 0L, preprint);
    }

    public Receipt(Frame parent, String title, boolean modal, Connection con, long nTrIdx, boolean preprint) {
        super(parent, title, modal);
        this.commonConstruct(title, con, nTrIdx, 0L, preprint);
    }

    public Receipt(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.sTitle = title;
        this.nPrinterTimeout = PosUtils.longVal(StoreDetails.getString("timeout"));
        try {
            this.jbInit();
            this.validate();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public Receipt(Frame parent, String title, boolean modal, Connection con, long nTrIdx, long ownerWidx, boolean preprint) {
        super(parent, title, modal);
        this.commonConstruct(title, con, nTrIdx, ownerWidx, preprint);
    }

    public Receipt(JDialog parent, String title, boolean modal, Connection con, long nTrIdx, long ownerWidx, boolean preprint) {
        super(parent, title, modal);
        this.commonConstruct(title, con, nTrIdx, ownerWidx, preprint);
    }

    public void setPrintCustAddr(boolean printCustAddr) {
        this.printCustAddr = printCustAddr;
    }

    public void setPrintedByUser(User printedByUser) {
        this.printedByUser = printedByUser;
    }

    private void commonConstruct(String title, Connection con, long nTrIdx, long nOwnerWidx, boolean preprint) {
        this.sTitle = title;
        this.con = con;
        this.nTransIdx = nTrIdx;
        this.reprint = preprint;
        this.nOwnerWidx = nOwnerWidx;
        this.nPrinterTimeout = PosUtils.longVal(StoreDetails.getString("timeout"));
        try {
            this.getDetails();
            this.jbInit();
            this.validate();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    private void jbInit() throws Exception {
        this.panel.setLayout(this.borderLayout);
        this.panel.setMinimumSize(new Dimension(400, 100));
        this.lText.setHorizontalTextPosition(0);
        this.lText.setHorizontalAlignment(0);
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.lText, "West");
        this.setSize(400, 100);
        PosUtils.centreWindow(this);
    }

    private void getDetails() {
        try (SqlQuery sql = new SqlQuery(this.con, "SELECT W.STORENO, H.DOCKET_NUMBER, H.TR_TYPE FROM RET_TRANH H, WHSE W WHERE W.WIDX = H.WIDX AND H.\"ACTIVE\" = 1 AND H.VHIDX = " + this.nTransIdx);){
            if (sql.next()) {
                this.sDocNum = "D" + sql.getString(1) + sql.getString(2);
            } else {
                this.sDocNum = "";
                this.nTransIdx = 0L;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private boolean callThread(Gen.DocketType receiptType, String sTitle, Element element, long vshidx, String sText) {
        boolean wasVisible = this.isVisible();
        if (!wasVisible) {
            this.setVisible(true);
        }
        this.paint(this.getGraphics());
        this.lText.setText(sTitle);
        this.lText.paint(this.lText.getGraphics());
        IOErrorHandler errorHandler = new IOErrorHandler();
        boolean bResult = true;
        ThreadReceipt r = new ThreadReceipt(this.con, this.nTransIdx, this.nOwnerWidx, this.reprint, errorHandler);
        r.setParams(receiptType, element, vshidx, sText, this.printCustAddr, this.printedByUser);
        r.setDaemon(true);
        r.start();
        try {
            r.join(this.nPrinterTimeout * 1000L);
        }
        catch (InterruptedException e) {
            PosUtils.logError(e);
        }
        if (r.isAlive()) {
            DlgMessage.showMessage(this, StoreParams.res.getString("Error_printing_message"), StoreParams.res.getString("Error_printing"), 0);
            bResult = false;
        } else if (errorHandler.isError()) {
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("error_creating_receipt_new"), "\n", errorHandler.getErrorMessage()), StoreParams.res.getString("Error"), 0);
            bResult = false;
        }
        if (!wasVisible) {
            this.setVisible(false);
        }
        return bResult;
    }

    public boolean PrintReservation(Element cust, boolean custCopy) {
        return this.callThread(custCopy ? Gen.DocketType.CUSTRES : Gen.DocketType.STORERES, this.sTitle + " " + this.sDocNum, cust, 0L, null);
    }

    public boolean PrintSale(Element cust) {
        return this.callThread(Gen.DocketType.SALE, this.sTitle + " " + this.sDocNum, cust, 0L, null);
    }

    public boolean PrintGiftPurchDoc(Element cust) {
        return this.callThread(Gen.DocketType.GIFT_PURCHASE_DOCKET, this.sTitle + " " + this.sDocNum, cust, 0L, null);
    }

    public boolean PrintLayBy(Element root) {
        return this.callThread(Gen.DocketType.LAYBY, this.sTitle + " " + this.sDocNum, root, 0L, null);
    }

    public boolean PrintSpecialOrder(Element root) {
        return this.callThread(Gen.DocketType.SPECIAL_ORDER, this.sTitle + " " + this.sDocNum, root, 0L, null);
    }

    public boolean PrintCustOrder(Element root) {
        return this.callThread(Gen.DocketType.CUST_ORDER, this.sTitle + " " + this.sDocNum, root, 0L, null);
    }

    public boolean PrintTransferIn() {
        return this.callThread(Gen.DocketType.TRANSFER_IN, this.sTitle + " " + this.sDocNum, null, 0L, null);
    }

    public boolean PrintTransferOut() {
        return this.callThread(Gen.DocketType.TRANSFER_OUT, this.sTitle + " " + this.sDocNum, null, 0L, null);
    }

    public boolean PrintStkTakeLocn(long vshidx) {
        return this.callThread(Gen.DocketType.STOCKTAKE, this.sTitle, null, vshidx, null);
    }

    public boolean PrintWithDrawal() {
        return this.callThread(Gen.DocketType.WITHDRAWAL, this.sTitle + " " + this.sDocNum, null, 0L, null);
    }

    public boolean PrintExpense() {
        return this.callThread(Gen.DocketType.EXPENSE, this.sTitle + " " + this.sDocNum, null, 0L, null);
    }

    public boolean printTransferChecklist(Element root) {
        return this.callThread(Gen.DocketType.TRANSFER_CHECKLIST, this.sTitle + " " + this.sDocNum, root, 0L, null);
    }

    public boolean printCustOrderPicklist(Element root) {
        return this.callThread(Gen.DocketType.CUST_ORDER_PICKLIST, this.sTitle, root, 0L, null);
    }

    public boolean PrintOpenTillDocket() {
        return this.callThread(Gen.DocketType.OPEN_TILL_DOCKET, this.sTitle, null, 0L, null);
    }

    public boolean printText(String sText) {
        return this.callThread(Gen.DocketType.PRINT_TEXT, this.sTitle, null, 0L, sText);
    }

    public boolean PrintStockReceiptUnexpected() {
        return this.callThread(Gen.DocketType.STOCK_RECEIPT_UNEXPECTED, this.sTitle + " " + this.sDocNum, null, 0L, null);
    }

    public boolean isValidReceipt() {
        return this.nTransIdx != 0L;
    }
}

