/*
 * Decompiled with CFR 0.152.
 */
package ReceiptPrinter;

import ReceiptPrinter.Comments;
import ReceiptPrinter.Detail;
import ReceiptPrinter.Disc;
import ReceiptPrinter.Gen;
import ReceiptPrinter.IOErrorHandler;
import ReceiptPrinter.PhNums;
import ReceiptPrinter.PrintReceipt;
import ReceiptPrinter.RcptTen;
import ReceiptPrinter.StoreDetails;
import ReceiptPrinter.Trans;
import ReceiptPrinter.Warehouse;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jpos.Note;
import jpos.PosDateFormatter;
import jpos.PosUtils;
import jpos.Promotions.PromotionUtils;
import jpos.Reference;
import jpos.SP;
import jpos.Security;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.User;
import jpos.XMLUtils;
import jpos.basscom.utils.PeriodCalc;
import jpos.basscom.utils.Utils;
import jpos.custorder.DeliveryInfo;
import jpos.pay.PayType;
import jpos.pay.PayTypes;
import jpos.pay.PayUtils;
import jpos.stockreceipt.Carton;
import jpos.stockreceipt.CartonItem;
import jpos.stockreceipt.NonASNTransaction;
import jpos.stockreceipt.TransactionItem;
import jpos.voucher.IVoucherGateway;
import jpos.voucher.VoucherGatewayManager;
import jpos.voucher.VoucherLoadAdapter;
import jpos.voucher.VoucherType;
import jpos.voucher.VoucherUtils;
import jpos.voucher.vii.ViiGateway;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class ThreadReceipt
extends Thread {
    private long nTransIdx = 0L;
    private Connection conn = null;
    private String sDocNum = null;
    private String sTillNum = null;
    private String sTillNumText = null;
    private long nTrType = -1L;
    private String sStoreNum = null;
    private String servedByJoin = "H.TRANSSREPIDX";
    private boolean floorToDoor = false;
    private String sPerIdx = null;
    private long nOwnerWidx = 0L;
    private Reference pointsPartner = null;
    private String pointsPartnerNumber = null;
    private String sCreditNoteNum = null;
    private String sTransferNum = null;
    private String sPrinterPort = null;
    private String sPrinterFont = null;
    private String sImagePath = null;
    private boolean bSaleHasACreditNote = false;
    private boolean bPrintPromoVoucher = false;
    private boolean bSaleHasCredNoteGiftVouch = false;
    private Comments comments;
    private DecimalFormat dfQty;
    private DecimalFormat dfDet;
    private DecimalFormat dfTot;
    private int nPrec;
    private boolean reprint;
    private boolean origReprintValue;
    private String sEftDocket = "";
    private PayUtils.ReceiptDeliveryMethod deliveryMethod = PayUtils.ReceiptDeliveryMethod.PRINT_ONLY;
    private int maxProdCodeLen;
    private int maxProdDescriptLen;
    private Gen.DocketType param_docketType;
    private Element param_element = null;
    private long param_vshidx = 0L;
    private String param_text = null;
    private boolean printCustAddr = false;
    private User printedByUser = null;
    private final String TAX_ID = "*";
    public boolean bLargeFontForTotals = false;
    public boolean bPrintTillName = false;
    private boolean bPrintTotUnits = false;
    private boolean bPrintDiscountPercent = false;
    private boolean bUsingExtTax = StoreDetails.getString("ext_tax").equals("1");
    private boolean showTaxRate = !StoreDetails.getString("tax_lookup").equals("1");
    private long nRetTrType = -1L;
    private boolean bPrintCapillaryPoints = false;
    private IOErrorHandler errorHandler;

    public ThreadReceipt(Connection conn, long nTrIdx, long ownerWidx, boolean preprint, IOErrorHandler errorHandler) {
        this.conn = conn;
        this.nTransIdx = nTrIdx;
        this.reprint = preprint;
        this.origReprintValue = preprint;
        this.errorHandler = errorHandler;
        this.nOwnerWidx = ownerWidx;
        this.commonConstruct();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void resetReprint() {
        this.reprint = this.origReprintValue;
    }

    public void setParams(Gen.DocketType docketType, Element element, long vshidx, String spText, boolean printCustAddr, User printedByUser) {
        this.param_docketType = docketType;
        this.param_element = element;
        this.param_vshidx = vshidx;
        this.param_text = spText;
        this.printCustAddr = printCustAddr;
        this.printedByUser = printedByUser;
    }

    @Override
    public void run() {
        try {
            switch (this.param_docketType) {
                case SALE: {
                    this.printSale(this.param_element, false);
                    break;
                }
                case LAYBY: {
                    this.printLayBy(this.param_element);
                    break;
                }
                case TRANSFER_IN: {
                    this.printTransferIn(false);
                    break;
                }
                case TRANSFER_OUT: {
                    this.printTransferOut(false);
                    break;
                }
                case STOCKTAKE: {
                    this.printStkTakeLocn(this.param_vshidx);
                    break;
                }
                case WITHDRAWAL: {
                    this.printWithDrawal();
                    break;
                }
                case EXPENSE: {
                    this.printExpense();
                    break;
                }
                case CUSTRES: {
                    this.printReservation(this.param_element, true);
                    break;
                }
                case STORERES: {
                    this.printReservation(this.param_element, false);
                    break;
                }
                case GIFT_PURCHASE_DOCKET: {
                    this.printSale(this.param_element, true);
                    break;
                }
                case TRANSFER_CHECKLIST: {
                    this.printTransferChecklist(this.param_element);
                    break;
                }
                case SPECIAL_ORDER: {
                    this.printSpecialOrder(this.param_element);
                    break;
                }
                case CUST_ORDER: {
                    this.printCustOrder(this.param_element);
                    break;
                }
                case CUST_ORDER_PICKLIST: {
                    this.printCustOrderPickList(this.param_element);
                    break;
                }
                case OPEN_TILL_DOCKET: {
                    this.printOpenTillDocket(this.nTransIdx);
                    break;
                }
                case PRINT_TEXT: {
                    this.printText(this.param_text);
                    break;
                }
                case STOCK_RECEIPT_UNEXPECTED: {
                    this.printTransferIn(true);
                    break;
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void commonConstruct() {
        try {
            DecimalFormatSymbols symbols;
            Gen.populateNumCopies(this.conn);
            StringBuffer sDet = new StringBuffer();
            StringBuffer sTot = new StringBuffer();
            StringBuffer sPrec = new StringBuffer();
            if (this.nOwnerWidx > 0L) {
                Gen.getCurrencyFmt(this.conn, this.nOwnerWidx, sTot, sDet, sPrec);
            } else {
                Gen.getCurrencyFmt(this.conn, sTot, sDet, sPrec);
            }
            this.dfQty = new DecimalFormat("");
            if (this.dfQty.getDecimalFormatSymbols().getGroupingSeparator() == '\u00a0') {
                symbols = this.dfQty.getDecimalFormatSymbols();
                symbols.setGroupingSeparator(' ');
                this.dfQty.setDecimalFormatSymbols(symbols);
            }
            this.dfDet = new DecimalFormat(sDet.toString());
            if (this.dfDet.getDecimalFormatSymbols().getGroupingSeparator() == '\u00a0') {
                symbols = this.dfDet.getDecimalFormatSymbols();
                symbols.setGroupingSeparator(' ');
                this.dfDet.setDecimalFormatSymbols(symbols);
            }
            this.dfTot = new DecimalFormat(sTot.toString());
            if (this.dfTot.getDecimalFormatSymbols().getGroupingSeparator() == '\u00a0') {
                symbols = this.dfTot.getDecimalFormatSymbols();
                symbols.setGroupingSeparator(' ');
                this.dfTot.setDecimalFormatSymbols(symbols);
            }
            this.nPrec = PosUtils.intVal(sPrec.toString());
            this.comments = new Comments(this.conn);
            this.sPrinterPort = StoreDetails.getString("printerport");
            this.sPrinterFont = Gen.NVLString(StoreDetails.getString("printerfont"), "");
            this.sImagePath = StoreDetails.getString("imagepath");
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT MAX(CHARACTER_LENGTH(stylecode)) FROM STYLE");){
                this.maxProdCodeLen = sql.next() ? sql.getInt(1) : 10;
            }
            this.maxProdDescriptLen = 30;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        block110: {
            try {
                Throwable throwable;
                SqlQuery sql;
                this.pointsPartner = null;
                this.pointsPartnerNumber = "";
                this.sTillNumText = StoreParams.res.getString("Till_No");
                if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.SHOW_SALES_REP_ON_DOCKET)) {
                    this.servedByJoin = "H.SREPIDX";
                }
                if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.CAPILLARY_LOYALTY_SETUP)) {
                    try {
                        sql = new SqlQuery(this.conn, "SELECT CLIENTIDX, CAPILLARY_POINTS_BALANCE FROM RET_TRANH WHERE CAPILLARY_POINTS_BALANCE IS NOT NULL AND VHIDX = " + this.nTransIdx);
                        throwable = null;
                        try {
                            if (sql.next()) {
                                String clientIdx = sql.getString("CLIENTIDX");
                                double currentBalance = sql.getDouble("CAPILLARY_POINTS_BALANCE");
                                if (clientIdx != null && currentBalance >= 0.0) {
                                    this.bPrintCapillaryPoints = true;
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (sql != null) {
                                if (throwable != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                }
                if (this.nTransIdx != 0L) {
                    sql = new SqlQuery(this.conn, "SELECT W.STORENO, H.DOCKET_NUMBER, H.TR_TYPE, H.TILL_NUMBER, B.BLOBTEXT, COALESCE(H.DELIVERY_METHOD, 2), H.POINTS_PARTNER_RCIDX, H.POINTS_PARTNER_NUM, H.DEL_METHOD_IDX, CLIENTIDX FROM RET_TRANH H LEFT JOIN BLOBTEXT B ON H.EFTPOS_BLOBIDX = B.BLOBIDX, WHSE W WHERE W.WIDX = H.WIDX AND H.\"ACTIVE\" = 1 AND H.VHIDX = " + this.nTransIdx + " ");
                    throwable = null;
                    try {
                        if (sql.next()) {
                            this.sDocNum = "D" + sql.getString(1) + sql.getString(2);
                            this.sStoreNum = sql.getString(1);
                            this.nTrType = sql.getLong(3);
                            this.sTillNum = sql.getString(4);
                            this.sEftDocket = Gen.NVLString(sql.getString(5), "");
                            this.deliveryMethod = PayUtils.intToReceiptDeliveryMethod(sql.getInt(6));
                            if (sql.getLong(7) != 0L) {
                                this.pointsPartner = new Reference(sql.getLong(7), true, this.conn);
                                this.pointsPartnerNumber = sql.getString(8);
                            }
                            this.floorToDoor = sql.getLong("DEL_METHOD_IDX") > 0L;
                            this.sPerIdx = sql.getString("CLIENTIDX");
                        } else {
                            this.sDocNum = "";
                            this.sStoreNum = "";
                            this.nTransIdx = 0L;
                            this.sTillNum = "";
                            this.sEftDocket = "";
                            this.sTillNumText = "";
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (sql != null) {
                            if (throwable != null) {
                                try {
                                    sql.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                sql.close();
                            }
                        }
                    }
                    if (this.sDocNum.length() > 0) {
                        sql = new SqlQuery(this.conn, "SELECT B.BLOBTEXT FROM RET_TRANH H, RET_TRANP P LEFT JOIN BLOBTEXT B ON P.EFTPOS_BLOBIDX = B.BLOBIDX, WHSE W WHERE W.WIDX = H.WIDX AND H.\"ACTIVE\" = 1 and P.VHIDX = H.VHIDX AND H.VHIDX = " + this.nTransIdx + " ORDER BY P.SEQUENCE_NUMBER");
                        throwable = null;
                        try {
                            if (sql.next()) {
                                this.sEftDocket = Gen.NVLString(sql.getString(1), "");
                                while (sql.next()) {
                                    if (Gen.NVLString(sql.getString(1), "").length() <= 0) continue;
                                    this.sEftDocket = this.sEftDocket + "\n" + Gen.NVLString(sql.getString(1), "");
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (sql != null) {
                                if (throwable != null) {
                                    try {
                                        sql.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable.addSuppressed(throwable7);
                                    }
                                } else {
                                    sql.close();
                                }
                            }
                        }
                    }
                    sql = new SqlQuery(this.conn, "SELECT S.LARGE_FONT, S.PRINT_TILLNAME FROM STOREPARAMS S");
                    throwable = null;
                    try {
                        if (sql.next()) {
                            this.bLargeFontForTotals = sql.getBoolean(1);
                            this.bPrintTillName = sql.getBoolean(2);
                            if (!this.bPrintTillName) {
                                this.sTillNum = "";
                                this.sTillNumText = "";
                            }
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (sql != null) {
                            if (throwable != null) {
                                try {
                                    sql.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                            } else {
                                sql.close();
                            }
                        }
                    }
                    sql = new SqlQuery(this.conn, "SELECT COALESCE(PARLNKIDX,0) FROM SYSPARAM WHERE PARIDX = 620");
                    throwable = null;
                    try {
                        if (sql.next()) {
                            this.bPrintTotUnits = sql.getBoolean(1);
                        }
                    }
                    catch (Throwable throwable10) {
                        throwable = throwable10;
                        throw throwable10;
                    }
                    finally {
                        if (sql != null) {
                            if (throwable != null) {
                                try {
                                    sql.close();
                                }
                                catch (Throwable throwable11) {
                                    throwable.addSuppressed(throwable11);
                                }
                            } else {
                                sql.close();
                            }
                        }
                    }
                    sql = new SqlQuery(this.conn, "SELECT COALESCE(PARLNKIDX,0) FROM SYSPARAM WHERE PARIDX = 657");
                    throwable = null;
                    try {
                        if (sql.next()) {
                            this.bPrintDiscountPercent = sql.getBoolean(1);
                        }
                    }
                    catch (Throwable throwable12) {
                        throwable = throwable12;
                        throw throwable12;
                    }
                    finally {
                        if (sql != null) {
                            if (throwable != null) {
                                try {
                                    sql.close();
                                }
                                catch (Throwable throwable13) {
                                    throwable.addSuppressed(throwable13);
                                }
                            } else {
                                sql.close();
                            }
                        }
                    }
                    sql = new SqlQuery(this.conn, "SELECT COALESCE(PARLNKIDX,0) FROM SYSPARAM WHERE PARIDX = 758");
                    throwable = null;
                    try {
                        if (sql.next()) {
                            this.bPrintPromoVoucher = sql.getBoolean(1);
                        }
                        break block110;
                    }
                    catch (Throwable throwable14) {
                        throwable = throwable14;
                        throw throwable14;
                    }
                    finally {
                        if (sql != null) {
                            if (throwable != null) {
                                try {
                                    sql.close();
                                }
                                catch (Throwable throwable15) {
                                    throwable.addSuppressed(throwable15);
                                }
                            } else {
                                sql.close();
                            }
                        }
                    }
                }
                this.sDocNum = "";
                this.sStoreNum = "";
                this.nTransIdx = 0L;
                this.sTillNum = "";
                this.sEftDocket = "";
                this.sTillNumText = "";
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    private boolean printHeader(HeaderType headerType, PrintReceipt r1) {
        String sLocnidx = null;
        String sTradeName = null;
        String sAddress1 = null;
        String sAddress2 = null;
        String sCity = null;
        String sState = null;
        String sPostcode = null;
        String sABN = null;
        String sPhone = null;
        String sFax = null;
        String sEmail = null;
        String sWeb = null;
        String sDocketHdr = null;
        String sLegalComment = null;
        sLocnidx = StoreDetails.getString("linkidx");
        sTradeName = StoreDetails.getString("tradename");
        sAddress1 = StoreDetails.getString("adrs1");
        sAddress2 = StoreDetails.getString("adrs2");
        sCity = StoreDetails.getString("city");
        sState = StoreDetails.getString("state");
        sPostcode = StoreDetails.getString("postcode");
        sABN = StoreDetails.getString("abn");
        if (sABN != null) {
            sABN = StoreParams.res.getString("ABN") + " " + sABN;
        }
        if (sLocnidx != null) {
            PhNums pn = new PhNums(sLocnidx);
            pn.loadPhoneNumbers(this.conn);
            sPhone = pn.getString(154L);
            if (sPhone != null) {
                sPhone = StoreParams.res.getString("Ph_") + " " + sPhone;
            }
            if ((sFax = pn.getString(373L)) != null) {
                sFax = StoreParams.res.getString("Fax") + " " + sFax;
            }
            sEmail = pn.getString(159L);
            sWeb = pn.getString(467L);
        }
        if (headerType != HeaderType.WITHDRAWAL && headerType != HeaderType.EXPENSE) {
            sDocketHdr = this.comments.getString(Comments.DocketTextType.DOCKET_HDR);
        }
        double nTotCost = Gen.getTotalCost(this.nTransIdx, this.conn);
        switch (headerType) {
            case SALE: {
                sLegalComment = nTotCost < 0.0 ? this.comments.getString(Comments.DocketTextType.CREDIT_LEGAL) : this.comments.getString(Comments.DocketTextType.SALE_LEGAL);
                if (this.nTrType != 558L) break;
                sLegalComment = sLegalComment + " " + StoreParams.res.getString("payment");
                break;
            }
            case CREDIT: {
                sLegalComment = this.comments.getString(Comments.DocketTextType.CREDIT_LEGAL);
                break;
            }
            case LAYBY_CUST: {
                sLegalComment = this.comments.getString(Comments.DocketTextType.LAYBY_LEGAL) + "\n" + StoreParams.res.getString("Customer_Copy");
                break;
            }
            case LAYBY_STORE: {
                sLegalComment = this.comments.getString(Comments.DocketTextType.LAYBY_LEGAL) + "\n" + StoreParams.res.getString("Store_Copy");
                break;
            }
            case WITHDRAWAL: {
                sLegalComment = StoreParams.res.getString("Cash_Withdrawal");
                break;
            }
            case EXPENSE: {
                sLegalComment = StoreParams.res.getString("Expense_Detail");
                break;
            }
            case RESERVATION_CUST: {
                sLegalComment = StoreParams.res.getString("Stock_Reservation") + "\n" + StoreParams.res.getString("Customer_Copy");
                break;
            }
            case RESERVATION_STORE: {
                sLegalComment = StoreParams.res.getString("Stock_Reservation") + "\n" + StoreParams.res.getString("Store_Copy");
                break;
            }
            case GIFT_PURCHASE: {
                sLegalComment = StoreParams.res.getString("GIFT_PURCHASE_DOCKET");
                break;
            }
            case SPECIAL_ORDER_CUST: {
                sLegalComment = this.comments.getString(Comments.DocketTextType.SPECIAL_ORDER_LEGAL) + "\n" + StoreParams.res.getString("Customer_Copy");
                break;
            }
            case SPECIAL_ORDER_STORE: {
                sLegalComment = this.comments.getString(Comments.DocketTextType.SPECIAL_ORDER_LEGAL) + "\n" + StoreParams.res.getString("Store_Copy");
                break;
            }
            case CUST_ORDER_CUST: {
                sLegalComment = this.comments.getString(this.floorToDoor ? Comments.DocketTextType.FLOOR_TO_DOOR_LEGAL : Comments.DocketTextType.CUST_ORDER_LEGAL) + "\n" + StoreParams.res.getString("Customer_Copy");
                break;
            }
            case CUST_ORDER_STORE: {
                sLegalComment = this.comments.getString(this.floorToDoor ? Comments.DocketTextType.FLOOR_TO_DOOR_LEGAL : Comments.DocketTextType.CUST_ORDER_LEGAL) + "\n" + StoreParams.res.getString("Store_Copy");
                break;
            }
            case ACCOUNT_PAYMENT: {
                sLegalComment = StoreParams.res.getString("ACCOUNT_PAYMENT_DOCKET");
                break;
            }
            case RETURN_CUST: {
                sLegalComment = nTotCost < 0.0 ? this.comments.getString(Comments.DocketTextType.CREDIT_LEGAL) : this.comments.getString(Comments.DocketTextType.SALE_LEGAL);
                if (this.nTrType == 558L) {
                    sLegalComment = sLegalComment + " " + StoreParams.res.getString("payment");
                }
                sLegalComment = sLegalComment + "\n" + StoreParams.res.getString("Customer_Copy");
                break;
            }
            case RETURN_STORE: {
                sLegalComment = nTotCost < 0.0 ? this.comments.getString(Comments.DocketTextType.CREDIT_LEGAL) : this.comments.getString(Comments.DocketTextType.SALE_LEGAL);
                if (this.nTrType == 558L) {
                    sLegalComment = sLegalComment + " " + StoreParams.res.getString("payment");
                }
                sLegalComment = sLegalComment + "\n" + StoreParams.res.getString("Store_Copy");
                break;
            }
            case PROMO_VOUCHER: {
                sDocketHdr = "";
                sLegalComment = "";
                break;
            }
        }
        r1.PrintString("\u001b\u0001");
        r1.PrintString("\u001b\u0006");
        if (this.reprint) {
            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("REPRINT"), 42));
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        }
        if (sDocketHdr != null && sDocketHdr.length() > 0) {
            r1.PrintCommentString(sDocketHdr);
            r1.PrintString("\u001b\u0001");
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        }
        if (sLegalComment != null && sLegalComment.length() > 0) {
            r1.PrintString("\u001b\u0006");
            r1.PrintCommentString(sLegalComment);
            r1.PrintString("\u001b\u0001");
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        }
        if (sTradeName != null && sTradeName.length() > 0) {
            r1.PrintString("\u001b\u0007");
            r1.PrintString(r1.FormatCentre(sTradeName, 56));
        }
        r1.PrintString("\u001b\u0005");
        if (sAddress1 != null && sAddress1.length() > 0) {
            r1.PrintString(r1.FormatCentre(sAddress1, 56));
        }
        if (sAddress2 != null && sAddress2.length() > 0) {
            r1.PrintString(r1.FormatCentre(sAddress2, 56));
        }
        String sCityStateAndPC = "";
        if (sCity != null && sCity.length() > 0) {
            sCityStateAndPC = sCity;
        }
        if (sState != null && sState.length() > 0) {
            sCityStateAndPC = sCityStateAndPC + (sCityStateAndPC.equals("") ? "" : " ") + sState;
        }
        if (sPostcode != null && sPostcode.length() > 0) {
            sCityStateAndPC = sCityStateAndPC + (sCityStateAndPC.equals("") ? "" : " ") + sPostcode;
        }
        if (sCityStateAndPC.length() > 0) {
            r1.PrintString(r1.FormatCentre(sCityStateAndPC, 56));
        }
        String sSpace = "  ";
        if (sPhone == null || sFax == null || sPhone.length() == 0 || sFax.length() == 0) {
            sSpace = "";
        }
        if (sPhone != null && sPhone.length() > 0 || sFax != null && sFax.length() > 0) {
            r1.PrintString(r1.FormatCentre(Gen.NVLString(sPhone, "") + sSpace + Gen.NVLString(sFax, ""), 56));
        }
        if (sEmail != null && sEmail.length() > 0) {
            r1.PrintString(r1.FormatCentre(sEmail, 56));
        }
        if (sWeb != null && sWeb.length() > 0) {
            r1.PrintString(r1.FormatCentre(sWeb, 56));
        }
        if (sABN != null && sABN.length() > 0) {
            r1.PrintString(r1.FormatCentre(sABN, 56));
        }
        r1.PrintString("\u001b\u0001");
        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
        return true;
    }

    private boolean printFooter(FooterType footerType, PrintReceipt r1) {
        return this.printFooter(footerType, r1, false);
    }

    private boolean printFooter(FooterType footerType, PrintReceipt r1, boolean bGiftPurchDoc) {
        boolean bPrintTaxableItemsBlurb = false;
        boolean bPrintEFTPOS = false;
        String sDocketFtr = null;
        switch (footerType) {
            case SALE: {
                bPrintTaxableItemsBlurb = true;
                bPrintEFTPOS = true;
                sDocketFtr = this.comments.getString(Comments.DocketTextType.DOCKET_FTR);
                break;
            }
            case CREDIT: {
                sDocketFtr = this.comments.getString(Comments.DocketTextType.CREDIT_TERMS);
                break;
            }
            case LAYBY: {
                bPrintTaxableItemsBlurb = true;
                bPrintEFTPOS = true;
                sDocketFtr = this.comments.getString(Comments.DocketTextType.LAYBY_TERMS);
                break;
            }
            case TRANSFER: {
                sDocketFtr = this.comments.getString(Comments.DocketTextType.TRANSFER);
                break;
            }
            case STK_TAKE: {
                sDocketFtr = this.comments.getString(Comments.DocketTextType.STK_TAKE);
                break;
            }
            case RESERVATION: {
                bPrintTaxableItemsBlurb = true;
                sDocketFtr = this.comments.getString(Comments.DocketTextType.RESERVATION);
                break;
            }
            case SPECIAL_ORDER: {
                bPrintTaxableItemsBlurb = true;
                bPrintEFTPOS = true;
                sDocketFtr = this.comments.getString(Comments.DocketTextType.SPECIAL_ORDER_TERMS);
                break;
            }
            case CUST_ORDER: {
                bPrintTaxableItemsBlurb = true;
                bPrintEFTPOS = true;
                sDocketFtr = this.comments.getString(this.floorToDoor ? Comments.DocketTextType.FLOOR_TO_DOOR_TERMS : Comments.DocketTextType.CUST_ORDER_TERMS);
                break;
            }
            case ACCOUNT_PAYMENT: {
                bPrintTaxableItemsBlurb = false;
                bPrintEFTPOS = true;
                sDocketFtr = this.comments.getString(Comments.DocketTextType.DOCKET_FTR);
                break;
            }
        }
        if (bPrintEFTPOS && !bGiftPurchDoc && this.sEftDocket.length() > 0) {
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
            r1.PrintString("\u001b\u0004");
            r1.PrintString(this.sEftDocket);
            r1.PrintString("\u001b\u0005");
            r1.Feed(1);
        }
        if (this.pointsPartner != null && !StringUtils.isNullOrEmpty(this.pointsPartnerNumber)) {
            boolean docketTextOverride = false;
            String docketText = "";
            long idx = this.pointsPartner.getIdx();
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT OVERRIDE_DOCKET_FLAG, OVERRIDE_DOCKET_TEXT FROM POINTS_PARTNER WHERE RCIDX = " + idx);){
                if (sql.next()) {
                    docketTextOverride = sql.getBoolean("OVERRIDE_DOCKET_FLAG");
                    docketText = StringUtils.nullToEmpty(sql.getString("OVERRIDE_DOCKET_TEXT"));
                    docketText = r1.wordWrap(docketText, 56);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
            if (docketTextOverride && !StringUtils.isNullOrEmpty(docketText)) {
                r1.PrintString(docketText + "\n");
            } else {
                r1.PrintString(r1.FormatLeft(SP.getRS("points_partner_number", this.pointsPartner.getName(), this.pointsPartnerNumber), 56) + "\n");
            }
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        }
        if (this.bPrintCapillaryPoints) {
            this.printCapillaryRewardsPointsBalance(r1);
        }
        if (bPrintTaxableItemsBlurb && !this.bUsingExtTax) {
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
            r1.PrintString(r1.FormatCentre("* " + StoreParams.res.getString("REFERS_TO_TAXABLE_ITEMS"), 56));
        }
        r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        if (footerType == FooterType.CREDIT) {
            r1.PrintBarcode("\u0004", this.sCreditNoteNum, "B", false);
            r1.PrintString(r1.FormatCentre(this.sCreditNoteNum, 56));
            if (this.saleHasCredNoteGiftVouch()) {
                String vouchPin = VoucherUtils.getVoucherPin(this.sCreditNoteNum);
                r1.PrintString(r1.FormatCentre("PIN:" + vouchPin, 56));
            }
        } else if (footerType != FooterType.STK_TAKE) {
            r1.PrintBarcode("\u0004", this.sDocNum, "B", false);
            r1.PrintString(r1.FormatCentre(this.sDocNum, 56));
        }
        r1.PrintString("\u001b\u0005");
        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
        String qrText = this.comments.getString(Comments.DocketTextType.QR_CODE_PERSON_SIGNUP);
        if (!StringUtils.isNullOrEmpty(qrText) && StringUtils.isNullOrEmpty(this.sPerIdx)) {
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT SUM(NET) AS TRANS_TOTAL FROM RET_TRAND D WHERE D.\"ACTIVE\" = 1 AND D.VHIDX = " + this.nTransIdx + " ");){
                if (sql.next() && sql.getLong("TRANS_TOTAL") > 0L) {
                    qrText = Utils.stringReplace(qrText, "{docket}", this.sDocNum);
                    r1.PrintString("\u001b\u0001");
                    r1.PrintCommentString(qrText);
                    r1.PrintString("________________________________________________________\n");
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        r1.PrintString("\u001b\u0001");
        if (sDocketFtr != null && sDocketFtr.length() > 0) {
            r1.PrintCommentString(sDocketFtr);
            r1.PrintString("\u001b\u0001");
        }
        if (footerType != FooterType.SALE) {
            r1.FeedAndCut();
        }
        return true;
    }

    private boolean printCapillaryRewardsPointsBalance(PrintReceipt r1) {
        String sqlQuery = "Select COALESCE(H.CAPILLARY_POINTS_BALANCE, 0) AS POINTS_BALANCE, COALESCE(H.CAPILLARY_REDEMPTION_POINTS, 0) AS POINTS_REDEEMED FROM RET_TRANH H WHERE H.VHIDX = " + this.nTransIdx;
        double pointsBalance = 0.0;
        double redeemedPoints = 0.0;
        try (SqlQuery sql = new SqlQuery(this.conn, sqlQuery);){
            if (sql.next()) {
                pointsBalance = sql.getDouble("POINTS_BALANCE");
                redeemedPoints = sql.getDouble("POINTS_REDEEMED");
                r1.PrintString("");
                r1.PrintString(r1.FormatCentre(SP.getRS("Pre_Transaction_Points_Balance", pointsBalance), 56));
                r1.PrintString("");
                r1.PrintString(r1.FormatCentre(SP.getRS("Redeemed_Points", redeemedPoints), 56));
                r1.PrintString(r1.FormatCentre(SP.getRS("Post_Transaction_Points_Balance", pointsBalance - redeemedPoints), 56));
                r1.PrintString(r1.FormatCentre(SP.getRS("End_Transaction_Points_Text"), 56));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean printPromoVoucher(PrintReceipt r1) {
        String sSalesRep = "";
        String sTranDate = "";
        String sDocketNumber = "";
        String sFooter = this.comments.getString(Comments.DocketTextType.PROMO_VOUCHER_FOOTER);
        String sqlQuery = "SELECT H.DOCKET_NUMBER, H.TRAND, COALESCE(P.FIRSTNAME, ''),\r\n\tPV.VoucherNumber, PV.VoucherHeading, PV.moneyValue, PV.VoucherPin, PV.ExpiryDate\r\n\tFROM RET_TRANH H \r\n\tLEFT JOIN PERSON P ON H.TRANSSREPIDX = P.PERIDX\r\n\tLEFT JOIN online_q_promo_voucher_res PV on H.VHIDX = PV.VHIDX\r\n\tWHERE H.ACTIVE = 1 AND H.VHIDX =" + this.nTransIdx;
        try (SqlQuery sql = new SqlQuery(this.conn, sqlQuery);){
            if (sql.next()) {
                sDocketNumber = sql.getString(1);
                if (StringUtils.isNullOrEmpty(sql.getString(4))) {
                    boolean bl = false;
                    return bl;
                }
                PosDateFormatter dateFormatter = new PosDateFormatter(null);
                try {
                    dateFormatter.setFormat(3, 3, 2);
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
                dateFormatter.setTimestamp(sql.getTimestamp(2));
                sTranDate = dateFormatter.toString();
                sSalesRep = sql.getString(3);
                if (!PayUtils.isNonPrint(this.deliveryMethod)) {
                    r1.PrintString("\u001b\u0005");
                    r1.PrintString(r1.FormatCentre("-------------------------------------------------------", 56));
                    r1.Feed(2);
                }
                r1.PrintString("\u001b\u0006");
                r1.PrintString(r1.FormatCentre(sql.getString(5) + "\n", 42));
                r1.Feed(1);
                this.printHeader(HeaderType.PROMO_VOUCHER, r1);
                r1.PrintString("\u001b\u0005");
                r1.PrintString("\u001b\u0001");
                r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Served_By"), this.sTillNumText, StoreParams.res.getString("Date_Time")) + "\n");
                r1.PrintString(r1.FormatDetailHdr(sSalesRep, this.sTillNum, sTranDate) + "\n");
                r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintString("\u001b\u0005");
                r1.PrintString(r1.FormatCentre("Issued with Docket " + sDocketNumber, 56));
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintString("\u001b\u0006");
                r1.PrintString(r1.FormatCentre("Value: " + this.dfTot.format(sql.getDouble(6)), 42));
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintBarcode("\u0004", sql.getString(4), "B", false);
                r1.Feed(1);
                r1.PrintString("\u001b\u0006");
                r1.PrintString(r1.FormatCentre("Voucher number:" + sql.getString(4) + "        PIN " + VoucherUtils.decryptPin(sql.getString(7)), 42));
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintString(r1.FormatCentre("Expires: " + sql.getString(8), 42));
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                if (StringUtils.isNullOrEmpty(sFooter)) return true;
                r1.PrintCommentString(sFooter);
                return true;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    public boolean printSale(Element root, boolean bGiftPurchDoc) {
        this.bSaleHasACreditNote = false;
        if (this.sPrinterPort == null) {
            this.errorHandler.setError("Printer not setup");
            return false;
        }
        int nNumOfCopies = 0;
        if (root != null && !root.getName().equals("person")) {
            nNumOfCopies = Gen.DEBTOR_SALES_COPIES;
        } else {
            nNumOfCopies = Gen.SALES_COPIES;
            long saleType = this.getSaleType();
            if (saleType == 842L) {
                nNumOfCopies = Gen.CUST_ORD_COMPL_PICKUP_SALES_COPIES;
            } else if (saleType == 841L) {
                nNumOfCopies = Gen.CUST_ORD_COMPL_DISPATCH_SALES_COPIES;
            }
        }
        if (bGiftPurchDoc) {
            nNumOfCopies = 1;
        }
        boolean bAccountPayment = this.isAccountPayment();
        this.nRetTrType = -1L;
        HeaderType headerType = HeaderType.SALE;
        if (bAccountPayment) {
            headerType = HeaderType.ACCOUNT_PAYMENT;
        } else if (bGiftPurchDoc) {
            headerType = HeaderType.GIFT_PURCHASE;
        }
        boolean bReturns = false;
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT D.QTY FROM RET_TRAND D WHERE D.\"ACTIVE\" = 1 AND D.LINE_TYPE IN(0,2,6,7) AND D.VHIDX = " + this.nTransIdx + " AND D.QTY < 0");){
            if (sql.next()) {
                bReturns = true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        if (!bReturns) {
            if (!this.printSaleCopies(headerType, nNumOfCopies, bAccountPayment, bGiftPurchDoc, root)) {
                return false;
            }
        } else {
            headerType = HeaderType.RETURN_CUST;
            nNumOfCopies = Gen.RETURNS_CUST_COPIES;
            if (!this.printSaleCopies(headerType, nNumOfCopies, bAccountPayment, bGiftPurchDoc, root)) {
                return false;
            }
            this.resetReprint();
            headerType = HeaderType.RETURN_STORE;
            nNumOfCopies = Gen.RETURNS_STORE_COPIES;
            if (!this.printSaleCopies(headerType, nNumOfCopies, bAccountPayment, bGiftPurchDoc, root)) {
                return false;
            }
        }
        this.resetReprint();
        if (!bGiftPurchDoc) {
            Element perCust = root;
            if (perCust != null) {
                if (perCust.getName().equals("transaction")) {
                    perCust = root.getChild("cust");
                }
                if (perCust == null) {
                    perCust = root.getChild("person");
                }
            }
            if (this.bSaleHasACreditNote) {
                this.printCreditNote(false, perCust, this.nRetTrType);
            }
            if (this.saleHasCredNoteGiftVouch()) {
                this.printCreditNoteGiftVoucher(false, perCust, this.nRetTrType);
            }
        }
        return true;
    }

    private boolean saleHasCredNoteGiftVouch() {
        boolean hasNote = false;
        String vouchSku = VoucherUtils.getCreditNoteGiftVoucherSKU();
        if (vouchSku != null && vouchSku != "") {
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT * FROM RET_TRAND D where d.active = 1 and d.skuidx = " + vouchSku + " and d.vhidx = " + this.nTransIdx);){
                if (sql.next()) {
                    hasNote = true;
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        return hasNote;
    }

    private boolean saleHasViiRefundVoucher() {
        boolean hasVouch;
        block30: {
            String barcode;
            hasVouch = false;
            IVoucherGateway viiGatewayCheck = VoucherGatewayManager.getInstance().getGateway();
            if (viiGatewayCheck instanceof ViiGateway && (barcode = ((ViiGateway)viiGatewayCheck).getDigitalRefundBarcode()) != "" && barcode != null) {
                try (SqlQuery sql = new SqlQuery(this.conn, "SELECT SKUIDX FROM BARCODE WHERE CODE = '" + barcode.trim() + "'");){
                    if (!sql.next()) break block30;
                    int sku = sql.getInt("SKUIDX");
                    try (SqlQuery skuSql = new SqlQuery(this.conn, "SELECT sum(d.gross)FROM RET_TRAND D WHERE D.VHIDX = " + this.nTransIdx + " AND d.skuidx = " + sku + " AND d.active = 1 HAVING SUM(d.gross) <> 0");){
                        if (skuSql.next()) {
                            hasVouch = true;
                        }
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
        return hasVouch;
    }

    private boolean isAccountPayment() {
        boolean bAccountPayment;
        block27: {
            bAccountPayment = false;
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT COUNT(D.VSHIDX)FROM RET_TRAND D WHERE D.\"ACTIVE\" = 1 AND D.LINE_TYPE IN(0,2,6,7) AND D.VHIDX = " + this.nTransIdx);){
                if (!sql.next() || sql.getInt(1) != 0) break block27;
                try (SqlQuery sqlPay = new SqlQuery(this.conn, "SELECT COUNT(P.VSHIDX)FROM RET_TRANP P WHERE P.\"ACTIVE\" = 1 AND P.PAYMENT_TYPEIDX = 647 AND P.VHIDX = " + this.nTransIdx);){
                    if (sqlPay.next() && sqlPay.getInt(1) > 0) {
                        bAccountPayment = true;
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        return bAccountPayment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getSaleType() {
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT H.SALE_TYPE_IDX FROM RET_TRANH H WHERE H.VHIDX = " + this.nTransIdx);){
            if (!sql.next()) return 0L;
            long l = sql.getLong(1);
            return l;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCustOrderCompletion() {
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT H.TR_TYPE, SUM(D.TAKEN) FROM RET_TRANH H JOIN RET_TRAND D ON D.VHIDX = H.VHIDX WHERE H.VHIDX = " + this.nTransIdx + "GROUP BY TR_TYPE, TAKEN");){
            if (!sql.next()) return false;
            long trtype = sql.getLong(1);
            long taken = sql.getLong(2);
            boolean bl = trtype == 715L && taken > 0L;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean printSaleCopies(HeaderType headerType, int nNumOfCopies, boolean bAccountPayment, boolean bGiftPurchDoc, Element root) {
        if (!this.reprint && PayUtils.isNonPrint(this.deliveryMethod) && (headerType == HeaderType.SALE || headerType == HeaderType.RETURN_CUST)) {
            if (Gen.openTillRequired(this.conn, this.nTransIdx) && !bGiftPurchDoc) {
                try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
                    r1.OpenCashDrawer();
                }
                catch (IOException e) {
                    this.errorHandler.setError(e);
                    return false;
                }
            }
            if (headerType != HeaderType.SALE) return true;
            boolean voucherPrinted = false;
            try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
                voucherPrinted = this.printPromoVoucher(r1);
                if (voucherPrinted) {
                    r1.FeedAndCut();
                }
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
            if (!voucherPrinted) return true;
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            return true;
        }
        int i = 0;
        while (i < nNumOfCopies) {
            block58: {
                try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
                    if (i == 0 && Gen.openTillRequired(this.conn, this.nTransIdx) && !this.reprint && !bGiftPurchDoc) {
                        r1.OpenCashDrawer();
                    }
                    if (!this.printHeader(headerType, r1)) {
                        this.errorHandler.setError("");
                        boolean bl = false;
                        return bl;
                    }
                    this.nRetTrType = bAccountPayment ? this.printAccountPaymentDetails(r1, root) : this.printSaleDetails(r1, root, bGiftPurchDoc, headerType);
                    this.printLoadedVouchers(r1, this.nTransIdx);
                    if (bAccountPayment) {
                        this.printFooter(FooterType.ACCOUNT_PAYMENT, r1, bGiftPurchDoc);
                    } else {
                        this.printFooter(FooterType.SALE, r1, bGiftPurchDoc);
                    }
                    if (headerType == HeaderType.SALE) {
                        if (this.bPrintPromoVoucher) {
                            this.printPromoVoucher(r1);
                            r1.FeedAndCut();
                            break block58;
                        } else {
                            r1.FeedAndCut();
                        }
                        break block58;
                    }
                    r1.FeedAndCut();
                }
                catch (IOException e) {
                    this.errorHandler.setError(e);
                    return false;
                }
            }
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            this.reprint = true;
            ++i;
        }
        return true;
    }

    private long printSaleDetails(PrintReceipt r1, Element root, boolean bGiftPurchDoc, HeaderType headerType) {
        long trtype;
        block196: {
            String sTransIdx = String.valueOf(this.nTransIdx);
            double nTaxPer = 0.0;
            long nRetReasIdx = 0L;
            String sRetReason = null;
            String sAltStyleCode = null;
            long nDiscReasIdx = 0L;
            long nPromoIdx = 0L;
            String sDiscReason = "";
            int nLineType = 0;
            trtype = -1L;
            boolean giftProduct = false;
            double nPaymentAmount = 0.0;
            double nRewardsRedemptionValue = 0.0;
            int nStrLen = 0;
            boolean bPrintSignature = false;
            String sLoyaltyCards = "";
            try {
                int nRightLength;
                int nLeftLength;
                String sDiscPer;
                String sPrice;
                double nPrice;
                double nNet;
                Throwable throwable;
                SqlQuery sql;
                block192: {
                    sql = new SqlQuery(this.conn, "SELECT H.VHIDX, H.DOCKET_NUMBER, H.TRANSSREPIDX,  H.TRAND, H.TRAND,  COALESCE(P.FIRSTNAME, ''), H.TRANS_NUMBER, SUM(PH.PAYMENT_AMOUNT), H.TR_TYPE,  H.TRANS_NUMBER, OS.CODE, OSW.STORENO, H.TILL_NUMBER, COALESCE(H.OMNEO_REDEMPTION_VALUE,0) + COALESCE(H.REWARDS_REDEMPTION_VALUE,0), H.CORDER,  H.WIDX AS OWNER_WIDX, OWNERWHSE.STORENO AS OWNER_STORENO, OWNER.NAME AS OWNER_NAME  FROM RET_TRANH H  LEFT JOIN PERSON P ON " + this.servedByJoin + " = P.PERIDX  LEFT JOIN REFCODE OS ON H.FROM_WIDX = OS.RCIDX  LEFT JOIN WHSE OSW ON OS.RCIDX = OSW.WIDX  LEFT JOIN REFCODE OWNER ON H.WIDX = OWNER.RCIDX  LEFT JOIN WHSE OWNERWHSE ON H.WIDX = OWNERWHSE.WIDX  LEFT OUTER JOIN RET_TRANP PH ON PH.VHIDX = H.VHIDX AND PH.\"ACTIVE\" = 1  WHERE H.\"ACTIVE\" = 1 AND H.VHIDX = " + sTransIdx + " GROUP BY H.VHIDX, H.DOCKET_NUMBER, H.TRANSSREPIDX, H.TRAND, H.TRAND,  COALESCE(P.FIRSTNAME, ''), H.TRANS_NUMBER, H.TR_TYPE,  H.TRANS_NUMBER, OS.CODE, OSW.STORENO, H.TILL_NUMBER, COALESCE(H.OMNEO_REDEMPTION_VALUE,0) + COALESCE(H.REWARDS_REDEMPTION_VALUE,0), H.CORDER,  H.WIDX, OWNERWHSE.STORENO, OWNER.NAME");
                    throwable = null;
                    try {
                        if (!sql.next()) break block192;
                        PosDateFormatter dateFormatter = new PosDateFormatter(null);
                        dateFormatter.setTimestamp(sql.getTimestamp(4));
                        try {
                            dateFormatter.setFormat(3, 3, 2);
                        }
                        catch (Exception e) {
                            PosUtils.logError(e);
                        }
                        String sTranDate = dateFormatter.toString();
                        String sSalesRep = sql.getString(6);
                        trtype = sql.getLong(9);
                        String sOrigDoc = sql.getString(10);
                        String sOrigStore = sql.getString(11);
                        String sOrigStoreNo = sql.getString(12);
                        String custRef = sql.getString("CORDER");
                        nRewardsRedemptionValue = sql.getDouble(14);
                        if (!Gen.NVLString(sOrigDoc, "").equals("") && trtype != 556L && trtype != 558L && sOrigStore != null) {
                            r1.PrintString("\u001b\u0001");
                            r1.PrintString("\u001b\u0007");
                            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Original_Store_") + " " + sOrigStore, 56));
                            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Original_Docket_No_") + " D" + sOrigStoreNo + sOrigDoc, 56));
                        }
                        if (!StringUtils.isNullOrEmpty(custRef)) {
                            r1.PrintString("\u001b\u0001");
                            r1.PrintString("\u001b\u0007");
                            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Customer_Reference_No") + " " + custRef, 56));
                        }
                        Element person = root;
                        if (root != null) {
                            if (root.getChild("person") != null) {
                                person = root.getChild("person");
                            } else if (root.getChild("cust") != null && root.getChild("cust").getChild("person") != null) {
                                person = root.getChild("cust").getChild("person");
                            }
                        }
                        sLoyaltyCards = this.getLoyaltyCards(PosUtils.longVal(sTransIdx), person);
                        if (sql.getString(7) != null && (trtype == 556L || trtype == 558L)) {
                            r1.PrintString("\u001b\u0001");
                            r1.PrintString("\u001b\u0007");
                            r1.PrintString(r1.FormatCentre((sql.getDouble(8) >= 0.0 ? StoreParams.res.getString("Invoice_No") : StoreParams.res.getString("Adj_no")) + ": " + sql.getString(7), 56));
                        }
                        r1.PrintString("\u001b\u0005");
                        r1.PrintString("\u001b\u0001");
                        r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                        r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Docket_No_"), StoreParams.res.getString("Served_By"), this.sTillNumText, StoreParams.res.getString("Date_Time")) + "\n");
                        r1.PrintString(r1.FormatDetailHdr(this.sDocNum, sSalesRep, this.sTillNum, sTranDate) + "\n");
                        if (sql.getLong("OWNER_WIDX") != SP.sParams.getStoreIdx()) {
                            r1.PrintString(r1.FormatLeft(SP.getRS("On_behalf_of") + " " + sql.getString("OWNER_STORENO") + " " + sql.getString("OWNER_NAME"), 56) + "\n");
                        }
                        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                        if (!(root == null || bGiftPurchDoc && headerType != HeaderType.RETURN_STORE)) {
                            boolean printTerms;
                            Element custPrinter = root.getName().equals("transaction") ? root.getChild("cust") : root;
                            boolean bl = printTerms = sql.getDouble(8) > 0.0 && custPrinter != null && custPrinter.getName().equals("cust");
                            if (headerType == HeaderType.RETURN_STORE) {
                                this.printCustDets(r1, custPrinter, sql.getDouble(8) > 0.0 && printTerms, sLoyaltyCards, true);
                            } else {
                                this.printCustDets(r1, custPrinter, sql.getDouble(8) > 0.0 && printTerms, sLoyaltyCards, this.printCustAddr);
                            }
                            r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                        }
                        r1.PrintString("\u001b\u0007");
                        r1.PrintString(StoreParams.res.getString("Product_Description_n"));
                        r1.PrintString("\u001b\u0005\n");
                        nPaymentAmount = sql.getDouble(8);
                    }
                    catch (Throwable dateFormatter) {
                        throwable = dateFormatter;
                        throw dateFormatter;
                    }
                    finally {
                        if (sql != null) {
                            if (throwable != null) {
                                try {
                                    sql.close();
                                }
                                catch (Throwable dateFormatter) {
                                    throwable.addSuppressed(dateFormatter);
                                }
                            } else {
                                sql.close();
                            }
                        }
                    }
                }
                double nTotalCost = 0.0;
                double nTotalTax = 0.0;
                double nTotalUnits = 0.0;
                double nTotalReturns = 0.0;
                double nTotalDiscount = 0.0;
                double nStyleTotalTax = 0.0;
                sql = new SqlQuery(this.conn, "SELECT D.QTY, D.NET, D.TAXPER, S.STYLECODE, S.NAME, C.CLRNAME, K.SIZEVAL, D.PRICE, D.GROSS, D.RET_REASIDX, D.DESCRIP1, D.LINE_TYPE, D.DISCOUNT_REASIDX, D.DISCOUNT_PER, D.VSHIDX, D.ORIG_PRICE, M.MSG, M.ORIG_FLAG, D.EXT_TAXRATE, D.PROMOIDX, D.GIFT_IDX FROM RET_TRAND D LEFT JOIN SKU K ON D.SKUIDX = K.SKUIDX LEFT JOIN CLR C ON K.CLRIDX = C.CLRIDX LEFT JOIN STYLE S ON C.STYLEIDX = S.STYLEIDX LEFT JOIN POS_MKDMSG M ON D.POS_MKDMSGIDX = M.MKDIDX WHERE D.\"ACTIVE\" = 1 AND D.LINE_TYPE IN(0,2,6,7) AND D.VHIDX = " + sTransIdx + " ORDER BY D.SEQUENCE_NUMBER ");
                throwable = null;
                try {
                    while (sql.next()) {
                        double nQty = sql.getDouble("QTY");
                        nLineType = sql.getInt("LINE_TYPE");
                        if (nLineType == 0 || nLineType == 2) {
                            if (this.bUsingExtTax && !bGiftPurchDoc && !giftProduct && nStyleTotalTax != 0.0) {
                                nStyleTotalTax = Gen.RoundNumber(nStyleTotalTax, this.nPrec);
                                nTotalTax = Gen.RoundNumber(nTotalTax, this.nPrec);
                                if (this.showTaxRate) {
                                    r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("tax_at") + " " + this.dfQty.format(Gen.RoundNumber(nTaxPer, 4)) + "%", 40));
                                } else {
                                    r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("Tax"), 40));
                                }
                                r1.PrintString(r1.FormatRight(this.dfDet.format(nStyleTotalTax), 16) + "\n");
                                nStyleTotalTax = 0.0;
                            }
                            boolean bl = giftProduct = sql.getLong("GIFT_IDX") > 0L;
                            nTaxPer = giftProduct ? 0.0 : (this.bUsingExtTax ? sql.getDouble("EXT_TAXRATE") : sql.getDouble("TAXPER"));
                        }
                        nNet = !giftProduct ? sql.getDouble("NET") : 0.0;
                        nPrice = !giftProduct ? sql.getDouble("PRICE") : 0.0;
                        double nGross = !giftProduct ? sql.getDouble("GROSS") : 0.0;
                        double nOrigPrice = !giftProduct ? sql.getDouble("ORIG_PRICE") : 0.0;
                        String sMkdMsg = !giftProduct ? Gen.NVLString(sql.getString("MSG"), "") : "";
                        boolean bPrintOrigPrice = sql.getBoolean("ORIG_FLAG");
                        if (nPrice >= nOrigPrice || bGiftPurchDoc || giftProduct) {
                            bPrintOrigPrice = false;
                        }
                        if (!(giftProduct || this.bUsingExtTax || root == null || root.getName().equals("person") || nLineType != 0 && nLineType != 2)) {
                            nNet += Gen.RoundNumber(nNet * (nTaxPer / 100.0), this.nPrec);
                            nPrice += Gen.RoundNumber(nPrice * (nTaxPer / 100.0), this.nPrec);
                            nGross += Gen.RoundNumber(nGross * (nTaxPer / 100.0), this.nPrec);
                            nOrigPrice += Gen.RoundNumber(nOrigPrice * (nTaxPer / 100.0), this.nPrec);
                        }
                        nRetReasIdx = sql.getLong("RET_REASIDX");
                        sAltStyleCode = sql.getString("DESCRIP1");
                        nDiscReasIdx = !giftProduct ? sql.getLong("DISCOUNT_REASIDX") : 0L;
                        double nDiscPer = !giftProduct ? sql.getDouble("DISCOUNT_PER") : 0.0;
                        nPromoIdx = !giftProduct ? sql.getLong("PROMOIDX") : 0L;
                        sRetReason = "";
                        if (nRetReasIdx != 0L) {
                            sRetReason = Gen.getRefName(nRetReasIdx, this.conn);
                        }
                        sDiscReason = "";
                        if (nPromoIdx != 0L && (nDiscReasIdx == 720L || nDiscReasIdx == 849L)) {
                            sDiscReason = PromotionUtils.getPromoName(nPromoIdx, this.conn);
                        } else if (nDiscReasIdx != 0L) {
                            sDiscReason = Gen.getRefName(nDiscReasIdx, this.conn);
                        }
                        String sQty = this.dfQty.format(nQty);
                        sPrice = this.dfDet.format(nPrice);
                        String sOrigPrice = this.dfDet.format(nOrigPrice);
                        String sCost = !giftProduct ? this.dfDet.format(nNet) : SP.getRS("GIFT");
                        nTotalCost += nNet;
                        if (this.bUsingExtTax) {
                            nTotalTax += nNet * nTaxPer / 100.0;
                            nStyleTotalTax += nNet * nTaxPer / 100.0;
                        } else {
                            nTotalTax += nNet - nNet / (1.0 + nTaxPer / 100.0);
                        }
                        if (nQty > 0.0) {
                            nTotalUnits += nQty;
                        } else {
                            nTotalReturns += nQty;
                        }
                        String sStyleCode = Gen.NVLString(sql.getString("STYLECODE"), "");
                        String sStyleName = Gen.NVLString(sql.getString("NAME"), "");
                        sStyleName = sStyleName.substring(0, this.getMaxProdDescLen(sStyleName));
                        String sClrName = Gen.NVLString(sql.getString("CLRNAME"), "");
                        String sSizeVal = Gen.NVLString(sql.getString("SIZEVAL"), "");
                        if (nLineType == 0 || nLineType == 2) {
                            if (!this.bUsingExtTax && nTaxPer != 0.0) {
                                sStyleName = "* " + sStyleName;
                                if (sAltStyleCode != null) {
                                    sAltStyleCode = "* " + sAltStyleCode;
                                }
                            } else {
                                sStyleName = "  " + sStyleName;
                                if (sAltStyleCode != null) {
                                    sAltStyleCode = "  " + sAltStyleCode;
                                }
                            }
                            if (sAltStyleCode == null) {
                                r1.PrintString(r1.FormatLeft(sStyleName + (sClrName.length() > 0 ? " " + sClrName : "") + (sSizeVal.length() > 0 ? " " + sSizeVal : ""), 56) + "\n");
                            } else {
                                r1.PrintString(r1.FormatLeft(sAltStyleCode, 56) + "\n");
                            }
                            sPrice = bGiftPurchDoc || giftProduct ? "" : sPrice + " ";
                            if (!bPrintOrigPrice) {
                                sOrigPrice = "";
                                sMkdMsg = "";
                            } else {
                                Object[] objs = new Object[]{sOrigPrice};
                                sOrigPrice = MessageFormat.format(StoreParams.res.getString("orig_price_text"), objs);
                            }
                            r1.PrintString(r1.FormatLeft("  " + sStyleCode + " " + sPrice + "x " + sQty + StoreParams.res.getString("units"), 40));
                            if (!bGiftPurchDoc) {
                                r1.PrintString(r1.FormatRight(sCost, 16) + "\n");
                            } else {
                                r1.PrintString("\n");
                            }
                            if (sMkdMsg.length() > 0) {
                                r1.PrintString("  " + sMkdMsg + "\n");
                            }
                            if (bPrintOrigPrice && !giftProduct) {
                                r1.PrintString("  " + sOrigPrice + "\n");
                            }
                            if (sRetReason != null && sRetReason.length() > 0) {
                                nStrLen = StoreParams.res.getString("Return_Reason_").length() + 4 + 1;
                                r1.PrintString("\u001b\u0007    " + StoreParams.res.getString("Return_Reason_") + " " + "\u001b\u0005" + r1.FormatLeft(sRetReason, 56 - nStrLen) + "\n");
                            }
                            if (root == null || root.getName().equals("person")) continue;
                            this.printNotes(r1, Note.getNotes(sql.getLong("VSHIDX"), "RET_TRAND", this.conn), false);
                            continue;
                        }
                        if (nLineType == 7 && this.nTrType == 556L && this.nTrType == 558L) {
                            sAltStyleCode = StoreParams.res.getString("Loyalty");
                        }
                        if (sAltStyleCode != null && sAltStyleCode.length() > 33) {
                            sAltStyleCode = sAltStyleCode.substring(0, 33);
                        }
                        sDiscPer = this.bPrintDiscountPercent && Gen.RoundNumber(nDiscPer, 2) != 0.0 ? " " + this.dfQty.format(Gen.RoundNumber(nDiscPer, 2)) + "%" : "";
                        nTotalDiscount += nNet;
                        nStrLen = sAltStyleCode.length() + 4 + 2;
                        if (bGiftPurchDoc || giftProduct) continue;
                        r1.PrintString("\u001b\u0007    " + sAltStyleCode + ": " + "\u001b\u0005" + r1.FormatLeft(sDiscReason, Math.max(0, 39 - nStrLen)) + r1.FormatLeft(sDiscPer, 7));
                        r1.PrintString(r1.FormatRight(sCost, 10) + "\n");
                    }
                }
                catch (Throwable sStyleCode) {
                    throwable = sStyleCode;
                    throw sStyleCode;
                }
                finally {
                    if (sql != null) {
                        if (throwable != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable sStyleCode) {
                                throwable.addSuppressed(sStyleCode);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
                if (this.bUsingExtTax && !bGiftPurchDoc && !giftProduct && nStyleTotalTax != 0.0) {
                    nStyleTotalTax = Gen.RoundNumber(nStyleTotalTax, this.nPrec);
                    nTotalTax = Gen.RoundNumber(nTotalTax, this.nPrec);
                    if (this.showTaxRate) {
                        r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("tax_at") + " " + this.dfQty.format(Gen.RoundNumber(nTaxPer, 4)) + "%", 40));
                    } else {
                        r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("Tax"), 40));
                    }
                    r1.PrintString(r1.FormatRight(this.dfDet.format(nStyleTotalTax), 16) + "\n");
                    nStyleTotalTax = 0.0;
                }
                if (root != null && this.nTrType == 558L) {
                    for (Element nextStyles : root.getChildren("styles")) {
                        Iterator stylelines = nextStyles.getChildren().iterator();
                        nNet = 0.0;
                        while (stylelines.hasNext()) {
                            Element style = (Element)stylelines.next();
                            try {
                                SqlQuery sql2;
                                if (style.getName().equals("style")) {
                                    sql2 = new SqlQuery(this.conn, "SELECT S.STYLECODE, S.NAME, COALESCE(C.CLRNAME, ''), COALESCE(K.SIZEVAL, '') FROM SKU K, CLR C, STYLE S WHERE K.CLRIDX = C.CLRIDX AND C.STYLEIDX = S.STYLEIDX AND K.SKUIDX = " + style.getAttribute("skuidx").getValue());
                                    Throwable sSizeVal = null;
                                    try {
                                        if (sql2.next()) {
                                            String prefix;
                                            nTaxPer = !this.bUsingExtTax ? style.getAttribute("taxper").getDoubleValue() / 100.0 : 0.0;
                                            nPrice = style.getAttribute("price").getDoubleValue() + Gen.RoundNumber(style.getAttribute("price").getDoubleValue() * nTaxPer, this.nPrec);
                                            nNet = nPrice * PosUtils.doubleValInternal(style.getText());
                                            String string = prefix = style.getAttribute("taxper").getDoubleValue() > 0.0 && !this.bUsingExtTax ? "* " : "  ";
                                            if (style.getAttribute("descrip1") == null) {
                                                r1.PrintString(r1.FormatLeft(prefix + sql2.getString(2) + " " + sql2.getString(3) + " " + sql2.getString(4), 56) + "\n");
                                            } else {
                                                r1.PrintString(r1.FormatLeft(prefix + style.getAttribute("descrip1").getValue(), 56) + "\n");
                                            }
                                            sPrice = bGiftPurchDoc ? "" : this.dfDet.format(nPrice) + " ";
                                            r1.PrintString(r1.FormatLeft("  " + sql2.getString(1) + " " + sPrice + "x " + this.dfQty.format(PosUtils.doubleValInternal(style.getText())) + StoreParams.res.getString("units"), 40));
                                            if (!bGiftPurchDoc) {
                                                r1.PrintString(r1.FormatRight(this.dfDet.format(nNet), 16) + "\n");
                                            } else {
                                                r1.PrintString("\n");
                                            }
                                        }
                                    }
                                    catch (Throwable prefix) {
                                        sSizeVal = prefix;
                                        throw prefix;
                                    }
                                    finally {
                                        if (sql2 != null) {
                                            if (sSizeVal != null) {
                                                try {
                                                    sql2.close();
                                                }
                                                catch (Throwable prefix) {
                                                    sSizeVal.addSuppressed(prefix);
                                                }
                                            } else {
                                                sql2.close();
                                            }
                                        }
                                    }
                                    this.printNotes(r1, style.getChildren("note"), false);
                                } else if (style.getName().equals("discount")) {
                                    nNet = -nNet * (PosUtils.doubleValInternal(style.getText()) / 100.0);
                                    sDiscPer = this.bPrintDiscountPercent && Gen.RoundNumber(PosUtils.doubleValInternal(style.getText()), 2) != 0.0 ? " " + this.dfQty.format(Gen.RoundNumber(PosUtils.doubleValInternal(style.getText()), 2)) + "%" : "";
                                    nStrLen = StoreParams.res.getString("Discount1").length() + 4 + 2;
                                    if (!bGiftPurchDoc) {
                                        sql2 = new SqlQuery(this.conn, "SELECT NAME FROM REFCODE WHERE RCIDX = " + style.getAttribute("reasonidx").getValue());
                                        Throwable sSizeVal = null;
                                        try {
                                            if (sql2.next()) {
                                                r1.PrintString("\u001b\u0007    " + StoreParams.res.getString("Discount1") + ": " + "\u001b\u0005" + r1.FormatLeft(sql2.getString(1), 33 - nStrLen) + r1.FormatLeft(sDiscPer, 7));
                                            } else {
                                                r1.PrintString("\u001b\u0007" + r1.FormatLeft("    " + StoreParams.res.getString("Discount1"), 33) + "\u001b\u0005" + r1.FormatLeft(sDiscPer, 7));
                                            }
                                        }
                                        catch (Throwable prefix) {
                                            sSizeVal = prefix;
                                            throw prefix;
                                        }
                                        finally {
                                            if (sql2 != null) {
                                                if (sSizeVal != null) {
                                                    try {
                                                        sql2.close();
                                                    }
                                                    catch (Throwable prefix) {
                                                        sSizeVal.addSuppressed(prefix);
                                                    }
                                                } else {
                                                    sql2.close();
                                                }
                                            }
                                        }
                                        r1.PrintString(r1.FormatRight(this.dfDet.format(nNet), 16) + "\n");
                                    }
                                    nTotalDiscount += nNet;
                                }
                                nTotalCost += nNet;
                                if (!this.bUsingExtTax) {
                                    nTotalTax += nNet - nNet / (1.0 + nTaxPer);
                                }
                                if (PosUtils.doubleValInternal(style.getText()) > 0.0) {
                                    nTotalUnits += PosUtils.doubleValInternal(style.getText());
                                    continue;
                                }
                                nTotalReturns += PosUtils.doubleValInternal(style.getText());
                            }
                            catch (Exception e) {
                                PosUtils.logError(e);
                            }
                        }
                    }
                }
                if (this.bPrintTotUnits) {
                    Object[] objs;
                    r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                    r1.PrintString("\u001b\u0007");
                    if (nTotalUnits > 0.0) {
                        objs = new Object[]{this.dfQty.format(nTotalUnits)};
                        r1.PrintString(r1.FormatLeft("  " + MessageFormat.format(StoreParams.res.getString("total_units"), objs), 40) + "\n");
                    }
                    if (nTotalReturns < 0.0) {
                        objs = new Object[]{this.dfQty.format(nTotalReturns * -1.0)};
                        r1.PrintString(r1.FormatLeft("  " + MessageFormat.format(StoreParams.res.getString("total_returns"), objs), 40) + "\n");
                    }
                    r1.PrintString("\u001b\u0005");
                }
                if (bGiftPurchDoc) break block196;
                double totalIncTax = this.bUsingExtTax ? nTotalCost + nTotalTax : nTotalCost;
                String sTotalCost = this.dfTot.format(totalIncTax);
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                if (this.bLargeFontForTotals) {
                    r1.PrintString("\u001b\u0006");
                    nLeftLength = 30;
                    nRightLength = 12;
                } else {
                    r1.PrintString("\u001b\u0007");
                    nLeftLength = 40;
                    nRightLength = 16;
                }
                if (root != null && !root.getName().equals("person") && nPaymentAmount < 0.0) {
                    r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_Credit_Inc_Tax"), nLeftLength));
                } else {
                    r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_Inc_Tax"), nLeftLength));
                }
                r1.PrintString(r1.FormatRight(sTotalCost, nRightLength));
                r1.PrintString("\u001b\u0005");
                if (!this.bUsingExtTax) {
                    double totalPromoVoucherPayments = this.getTotalPromoVoucherPayments(PosUtils.longVal(sTransIdx));
                    if ((totalPromoVoucherPayments = Gen.RoundNumber(totalPromoVoucherPayments, this.nPrec)) > 0.0) {
                        nTotalTax = this.adjustTaxForPromoVouchers(Gen.RoundNumber(totalIncTax, this.nPrec), nTotalTax, totalPromoVoucherPayments);
                    }
                }
                if ((nTotalTax = Gen.RoundNumber(nTotalTax, this.nPrec)) != 0.0) {
                    r1.PrintString(r1.FormatRight(StoreParams.res.getString("Tax"), 40));
                    r1.PrintString(r1.FormatRight(this.dfTot.format(nTotalTax), 16) + "\n");
                }
                if ((nTotalDiscount = Gen.RoundNumber(nTotalDiscount + nRewardsRedemptionValue, this.nPrec)) != 0.0) {
                    r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_Discount"), 40));
                    r1.PrintString(r1.FormatRight(this.dfTot.format(nTotalDiscount), 16) + "\n");
                }
                if ((nRewardsRedemptionValue = Gen.RoundNumber(nRewardsRedemptionValue * -1.0, this.nPrec)) != 0.0) {
                    r1.PrintString(r1.FormatRight(StoreParams.res.getString("Rewards_Redeemed"), 40));
                    r1.PrintString(r1.FormatRight(this.dfTot.format(nRewardsRedemptionValue), 16) + "\n");
                }
                boolean bfoundAccPayment = false;
                try (SqlQuery sql3 = new SqlQuery(this.conn, "SELECT P.PAYMENT_AMOUNT, COALESCE(P.EFTPOS_CARDTYPE || ' ' || P.EFTPOS_ACTYPE, COALESCE(PT.ALT_CODE, R.NAME)) FROM RET_TRANP P, REFCODE R LEFT OUTER JOIN RET_PAY_TYPES PT ON R.RCIDX = PT.RCIDX WHERE P.PAYMENT_TYPEIDX = 647 AND P.\"ACTIVE\" = 1 AND P.PAYMENT_TYPEIDX = R.RCIDX AND P.VHIDX = " + sTransIdx + " ORDER BY P.SEQUENCE_NUMBER ");){
                    while (sql3.next()) {
                        if (!bfoundAccPayment) {
                            r1.PrintString("\u001b\u0007");
                            r1.PrintString("\n");
                            bfoundAccPayment = true;
                            bPrintSignature = true;
                        }
                        r1.PrintString(r1.FormatRight(sql3.getString(2), 40));
                        r1.PrintString(r1.FormatRight(this.dfTot.format(sql3.getDouble(1) * -1.0), 16) + "\n");
                    }
                }
                r1.PrintString("\u001b\u0005");
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintString("\u001b\u0007");
                r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Payment_Details_"), 40) + "\n");
                r1.PrintString("\u001b\u0005");
                String eftDets = "";
                String sRemainingValue = "";
                String sVoucherName = "";
                String sVoucherPin = "";
                String paymentVhIdx = sTransIdx;
                String paymentWhere = " AND P.VHIDX = ? ";
                try (SqlQuery payTransQuery = new SqlQuery(this.conn, "SELECT VHIDX FROM RET_TRANH WHERE PAYMENT_FOR_VHIDX = ? AND ACTIVE = 1", sTransIdx);){
                    if (payTransQuery.next()) {
                        paymentVhIdx = payTransQuery.getString("VHIDX");
                        paymentWhere = " AND P.PAYMENT_TYPEIDX <> 716 AND P.VHIDX = ? ";
                    }
                }
                var85_96 = null;
                try (SqlQuery sql4 = new SqlQuery(this.conn, "SELECT  P.PAYMENT_AMOUNT, COALESCE(P.EFTPOS_CARDTYPE || ' ' || P.EFTPOS_ACTYPE, COALESCE(PT.ALT_CODE, R.NAME)), COALESCE(R.RCIDX,0), P.PAYMENT_NUMBER, T.BLOBTEXT, P.EFTPOS_STAN, P.EFTPOS_REFERENCE, P.VOUCHER_BALANCE, P.EXPIRY_DATE FROM RET_TRANP P JOIN REFCODE R ON P.PAYMENT_TYPEIDX = R.RCIDX LEFT JOIN EFT_TRANDETS E ON E.VSHIDX = P.VSHIDX LEFT JOIN BLOBTEXT T ON T.BLOBIDX = E.DOCKET_BLOBIDX LEFT OUTER JOIN RET_PAY_TYPES PT ON R.RCIDX = PT.RCIDX WHERE P.\"ACTIVE\" = 1 AND P.PAYMENT_TYPEIDX <> 647" + paymentWhere + "ORDER BY P.SEQUENCE_NUMBER ", paymentVhIdx);){
                    while (sql4.next()) {
                        long nPayIdx = sql4.getLong(3);
                        if (nPayIdx == 420L || PayTypes.getPayType((long)nPayIdx).isAccount) {
                            bPrintSignature = true;
                        }
                        double nPayAmt = sql4.getDouble(1);
                        String sPayType = sql4.getString(2);
                        String sPayNumber = sql4.getString(4);
                        if (nPayIdx != 518L && !PayTypes.getPayType((long)nPayIdx).isCreditNote && nPayAmt < 0.0) {
                            sPayType = StoreParams.res.getString("Change_") + sPayType + StoreParams.res.getString("KEY3");
                        }
                        if (PayTypes.getPayType((long)nPayIdx).isCreditNote) {
                            if (sPayNumber != null) {
                                sPayType = sPayType + ": " + sPayNumber;
                            }
                            if (nPayAmt < 0.0) {
                                this.bSaleHasACreditNote = true;
                            }
                        }
                        if (nPayIdx == 776L) {
                            String stan = sql4.getString(6);
                            if (stan.length() > 20) {
                                stan = stan.substring(0, 20);
                            }
                            sPayType = sPayType + " " + StoreParams.res.getString("afterpay_order_receipt") + ": " + stan;
                        }
                        if (nPayIdx == 795L) {
                            String stan = sql4.getString(6);
                            if (stan.length() > 20) {
                                stan = stan.substring(0, 20);
                            }
                            sPayType = sPayType + " " + StoreParams.res.getString("zippay_ref_receipt") + ": " + stan;
                        }
                        if (nPayIdx == 850L) {
                            String stan = sql4.getString(6);
                            if (stan.length() > 20) {
                                stan = stan.substring(0, 20);
                            }
                            sPayType = sPayType + " " + StoreParams.res.getString("openpay_ref_receipt") + ": " + stan;
                        }
                        sRemainingValue = "";
                        sVoucherPin = "";
                        boolean isGatewayVoucher = false;
                        if (PayTypes.getPayType((long)nPayIdx).isVoucher && sPayNumber != null) {
                            VoucherLoadAdapter voucherAdapter = new VoucherLoadAdapter();
                            voucherAdapter.processNumber(sPayNumber);
                            if (voucherAdapter.getVoucher() != null) {
                                sVoucherName = voucherAdapter.getVoucher().getVoucherType().getName();
                                if (sVoucherName.length() > 25) {
                                    sVoucherName = sVoucherName.substring(0, 25);
                                }
                                sPayType = String.valueOf(voucherAdapter.getVoucher().getVoucherType().getRcidx()).equals(VoucherUtils.getCreditNoteGiftVoucherType()) ? sVoucherName + ": CN" + voucherAdapter.getVoucher().getDisplayNumber() : sVoucherName + ": " + voucherAdapter.getVoucher().getDisplayNumber();
                                if (voucherAdapter.getVoucher().getVoucherType().getBalanceRules() == VoucherType.BalanceRules.RETAIN_VALUE) {
                                    Object[] objs = new Object[]{this.dfDet.format(voucherAdapter.getVoucher().getAvailableAmount())};
                                    sRemainingValue = MessageFormat.format(StoreParams.res.getString("remaining_voucher_amount"), objs);
                                    sVoucherPin = VoucherUtils.getVoucherPin(voucherAdapter.getVoucher().getNumber());
                                }
                            } else {
                                sPayType = sPayType + ": " + sPayNumber;
                                if (VoucherGatewayManager.getInstance().getGateway() != null) {
                                    isGatewayVoucher = true;
                                }
                            }
                        }
                        if (nPayIdx == 518L && (nPayAmt = Gen.RoundNumber(nPayAmt, this.nPrec)) != 0.0) {
                            nPayAmt *= -1.0;
                        }
                        if (sql4.getString(5) != null) {
                            eftDets = eftDets + sql4.getString(5);
                        }
                        if (this.nTrType == 558L && nPayIdx == 420L) continue;
                        String sPayAmt = this.dfDet.format(nPayAmt);
                        r1.PrintString(r1.FormatLeft("  " + sPayType, 40));
                        r1.PrintString(r1.FormatRight(sPayAmt, 16) + "\n");
                        if (isGatewayVoucher) {
                            PosDateFormatter dateFormatter = new PosDateFormatter(null);
                            dateFormatter.setFormat(3, 0);
                            r1.PrintString(r1.FormatLeft("    " + SP.getRS("voucher_receipt_balance"), 20));
                            r1.PrintString(r1.FormatLeft(this.dfDet.format(sql4.getDouble("VOUCHER_BALANCE")), 36) + "\n");
                            if (sql4.getDate("EXPIRY_DATE") != null) {
                                dateFormatter.setTimestamp(sql4.getTimestamp("EXPIRY_DATE"));
                                r1.PrintString(r1.FormatLeft("    " + SP.getRS("voucher_receipt_expiry_date"), 20));
                                r1.PrintString(r1.FormatLeft(dateFormatter.toString(), 36) + "\n");
                            }
                        }
                        if (!sVoucherPin.equals("")) {
                            r1.PrintString(r1.FormatLeft("  PIN: " + sVoucherPin, 40) + "\n");
                        }
                        if (sRemainingValue.equals("")) continue;
                        r1.PrintString(r1.FormatLeft("  " + sRemainingValue, 40) + "\n");
                    }
                    this.printEftDets(r1, eftDets);
                    if (headerType == HeaderType.RETURN_STORE) {
                        this.printReturnSignature(r1);
                    } else if (bPrintSignature) {
                        this.printSignature(r1);
                    }
                }
                catch (Throwable throwable2) {
                    var85_96 = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        return trtype;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean printCreditNote(boolean bStandAlone, Element cust, long trtype) {
        if (this.printedByUser != null && this.reprint && !Security.hasSecurity(11163L, this.printedByUser.getMemidx(), 0)) {
            return false;
        }
        try {
            String query = null;
            if (trtype == 556L) {
                query = "SELECT P.VSHIDX FROM RET_TRANP P WHERE P.\"ACTIVE\" = 1 AND P.PAYMENT_TYPEIDX = 420 AND P.PAYMENT_AMOUNT < 0 AND P.VHIDX = " + this.nTransIdx + " ORDER BY P.SEQUENCE_NUMBER ";
            } else {
                String paymentExtraWhere = "";
                try (SqlQuery payTransQuery = new SqlQuery(this.conn, "SELECT VHIDX FROM RET_TRANH WHERE PAYMENT_FOR_VHIDX = ? AND ACTIVE = 1", this.nTransIdx);){
                    if (payTransQuery.next()) {
                        paymentExtraWhere = " OR P.VHIDX = " + payTransQuery.getString("VHIDX");
                    }
                }
                query = "SELECT P.VSHIDX FROM RET_TRANP P, RET_PAY_TYPES T WHERE P.PAYMENT_TYPEIDX = T.RCIDX AND P.\"ACTIVE\" = 1 AND T.IS_CREDIT_NOTE = 1 AND P.PAYMENT_AMOUNT < 0 AND (P.VHIDX = " + this.nTransIdx + paymentExtraWhere + ") ORDER BY P.VHIDX, P.SEQUENCE_NUMBER ";
            }
            try (SqlQuery sql = new SqlQuery(this.conn, query);){
                while (sql.next()) {
                    for (int i = 0; i < Gen.CREDIT_NOTES_COPIES; ++i) {
                        try {
                            Throwable throwable;
                            PrintReceipt r1;
                            block59: {
                                boolean bl;
                                block60: {
                                    r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);
                                    throwable = null;
                                    if (i == 0 && bStandAlone && Gen.openTillRequired(this.conn, this.nTransIdx) && !this.reprint) {
                                        r1.OpenCashDrawer();
                                    }
                                    if (this.printHeader(HeaderType.CREDIT, r1)) break block59;
                                    this.errorHandler.setError("");
                                    bl = false;
                                    if (r1 == null) return bl;
                                    if (throwable == null) break block60;
                                    try {
                                        r1.close();
                                        return bl;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                        return bl;
                                    }
                                }
                                r1.close();
                                return bl;
                            }
                            try {
                                this.printCreditDetails(r1, sql.getLong(1), cust);
                                this.printFooter(FooterType.CREDIT, r1);
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throw throwable4;
                            }
                            finally {
                                if (r1 != null) {
                                    if (throwable != null) {
                                        try {
                                            r1.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        r1.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            this.errorHandler.setError(e);
                            boolean bl = false;
                            if (sql == null) return bl;
                            if (var7_7 == null) {
                                sql.close();
                                return bl;
                            }
                            try {
                                sql.close();
                                return bl;
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                                return bl;
                            }
                        }
                        Gen.PrintImage(this.sPrinterPort, this.sImagePath);
                        this.reprint = true;
                    }
                    this.resetReprint();
                }
                return true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return true;
    }

    private void printCreditDetails(PrintReceipt r1, long nPaymentIdx, Element cust) {
        String sTransIdx = String.valueOf(this.nTransIdx);
        PosDateFormatter dateFormatter = new PosDateFormatter(null);
        double nTotalCredit = 0.0;
        String sTotalCredit = null;
        try {
            long transType;
            block50: {
                block49: {
                    try (SqlQuery sql = new SqlQuery(this.conn, "SELECT P.PAYMENT_NUMBER, P.PAYMENT_AMOUNT, H.TR_TYPE, H.TRANS_NUMBER, P.EXPIRY_DATE, H.WIDX FROM RET_TRANP P, RET_TRANH H WHERE H.VHIDX = P.VHIDX AND P.VSHIDX = " + nPaymentIdx + " ");){
                        if (!sql.next()) break block49;
                        this.sCreditNoteNum = sql.getLong(3) == 556L ? "A" + Gen.NVLString(sql.getString(4), " ") : "C" + SP.sParams.getStore(sql.getLong("WIDX")).getStoreNo() + Gen.NVLString(sql.getString(1), " ");
                        nTotalCredit = Gen.RoundNumber(sql.getDouble(2), this.nPrec);
                        String sExpDate = "";
                        if (sql.getString(5) != null) {
                            dateFormatter.setTimestamp(sql.getTimestamp(5));
                            try {
                                dateFormatter.setFormat(3, 3, 0);
                            }
                            catch (Exception e) {
                                PosUtils.logError(e);
                            }
                            sExpDate = " " + StoreParams.res.getString("Expires") + " " + dateFormatter.toString();
                        }
                        if (nTotalCredit != 0.0) {
                            nTotalCredit *= -1.0;
                        }
                        sTotalCredit = this.dfTot.format(nTotalCredit);
                        r1.PrintString("\u001b\u0001");
                        r1.PrintString("\u001b\u0007");
                        r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Credit_Note_No_") + " " + this.sCreditNoteNum + sExpDate, 56) + "\n");
                        r1.PrintString("\u001b\u0005");
                    }
                }
                transType = 0L;
                try (SqlQuery sql = new SqlQuery(this.conn, "SELECT H.VHIDX, H.DOCKET_NUMBER, H.TRANSSREPIDX, H.TRAND, H.TRAND, COALESCE(P.FIRSTNAME, ''), H.TR_TYPE FROM RET_TRANH H LEFT JOIN PERSON P ON " + this.servedByJoin + " = P.PERIDX  WHERE H.\"ACTIVE\" = 1 AND H.VHIDX = " + sTransIdx);){
                    if (!sql.next()) break block50;
                    transType = sql.getLong(7);
                    dateFormatter.setTimestamp(sql.getTimestamp(4));
                    try {
                        dateFormatter.setFormat(3, 3, 2);
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                    String sTranDate = dateFormatter.toString();
                    String sSalesRep = sql.getString(6);
                    r1.PrintString("\u001b\u0005");
                    r1.PrintString("\u001b\u0001");
                    r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Docket_No_"), StoreParams.res.getString("Served_By"), this.sTillNumText, StoreParams.res.getString("Date_Time")) + "\n");
                    r1.PrintString(r1.FormatDetailHdr(this.sDocNum, sSalesRep, this.sTillNum, sTranDate) + "\n");
                    r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    if (cust != null) {
                        this.printCustDets(r1, cust, false, null, this.printCustAddr);
                        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    }
                }
            }
            boolean bPrintHeading = true;
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT DISTINCT R.NAME FROM REFCODE R, RET_TRAND D WHERE D.\"ACTIVE\" = 1 AND D.LINE_TYPE in (0,2) AND D.RET_REASIDX = R.RCIDX AND D.VHIDX = " + sTransIdx);){
                while (sql.next()) {
                    if (bPrintHeading) {
                        Object[] objs = new Object[]{"\n"};
                        r1.PrintString("\u001b\u0007" + MessageFormat.format(StoreParams.res.getString("Return_Reason_s_n"), objs) + "\u001b\u0005");
                        bPrintHeading = false;
                    }
                    r1.PrintString(r1.FormatLeft(Gen.NVLString(sql.getString(1), " "), 56) + "\n");
                }
            }
            if (!bPrintHeading) {
                r1.Feed(2, PrintReceipt.DocketFormat.LONG_ONLY);
            }
            r1.PrintString("\u001b\u0007");
            r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_Credit_Inc_Tax"), 40));
            r1.PrintString(r1.FormatRight(sTotalCredit, 16) + "\n");
            r1.PrintString("\u001b\u0005");
            if (transType == 556L) {
                r1.Feed(1);
                r1.PrintString("\u001b\u0007");
                r1.PrintString(StoreParams.res.getString("Signature_1") + "\n");
                r1.Feed(1);
                r1.PrintString(StoreParams.res.getString("Date_1") + "\n");
                r1.Feed(1);
                r1.PrintString("\u001b\u0005");
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean printCreditNoteGiftVoucher(boolean bStandAlone, Element cust, long trtype) {
        block43: {
            if (this.printedByUser != null && this.reprint && !Security.hasSecurity(11163L, this.printedByUser.getMemidx(), 0)) {
                return false;
            }
            try {
                query = "SELECT D.VSHIDX FROM RET_TRAND D WHERE D.ACTIVE = 1 AND D.LINE_TYPE = 2 AND D.VHIDX = " + this.nTransIdx + " AND D.SKUIDX = " + VoucherUtils.getCreditNoteGiftVoucherSKU() + " ORDER BY D.SEQUENCE_NUMBER";
                sql = new SqlQuery(this.conn, query);
                var7_7 = null;
                ** try [egrp 1[TRYBLOCK] [13, 16 : 94->229)] { 
lbl8:
                // 1 sources

                break block43;
lbl9:
                // 1 sources

                catch (Throwable var8_10) {
                    var7_7 = var8_10;
                    throw var8_10;
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
            return true;
        }
        while (sql.next() != false) {
            for (i = 0; i < Gen.CREDIT_NOTES_COPIES; ++i) {
                try {
                    block44: {
                        block45: {
                            r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);
                            var10_13 = null;
                            if (i == 0 && bStandAlone && Gen.openTillRequired(this.conn, this.nTransIdx) && !this.reprint) {
                                r1.OpenCashDrawer();
                            }
                            if (this.printHeader(HeaderType.CREDIT, r1)) break block44;
                            this.errorHandler.setError("");
                            var11_16 = false;
                            if (r1 == null) return var11_16;
                            if (var10_13 == null) break block45;
                            try {
                                r1.close();
                                return var11_16;
                            }
                            catch (Throwable var12_19) {
                                var10_13.addSuppressed(var12_19);
                                return var11_16;
                            }
                        }
                        r1.close();
                        return var11_16;
                    }
                    try {
                        this.printCNGVDetails(r1, sql.getLong(1), cust);
                        this.printFooter(FooterType.CREDIT, r1);
                    }
                    catch (Throwable var11_17) {
                        var10_13 = var11_17;
                        throw var11_17;
                    }
                    catch (Throwable var13_21) {
                        throw var13_21;
                    }
                    finally {
                        if (r1 != null) {
                            if (var10_13 != null) {
                                try {
                                    r1.close();
                                }
                                catch (Throwable var11_15) {
                                    var10_13.addSuppressed(var11_15);
                                }
                            } else {
                                r1.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    this.errorHandler.setError(e);
                    var10_14 = false;
                    if (sql == null) return var10_14;
                    if (var7_7 == null) {
                        sql.close();
                        return var10_14;
                    }
                    try {
                        sql.close();
                        return var10_14;
                    }
                    catch (Throwable var11_18) {
                        var7_7.addSuppressed(var11_18);
                        return var10_14;
                    }
                }
                Gen.PrintImage(this.sPrinterPort, this.sImagePath);
                this.reprint = true;
            }
            this.resetReprint();
        }
        return true;
lbl81:
        // 1 sources

        finally {
            if (sql != null) {
                if (var7_7 != null) {
                    try {
                        sql.close();
                    }
                    catch (Throwable var12_20) {
                        var7_7.addSuppressed(var12_20);
                    }
                } else {
                    sql.close();
                }
            }
        }
    }

    private void printCNGVDetails(PrintReceipt r1, long nDetailIdx, Element cust) {
        String sTransIdx = String.valueOf(this.nTransIdx);
        PosDateFormatter dateFormatter = new PosDateFormatter(null);
        double nTotalCredit = 0.0;
        String sTotalCredit = null;
        try {
            long transType;
            block49: {
                block48: {
                    try (SqlQuery sql = new SqlQuery(this.conn, "SELECT D.GVNUM, D.GROSS, EXPIRY_DATE, D.ORIG_EXPIRY_DATE FROM RET_TRAND D, RET_TRANH H WHERE D.ACTIVE = 1 AND D.LINE_TYPE = 2 AND D.VSHIDX = " + nDetailIdx + " ORDER BY D.SEQUENCE_NUMBER");){
                        if (!sql.next()) break block48;
                        this.sCreditNoteNum = "CN" + Gen.NVLString(sql.getString(1), " ");
                        nTotalCredit = Gen.RoundNumber(sql.getDouble(2), this.nPrec);
                        String sExpDate = "";
                        if (sql.getString(3) != null) {
                            dateFormatter.setTimestamp(sql.getTimestamp(3));
                            try {
                                dateFormatter.setFormat(3, 3, 0);
                            }
                            catch (Exception e) {
                                PosUtils.logError(e);
                            }
                            sExpDate = " " + StoreParams.res.getString("Expires") + " " + dateFormatter.toString();
                        }
                        sTotalCredit = this.dfTot.format(nTotalCredit);
                        r1.PrintString("\u001b\u0001");
                        r1.PrintString("\u001b\u0007");
                        r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Credit_Note_No_") + " " + this.sCreditNoteNum + sExpDate, 56) + "\n");
                        r1.PrintString("\u001b\u0005");
                    }
                }
                transType = 0L;
                try (SqlQuery sql = new SqlQuery(this.conn, "SELECT H.VHIDX, H.DOCKET_NUMBER, H.TRANSSREPIDX, H.TRAND, H.TRAND, COALESCE(P.FIRSTNAME, ''), H.TR_TYPE FROM RET_TRANH H LEFT JOIN PERSON P ON " + this.servedByJoin + " = P.PERIDX  WHERE H.\"ACTIVE\" = 1 AND H.VHIDX = " + sTransIdx);){
                    if (!sql.next()) break block49;
                    transType = sql.getLong(7);
                    dateFormatter.setTimestamp(sql.getTimestamp(4));
                    try {
                        dateFormatter.setFormat(3, 3, 2);
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                    String sTranDate = dateFormatter.toString();
                    String sSalesRep = sql.getString(6);
                    r1.PrintString("\u001b\u0005");
                    r1.PrintString("\u001b\u0001");
                    r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Docket_No_"), StoreParams.res.getString("Served_By"), this.sTillNumText, StoreParams.res.getString("Date_Time")) + "\n");
                    r1.PrintString(r1.FormatDetailHdr(this.sDocNum, sSalesRep, this.sTillNum, sTranDate) + "\n");
                    r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    if (cust != null) {
                        this.printCustDets(r1, cust, false, null, this.printCustAddr);
                        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    }
                }
            }
            boolean bPrintHeading = true;
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT DISTINCT R.NAME FROM REFCODE R, RET_TRAND D WHERE D.\"ACTIVE\" = 1 AND D.LINE_TYPE in (0,2) AND D.RET_REASIDX = R.RCIDX AND D.VHIDX = " + sTransIdx);){
                while (sql.next()) {
                    if (bPrintHeading) {
                        Object[] objs = new Object[]{"\n"};
                        r1.PrintString("\u001b\u0007" + MessageFormat.format(StoreParams.res.getString("Return_Reason_s_n"), objs) + "\u001b\u0005");
                        bPrintHeading = false;
                    }
                    r1.PrintString(r1.FormatLeft(Gen.NVLString(sql.getString(1), " "), 56) + "\n");
                }
            }
            if (!bPrintHeading) {
                r1.Feed(2, PrintReceipt.DocketFormat.LONG_ONLY);
            }
            r1.PrintString("\u001b\u0007");
            r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_Credit_Inc_Tax"), 40));
            r1.PrintString(r1.FormatRight(sTotalCredit, 16) + "\n");
            r1.PrintString("\u001b\u0005");
            if (transType == 556L) {
                r1.Feed(1);
                r1.PrintString("\u001b\u0007");
                r1.PrintString(StoreParams.res.getString("Signature_1") + "\n");
                r1.Feed(1);
                r1.PrintString(StoreParams.res.getString("Date_1") + "\n");
                r1.Feed(1);
                r1.PrintString("\u001b\u0005");
            }
            r1.PrintBarcode("\u0002", this.sCreditNoteNum, "B", false);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void printLoadedVouchers(PrintReceipt r1, long vhidx) {
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT D.GVNUM, D.GROSS, D.GVGATE_DEFERRED_FLAG, D.GVGATE_BALANCE, D.GVGATE_RECEIPT_NUM, D.GVGATE_AUTHCODE, D.GVGATE_ISSUE_DATE, D.GVGATE_EXPIRY_DATE, D.GVGATE_REFERENCE, D.GVGATE_ISDIGITAL FROM RET_TRAND D WHERE D.\"ACTIVE\" = 1 AND D.LINE_TYPE = 2 AND D.VOUCHER_GATEWAY_IDX > 0 AND D.VHIDX = ? ORDER BY D.SEQUENCE_NUMBER", vhidx);){
            boolean headerPrinted = false;
            boolean isDigital = false;
            PosDateFormatter dateFormatter = null;
            while (sql.next()) {
                isDigital = sql.getBoolean("GVGATE_ISDIGITAL");
                if (!headerPrinted) {
                    headerPrinted = true;
                    dateFormatter = new PosDateFormatter(null);
                    dateFormatter.setFormat(3, 0);
                    r1.PrintString("________________________________________________________\n");
                    r1.PrintString("\u001b\u0007");
                    if (isDigital) {
                        r1.PrintString(r1.FormatCentre(MessageFormat.format(SP.getRS("digital_voucher_receipt_title"), "\n"), 56));
                    } else {
                        r1.PrintString(r1.FormatCentre(MessageFormat.format(SP.getRS("voucher_receipt_title"), "\n"), 56));
                    }
                    r1.PrintString("\u001b\u0005");
                    r1.PrintString("________________________________________________________\n");
                }
                if (!StringUtils.isNullOrEmpty(sql.getString("GVNUM"))) {
                    if (isDigital) {
                        r1.PrintString(r1.FormatLeft(SP.getRS("voucher_receipt_orderdo"), 20));
                    } else {
                        r1.PrintString(r1.FormatLeft(SP.getRS("voucher_receipt_cardno"), 20));
                    }
                    r1.PrintString(r1.FormatLeft(sql.getString("GVNUM"), 36) + "\n");
                }
                if (sql.getInt("GVGATE_DEFERRED_FLAG") > 0) {
                    if (isDigital) {
                        r1.PrintString("\u001b\u0007");
                        r1.PrintString(r1.FormatCentre(SP.getRS("voucher_receipt_deferred_order"), 56));
                        r1.PrintString("\u001b\u0005");
                    } else {
                        r1.PrintString(r1.FormatLeft(SP.getRS("voucher_receipt_load_amount"), 20));
                        r1.PrintString(r1.FormatLeft(this.dfDet.format(Gen.RoundNumber(sql.getDouble("GROSS"), this.nPrec)), 36) + "\n");
                        r1.PrintString("\u001b\u0007");
                        r1.PrintString(r1.FormatCentre(SP.getRS("voucher_receipt_deferred"), 56));
                        r1.PrintString("\u001b\u0005");
                    }
                } else {
                    if (isDigital) {
                        r1.PrintString(r1.FormatLeft(SP.getRS("voucher_ref"), 20));
                        r1.PrintString(r1.FormatLeft(sql.getString("GVGATE_REFERENCE"), 36) + "\n");
                    } else {
                        r1.PrintString(r1.FormatLeft(SP.getRS("voucher_receipt_balance"), 20));
                        r1.PrintString(r1.FormatLeft(this.dfDet.format(sql.getDouble("GVGATE_BALANCE")), 36) + "\n");
                    }
                    if (sql.getTimestamp("GVGATE_ISSUE_DATE") != null) {
                        dateFormatter.setTimestamp(sql.getTimestamp("GVGATE_ISSUE_DATE"));
                        r1.PrintString(r1.FormatLeft(SP.getRS("voucher_receipt_issue_date"), 20));
                        r1.PrintString(r1.FormatLeft(dateFormatter.toString(), 36) + "\n");
                    }
                    if (sql.getDate("GVGATE_EXPIRY_DATE") != null) {
                        dateFormatter.setTimestamp(sql.getTimestamp("GVGATE_EXPIRY_DATE"));
                        r1.PrintString(r1.FormatLeft(SP.getRS("voucher_receipt_expiry_date"), 20));
                        r1.PrintString(r1.FormatLeft(dateFormatter.toString(), 36) + "\n");
                    }
                }
                r1.PrintString("________________________________________________________\n");
            }
            if (headerPrinted) {
                String footer = this.comments.getString(isDigital ? (this.saleHasViiRefundVoucher() ? Comments.DocketTextType.VOUCHER_GATEWAY_DIGITAL_REFUND : Comments.DocketTextType.VOUCHER_GATEWAY_DIGITAL_FOOTER) : Comments.DocketTextType.VOUCHER_GATEWAY_LOAD_FOOTER);
                if (!StringUtils.isNullOrEmpty(footer)) {
                    r1.PrintCommentString(footer);
                    r1.PrintString("\u001b\u0001");
                    r1.PrintString("________________________________________________________\n");
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean printLayBy(Element root) throws DataConversionException {
        int i;
        this.bSaleHasACreditNote = false;
        for (i = 0; i < Gen.LAYBYS_CUST_COPIES; ++i) {
            boolean print = true;
            try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
                if (root.getChild("printCustCopy") != null) {
                    print = root.getChild("printCustCopy").getAttribute("print").getBooleanValue();
                }
                if (i == 0 && Gen.openTillRequired(this.conn, this.nTransIdx) && !this.reprint) {
                    r1.OpenCashDrawer();
                }
                if (print) {
                    if (!this.printHeader(HeaderType.LAYBY_CUST, r1)) {
                        this.errorHandler.setError("");
                        boolean bl = false;
                        return bl;
                    }
                    this.printOrderDetails(r1, root, Gen.DocketType.LAYBY, true);
                    this.printFooter(FooterType.LAYBY, r1);
                }
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
            if (!print) continue;
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            this.reprint = true;
        }
        this.resetReprint();
        for (i = 0; i < Gen.LAYBYS_STORE_COPIES; ++i) {
            try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
                if (!this.printHeader(HeaderType.LAYBY_STORE, r1)) {
                    this.errorHandler.setError("");
                    boolean bl = false;
                    return bl;
                }
                this.printOrderDetails(r1, root, Gen.DocketType.LAYBY, false);
                this.printFooter(FooterType.LAYBY, r1);
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            this.reprint = true;
        }
        this.resetReprint();
        if (this.bSaleHasACreditNote) {
            this.printCreditNote(false, root.getName().equals("person") ? root : root.getChild("person"), -1L);
        }
        if (!this.bSaleHasCredNoteGiftVouch) return true;
        this.printCreditNoteGiftVoucher(false, root.getName().equals("person") ? root : root.getChild("person"), -1L);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean printCustOrder(Element root) {
        Throwable throwable;
        PrintReceipt r1;
        int i;
        int nNumOfCustCopies = Gen.CUST_ORDERS_CUST_COPIES;
        int nNumOfStoreCopies = Gen.CUST_ORDERS_STORE_COPIES;
        if (this.isCustOrderCompletion()) {
            try {
                if (root.getAttribute("store_despatch") != null && root.getAttribute("store_despatch").getIntValue() == 1) {
                    nNumOfCustCopies = Gen.CUST_ORD_COMPL_DISPATCH_CUST_COPIES;
                    nNumOfStoreCopies = Gen.CUST_ORD_COMPL_DISPATCH_STORE_COPIES;
                } else {
                    nNumOfCustCopies = Gen.CUST_ORD_COMPL_PICKUP_CUST_COPIES;
                    nNumOfStoreCopies = Gen.CUST_ORD_COMPL_PICKUP_STORE_COPIES;
                }
            }
            catch (DataConversionException e) {
                this.errorHandler.setError((Exception)((Object)e));
                return false;
            }
        }
        this.bSaleHasACreditNote = false;
        for (i = 0; i < nNumOfCustCopies; ++i) {
            try {
                r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);
                throwable = null;
                try {
                    if (i == 0 && Gen.openTillRequired(this.conn, this.nTransIdx) && !this.reprint) {
                        r1.OpenCashDrawer();
                    }
                    if (!this.printHeader(HeaderType.CUST_ORDER_CUST, r1)) {
                        this.errorHandler.setError("");
                        boolean bl = false;
                        return bl;
                    }
                    this.printOrderDetails(r1, root, Gen.DocketType.CUST_ORDER, true);
                    this.printFooter(FooterType.CUST_ORDER, r1);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r1 != null) {
                        if (throwable != null) {
                            try {
                                r1.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            r1.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            this.reprint = true;
        }
        this.resetReprint();
        for (i = 0; i < nNumOfStoreCopies; ++i) {
            try {
                r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);
                throwable = null;
                try {
                    if (!this.printHeader(HeaderType.CUST_ORDER_STORE, r1)) {
                        this.errorHandler.setError("");
                        boolean bl = false;
                        return bl;
                    }
                    this.printOrderDetails(r1, root, Gen.DocketType.CUST_ORDER, false);
                    this.printFooter(FooterType.CUST_ORDER, r1);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (r1 != null) {
                        if (throwable != null) {
                            try {
                                r1.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            r1.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            this.reprint = true;
        }
        this.resetReprint();
        if (this.bSaleHasACreditNote) {
            this.printCreditNote(false, root.getName().equals("person") ? root : root.getChild("person"), -1L);
        }
        if (!this.bSaleHasCredNoteGiftVouch) return true;
        this.printCreditNoteGiftVoucher(false, root.getName().equals("person") ? root : root.getChild("person"), -1L);
        return true;
    }

    public boolean printCustOrderPickList(Element root) {
        try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
            if (root != null) {
                try {
                    r1.PrintString("\u001b\u0006");
                    r1.PrintString("\u001b\u0001");
                    r1.PrintString(r1.FormatCentre(StoreParams.res.getString("CUST_ORDER_PICKLIST"), 42));
                    r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                    r1.PrintString("\u001b\u0005");
                    r1.PrintString("\u001b\u0001");
                    r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    r1.PrintString("\u001b\u0007");
                    String orderNum = XMLUtils.getValue(root, "trans_number");
                    String storeno = root.getAttribute("widx") != null ? SP.sParams.getStore(root.getAttribute("widx").getLongValue()).getStoreNo() : "000";
                    r1.PrintString(r1.FormatCentre(StoreParams.res.getString("CustomerOrder_No_") + " O" + storeno + orderNum, 56));
                    String custRef = XMLUtils.getValue(root, "corder");
                    if (StringUtils.isNullOrEmpty(custRef)) {
                        custRef = XMLUtils.getValue(root, "notes2");
                    }
                    if (!StringUtils.isNullOrEmpty(custRef)) {
                        r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Customer_Reference_No") + " " + custRef, 56));
                    }
                    if (root.getAttribute("is_on_hold") != null && root.getAttribute("is_on_hold").getValue().equals("1")) {
                        r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Order_On_Hold_Title"), 56));
                        r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                    }
                    r1.PrintString("\u001b\u0005");
                    r1.PrintString("\u001b\u0001");
                    r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                    Element person = root.getName().equals("person") ? root : root.getChild("person");
                    this.printCustDets(r1, person, false, "", true);
                    if (root.getAttribute("store_despatch") != null && root.getAttribute("store_despatch").getIntValue() == 1) {
                        Element delivery_location = root.getName().equals("delivery_location") ? root : root.getChild("delivery_location");
                        this.printDeliveryLocation(delivery_location, r1);
                    }
                    long carrierIdx = PosUtils.longVal(XMLUtils.getValue(root, "carrier"));
                    long serviceTypeIdx = PosUtils.longVal(XMLUtils.getValue(root, "service_type"));
                    if (carrierIdx > 0L || serviceTypeIdx > 0L) {
                        r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                        if (carrierIdx > 0L) {
                            r1.PrintString(SP.getRS("Carrier_") + " " + Gen.getRefName(carrierIdx, this.conn) + "\n");
                        }
                        if (serviceTypeIdx > 0L) {
                            r1.PrintString(SP.getRS("Serv_Type_") + " " + Gen.getRefName(serviceTypeIdx, this.conn) + "\n");
                        }
                    }
                    if (root.getAttribute("delivery_instructions") != null && !StringUtils.isNullOrEmpty(root.getAttribute("delivery_instructions").getValue())) {
                        String instructions = r1.wordWrap(SP.getRS("Delivery_Instructions_") + " " + root.getAttribute("delivery_instructions").getValue(), 56);
                        r1.PrintString(instructions + "\n");
                    }
                    this.printNotesSection(root, r1);
                    this.printProductUnitsSection(root, r1, false, null);
                    String docketNumber = "D" + storeno + root.getAttribute("docket_number").getValue();
                    r1.PrintBarcode("\u0004", docketNumber, "B", false);
                    r1.PrintString(r1.FormatCentre(docketNumber, 56));
                    r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    r1.FeedAndCut();
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
        catch (IOException e) {
            this.errorHandler.setError(e);
            return false;
        }
        Gen.PrintImage(this.sPrinterPort, this.sImagePath);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean printReservation(Element root, boolean custCopy) {
        this.bSaleHasACreditNote = false;
        int nNumOfCopies = custCopy ? Gen.RESERVATIONS_CUST_COPIES : Gen.RESERVATIONS_STORE_COPIES;
        int i = 0;
        while (true) {
            if (i >= nNumOfCopies) {
                this.resetReprint();
                return true;
            }
            try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
                if (!this.printHeader(custCopy ? HeaderType.RESERVATION_CUST : HeaderType.RESERVATION_STORE, r1)) {
                    this.errorHandler.setError("");
                    boolean bl = false;
                    return bl;
                }
                this.printReservationDetails(r1, root, custCopy);
                this.printFooter(FooterType.RESERVATION, r1);
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            this.reprint = true;
            ++i;
        }
    }

    private void printOrderDetails(PrintReceipt r1, Element root, Gen.DocketType docketType, boolean bCustCopy) {
        double nRewardsRedemptionValue;
        PosDateFormatter dateFormatter;
        String eftDets;
        String sLayByNextPayDue;
        String sLayByDue;
        long nAdminSku;
        long nCancSku;
        block217: {
            nCancSku = 0L;
            nAdminSku = 0L;
            if (docketType == Gen.DocketType.LAYBY) {
                nCancSku = SP.sParams.lbCancFeeSku;
                nAdminSku = SP.sParams.lbAdminFeeSku;
            } else if (docketType == Gen.DocketType.SPECIAL_ORDER) {
                nCancSku = SP.sParams.specOrdCancFeeSku;
                nAdminSku = SP.sParams.specOrdAdminFeeSku;
            }
            String sTransNum = null;
            sLayByDue = null;
            sLayByNextPayDue = null;
            String sOrigStoreNo = "";
            String custRef = null;
            eftDets = "";
            dateFormatter = new PosDateFormatter(null);
            nRewardsRedemptionValue = 0.0;
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT H.TRANS_NUMBER, H.FROM_WIDX, H.LAYBY_DUE, COALESCE(H.CLIENTIDX, 0), L.PAYMENT_DUE, H.TR_TYPE, H.WIDX, H.TRAND, H.DOCKET_NUMBER, W.STORENO, COALESCE(H.OMNEO_REDEMPTION_VALUE,0) + COALESCE(H.REWARDS_REDEMPTION_VALUE,0), H.CORDER FROM RET_TRANH H LEFT JOIN LAYBY_PAYDUEDATES L ON H.TRANS_NUMBER = L.TRANS_NUMBER AND H.FROM_WIDX = L.FROM_WIDX LEFT JOIN WHSE W ON H.FROM_WIDX = W.WIDX WHERE VHIDX = " + this.nTransIdx + " ORDER BY L.LBIDX DESC");){
                if (sql.next()) {
                    sTransNum = Gen.NVLString(sql.getString(1), " ");
                    if (docketType == Gen.DocketType.LAYBY) {
                        try {
                            dateFormatter.setFormat(3, 0);
                        }
                        catch (Exception e) {
                            PosUtils.logError(e);
                        }
                        dateFormatter.setTimestamp(sql.getTimestamp(3));
                        sLayByDue = dateFormatter.toString();
                        dateFormatter.setTimestamp(sql.getTimestamp(5));
                        sLayByNextPayDue = dateFormatter.toString();
                    } else if (docketType == Gen.DocketType.SPECIAL_ORDER || docketType == Gen.DocketType.CUST_ORDER) {
                        sLayByDue = "";
                        sLayByNextPayDue = "";
                    }
                    sOrigStoreNo = sql.getString(10);
                    nRewardsRedemptionValue = sql.getDouble(11);
                    custRef = sql.getString("CORDER");
                    r1.PrintString("\u001b\u0001");
                    r1.PrintString("\u001b\u0007");
                    if (docketType == Gen.DocketType.LAYBY) {
                        r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Lay_by_No_") + " L" + sOrigStoreNo + sTransNum, 56) + "\n");
                    } else if (docketType == Gen.DocketType.SPECIAL_ORDER) {
                        r1.PrintString(r1.FormatCentre(StoreParams.res.getString("SpecialOrder_No_") + " S" + sOrigStoreNo + sTransNum, 56) + "\n");
                    } else if (docketType == Gen.DocketType.CUST_ORDER) {
                        r1.PrintString(r1.FormatCentre(StoreParams.res.getString("CustomerOrder_No_") + " O" + sOrigStoreNo + sTransNum, 56));
                        if (!StringUtils.isNullOrEmpty(custRef)) {
                            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Customer_Reference_No") + " " + custRef, 56));
                        }
                        r1.Feed(1);
                    }
                    r1.PrintString("\u001b\u0005");
                    break block217;
                }
                sLayByDue = "";
                sLayByNextPayDue = "";
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        Vector<String> vSkuIdxs = new Vector<String>();
        Vector<Trans> vTransactions = new Vector<Trans>();
        Vector<String> vVhIdxs = new Vector<String>();
        if (root != null) {
            Object cTrans;
            Iterator subtrans = root.getChildren("subtrans").iterator();
            while (subtrans.hasNext()) {
                try {
                    Element nextSubTrans = (Element)subtrans.next();
                    Attribute vhidx = nextSubTrans.getAttribute("vhidx");
                    Attribute attribute = nextSubTrans.getAttribute("trand");
                    Attribute tr_type = nextSubTrans.getAttribute("tr_type");
                    Attribute docket_number = nextSubTrans.getAttribute("docket_number");
                    Trans t = new Trans();
                    t.nVhidx = vhidx.getLongValue();
                    t.dateFormatter.setTimestampInternal(attribute.getValue());
                    t.nTrType = tr_type.getLongValue();
                    t.sDocketNumber = docket_number.getValue();
                    vVhIdxs.addElement(vhidx.getValue());
                    vTransactions.addElement(t);
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
            Iterator payments = root.getChildren("payments").iterator();
            while (payments.hasNext()) {
                try {
                    Element nextPayments = (Element)payments.next();
                    Attribute attribute = nextPayments.getAttribute("vhidx");
                    int index = vVhIdxs.indexOf(attribute.getValue());
                    Trans cTrans2 = (Trans)vTransactions.elementAt(index);
                    for (Element nextTender : nextPayments.getChildren()) {
                        Attribute rcidx = nextTender.getAttribute("payment_typeidx");
                        String sPayIdx = "";
                        if (rcidx != null) {
                            sPayIdx = rcidx.getValue();
                        }
                        Attribute payment_number = nextTender.getAttribute("payment_number");
                        String sPaymentNumber = "";
                        if (payment_number != null) {
                            sPaymentNumber = payment_number.getValue();
                        }
                        Attribute eftpos_cardtype = nextTender.getAttribute("eftpos_cardtype");
                        String sCardtype = "";
                        if (eftpos_cardtype != null) {
                            sCardtype = eftpos_cardtype.getValue();
                        }
                        Attribute eftpos_actype = nextTender.getAttribute("eftpos_actype");
                        String sEftAcType = "";
                        if (eftpos_actype != null) {
                            sEftAcType = eftpos_actype.getValue();
                        }
                        RcptTen cRcpTen = new RcptTen();
                        cRcpTen.nPayType = PosUtils.longVal(sPayIdx);
                        cRcpTen.sPayTypeName = Gen.getPayTypeName(sPayIdx, this.conn);
                        cRcpTen.nPayAmt = PosUtils.doubleValInternal(nextTender.getText());
                        cRcpTen.sPayNumber = sPaymentNumber;
                        if (sCardtype != null && sCardtype.length() > 0 && sEftAcType != null && sEftAcType.length() > 0) {
                            cRcpTen.sPayTypeName = sCardtype + " " + sEftAcType;
                        }
                        cTrans2.vTenders.addElement(cRcpTen);
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
            Iterator<Detail> styles = root.getChildren("styles").iterator();
            while (styles.hasNext()) {
                try {
                    Element element = (Element)styles.next();
                    Attribute vhidx = element.getAttribute("vhidx");
                    int index = vVhIdxs.indexOf(vhidx.getValue());
                    cTrans = (Trans)vTransactions.elementAt(index);
                    Iterator details = element.getChildren().iterator();
                    int nStyleCount = 0;
                    while (details.hasNext()) {
                        Element nextDetails = (Element)details.next();
                        String sTagName = nextDetails.getName();
                        if (sTagName.equals("discount")) {
                            Detail cDetail = ((Trans)cTrans).vDetails.elementAt(nStyleCount - 1);
                            Attribute reasonidx = nextDetails.getAttribute("reasonidx");
                            Attribute promoidx = nextDetails.getAttribute("promoidx");
                            Attribute loyalty = nextDetails.getAttribute("loyalty");
                            Attribute descrip1 = nextDetails.getAttribute("descrip1");
                            double nDiscPerc = PosUtils.doubleValInternal(nextDetails.getText());
                            String sReason = "";
                            if (promoidx != null && promoidx.getLongValue() != 0L && reasonidx != null && (reasonidx.getLongValue() == 720L || reasonidx.getLongValue() == 849L)) {
                                sReason = PromotionUtils.getPromoName(promoidx.getLongValue(), this.conn);
                            } else if (reasonidx != null && reasonidx.getLongValue() != 0L) {
                                sReason = Gen.getRefName(reasonidx.getLongValue(), this.conn);
                            }
                            String sLoyalty = loyalty.getValue();
                            Disc cDiscount = new Disc();
                            if (sLoyalty.equals("true")) {
                                cDiscount.sDiscName = reasonidx != null && reasonidx.getLongValue() == 786L && descrip1 != null && !descrip1.getValue().isEmpty() ? descrip1.getValue() : StoreParams.res.getString("Loyalty");
                                cDiscount.bLoyalty = true;
                            } else {
                                cDiscount.sDiscName = StoreParams.res.getString("Discount1");
                            }
                            cDiscount.nDiscReasIdx = reasonidx != null ? reasonidx.getLongValue() : 0L;
                            cDiscount.nPromoIdx = promoidx != null ? promoidx.getLongValue() : 0L;
                            cDiscount.sDiscReason = sReason;
                            cDiscount.nDiscPerc = nDiscPerc;
                            if (nextDetails.getAttribute("net") != null) {
                                cDiscount.nDiscAmt = nextDetails.getAttribute("net").getDoubleValue();
                            }
                            cDetail.vDiscounts.addElement(cDiscount);
                            continue;
                        }
                        Attribute skuidx = nextDetails.getAttribute("skuidx");
                        Attribute price = nextDetails.getAttribute("price");
                        Attribute taxper = nextDetails.getAttribute("taxper");
                        Attribute descrip1 = nextDetails.getAttribute("descrip1");
                        Attribute origPrice = nextDetails.getAttribute("orig_price");
                        Attribute mkdMsgIdx = nextDetails.getAttribute("pos_mkdmsgidx");
                        Attribute pickupQty = nextDetails.getAttribute("taken");
                        Attribute sohQty = nextDetails.getAttribute("soh_qty");
                        Attribute sCustomisation = nextDetails.getAttribute("customisation");
                        String sSkuIdx = skuidx.getValue();
                        double nPrice = price.getDoubleValue();
                        double nQty = PosUtils.doubleValInternal(nextDetails.getText());
                        double nPickupQty = pickupQty == null ? 0.0 : pickupQty.getDoubleValue();
                        double nNet = nPrice * nQty;
                        double nTaxPer = taxper.getDoubleValue();
                        double nOrigPrice = origPrice == null ? 0.0 : origPrice.getDoubleValue();
                        String sMkdMsg = "";
                        boolean bPrintOrigPrice = false;
                        if (mkdMsgIdx != null && !(nPrice >= nOrigPrice)) {
                            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT MSG, ORIG_FLAG FROM POS_MKDMSG WHERE MKDIDX = " + mkdMsgIdx.getLongValue());){
                                if (sql.next()) {
                                    sMkdMsg = Gen.NVLString(sql.getString(1), "");
                                    bPrintOrigPrice = sql.getBoolean(2);
                                }
                            }
                        }
                        String sAltStyleCode = "";
                        if (descrip1 != null) {
                            sAltStyleCode = descrip1.getValue();
                        }
                        Detail cDetail = new Detail();
                        cDetail.vNotes = nextDetails.getChildren("note");
                        cDetail.nSkuIdx = PosUtils.longVal(sSkuIdx);
                        cDetail.nPrice = nPrice;
                        cDetail.nSohQty = sohQty != null ? sohQty.getDoubleValue() : 0.0;
                        cDetail.nQty = nQty;
                        cDetail.nPickupQty = nPickupQty;
                        cDetail.nNet = nNet;
                        cDetail.nTaxPer = nTaxPer;
                        cDetail.sAltStyleCode = sAltStyleCode;
                        cDetail.nOrigPrice = nOrigPrice;
                        cDetail.bPrintOrigPrice = bPrintOrigPrice;
                        cDetail.giftProduct = nextDetails.getAttribute("gift_idx") != null && nextDetails.getAttribute("gift_idx").getValue().length() > 0;
                        cDetail.sMkdMsg = sMkdMsg;
                        if (sCustomisation != null) {
                            cDetail.sCustomisation = sCustomisation.getValue();
                        }
                        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT S.STYLECODE, S.NAME, C.CLRNAME, K.SIZEVAL FROM STYLE S, CLR C, SKU K WHERE K.CLRIDX = C.CLRIDX AND C.STYLEIDX = S.STYLEIDX AND K.SKUIDX = " + sSkuIdx);){
                            if (sql.next()) {
                                cDetail.sStyleCode = Gen.NVLString(sql.getString(1), "");
                                cDetail.sStyleName = Gen.NVLString(sql.getString(2), "");
                                cDetail.sStyleName = cDetail.sStyleName.substring(0, this.getMaxProdDescLen(cDetail.sStyleName));
                                cDetail.sClrName = Gen.NVLString(sql.getString(3), "");
                                cDetail.sSizeVal = Gen.NVLString(sql.getString(4), "");
                            }
                        }
                        int nSkuExists = vSkuIdxs.indexOf(sSkuIdx);
                        if (nSkuExists < 0) {
                            vSkuIdxs.addElement(sSkuIdx);
                        }
                        ((Trans)cTrans).vDetails.addElement(cDetail);
                        ++nStyleCount;
                    }
                }
                catch (Exception exception) {
                    PosUtils.logError(exception);
                }
            }
            try {
                Trans trans = new Trans();
                try (SqlQuery sql = new SqlQuery(this.conn, "SELECT DOCKET_NUMBER, TRAND, TR_TYPE FROM RET_TRANH WHERE VHIDX = " + this.nTransIdx);){
                    if (sql.next()) {
                        trans.nVhidx = this.nTransIdx;
                        trans.dateFormatter.setTimestamp(sql.getTimestamp(2));
                        trans.nTrType = sql.getLong(3);
                        trans.sDocketNumber = sql.getString(1);
                        vVhIdxs.addElement(String.valueOf(this.nTransIdx));
                        vTransactions.addElement(trans);
                    }
                }
                int nStyleCount = 0;
                SqlQuery sql = new SqlQuery(this.conn, "SELECT D.QTY, D.NET, D.TAXPER, S.STYLECODE, S.NAME, C.CLRNAME, K.SIZEVAL, D.PRICE, D.RET_REASIDX, D.DESCRIP1, D.LINE_TYPE, D.DISCOUNT_REASIDX, D.DISCOUNT_PER, K.SKUIDX, D.LINE_CODE, D.VSHIDX, D.ORIG_PRICE, M.MSG, M.ORIG_FLAG, D.TAKEN, D.PROMOIDX, D.GIFT_IDX FROM RET_TRAND D LEFT JOIN SKU K ON D.SKUIDX = K.SKUIDX LEFT JOIN CLR C ON K.CLRIDX = C.CLRIDX LEFT JOIN STYLE S ON C.STYLEIDX = S.STYLEIDX LEFT JOIN POS_MKDMSG M ON D.POS_MKDMSGIDX = M.MKDIDX WHERE D.\"ACTIVE\" = 1 AND D.LINE_TYPE IN(0,2,6,7) AND D.VHIDX = " + this.nTransIdx + " ORDER BY D.SEQUENCE_NUMBER ");
                cTrans = null;
                try {
                    while (sql.next()) {
                        int nLineType = sql.getInt(11);
                        if (nLineType == 6 || nLineType == 7) {
                            Disc cDiscount = new Disc();
                            Detail cDetail = trans.vDetails.elementAt(nStyleCount - 1);
                            cDiscount.nDiscPerc = sql.getDouble(13);
                            cDiscount.nDiscReasIdx = sql.getLong(12);
                            cDiscount.nPromoIdx = sql.getLong(21);
                            cDiscount.sDiscReason = cDiscount.nPromoIdx != 0L && (cDiscount.nDiscReasIdx == 720L || cDiscount.nDiscReasIdx == 849L) ? PromotionUtils.getPromoName(cDiscount.nPromoIdx, this.conn) : Gen.getRefName(cDiscount.nDiscReasIdx, this.conn);
                            cDiscount.sDiscName = sql.getString(10);
                            cDiscount.nDiscAmt = sql.getDouble(2);
                            cDetail.vDiscounts.addElement(cDiscount);
                            if (nLineType != 7) continue;
                            cDiscount.bLoyalty = true;
                            if (cDiscount.nDiscReasIdx == 786L && !sql.getString(10).isEmpty()) {
                                cDiscount.sDiscName = sql.getString(10).substring(0, Math.min(29, sql.getString(10).length()));
                                continue;
                            }
                            cDiscount.sDiscName = StoreParams.res.getString("Loyalty");
                            continue;
                        }
                        Detail cDetail = new Detail();
                        cDetail.vNotes = Note.getNotes(sql.getLong(16), "RET_TRAND", this.conn);
                        cDetail.nSkuIdx = sql.getLong(14);
                        cDetail.nPrice = sql.getDouble(8);
                        cDetail.nQty = sql.getDouble(1);
                        cDetail.nPickupQty = sql.getDouble(20);
                        cDetail.nNet = sql.getDouble(2);
                        cDetail.nTaxPer = sql.getDouble(3);
                        cDetail.nOrigPrice = sql.getDouble(17);
                        cDetail.sMkdMsg = Gen.NVLString(sql.getString(18), "");
                        cDetail.bPrintOrigPrice = sql.getBoolean(19);
                        boolean bl = cDetail.giftProduct = sql.getLong("GIFT_IDX") > 0L;
                        if (cDetail.nPrice >= cDetail.nOrigPrice) {
                            cDetail.bPrintOrigPrice = false;
                        }
                        cDetail.sStyleCode = Gen.NVLString(sql.getString(4), "");
                        cDetail.sStyleName = Gen.NVLString(sql.getString(5), "");
                        cDetail.sStyleName = cDetail.sStyleName.substring(0, this.getMaxProdDescLen(cDetail.sStyleName));
                        cDetail.sClrName = Gen.NVLString(sql.getString(6), "");
                        cDetail.sSizeVal = Gen.NVLString(sql.getString(7), "");
                        cDetail.sAltStyleCode = Gen.NVLString(sql.getString(10), "");
                        int nSkuExists = vSkuIdxs.indexOf(String.valueOf(cDetail.nSkuIdx));
                        if (nSkuExists < 0) {
                            vSkuIdxs.addElement(String.valueOf(cDetail.nSkuIdx));
                        }
                        trans.vDetails.addElement(cDetail);
                        ++nStyleCount;
                    }
                }
                catch (Throwable nLineType) {
                    cTrans = nLineType;
                    throw nLineType;
                }
                finally {
                    if (sql != null) {
                        if (cTrans != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable nLineType) {
                                ((Throwable)cTrans).addSuppressed(nLineType);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
                sql = new SqlQuery(this.conn, "SELECT  P.PAYMENT_AMOUNT, COALESCE(P.EFTPOS_CARDTYPE || ' ' || P.EFTPOS_ACTYPE, COALESCE(PT.ALT_CODE, R.NAME)), R.RCIDX, P.PAYMENT_NUMBER, P.EFTPOS_STAN, T.BLOBTEXT FROM RET_TRANP P LEFT JOIN EFT_TRANDETS E ON E.VSHIDX = P.VSHIDX LEFT JOIN BLOBTEXT T ON T.BLOBIDX = E.DOCKET_BLOBIDX, REFCODE R LEFT OUTER JOIN RET_PAY_TYPES PT ON R.RCIDX = PT.RCIDX WHERE P.\"ACTIVE\" = 1 AND P.PAYMENT_TYPEIDX = R.RCIDX AND R.RCIDX NOT IN (456,457,642,643, 716) AND P.VHIDX = " + this.nTransIdx + " ORDER BY P.SEQUENCE_NUMBER ");
                cTrans = null;
                try {
                    while (sql.next()) {
                        RcptTen cTender = new RcptTen();
                        cTender.nPayType = sql.getLong(3);
                        cTender.sPayTypeName = Gen.NVLString(sql.getString(2), "");
                        cTender.nPayAmt = sql.getDouble(1);
                        cTender.sPayNumber = sql.getString(4);
                        cTender.sStan = sql.getString(5);
                        trans.vTenders.addElement(cTender);
                        if (sql.getString(6) == null) continue;
                        eftDets = eftDets + sql.getString(6);
                    }
                }
                catch (Throwable throwable) {
                    cTrans = throwable;
                    throw throwable;
                }
                finally {
                    if (sql != null) {
                        if (cTrans != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)cTrans).addSuppressed(throwable);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                PosUtils.logError(exception);
            }
        }
        for (Trans t : vTransactions) {
            for (Detail detail : t.vDetails) {
                detail.fixValues();
            }
        }
        try {
            block223: {
                String sTranDate = null;
                String sSalesRep = null;
                Throwable throwable = null;
                try (SqlQuery sql = new SqlQuery(this.conn, "SELECT H.TRAND, COALESCE(P.FIRSTNAME, '') FROM RET_TRANH H LEFT JOIN PERSON P ON " + this.servedByJoin + " = P.PERIDX WHERE H.\"ACTIVE\" = 1 AND H.VHIDX = " + this.nTransIdx);){
                    if (!sql.next()) break block223;
                    try {
                        dateFormatter.setFormat(3, 3, 2);
                        dateFormatter.setTimestamp(sql.getTimestamp(1));
                        sTranDate = dateFormatter.toString();
                    }
                    catch (Exception dateEx) {
                        sTranDate = "";
                    }
                    sSalesRep = sql.getString(2);
                    r1.PrintString("\u001b\u0005");
                    r1.PrintString("\u001b\u0001");
                    r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Docket_No_"), StoreParams.res.getString("Served_By"), this.sTillNumText, StoreParams.res.getString("Date_Time")) + "\n");
                    r1.PrintString(r1.FormatDetailHdr(this.sDocNum, sSalesRep, this.sTillNum, sTranDate) + "\n");
                }
                catch (Throwable dateEx) {
                    Throwable throwable2 = dateEx;
                    throw dateEx;
                }
            }
            r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
            r1.PrintString("\u001b\u0001");
            if (root == null) {
                r1.PrintString("\u001b\u0007");
                r1.PrintString(StoreParams.res.getString("Customer_Details_") + "\n");
                r1.PrintString("\u001b\u0005");
            } else {
                long l;
                Element person = root.getName().equals("person") ? root : root.getChild("person");
                long l2 = l = root.getName().equals("person") ? this.nTransIdx : root.getAttribute("vhidx").getLongValue();
                if (root.getAttribute("fromtransin") != null && root.getAttribute("fromtransin").getValue().equals("1")) {
                    l = this.nTransIdx;
                }
                this.printCustDets(r1, person, false, this.getLoyaltyCards(l, person), !bCustCopy || this.printCustAddr);
            }
            r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
            this.printDeliveryAddress(r1, this.nTransIdx);
            r1.PrintString("\u001b\u0007");
            r1.PrintString(StoreParams.res.getString("Product_Description_n") + "\n");
            r1.PrintString("\u001b\u0005");
            String sDiscPer = null;
            boolean bl = false;
            double nTotalUnits = 0.0;
            double nTotalReturns = 0.0;
            double nTotalNet = 0.0;
            double nTotalTax = 0.0;
            double nTotalDiscount = 0.0;
            boolean bOrderHasQtys = false;
            for (int nMainCnt = 0; nMainCnt < vSkuIdxs.size(); ++nMainCnt) {
                Detail cFinalDetail = new Detail();
                double nDiscNet = 0.0;
                for (int nTransCnt = 0; nTransCnt < vTransactions.size(); ++nTransCnt) {
                    Trans cTrans = (Trans)vTransactions.elementAt(nTransCnt);
                    for (int nDetsCnt = 0; nDetsCnt < cTrans.vDetails.size(); ++nDetsCnt) {
                        Detail cDetail = cTrans.vDetails.elementAt(nDetsCnt);
                        if (cDetail.nSkuIdx == PosUtils.longVal(vSkuIdxs.elementAt(nMainCnt))) {
                            cFinalDetail.nSkuIdx = cDetail.nSkuIdx;
                            cFinalDetail.nPrice = cDetail.nPrice;
                            cFinalDetail.nQty += cDetail.nQty;
                            cFinalDetail.nPickupQty += cDetail.nPickupQty;
                            cFinalDetail.nNet += cDetail.nNet;
                            cFinalDetail.nTaxPer = cDetail.nTaxPer;
                            cFinalDetail.sStyleCode = cDetail.sStyleCode;
                            cFinalDetail.sStyleName = cDetail.sStyleName;
                            cFinalDetail.sClrName = cDetail.sClrName;
                            cFinalDetail.sSizeVal = cDetail.sSizeVal;
                            cFinalDetail.sAltStyleCode = cDetail.sAltStyleCode;
                            cFinalDetail.vNotes = cDetail.vNotes;
                            cFinalDetail.nOrigPrice = cDetail.nOrigPrice;
                            cFinalDetail.sMkdMsg = cDetail.sMkdMsg;
                            cFinalDetail.bPrintOrigPrice = cDetail.bPrintOrigPrice;
                            cFinalDetail.giftProduct = cFinalDetail.giftProduct || cDetail.giftProduct;
                            cFinalDetail.fixValues();
                            if (!cFinalDetail.bPrintOrigPrice) {
                                cFinalDetail.sOrigPrice = "";
                                cFinalDetail.sMkdMsg = "";
                            } else {
                                cFinalDetail.sOrigPrice = this.dfDet.format(cFinalDetail.nOrigPrice);
                                Object[] objs = new Object[]{cFinalDetail.sOrigPrice};
                                cFinalDetail.sOrigPrice = MessageFormat.format(StoreParams.res.getString("orig_price_text"), objs);
                            }
                            if (!cFinalDetail.giftProduct) {
                                double initialDisc = 0.0;
                                for (int nDiscCnt = 0; nDiscCnt < cDetail.vDiscounts.size(); ++nDiscCnt) {
                                    Disc cDiscount = cDetail.vDiscounts.elementAt(nDiscCnt);
                                    if (cDiscount.nDiscAmt == 0.0) {
                                        nDiscNet = cDiscount.bLoyalty ? (nDiscNet += Gen.RoundNumber(cDiscount.nDiscPerc * (cDetail.nNet + initialDisc) / 100.0 * -1.0, this.nPrec)) : (nDiscNet += Gen.RoundNumber(cDiscount.nDiscPerc * cDetail.nNet / 100.0 * -1.0, this.nPrec));
                                        if (nDiscCnt != 0 || cDiscount.bLoyalty) continue;
                                        initialDisc = nDiscNet;
                                        continue;
                                    }
                                    nDiscNet += cDiscount.nDiscAmt;
                                }
                            }
                        }
                        if (String.valueOf(cDetail.nSkuIdx) != VoucherUtils.getCreditNoteGiftVoucherSKU()) continue;
                        this.bSaleHasCredNoteGiftVouch = true;
                    }
                }
                nTotalDiscount += nDiscNet;
                nTotalNet = nTotalNet + cFinalDetail.nNet + nDiscNet;
                if (cFinalDetail.nQty > 0.0 && cFinalDetail.nSkuIdx != nCancSku && cFinalDetail.nSkuIdx != nAdminSku) {
                    nTotalUnits += cFinalDetail.nQty;
                } else {
                    nTotalReturns += cFinalDetail.nQty;
                }
                nTotalTax = nTotalTax + (cFinalDetail.nNet - cFinalDetail.nNet / (1.0 + cFinalDetail.nTaxPer / 100.0)) + (nDiscNet - nDiscNet / (1.0 + cFinalDetail.nTaxPer / 100.0));
                if (Gen.RoundNumber(cFinalDetail.nQty, this.nPrec) == 0.0) continue;
                bOrderHasQtys = true;
                if (cFinalDetail.nTaxPer != 0.0) {
                    cFinalDetail.sStyleName = "* " + cFinalDetail.sStyleName;
                    if (!Gen.NVLString(cFinalDetail.sAltStyleCode, "").equals("")) {
                        cFinalDetail.sAltStyleCode = "* " + cFinalDetail.sAltStyleCode;
                    }
                } else {
                    cFinalDetail.sStyleName = "  " + cFinalDetail.sStyleName;
                    if (!Gen.NVLString(cFinalDetail.sAltStyleCode, "").equals("")) {
                        cFinalDetail.sAltStyleCode = "  " + cFinalDetail.sAltStyleCode;
                    }
                }
                if (Gen.NVLString(cFinalDetail.sAltStyleCode, "").equals("")) {
                    r1.PrintString(r1.FormatLeft(cFinalDetail.sStyleName + (cFinalDetail.sClrName.length() > 0 ? " " + cFinalDetail.sClrName : "") + (cFinalDetail.sSizeVal.length() > 0 ? " " + cFinalDetail.sSizeVal : ""), 56) + "\n");
                } else {
                    r1.PrintString(r1.FormatLeft(cFinalDetail.sAltStyleCode, 56) + "\n");
                }
                if (!(docketType != Gen.DocketType.LAYBY && docketType != Gen.DocketType.SPECIAL_ORDER || cFinalDetail.nSkuIdx != nCancSku && cFinalDetail.nSkuIdx != nAdminSku)) {
                    r1.PrintString(r1.FormatLeft("  " + cFinalDetail.sStyleCode, 40));
                } else {
                    String price = cFinalDetail.giftProduct ? "" : " " + this.dfDet.format(cFinalDetail.nPrice);
                    r1.PrintString(r1.FormatLeft("  " + cFinalDetail.sStyleCode + price + " x " + this.dfQty.format(Gen.RoundNumber(cFinalDetail.nQty, this.nPrec)) + StoreParams.res.getString("units"), 40));
                }
                String net = cFinalDetail.giftProduct ? SP.getRS("GIFT") : this.dfDet.format(cFinalDetail.nNet);
                r1.PrintString(r1.FormatRight(net, 16) + "\n");
                if (cFinalDetail.sMkdMsg.length() > 0) {
                    r1.PrintString("  " + cFinalDetail.sMkdMsg + "\n");
                }
                if (cFinalDetail.bPrintOrigPrice) {
                    r1.PrintString("  " + cFinalDetail.sOrigPrice + "\n");
                }
                if (Gen.RoundNumber(nDiscNet, this.nPrec) != 0.0) {
                    r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Discount"), 40));
                    r1.PrintString(r1.FormatRight(this.dfDet.format(nDiscNet), 16) + "\n");
                }
                this.printNotes(r1, cFinalDetail.vNotes, false);
            }
            if (this.bPrintTotUnits) {
                r1.PrintString("\u001b\u0007");
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                if (nTotalUnits > 0.0) {
                    Object[] objs = new Object[]{this.dfQty.format(nTotalUnits)};
                    r1.PrintString(r1.FormatLeft("  " + MessageFormat.format(StoreParams.res.getString("total_units"), objs), 40) + "\n");
                }
                if (nTotalReturns < 0.0) {
                    Object[] objs = new Object[]{this.dfQty.format(nTotalReturns * -1.0)};
                    r1.PrintString(r1.FormatLeft("  " + MessageFormat.format(StoreParams.res.getString("total_returns"), objs), 40) + "\n");
                }
                r1.PrintString("\u001b\u0005");
            }
            boolean bPrintSignature = false;
            if (!bOrderHasQtys) {
                Object[] objs = new Object[]{"\n"};
                if (docketType == Gen.DocketType.LAYBY) {
                    r1.PrintString(MessageFormat.format(StoreParams.res.getString("Lay_by_Cancelled_n"), objs));
                } else if (docketType == Gen.DocketType.SPECIAL_ORDER) {
                    r1.PrintString(MessageFormat.format(StoreParams.res.getString("SpecialOrder_Cancelled_n"), objs));
                } else if (docketType == Gen.DocketType.CUST_ORDER) {
                    r1.PrintString(MessageFormat.format(StoreParams.res.getString("CustomerOrder_Cancelled_n"), objs));
                }
            } else {
                int nRightLength;
                int nLeftLength;
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                if (this.bLargeFontForTotals) {
                    r1.PrintString("\u001b\u0006");
                    nLeftLength = 30;
                    nRightLength = 12;
                } else {
                    r1.PrintString("\u001b\u0007");
                    nLeftLength = 40;
                    nRightLength = 16;
                }
                r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_Inc_Tax"), nLeftLength));
                r1.PrintString(r1.FormatRight(this.dfTot.format(nTotalNet), nRightLength));
                r1.PrintString("\u001b\u0005");
                nTotalTax = Gen.RoundNumber(nTotalTax, this.nPrec);
                if (nTotalTax != 0.0) {
                    r1.PrintString(r1.FormatRight(StoreParams.res.getString("Tax"), 40));
                    r1.PrintString(r1.FormatRight(this.dfTot.format(nTotalTax), 16));
                }
                if ((nTotalDiscount = Gen.RoundNumber(nTotalDiscount + nRewardsRedemptionValue, this.nPrec)) != 0.0) {
                    r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_Discount"), 40));
                    r1.PrintString(r1.FormatRight(this.dfTot.format(nTotalDiscount), 16));
                }
                if ((nRewardsRedemptionValue = Gen.RoundNumber(nRewardsRedemptionValue * -1.0, this.nPrec)) != 0.0) {
                    r1.PrintString(r1.FormatRight(StoreParams.res.getString("Rewards_Redeemed"), 40));
                    r1.PrintString(r1.FormatRight(this.dfTot.format(nRewardsRedemptionValue), 16));
                }
            }
            r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
            r1.Feed(1, PrintReceipt.DocketFormat.SHORT_ONLY);
            r1.PrintString("\u001b\u0007");
            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Transaction_History_Details_"), 56) + "\n");
            r1.PrintString("\u001b\u0005");
            double nTotPaid = 0.0;
            double nTotDue = 0.0;
            String sPickUpTitle = "";
            String sOrderTitle = "";
            if (docketType == Gen.DocketType.CUST_ORDER) {
                sPickUpTitle = StoreParams.res.getString("PickUp") + " ";
                sOrderTitle = StoreParams.res.getString("Order") + " ";
            }
            for (int nTrCnt = 0; nTrCnt < vTransactions.size(); ++nTrCnt) {
                Trans cTrans = (Trans)vTransactions.elementAt(nTrCnt);
                r1.PrintString(r1.FormatLeft(cTrans.dateFormatter.toString() + " Transaction " + (nTrCnt + 1), 56) + "\n");
                for (int nSkuCnt = 0; nSkuCnt < cTrans.vDetails.size(); ++nSkuCnt) {
                    Detail cDetail = cTrans.vDetails.elementAt(nSkuCnt);
                    if (Gen.RoundNumber(cDetail.nQty, this.nPrec) != 0.0) {
                        if (!(docketType != Gen.DocketType.LAYBY && docketType != Gen.DocketType.SPECIAL_ORDER || cDetail.nSkuIdx != nCancSku && cDetail.nSkuIdx != nAdminSku)) {
                            r1.PrintString(r1.FormatLeft("    " + cDetail.sStyleCode, 36));
                        } else {
                            r1.PrintString(r1.FormatLeft("    " + sOrderTitle + cDetail.sStyleCode + (cDetail.sClrName.length() > 0 ? " " + cDetail.sClrName : "") + (cDetail.sSizeVal.length() > 0 ? " " + cDetail.sSizeVal : "") + " x " + this.dfQty.format(Gen.RoundNumber(cDetail.nQty, this.nPrec)), 36));
                        }
                        String net = cDetail.giftProduct ? SP.getRS("GIFT") : this.dfDet.format(cDetail.nNet);
                        r1.PrintString(r1.FormatRight(net, 16) + "\n");
                        nTotDue += cDetail.nNet;
                    }
                    if (docketType == Gen.DocketType.CUST_ORDER && Gen.RoundNumber(cDetail.nPickupQty, this.nPrec) != 0.0) {
                        r1.PrintString(r1.FormatLeft("    " + sPickUpTitle + cDetail.sStyleCode + (cDetail.sClrName.length() > 0 ? " " + cDetail.sClrName : "") + (cDetail.sSizeVal.length() > 0 ? " " + cDetail.sSizeVal : "") + " x " + this.dfQty.format(Gen.RoundNumber(cDetail.nPickupQty, this.nPrec)), 36));
                        r1.Feed(1);
                    }
                    double initialDisc = 0.0;
                    for (int nDiscCnt = 0; nDiscCnt < cDetail.vDiscounts.size(); ++nDiscCnt) {
                        Disc cDiscount = cDetail.vDiscounts.elementAt(nDiscCnt);
                        double nDiscNet = cDiscount.nDiscAmt;
                        if (nDiscNet == 0.0) {
                            nDiscNet = cDiscount.bLoyalty ? Gen.RoundNumber(cDiscount.nDiscPerc * (cDetail.nNet + initialDisc) / 100.0 * -1.0, this.nPrec) : Gen.RoundNumber(cDiscount.nDiscPerc * cDetail.nNet / 100.0 * -1.0, this.nPrec);
                            if (nDiscCnt == 0 && !cDiscount.bLoyalty) {
                                initialDisc = nDiscNet;
                            }
                        }
                        nTotDue += nDiscNet;
                        sDiscPer = this.bPrintDiscountPercent && Gen.RoundNumber(cDiscount.nDiscPerc, 2) != 0.0 ? " " + this.dfQty.format(Gen.RoundNumber(cDiscount.nDiscPerc, 2)) + "%" : "";
                        int n = cDiscount.sDiscName.length() + 4 + 2;
                        r1.PrintString("\u001b\u0007    " + cDiscount.sDiscName + ": " + "\u001b\u0005" + r1.FormatLeft(cDiscount.sDiscReason, Math.max(35 - n, 0)) + r1.FormatLeft(sDiscPer, 7));
                        r1.PrintString(r1.FormatRight(this.dfDet.format(nDiscNet), 10) + "\n");
                    }
                    this.printNotes(r1, cDetail.vNotes, false, "  ");
                }
                boolean bfoundAccPayment = false;
                for (int nPayCnt = 0; nPayCnt < cTrans.vTenders.size(); ++nPayCnt) {
                    RcptTen cTender = cTrans.vTenders.elementAt(nPayCnt);
                    if (cTender.nPayType != 647L) continue;
                    if (!bfoundAccPayment) {
                        r1.PrintString("\u001b\u0007");
                        bfoundAccPayment = true;
                        bPrintSignature = true;
                    }
                    r1.PrintString(r1.FormatLeft("    " + cTender.sPayTypeName, 36));
                    r1.PrintString(r1.FormatRight(this.dfDet.format(cTender.nPayAmt * -1.0), 16) + "\n");
                    nTotPaid += cTender.nPayAmt;
                }
                r1.PrintString("\u001b\u0005");
                String sRemainingValue = "";
                String sVoucherName = "";
                for (RcptTen cTen : cTrans.vTenders) {
                    PayType payType = PayTypes.getPayType(cTen.nPayType);
                    if (cTen.nPayType == 456L || cTen.nPayType == 457L || cTen.nPayType == 642L || cTen.nPayType == 643L || cTen.nPayType == 647L || cTen.nPayType == 716L) continue;
                    String sPayTypeName = cTen.sPayTypeName;
                    double nPayAmt = cTen.nPayAmt;
                    String sStan = cTen.sStan;
                    if (payType.isAccount) {
                        bPrintSignature = true;
                    }
                    if (cTen.nPayType != 518L && !payType.isCreditNote && nPayAmt < 0.0) {
                        sPayTypeName = StoreParams.res.getString("Change_") + sPayTypeName + ")";
                    } else if (cTen.nPayType != 518L && nPayAmt > 0.0) {
                        if (cTen.nPayType == 795L) {
                            String string = sPayTypeName = sStan.equals(null) || sStan.equals("") ? StoreParams.res.getString("Deposit_") + " " + sPayTypeName : StoreParams.res.getString("Deposit_") + " " + sPayTypeName + " " + StoreParams.res.getString("zippay_ref_receipt") + ": " + sStan;
                        }
                        sPayTypeName = cTen.nPayType == 850L ? (sStan.equals(null) || sStan.equals("") ? StoreParams.res.getString("Deposit_") + " " + sPayTypeName : StoreParams.res.getString("Deposit_") + " " + sPayTypeName + " " + StoreParams.res.getString("openpay_ref_receipt") + ": " + sStan) : StoreParams.res.getString("Deposit_") + " " + sPayTypeName;
                    }
                    if (payType.isCreditNote) {
                        if (!Gen.NVLString(cTen.sPayNumber, "").equals("")) {
                            sPayTypeName = sPayTypeName + ": " + cTen.sPayNumber;
                        }
                        if (nPayAmt < 0.0 && cTrans.nVhidx == this.nTransIdx) {
                            this.bSaleHasACreditNote = true;
                        }
                    }
                    sRemainingValue = "";
                    if (PayTypes.getPayType((long)cTen.nPayType).isVoucher && !Gen.NVLString(cTen.sPayNumber, "").equals("")) {
                        VoucherLoadAdapter voucherAdapter = new VoucherLoadAdapter();
                        voucherAdapter.processNumber(cTen.sPayNumber);
                        if (voucherAdapter.getVoucher() != null) {
                            sVoucherName = StoreParams.res.getString("Deposit_") + " " + voucherAdapter.getVoucher().getVoucherType().getName();
                            if (sVoucherName.length() > 20) {
                                sVoucherName = sVoucherName.substring(0, 20);
                            }
                            sPayTypeName = sVoucherName + ": " + voucherAdapter.getVoucher().getDisplayNumber();
                            if (voucherAdapter.getVoucher().getVoucherType().getBalanceRules() == VoucherType.BalanceRules.RETAIN_VALUE) {
                                Object[] objs = new Object[]{this.dfDet.format(voucherAdapter.getVoucher().getAvailableAmount())};
                                sRemainingValue = MessageFormat.format(StoreParams.res.getString("remaining_voucher_amount"), objs);
                            }
                        } else {
                            sPayTypeName = sPayTypeName + ": " + cTen.sPayNumber;
                        }
                    }
                    double nDisplayPayAmt = nPayAmt;
                    if (cTen.nPayType == 518L && (nDisplayPayAmt = Gen.RoundNumber(nDisplayPayAmt, this.nPrec)) != 0.0) {
                        nDisplayPayAmt *= -1.0;
                    }
                    nTotPaid += nPayAmt;
                    r1.PrintString(r1.FormatLeft("    " + sPayTypeName, 36));
                    r1.PrintString(r1.FormatRight(this.dfDet.format(nDisplayPayAmt), 16) + "\n");
                    if (sRemainingValue.equals("")) continue;
                    r1.PrintString(r1.FormatLeft("    " + sRemainingValue, 36) + "\n");
                }
            }
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
            r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_Deposits_"), 40));
            r1.PrintString(r1.FormatRight(this.dfTot.format(Gen.RoundNumber(nTotPaid, this.nPrec)), 16));
            String sBalanceOutstanding = this.dfTot.format(Gen.RoundNumber(nTotDue - nTotPaid, this.nPrec));
            r1.PrintString("\u001b\u0007");
            r1.PrintString(r1.FormatRight(StoreParams.res.getString("Balance_Outstanding_"), 40));
            r1.PrintString(r1.FormatRight(sBalanceOutstanding, 16) + "\n");
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
            if (docketType == Gen.DocketType.LAYBY) {
                if (Gen.RoundNumber(nTotDue - nTotPaid, this.nPrec) != 0.0 && !sLayByNextPayDue.equals("")) {
                    r1.PrintString(r1.FormatRight(StoreParams.res.getString("Next_Payment_Due_"), 40));
                    r1.PrintString(r1.FormatRight(sLayByNextPayDue, 16) + "\n");
                }
                if (Gen.RoundNumber(nTotDue - nTotPaid, this.nPrec) != 0.0 && !sLayByDue.equals("")) {
                    r1.PrintString(r1.FormatRight(StoreParams.res.getString("Final_Payment_Due_"), 40));
                    r1.PrintString(r1.FormatRight(sLayByDue, 16) + "\n");
                }
            }
            this.printEftDets(r1, eftDets);
            r1.PrintString("\u001b\u0005");
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
            if (bPrintSignature) {
                this.printSignature(r1);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void printReservationDetails(PrintReceipt r1, Element person, boolean custCopy) {
        double nTaxPer = 0.0;
        String sAltStyleCode = null;
        int nLineType = 0;
        double nAvailQty = 0.0;
        PosDateFormatter dateFormatter = new PosDateFormatter(null);
        try {
            int nRightLength;
            int nLeftLength;
            Object sStyleName;
            String sCost;
            String sOrigPrice;
            String sPrice;
            String sQty;
            boolean bPrintOrigPrice;
            String sMkdMsg;
            double nOrigPrice;
            double nPrice;
            double nNet;
            double nQty;
            block91: {
                try (SqlQuery sql = new SqlQuery(this.conn, "SELECT H.VHIDX, H.DOCKET_NUMBER, H.TRANSSREPIDX, H.TRAND, H.TRAND, COALESCE(P.FIRSTNAME, ''), H.TRANS_NUMBER, H.TR_TYPE, H.NOTES1 FROM RET_TRANH H LEFT JOIN PERSON P ON " + this.servedByJoin + " = P.PERIDX  WHERE H.\"ACTIVE\" = 1 AND H.VHIDX = " + this.nTransIdx);){
                    String sTranDate;
                    if (!sql.next()) break block91;
                    r1.PrintString("\u001b\u0001");
                    r1.PrintString("\u001b\u0007");
                    r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Reservation_No") + " R" + this.sStoreNum + sql.getString(2), 56) + "\n");
                    r1.PrintString("\u001b\u0005");
                    try {
                        dateFormatter.setFormat(3, 3, 2);
                        dateFormatter.setTimestamp(sql.getTimestamp(4));
                        sTranDate = dateFormatter.toString();
                    }
                    catch (Exception e) {
                        sTranDate = "";
                    }
                    String sSalesRep = sql.getString(6);
                    r1.PrintString("\u001b\u0005");
                    r1.PrintString("\u001b\u0001");
                    r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Docket_No_"), StoreParams.res.getString("Served_By"), this.sTillNumText, StoreParams.res.getString("Date_Time")) + "\n");
                    r1.PrintString(r1.FormatDetailHdr(this.sDocNum, sSalesRep, this.sTillNum, sTranDate) + "\n");
                    r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    if (person != null) {
                        this.printCustDets(r1, person, false, null, !custCopy);
                        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    }
                    this.printNotes(r1, Note.getNotes(sql.getLong(1), "RET_TRANH", this.conn), true);
                }
            }
            String qtyDesc = "COALESCE(D.QTY,0)";
            if (!custCopy) {
                qtyDesc = "COALESCE(D.QTY_AVAIL,0)";
            }
            double nTotalCost = 0.0;
            double nTotalTax = 0.0;
            double nTotalUnits = 0.0;
            double nStyleTotalTax = 0.0;
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT D.QTY, D.NET, D.TAXPER, S.STYLECODE, S.NAME, C.CLRNAME, K.SIZEVAL, D.PRICE, D.GROSS, D.RET_REASIDX, D.DESCRIP1, D.LINE_TYPE, D.DISCOUNT_REASIDX, D.QTY_AVAIL, D.ORIG_PRICE, M.MSG, M.ORIG_FLAG, D.EXT_TAXRATE FROM RET_TRAND D LEFT JOIN SKU K ON D.SKUIDX = K.SKUIDX LEFT JOIN CLR C ON K.CLRIDX = C.CLRIDX LEFT JOIN STYLE S ON C.STYLEIDX = S.STYLEIDX LEFT JOIN POS_MKDMSG M ON D.POS_MKDMSGIDX = M.MKDIDX WHERE D.\"ACTIVE\" = 1 AND D.VHIDX = " + this.nTransIdx + " AND " + qtyDesc + ">0 ORDER BY D.SEQUENCE_NUMBER ");){
                while (sql.next()) {
                    if (sql.getRow() == 1) {
                        if (!custCopy) {
                            r1.PrintString("\u001b\u0007");
                            r1.PrintString("\u001b\u0001");
                            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Reserved_Stock"), 56));
                            r1.PrintString("\u001b\u0005");
                        }
                        r1.PrintString("\u001b\u0007" + StoreParams.res.getString("Product_Description_n") + "\u001b\u0005" + "\n");
                    }
                    nQty = sql.getDouble(1);
                    nAvailQty = sql.getDouble(14);
                    nLineType = sql.getInt(12);
                    if (nLineType == 0 || nLineType == 2) {
                        if (this.bUsingExtTax && nStyleTotalTax != 0.0) {
                            nStyleTotalTax = Gen.RoundNumber(nStyleTotalTax, this.nPrec);
                            nTotalTax = Gen.RoundNumber(nTotalTax, this.nPrec);
                            if (this.showTaxRate) {
                                r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("tax_at") + " " + this.dfQty.format(Gen.RoundNumber(nTaxPer, 4)) + "%", 40));
                            } else {
                                r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("Tax"), 40));
                            }
                            r1.PrintString(r1.FormatRight(this.dfDet.format(nStyleTotalTax), 16) + "\n");
                            nStyleTotalTax = 0.0;
                        }
                        nTaxPer = this.bUsingExtTax ? sql.getDouble(18) : sql.getDouble(3);
                    }
                    nNet = sql.getDouble(2);
                    nPrice = sql.getDouble(8);
                    nOrigPrice = sql.getDouble(15);
                    sMkdMsg = Gen.NVLString(sql.getString(16), "");
                    bPrintOrigPrice = sql.getBoolean(17);
                    if (nPrice >= nOrigPrice) {
                        bPrintOrigPrice = false;
                    }
                    if (!custCopy && nQty > nAvailQty) {
                        nNet = nNet * nAvailQty / nQty;
                        nQty = nAvailQty;
                    }
                    sAltStyleCode = sql.getString(11);
                    sQty = this.dfQty.format(nQty);
                    sPrice = this.dfDet.format(nPrice);
                    sOrigPrice = this.dfDet.format(nOrigPrice);
                    sCost = this.dfDet.format(nNet);
                    nTotalCost += nNet;
                    nTotalUnits += nQty;
                    if (this.bUsingExtTax) {
                        nTotalTax += nNet * nTaxPer / 100.0;
                        nStyleTotalTax += nNet * nTaxPer / 100.0;
                    } else {
                        nTotalTax += nNet - nNet / (1.0 + nTaxPer / 100.0);
                    }
                    String sStyleCode = Gen.NVLString(sql.getString(4), "");
                    sStyleName = Gen.NVLString(sql.getString(5), "");
                    sStyleName = ((String)sStyleName).substring(0, this.getMaxProdDescLen((String)sStyleName));
                    String sClrName = Gen.NVLString(sql.getString(6), "");
                    String sSizeVal = Gen.NVLString(sql.getString(7), "");
                    if (!bPrintOrigPrice) {
                        sOrigPrice = "";
                        sMkdMsg = "";
                    } else {
                        Object[] objs = new Object[]{sOrigPrice};
                        sOrigPrice = MessageFormat.format(StoreParams.res.getString("orig_price_text"), objs);
                    }
                    if (!this.bUsingExtTax && nTaxPer != 0.0) {
                        sStyleName = "* " + (String)sStyleName;
                        if (sAltStyleCode != null) {
                            sAltStyleCode = "* " + sAltStyleCode;
                        }
                    } else {
                        sStyleName = "  " + (String)sStyleName;
                        if (sAltStyleCode != null) {
                            sAltStyleCode = "  " + sAltStyleCode;
                        }
                    }
                    if (sAltStyleCode == null) {
                        r1.PrintString(r1.FormatLeft((String)sStyleName + (sClrName.length() > 0 ? " " + sClrName : "") + (sSizeVal.length() > 0 ? " " + sSizeVal : ""), 56) + "\n");
                    } else {
                        r1.PrintString(r1.FormatLeft(sAltStyleCode, 56) + "\n");
                    }
                    r1.PrintString(r1.FormatLeft("  " + sStyleCode + " " + sPrice + " x " + sQty + StoreParams.res.getString("units"), 40));
                    r1.PrintString(r1.FormatRight(sCost, 16) + "\n");
                    if (sMkdMsg.length() > 0) {
                        r1.PrintString("  " + sMkdMsg + "\n");
                    }
                    if (!bPrintOrigPrice) continue;
                    r1.PrintString("  " + sOrigPrice + "\n");
                }
            }
            if (this.bUsingExtTax && nStyleTotalTax != 0.0) {
                nStyleTotalTax = Gen.RoundNumber(nStyleTotalTax, this.nPrec);
                nTotalTax = Gen.RoundNumber(nTotalTax, this.nPrec);
                if (this.showTaxRate) {
                    r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("tax_at") + " " + this.dfQty.format(Gen.RoundNumber(nTaxPer, 4)) + "%", 40));
                } else {
                    r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("Tax"), 40));
                }
                r1.PrintString(r1.FormatRight(this.dfDet.format(nStyleTotalTax), 16) + "\n");
                nStyleTotalTax = 0.0;
            }
            if (!custCopy) {
                double nAllQty = 0.0;
                nStyleTotalTax = 0.0;
                SqlQuery sql = new SqlQuery(this.conn, "SELECT COALESCE(D.QTY,0)-COALESCE(D.QTY_AVAIL,0), D.NET, D.TAXPER, S.STYLECODE, S.NAME, C.CLRNAME, K.SIZEVAL, D.PRICE, D.GROSS, D.RET_REASIDX, D.DESCRIP1, D.LINE_TYPE, D.DISCOUNT_REASIDX, D.QTY, D.ORIG_PRICE, M.MSG, M.ORIG_FLAG, D.EXT_TAXRATE FROM RET_TRAND D LEFT JOIN SKU K ON D.SKUIDX = K.SKUIDX LEFT JOIN CLR C ON K.CLRIDX = C.CLRIDX LEFT JOIN STYLE S ON C.STYLEIDX = S.STYLEIDX LEFT JOIN POS_MKDMSG M ON D.POS_MKDMSGIDX = M.MKDIDX WHERE D.\"ACTIVE\" = 1 AND D.VHIDX = " + this.nTransIdx + " AND (COALESCE(D.QTY,0)-COALESCE(D.QTY_AVAIL,0))>0 ORDER BY D.SEQUENCE_NUMBER ");
                sStyleName = null;
                try {
                    while (sql.next()) {
                        nAllQty = sql.getDouble(14);
                        if (sql.getRow() == 1) {
                            r1.PrintString("\u001b\u0007");
                            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Goods_In_Transit"), 56));
                            r1.PrintString("\u001b\u0005");
                            r1.PrintString("\u001b\u0007" + StoreParams.res.getString("Product_Description_n") + "\u001b\u0005" + "\n");
                        }
                        nQty = sql.getDouble(1);
                        nLineType = sql.getInt(12);
                        if (nLineType == 0 || nLineType == 2) {
                            if (this.bUsingExtTax && nStyleTotalTax != 0.0) {
                                nStyleTotalTax = Gen.RoundNumber(nStyleTotalTax, this.nPrec);
                                nTotalTax = Gen.RoundNumber(nTotalTax, this.nPrec);
                                if (this.showTaxRate) {
                                    r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("tax_at") + " " + this.dfQty.format(Gen.RoundNumber(nTaxPer, 4)) + "%", 40));
                                } else {
                                    r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("Tax"), 40));
                                }
                                r1.PrintString(r1.FormatRight(this.dfDet.format(nStyleTotalTax), 16) + "\n");
                                nStyleTotalTax = 0.0;
                            }
                            nTaxPer = this.bUsingExtTax ? sql.getDouble(18) : sql.getDouble(3);
                        }
                        nNet = sql.getDouble(2);
                        nNet = nNet * nQty / nAllQty;
                        nPrice = sql.getDouble(8);
                        nOrigPrice = sql.getDouble(15);
                        sMkdMsg = Gen.NVLString(sql.getString(16), "");
                        bPrintOrigPrice = sql.getBoolean(17);
                        sAltStyleCode = sql.getString(11);
                        sQty = this.dfQty.format(nQty);
                        sPrice = this.dfDet.format(nPrice);
                        sOrigPrice = this.dfDet.format(nOrigPrice);
                        sCost = this.dfDet.format(nNet);
                        nTotalCost += nNet;
                        nTotalUnits += nQty;
                        if (this.bUsingExtTax) {
                            nTotalTax += nNet * nTaxPer / 100.0;
                            nStyleTotalTax += nNet * nTaxPer / 100.0;
                        } else {
                            nTotalTax += nNet - nNet / (1.0 + nTaxPer / 100.0);
                        }
                        String sStyleCode = Gen.NVLString(sql.getString(4), "");
                        String sStyleName2 = Gen.NVLString(sql.getString(5), "");
                        sStyleName2 = sStyleName2.substring(0, this.getMaxProdDescLen(sStyleName2));
                        String sClrName = Gen.NVLString(sql.getString(6), "");
                        String sSizeVal = Gen.NVLString(sql.getString(7), "");
                        if (!bPrintOrigPrice) {
                            sOrigPrice = "";
                            sMkdMsg = "";
                        } else {
                            Object[] objs = new Object[]{sOrigPrice};
                            sOrigPrice = MessageFormat.format(StoreParams.res.getString("orig_price_text"), objs);
                        }
                        if (!this.bUsingExtTax && nTaxPer != 0.0) {
                            sStyleName2 = "* " + sStyleName2;
                            if (sAltStyleCode != null) {
                                sAltStyleCode = "* " + sAltStyleCode;
                            }
                        } else {
                            sStyleName2 = "  " + sStyleName2;
                            if (sAltStyleCode != null) {
                                sAltStyleCode = "  " + sAltStyleCode;
                            }
                        }
                        if (sAltStyleCode == null) {
                            r1.PrintString(r1.FormatLeft(sStyleName2 + (sClrName.length() > 0 ? " " + sClrName : "") + (sSizeVal.length() > 0 ? " " + sSizeVal : ""), 56) + "\n");
                        } else {
                            r1.PrintString(r1.FormatLeft(sAltStyleCode, 56) + "\n");
                        }
                        r1.PrintString(r1.FormatLeft("  " + sStyleCode + " " + sPrice + " x " + sQty + StoreParams.res.getString("units"), 40));
                        r1.PrintString(r1.FormatRight(sCost, 16) + "\n");
                        if (sMkdMsg.length() > 0) {
                            r1.PrintString("  " + sMkdMsg + "\n");
                        }
                        if (!bPrintOrigPrice) continue;
                        r1.PrintString("  " + sOrigPrice + "\n");
                    }
                }
                catch (Throwable throwable) {
                    sStyleName = throwable;
                    throw throwable;
                }
                finally {
                    if (sql != null) {
                        if (sStyleName != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)sStyleName).addSuppressed(throwable);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
                if (this.bUsingExtTax && nStyleTotalTax != 0.0) {
                    nStyleTotalTax = Gen.RoundNumber(nStyleTotalTax, this.nPrec);
                    nTotalTax = Gen.RoundNumber(nTotalTax, this.nPrec);
                    if (this.showTaxRate) {
                        r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("tax_at") + " " + this.dfQty.format(Gen.RoundNumber(nTaxPer, 4)) + "%", 40));
                    } else {
                        r1.PrintString(r1.FormatLeft("    " + StoreParams.res.getString("Tax"), 40));
                    }
                    r1.PrintString(r1.FormatRight(this.dfDet.format(nStyleTotalTax), 16) + "\n");
                    nStyleTotalTax = 0.0;
                }
            }
            if (this.bPrintTotUnits) {
                r1.PrintString("\u001b\u0007");
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                if (nTotalUnits > 0.0) {
                    Object[] objs = new Object[]{this.dfQty.format(nTotalUnits)};
                    r1.PrintString(r1.FormatLeft("  " + MessageFormat.format(StoreParams.res.getString("total_units"), objs), 40) + "\n");
                }
                r1.PrintString("\u001b\u0005");
            }
            String sTotalTax = this.dfTot.format(nTotalTax);
            String sTotalCost = this.bUsingExtTax ? this.dfTot.format(nTotalCost + nTotalTax) : this.dfTot.format(nTotalCost);
            r1.Feed(2, PrintReceipt.DocketFormat.LONG_ONLY);
            if (this.bLargeFontForTotals) {
                r1.PrintString("\u001b\u0006");
                nLeftLength = 30;
                nRightLength = 12;
            } else {
                r1.PrintString("\u001b\u0007");
                nLeftLength = 40;
                nRightLength = 16;
            }
            r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_Inc_Tax"), nLeftLength));
            r1.PrintString(r1.FormatRight(sTotalCost, nRightLength) + "\n");
            r1.PrintString("\u001b\u0005");
            nTotalTax = Gen.RoundNumber(nTotalTax, this.nPrec);
            if (nTotalTax != 0.0) {
                r1.PrintString(r1.FormatRight(StoreParams.res.getString("Tax"), 40));
                r1.PrintString(r1.FormatRight(sTotalTax, 16) + "\n");
            }
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean printTransferIn(boolean unexpected) {
        int i = 0;
        while (true) {
            if (i >= Gen.TRANSFERS_IN_COPIES) {
                this.resetReprint();
                return true;
            }
            try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
                if (!this.printTransferHeader(r1, unexpected)) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.printTransferDetails(r1, unexpected)) {
                    boolean bl = false;
                    return bl;
                }
                if (unexpected) {
                    this.printFooter(FooterType.STOCK_RECEIPT_UNEXPECTED, r1);
                } else {
                    this.printFooter(FooterType.TRANSFER, r1);
                }
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            this.reprint = true;
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean printTransferOut(boolean unexpected) {
        int i = 0;
        while (true) {
            if (i >= Gen.TRANSFERS_OUT_COPIES) {
                this.resetReprint();
                return true;
            }
            try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
                if (!this.printTransferHeader(r1, unexpected)) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.printTransferDetails(r1, unexpected)) {
                    boolean bl = false;
                    return bl;
                }
                if (unexpected) {
                    this.printFooter(FooterType.STOCK_RECEIPT_UNEXPECTED, r1);
                } else {
                    this.printFooter(FooterType.TRANSFER, r1);
                }
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            this.reprint = true;
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean printStkTakeLocn(long vshidx) {
        try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
            r1.PrintString("\u001b\u0006");
            r1.PrintString("\u001b\u0001");
            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Stk_Take_Report"), 42));
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
            r1.PrintString("\u001b\u0005");
            r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
            if (!this.printLocnDetails(r1, vshidx)) {
                boolean bl = false;
                return bl;
            }
            this.printFooter(FooterType.STK_TAKE, r1);
        }
        catch (IOException e) {
            this.errorHandler.setError(e);
            return false;
        }
        Gen.PrintImage(this.sPrinterPort, this.sImagePath);
        return true;
    }

    private boolean printLocnDetails(PrintReceipt r1, long vshidx) {
        try {
            block33: {
                try (SqlQuery sql = new SqlQuery(this.conn, "SELECT COALESCE(H.LOCATION, ''), H.TRAND, H.TRAND, COALESCE(P.FIRSTNAME, '') FROM RET_STTH H LEFT JOIN PERSON P ON H.SREPIDX = P.PERIDX  WHERE H.VSHIDX = " + vshidx);){
                    if (!sql.next()) break block33;
                    PosDateFormatter dateFormatter = new PosDateFormatter(sql.getTimestamp(2));
                    try {
                        dateFormatter.setFormat(3, 3, 2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    r1.PrintString("\u001b\u0001");
                    r1.PrintString("\u001b\u0005");
                    r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Location"), StoreParams.res.getString("Processed_By"), this.sTillNumText, StoreParams.res.getString("Date_Time")) + "\n");
                    r1.PrintString(r1.FormatDetailHdr(sql.getString(1), sql.getString(4), this.sTillNum, dateFormatter.toString()) + "\n");
                    r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                }
            }
            double nQty = 0.0;
            double nTotal = 0.0;
            String sStyleCode = null;
            String sStyleName = null;
            String sClrName = null;
            String sSizeVal = null;
            String sTmp = null;
            String sStyleTmp = null;
            r1.PrintString("\u001b\u0007");
            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Count_Details"), 56));
            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Product_Description_n"), 40));
            r1.PrintString(r1.FormatRight(StoreParams.res.getString("Qty_Units"), 16) + "\n");
            r1.PrintString("\u001b\u0005");
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT COALESCE(S.STYLECODE,''), COALESCE(S.NAME,''), COALESCE(C.CLRNAME,''), COALESCE(K.SIZEVAL,''), D.QTY, D.LINE_CODE, K.SKUIDX FROM RET_STTD D LEFT JOIN SKU K ON D.SKUIDX = K.SKUIDX LEFT JOIN CLR C ON K.CLRIDX = C.CLRIDX LEFT JOIN STYLE S ON C.STYLEIDX = S.STYLEIDX WHERE D.ST_VSHIDX = " + vshidx + " ORDER BY D.SEQUENCE_NUMBER ");){
                while (sql.next()) {
                    int disLength;
                    sStyleCode = sql.getString(1);
                    sStyleName = sql.getString(2);
                    sStyleName = sStyleName.substring(0, this.getMaxProdDescLen(sStyleName));
                    sClrName = sql.getString(3);
                    sSizeVal = sql.getString(4);
                    nQty = sql.getDouble(5);
                    sTmp = this.dfQty.format(nQty);
                    int length = sStyleCode.length() + sStyleName.length() + sClrName.length() + sSizeVal.length() + sTmp.length() + 4;
                    sStyleTmp = null;
                    if (length > 49 && sStyleCode.length() > this.maxProdCodeLen) {
                        sStyleCode = sStyleCode.substring(0, this.maxProdCodeLen);
                        length = sStyleCode.length() + sStyleName.length() + sClrName.length() + sSizeVal.length() + sTmp.length() + 4;
                    }
                    int n = disLength = this.maxProdCodeLen > 10 ? 10 : 15;
                    if (length > 49 && sStyleName.length() > disLength) {
                        sStyleName = sStyleName.substring(0, disLength);
                        length = sStyleCode.length() + sStyleName.length() + sClrName.length() + sSizeVal.length() + sTmp.length() + 4;
                    }
                    if (length > 49 && sClrName.length() > disLength) {
                        sClrName = sClrName.substring(0, disLength);
                        length = sStyleCode.length() + sStyleName.length() + sClrName.length() + sSizeVal.length() + sTmp.length() + 4;
                    }
                    if (length > 49 && sSizeVal.length() > 6) {
                        sSizeVal = sSizeVal.substring(0, 6);
                        length = sStyleCode.length() + sStyleName.length() + sClrName.length() + sSizeVal.length() + sTmp.length() + 4;
                    }
                    sStyleTmp = sql.getString(7) == null ? "**" + StoreParams.res.getString("INVALID_APN") + "**" : sStyleCode + " " + sStyleName + " " + sClrName + " " + sSizeVal + " ";
                    r1.PrintString(r1.FormatLeft(sStyleTmp, 50));
                    r1.PrintString(r1.FormatRight(sTmp, 6) + "\n");
                    r1.PrintString("  " + sql.getString(6) + "\n");
                    nTotal += nQty;
                }
            }
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
            sTmp = this.dfQty.format(nTotal);
            r1.PrintString("\u001b\u0007");
            r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_1"), 40));
            r1.PrintString(r1.FormatRight(sTmp, 16));
            r1.PrintString("\u001b\u0005");
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return true;
    }

    private boolean printTransferHeader(PrintReceipt r1, boolean unexpected) {
        String sCityStateAndPCTHEM;
        Object[] objs;
        PhNums pn;
        long nSupplierIdx;
        String sTransferRequest;
        String sConNum;
        String sDelivInst;
        String sCarrier;
        String sDate;
        String sSalesRep;
        long nFromWidx;
        long nToWidx;
        long nTrType;
        block95: {
            nTrType = 0L;
            nToWidx = 0L;
            nFromWidx = 0L;
            sSalesRep = null;
            sDate = null;
            long nCarrIdx = 0L;
            sCarrier = null;
            sDelivInst = null;
            sConNum = null;
            sTransferRequest = null;
            nSupplierIdx = 0L;
            String sPad = "          ";
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT H.TR_TYPE, H.WIDX, H.TO_WIDX, H.FROM_WIDX, H.TRANS_NUMBER, H.TRANSSREPIDX, H.TRAND, H.TRAND, COALESCE(P.FIRSTNAME, ''), H.CARRIERIDX, H.NOTES1, H.SUPPLIERIDX, H.NOTES2, H.CORDER FROM RET_TRANH H LEFT JOIN PERSON P ON " + this.servedByJoin + " = P.PERIDX WHERE H.\"ACTIVE\" = 1 AND H.VHIDX = " + this.nTransIdx);){
                if (!sql.next()) break block95;
                nTrType = sql.getLong(1);
                nToWidx = sql.getString(3) != null ? sql.getLong(3) : 0L;
                nFromWidx = sql.getString(4) != null ? sql.getLong(4) : 0L;
                this.sTransferNum = Gen.NVLString(sql.getString(5), " ");
                if (sql.getString(13) != null && (nTrType == 249L || nTrType == 252L)) {
                    sConNum = sql.getString(13);
                }
                if (sql.getString(14) != null && nTrType == 249L) {
                    sTransferRequest = sql.getString(14);
                }
                PosDateFormatter dateFormatter = new PosDateFormatter(sql.getTimestamp(7));
                try {
                    dateFormatter.setFormat(3, 3, 2);
                    sDate = dateFormatter.toString();
                }
                catch (Exception e) {
                    sDate = "";
                }
                sSalesRep = sql.getString(9);
                nCarrIdx = sql.getLong(10);
                sDelivInst = sql.getString(11);
                nSupplierIdx = sql.getLong(12);
                sCarrier = Gen.getRefName(nCarrIdx, this.conn);
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        String sLocnidxUS = null;
        String sWhseNumUS = null;
        String sTradeNameUS = null;
        String sAddress1US = null;
        String sAddress2US = null;
        String sCityUS = null;
        String sStateUS = null;
        String sPostcodeUS = null;
        String sPhoneUS = null;
        String sFaxUS = null;
        String sLocnidxTHEM = null;
        String sWhseNumTHEM = null;
        String sTradeNameTHEM = null;
        String sAddress1THEM = null;
        String sAddress2THEM = null;
        String sCityTHEM = null;
        String sStateTHEM = null;
        String sPostcodeTHEM = null;
        String sPhoneTHEM = null;
        String sFaxTHEM = null;
        String[] sSupAddress = new String[]{"", "", "", "", "", "", "", ""};
        long nTheirWhse = 0L;
        if (nTrType == 249L) {
            nTheirWhse = nToWidx;
        } else if (nTrType == 250L) {
            nTheirWhse = nFromWidx;
        } else if (nTrType == 248L || nTrType == 251L || nTrType == 252L) {
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT LOCNIDX FROM LOCN WHERE SUPLIDX = " + nSupplierIdx + " AND LOCNTYIDX IN (1,6) AND \"ACTIVE\" = 1 ORDER BY LOCNTYIDX DESC ");){
                if (sql.next() && (sLocnidxTHEM = sql.getString(1)) != null) {
                    Gen.getAddress(this.conn, PosUtils.longVal(sLocnidxTHEM), sSupAddress);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        sWhseNumUS = StoreDetails.getString("storeno");
        sLocnidxUS = StoreDetails.getString("linkidx");
        sTradeNameUS = StoreDetails.getString("tradename");
        sAddress1US = StoreDetails.getString("adrs1");
        sAddress2US = StoreDetails.getString("adrs2");
        sCityUS = StoreDetails.getString("city");
        sStateUS = StoreDetails.getString("state");
        sPostcodeUS = StoreDetails.getString("postcode");
        if (sLocnidxUS != null) {
            pn = new PhNums(sLocnidxUS);
            pn.loadPhoneNumbers(this.conn);
            sPhoneUS = pn.getString(154L);
            if (sPhoneUS != null) {
                sPhoneUS = StoreParams.res.getString("Ph_") + " " + sPhoneUS;
            }
            if ((sFaxUS = pn.getString(373L)) != null) {
                sFaxUS = StoreParams.res.getString("Fax") + " " + sFaxUS;
            }
        }
        if (nTrType == 249L || nTrType == 250L) {
            Warehouse wh = new Warehouse(nTheirWhse);
            wh.loadWarehouse(this.conn);
            sWhseNumTHEM = wh.getString("storeno");
            sLocnidxTHEM = wh.getString("locnidx");
            sTradeNameTHEM = wh.getString("tradename");
            sAddress1THEM = wh.getString("adrs1");
            sAddress2THEM = wh.getString("adrs2");
            sCityTHEM = wh.getString("city");
            sStateTHEM = wh.getString("state");
            sPostcodeTHEM = wh.getString("postcode");
        } else if (nTrType == 248L || nTrType == 251L || nTrType == 252L) {
            sWhseNumTHEM = "";
            sTradeNameTHEM = sSupAddress[0];
            sAddress1THEM = sSupAddress[1];
            sAddress2THEM = sSupAddress[2];
            sCityTHEM = sSupAddress[3];
            sStateTHEM = sSupAddress[4];
            sPostcodeTHEM = sSupAddress[5];
        }
        if (sLocnidxTHEM != null) {
            pn = new PhNums(sLocnidxTHEM);
            pn.loadPhoneNumbers(this.conn);
            sPhoneTHEM = pn.getString(154L);
            if (sPhoneTHEM != null) {
                sPhoneTHEM = StoreParams.res.getString("Ph_") + " " + sPhoneTHEM;
            }
            if ((sFaxTHEM = pn.getString(373L)) != null) {
                sFaxTHEM = StoreParams.res.getString("Fax") + " " + sFaxTHEM;
            }
        }
        r1.PrintString("\u001b\u0006");
        r1.PrintString("\u001b\u0001");
        if (this.reprint) {
            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("REPRINT"), 42));
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        }
        if (nTrType == 249L) {
            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("TRANSFER_OUT"), 42));
        } else if (nTrType == 250L || nTrType == 251L) {
            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("TRANSFER_IN"), 42));
            if (unexpected) {
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Unexpected_Items"), 42));
            }
        } else if (nTrType == 248L) {
            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("AD-HOC_STOCK_RECEIPT"), 42));
        } else if (nTrType == 252L) {
            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("RETURN_TO_SUPPLIER"), 42));
        }
        r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        r1.PrintString("\u001b\u0001");
        r1.PrintString("\u001b\u0005");
        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
        r1.PrintString("\u001b\u0007");
        r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Transfer_No_") + " " + this.sTransferNum, 56));
        if (sConNum != null) {
            r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Connote_No_") + " " + sConNum, 56));
        }
        r1.Feed(1);
        r1.PrintString("\u001b\u0005");
        r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Docket_No_"), StoreParams.res.getString("Processed_By"), this.sTillNumText, StoreParams.res.getString("Date_Time")) + "\n");
        r1.PrintString(r1.FormatDetailHdr(this.sDocNum, sSalesRep, this.sTillNum, sDate) + "\n");
        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
        r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        if (nTrType == 249L || nTrType == 252L) {
            r1.PrintString("\u001b\u0007");
            objs = new Object[]{"\n"};
            r1.PrintString(MessageFormat.format(StoreParams.res.getString("Sent_from_n"), objs));
            r1.PrintString("\u001b\u0005");
            r1.PrintString("\u001b\u0007");
            r1.PrintString("          " + Gen.NVLString(sWhseNumUS, "") + " " + Gen.NVLString(sTradeNameUS, "") + "\n");
            r1.PrintString("\u001b\u0005");
            r1.PrintString("\u001b\u0005");
            if (sAddress1US != null) {
                r1.PrintString("          " + sAddress1US + "\n");
            }
            if (sAddress2US != null) {
                r1.PrintString("          " + sAddress2US + "\n");
            }
            String sCityStateAndPCUS = "";
            if (sCityUS != null) {
                sCityStateAndPCUS = sCityUS;
            }
            if (sStateUS != null) {
                sCityStateAndPCUS = sCityStateAndPCUS + (sCityStateAndPCUS.equals("") ? "" : " ") + sStateUS;
            }
            if (sPostcodeUS != null) {
                sCityStateAndPCUS = sCityStateAndPCUS + (sCityStateAndPCUS.equals("") ? "" : " ") + sPostcodeUS;
            }
            if (sCityStateAndPCUS.length() > 0) {
                r1.PrintString("          " + sCityStateAndPCUS + "\n");
            }
            if (sPhoneUS != null) {
                r1.PrintString("          " + sPhoneUS + "\n");
            }
            if (sFaxUS != null) {
                r1.PrintString("          " + sFaxUS + "\n");
            }
            r1.PrintString("\u001b\u0007");
            r1.Feed(1);
            r1.PrintString(StoreParams.res.getString("Authorised_By_") + "\n");
            r1.Feed(1);
            r1.PrintString(StoreParams.res.getString("Date_1") + "\n");
            r1.Feed(1, PrintReceipt.DocketFormat.SHORT_ONLY);
            r1.PrintString("\u001b\u0005");
        } else if (nTrType == 250L || nTrType == 248L || nTrType == 251L) {
            r1.PrintString("\u001b\u0007");
            objs = new Object[]{"\n"};
            r1.PrintString(MessageFormat.format(StoreParams.res.getString("Sent_by_n"), objs));
            r1.PrintString("\u001b\u0005");
            r1.PrintString("\u001b\u0007");
            if (nTrType == 248L || nTrType == 251L) {
                r1.PrintString("          " + Gen.NVLString(sTradeNameTHEM, "") + "\n");
            } else {
                r1.PrintString("          " + Gen.NVLString(sWhseNumTHEM, "") + " " + Gen.NVLString(sTradeNameTHEM, "") + "\n");
            }
            r1.PrintString("\u001b\u0005");
            r1.PrintString("\u001b\u0005");
            if (sAddress1THEM != null) {
                r1.PrintString("          " + sAddress1THEM + "\n");
            }
            if (sAddress2THEM != null) {
                r1.PrintString("          " + sAddress2THEM + "\n");
            }
            sCityStateAndPCTHEM = "";
            if (sCityTHEM != null) {
                sCityStateAndPCTHEM = sCityTHEM;
            }
            if (sStateTHEM != null) {
                sCityStateAndPCTHEM = sCityStateAndPCTHEM + (sCityStateAndPCTHEM.equals("") ? "" : " ") + sStateTHEM;
            }
            if (sPostcodeTHEM != null) {
                sCityStateAndPCTHEM = sCityStateAndPCTHEM + (sCityStateAndPCTHEM.equals("") ? "" : " ") + sPostcodeTHEM;
            }
            if (sCityStateAndPCTHEM.length() > 0) {
                r1.PrintString("          " + sCityStateAndPCTHEM + "\n");
            }
            if (sPhoneTHEM != null) {
                r1.PrintString("          " + sPhoneTHEM + "\n");
            }
            if (sFaxTHEM != null) {
                r1.PrintString("          " + sFaxTHEM + "\n");
            }
        }
        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
        r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        if (nTrType == 249L || nTrType == 252L) {
            r1.PrintString("\u001b\u0007");
            objs = new Object[]{"\n"};
            r1.PrintString(MessageFormat.format(StoreParams.res.getString("Deliver_to_n"), objs));
            r1.PrintString("\u001b\u0005");
            r1.PrintString("\u001b\u0007");
            if (nTrType == 252L) {
                r1.PrintString("          " + Gen.NVLString(sTradeNameTHEM, "") + "\n");
            } else {
                r1.PrintString("          " + Gen.NVLString(sWhseNumTHEM, "") + " " + Gen.NVLString(sTradeNameTHEM, "") + "\n");
            }
            r1.PrintString("\u001b\u0005");
            r1.PrintString("\u001b\u0005");
            if (sAddress1THEM != null) {
                r1.PrintString("          " + sAddress1THEM + "\n");
            }
            if (sAddress2THEM != null) {
                r1.PrintString("          " + sAddress2THEM + "\n");
            }
            sCityStateAndPCTHEM = "";
            if (sCityTHEM != null) {
                sCityStateAndPCTHEM = sCityTHEM;
            }
            if (sStateTHEM != null) {
                sCityStateAndPCTHEM = sCityStateAndPCTHEM + (sCityStateAndPCTHEM.equals("") ? "" : " ") + sStateTHEM;
            }
            if (sPostcodeTHEM != null) {
                sCityStateAndPCTHEM = sCityStateAndPCTHEM + (sCityStateAndPCTHEM.equals("") ? "" : " ") + sPostcodeTHEM;
            }
            if (sCityStateAndPCTHEM.length() > 0) {
                r1.PrintString("          " + sCityStateAndPCTHEM + "\n");
            }
            if (sPhoneTHEM != null) {
                r1.PrintString("          " + sPhoneTHEM + "\n");
            }
            if (sFaxTHEM != null) {
                r1.PrintString("          " + sFaxTHEM + "\n");
            }
        } else if (nTrType == 250L || nTrType == 248L || nTrType == 251L) {
            r1.PrintString("\u001b\u0007");
            objs = new Object[]{"\n"};
            r1.PrintString(MessageFormat.format(StoreParams.res.getString("Received_by_n"), objs));
            r1.PrintString("\u001b\u0005");
            r1.PrintString("\u001b\u0007");
            r1.PrintString("          " + Gen.NVLString(sWhseNumUS, "") + " " + Gen.NVLString(sTradeNameUS, "") + "\n");
            r1.PrintString("\u001b\u0005");
        }
        r1.PrintString("\u001b\u0005");
        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
        r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        if (nTrType == 249L || nTrType == 252L) {
            if (sCarrier != null && sCarrier.length() > 0) {
                r1.PrintString("\u001b\u0007" + StoreParams.res.getString("Carrier_") + "\u001b\u0005" + "  " + sCarrier + "\n");
            }
            if (sDelivInst != null && sDelivInst.length() > 0) {
                r1.PrintString("\u001b\u0007");
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                Object[] objs1 = new Object[]{"\n"};
                r1.PrintString(MessageFormat.format(StoreParams.res.getString("Delivery_Instructions1"), objs1));
                r1.PrintString("\u001b\u0005");
                r1.PrintString(sDelivInst + "\n");
            }
            if (sTransferRequest != null && sTransferRequest.length() > 0 && nTrType == 249L) {
                r1.Feed(1);
                r1.PrintString("\u001b\u0007" + StoreParams.res.getString("Transfer_Request_No_") + "\u001b\u0005" + "  " + sTransferRequest + "\n");
            }
            r1.Feed(1);
            r1.PrintString("\u001b\u0007");
            r1.PrintString(StoreParams.res.getString("Signature_1") + "\n");
            r1.Feed(1);
            r1.PrintString(StoreParams.res.getString("Date_1") + "\n");
            r1.PrintString("\u001b\u0005");
            r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
            r1.Feed(1);
        }
        return true;
    }

    private boolean printTransferDetails(PrintReceipt r1, boolean unexpected) {
        try {
            double nQty = 0.0;
            double nTotal = 0.0;
            String sTmp = null;
            String sStyleTmp = null;
            String lineTypes = "0, 2";
            if (unexpected) {
                lineTypes = Integer.toString(99);
            }
            r1.PrintString("\u001b\u0007");
            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Product_Description_n"), 40));
            r1.PrintString(r1.FormatRight(StoreParams.res.getString("Qty_Units"), 16) + "\n");
            r1.PrintString("\u001b\u0005");
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT COALESCE(S.STYLECODE,''), COALESCE(S.NAME,''), COALESCE(C.CLRNAME,''), COALESCE(K.SIZEVAL,''), D.QTY FROM RET_TRAND D LEFT JOIN SKU K ON D.SKUIDX = K.SKUIDX LEFT JOIN CLR C ON K.CLRIDX = C.CLRIDX LEFT JOIN STYLE S ON C.STYLEIDX = S.STYLEIDX WHERE D.\"ACTIVE\" = 1 AND D.LINE_TYPE in (" + lineTypes + ") AND D.VHIDX = " + this.nTransIdx + " ORDER BY S.STYLECODE, C.CLRCODE, K.SIZESEQ ");){
                while (sql.next()) {
                    nQty = sql.getDouble(5);
                    sTmp = this.dfQty.format(nQty);
                    sStyleTmp = this.TruncateTransferDetails(sql.getString(1) != null ? sql.getString(1) : "", sql.getString(2) != null ? " " + sql.getString(2) : "", sql.getString(3) != null ? " " + sql.getString(3) : "", sql.getString(4) != null ? " " + sql.getString(4) : "", 50);
                    r1.PrintString(r1.FormatLeft(sStyleTmp, 50));
                    r1.PrintString(r1.FormatRight(sTmp, 6) + "\n");
                    nTotal += nQty;
                }
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                sTmp = this.dfQty.format(nTotal);
                r1.PrintString("\u001b\u0007");
                r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_1"), 40));
                r1.PrintString(r1.FormatRight(sTmp, 16));
                r1.PrintString("\u001b\u0005");
                r1.Feed(1);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean printWithDrawal() {
        if (this.sPrinterPort == null) {
            this.errorHandler.setError("Printer not set up");
            return false;
        }
        try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
            if (!this.reprint) {
                r1.OpenCashDrawer();
            }
            if (!this.printHeader(HeaderType.WITHDRAWAL, r1)) {
                boolean bl = false;
                return bl;
            }
            this.printWithDrawalDetails(r1);
            this.printFooter(FooterType.WITHDRAWAL, r1);
        }
        catch (IOException e) {
            this.errorHandler.setError(e);
            return false;
        }
        Gen.PrintImage(this.sPrinterPort, this.sImagePath);
        return true;
    }

    private void printWithDrawalDetails(PrintReceipt r1) {
        block16: {
            String sTransIdx = String.valueOf(this.nTransIdx);
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT H.VHIDX, H.DOCKET_NUMBER, H.TRANSSREPIDX, H.TRAND, H.TRAND, COALESCE(P.FIRSTNAME, ''), H.NOTES1, RP.PAYMENT_AMOUNT FROM RET_TRANH H LEFT JOIN PERSON P ON " + this.servedByJoin + " = P.PERIDX, RET_TRANP RP WHERE H.\"ACTIVE\" = 1 AND RP.\"ACTIVE\" = 1 AND RP.PAYMENT_TYPEIDX = 548 AND RP.VHIDX = H.VHIDX AND H.VHIDX = " + sTransIdx);){
                String sTranDate;
                if (!sql.next()) break block16;
                PosDateFormatter dateFormatter = new PosDateFormatter(sql.getTimestamp(4));
                try {
                    dateFormatter.setFormat(3, 3, 2);
                    sTranDate = dateFormatter.toString();
                }
                catch (Exception e) {
                    sTranDate = "";
                }
                String sSalesRep = sql.getString(6);
                r1.PrintString("\u001b\u0005");
                r1.PrintString("\u001b\u0001");
                r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Docket_No_"), StoreParams.res.getString("Sales_Rep"), this.sTillNumText, StoreParams.res.getString("Date_Time")) + "\n");
                r1.PrintString(r1.FormatDetailHdr(this.sDocNum, sSalesRep, this.sTillNum, sTranDate) + "\n");
                r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                this.printNotes(r1, Note.getNotes(sql.getLong(1), "RET_TRANH", this.conn), true);
                r1.PrintString("\u001b\u0007" + StoreParams.res.getString("Description_n") + "\u001b\u0005" + "\n");
                r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Amount_Withdrawn"), 40) + r1.FormatRight(this.dfTot.format(sql.getDouble(8)), 16) + "\n");
                r1.PrintString("\u001b\u0005");
                r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                r1.Feed(1);
                r1.PrintString("\u001b\u0007");
                r1.PrintString(StoreParams.res.getString("Signature_1") + "\n");
                r1.Feed(1);
                r1.PrintString(StoreParams.res.getString("Date_1") + "\n");
                r1.Feed(1);
                r1.PrintString("\u001b\u0005");
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean printExpense() {
        if (this.sPrinterPort == null) {
            this.errorHandler.setError("Printer not setup");
            return false;
        }
        try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
            if (!this.printHeader(HeaderType.EXPENSE, r1)) {
                this.errorHandler.setError("");
                boolean bl = false;
                return bl;
            }
            this.printExpenseDetails(r1);
            this.printFooter(FooterType.EXPENSE, r1);
        }
        catch (IOException e) {
            this.errorHandler.setError(e);
            return false;
        }
        Gen.PrintImage(this.sPrinterPort, this.sImagePath);
        return true;
    }

    private void printExpenseDetails(PrintReceipt r1) {
        block20: {
            String sTransIdx = String.valueOf(this.nTransIdx);
            double nPayAmt = 0.0;
            long nVhIdx = 0L;
            try (SqlQuery sql = new SqlQuery(this.conn, "SELECT H.VHIDX, H.DOCKET_NUMBER, H.TRANSSREPIDX, H.TRAND, H.TRAND, COALESCE(P.FIRSTNAME, ''), RD.DESCRIP1, W.STORENO, O.DOCKET_NUMBER, OP.PAYMENT_AMOUNT, E.NAME, RD.NET-(RD.NET/((RD.TAXPER/100.00000000)+1)), RD.NET FROM RET_TRANH H LEFT JOIN PERSON P ON " + this.servedByJoin + " = P.PERIDX LEFT JOIN RET_TRAND RD ON H.VHIDX = RD.VHIDX LEFT JOIN REFCODE E ON RD.LINE_CODE = CAST(E.RCIDX AS VARCHAR(50)), WHSE W, RET_TRANH O, RET_TRANP OP WHERE H.\"ACTIVE\" = 1 AND OP.\"ACTIVE\" = 1 AND OP.PAYMENT_TYPEIDX = 548 AND H.WIDX = W.WIDX AND  O.DOCKET_NUMBER = H.TRANS_NUMBER AND O.VHIDX = OP.VHIDX AND OP.PAYMENT_TYPEIDX = 548 AND H.VHIDX = ? AND  O.WIDX = ? ORDER BY RD.SEQUENCE_NUMBER", sTransIdx, SP.sParams.getStoreIdx());){
                String sTranDate;
                if (!sql.next()) break block20;
                nVhIdx = sql.getLong(1);
                nPayAmt = sql.getDouble(10);
                String sDetails = sql.getString(7);
                PosDateFormatter dateFormatter = new PosDateFormatter(sql.getTimestamp(4));
                try {
                    dateFormatter.setFormat(3, 3, 2);
                    sTranDate = dateFormatter.toString();
                }
                catch (Exception e) {
                    sTranDate = "";
                }
                String sSalesRep = sql.getString(6);
                r1.PrintString("\u001b\u0005");
                r1.PrintString("\u001b\u0001");
                r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Docket_No_"), StoreParams.res.getString("Sales_Rep"), this.sTillNumText, StoreParams.res.getString("Date_Time")) + "\n");
                r1.PrintString(r1.FormatDetailHdr(this.sDocNum, sSalesRep, this.sTillNum, sTranDate) + "\n");
                r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Withdrawal_D") + " D" + sql.getString(8) + sql.getString(9), 40) + r1.FormatRight(this.dfTot.format(nPayAmt), 16));
                r1.Feed(2, PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintString("\u001b\u0007");
                r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Description_n"), 24) + r1.FormatRight(StoreParams.res.getString("Tax"), 16) + r1.FormatRight(StoreParams.res.getString("Amount"), 16));
                r1.PrintString("\u001b\u0005");
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintString(r1.FormatLeft(sql.getString(11), 24) + r1.FormatRight(this.dfDet.format(sql.getDouble(12)), 16) + r1.FormatRight(this.dfDet.format(sql.getDouble(13)), 16));
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                if (sDetails != null && sDetails.length() > 0) {
                    r1.PrintString(r1.FormatLeft("  " + sDetails, 56) + "\n");
                }
                double tot = sql.getDouble(13);
                double tax = sql.getDouble(12);
                while (sql.next()) {
                    sDetails = sql.getString(7);
                    r1.PrintString(r1.FormatLeft(sql.getString(11), 24) + r1.FormatRight(this.dfDet.format(sql.getDouble(12)), 16) + r1.FormatRight(this.dfDet.format(sql.getDouble(13)), 16));
                    r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                    if (sDetails != null && sDetails.length() > 0) {
                        r1.PrintString(r1.FormatLeft("  " + sDetails, 56) + "\n");
                    }
                    tot += sql.getDouble(13);
                    tax += sql.getDouble(12);
                }
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintString("\u001b\u0007");
                r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Totals_"), 24) + r1.FormatRight(this.dfDet.format(tax), 16) + r1.FormatRight(this.dfDet.format(tot), 16));
                r1.PrintString("\u001b\u0005");
                r1.Feed(2, PrintReceipt.DocketFormat.LONG_ONLY);
                if (Gen.RoundNumber(nPayAmt - tot, this.nPrec) != 0.0 && !this.reprint) {
                    r1.OpenCashDrawer();
                }
                r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Return_To_Till"), 40) + r1.FormatRight(this.dfTot.format(nPayAmt - tot), 16) + "\n");
                r1.PrintString("\u001b\u0005");
                r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                this.printNotes(r1, Note.getNotes(nVhIdx, "RET_TRANH", this.conn), true);
                r1.Feed(1);
                r1.PrintString("\u001b\u0007");
                r1.PrintString(StoreParams.res.getString("Signature_1") + "\n");
                r1.Feed(1);
                r1.PrintString(StoreParams.res.getString("Date_1") + "\n");
                r1.Feed(1);
                r1.PrintString("\u001b\u0005");
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    private void printCustDets(PrintReceipt r1, Element cust, boolean printTradeTerms, String sLoyaltyCards, boolean bPrintLocn) {
        if (cust != null) {
            boolean bIsAccountCust = false;
            boolean bIsDebtorSale = false;
            try {
                Element person = null;
                if (cust.getName().equals("cust")) {
                    bIsDebtorSale = true;
                }
                if (cust.getChild("person") != null || cust.getName().equals("person")) {
                    person = cust.getName().equals("person") ? cust : cust.getChild("person");
                }
                r1.PrintString("\u001b\u0007");
                if (printTradeTerms) {
                    r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Customer_Details_"), 32) + r1.FormatRight(StoreParams.res.getString("Trading_Terms"), 24) + "\n");
                } else if (person != null && person.getAttribute("custidx") != null) {
                    bIsAccountCust = true;
                    r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Customer_Details_"), 32) + r1.FormatRight(StoreParams.res.getString("Settlement_Due"), 24) + "\n");
                } else {
                    r1.PrintString(StoreParams.res.getString("Customer_Details_") + "\n");
                }
                r1.PrintString("\u001b\u0005");
                if (!Gen.NVLString(sLoyaltyCards, "").equals("")) {
                    r1.PrintString(sLoyaltyCards);
                }
                if (person != null) {
                    String name;
                    if (bIsAccountCust) {
                        String sSettlementDue = "";
                        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT C.PSDWMY, COALESCE(C.PDAY,-1), COALESCE(C.PWEEK,-1), COALESCE(C.PMONTH,-1), COALESCE(C.PNEXT_TYPE,0) FROM CUST C WHERE C.CUSTIDX = " + person.getAttribute("custidx").getValue());){
                            if (sql.next() && sql.getString(1) != null) {
                                sSettlementDue = PeriodCalc.getPeriodDesc(sql.getString(1), sql.getInt(2), sql.getInt(3), sql.getInt(4), sql.getInt(5));
                            }
                        }
                        String custCode = person.getAttribute("custcode") != null ? StringUtils.nullToEmpty(person.getAttribute("custcode").getValue()) : "";
                        String custName = person.getAttribute("custname") != null ? StringUtils.nullToEmpty(person.getAttribute("custname").getValue()) : "";
                        r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Account") + ": " + custCode + " - " + custName, 32) + r1.FormatRight(sSettlementDue, 24) + "\n");
                    }
                    String string = person.getAttribute("name") != null ? (StringUtils.nullToEmpty(person.getAttribute("name").getValue()).charAt(0) == ' ' ? StringUtils.nullToEmpty(person.getAttribute("name").getValue()).substring(1) : StringUtils.nullToEmpty(person.getAttribute("name").getValue())) : (name = "");
                    if (name.equals("")) {
                        if (person.getAttribute("title") != null) {
                            name = name + StringUtils.nullToEmpty(person.getAttribute("title").getValue()) + " ";
                        }
                        if (person.getAttribute("firstname") != null) {
                            name = name + StringUtils.nullToEmpty(person.getAttribute("firstname").getValue()) + " ";
                        }
                        if (person.getAttribute("surname") != null) {
                            name = name + StringUtils.nullToEmpty(person.getAttribute("surname").getValue());
                        }
                    }
                    if (printTradeTerms) {
                        r1.PrintString(r1.FormatLeft(name, 24) + r1.FormatRight(PeriodCalc.getPeriodDesc(cust.getAttribute("trterms").getValue()), 32) + "\n");
                    } else {
                        r1.PrintString(name + "\n");
                    }
                } else if (printTradeTerms) {
                    r1.PrintString(r1.FormatRight(PeriodCalc.getPeriodDesc(cust.getAttribute("trterms").getValue()), 56) + "\n");
                }
                if ((bIsDebtorSale || bPrintLocn) && cust.getChild("locn") != null) {
                    Element locn = cust.getChild("locn");
                    if (locn.getAttribute("tradename") != null) {
                        r1.PrintString(locn.getAttribute("tradename").getValue() + "\n");
                    }
                    if (locn.getAttribute("adrs1") != null) {
                        r1.PrintString(locn.getAttribute("adrs1").getValue() + "\n");
                    }
                    if (locn.getAttribute("adrs2") != null) {
                        r1.PrintString(locn.getAttribute("adrs2").getValue() + "\n");
                    }
                    if (locn.getAttribute("city") != null || locn.getAttribute("postcode") != null || locn.getAttribute("country") != null) {
                        if (locn.getAttribute("city") != null) {
                            r1.PrintString(locn.getAttribute("city").getValue());
                        }
                        if (locn.getAttribute("city") != null && (locn.getAttribute("postcode") != null || locn.getAttribute("country") != null)) {
                            r1.PrintString(", ");
                        }
                        if (locn.getAttribute("postcode") != null) {
                            r1.PrintString(locn.getAttribute("postcode").getValue());
                        }
                        if (locn.getAttribute("postcode") != null && locn.getAttribute("country") != null) {
                            r1.PrintString(" ");
                        }
                        if (locn.getAttribute("country") != null) {
                            r1.PrintString(locn.getAttribute("country").getValue());
                        }
                        r1.Feed(1);
                    }
                    for (Element phone : locn.getChildren("phonenum")) {
                        if (phone.getAttribute("phonetyidx").getLongValue() == 154L && !phone.getText().equals("")) {
                            r1.PrintString(StoreParams.res.getString("Ph_") + " " + phone.getText() + "\n");
                            continue;
                        }
                        if (phone.getAttribute("phonetyidx").getLongValue() != 373L || phone.getText().equals("")) continue;
                        r1.PrintString(StoreParams.res.getString("Fax") + " " + phone.getText() + "\n");
                    }
                    if (cust.getAttribute("abn") != null) {
                        r1.PrintString(StoreParams.res.getString("ABN") + " " + cust.getAttribute("abn").getValue() + "\n");
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public void printDeliveryLocation(Element deliveryLocation, PrintReceipt r1) {
        if (deliveryLocation == null) {
            return;
        }
        r1.PrintString("\u001b\u0007");
        r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
        r1.PrintString(StoreParams.res.getString("Delivery_Details_") + "\n");
        r1.PrintString("\u001b\u0005");
        if (deliveryLocation.getAttribute("contact") != null) {
            r1.PrintString(deliveryLocation.getAttribute("contact").getValue() + "\n");
        }
        if (deliveryLocation.getAttribute("tradename") != null) {
            r1.PrintString(deliveryLocation.getAttribute("tradename").getValue() + "\n");
        }
        if (deliveryLocation.getAttribute("adrs1") != null) {
            r1.PrintString(deliveryLocation.getAttribute("adrs1").getValue() + "\n");
        }
        if (deliveryLocation.getAttribute("adrs2") != null) {
            r1.PrintString(deliveryLocation.getAttribute("adrs2").getValue() + "\n");
        }
        if (deliveryLocation.getAttribute("city") != null || deliveryLocation.getAttribute("postcode") != null || deliveryLocation.getAttribute("country") != null || deliveryLocation.getAttribute("state") != null) {
            if (deliveryLocation.getAttribute("city") != null) {
                r1.PrintString(deliveryLocation.getAttribute("city").getValue());
                if (deliveryLocation.getAttribute("postcode") != null || deliveryLocation.getAttribute("country") != null || deliveryLocation.getAttribute("state") != null) {
                    r1.PrintString(", ");
                }
            }
            if (deliveryLocation.getAttribute("state") != null) {
                r1.PrintString(deliveryLocation.getAttribute("state").getValue());
                if (deliveryLocation.getAttribute("postcode") != null && deliveryLocation.getAttribute("country") != null) {
                    r1.PrintString(", ");
                }
            }
            if (deliveryLocation.getAttribute("postcode") != null) {
                r1.PrintString(deliveryLocation.getAttribute("postcode").getValue());
            }
            if (deliveryLocation.getAttribute("postcode") != null && deliveryLocation.getAttribute("country") != null) {
                r1.PrintString(" ");
            }
            if (deliveryLocation.getAttribute("country") != null) {
                r1.PrintString(deliveryLocation.getAttribute("country").getValue());
            }
            r1.Feed(1);
        }
        if (deliveryLocation.getAttribute("main_phone") != null) {
            r1.PrintString("Home Ph. " + deliveryLocation.getAttribute("main_phone").getValue() + "\n");
        }
        if (deliveryLocation.getAttribute("mobile") != null) {
            r1.PrintString("Mobile Ph. " + deliveryLocation.getAttribute("mobile").getValue() + "\n");
        }
        if (deliveryLocation.getAttribute("email") != null) {
            r1.PrintString(deliveryLocation.getAttribute("email").getValue() + "\n");
        }
    }

    public boolean isValidReceipt() {
        return this.nTransIdx != 0L;
    }

    private boolean printNotes(PrintReceipt r1, List<?> notesXml, boolean printTitle) {
        return this.printNotes(r1, notesXml, printTitle, "");
    }

    private boolean printNotes(PrintReceipt r1, List<?> notesXml, boolean printTitle, String sExtraPadding) {
        try {
            if (notesXml.size() > 0) {
                for (int i = 0; i < notesXml.size(); ++i) {
                    String notes;
                    Element note = (Element)notesXml.get(i);
                    if (printTitle) {
                        r1.PrintString("\u001b\u0007");
                        if (note.getAttribute("typeidx") != null) {
                            r1.PrintString(Gen.getRefName(note.getAttribute("typeidx").getLongValue(), this.conn) + "\n");
                        }
                        r1.PrintString("\u001b\u0005");
                        if (note.getAttribute("rcidx") != null) {
                            r1.PrintString(Gen.getRefName(note.getAttribute("rcidx").getLongValue(), this.conn) + " : ");
                        }
                        notes = r1.wordWrap(note.getText(), 56);
                        r1.PrintString(notes + "\n");
                        continue;
                    }
                    r1.PrintString("\u001b\u0005");
                    if (note.getAttribute("rcidx") != null) {
                        r1.PrintString(sExtraPadding + "  " + Gen.getRefName(note.getAttribute("rcidx").getLongValue(), this.conn) + " : ");
                    }
                    notes = Utils.stringReplace(r1.wordWrap(sExtraPadding + "  " + note.getText(), 38), "\n", "\n  " + sExtraPadding);
                    r1.PrintString(notes + "\n");
                }
                if (printTitle) {
                    r1.PrintString("\u001b\u0005");
                    r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                }
                return true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLoyaltyCards(long nVhidx, Element person) {
        String sLoyaltyCards = "";
        long widx = SP.sParams.getStoreIdx();
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT CARDNO FROM RET_LOYALTY WHERE VHIDX = ? OR VHIDX IN (   SELECT D2.VHIDX   FROM RET_TRAND D1   JOIN RET_TRANH H1 ON D1.VHIDX = H1.VHIDX   JOIN RET_TRAND D2 ON D2.VSHIDX = D1.ORIG_VSHIDX   WHERE D1.VHIDX = ?   AND COALESCE(H1.FROM_WIDX, ?) = ? )", nVhidx, nVhidx, widx, widx);){
            while (sql.next()) {
                String sqlWhere = null;
                String cardNo = sql.getString(1);
                if (cardNo.startsWith("L") && !cardNo.startsWith("LM")) {
                    sqlWhere = " R.RGIDX = 366 AND R.CODE = " + PosUtils.StringToSqlString(cardNo.substring(1, 3));
                } else if (person != null) {
                    String rcidxs = "";
                    List loyalties = person.getChildren("perloyalty");
                    for (int i = 0; i < loyalties.size(); ++i) {
                        if (!cardNo.equals(((Element)loyalties.get(i)).getAttribute("cardno").getValue())) continue;
                        rcidxs = rcidxs.equals("") ? ((Element)loyalties.get(i)).getAttribute("rcidx").getValue() : rcidxs + "," + ((Element)loyalties.get(i)).getAttribute("rcidx").getValue();
                    }
                    if (rcidxs.indexOf(",") > -1) {
                        sqlWhere = " R.RCIDX IN (" + rcidxs + ")";
                    } else if (!rcidxs.equals("")) {
                        sqlWhere = " R.RCIDX = " + rcidxs;
                    }
                }
                if (sqlWhere != null) {
                    SqlQuery sql2;
                    block33: {
                        sql2 = new SqlQuery(this.conn, "SELECT R.CODE || ' - ' || R.NAME || ' - " + StoreParams.res.getString("Card_") + " " + cardNo + "' FROM REFCODE R WHERE " + sqlWhere);
                        Throwable throwable = null;
                        try {
                            while (sql2.next()) {
                                sLoyaltyCards = sLoyaltyCards + sql2.getString(1) + "\n";
                            }
                            if (sql2 == null) continue;
                            if (throwable == null) break block33;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (sql2 == null) throw throwable3;
                                if (throwable == null) {
                                    sql2.close();
                                    throw throwable3;
                                }
                                try {
                                    sql2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            sql2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    sql2.close();
                    continue;
                }
                sLoyaltyCards = sLoyaltyCards + StoreParams.res.getString("Card_") + " " + cardNo + "\n";
            }
            return sLoyaltyCards;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return sLoyaltyCards;
    }

    private boolean printTransferChecklist(Element root) {
        block124: {
            String sPad = "          ";
            try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
                if (root == null) break block124;
                boolean newReceiptType = false;
                boolean isCarton = false;
                Carton carton = null;
                boolean isNonASN = false;
                NonASNTransaction nonASN = null;
                XMLOutputter outp = new XMLOutputter();
                String xmlString = outp.outputString(root);
                try {
                    if (root.getName().equals("Carton")) {
                        carton = Carton.createCartonFromXmlString(xmlString);
                        isCarton = true;
                    } else if (root.getName().equals("NonASNTransaction")) {
                        nonASN = NonASNTransaction.createTransactionFromXmlString(xmlString);
                        isNonASN = true;
                    }
                    newReceiptType = isCarton || isNonASN;
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
                Warehouse whFrom = null;
                String sSupplierName = null;
                boolean bFromPurchaseOrder = false;
                boolean bTransferReq = false;
                String fromIdx = "";
                if (newReceiptType) {
                    if (isCarton) {
                        fromIdx = Long.toString(carton.getFromIdx());
                        bFromPurchaseOrder = carton.getTranType().equals("PO");
                    } else if (isNonASN) {
                        fromIdx = Long.toString(nonASN.getFromIdx());
                        bFromPurchaseOrder = nonASN.GetTranType().equals("PO");
                    }
                } else {
                    fromIdx = root.getAttribute("widx").getValue();
                    if (root.getName().equals("porder")) {
                        bFromPurchaseOrder = true;
                    } else if (root.getName().equals("trans_req")) {
                        bTransferReq = true;
                    }
                }
                if (bFromPurchaseOrder) {
                    try (SqlQuery sql = new SqlQuery(this.conn, "SELECT NAME FROM SUPPLIER WHERE SUPIDX = " + fromIdx);){
                        if (sql.next()) {
                            sSupplierName = sql.getString(1);
                        }
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                }
                String sFromWhseNum = null;
                if (!bFromPurchaseOrder) {
                    whFrom = new Warehouse(PosUtils.longVal(fromIdx));
                    whFrom.loadWarehouse(this.conn);
                    sFromWhseNum = whFrom.getString("storeno");
                }
                r1.PrintString("\u001b\u0006");
                r1.PrintString("\u001b\u0001");
                if (bTransferReq) {
                    r1.PrintString(r1.FormatCentre(StoreParams.res.getString("TRANSFER__REQUEST_PICKLIST"), 42));
                } else {
                    r1.PrintString(r1.FormatCentre(StoreParams.res.getString("TRANSFER_CHECKLIST"), 42));
                }
                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintString("\u001b\u0005");
                r1.PrintString("\u001b\u0001");
                r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                r1.PrintString("\u001b\u0007");
                String sTransferNum = "";
                if (newReceiptType) {
                    if (isCarton) {
                        sTransferNum = carton.getTranNum();
                    } else if (isNonASN) {
                        sTransferNum = nonASN.GetTranNum();
                    }
                } else if (root.getAttribute("trans_number") != null) {
                    sTransferNum = root.getAttribute("trans_number").getValue();
                }
                if (bTransferReq) {
                    r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Transfer_Request_No_") + " " + sTransferNum, 56));
                } else {
                    r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Transfer_No_") + " " + sTransferNum, 56));
                }
                String connum = "";
                if (newReceiptType) {
                    if (isCarton) {
                        connum = carton.GetConNote();
                    } else if (isNonASN) {
                        connum = nonASN.GetConNote();
                    }
                } else if (root.getAttribute("notes2") != null) {
                    connum = root.getAttribute("notes2").getValue();
                }
                if (connum != null && !connum.isEmpty()) {
                    r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Connote_No_") + " " + connum, 56));
                }
                r1.PrintString("\u001b\u0005");
                r1.PrintString("\u001b\u0001");
                r1.Feed(1);
                String sDocNum = "";
                String sSalesRep = "";
                String sDate = "";
                if (root.getAttribute("docket_number") != null) {
                    sDocNum = "D" + sFromWhseNum + root.getAttribute("docket_number").getValue();
                }
                if (root.getAttribute("srepidx") != null) {
                    try (SqlQuery sql = new SqlQuery(this.conn, "SELECT FIRSTNAME FROM PERSON WHERE PERIDX = " + root.getAttribute("srepidx").getValue());){
                        if (sql.next()) {
                            sSalesRep = sql.getString(1);
                        }
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                }
                PosDateFormatter dateFormatter = null;
                try {
                    dateFormatter = new PosDateFormatter(null, 3, 3, 0);
                    if (newReceiptType) {
                        if (isCarton) {
                            dateFormatter.setTimestamp(new Timestamp(carton.GetShipDate().getTime()));
                        } else if (isNonASN) {
                            dateFormatter.setTimestamp(new Timestamp(nonASN.GetShipDate().getTime()));
                        }
                    } else if (root.getAttribute("trand") != null) {
                        dateFormatter.setTimestampInternal(root.getAttribute("trand").getValue());
                    }
                    sDate = dateFormatter.toString();
                }
                catch (Exception e) {
                    sDate = "";
                }
                if (!bTransferReq) {
                    r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Docket_No_"), StoreParams.res.getString("Processed_By"), this.sTillNumText, StoreParams.res.getString("Date")) + "\n");
                    r1.PrintString(r1.FormatDetailHdr(Gen.NVLString(sDocNum, "").equals("") ? StoreParams.res.getString("not_applicable") : sDocNum, Gen.NVLString(sSalesRep, "").equals("") ? StoreParams.res.getString("head_office") : sSalesRep, this.sTillNum, sDate) + "\n");
                    r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                    String sFromLocnidx = bFromPurchaseOrder ? "" : whFrom.getString("locnidx");
                    String sFromTradeName = bFromPurchaseOrder ? "" : whFrom.getString("tradename");
                    String sFromAddress1 = bFromPurchaseOrder ? "" : whFrom.getString("adrs1");
                    String sFromAddress2 = bFromPurchaseOrder ? "" : whFrom.getString("adrs2");
                    String sFromCity = bFromPurchaseOrder ? "" : whFrom.getString("city");
                    String sFromState = bFromPurchaseOrder ? "" : whFrom.getString("state");
                    String sFromPostcode = bFromPurchaseOrder ? "" : whFrom.getString("postcode");
                    String sFromPhone = "";
                    String sFromFax = "";
                    if (sFromLocnidx != null && !bFromPurchaseOrder) {
                        PhNums pn = new PhNums(sFromLocnidx);
                        pn.loadPhoneNumbers(this.conn);
                        sFromPhone = pn.getString(154L);
                        if (sFromPhone != null) {
                            sFromPhone = StoreParams.res.getString("Ph_") + " " + sFromPhone;
                        }
                        if ((sFromFax = pn.getString(373L)) != null) {
                            sFromFax = StoreParams.res.getString("Fax") + " " + sFromFax;
                        }
                    }
                    r1.PrintString("\u001b\u0007");
                    Object[] objs = new Object[]{"\n"};
                    r1.PrintString(MessageFormat.format(StoreParams.res.getString("Sent_from_n"), objs));
                    r1.PrintString("\u001b\u0005");
                    if (bFromPurchaseOrder) {
                        r1.PrintString("\u001b\u0007");
                        r1.PrintString("          " + sSupplierName + "\n");
                        r1.PrintString("\u001b\u0005");
                    } else {
                        if (sFromTradeName != null) {
                            r1.PrintString("\u001b\u0007");
                            r1.PrintString("          " + sFromWhseNum + " " + sFromTradeName + "\n");
                            r1.PrintString("\u001b\u0005");
                        }
                        r1.PrintString("\u001b\u0005");
                        if (sFromAddress1 != null) {
                            r1.PrintString("          " + sFromAddress1 + "\n");
                        }
                        if (sFromAddress2 != null) {
                            r1.PrintString("          " + sFromAddress2 + "\n");
                        }
                        String sFromCityStateAndPC = "";
                        if (sFromCity != null) {
                            sFromCityStateAndPC = sFromCity;
                        }
                        if (sFromState != null) {
                            sFromCityStateAndPC = sFromCityStateAndPC + (sFromCityStateAndPC.equals("") ? "" : " ") + sFromState;
                        }
                        if (sFromPostcode != null) {
                            sFromCityStateAndPC = sFromCityStateAndPC + (sFromCityStateAndPC.equals("") ? "" : " ") + sFromPostcode;
                        }
                        if (sFromCityStateAndPC.length() > 0) {
                            r1.PrintString("          " + sFromCityStateAndPC + "\n");
                        }
                        if (sFromPhone != null) {
                            r1.PrintString("          " + sFromPhone + "\n");
                        }
                        if (sFromFax != null) {
                            r1.PrintString("          " + sFromFax + "\n");
                        }
                    }
                    r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                }
                Warehouse whTo = bTransferReq ? new Warehouse(PosUtils.longVal(root.getAttribute("to_widx").getValue())) : new Warehouse(PosUtils.longVal(SP.sParams.getStoreIdx()));
                whTo.loadWarehouse(this.conn);
                String sToWhseNum = whTo.getString("storeno");
                String sToLocnidx = whTo.getString("locnidx");
                String sToTradeName = whTo.getString("tradename");
                String sToAddress1 = whTo.getString("adrs1");
                String sToAddress2 = whTo.getString("adrs2");
                String sToCity = whTo.getString("city");
                String sToState = whTo.getString("state");
                String sToPostcode = whTo.getString("postcode");
                String sToPhone = "";
                String sToFax = "";
                if (sToLocnidx != null) {
                    PhNums pn = new PhNums(sToLocnidx);
                    pn.loadPhoneNumbers(this.conn);
                    sToPhone = pn.getString(154L);
                    if (sToPhone != null) {
                        sToPhone = StoreParams.res.getString("Ph_") + " " + sToPhone;
                    }
                    if ((sToFax = pn.getString(373L)) != null) {
                        sToFax = StoreParams.res.getString("Fax") + " " + sToFax;
                    }
                }
                r1.PrintString("\u001b\u0007");
                Object[] objs2 = new Object[]{"\n"};
                if (bTransferReq) {
                    r1.PrintString(MessageFormat.format(StoreParams.res.getString("Transfer_to_n"), objs2));
                } else {
                    r1.PrintString(MessageFormat.format(StoreParams.res.getString("Deliver_to_n"), objs2));
                }
                r1.PrintString("\u001b\u0005");
                if (sToTradeName != null) {
                    r1.PrintString("\u001b\u0007");
                    r1.PrintString("          " + sToWhseNum + " " + sToTradeName + "\n");
                    r1.PrintString("\u001b\u0005");
                }
                r1.PrintString("\u001b\u0005");
                if (sToAddress1 != null) {
                    r1.PrintString("          " + sToAddress1 + "\n");
                }
                if (sToAddress2 != null) {
                    r1.PrintString("          " + sToAddress2 + "\n");
                }
                String sToCityStateAndPC = "";
                if (sToCity != null) {
                    sToCityStateAndPC = sToCity;
                }
                if (sToState != null) {
                    sToCityStateAndPC = sToCityStateAndPC + (sToCityStateAndPC.equals("") ? "" : " ") + sToState;
                }
                if (sToPostcode != null) {
                    sToCityStateAndPC = sToCityStateAndPC + (sToCityStateAndPC.equals("") ? "" : " ") + sToPostcode;
                }
                if (sToCityStateAndPC.length() > 0) {
                    r1.PrintString("          " + sToCityStateAndPC + "\n");
                }
                if (sToPhone != null) {
                    r1.PrintString("          " + sToPhone + "\n");
                }
                if (sToFax != null) {
                    r1.PrintString("          " + sToFax + "\n");
                }
                Object receipt = isCarton ? carton : (isNonASN ? nonASN : null);
                this.printNotesSection(root, r1, newReceiptType, receipt);
                this.printProductUnitsSection(root, r1, newReceiptType, receipt);
                if (newReceiptType) {
                    if (bFromPurchaseOrder) {
                        r1.PrintBarcode("\u0004", "P" + sTransferNum, "B", false);
                        r1.PrintString(r1.FormatCentre("P" + sTransferNum, 56));
                    } else {
                        r1.PrintBarcode("\u0004", "T" + sTransferNum, "B", false);
                        r1.PrintString(r1.FormatCentre("T" + sTransferNum, 56));
                    }
                } else if (root.getName().equals("transaction")) {
                    r1.PrintBarcode("\u0004", sDocNum, "B", false);
                    r1.PrintString(r1.FormatCentre(sDocNum, 56));
                } else if (root.getName().equals("transfer")) {
                    r1.PrintBarcode("\u0004", "T" + sTransferNum, "B", false);
                    r1.PrintString(r1.FormatCentre("T" + sTransferNum, 56));
                } else if (root.getName().equals("porder")) {
                    r1.PrintBarcode("\u0004", "P" + sTransferNum, "B", false);
                    r1.PrintString(r1.FormatCentre("P" + sTransferNum, 56));
                }
                r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                r1.FeedAndCut();
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
        }
        Gen.PrintImage(this.sPrinterPort, this.sImagePath);
        return true;
    }

    private void printProductUnitsSection(Element root, PrintReceipt r1, boolean newReceiptType, Object receipt) {
        try {
            Carton carton = null;
            NonASNTransaction nonASN = null;
            if (newReceiptType) {
                if (receipt instanceof Carton) {
                    carton = (Carton)receipt;
                } else if (receipt instanceof NonASNTransaction) {
                    nonASN = (NonASNTransaction)receipt;
                }
            }
            r1.PrintString("\u001b\u0007");
            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Product_Description_n"), 44));
            if (SP.sParams.bUsingSOHInCustOrders) {
                r1.PrintString(r1.FormatRight(StoreParams.res.getString("Soh_Units"), 6));
                r1.PrintString(r1.FormatRight(StoreParams.res.getString("Qty_Units"), 6) + "\n");
            } else {
                r1.PrintString(r1.FormatRight(StoreParams.res.getString("Qty_Units"), 12) + "\n");
            }
            r1.PrintString("\u001b\u0005");
            double total = 0.0;
            Vector<Detail> details = new Vector<Detail>();
            if (newReceiptType) {
                Detail detail;
                if (carton != null) {
                    for (CartonItem cartonItem : carton.getItems()) {
                        if (!(cartonItem.getQty() >= 0.0)) continue;
                        detail = new Detail();
                        detail.nSkuIdx = cartonItem.getSkuidx();
                        detail.nQty = cartonItem.getQty();
                        details.add(detail);
                    }
                } else if (nonASN != null) {
                    for (TransactionItem transactionItem : nonASN.getItems()) {
                        if (!(transactionItem.getQty() - transactionItem.getPrevReceivedQty() >= 0.0)) continue;
                        detail = new Detail();
                        detail.nSkuIdx = transactionItem.getSkuidx();
                        detail.nQty = transactionItem.getQty() - transactionItem.getPrevReceivedQty();
                        details.add(detail);
                    }
                }
            } else {
                for (Element element : root.getChildren("styles")) {
                    for (Element style : element.getChildren()) {
                        if (!style.getName().equals("style")) continue;
                        long skuidx = PosUtils.longVal(style.getAttribute("skuidx").getValue());
                        boolean sohQtyAvailable = style.getAttribute("soh_qty") != null;
                        double sohQty = sohQtyAvailable ? PosUtils.doubleValInternal(style.getAttribute("soh_qty").getValue()) : 0.0;
                        double qty = PosUtils.doubleValInternal(style.getText());
                        double packed = style.getAttribute("packed") != null ? PosUtils.doubleValInternal(style.getAttribute("packed").getValue()) : 0.0;
                        String sCustomisation = style.getAttribute("customisation") != null ? SP.getRS("Customisation_Text", style.getAttribute("customisation").getValue()) : "";
                        boolean found = false;
                        for (Detail detail : details) {
                            if (detail.nSkuIdx != skuidx || !detail.sCustomisation.contentEquals(sCustomisation)) continue;
                            detail.nQty += qty - packed;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        Detail detail = new Detail();
                        detail.nSkuIdx = skuidx;
                        detail.bSohQtyAvailable = SP.sParams.bUsingSOHInCustOrders && sohQtyAvailable;
                        detail.nSohQty = sohQty;
                        detail.nQty = qty - packed;
                        detail.sCustomisation = sCustomisation;
                        details.add(detail);
                    }
                }
            }
            String detailsSql = null;
            String[] stringArray = StringUtils.nullToEmpty(SystemSettings.getInstance().getText(SystemSettings.SystemSetting.PICKLIST_REFERENCE)).split("@");
            if (stringArray.length >= 2) {
                String table = stringArray[0];
                String column = stringArray[1];
                detailsSql = "SELECT COALESCE(STYLE.STYLECODE, ''), COALESCE(STYLE.NAME, ''), COALESCE(CLR.CLRNAME, ''), COALESCE(SKU.SIZEVAL, ''), COALESCE(REFCODE.NAME, '') FROM SKU JOIN CLR ON SKU.CLRIDX = CLR.CLRIDX JOIN STYLE ON CLR.STYLEIDX = STYLE.STYLEIDX LEFT JOIN REFCODE ON REFCODE.RCIDX = " + table + "." + column + " WHERE SKU.SKUIDX = ";
            } else {
                detailsSql = "SELECT COALESCE(STYLE.STYLECODE, ''), COALESCE(STYLE.NAME, ''), COALESCE(CLR.CLRNAME, ''), COALESCE(SKU.SIZEVAL, ''), '' FROM SKU JOIN CLR ON SKU.CLRIDX = CLR.CLRIDX JOIN STYLE ON CLR.STYLEIDX = STYLE.STYLEIDX WHERE SKU.SKUIDX = ";
            }
            for (Detail detail : details) {
                if (detail.nQty == 0.0) continue;
                SqlQuery sql = new SqlQuery(this.conn, detailsSql + detail.nSkuIdx);
                Throwable throwable = null;
                try {
                    String[] lines;
                    if (!sql.next()) continue;
                    int descriptionWidth = SP.sParams.bUsingSOHInCustOrders ? 44 : 50;
                    try {
                        String description = this.WrapText(String.format("%s %s %s %s %s", sql.getString(1), sql.getString(2), sql.getString(3), sql.getString(4), sql.getString(5)).trim(), descriptionWidth - 14, descriptionWidth);
                        description = description + (StringUtils.isNullOrEmpty(detail.sCustomisation) ? "" : String.format("\n%s", detail.sCustomisation));
                        lines = description.split("\n");
                    }
                    catch (Exception e) {
                        lines = new String[]{this.TruncateTransferDetails(sql.getString(1), sql.getString(2), sql.getString(3), sql.getString(4), descriptionWidth)};
                    }
                    r1.PrintString(r1.FormatLeft(lines[0], descriptionWidth));
                    if (SP.sParams.bUsingSOHInCustOrders) {
                        if (detail.bSohQtyAvailable) {
                            r1.PrintString(r1.FormatRight(this.dfQty.format(detail.nSohQty), 6));
                        } else {
                            r1.PrintString(r1.FormatRight(" ", 6));
                        }
                    }
                    r1.PrintString(r1.FormatRight(this.dfQty.format(detail.nQty), 6) + "\n");
                    for (int i = 1; i < lines.length; ++i) {
                        r1.PrintString(r1.FormatLeft(lines[i], descriptionWidth) + "\n");
                    }
                    total += detail.nQty;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (sql == null) continue;
                    if (throwable != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    sql.close();
                }
            }
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
            r1.PrintString("\u001b\u0007");
            r1.PrintString(r1.FormatRight(StoreParams.res.getString("Total_1"), 40));
            r1.PrintString(r1.FormatRight(this.dfQty.format(total), 16) + "\n");
            r1.PrintString("\u001b\u0005");
            r1.Feed(1);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private void printNotesSection(Element root, PrintReceipt r1) {
        this.printNotesSection(root, r1, false, null);
    }

    private void printNotesSection(Element root, PrintReceipt r1, boolean newReceiptType, Object receipt) {
        NonASNTransaction nonASN = null;
        Carton carton = null;
        if (newReceiptType) {
            if (receipt instanceof Carton) {
                carton = (Carton)receipt;
            } else if (receipt instanceof NonASNTransaction) {
                nonASN = (NonASNTransaction)receipt;
            }
        }
        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
        r1.Feed(1);
        r1.PrintString("\u001b\u0007");
        r1.PrintString(StoreParams.res.getString("Date_1") + "\n");
        r1.Feed(1);
        Object[] objs5 = new Object[]{"\n"};
        r1.PrintString(MessageFormat.format(StoreParams.res.getString("Notes_n"), objs5));
        r1.PrintString("\u001b\u0005");
        if (newReceiptType) {
            if (nonASN != null && nonASN.getDelIns() != null && !nonASN.getDelIns().isEmpty()) {
                r1.PrintString(nonASN.getDelIns());
            } else if (carton != null && carton.getDelIns() != null && !carton.getDelIns().isEmpty()) {
                r1.PrintString(carton.getDelIns());
            }
        } else if (root.getAttribute("notes1") != null) {
            r1.PrintString(root.getAttribute("notes1").getValue());
        }
        r1.Feed(3);
        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
        r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean printSpecialOrder(Element root) {
        Throwable throwable;
        PrintReceipt r1;
        int i;
        this.bSaleHasACreditNote = false;
        for (i = 0; i < Gen.SPECIAL_ORDERS_CUST_COPIES; ++i) {
            try {
                r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);
                throwable = null;
                try {
                    if (i == 0 && Gen.openTillRequired(this.conn, this.nTransIdx) && !this.reprint) {
                        r1.OpenCashDrawer();
                    }
                    if (!this.printHeader(HeaderType.SPECIAL_ORDER_CUST, r1)) {
                        this.errorHandler.setError("");
                        boolean bl = false;
                        return bl;
                    }
                    this.printOrderDetails(r1, root, Gen.DocketType.SPECIAL_ORDER, true);
                    this.printFooter(FooterType.SPECIAL_ORDER, r1);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r1 != null) {
                        if (throwable != null) {
                            try {
                                r1.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            r1.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            this.reprint = true;
        }
        this.resetReprint();
        for (i = 0; i < Gen.SPECIAL_ORDERS_STORE_COPIES; ++i) {
            try {
                r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);
                throwable = null;
                try {
                    if (!this.printHeader(HeaderType.SPECIAL_ORDER_STORE, r1)) {
                        this.errorHandler.setError("");
                        boolean bl = false;
                        return bl;
                    }
                    this.printOrderDetails(r1, root, Gen.DocketType.SPECIAL_ORDER, false);
                    this.printFooter(FooterType.SPECIAL_ORDER, r1);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (r1 != null) {
                        if (throwable != null) {
                            try {
                                r1.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            r1.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
            this.reprint = true;
        }
        this.resetReprint();
        if (this.bSaleHasACreditNote) {
            this.printCreditNote(false, root.getName().equals("person") ? root : root.getChild("person"), -1L);
        }
        if (!this.bSaleHasCredNoteGiftVouch) return true;
        this.printCreditNoteGiftVoucher(false, root.getName().equals("person") ? root : root.getChild("person"), -1L);
        return true;
    }

    private long printAccountPaymentDetails(PrintReceipt r1, Element root) {
        String sTransIdx = String.valueOf(this.nTransIdx);
        long trtype = -1L;
        String sLoyaltyCards = "";
        try {
            Object dateFormatter;
            block60: {
                try (SqlQuery sql = new SqlQuery(this.conn, "SELECT H.VHIDX, H.DOCKET_NUMBER, H.TRANSSREPIDX, H.TRAND, H.TRAND, COALESCE(P.FIRSTNAME, ''), H.TRANS_NUMBER, SUM(PH.PAYMENT_AMOUNT), H.TR_TYPE, H.TRANS_NUMBER, OS.CODE, OSW.STORENO FROM RET_TRANH H LEFT JOIN PERSON P ON " + this.servedByJoin + " = P.PERIDX LEFT JOIN REFCODE OS ON H.FROM_WIDX = OS.RCIDX LEFT JOIN WHSE OSW ON OS.RCIDX = OSW.WIDX LEFT OUTER JOIN RET_TRANP PH ON PH.VHIDX = H.VHIDX AND PH.\"ACTIVE\" = 1  WHERE H.\"ACTIVE\" = 1 AND H.VHIDX = " + sTransIdx + " GROUP BY H.VHIDX, H.DOCKET_NUMBER, H.TRANSSREPIDX, H.TRAND, H.TRAND, COALESCE(P.FIRSTNAME, ''), H.TRANS_NUMBER, H.TR_TYPE, H.TRANS_NUMBER, OS.CODE, OSW.STORENO  ");){
                    String sTranDate;
                    if (!sql.next()) break block60;
                    dateFormatter = new PosDateFormatter(sql.getTimestamp(4));
                    try {
                        ((PosDateFormatter)dateFormatter).setFormat(3, 3, 2);
                        sTranDate = ((PosDateFormatter)dateFormatter).toString();
                    }
                    catch (Exception e) {
                        sTranDate = "";
                    }
                    String sSalesRep = sql.getString(6);
                    trtype = sql.getLong(9);
                    String sOrigDoc = sql.getString(10);
                    String sOrigStore = sql.getString(11);
                    String sOrigStoreNo = sql.getString(12);
                    if (!Gen.NVLString(sOrigDoc, "").equals("") && sOrigStore != null) {
                        r1.PrintString("\u001b\u0001");
                        r1.PrintString("\u001b\u0007");
                        r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Original_Store_") + " " + sOrigStore, 56));
                        r1.PrintString(r1.FormatCentre(StoreParams.res.getString("Original_Docket_No_") + " D" + sOrigStoreNo + sOrigDoc, 56) + "\n");
                    }
                    Element person = root;
                    if (root != null) {
                        if (root.getChild("person") != null) {
                            person = root.getChild("person");
                        } else if (root.getChild("cust") != null && root.getChild("cust").getChild("person") != null) {
                            person = root.getChild("cust").getChild("person");
                        }
                    }
                    sLoyaltyCards = this.getLoyaltyCards(PosUtils.longVal(sTransIdx), person);
                    r1.PrintString("\u001b\u0005");
                    r1.PrintString("\u001b\u0001");
                    r1.PrintString(r1.FormatDetailHdr(StoreParams.res.getString("Docket_No_"), StoreParams.res.getString("Served_By"), this.sTillNumText, StoreParams.res.getString("Date_Time")) + "\n");
                    r1.PrintString(r1.FormatDetailHdr(this.sDocNum, sSalesRep, this.sTillNum, sTranDate) + "\n");
                    r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    if (root != null) {
                        Element custPrinter = root.getName().equals("transaction") ? root.getChild("cust") : root;
                        boolean printTerms = sql.getDouble(8) > 0.0 && custPrinter != null && custPrinter.getName().equals("cust");
                        this.printCustDets(r1, custPrinter, sql.getDouble(8) > 0.0 && printTerms, sLoyaltyCards, this.printCustAddr);
                        r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                    }
                }
            }
            boolean bfoundAccPayment = false;
            SqlQuery sql = new SqlQuery(this.conn, "SELECT  P.PAYMENT_AMOUNT, COALESCE(P.EFTPOS_CARDTYPE || ' ' || P.EFTPOS_ACTYPE, COALESCE(PT.ALT_CODE, R.NAME)) FROM RET_TRANP P, REFCODE R LEFT OUTER JOIN RET_PAY_TYPES PT ON R.RCIDX = PT.RCIDX WHERE P.PAYMENT_TYPEIDX = 647 AND P.\"ACTIVE\" = 1 AND P.PAYMENT_TYPEIDX = R.RCIDX AND P.VHIDX = " + sTransIdx + " ORDER BY P.SEQUENCE_NUMBER ");
            dateFormatter = null;
            try {
                while (sql.next()) {
                    if (!bfoundAccPayment) {
                        r1.PrintString("\u001b\u0007");
                        bfoundAccPayment = true;
                    }
                    r1.PrintString(r1.FormatLeft(sql.getString(2), 40));
                    r1.PrintString(r1.FormatRight(this.dfTot.format(sql.getDouble(1) * -1.0), 16) + "\n");
                }
            }
            catch (Throwable throwable) {
                dateFormatter = throwable;
                throw throwable;
            }
            finally {
                if (sql != null) {
                    if (dateFormatter != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)dateFormatter).addSuppressed(throwable);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
            r1.PrintString("\u001b\u0007");
            r1.PrintString(r1.FormatLeft(StoreParams.res.getString("Payment_Details_"), 40) + "\n");
            r1.PrintString("\u001b\u0005");
            String eftDets = "";
            String sRemainingValue = "";
            String sVoucherName = "";
            try (SqlQuery sql2 = new SqlQuery(this.conn, "SELECT  P.PAYMENT_AMOUNT, COALESCE(P.EFTPOS_CARDTYPE || ' ' || P.EFTPOS_ACTYPE, COALESCE(PT.ALT_CODE, R.NAME)), R.RCIDX, P.PAYMENT_NUMBER, T.BLOBTEXT FROM RET_TRANP P LEFT JOIN EFT_TRANDETS E ON E.VSHIDX = P.VSHIDX  LEFT JOIN BLOBTEXT T ON T.BLOBIDX = E.DOCKET_BLOBIDX, REFCODE R LEFT OUTER JOIN RET_PAY_TYPES PT ON R.RCIDX = PT.RCIDX WHERE P.\"ACTIVE\" = 1 AND P.PAYMENT_TYPEIDX = R.RCIDX AND P.PAYMENT_TYPEIDX <> 647 AND P.VHIDX = " + sTransIdx + " ORDER BY P.SEQUENCE_NUMBER ");){
                while (sql2.next()) {
                    long nPayIdx = sql2.getLong(3);
                    double nPayAmt = sql2.getDouble(1);
                    String sPayType = sql2.getString(2);
                    String sPayNumber = sql2.getString(4);
                    if (nPayIdx != 518L && !PayTypes.getPayType((long)nPayIdx).isCreditNote && nPayAmt < 0.0) {
                        sPayType = StoreParams.res.getString("Change_") + sPayType + StoreParams.res.getString("KEY3");
                    }
                    if (PayTypes.getPayType((long)nPayIdx).isCreditNote) {
                        if (sPayNumber != null) {
                            sPayType = sPayType + ": " + sPayNumber;
                        }
                        if (nPayAmt < 0.0) {
                            this.bSaleHasACreditNote = true;
                        }
                    }
                    sRemainingValue = "";
                    if (PayTypes.getPayType((long)nPayIdx).isVoucher && sPayNumber != null) {
                        VoucherLoadAdapter voucherAdapter = new VoucherLoadAdapter();
                        voucherAdapter.processNumber(sPayNumber);
                        if (voucherAdapter.getVoucher() != null) {
                            sVoucherName = voucherAdapter.getVoucher().getVoucherType().getName();
                            if (sVoucherName.length() > 25) {
                                sVoucherName = sVoucherName.substring(0, 25);
                            }
                            sPayType = sVoucherName + ": " + voucherAdapter.getVoucher().getDisplayNumber();
                            if (voucherAdapter.getVoucher().getVoucherType().getBalanceRules() == VoucherType.BalanceRules.RETAIN_VALUE) {
                                Object[] objs = new Object[]{this.dfDet.format(voucherAdapter.getVoucher().getAvailableAmount())};
                                sRemainingValue = MessageFormat.format(StoreParams.res.getString("remaining_voucher_amount"), objs);
                            }
                        } else {
                            sPayType = sPayType + ": " + sPayNumber;
                        }
                    }
                    if (nPayIdx == 518L && (nPayAmt = Gen.RoundNumber(nPayAmt, this.nPrec)) != 0.0) {
                        nPayAmt *= -1.0;
                    }
                    if (sql2.getString(5) != null) {
                        eftDets = eftDets + sql2.getString(5);
                    }
                    if (this.nTrType == 558L && nPayIdx == 420L) continue;
                    String sPayAmt = this.dfDet.format(nPayAmt);
                    r1.PrintString(r1.FormatLeft("  " + sPayType, 40));
                    r1.PrintString(r1.FormatRight(sPayAmt, 16) + "\n");
                    if (sRemainingValue.equals("")) continue;
                    r1.PrintString(r1.FormatLeft("  " + sRemainingValue, 40) + "\n");
                }
            }
            this.printEftDets(r1, eftDets);
            this.printSignature(r1);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return trtype;
    }

    private void printOpenTillDocket(long transIdx) {
        block56: {
            if (transIdx != 0L) {
                try (PreparedStatement prepStmt = this.conn.prepareStatement("SELECT W.STORENO, R_WHSE.NAME, H.TRAND, H.TILL_NUMBER, H.DOCKET_NUMBER, COALESCE(P.FIRSTNAME, ' ') || ' ' || COALESCE(P.SURNAME, ' '), REASON.NAME, H.NOTES1  FROM RET_TRANH H, WHSE W, REFCODE R_WHSE, PERSON P, REFCODE REASON WHERE R_WHSE.RCIDX = W.WIDX AND W.WIDX = H.WIDX AND " + this.servedByJoin + " = P.PERIDX AND H.FREASIDX = REASON.RCIDX AND H.\"ACTIVE\" = 1 AND H.VHIDX = ?");){
                    prepStmt.setLong(1, transIdx);
                    try (ResultSet result = prepStmt.executeQuery();){
                        if (!result.next()) break block56;
                        String storeNumber = Gen.NullToEmpty(result.getString(1));
                        String storeName = Gen.NullToEmpty(result.getString(2));
                        String date = null;
                        PosDateFormatter dateFormatter = new PosDateFormatter(result.getTimestamp(3));
                        try {
                            dateFormatter.setFormat(3, 3, 2);
                            date = Gen.NullToEmpty(dateFormatter.toString());
                        }
                        catch (Exception e) {
                            date = "";
                        }
                        String tillNumber = Gen.NullToEmpty(result.getString(4));
                        String docketNumber = "D" + Gen.NullToEmpty(storeNumber) + Gen.NullToEmpty(result.getString(5));
                        String operator = Gen.NullToEmpty(result.getString(6)).trim();
                        String reason = Gen.NullToEmpty(result.getString(7));
                        String notes = Gen.NullToEmpty(result.getString(8));
                        try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
                            r1.PrintString("\u001b\u0001");
                            r1.PrintString("\u001b\u0006");
                            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                            if (this.reprint) {
                                r1.PrintString(r1.FormatCentre(StoreParams.res.getString("REPRINT"), 42));
                                r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                            }
                            r1.PrintString(r1.FormatCentre(SP.getRS("Open_Till_Docket_Header"), 42));
                            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                            r1.PrintString("\u001b\u0005");
                            r1.PrintString("\u001b\u0001");
                            r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
                            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                            r1.PrintString(r1.FormatLeft(SP.getRS("Store_Number"), 28));
                            r1.PrintString(r1.FormatLeft(storeNumber, 28));
                            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                            r1.PrintString(r1.FormatLeft(SP.getRS("Store_Name"), 28));
                            r1.PrintString(r1.FormatLeft(storeName, 28));
                            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                            r1.PrintString(r1.FormatLeft(SP.getRS("Date_Time"), 28));
                            r1.PrintString(r1.FormatLeft(date, 28));
                            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                            r1.PrintString(r1.FormatLeft(SP.getRS("Till_Number"), 28));
                            r1.PrintString(r1.FormatLeft(tillNumber, 28));
                            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                            r1.PrintString(r1.FormatLeft(SP.getRS("Docket_Number"), 28));
                            r1.PrintString(r1.FormatLeft(docketNumber, 28));
                            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                            r1.PrintString(r1.FormatLeft(SP.getRS("Operator"), 28));
                            r1.PrintString(r1.FormatLeft(operator, 28));
                            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                            r1.PrintString(r1.FormatLeft(SP.getRS("Reason"), 28));
                            r1.PrintString(r1.FormatLeft(reason, 28));
                            r1.Feed(1, PrintReceipt.DocketFormat.LONG_ONLY);
                            r1.PrintString(r1.FormatLeft(SP.getRS("Notes"), 28));
                            r1.PrintString(notes);
                            r1.Feed(3);
                            r1.PrintString("\u001b\u0007");
                            r1.PrintString(StoreParams.res.getString("Operator_Signature") + "\n");
                            r1.FeedAndCut();
                        }
                        catch (IOException e) {
                            this.errorHandler.setError(e);
                            if (result != null) {
                                if (var6_8 != null) {
                                    try {
                                        result.close();
                                    }
                                    catch (Throwable throwable) {
                                        var6_8.addSuppressed(throwable);
                                    }
                                } else {
                                    result.close();
                                }
                            }
                            if (prepStmt != null) {
                                if (var4_4 != null) {
                                    try {
                                        prepStmt.close();
                                    }
                                    catch (Throwable throwable) {
                                        var4_4.addSuppressed(throwable);
                                    }
                                } else {
                                    prepStmt.close();
                                }
                            }
                            return;
                        }
                        Gen.PrintImage(this.sPrinterPort, this.sImagePath);
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
    }

    public boolean printText(String sText) {
        if (sText != null && !sText.equals("")) {
            if (this.sPrinterPort == null) {
                this.errorHandler.setError("Printer not set up");
                return false;
            }
            try (PrintReceipt r1 = new PrintReceipt(this.sPrinterPort, this.sPrinterFont);){
                r1.PrintString("\u001b\u0001");
                r1.PrintString("\u001b\u0004");
                r1.PrintString(sText);
                r1.Feed(1);
                r1.FeedAndCut();
            }
            catch (IOException e) {
                this.errorHandler.setError(e);
                return false;
            }
            Gen.PrintImage(this.sPrinterPort, this.sImagePath);
        }
        return true;
    }

    private void printSignature(PrintReceipt r1) {
        r1.Feed(1);
        r1.PrintString("\u001b\u0007");
        String s = SP.getRS("Signature_1");
        r1.PrintString(s + " " + r1.repeatChar('.', r1.getLineWidth() - s.length() - 1) + "\n");
        r1.Feed(1);
        s = SP.getRS("Date_1");
        r1.PrintString(s + " " + r1.repeatChar('.', r1.getLineWidth() - s.length() - 1) + "\n");
        r1.Feed(1);
        r1.PrintString("\u001b\u0005");
    }

    private void printReturnSignature(PrintReceipt r1) {
        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.EXTENDED_SIGNATURE_PANEL_ON_RETURN_DOCKETS)) {
            r1.Feed(1);
            r1.PrintString("\u001b\u0007");
            String s = SP.getRS("Customer_Signature");
            r1.PrintString(s + " " + r1.repeatChar('.', r1.getLineWidth() - s.length() - 1) + "\n");
            r1.Feed(1);
            s = SP.getRS("Customer_Address");
            r1.PrintString(s + " " + r1.repeatChar('.', r1.getLineWidth() - s.length() - 1) + "\n");
            r1.Feed(1);
            r1.PrintString(r1.repeatChar('.', r1.getLineWidth()) + "\n");
            r1.Feed(1);
            s = SP.getRS("Contact_Phone_Number");
            r1.PrintString(s + " " + r1.repeatChar('.', r1.getLineWidth() - s.length() - 1) + "\n");
            r1.Feed(1);
            s = SP.getRS("Date_1");
            r1.PrintString(s + " " + r1.repeatChar('.', r1.getLineWidth() - s.length() - 1) + "\n");
            r1.Feed(1);
            s = SP.getRS("Salesperson_Sign_Print");
            r1.PrintString(s + " " + r1.repeatChar('.', r1.getLineWidth() - s.length() - 1) + "\n");
            r1.Feed(1);
            s = SP.getRS("Authorised_Sign_Print");
            r1.PrintString(s + " " + r1.repeatChar('.', r1.getLineWidth() - s.length() - 1) + "\n");
            r1.Feed(1);
            r1.PrintString("\u001b\u0005");
        } else {
            r1.Feed(1);
            r1.PrintString("\u001b\u0007");
            String s = SP.getRS("Customer_Signature");
            r1.PrintString(s + " " + r1.repeatChar('.', r1.getLineWidth() - s.length() - 1) + "\n");
            r1.Feed(1);
            s = SP.getRS("Salesperson_Signature");
            r1.PrintString(s + " " + r1.repeatChar('.', r1.getLineWidth() - s.length() - 1) + "\n");
            r1.Feed(1);
            s = SP.getRS("Date_1");
            r1.PrintString(s + " " + r1.repeatChar('.', r1.getLineWidth() - s.length() - 1) + "\n");
            r1.Feed(1);
            r1.PrintString("\u001b\u0005");
        }
    }

    private void printEftDets(PrintReceipt r1, String eftDets) {
        if (!eftDets.equals("")) {
            r1.PrintString("\u001b\u0005");
            r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
            r1.Feed(1);
            r1.PrintString(eftDets);
            r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
        }
    }

    private String WrapText(String text, int minWidth, int maxWidth) {
        if (minWidth < 0 || maxWidth < 1 || maxWidth < minWidth || StringUtils.nullToEmpty(text).length() < maxWidth) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (pos < text.length()) {
            boolean wordWrapped = false;
            for (int i = maxWidth; i >= minWidth; --i) {
                if (text.charAt(pos + i) != ' ') continue;
                sb.append(text.substring(pos, pos + i) + "\n");
                pos += i + 1;
                wordWrapped = true;
                break;
            }
            if (!wordWrapped) {
                sb.append(text.substring(pos, pos + maxWidth - 1) + "-\n");
                pos += maxWidth - 1;
            }
            if (text.length() - pos > maxWidth) continue;
            sb.append(text.substring(pos, text.length()));
            break;
        }
        return sb.toString();
    }

    private String TruncateTransferDetails(String sStyleCode, String sStyleName, String sClrName, String sSizeVal, int width) {
        int disLength;
        int length = sStyleCode.length() + sStyleName.length() + sClrName.length() + sSizeVal.length();
        if (length > width && sStyleCode.length() > this.maxProdCodeLen) {
            length = length - sStyleCode.length() + this.maxProdCodeLen;
            sStyleCode = sStyleCode.substring(0, this.maxProdCodeLen);
        }
        int n = disLength = this.maxProdCodeLen > 10 ? 10 : 15;
        if (length > width && sStyleName.length() > disLength) {
            length = length - sStyleName.length() + disLength;
            sStyleName = sStyleName.substring(0, disLength);
        }
        if (length > width && sClrName.length() > disLength) {
            length = length - sClrName.length() + disLength;
            sClrName = sClrName.substring(0, disLength);
        }
        if (length > width) {
            sSizeVal = sSizeVal.substring(0, sSizeVal.length() - length + width);
        }
        return sStyleCode + sStyleName + sClrName + sSizeVal + " ";
    }

    private void printDeliveryAddress(PrintReceipt r1, long vhidx) {
        DeliveryInfo d = new DeliveryInfo();
        d.populateFromDatabase(vhidx);
        if (d.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY || d.getDeliveryOption() == DeliveryInfo.DeliveryOptions.SPLIT) {
            r1.PrintString("\u001b\u0001");
            r1.PrintString("\u001b\u0007");
            r1.PrintString(SP.getRS("Deliver_To") + "\n");
            r1.PrintString("\u001b\u0005");
            if (d.getContactName().length() > 0) {
                r1.PrintString(r1.FormatLeft(d.getContactName(), 56));
            }
            if (d.getAddressLine1().length() > 0) {
                r1.PrintString(r1.FormatLeft(d.getAddressLine1(), 56));
            }
            if (d.getAddressLine2().length() > 0) {
                r1.PrintString(r1.FormatLeft(d.getAddressLine2(), 56));
            }
            String sCityStateAndPC = "";
            if (d.getCity().length() > 0) {
                sCityStateAndPC = d.getCity();
            }
            if (d.getState().length() > 0) {
                sCityStateAndPC = sCityStateAndPC + (sCityStateAndPC.equals("") ? "" : " ") + d.getState();
            }
            if (d.getPostcode().length() > 0) {
                sCityStateAndPC = sCityStateAndPC + (sCityStateAndPC.equals("") ? "" : " ") + d.getPostcode();
            }
            if (sCityStateAndPC.length() > 0) {
                r1.PrintString(r1.FormatLeft(sCityStateAndPC, 56));
            }
            if (d.getCountry().getName().length() > 0) {
                r1.PrintString(r1.FormatLeft(d.getCountry().getName(), 56));
            }
            if (d.getPhone().length() > 0) {
                r1.PrintString(r1.FormatLeft(SP.getRS("Ph_") + " " + d.getPhone(), 56));
            }
            if (d.getDeliveryMethod() != null && d.getDeliveryMethod().getName().length() > 0) {
                r1.PrintString(r1.FormatLeft(MessageFormat.format(SP.getRS("Delivery_Method_x"), d.getDeliveryMethod().getName()), 56));
            }
            r1.PrintString("________________________________________________________\n", PrintReceipt.DocketFormat.LONG_ONLY);
        }
    }

    private double getTotalPromoVoucherPayments(long vhidx) {
        double promoPayments = 0.0;
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT P.PAYMENT_NUMBER, P.PAYMENT_AMOUNT, P.PAYMENT_TYPEIDX FROM RET_TRANP P WHERE P.\"ACTIVE\" = 1 and P.PAYMENT_NUMBER IS NOT NULL AND P.VHIDX = " + vhidx);){
            while (sql.next()) {
                VoucherType type;
                PayType payType = null;
                try {
                    payType = PayTypes.getPayType(sql.getLong("PAYMENT_TYPEIDX"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (payType == null || !payType.isVoucher || (type = VoucherUtils.getVoucherType(sql.getString("PAYMENT_NUMBER"))) == null || type.getIssueType() != VoucherType.IssueType.PROMO) continue;
                promoPayments += sql.getDouble("PAYMENT_AMOUNT");
            }
        }
        catch (SQLException e) {
            promoPayments = 0.0;
            this.errorHandler.setError(e);
        }
        return promoPayments;
    }

    private double adjustTaxForPromoVouchers(double totalSaleIncTax, double totalTax, double totalPromoVoucher) {
        if (totalSaleIncTax == 0.0) {
            return totalTax;
        }
        return totalTax - totalTax / totalSaleIncTax * totalPromoVoucher;
    }

    private int getMaxProdDescLen(String input) {
        return Math.min(this.maxProdDescriptLen, input.length());
    }

    private static enum FooterType {
        SALE,
        CREDIT,
        LAYBY,
        TRANSFER,
        STK_TAKE,
        WITHDRAWAL,
        EXPENSE,
        RESERVATION,
        SPECIAL_ORDER,
        ACCOUNT_PAYMENT,
        CUST_ORDER,
        STOCK_RECEIPT_UNEXPECTED;

    }

    private static enum HeaderType {
        SALE,
        CREDIT,
        LAYBY_STORE,
        LAYBY_CUST,
        WITHDRAWAL,
        EXPENSE,
        RESERVATION_CUST,
        RESERVATION_STORE,
        GIFT_PURCHASE,
        SPECIAL_ORDER_STORE,
        SPECIAL_ORDER_CUST,
        ACCOUNT_PAYMENT,
        CUST_ORDER_STORE,
        CUST_ORDER_CUST,
        RETURN_STORE,
        RETURN_CUST,
        PROMO_VOUCHER;

    }
}

