/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import jpos.Reference;
import jpos.StringUtils;

public class Carrier {
    private Reference carrierRef = null;
    private String url = null;

    public Carrier(long carrierId) {
        if (carrierId > 0L) {
            String[] parts;
            this.carrierRef = new Reference(carrierId);
            this.carrierRef.setShowName(true);
            String extend = this.carrierRef.getExtend();
            if (!StringUtils.isNullOrEmpty(extend) && (parts = extend.split("\t")).length > 3) {
                this.url = parts[3];
            }
        }
    }

    public String getUrl() {
        return StringUtils.nullToEmpty(this.url);
    }

    public String getUrl(String conNote) {
        return this.getUrl().replaceAll("(?i)<connote>", conNote);
    }

    public String toString() {
        return this.carrierRef != null ? StringUtils.nullToEmpty(this.carrierRef.toString()) : "";
    }

    public long getId() {
        return this.carrierRef != null ? this.carrierRef.getIdx() : 0L;
    }
}

