/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import jpos.MultiLineDisc;
import jpos.PosDouble;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.StyleLine;

public class DiscLine {
    private DecimalFormat df = new DecimalFormat("#.####%");
    private MultiLineDisc discParent;
    private StyleLine styleParent;
    private StoreParams sParams;
    private boolean validated = true;
    private long pos_vshidx = -1L;

    public DiscLine(StyleLine sParent, MultiLineDisc dParent, StoreParams sParams, long pos_vshidx) {
        this.styleParent = sParent;
        this.discParent = dParent;
        this.sParams = sParams;
        this.pos_vshidx = pos_vshidx;
    }

    public Object getVal(int colIndex, int type) {
        Object val;
        try {
            block1 : switch (type) {
                case 1: {
                    switch (colIndex) {
                        case 0: {
                            val = this.getCode();
                            break block1;
                        }
                        case 1: {
                            val = this.getDisplayDescription();
                            break block1;
                        }
                        case 2: {
                            val = this.discParent.getExtraMsg();
                            break block1;
                        }
                        case 3: {
                            val = this.df.format(this.discParent.getCurrDiscPer());
                            break block1;
                        }
                        case 4: {
                            val = "";
                            break block1;
                        }
                        case 7: {
                            val = new PosDouble(0.0);
                            break block1;
                        }
                        case 10: {
                            val = new PosDouble(this.getNet());
                            break block1;
                        }
                        case 11: {
                            val = new PosDouble(0.0);
                            break block1;
                        }
                    }
                    val = null;
                    break;
                }
                case 10: {
                    switch (colIndex) {
                        case 0: {
                            val = this.getCode();
                            break block1;
                        }
                        case 1: {
                            val = this.getDisplayDescription();
                            break block1;
                        }
                        case 2: {
                            val = this.discParent.getExtraMsg();
                            break block1;
                        }
                        case 3: {
                            val = this.df.format(this.discParent.getCurrDiscPer());
                            break block1;
                        }
                        case 4: {
                            val = "";
                            break block1;
                        }
                        case 5: {
                            val = new PosDouble(0.0);
                            break block1;
                        }
                        case 6: {
                            val = new PosDouble(this.getNet());
                            break block1;
                        }
                        case 7: {
                            val = new PosDouble(0.0);
                            break block1;
                        }
                    }
                    val = null;
                    break;
                }
                case 12: {
                    switch (colIndex) {
                        case 0: {
                            val = this.getCode();
                            break block1;
                        }
                        case 1: {
                            val = this.getDisplayDescription();
                            break block1;
                        }
                        case 2: {
                            val = this.discParent.getExtraMsg();
                            break block1;
                        }
                        case 3: {
                            val = this.df.format(this.discParent.getCurrDiscPer());
                            break block1;
                        }
                        case 4: {
                            val = "";
                            break block1;
                        }
                        case 6: {
                            val = "";
                            break block1;
                        }
                        case 7: {
                            val = "";
                            break block1;
                        }
                        case 8: {
                            val = "";
                            break block1;
                        }
                        case 9: {
                            val = new PosDouble(0.0);
                            break block1;
                        }
                        case 12: {
                            val = new PosDouble(this.getNet());
                            break block1;
                        }
                        case 13: {
                            val = new PosDouble(0.0);
                            break block1;
                        }
                    }
                    val = null;
                    break;
                }
                default: {
                    val = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            val = null;
            PosUtils.logError(e);
        }
        return val;
    }

    public double getNet() {
        return !this.styleParent.adjustDiscountNet() ? SP.sParams.rndEven(this.getNetUnrounded()) : this.getAdjustmentNet();
    }

    public double getAdjustmentNet() {
        double oldNet = SP.sParams.rnd(this.getNetUnrounded(1));
        double newNet = SP.sParams.rnd(this.getNetUnrounded(10));
        return SP.sParams.rnd(newNet - oldNet);
    }

    public double getNetUnrounded() {
        return this.getNetUnrounded(2);
    }

    public double getAdjustmentNetRecall() {
        double oldNet = SP.sParams.rndEvenRecall(this.getNetUnrounded(1));
        double newNet = SP.sParams.rndEvenRecall(this.getNetUnrounded(10));
        double totalNet = 0.0;
        totalNet = newNet == 0.0 ? SP.sParams.rnd(oldNet) : SP.sParams.rnd(newNet - oldNet);
        return totalNet;
    }

    private double getNetUnrounded(int qtyType) {
        double extend = this.isLoyalty() ? this.styleParent.getNetBeforeLoyalty(qtyType) : (this.isPromotion() ? this.styleParent.getNetBeforePromotion(qtyType, this.getDiscParent()) : this.styleParent.getGross(qtyType));
        return this.discParent.getCurrDiscPer() * extend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void db_insertline() throws SQLException {
        double net = this.getNet();
        if (net != 0.0) {
            PreparedStatement pStmt = null;
            try {
                pStmt = SP.sParams.conn.prepareStatement("INSERT INTO RET_TRAND(VSHIDX, VHIDX, \"ACTIVE\", GROSS, NET, PRICE, DISCOUNT, SEQUENCE_NUMBER, LINE_TYPE, STKFLAG, DISCOUNT_PER, DISCOUNT_REASIDX, LINE_CODE, DESCRIP1, DESCRIP2, FROM_VSHIDX, ORIG_VSHIDX, PROMOIDX, OLD_HELD_VALUE, OVERRIDE_SREPIDX, COUPON_IDX) SELECT ?, ?, ?, ?, ?, ?, ?, COALESCE(MAX(SEQUENCE_NUMBER), -1)+1, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? FROM RET_TRAND WHERE VHIDX = ?");
                pStmt.setLong(1, this.sParams.nextVal("XRET_TRAND"));
                pStmt.setLong(2, this.sParams.currVal("XRET_TRANH"));
                pStmt.setInt(3, 1);
                pStmt.setDouble(4, net * -1.0);
                pStmt.setDouble(5, net * -1.0);
                pStmt.setDouble(6, net * -1.0);
                pStmt.setDouble(7, net * -1.0);
                pStmt.setInt(8, this.isLoyalty() ? 7 : 6);
                pStmt.setInt(9, 0);
                pStmt.setDouble(10, this.discParent.getCurrDiscPer() * 100.0);
                pStmt.setLong(11, this.discParent.getDiscount().getIdx());
                if (this.isLoyalty()) {
                    pStmt.setLong(12, this.discParent.getLoyalty().getIdx());
                } else {
                    pStmt.setNull(12, 2);
                }
                pStmt.setString(13, this.getDescription1ToSave());
                pStmt.setString(14, this.getDescription2ToSave());
                pStmt.setLong(15, this.styleParent.getVshidx());
                if (this.pos_vshidx != -1L) {
                    pStmt.setLong(16, this.pos_vshidx);
                } else {
                    pStmt.setNull(16, 2);
                }
                if (this.isPromotion()) {
                    pStmt.setLong(17, this.discParent.getPromotionIdx());
                } else {
                    pStmt.setNull(17, 2);
                }
                pStmt.setInt(18, this.isNew() ? 0 : 1);
                if (this.discParent.getOverrideSalesRep() != null) {
                    pStmt.setLong(19, this.discParent.getOverrideSalesRep().getPeridx());
                } else {
                    pStmt.setNull(19, 4);
                }
                if (this.isCoupon() && this.discParent.getCouponIdx() != 0L) {
                    pStmt.setLong(20, this.discParent.getCouponIdx());
                } else {
                    pStmt.setNull(20, 4);
                }
                pStmt.setLong(21, this.sParams.currVal("XRET_TRANH"));
                pStmt.executeUpdate();
            }
            catch (Throwable throwable) {
                PosUtils.closeStatement(pStmt);
                throw throwable;
            }
            PosUtils.closeStatement(pStmt);
        }
    }

    public boolean isLoyalty() {
        return this.discParent.isLoyalty();
    }

    public boolean isPromotion() {
        return this.discParent.isPromotion();
    }

    public boolean isCoupon() {
        return this.discParent.isCoupon();
    }

    public boolean isManualDiscount() {
        return this.discParent.isManualDiscount();
    }

    public boolean isRewardsDiscount() {
        return this.discParent.isRewardsDiscount();
    }

    public boolean isRewardsLoyalty() {
        return this.discParent.isRewardsLoyalty();
    }

    public boolean isNew() {
        return this.discParent.isNew();
    }

    public MultiLineDisc getDiscParent() {
        return this.discParent;
    }

    public StyleLine getStyleParent() {
        return this.styleParent;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public String getDescription1ToSave() {
        if (this.isRewardsDiscount() && this.styleParent.getGift() != null && !StringUtils.isNullOrEmpty(this.styleParent.getGift().getName())) {
            return this.styleParent.getGift().getName();
        }
        if (this.isRewardsLoyalty() && !StringUtils.isNullOrEmpty(this.discParent.getRewardsProgramName())) {
            return this.discParent.getRewardsProgramName();
        }
        if (!StringUtils.isNullOrEmpty(this.discParent.getDescription1())) {
            return this.discParent.getDescription1();
        }
        return this.getCode();
    }

    public String getDescription2ToSave() {
        if (this.isCoupon()) {
            return this.discParent.getCouponCode();
        }
        if (!StringUtils.isNullOrEmpty(this.discParent.getDescription2())) {
            return this.discParent.getDescription2();
        }
        return "";
    }

    public String getCode() {
        if (this.isLoyalty()) {
            return StoreParams.LOYALTY_MSG.trim();
        }
        if (this.isCoupon()) {
            return StoreParams.COUPON_MSG.trim();
        }
        if (this.isPromotion()) {
            return StoreParams.PROMO_MSG.trim();
        }
        return StoreParams.DISC_MSG.trim();
    }

    public String getDisplayDescription() {
        if (this.isRewardsDiscount() && this.styleParent.getGift() != null && !StringUtils.isNullOrEmpty(this.styleParent.getGift().getName())) {
            return this.styleParent.getGift().getName();
        }
        if (this.isRewardsDiscount() && this.styleParent.getGift() != null && !StringUtils.isNullOrEmpty(this.discParent.getDescription1())) {
            return this.discParent.getDescription1();
        }
        if (this.isCoupon() && !StringUtils.isNullOrEmpty(this.discParent.getCouponCode())) {
            return this.discParent.getCouponCode() + " - " + this.discParent.getPromotionName();
        }
        if (this.isPromotion()) {
            return this.discParent.getPromotionName();
        }
        if (this.isManualDiscount()) {
            return this.discParent.getDiscount().toString();
        }
        if (this.isLoyalty()) {
            String description;
            String string = description = this.isRewardsLoyalty() && !StringUtils.isNullOrEmpty(this.discParent.getRewardsProgramName()) ? this.discParent.getRewardsProgramName() : this.discParent.getDiscount().toString();
            if (this.discParent.getLoyaltyDetails().isDiscountOnOrigPrice()) {
                PosDouble origPrice = this.styleParent.getOrigPrice() > this.styleParent.getPrice() ? PosDouble.valueOf(this.styleParent.getOrigPrice()) : PosDouble.valueOf(this.styleParent.getPrice());
                return description + " - " + MessageFormat.format(SP.getRS("Original_Price_"), origPrice);
            }
            return description;
        }
        return "";
    }

    private String getLoyaltyProgName() {
        if (this.isRewardsLoyalty()) {
            return this.discParent.getRewardsProgramName();
        }
        return "";
    }
}

