/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.StoreParams;
import jpos.ui.LabelNormal;
import jpos.ui.LabelStrong;
import jpos.ui.LabelSubHeading;

public class DlgAbout
extends PosDialog {
    private JPanel paMain = new JPanel();
    private BorderLayout borderLayout = new BorderLayout();
    private JLabel lLogo = new JLabel();
    private ImageIcon iLogo;
    private JPanel paFoot = new JPanel();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private LabelNormal lCountry = new LabelNormal();
    private LabelNormal lAdrs1 = new LabelNormal();
    private LabelNormal lAdrs2 = new LabelNormal();
    private LabelNormal lWWW = new LabelNormal();
    private LabelSubHeading lVersion = new LabelSubHeading();
    private LabelNormal lPhone = new LabelNormal();
    private LabelStrong lApparel21 = new LabelStrong();
    private LabelNormal lMachine = new LabelNormal();

    public DlgAbout(PosFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void jbInit() throws Exception {
        this.iLogo = new ImageIcon(this.sParams.imagepath + "basslogo.jpg");
        this.lLogo.setHorizontalAlignment(0);
        this.lLogo.setIcon(this.iLogo);
        this.paMain.setLayout(this.borderLayout);
        this.paFoot.setLayout(this.gridBagLayout);
        this.lCountry.setHorizontalAlignment(0);
        this.lCountry.setText(StoreParams.res.getString("Australia"));
        this.lAdrs1.setHorizontalAlignment(0);
        this.lAdrs1.setText(StoreParams.res.getString("badrs1"));
        this.lAdrs2.setHorizontalAlignment(0);
        this.lAdrs2.setText(StoreParams.res.getString("badrs2"));
        this.lWWW.setHorizontalAlignment(0);
        this.lWWW.setText(StoreParams.res.getString("www_BassSoftware_com"));
        this.lVersion.setHorizontalAlignment(0);
        this.lVersion.setText(MessageFormat.format(StoreParams.res.getString("AP21POS_version_build"), StoreParams.VERSION, this.getBuildNumber()));
        this.lPhone.setText(StoreParams.res.getString("BassPhoneFax"));
        this.lApparel21.setText(StoreParams.res.getString("Bass_Software_Pty_Ltd"));
        this.lMachine.setHorizontalAlignment(0);
        String tillName = "";
        try {
            tillName = MessageFormat.format(StoreParams.res.getString("Till_Name"), InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String locale = MessageFormat.format(StoreParams.res.getString("Locale"), Locale.getDefault().toString());
        this.lMachine.setText(tillName + ", " + locale);
        this.getContentPane().add(this.paMain);
        this.paMain.add((Component)this.lLogo, "Center");
        this.paMain.add((Component)this.paFoot, "South");
        this.paFoot.add((Component)this.lVersion, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.paFoot.add((Component)this.lApparel21, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.paFoot.add((Component)this.lWWW, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.paFoot.add((Component)this.lPhone, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.paFoot.add((Component)this.lAdrs1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.paFoot.add((Component)this.lAdrs2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.paFoot.add((Component)this.lCountry, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.paFoot.add((Component)this.lMachine, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.pack();
        PosUtils.centreWindow(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBuildNumber() {
        try (FileInputStream buildNumbersFile = new FileInputStream("BuildNumbers.properties");){
            Properties properties = new Properties();
            properties.load(buildNumbersFile);
            String buildNumber = properties.getProperty("PosClientBuildNumber");
            String string = buildNumber == null ? "0" : buildNumber;
            return string;
        }
        catch (Exception e) {
            return "0";
        }
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }

    @Override
    public void okDialog() {
        this.dispose();
    }

    @Override
    public boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

