/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JPanel;
import jpos.FrSales;
import jpos.PaSales;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.searchfields.ProductClrSizeSearch;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class DlgAddBagPrompt
extends PosDialog
implements AutoCloseable {
    private boolean continuePayment = false;
    private Vector<Long> bagStyleList;
    private LabelSubHeading bagTitle;
    private ProductClrSizeSearch searchBag;
    private DialogButton bPayment;
    private DialogButton bCancel;

    public DlgAddBagPrompt(FrSales frame, Vector<Long> bagStyleList) {
        super((PosFrame)frame, SP.getRS("Scan_Bag_Header"), true, true);
        this.frParent = frame;
        this.bagStyleList = bagStyleList;
        try {
            this.init();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void init() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setAcceptOnEnter(false);
        this.bagTitle = new LabelSubHeading(SP.getRS("Scan_Bag"));
        this.bPayment = new DialogButton("");
        this.bPayment.setText(SP.getRS("Skip"));
        this.bPayment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgAddBagPrompt.this.okDialog();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 120) {
                    DlgAddBagPrompt.this.okDialog();
                } else if (e.getKeyCode() == 10 && !DlgAddBagPrompt.this.searchBag.getBarcodeSearchField().isFocusOwner()) {
                    if (DlgAddBagPrompt.this.bCancel.isFocusOwner()) {
                        DlgAddBagPrompt.this.cancelDialog();
                    } else {
                        DlgAddBagPrompt.this.okDialog();
                    }
                }
            }
        });
        this.bCancel = new DialogButton("");
        this.bCancel.setText(SP.getRS("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgAddBagPrompt.this.cancelDialog();
            }
        });
        this.searchBag = new ProductClrSizeSearch(this, TouchTextField.FontSize.LARGE){

            @Override
            public boolean processSku(long skuidx, String barcode) {
                if (DlgAddBagPrompt.this.validateSku(skuidx, barcode)) {
                    DlgAddBagPrompt.this.cancelDialog();
                    return true;
                }
                return false;
            }
        };
        this.searchBag.getBarcodeSearchField().setShowSearchForOneResult(true);
        String validStyles = "";
        for (long idx : this.bagStyleList) {
            validStyles = validStyles + Long.toString(idx) + ",";
        }
        validStyles = validStyles.substring(0, validStyles.length() - 1);
        this.searchBag.getBarcodeSearchField().setWhere("AND S.STYLEIDX in (" + validStyles + ")");
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelHeader = new JPanel(new GridBagLayout());
        JPanel panelBody = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panelMain, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelBody, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelHeader.add((Component)this.bagTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 15, 1, 15), 0, 0));
        panelBody.add((Component)this.searchBag.getSearchPanel(), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 15, 5, 15), 0, 0));
        panelFooter.add((Component)this.bPayment, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 15, 20, 5), 0, 0));
        panelFooter.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 1, 20, 15), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabVector = new Vector<Component>();
        tabVector.add(this.searchBag.getBarcodeSearchField());
        tabVector.add(this.bPayment);
        tabVector.add(this.bCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabVector);
        this.setFocusTraversalPolicy(ftp);
        this.searchBag.getBarcodeSearchField().requestFocusInWindow();
        this.pack();
        PosUtils.centreWindow(this);
    }

    @Override
    public void okDialog() {
        this.continuePayment = true;
        this.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateSku(long sku, String barcode) {
        if (sku == 0L) return false;
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT C.STYLEIDX FROM CLR C JOIN SKU K ON C.CLRIDX = K.CLRIDX WHERE K.SKUIDX = " + sku);){
            if (!query.next()) return false;
            Long styleidx = query.getLong(1);
            if (!this.bagStyleList.contains(styleidx)) return false;
            if (!(this.frParent instanceof FrSales)) return false;
            FrSales salesFr = (FrSales)this.frParent;
            PaSales salesPa = (PaSales)salesFr.paBody;
            salesPa.tblStyles.addEAN(barcode);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        return false;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void cancelDialog() {
        this.continuePayment = false;
        this.dispose();
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    public boolean getContinueAfterDialog() {
        return this.continuePayment;
    }
}

