/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jpos.PosFrame;
import jpos.PosUtils;

public class DlgImage
extends JDialog {
    int DEFAULT_WIDTH = 300;
    int DEFAULT_HEIGHT = 300;
    int DEFAULT_X = 0;
    int DEFAULT_Y = 0;
    PosFrame frParent;
    boolean bMaximised = false;
    String sPropertiesFile;
    Image pic;
    private Properties props = new Properties();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel panelMain = new JPanel(){

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (DlgImage.this.pic != null) {
                Image picScaled = null;
                int pw = this.getWidth();
                int ph = this.getHeight();
                double iw = DlgImage.this.pic.getWidth(null);
                double ih = DlgImage.this.pic.getHeight(null);
                if ((double)pw >= iw && (double)ph >= ih) {
                    picScaled = DlgImage.this.pic;
                } else {
                    if (iw > (double)pw && ih > (double)ph) {
                        if ((double)pw / iw > (double)ph / ih) {
                            pw = -1;
                        } else {
                            ph = -1;
                        }
                    } else if (iw > (double)pw) {
                        ph = -1;
                    } else {
                        pw = -1;
                    }
                    picScaled = DlgImage.this.pic.getScaledInstance(pw, ph, 1);
                    MediaTracker tracker = new MediaTracker(DlgImage.this.panelMain);
                    tracker.addImage(picScaled, 0);
                    try {
                        tracker.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    tracker.removeImage(picScaled);
                    tracker = null;
                }
                g.drawImage(picScaled, (DlgImage.this.panelMain.getWidth() - picScaled.getWidth(null)) / 2, (DlgImage.this.panelMain.getHeight() - picScaled.getHeight(null)) / 2, this);
                if (DlgImage.this.pic != picScaled) {
                    picScaled.flush();
                }
            }
        }
    };

    public DlgImage(PosFrame frParent, String title, String sPropertiesFile, boolean modal) {
        super(frParent, title, modal);
        try {
            this.frParent = frParent;
            this.load(sPropertiesFile);
            this.sPropertiesFile = sPropertiesFile;
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(this.DEFAULT_WIDTH, this.DEFAULT_HEIGHT);
        this.setFocusableWindowState(false);
        if (this.bMaximised) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(screenSize.width, screenSize.height);
            this.setLocation(0, 0);
        } else {
            if (this.DEFAULT_X == -1 || this.DEFAULT_Y == -1) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension frameSize = this.getSize();
                this.DEFAULT_X = (screenSize.width - frameSize.width) / 2;
                this.DEFAULT_Y = (screenSize.height - frameSize.height) / 2;
            }
            this.setLocation(this.DEFAULT_X, this.DEFAULT_Y);
        }
        this.panelMain.setLayout(this.gridBagLayout1);
        this.getContentPane().add((Component)this.panelMain, "Center");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    if (DlgImage.this.bMaximised) {
                        DlgImage.this.setSize(DlgImage.this.DEFAULT_WIDTH, DlgImage.this.DEFAULT_HEIGHT);
                        DlgImage.this.setLocation(DlgImage.this.DEFAULT_X, DlgImage.this.DEFAULT_Y);
                    } else {
                        DlgImage.this.DEFAULT_WIDTH = DlgImage.this.getWidth();
                        DlgImage.this.DEFAULT_HEIGHT = DlgImage.this.getHeight();
                        DlgImage.this.DEFAULT_X = DlgImage.this.getX();
                        DlgImage.this.DEFAULT_Y = DlgImage.this.getY();
                        DlgImage.this.setSize(screenSize.width, screenSize.height);
                        DlgImage.this.setLocation(0, 0);
                    }
                    DlgImage.this.bMaximised = !DlgImage.this.bMaximised;
                    DlgImage.this.validate();
                }
            }
        });
    }

    public void setImage(String sFilename, String sTitle) {
        this.setTitle(sTitle);
        if (this.pic != null) {
            this.pic.flush();
            this.pic = null;
        }
        if (sFilename != null && sFilename.length() > 0 && new File(sFilename).exists()) {
            this.pic = Toolkit.getDefaultToolkit().getImage(sFilename);
            MediaTracker tracker = new MediaTracker(this.panelMain);
            tracker.addImage(this.pic, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            tracker.removeImage(this.pic);
            Object var3_3 = null;
        } else {
            this.pic = Toolkit.getDefaultToolkit().getImage("");
        }
    }

    public void load(String fileName) throws FileNotFoundException {
        this.props.clear();
        if (new File(fileName).exists()) {
            try (FileInputStream in = new FileInputStream(fileName);){
                this.props.load(in);
                this.DEFAULT_X = Integer.parseInt(this.props.getProperty("x", "-1"));
                this.DEFAULT_Y = Integer.parseInt(this.props.getProperty("y", "-1"));
                this.DEFAULT_WIDTH = Integer.parseInt(this.props.getProperty("width", "300"));
                this.DEFAULT_HEIGHT = Integer.parseInt(this.props.getProperty("height", "300"));
                this.bMaximised = Boolean.valueOf(this.props.getProperty("maximised", "false"));
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        } else {
            this.DEFAULT_X = -1;
            this.DEFAULT_Y = -1;
            this.DEFAULT_WIDTH = 300;
            this.DEFAULT_HEIGHT = 300;
            this.bMaximised = false;
        }
    }

    public void save(String fileName) throws FileNotFoundException {
        if (!this.bMaximised) {
            this.DEFAULT_X = this.getX();
            this.DEFAULT_Y = this.getY();
            this.DEFAULT_WIDTH = this.getWidth();
            this.DEFAULT_HEIGHT = this.getHeight();
        }
        this.props.setProperty("x", this.DEFAULT_X + "");
        this.props.setProperty("y", this.DEFAULT_Y + "");
        this.props.setProperty("width", this.DEFAULT_WIDTH + "");
        this.props.setProperty("height", this.DEFAULT_HEIGHT + "");
        this.props.setProperty("maximised", this.bMaximised + "");
        try (FileOutputStream out = new FileOutputStream(fileName);){
            this.props.store(out, "Image");
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    @Override
    public void dispose() {
        try {
            this.save(this.sPropertiesFile);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        super.dispose();
    }
}

