/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.StoreParams;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchList;

public class DlgList
extends PosDialog {
    private static Object result = null;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private GridBagLayout gridBagLayoutButtons = new GridBagLayout();
    private JPanel panel = new JPanel();
    private JPanel panelButtons = new JPanel();
    private LabelSubHeading labelTitle = new LabelSubHeading();
    private TouchList<Object> list = null;
    private DialogButton bOk = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private PosScrollPane scrollPane = null;
    private int extraWidthPadding = 0;

    public DlgList(PosFrame frame, String title, boolean modal, String message, Object[] selectionValues, Object initialSelectionValue, boolean extraWide) {
        super(frame, title, modal);
        this.list = new TouchList<Object>(selectionValues);
        if (extraWide) {
            this.extraWidthPadding = 75;
        }
        try {
            this.jbInit();
            this.labelTitle.setText(message);
            this.list.setSelectedValue(initialSelectionValue, true);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static Object showDialog(Component parentComponent, String message, String title, Object[] selectionValues, Object initialSelectionValue) {
        DlgList dialog = new DlgList((PosFrame)parentComponent, title, true, message, selectionValues, initialSelectionValue, false);
        dialog.setVisible(true);
        return result;
    }

    public static Object showDialog(Component parentComponent, String message, String title, Object[] selectionValues, Object initialSelectionValue, boolean extraWide) {
        DlgList dialog = new DlgList((PosFrame)parentComponent, title, true, message, selectionValues, initialSelectionValue, extraWide);
        dialog.setVisible(true);
        return result;
    }

    private void jbInit() throws Exception {
        this.panel.setLayout(this.gridBagLayout);
        this.panelButtons.setLayout(this.gridBagLayoutButtons);
        this.scrollPane = new PosScrollPane(this.list);
        this.bOk.setText(StoreParams.res.getString("OK"));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                result = DlgList.this.list.getSelectedValue();
                DlgList.this.dispose();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                result = null;
                DlgList.this.dispose();
            }
        });
        this.scrollPane.setMinimumSize(new Dimension(250 + this.extraWidthPadding, 100));
        this.scrollPane.setPreferredSize(new Dimension(250 + this.extraWidthPadding, 100));
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    DlgList.this.bOk.doClick();
                }
            }
        });
        this.panel.setMinimumSize(new Dimension(350 + this.extraWidthPadding, 400));
        this.panel.setPreferredSize(new Dimension(350 + this.extraWidthPadding, 400));
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.labelTitle, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 1));
        this.panel.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 0, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 1));
        this.panel.add((Component)this.panelButtons, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelButtons.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panelButtons.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.scrollPane.getViewport().add(this.list);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.list);
        v.add(this.bOk);
        v.add(this.bCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void okDialog() {
        this.bOk.doClick();
    }

    @Override
    public void cancelDialog() {
        this.bCancel.doClick();
    }
}

