/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.StoreParams;
import jpos.ui.DialogButton;
import jpos.ui.StatusButton;
import jpos.ui.TouchTextArea;

public final class DlgMessage
extends JDialog
implements KeyEventDispatcher {
    public static final int BUTTON_DEFAULT = -1;
    public static final int BUTTON_YES_NO = 0;
    public static final int BUTTON_YES_NO_CANCEL = 1;
    public static final int BUTTON_OK_CANCEL = 2;
    public static final int BUTTON_RETRY_CANCEL = 3;
    public static final int RESULT_YES = 0;
    public static final int RESULT_NO = 1;
    public static final int RESULT_CANCEL = 2;
    public static final int RESULT_OK = 0;
    public static final int RESULT_RETRY = 0;
    public static final int ICON_ERROR = 0;
    public static final int ICON_INFORMATION = 1;
    public static final int ICON_WARNING = 2;
    public static final int ICON_QUESTION = 3;
    private String message;
    private int buttonType = 0;
    private int iconType = 0;
    private int result = -1;
    private int closeAction = -1;
    private int focusedTabIndex = 0;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private GridBagLayout gridBagLayoutButtons = new GridBagLayout();
    private JPanel panel = new JPanel();
    private JPanel panelButtons = new JPanel();
    private TouchTextArea jTextArea = new TouchTextArea();
    private DialogButton bOk = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private DialogButton bYes = new DialogButton("");
    private DialogButton bRetry = new DialogButton("");
    private DialogButton bNo = new DialogButton("");
    private JLabel lImage = new JLabel();

    public DlgMessage(Window parent, String title, String message, int buttonType, int iconType) {
        this(parent, title, message, buttonType, iconType, 0);
    }

    public DlgMessage(Window parent, String title, String message, int buttonType, int iconType, int focusedTabIndex) {
        super(parent, title, DEFAULT_MODALITY_TYPE);
        this.message = message;
        this.buttonType = buttonType;
        this.iconType = iconType;
        this.focusedTabIndex = focusedTabIndex;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d.width < 300) {
            d.width = 300;
        }
        return d;
    }

    private void jbInit() throws Exception {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    if (DlgMessage.this.closeAction != -1) {
                        DlgMessage.this.result = DlgMessage.this.closeAction;
                    } else {
                        switch (DlgMessage.this.buttonType) {
                            case 2: {
                                DlgMessage.this.result = 2;
                                break;
                            }
                            case 0: {
                                DlgMessage.this.result = 1;
                                break;
                            }
                            case 1: {
                                DlgMessage.this.result = 2;
                                break;
                            }
                            case 3: {
                                DlgMessage.this.result = 2;
                                break;
                            }
                            default: {
                                DlgMessage.this.result = 0;
                            }
                        }
                    }
                    DlgMessage.this.dispose();
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.panel.setLayout(this.gridBagLayout);
        this.panelButtons.setLayout(this.gridBagLayoutButtons);
        this.bOk.setText(StoreParams.res.getString("OK"));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgMessage.this.result = 0;
                DlgMessage.this.dispose();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgMessage.this.result = 2;
                DlgMessage.this.dispose();
            }
        });
        this.bYes.setText(StoreParams.res.getString("Yes"));
        this.bYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgMessage.this.result = 0;
                DlgMessage.this.dispose();
            }
        });
        this.bRetry.setText(StoreParams.res.getString("Retry"));
        this.bRetry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgMessage.this.result = 0;
                DlgMessage.this.dispose();
            }
        });
        this.bNo.setText(StoreParams.res.getString("No"));
        this.bNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgMessage.this.result = 1;
                DlgMessage.this.dispose();
            }
        });
        this.jTextArea.setEditable(false);
        this.jTextArea.setFocusable(false);
        this.jTextArea.setBackground(UIManager.getColor("Panel.background"));
        this.jTextArea.setText(this.message);
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.lImage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.panel.add((Component)this.jTextArea, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 0, 10), 1, 1));
        this.panel.add((Component)this.panelButtons, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 15, 0, new Insets(0, 0, 0, 0), 1, 1));
        switch (this.buttonType) {
            case 2: {
                this.panelButtons.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.panelButtons.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                break;
            }
            case 0: {
                this.panelButtons.add((Component)this.bYes, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.panelButtons.add((Component)this.bNo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                break;
            }
            case 1: {
                this.panelButtons.add((Component)this.bYes, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.panelButtons.add((Component)this.bNo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.panelButtons.add((Component)this.bCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                break;
            }
            case 3: {
                this.panelButtons.add((Component)this.bRetry, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.panelButtons.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                break;
            }
            default: {
                this.panelButtons.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            }
        }
        switch (this.iconType) {
            case 0: {
                this.lImage.setIcon(new ImageIcon("images/Error.gif"));
                break;
            }
            case 2: {
                this.lImage.setIcon(new ImageIcon("images/Warn.gif"));
                break;
            }
            case 3: {
                this.lImage.setIcon(new ImageIcon("images/Question.gif"));
                break;
            }
            default: {
                this.lImage.setIcon(new ImageIcon("images/Inform.gif"));
            }
        }
        this.lImage.paint(this.lImage.getGraphics());
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        switch (this.buttonType) {
            case 2: {
                v.add(this.bOk);
                v.add(this.bCancel);
                break;
            }
            case 0: {
                if (this.focusedTabIndex == 0) {
                    v.add(this.bYes);
                    v.add(this.bNo);
                    break;
                }
                if (this.focusedTabIndex != 1) break;
                v.add(this.bNo);
                v.add(this.bYes);
                break;
            }
            case 1: {
                v.add(this.bYes);
                v.add(this.bNo);
                v.add(this.bCancel);
                break;
            }
            case 3: {
                v.add(this.bRetry);
                v.add(this.bCancel);
                break;
            }
            default: {
                v.add(this.bOk);
            }
        }
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
        this.setResizable(false);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isActive()) {
            this.processKeyEvent(e);
        }
        return false;
    }

    public static int showMessage(Window parent, String message, String title, int buttonType, int iconType, int focusedTabIndex) {
        DlgMessage dlg = new DlgMessage(parent, title, message, buttonType, iconType, focusedTabIndex);
        dlg.setVisible(true);
        return dlg.result;
    }

    public static int showMessage(Window parent, String message, String title, int buttonType, int iconType) {
        DlgMessage dlg = new DlgMessage(parent, title, message, buttonType, iconType);
        dlg.setVisible(true);
        return dlg.result;
    }

    public static int showMessage(Window parent, String message, String title, int iconType) {
        DlgMessage dlg = new DlgMessage(parent, title, message, -1, iconType);
        dlg.setVisible(true);
        return dlg.result;
    }

    public static int showMessage(Window parent, String message, String title) {
        DlgMessage dlg = new DlgMessage(parent, title, message, -1, 1);
        dlg.setVisible(true);
        return dlg.result;
    }

    public static int showMessage(Window parent, String message) {
        DlgMessage dlg = new DlgMessage(parent, "Message", message, -1, 1);
        dlg.setVisible(true);
        return dlg.result;
    }

    public int showMessage() {
        this.setVisible(true);
        return this.result;
    }

    public StatusButton getOkButton() {
        return this.bOk;
    }

    public StatusButton getCancelButton() {
        return this.bCancel;
    }

    public StatusButton getYesButton() {
        return this.bYes;
    }

    public StatusButton getNoButton() {
        return this.bNo;
    }

    public void setCloseAction(int action) {
        this.closeAction = action != 0 && action != 1 && action != 2 && action != 0 ? -1 : action;
        this.result = this.closeAction;
    }

    @Override
    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        super.dispose();
    }
}

