/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.rtf.RTFEditorKit;
import jpos.DlgMessage;
import jpos.MLengthTextArea;
import jpos.Note;
import jpos.NoteType;
import jpos.PosDateFormatter;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.RefCombo;
import jpos.Reference;
import jpos.StoreParams;
import jpos.User;
import jpos.basscom.utils.Utils;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.TouchList;
import jpos.ui.TouchTextArea;

public class DlgNotes
extends PosDialog {
    private TitledBorder titledBorder;
    private GridBagLayout gridBagLayoutMain = new GridBagLayout();
    private GridLayout gridLayoutTop = new GridLayout();
    private GridBagLayout gridBagLayoutBottom = new GridBagLayout();
    private JPanel jPanelTop = new JPanel();
    private JPanel jPanelBottom = new JPanel();
    private PosScrollPane scrollerTop = new PosScrollPane();
    private PosScrollPane scrollerBottomLeft = new PosScrollPane();
    private PosScrollPane scrollerBottomRight = new PosScrollPane();
    private JEditorPane epNotsDisplay = new JEditorPane();
    private MLengthTextArea mlNotesEditor = new MLengthTextArea(7000);
    private TouchList<NoteType> listNoteTypes;
    private LabelNormal lRefGroup = new LabelNormal();
    private LabelNormal lComments = new LabelNormal();
    private RefCombo cmbRefcode = new RefCombo();
    private TouchTextArea notesTextArea = new TouchTextArea();
    private DialogButton btnSave = new DialogButton("");
    private RTFEditorKit rtf = new RTFEditorKit();
    private User user;
    private String[] saMonth = new String[12];
    private Vector<Note> vNotes;
    private Vector<NoteType> vTypes;
    private int nCurrent = -1;
    private NoteType currentType;
    private boolean bReadOnly;
    private boolean msgShown = false;

    public DlgNotes(PosFrame frame, String title, boolean modal, User pUser, Vector<Note> vpNotes, Vector<NoteType> vpTypes, boolean preadOnly) {
        super(frame, title, modal);
        this.frParent.setCursor(StoreParams.waitCursor);
        try {
            this.vTypes = vpTypes;
            this.bReadOnly = vpTypes.size() == 0 || preadOnly;
            this.user = pUser;
            this.vNotes = vpNotes;
            this.jbInit();
            this.displayNotes();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
        this.frParent.setCursor(StoreParams.normalCursor);
    }

    private void DoEdit(KeyEvent e) {
        this.btnSave.setEnabled(this.mlNotesEditor.getText().length() > 0);
    }

    private void saveNote() {
        Reference ref = null;
        if (!this.bReadOnly && this.btnSave.isEnabled()) {
            if (this.cmbRefcode.isVisible()) {
                ref = (Reference)this.cmbRefcode.getSelectedItem();
            }
            if (!this.cmbRefcode.isVisible() || ref != null) {
                Date dNow = new Date();
                Timestamp tNow = new Timestamp(dNow.getTime());
                Note myNote = new Note(0L, this.currentType, this.user, ref, this.mlNotesEditor.getText(), tNow, 0L, this.sParams);
                this.vNotes.insertElementAt(myNote, 0);
                this.mlNotesEditor.setText("");
                this.displayNotes();
                this.btnSave.setEnabled(false);
            } else {
                this.msgShown = true;
                DlgMessage.showMessage(this, StoreParams.res.getString("must_select_reference"), this.lRefGroup.getText(), 2);
            }
        }
    }

    private void displayNotes() {
        PosDateFormatter dateFormatter = new PosDateFormatter(null, 3, 3, 2);
        this.setCursor(StoreParams.waitCursor);
        StringBuffer s1 = new StringBuffer();
        String sCRLF = new String("\r\n");
        String sNewline = new String("\n");
        this.epNotsDisplay.setText("");
        s1.append("{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang3081{\\fonttbl{\\f0\\fswiss\\fcharset0 Arial;}}\\viewkind4\\uc1");
        s1.append("{\\colortbl ;\\red7\\green82\\blue169;\\red208\\green2\\blue27;\\red61\\green176\\blue24;}");
        try {
            for (int nCount = 0; nCount < this.vNotes.size(); ++nCount) {
                Note note = this.vNotes.elementAt(nCount);
                s1.append("\\cf0 \\pard\\li000\\f0\\fs24\\b\\ul ");
                s1.append(note.getLoginName() + "  (" + note.noteType.sObjectName + ") " + note.noteType.sName + ":\\b0  ");
                try {
                    dateFormatter.setTimestampInternal(note.dCreated.toString());
                    s1.append(dateFormatter.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                s1.append("\\ul0\\par \\cf2 \\li568\\b0 \\i0 ");
                if (note.ref != null && note.ref.getGroupName() != null && note.ref.getGroupName().compareTo("") > 0) {
                    s1.append(note.ref.getGroupName() + ": " + note.ref.getCode() + "\\par ");
                }
                s1.append("\\cf1 \\li568 ");
                if (note.sNotes != null) {
                    String sTemp = Utils.stringReplace(note.sNotes, sCRLF, sNewline);
                    s1.append(Utils.stringReplace(sTemp, sNewline, "\\par \n\r"));
                }
                s1.append("\\par");
            }
            s1.append("}");
            StringReader stream = new StringReader(s1.toString());
            this.rtf.read(stream, this.epNotsDisplay.getDocument(), 0);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            this.epNotsDisplay.setText("Exception: " + e.getMessage());
        }
        this.setCursor(StoreParams.normalCursor);
        this.setFocus();
    }

    private void SelectNewType() {
        int nIndex = this.listNoteTypes.getSelectedIndex();
        if (nIndex > -1 && nIndex <= this.vTypes.size()) {
            this.nCurrent = nIndex;
            this.currentType = this.vTypes.elementAt(this.nCurrent);
            if (this.vTypes.elementAt((int)this.nCurrent).nRgidx > 0L) {
                this.cmbRefcode.removeAllItems();
                RefCombo temp = new RefCombo(this.vTypes.elementAt((int)this.nCurrent).nRgidx, "", "R.CODE");
                for (int i = 0; i < temp.getItemCount(); ++i) {
                    this.cmbRefcode.addItem(temp.getItemAt(i));
                }
                if (temp.getItemCount() > 0) {
                    this.lRefGroup.setText(((Reference)temp.getItemAt(0)).getGroupName());
                }
                this.cmbRefcode.setSelectedIndex(-1);
                this.lRefGroup.setVisible(true);
                this.cmbRefcode.setVisible(true);
            } else {
                this.lRefGroup.setVisible(false);
                this.cmbRefcode.setVisible(false);
            }
            this.btnSave.setEnabled(this.mlNotesEditor.getText().length() > 0);
        }
    }

    private void jbInit() throws Exception {
        Vector<NoteType> sortedTypes = new Vector<NoteType>();
        for (int i = 0; i < this.vTypes.size(); ++i) {
            int j;
            NoteType type = this.vTypes.elementAt(i);
            for (j = 0; j < sortedTypes.size(); ++j) {
                if (type.toString().compareToIgnoreCase(((NoteType)sortedTypes.elementAt(j)).toString()) >= 0) continue;
                sortedTypes.add(j, type);
                break;
            }
            if (j != sortedTypes.size()) continue;
            sortedTypes.add(type);
        }
        this.vTypes = sortedTypes;
        this.listNoteTypes = new TouchList(sortedTypes);
        this.titledBorder = new TitledBorder("");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                DlgNotes.this.this_windowActivated(e);
            }
        });
        this.getContentPane().setLayout(this.gridBagLayoutMain);
        this.jPanelTop.setAlignmentY(0.0f);
        this.jPanelTop.setBorder(this.titledBorder);
        this.jPanelTop.setLayout(this.gridLayoutTop);
        this.epNotsDisplay.setEditorKit(this.rtf);
        this.epNotsDisplay.setBackground(Colours.WHITE);
        this.epNotsDisplay.setEditable(false);
        this.mlNotesEditor.setAlignmentX(0.0f);
        this.mlNotesEditor.setBackground(Colours.WHITE);
        this.mlNotesEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                DlgNotes.this.DoEdit(e);
            }
        });
        this.jPanelBottom.setLayout(this.gridBagLayoutBottom);
        this.saMonth[0] = new String(StoreParams.res.getString("Jan"));
        this.saMonth[1] = new String(StoreParams.res.getString("Feb"));
        this.saMonth[2] = new String(StoreParams.res.getString("Mar"));
        this.saMonth[3] = new String(StoreParams.res.getString("Apr"));
        this.saMonth[4] = new String(StoreParams.res.getString("May"));
        this.saMonth[5] = new String(StoreParams.res.getString("Jun"));
        this.saMonth[6] = new String(StoreParams.res.getString("Jul"));
        this.saMonth[7] = new String(StoreParams.res.getString("Aug"));
        this.saMonth[8] = new String(StoreParams.res.getString("Sep"));
        this.saMonth[9] = new String(StoreParams.res.getString("Oct"));
        this.saMonth[10] = new String(StoreParams.res.getString("Nov"));
        this.saMonth[11] = new String(StoreParams.res.getString("Dec"));
        this.btnSave.setText(StoreParams.res.getString("F8_Save"));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNotes.this.jSave_actionPerformed(e);
            }
        });
        this.listNoteTypes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DlgNotes.this.listNoteTypes_valueChanged(e);
            }
        });
        this.notesTextArea.setText(StoreParams.res.getString("Note_Types"));
        this.notesTextArea.setBackground(UIManager.getColor("control"));
        this.notesTextArea.setEditable(false);
        this.jPanelTop.setPreferredSize(new Dimension(600, 300));
        this.jPanelBottom.setPreferredSize(new Dimension(600, 100));
        this.scrollerBottomLeft.setMaximumSize(new Dimension(1000, 1000));
        this.scrollerBottomLeft.setMinimumSize(new Dimension(220, 30));
        this.scrollerBottomLeft.setPreferredSize(new Dimension(220, 30));
        this.cmbRefcode.setFieldWidth(120);
        this.scrollerBottomRight.setMaximumSize(new Dimension(1000, 1000));
        this.scrollerBottomRight.setMinimumSize(new Dimension(400, 30));
        this.scrollerBottomRight.setPreferredSize(new Dimension(400, 30));
        this.lComments.setText(StoreParams.res.getString("Enter_Comments"));
        this.cmbRefcode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DlgNotes.this.jComboRefcode_itemStateChanged(e);
            }
        });
        this.jPanelTop.add((Component)this.scrollerTop, null);
        this.jPanelBottom.add((Component)this.scrollerBottomLeft, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrollerBottomLeft.getViewport().add(this.listNoteTypes);
        this.jPanelBottom.add((Component)this.cmbRefcode, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.jPanelBottom.add((Component)this.lRefGroup, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelBottom.add((Component)this.scrollerBottomRight, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, 0, 0), 0, 0));
        this.jPanelBottom.add((Component)this.lComments, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelBottom.add((Component)this.btnSave, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 15, 0, 3), 0, 0));
        this.jPanelBottom.add((Component)this.notesTextArea, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.scrollerBottomRight.getViewport().add(this.mlNotesEditor);
        this.scrollerTop.getViewport().add(this.epNotsDisplay);
        this.jPanelBottom.setAlignmentY(1.0f);
        this.jPanelBottom.setBorder(this.titledBorder);
        this.getContentPane().add((Component)this.jPanelTop, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (!this.bReadOnly) {
            this.getContentPane().add((Component)this.jPanelBottom, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            JSplitPane pane = new JSplitPane(0, this.jPanelTop, this.jPanelBottom);
            pane.setDividerLocation(0.5);
            this.getContentPane().add((Component)pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pane.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (!DlgNotes.this.msgShown) {
                        DlgNotes.this.saveNote();
                    } else {
                        DlgNotes.this.msgShown = false;
                    }
                }
            });
        }
        if (this.vTypes.size() > 0) {
            this.nCurrent = 0;
            this.currentType = this.vTypes.elementAt(this.nCurrent);
            this.listNoteTypes.setSelectedIndex(0);
        }
        if (this.vTypes.size() < 2) {
            this.SelectNewType();
        } else if (this.vTypes.size() > 1) {
            this.SelectNewType();
        }
        if (this.bReadOnly) {
            this.setSize(750, 300);
        } else {
            this.setSize(750, 500);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        this.setLocation((screenSize.width - frameSize.width) / 2, 1);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.listNoteTypes);
        v.add(this.cmbRefcode);
        v.add(this.mlNotesEditor);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.setFocus();
    }

    void jSave_actionPerformed(ActionEvent event) {
        this.saveNote();
    }

    void listNoteTypes_valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.SelectNewType();
        }
    }

    @Override
    public boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 119) {
            this.saveNote();
            return true;
        }
        return false;
    }

    public void setFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DlgNotes.this.bReadOnly) {
                    DlgNotes.this.epNotsDisplay.requestFocus();
                } else if (DlgNotes.this.vTypes.size() > 1) {
                    DlgNotes.this.listNoteTypes.requestFocus();
                } else {
                    DlgNotes.this.mlNotesEditor.requestFocus();
                }
                DlgNotes.this.mlNotesEditor.select(0, DlgNotes.this.mlNotesEditor.getText().length());
            }
        });
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }

    @Override
    public void okDialog() {
    }

    void jComboRefcode_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.DoEdit(null);
        }
    }

    void this_windowActivated(WindowEvent e) {
        this.setFocus();
    }

    public Vector<Note> getNotes() {
        return this.vNotes;
    }
}

