/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.regex.Pattern;

public class EmailValidator {
    private static final String FALLBACK_EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private final Pattern pattern;

    public EmailValidator(String validationPattern) {
        this.pattern = Pattern.compile(validationPattern == null || validationPattern.trim().equals("") ? FALLBACK_EMAIL_PATTERN : validationPattern);
    }

    public boolean validate(String emailAddress) {
        return this.pattern.matcher(emailAddress).matches();
    }
}

