/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Receipt;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.List;
import jpos.DlgList;
import jpos.DlgMessage;
import jpos.Note;
import jpos.PaExpense;
import jpos.PaPCFoot;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.StoreParams;
import jpos.Tender;
import jpos.basscom.utils.Utils;
import jpos.tillbalance.TillBalanceUtils;
import org.jdom.Element;

public class FrExpense
extends PosFrame {
    protected long fromVhidx = -1L;
    private boolean bCompleting = false;

    public FrExpense(PosMenuController pmenu, StoreParams psParams) {
        super(pmenu, null, 8, 1043L, psParams, StoreParams.res.getString("Expense_Detail"));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() {
        this.paBody = new PaExpense(this.sParams, this);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaPCFoot(this);
        this.contentPane.add((Component)this.paFoot, "South");
        this.voidTrans(false);
    }

    public void insertLine() {
        if (((PaPCFoot)this.paFoot).bInsert.isEnabled() && this.fromVhidx != -1L) {
            Object[] reasonsArray = ((PaExpense)this.paBody).reasons.toArray();
            Reference reason = (Reference)DlgList.showDialog(this, StoreParams.res.getString("sel_expense"), StoreParams.res.getString("Expense"), reasonsArray, reasonsArray[0]);
            if (reason != null) {
                ((PaExpense)this.paBody).insertRow(reason, "", 0.0, 0.0);
            }
        }
    }

    @Override
    public void setFocus() {
        if (this.isLoggedIn(false)) {
            if (((PaExpense)this.paBody).tfWNum.isEnabled()) {
                ((PaExpense)this.paBody).tfWNum.requestFocus();
            } else if (((PaExpense)this.paBody).tblExpenses.isEnabled()) {
                if (((PaExpense)this.paBody).tblExpenses.isEditing()) {
                    ((PaExpense)this.paBody).tblExpenses.getCellEditor().stopCellEditing();
                }
                ((PaExpense)this.paBody).tblExpenses.requestFocus();
            }
        }
    }

    @Override
    protected void setTransType() {
        this.transType = 547;
    }

    @Override
    public boolean validateTrans() {
        if (!TillBalanceUtils.canTrade()) {
            DlgMessage.showMessage(this, StoreParams.res.getString("start_of_day_required_before_trading"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        if (!((PaPCFoot)this.paFoot).bComplete.isEnabled()) {
            return false;
        }
        return ((PaExpense)this.paBody).validateData();
    }

    @Override
    public boolean completeTrans(boolean pcomplete) {
        try {
            PosUtils.startTrans(this.sParams.conn);
            this.vhidx = this.sParams.nextVal("XRET_TRANH");
            try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRAND,  TILL_NUMBER, STAFF_SALE_FLAG, NOTES1, SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, DOCKET_NUMBER, COMPLETE, ORIG_TRANIDX, TRANS_NUMBER, SALE_DATE) VALUES(?, ?, 1, ?, CURRENT_TIMESTAMP, ?, 0, ?, ?, ?, ?, ?, ?, 0, ?, ?, TRUNC_DATE(current_timestamp))");){
                prepStmt.setLong(1, this.vhidx);
                prepStmt.setInt(2, this.transType);
                prepStmt.setLong(3, this.sParams.getStoreIdx());
                prepStmt.setString(4, this.sParams.tillnum);
                prepStmt.setString(5, ((PaExpense)this.paBody).tpNotes.getText());
                prepStmt.setLong(6, this.getUser().getPeridx());
                prepStmt.setLong(7, this.getUser().getMemidx());
                prepStmt.setLong(8, this.getUser().getPeridx());
                prepStmt.setLong(9, this.getUser().getMemidx());
                prepStmt.setString(10, this.docknum == null ? "" : this.docknum);
                prepStmt.setLong(11, this.fromVhidx);
                prepStmt.setString(12, this.transnum == null ? "" : this.transnum);
                prepStmt.executeUpdate();
            }
            Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.vhidx);
            Tender withDrawal = new Tender(548L, ((PaExpense)this.paBody).tfAmt.getDouble() * -1.0, this.sParams);
            withDrawal.db_insert_tender();
            Tender returnAmt = new Tender(SP.getCashPayType(), ((PaExpense)this.paBody).tfReturn.getDouble(), this.sParams);
            returnAmt.db_insert_tender();
            ((PaExpense)this.paBody).db_insertExpenses();
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate("UPDATE RET_TRANH SET COMPLETE = 1 WHERE VHIDX = " + this.vhidx);
            }
            this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.vhidx);
            PosUtils.endTrans(this.sParams.conn);
            return true;
        }
        catch (Exception e) {
            PosUtils.releaseTrans(this.sParams.conn);
            PosUtils.logError(e);
            return false;
        }
    }

    @Override
    public void delLines() {
        if (((PaPCFoot)this.paFoot).bDelete.isEnabled()) {
            ((PaExpense)this.paBody).delLines();
        }
    }

    @Override
    public void voidTrans(boolean logout) {
        if (!logout || this.isLoggedIn(!logout)) {
            super.voidTrans(logout);
            this.fromVhidx = -1L;
            ((PaExpense)this.paBody).clearFields();
            ((PaExpense)this.paBody).lFeedBack.setForeground(this.getDefaultColor());
        }
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 116) {
            this.insertLine();
        }
        return true;
    }

    @Override
    public void setStatusText(String msg) {
        ((PaPCFoot)this.paFoot).statusBar.setText(msg);
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaPCFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void resetStatus() {
        ((PaPCFoot)this.paFoot).statusBar.reset();
    }

    @Override
    public boolean isVoid() {
        return ((PaExpense)this.paBody).tblExpenses.getRowCount() == 0 && this.transnum == null;
    }

    @Override
    protected void setEditable(boolean peditable) {
        super.setEditable(peditable);
        ((PaExpense)this.paBody).tfWNum.setEnabled(this.editable);
        ((PaExpense)this.paBody).tpNotes.setEnabled(this.editable);
        ((PaPCFoot)this.paFoot).bComplete.setEnabled(this.editable);
        ((PaPCFoot)this.paFoot).bDelete.setEnabled(this.editable);
        ((PaPCFoot)this.paFoot).bInsert.setEnabled(this.editable);
    }

    @Override
    public boolean populate(Element trans) {
        try {
            if (super.populate(trans)) {
                String storeno = trans.getAttribute("widx") != null ? this.sParams.getStore(trans.getAttribute("widx").getLongValue()).getStoreNo() : "000";
                ((PaExpense)this.paBody).lFeedBack.setText(StoreParams.res.getString("Docket_") + " D" + storeno + this.docknum);
                ((PaExpense)this.paBody).tfWNum.setText(storeno + this.transnum);
                if (trans.getAttribute("notes1") != null) {
                    ((PaExpense)this.paBody).tpNotes.setText(trans.getAttribute("notes1").getValue());
                }
                List payments = trans.getChild("payments").getChildren("tender");
                for (int i = 0; i < payments.size(); ++i) {
                    if (((Element)payments.get(i)).getAttribute("payment_typeidx").getLongValue() == 548L) {
                        ((PaExpense)this.paBody).tfAmt.setText(PosUtils.doubleValInternal(((Element)payments.get(i)).getText()) * -1.0);
                        continue;
                    }
                    if (((Element)payments.get(i)).getAttribute("payment_typeidx").getLongValue() != SP.getCashPayType()) continue;
                    ((PaExpense)this.paBody).tfReturn.setText(((Element)payments.get(i)).getText());
                }
                if (trans.getChild("styles") != null) {
                    List expenses = trans.getChild("styles").getChildren("style");
                    for (int i = 0; i < expenses.size(); ++i) {
                        Reference expense = new Reference(((Element)expenses.get(i)).getAttribute("line_code").getLongValue());
                        double amt = ((Element)expenses.get(i)).getAttribute("price").getDoubleValue();
                        double tax = amt - amt / (1.0 + ((Element)expenses.get(i)).getAttribute("taxper").getDoubleValue() / 100.0);
                        String details = "";
                        if (((Element)expenses.get(i)).getAttribute("descrip1") != null) {
                            details = ((Element)expenses.get(i)).getAttribute("descrip1").getValue();
                        }
                        ((PaExpense)this.paBody).insertRow(expense, details, tax, amt);
                    }
                }
                this.setEditable(false);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            this.voidTrans(false);
            return false;
        }
        return true;
    }

    @Override
    public void printReceipt(boolean reprint) {
        Receipt receipt = new Receipt(this, StoreParams.res.getString("Printing_Receipt"), false, this.sParams.getDocketConnection(), this.vhidx, reprint);
        if (receipt.isValidReceipt()) {
            receipt.PrintExpense();
        } else {
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), objs), StoreParams.res.getString("Error"), 0);
        }
        receipt.close();
    }

    @Override
    protected void setTransnum() {
    }

    @Override
    protected void updateSec(boolean[] formSec) {
    }

    @Override
    public void notesSet() {
        for (int i = 0; i < this.notes.size(); ++i) {
            Note note = (Note)this.notes.elementAt(i);
            if (note.noteType.getTblidx() != 23L) continue;
            ((PaExpense)this.paBody).lFeedBack.setForeground(this.notesColor);
        }
    }

    @Override
    public boolean checkExit() {
        if (this.editable && ((PaExpense)this.paBody).tblExpenses.getRowCount() > 0) {
            return super.checkExit();
        }
        return true;
    }

    @Override
    public void refreshImage() {
    }

    @Override
    public void processLogin() {
    }

    @Override
    public boolean completeTrans() {
        boolean bResult = false;
        if (!this.bCompleting) {
            this.bCompleting = true;
            bResult = super.completeTrans();
            if (bResult) {
                this.voidTrans(false);
            }
            this.bCompleting = false;
        }
        return bResult;
    }
}

