/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jpos.PosUtils;
import jpos.SP;
import jpos.StringUtils;
import jpos.basscom.utils.Utils;

public class GeneralTillSettings {
    public static void saveSettings(SettingsType settingsType, String settings, Connection connection) {
        block26: {
            try (PreparedStatement stmtUpdate = connection.prepareStatement("UPDATE GENERAL_TILL_SETTINGS SET SETTINGS_VALUE = ? WHERE TILL_NAME = ? AND SETTINGS_KEY = ?");){
                stmtUpdate.setString(1, settings);
                stmtUpdate.setString(2, SP.sParams.tillnum.toUpperCase());
                stmtUpdate.setString(3, settingsType.toString());
                if (stmtUpdate.executeUpdate() != 0) break block26;
                try (PreparedStatement stmtInsert = connection.prepareStatement("INSERT INTO GENERAL_TILL_SETTINGS(SETTINGS_VALUE, TILL_NAME, SETTINGS_KEY) VALUES(?, ?, ?)");){
                    stmtInsert.setString(1, settings);
                    stmtInsert.setString(2, SP.sParams.tillnum.toUpperCase());
                    stmtInsert.setString(3, settingsType.toString());
                    stmtInsert.executeUpdate();
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public static String loadSettings(SettingsType settingsType, Connection connection) {
        String settings = "";
        try (PreparedStatement select = connection.prepareStatement("SELECT SETTINGS_VALUE FROM GENERAL_TILL_SETTINGS WHERE TILL_NAME = ? AND SETTINGS_KEY = ?");){
            select.setString(1, SP.sParams.tillnum.toUpperCase());
            select.setString(2, settingsType.toString());
            try (ResultSet result = select.executeQuery();){
                if (result.next()) {
                    settings = StringUtils.nullToEmpty(result.getString(1));
                }
            }
        }
        catch (SQLException e) {
            Utils.logError(e);
        }
        return settings;
    }

    public static enum SettingsType {
        EFTPOS;

    }
}

