/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.SkuPrice;
import jpos.StoreParams;
import org.jdom.Element;

public class Kit {
    private Vector<KitDet> kitDets = new Vector();
    private KitType kitType = KitType.WHOLESALE;
    private PosFrame parent;
    private long kitidx = 0L;
    private String kitName = "";

    public Kit(PosFrame parent, long kitidx, String kitName, KitType kitType) {
        this.parent = parent;
        this.kitidx = kitidx;
        this.kitName = kitName;
        this.kitType = kitType;
    }

    public Vector<KitDet> getKitDets() {
        return this.kitDets;
    }

    public long getKitidx() {
        return this.kitidx;
    }

    public String toString() {
        return this.kitName;
    }

    public void loadFromDatabase() {
        this.kitDets.clear();
        try (PreparedStatement prepStmt = SP.sParams.conn.prepareStatement("SELECT S.STYLEIDX, C.CLRIDX, COALESCE(S.NAME, '') || ' ' || COALESCE(C.CLRNAME, ''), K.SKUIDX, S.TAXPER FROM KIT_HDR H, KIT_DET D, STYLE S, CLR C, SKU K WHERE H.IDX = D.KITIDX AND S.STYLEIDX = D.STYLEIDX AND COALESCE(D.CLRIDX, C.CLRIDX) = C.CLRIDX AND C.STYLEIDX = S.STYLEIDX AND K.CLRIDX = C.CLRIDX AND S.\"ACTIVE\" = 1 AND C.\"ACTIVE\" = 1 AND K.\"ACTIVE\" = 1 AND D.\"ACTIVE\" = 1 AND H.\"ACTIVE\" = 1 AND H.IDX = ? ORDER BY D.SEQ, D.IDX, C.CLRCODE, C.CLRIDX, K.SIZESEQ");){
            prepStmt.setLong(1, this.kitidx);
            try (ResultSet result = prepStmt.executeQuery();){
                while (result.next()) {
                    KitDet kitDet = new KitDet();
                    kitDet.styleidx = result.getLong(1);
                    kitDet.clridx = result.getLong(2);
                    kitDet.description = result.getString(3);
                    kitDet.skuidx = result.getLong(4);
                    kitDet.tax = result.getDouble(5);
                    kitDet.discount = 0.0;
                    SkuPrice skuPrice = new SkuPrice(kitDet.skuidx);
                    kitDet.price = skuPrice.getPrice();
                    kitDet.origPrice = skuPrice.getOrigPrice();
                    this.kitDets.add(kitDet);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public boolean loadFromHeadOffice(long memidx) {
        SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("kit", this.kitidx + "," + memidx).getXML();
        if (SP.sParams.root == null) {
            DlgMessage.showMessage(this.parent, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            return false;
        }
        this.kitDets.clear();
        Element kit = SP.sParams.root;
        List styles = kit.getChildren("style");
        for (int i = 0; i < styles.size(); ++i) {
            List skus = ((Element)styles.get(i)).getChildren("sku");
            for (int j = 0; j < skus.size(); ++j) {
                KitDet kitDet = new KitDet();
                kitDet.skuidx = PosUtils.longVal(((Element)skus.get(j)).getText());
                kitDet.styleidx = PosUtils.longVal(((Element)styles.get(i)).getAttribute("styleidx").getValue());
                kitDet.clridx = PosUtils.longVal(((Element)styles.get(i)).getAttribute("clridx").getValue());
                kitDet.description = ((Element)styles.get(i)).getAttribute("descrip").getValue();
                kitDet.tax = PosUtils.doubleValInternal(((Element)styles.get(i)).getAttribute("tax").getValue());
                kitDet.discount = PosUtils.doubleValInternal(((Element)styles.get(i)).getAttribute("discount").getValue());
                double price = PosUtils.doubleValInternal(((Element)styles.get(i)).getAttribute("price").getValue());
                double origPrice = PosUtils.doubleValInternal(((Element)styles.get(i)).getAttribute("orig_price").getValue());
                kitDet.price = price + SP.sParams.rnd(price * kitDet.tax / 100.0);
                kitDet.origPrice = origPrice + SP.sParams.rnd(origPrice * kitDet.tax / 100.0);
                this.kitDets.add(kitDet);
            }
        }
        return true;
    }

    public static Vector<Kit> loadKitList(PosFrame parent, long custidx, KitType kitType) {
        Vector<Kit> kits = new Vector<Kit>();
        try (PreparedStatement prepStmt = SP.sParams.conn.prepareStatement("SELECT H.IDX, H.TITLE FROM KIT_HDR H WHERE H.\"ACTIVE\" = 1 AND H.CUSTIDX = ? ORDER BY H.TITLE");){
            prepStmt.setLong(1, custidx);
            try (ResultSet result = prepStmt.executeQuery();){
                while (result.next()) {
                    Kit k = new Kit(parent, result.getLong(1), result.getString(2), kitType);
                    kits.add(k);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return kits;
    }

    public KitType getKitType() {
        return this.kitType;
    }

    public class KitDet {
        long skuidx;
        long styleidx;
        long clridx;
        double price;
        double origPrice;
        double tax;
        double discount;
        String description;
    }

    public static enum KitType {
        WHOLESALE,
        RETAIL;

    }
}

