/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import jpos.DiscLine;
import jpos.Discount;
import jpos.DlgDiscAmt;
import jpos.DlgMessage;
import jpos.LoyaltyDetails;
import jpos.PosDouble;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.SalesRep;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.StyleTable;
import jpos.basscom.utils.Utils;
import jpos.cardfee.CardFeeUtils;
import jpos.voucher.VoucherUtils;

public class MultiLineDisc {
    public static final int WHOLESALE = 557;
    public static final int PROMOTION = 720;
    public static final int COUPON = 849;
    private LoyaltyDetails loyaltyDetails = new LoyaltyDetails();
    private StyleTable tblStyles;
    private Discount discount;
    private Vector<DiscLine> discLines = new Vector();
    private Vector<PosDouble> thresholds = new Vector();
    private Vector<PosDouble> rates = new Vector();
    private Vector<Boolean> percs = new Vector();
    private double loyalHist = 0.0;
    private double finalDiscPer = 0.0;
    private double finalDiscAmt = 0.0;
    private double finalPrice = 0.0;
    private DiscountType discountType = DiscountType.PERCENTAGE;
    private boolean discAmtFinal = false;
    private double maxDisc = 0.0;
    private double minPur = 0.0;
    private boolean newDisc = true;
    private double currDiscPer = 0.0;
    private boolean overRidable = false;
    private boolean discValid = true;
    private String extraMsg = "";
    private long promoIdx = 0L;
    private String promoName = "";
    private MessageCode messageCode = MessageCode.NORMAL;
    private SalesRep overrideSalesRep = null;
    private String description1 = null;
    private String description2 = null;
    private String rewardsProgramName = null;
    private long couponIdx;
    private String couponCode;

    public MultiLineDisc(StyleTable tblStyles, Discount pDisc, boolean newDisc, boolean bLoyalty, long promoIdx, MessageCode messageCode) {
        this.tblStyles = tblStyles;
        this.newDisc = newDisc;
        this.promoIdx = promoIdx;
        this.messageCode = messageCode;
        if (bLoyalty) {
            this.setLoyaltyDetails(pDisc);
            this.setDiscDetails(this.discount);
        } else {
            this.setDiscDetails(pDisc);
        }
        this.setExtraMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLineDisc(StyleTable tblStyles, Discount pDisc, Vector<StyleLine> lines, SalesRep overrideSalesRep) {
        this.tblStyles = tblStyles;
        this.overrideSalesRep = overrideSalesRep;
        for (int i = lines.size() - 1; i >= 0; --i) {
            Object[] objs;
            int row = tblStyles.model.getData().indexOf(lines.elementAt(i));
            if (tblStyles.getRowCount() <= row || row < 0) {
                lines.remove(i);
                continue;
            }
            StyleLine style = lines.elementAt(i);
            if (VoucherUtils.isVoucher(((StyleLine)tblStyles.getItemAt(row)).getSkuidx())) {
                tblStyles.setRowSelectionInterval(row, row);
                DlgMessage.showMessage(tblStyles.frParent, StoreParams.res.getString("disc_gv"), StoreParams.res.getString("Discount1"), 1);
                lines.remove(i);
                continue;
            }
            if (CardFeeUtils.isCardFee(((StyleLine)tblStyles.getItemAt(row)).getSkuidx())) {
                tblStyles.setRowSelectionInterval(row, row);
                DlgMessage.showMessage(tblStyles.frParent, StoreParams.res.getString("disc_card_fee"), StoreParams.res.getString("Discount1"), 1);
                lines.remove(i);
                continue;
            }
            if (!style.isNew()) {
                tblStyles.setRowSelectionInterval(row, row);
                DlgMessage.showMessage(tblStyles.frParent, StoreParams.res.getString("oldLineDisc"), StoreParams.res.getString("Discount1"), 1);
                lines.remove(i);
                continue;
            }
            if (!style.allowDisc()) {
                tblStyles.setRowSelectionInterval(row, row);
                objs = new Object[]{"\n"};
                DlgMessage.showMessage(tblStyles.frParent, MessageFormat.format(StoreParams.res.getString("You_can_enter_a"), objs), StoreParams.res.getString("Discount1"), 1);
                lines.remove(i);
                continue;
            }
            if (!style.getSkuPrice().stopDiscountsMarkdown() && !style.getSkuPrice().stopDiscountsClr()) continue;
            tblStyles.setRowSelectionInterval(row, row);
            objs = new Object[]{style.stylecode + (style.clrcode.length() > 0 ? "." + style.clrcode : "") + (style.size.length() > 0 ? "." + style.size : "")};
            DlgMessage.showMessage(tblStyles.frParent, MessageFormat.format(StoreParams.res.getString("no_further_discounts_style"), objs), StoreParams.res.getString("Discount1"), 1);
            lines.remove(i);
        }
        if (lines.size() > 0) {
            int i;
            this.setDiscDetails(pDisc);
            double gross = 0.0;
            for (i = 0; i < lines.size(); ++i) {
                StyleLine style = lines.elementAt(i);
                if (this.isLoyalty()) {
                    gross += style.getNetBeforeLoyalty(2);
                    continue;
                }
                if (this.isPromotion()) {
                    gross += style.getNetBeforePromotion(2, this);
                    continue;
                }
                gross += style.getGross(2);
            }
            this.setDiscAmt(gross);
            if (this.overRidable) {
                int rateIndex = this.getRateIndex(gross);
                if (rateIndex > -1) {
                    this.discountType = this.percs.elementAt(rateIndex) != false ? DiscountType.PERCENTAGE : DiscountType.AMOUNT;
                    if (this.discountType == DiscountType.PERCENTAGE) {
                        this.finalDiscPer = PosUtils.scale(this.rates.elementAt(rateIndex).doubleValue() / 100.0, 8);
                    } else if (this.discountType == DiscountType.AMOUNT) {
                        this.finalDiscAmt = this.rates.elementAt(rateIndex).doubleValue();
                    }
                }
                String newAmt = "";
                while (newAmt.equals("")) {
                    StringBuffer amt = new StringBuffer();
                    if (this.discountType == DiscountType.PERCENTAGE) {
                        amt.append(new PosDouble(this.finalDiscPer * 100.0).toString() + "%");
                    } else {
                        amt.append(new PosDouble(this.finalDiscAmt).toString());
                    }
                    DlgDiscAmt dlgAmt = new DlgDiscAmt(tblStyles.frParent, StoreParams.res.getString("Discount1"), true, amt, lines.size());
                    dlgAmt.setVisible(true);
                    newAmt = amt.toString();
                    try {
                        if (newAmt.equals("")) {
                            return;
                        }
                        int validAmt = 0;
                        if (newAmt.indexOf(37) > -1) {
                            if (PosUtils.doubleValFormatted(newAmt.substring(0, newAmt.length() - 1)) > 100.0) {
                                validAmt = 1;
                            } else if (PosUtils.doubleValFormatted(newAmt.substring(0, newAmt.length() - 1)) < 0.0) {
                                validAmt = -1;
                            }
                        } else if (newAmt.indexOf(80) > -1) {
                            StyleLine sLine;
                            int nRow = tblStyles.getSelectedRow();
                            if (nRow == -1) {
                                nRow = 0;
                            }
                            if (tblStyles.getItemAt(nRow) instanceof StyleLine && (sLine = (StyleLine)tblStyles.getItemAt(nRow)).getPrice() < PosUtils.doubleValFormatted(newAmt.substring(0, newAmt.length() - 1))) {
                                validAmt = 2;
                            }
                        } else if (PosUtils.doubleValFormatted(newAmt) > gross) {
                            validAmt = 1;
                        } else if (PosUtils.doubleValFormatted(newAmt) < 0.0) {
                            validAmt = -1;
                        }
                        if (validAmt > 0) {
                            if (validAmt > 1) {
                                DlgMessage.showMessage(tblStyles.frParent, StoreParams.res.getString("price_too_high"), StoreParams.res.getString("Discount1"), 2);
                            } else {
                                DlgMessage.showMessage(tblStyles.frParent, StoreParams.res.getString("disc_too_high"), StoreParams.res.getString("Discount1"), 2);
                            }
                            newAmt = "";
                            continue;
                        }
                        if (validAmt >= 0) continue;
                        DlgMessage.showMessage(tblStyles.frParent, StoreParams.res.getString("disc_too_low"), StoreParams.res.getString("Discount1"), 2);
                        newAmt = "";
                    }
                    catch (NumberFormatException e) {
                        newAmt = "";
                    }
                }
                if (newAmt.indexOf(37) > -1) {
                    this.setFinalRate(PosUtils.scale(PosUtils.doubleValFormatted(newAmt.substring(0, newAmt.length() - 1)) / 100.0, 8), DiscountType.PERCENTAGE);
                } else if (newAmt.toString().indexOf(80) > -1) {
                    this.setFinalRate(SP.sParams.rnd(PosUtils.doubleValFormatted(newAmt.substring(0, newAmt.length() - 1))), DiscountType.PRICE);
                } else {
                    this.setFinalRate(SP.sParams.rnd(PosUtils.doubleValFormatted(newAmt)), DiscountType.AMOUNT);
                }
                this.setDiscAmt(gross);
            }
            tblStyles.beginUpdate();
            try {
                for (i = 0; i < lines.size(); ++i) {
                    this.addDiscLine(lines.elementAt(i), -1L);
                }
            }
            finally {
                tblStyles.endUpdate();
            }
        }
    }

    public void setFinalRate(double rate, DiscountType discType) {
        this.discountType = discType;
        this.discAmtFinal = true;
        if (this.discountType == DiscountType.PERCENTAGE) {
            this.finalDiscPer = rate;
        } else if (this.discountType == DiscountType.AMOUNT) {
            this.finalDiscAmt = rate;
        } else if (this.discountType == DiscountType.PRICE) {
            this.finalPrice = rate;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addDiscLine(StyleLine style, long pos_vshidx) {
        DiscLine disc;
        if (style.isNew()) {
            if (VoucherUtils.isVoucher(style.getSkuidx())) return false;
            if (CardFeeUtils.isCardFee(style.getSkuidx())) {
                return false;
            }
            if (this.isManualDiscount()) {
                if (style.getSkuPrice().stopDiscountsMarkdown()) return false;
                if (style.getSkuPrice().stopDiscountsClr()) {
                    return false;
                }
            }
            if (this.isLoyalty()) {
                try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT COUNT(*) " + this.loyaltyDetails.getRestrictSql() + " AND S.STYLEIDX = " + style.getStyleidx());){
                    if (sql.next() && sql.getInt(1) == 0) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (SQLException ex) {
                    PosUtils.logError(ex);
                }
            }
        }
        if (!style.addDisc(disc = new DiscLine(style, this, SP.sParams, pos_vshidx))) return false;
        if (!this.tblStyles.addDiscLine(disc)) return false;
        this.discLines.add(disc);
        return true;
    }

    private boolean setDiscAmt(double gross) {
        if (!this.isManualDiscount()) {
            if (this.finalDiscPer != this.currDiscPer) {
                this.currDiscPer = Math.min(this.finalDiscPer, 1.0);
                return true;
            }
            return false;
        }
        double newDiscPer = 0.0;
        this.discValid = true;
        this.extraMsg = "";
        int nRow = this.tblStyles.getSelectedRow();
        if (nRow == -1) {
            nRow = 0;
        }
        if (nRow >= this.tblStyles.getRowCount()) {
            return false;
        }
        if (this.discValid) {
            if (gross < this.minPur && gross > 0.0) {
                this.discValid = false;
                Object[] objs = new Object[]{SP.sParams.currFormat.format(this.minPur)};
                this.extraMsg = MessageFormat.format(StoreParams.res.getString("Min_pur"), objs);
            } else {
                if (this.discAmtFinal) {
                    newDiscPer = this.finalDiscPer;
                    if (this.discountType == DiscountType.AMOUNT) {
                        newDiscPer = gross == 0.0 ? 0.0 : PosUtils.scale(this.finalDiscAmt / gross, 8);
                    } else if (this.discountType == DiscountType.PRICE && this.tblStyles.getItemAt(nRow) instanceof StyleLine) {
                        StyleLine sLine = (StyleLine)this.tblStyles.getItemAt(nRow);
                        double nQty = sLine.getQty();
                        newDiscPer = PosUtils.scale(gross != 0.0 ? (gross - this.finalPrice * nQty) / gross : 0.0, 8);
                    }
                } else {
                    int rateIndex = this.getRateIndex(gross + this.loyalHist);
                    if (rateIndex > -1) {
                        this.discountType = this.percs.elementAt(rateIndex) != false ? DiscountType.PERCENTAGE : DiscountType.AMOUNT;
                        if (this.discountType == DiscountType.PERCENTAGE) {
                            newDiscPer = PosUtils.scale(this.rates.elementAt(rateIndex).doubleValue() / 100.0, 8);
                        } else if (this.discountType == DiscountType.AMOUNT) {
                            this.finalDiscAmt = this.rates.elementAt(rateIndex).doubleValue();
                            newDiscPer = PosUtils.scale(this.finalDiscAmt / gross, 8);
                        }
                    }
                }
                if (this.maxDisc > 0.0 && this.maxDisc < newDiscPer * 100.0) {
                    this.discValid = false;
                    this.extraMsg = SP.sParams.currFormat.format(this.maxDisc) + "% " + StoreParams.res.getString("Max_disc");
                    newDiscPer = PosUtils.scale(this.maxDisc / 100.0, 8);
                }
            }
        }
        if (newDiscPer != this.currDiscPer) {
            this.currDiscPer = Math.min(newDiscPer, 1.0);
            return true;
        }
        return false;
    }

    public boolean reEvalDiscAmt() {
        return this.setDiscAmt(this.getStyleGross());
    }

    private double getStyleGross() {
        double total = 0.0;
        for (int i = 0; i < this.discLines.size(); ++i) {
            if (this.isLoyalty()) {
                total += this.discLines.elementAt(i).getStyleParent().getNetBeforeLoyalty(2);
            }
            if (this.isPromotion()) {
                total += this.discLines.elementAt(i).getStyleParent().getNetBeforePromotion(2, this);
                continue;
            }
            total += this.discLines.elementAt(i).getStyleParent().getGross(2);
        }
        return total;
    }

    private int getRateIndex(double gross) {
        int rateIndex = -1;
        for (int i = 0; i < this.thresholds.size(); ++i) {
            double threshold = this.thresholds.elementAt(i).doubleValue();
            if (!(threshold <= gross) || rateIndex != -1 && !(threshold > this.thresholds.elementAt(rateIndex).doubleValue())) continue;
            rateIndex = i;
        }
        return rateIndex;
    }

    private void setDiscDetails(Discount pDisc) {
        this.discount = pDisc;
        String discDetails = this.discount.getBlobText();
        Vector<String> vToks1 = new Vector<String>();
        Vector<String> vToks2 = new Vector<String>();
        if (this.discount.getIdx() == 720L || this.discount.getIdx() == 849L) {
            this.loadPromoDetails();
        }
        if (discDetails == null || discDetails.equals("")) {
            this.finalDiscPer = 0.0;
            this.maxDisc = 0.0;
            this.minPur = 0.0;
        } else {
            boolean oldDiscSetup;
            boolean bl = oldDiscSetup = discDetails.indexOf(3) == -1;
            if (oldDiscSetup) {
                Utils.stringTokenize(discDetails, "@", vToks2);
                this.finalDiscPer = PosUtils.scale(PosUtils.doubleValInternal(vToks2.elementAt(1)) / 100.0, 8);
                this.discAmtFinal = true;
            } else {
                Utils.stringTokenize(discDetails, "\u0003", vToks1);
                Utils.stringTokenize(vToks1.elementAt(0), "@", vToks2);
            }
            this.maxDisc = PosUtils.doubleValInternal(vToks2.elementAt(2));
            if (oldDiscSetup) {
                this.minPur = PosUtils.doubleValInternal(vToks2.elementAt(3));
                this.overRidable = this.finalDiscPer == 0.0;
            } else {
                this.minPur = PosUtils.doubleValInternal(vToks2.elementAt(3));
                this.overRidable = PosUtils.booleanVal(vToks2.elementAt(4));
                StringTokenizer rateToks = new StringTokenizer(vToks1.elementAt(1), "@");
                while (rateToks.hasMoreTokens()) {
                    String thresholdRate = rateToks.nextToken();
                    this.thresholds.add(new PosDouble(PosUtils.doubleValInternal(thresholdRate.substring(0, thresholdRate.indexOf(44)))));
                    this.rates.add(new PosDouble(PosUtils.doubleValInternal(thresholdRate.substring(thresholdRate.indexOf(44) + 1, thresholdRate.length() - 2))));
                    this.percs.add(new Boolean(PosUtils.booleanVal(thresholdRate.substring(thresholdRate.length() - 1))));
                }
            }
        }
    }

    private void setExtraMessage() {
        switch (this.messageCode) {
            case NORMAL: {
                this.extraMsg = "";
                this.discValid = true;
                break;
            }
            case BASED_ON_ORIG_PRICE: {
                this.extraMsg = "";
                this.discValid = true;
                break;
            }
            case TOTAL_ALREADY_ZERO: {
                this.extraMsg = SP.getRS("Total_is_already_zero");
                this.discValid = false;
                break;
            }
            case NO_FURTHER_DISCOUNTS: {
                this.extraMsg = SP.getRS("no_further_discounts");
                this.discValid = false;
                break;
            }
            case OTHER_DISCOUNTS_BETTER_THAN_LOYALTY: {
                this.extraMsg = SP.getRS("Other_discounts_better_than_Loyalty");
                this.discValid = false;
                break;
            }
            case MINIMUM_PURCHASE_NOT_REACHED: {
                this.extraMsg = MessageFormat.format(StoreParams.res.getString("Min_pur"), PosDouble.valueOf(this.minPur));
                this.discValid = false;
                break;
            }
            default: {
                this.extraMsg = "";
                this.discValid = true;
            }
        }
    }

    public static Vector<String> getCompatibles(Reference loyalty) {
        LoyaltyDetails loyaltyDetailsTemp = new LoyaltyDetails(loyalty);
        return loyaltyDetailsTemp.getCompatibleLoyalties();
    }

    public static boolean hasDisc(Reference loyalty) {
        return loyalty != null && loyalty.getBlobText() != null && loyalty.getBlobText().indexOf("\u0003") > 0;
    }

    private void setLoyaltyDetails(Reference pLoyalty) {
        this.loyaltyDetails.setLoyaltyDetails(pLoyalty);
        this.discount = this.loyaltyDetails.getDiscount();
    }

    private void loadPromoDetails() {
        this.promoName = "";
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT NAME FROM PROMO WHERE PROIDX = " + this.promoIdx);){
            if (sql.next()) {
                this.promoName = sql.getString(1);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public boolean isLoyalty() {
        return this.loyaltyDetails != null && this.loyaltyDetails.getLoyalty() != null;
    }

    public boolean isPromotion() {
        return this.discount != null && (this.discount.getIdx() == 720L || this.discount.getIdx() == 849L) && this.promoIdx != 0L;
    }

    public boolean isCoupon() {
        return this.discount != null && this.discount.getIdx() == 849L && this.promoIdx != 0L;
    }

    public boolean isRewardsDiscount() {
        return this.discount != null && this.discount.getIdx() == 786L && !this.isLoyalty();
    }

    public boolean isRewardsLoyalty() {
        return this.isLoyalty() && this.getLoyalty().getIdx() == 787L;
    }

    public boolean isManualDiscount() {
        return !this.isLoyalty() && !this.isPromotion();
    }

    public boolean isNew() {
        return this.newDisc;
    }

    public Reference getLoyalty() {
        return this.loyaltyDetails.getLoyalty();
    }

    public LoyaltyDetails getLoyaltyDetails() {
        return this.loyaltyDetails;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public Vector<DiscLine> getDiscLines() {
        return this.discLines;
    }

    public double getCurrDiscPer() {
        return PosUtils.scale(this.currDiscPer, 8);
    }

    public boolean isDiscValid() {
        return this.discValid;
    }

    public String getExtraMsg() {
        return this.extraMsg;
    }

    public void setExtraMsg(String extraMsg) {
        this.extraMsg = extraMsg;
    }

    public long getPromotionIdx() {
        return this.promoIdx;
    }

    public String getPromotionName() {
        return this.promoName;
    }

    public double getMinPurchase() {
        return this.minPur;
    }

    public SalesRep getOverrideSalesRep() {
        return this.overrideSalesRep;
    }

    public void setOverrideSalesRep(SalesRep overrideSalesRep) {
        this.overrideSalesRep = overrideSalesRep;
    }

    public String getDescription1() {
        return this.description1;
    }

    public String getDescription2() {
        return this.description2;
    }

    public void setDescription(String description1, String description2) {
        this.description1 = description1;
        this.description2 = description2;
    }

    public String getRewardsProgramName() {
        return this.rewardsProgramName;
    }

    public void setRewardsProgramName(String personRewardsProgName) {
        this.rewardsProgramName = personRewardsProgName;
    }

    public long getCouponIdx() {
        return this.couponIdx;
    }

    public String getCouponCode() {
        return this.couponCode;
    }

    public void setCoupon(long couponIdx, String couponCode) {
        this.couponIdx = couponIdx;
        this.couponCode = couponCode;
    }

    public static enum MessageCode {
        NORMAL,
        BASED_ON_ORIG_PRICE,
        TOTAL_ALREADY_ZERO,
        NO_FURTHER_DISCOUNTS,
        OTHER_DISCOUNTS_BETTER_THAN_LOYALTY,
        MINIMUM_PURCHASE_NOT_REACHED;

    }

    public static enum DiscountType {
        PERCENTAGE,
        AMOUNT,
        PRICE;

    }
}

