/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Timestamp;
import jpos.DlgMessage;
import jpos.PosDateFormatter;
import jpos.PosDateSearch;
import jpos.PosUtils;
import jpos.SP;
import jpos.basscom.swing.BJTextField;

public class PosDateField
extends BJTextField {
    private boolean bIsValid = true;
    private PosDateFormatter dateFormatter;
    PosDateSearch dtSearch;
    private Window parent = null;
    private int yearsBeforeToday = -1;
    private int yearsAfterToday = -1;

    public PosDateField(Window parent) {
        this(parent, -1, -1);
    }

    public PosDateField(Window parent, int yearsBeforeToday, int yearsAfterToday) {
        this.parent = parent;
        this.yearsBeforeToday = yearsBeforeToday;
        this.yearsAfterToday = yearsAfterToday;
        try {
            this.dateFormatter = new PosDateFormatter(null, 3, 3, 0);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                PosDateField.this.bIsValid = false;
            }
        });
    }

    public Timestamp getValue() {
        return this.dateFormatter.getTimestamp();
    }

    public void setValue(Timestamp timestamp) {
        this.dateFormatter.setTimestamp(timestamp);
        this.setText(this.dateFormatter.toString());
    }

    public void setValue(String timestamp) {
        this.dateFormatter.setTimestampInternal(timestamp);
        this.setText(this.dateFormatter.toString());
    }

    @Override
    public void actionValidate() {
        this.actionValidate(true);
    }

    public void actionValidate(boolean showMessage) {
        String fmtVal = this.validate(this.getText(), showMessage);
        if (fmtVal.equals("INVALID")) {
            this.requestFocus();
            return;
        }
        if (!fmtVal.equals(this.getText())) {
            this.setText(fmtVal);
        }
        this.valueChanged();
    }

    @Override
    public void actionSearch() {
        String fmtVal = this.search(this.parent, this.getText());
        if (!fmtVal.equals("") && !fmtVal.equals(this.getText())) {
            this.setText(fmtVal);
        }
        this.valueChanged();
    }

    private String validate(String timestampString, boolean showMessage) {
        this.bIsValid = false;
        if (timestampString == null || timestampString.equals("")) {
            this.dateFormatter.setTimestampInternal("");
            this.bIsValid = true;
            return "";
        }
        try {
            this.dateFormatter.setTimestamp(timestampString);
        }
        catch (Exception e) {
            if (showMessage) {
                DlgMessage.showMessage(this.parent, SP.getRS("Invalid_Date_Format"), SP.getRS("Error"), 0);
            }
            return "INVALID";
        }
        this.bIsValid = true;
        return this.dateFormatter.toString();
    }

    private PosDateSearch getDateSearch() {
        if (this.dtSearch == null) {
            this.dtSearch = new PosDateSearch(this.parent, SP.getRS("Calendar"), true, this.dateFormatter, this.yearsBeforeToday, this.yearsAfterToday);
        }
        return this.dtSearch;
    }

    private String search(Window parent, String dateStr) {
        this.getDateSearch().setVisible(true);
        return this.dateFormatter.toString();
    }

    public boolean isValidDate() {
        return this.bIsValid;
    }

    public PosDateFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    public void valueChanged() {
    }
}

