/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import sun.util.BuddhistCalendar;

public class PosDateFormatter
implements Comparable<PosDateFormatter> {
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DATE_ONLY = 0;
    public static final int TIME_ONLY = 1;
    public static final int DATE_TIME = 2;
    private int dateStyle = 3;
    private int timeStyle = 2;
    private int format = 2;
    private Timestamp timestamp;
    private Locale locale;

    public PosDateFormatter(Timestamp timestamp) {
        this.timestamp = timestamp;
        this.locale = Locale.getDefault();
    }

    public PosDateFormatter(Timestamp timestamp, int dateStyle, int timeStyle, int format) {
        this.timestamp = timestamp;
        this.locale = Locale.getDefault();
        this.setFormat(dateStyle, timeStyle, format);
    }

    public PosDateFormatter(Timestamp timestamp, Locale locale) {
        this.timestamp = timestamp;
        this.locale = locale;
    }

    public PosDateFormatter(Timestamp timestamp, Locale locale, int style, int format) {
        this.timestamp = timestamp;
        this.locale = locale;
        this.setFormat(style, format);
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public void setTime(long time) {
        if (this.timestamp == null) {
            this.timestamp = new Timestamp(time);
        } else {
            this.timestamp.setTime(time);
        }
    }

    public long getTime() {
        if (this.timestamp == null) {
            return 0L;
        }
        return this.timestamp.getTime();
    }

    public void setTimestamp(String timestampString) throws ParseException {
        SimpleDateFormat simpleDateFormat = null;
        if (this.format == 0) {
            simpleDateFormat = this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateInstance(this.dateStyle, this.locale));
        } else if (this.format == 1) {
            simpleDateFormat = this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getTimeInstance(this.timeStyle, this.locale));
        } else if (this.format == 2) {
            simpleDateFormat = this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, this.locale));
        }
        if (simpleDateFormat != null) {
            simpleDateFormat.setLenient(false);
            if (this.timestamp == null) {
                this.timestamp = new Timestamp(simpleDateFormat.parse(timestampString).getTime());
            } else {
                this.timestamp.setTime(simpleDateFormat.parse(timestampString).getTime());
            }
            this.fixYear();
        }
    }

    private void fixYear() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), this.locale);
        calendar.setTime(this.timestamp);
        int year = calendar.get(1);
        if (year < 100) {
            GregorianCalendar startDate = new GregorianCalendar(TimeZone.getDefault(), this.locale);
            startDate.setTime(new Date());
            ((Calendar)startDate).add(1, -80);
            int startYear = startDate.get(1);
            int ambiguousStartYear = startYear % 100;
            calendar.set(1, year += startYear / 100 * 100 + (year < ambiguousStartYear ? 100 : 0));
            this.timestamp.setTime(calendar.getTimeInMillis());
        } else if (year > 9999) {
            try {
                year = Integer.parseInt(String.valueOf(year).substring(0, 4));
            }
            catch (Exception e) {
                year = 9999;
            }
            calendar.set(1, year);
            this.timestamp.setTime(calendar.getTimeInMillis());
        }
    }

    public void setFormat(int style, int format) {
        this.setFormat(style, style, format);
    }

    public void setFormat(int dateStyle, int timeStyle, int format) {
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
        this.format = format;
    }

    public void setTimestampInternal(String timestampString) throws IllegalArgumentException {
        if (timestampString == null || timestampString.equals("")) {
            this.timestamp = null;
        } else {
            if (timestampString.trim().length() == 10) {
                timestampString = timestampString + " 00:00:00.0";
            }
            this.timestamp = Timestamp.valueOf(timestampString);
        }
    }

    public String toString() {
        try {
            if (this.timestamp == null) {
                return "";
            }
            switch (this.format) {
                case 0: {
                    return this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateInstance(this.dateStyle, this.locale)).format(this.timestamp);
                }
                case 1: {
                    return this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getTimeInstance(this.timeStyle, this.locale)).format(this.timestamp);
                }
                case 2: {
                    return this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, this.locale)).format(this.timestamp);
                }
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String toStringInternal() {
        try {
            if (this.timestamp == null) {
                return "";
            }
            SimpleDateFormat simpleDateFormat = null;
            switch (this.format) {
                case 0: {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                    return simpleDateFormat.format(this.timestamp);
                }
                case 1: {
                    simpleDateFormat = new SimpleDateFormat("hh:mm:ss", Locale.ENGLISH);
                    return simpleDateFormat.format(this.timestamp);
                }
                case 2: {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.ENGLISH);
                    return simpleDateFormat.format(this.timestamp);
                }
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getDatePattern() {
        return this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateInstance(this.dateStyle, this.locale)).toPattern();
    }

    public String getTimePattern() {
        return this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getTimeInstance(this.timeStyle, this.locale)).toPattern();
    }

    public String getDateTimePattern() {
        return this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, this.locale)).toPattern();
    }

    private SimpleDateFormat convertPatternTo4DigitYear(SimpleDateFormat simpleDateFormat) {
        String pattern = simpleDateFormat.toPattern();
        if (pattern != null && !pattern.contains("yyyy") && pattern.contains("yy")) {
            pattern = pattern.replace("yy", "yyyy");
            simpleDateFormat.applyPattern(pattern);
        }
        if (simpleDateFormat.getCalendar() instanceof BuddhistCalendar) {
            simpleDateFormat.setCalendar(new GregorianCalendar(TimeZone.getDefault(), this.locale));
        }
        return simpleDateFormat;
    }

    public static void truncateTime(java.sql.Date date) {
        if (date != null) {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            cal.setTimeInMillis(date.getTime());
            cal.clear(10);
            cal.set(11, 0);
            cal.clear(12);
            cal.clear(13);
            cal.clear(14);
            date.setTime(cal.getTimeInMillis());
        }
    }

    public static void truncateTime(Timestamp time) {
        if (time != null) {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            cal.setTimeInMillis(time.getTime());
            cal.clear(10);
            cal.set(11, 0);
            cal.clear(12);
            cal.clear(13);
            cal.clear(14);
            time.setTime(cal.getTimeInMillis());
        }
    }

    public void dump() {
        System.out.println(this.locale.toString());
        System.out.println("Date");
        System.out.println("Short: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateInstance(3, this.locale)).format(this.timestamp));
        System.out.println("Med: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateInstance(2, this.locale)).format(this.timestamp));
        System.out.println("Long: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateInstance(1, this.locale)).format(this.timestamp));
        System.out.println("Full: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateInstance(0, this.locale)).format(this.timestamp));
        System.out.println("\nTime");
        System.out.println("Short: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getTimeInstance(3, this.locale)).format(this.timestamp));
        System.out.println("Med: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getTimeInstance(2, this.locale)).format(this.timestamp));
        System.out.println("Long: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getTimeInstance(1, this.locale)).format(this.timestamp));
        System.out.println("Full: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getTimeInstance(0, this.locale)).format(this.timestamp));
        System.out.println("\nDate/Time");
        System.out.println("Short: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, this.locale)).format(this.timestamp));
        System.out.println("Med: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, this.locale)).format(this.timestamp));
        System.out.println("Long: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1, this.locale)).format(this.timestamp));
        System.out.println("Full: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, this.locale)).format(this.timestamp));
    }

    public void dumpPatterns() {
        System.out.println(this.locale.toString());
        System.out.println("Date");
        System.out.println("Short: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateInstance(3, this.locale)).toPattern());
        System.out.println("Med: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateInstance(2, this.locale)).toPattern());
        System.out.println("Long: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateInstance(1, this.locale)).toPattern());
        System.out.println("Full: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateInstance(0, this.locale)).toPattern());
        System.out.println("\nTime");
        System.out.println("Short: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getTimeInstance(3, this.locale)).toPattern());
        System.out.println("Med: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getTimeInstance(2, this.locale)).toPattern());
        System.out.println("Long: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getTimeInstance(1, this.locale)).toPattern());
        System.out.println("Full: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getTimeInstance(0, this.locale)).toPattern());
        System.out.println("\nDate/Time");
        System.out.println("Short: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, this.locale)).toPattern());
        System.out.println("Med: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, this.locale)).toPattern());
        System.out.println("Long: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1, this.locale)).toPattern());
        System.out.println("Full: " + this.convertPatternTo4DigitYear((SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, this.locale)).toPattern());
    }

    @Override
    public int compareTo(PosDateFormatter anotherPosDateFormatter) {
        if (this.timestamp == null) {
            if (anotherPosDateFormatter == null || anotherPosDateFormatter.timestamp == null) {
                return 0;
            }
            return -1;
        }
        if (anotherPosDateFormatter == null || anotherPosDateFormatter.timestamp == null) {
            return 1;
        }
        return this.timestamp.compareTo(anotherPosDateFormatter.timestamp);
    }
}

