/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import JCP.JcpApi;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.function.Supplier;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import jpos.DlgInitialisingComponents;
import jpos.DlgMessage;
import jpos.ErrorHandler;
import jpos.FrExpense;
import jpos.FrReservations;
import jpos.FrSales;
import jpos.FrStkEnquiry;
import jpos.FrStkTake;
import jpos.FrTransferIn;
import jpos.FrTransferOut;
import jpos.FrWithDrawal;
import jpos.HeadOfficeError;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.Settings;
import jpos.SignInSettings;
import jpos.SkuReservation;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.Urgency;
import jpos.User;
import jpos.XMLLocal;
import jpos.coupons.CouponManager;
import jpos.crypt.PersonCrypt;
import jpos.custorder.auspost.DlgManifestShipments;
import jpos.custorder.auspost.DlgReprintManifest;
import jpos.pay.afterpay.AfterpayGateway;
import jpos.pay.openpay.Openpay;
import jpos.pay.zip.ZipPay;
import jpos.person.PersonDlg;
import jpos.quickreceipts.FrQuickReceipts;
import jpos.stockreceipt.FrStockReceipt;
import jpos.taxlookup.TaxLookupUtils;
import jpos.tillbalance.FrTillBalance;
import jpos.tillbalance.TillBalanceUtils;
import jpos.transreq.FrTransferRequest;
import jpos.voucher.VoucherGatewayManager;

public class PosMenuController {
    public static final int SALES = 1;
    public static final int TRANSFERSOUT = 2;
    public static final int TRANSFERSIN = 3;
    public static final int STKENQUIRY = 4;
    public static final int STKTAKE = 5;
    public static final int TILL_BALANCE = 6;
    public static final int WITHDRAWAL = 7;
    public static final int EXPENSE = 8;
    public static final int TRANSFER_REQUESTS = 9;
    public static final int DEBTOR_SALE = 10;
    public static final int RESERVATION = 11;
    public static final int CUST_ORDERS = 12;
    public static final int QUICK_RECEIPTS = 13;
    public static final int TILL_BALANCE_START_OF_DAY = 14;
    public static final int TILL_BALANCE_END_OF_DAY = 15;
    public static final int AUSPOST_GENERATE_MANIFEST = 16;
    public static final int AUSPOST_REPRINT_MANIFEST = 17;
    private static final String POSCOMMS_EXE = "poscomms.exe";
    private static final String POSCOMMS_PROCESS = "POSCOM.DOCOMM";
    private static PosMenuController instance = null;
    Vector<PosFrame> frames = new Vector();
    HashMap<String, JFrame> otherWindows = new HashMap();
    StoreParams sParams;
    public int defaultFrame = 1;
    private PosFrame openFrame = null;
    private int timerActionConsecutiveFailCount = 0;
    private boolean timerActionFailed = false;
    private int posCommsTimerCount = 60;
    private int posCommsFailCount = 0;
    private boolean posCommsDisplayIOErrorMessage = true;
    Timer timer = new Timer(2000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PosMenuController.this.timer_actionPerformed(e);
        }
    });
    private long lastPollTime = 0L;
    private boolean displayMismatchMsg = false;

    private void initialiseStaticInstance() {
        try {
            this.sParams = new StoreParams(true);
            SP.setStoreParam(this.sParams);
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
            this.defaultFrame = Settings.getStartupScreen();
            ErrorHandler.ErrorLogging errorLogging = Settings.getErrorLogging();
            if (errorLogging != ErrorHandler.ErrorLogging.NoLogging) {
                ErrorHandler.initialiseErrorHandler(SP.sParams.conn, this.sParams.getLogpath() + "poserrors.log", errorLogging);
            }
            XMLLocal.sParams = this.sParams;
            this.clearTillLocks();
            PosUtils.logActivity("Startup");
            final PosFrame newFrame = this.openFrame(this.defaultFrame, true, false, null);
            DlgInitialisingComponents.InitialiseComponents(newFrame, new Runnable(){

                @Override
                public void run() {
                    try {
                        PosMenuController.this.sParams.initEFTPOS();
                        PosMenuController.this.sParams.initDisplayDevice();
                        TaxLookupUtils.initTaxLookup();
                        PosMenuController.this.sParams.getPaymentGatewayConfigs();
                        AfterpayGateway.initialise();
                        ZipPay zipPay = SP.sParams.getZipPay(true);
                        Openpay openpay = SP.sParams.getOpenpay(true);
                        if (zipPay != null) {
                            zipPay.ReverseIncompleteZipTrans();
                        }
                        if (openpay != null) {
                            openpay.ReverseIncompleteOpenpayTrans();
                        }
                        PersonCrypt.getInstance().acquireKey(null);
                        if (VoucherGatewayManager.isGatewayInUse()) {
                            VoucherGatewayManager.isGatewayReady(newFrame);
                        }
                        CouponManager.cleanupPendingRequests();
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                }
            });
            this.timer.start();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    newFrame.paHead.signIn();
                }
            });
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void startPosCommsProcess() {
        block3: {
            try {
                Runtime.getRuntime().exec(System.getProperty("user.dir") + File.separator + POSCOMMS_EXE);
            }
            catch (Exception err) {
                ++this.posCommsFailCount;
                if (this.posCommsFailCount < 50) {
                    ErrorHandler.frErrors.logToFileOnly(err.getMessage());
                }
                if (!this.posCommsDisplayIOErrorMessage || !(err instanceof IOException) || DlgMessage.showMessage(this.openFrame, SP.getRS("poscomms_io_error_message"), SP.getRS("poscomms_io_error_title"), 3, 2) != 2) break block3;
                this.posCommsDisplayIOErrorMessage = false;
            }
        }
    }

    public static PosMenuController getInstance() {
        if (instance == null) {
            instance = new PosMenuController();
            instance.initialiseStaticInstance();
        }
        return instance;
    }

    public PosFrame getFrame(int item) {
        for (int i = 0; i < this.frames.size(); ++i) {
            if (this.frames.elementAt((int)i).frameType != item) continue;
            return this.frames.elementAt(i);
        }
        return null;
    }

    private void diposeOtherWindow(JFrame window) {
        try {
            window.dispose();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        if (window instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)window)).close();
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFrame showOtherWindow(final String key, Supplier<JFrame> generator) {
        JFrame frame;
        boolean newFrame = false;
        HashMap<String, JFrame> hashMap = this.otherWindows;
        synchronized (hashMap) {
            frame = this.otherWindows.get(key);
            if (frame == null) {
                newFrame = true;
                frame = generator.get();
                this.otherWindows.put(key, frame);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        PosMenuController.this.removeOtherWindow(key);
                    }
                });
            }
        }
        if (newFrame) {
            frame.validate();
            frame.setVisible(true);
        }
        frame.toFront();
        frame.requestFocus();
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOtherWindow(String key) {
        HashMap<String, JFrame> hashMap = this.otherWindows;
        synchronized (hashMap) {
            JFrame frame = this.otherWindows.get(key);
            if (frame != null) {
                this.diposeOtherWindow(frame);
                this.otherWindows.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Serializable frame;
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.sParams.eftpos != null) {
            try {
                StringBuffer msg = new StringBuffer();
                if (!this.sParams.eftpos.close(msg)) {
                    msg.setLength(200);
                    PosUtils.logActivity("Close down EFTPOS with error: " + msg.toString());
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        PosUtils.logActivity("Shutdown");
        while (this.frames.size() > 0) {
            frame = this.frames.elementAt(0);
            try {
                ((PosFrame)frame).dispose(false);
            }
            catch (Exception e) {
                this.frames.removeElement(frame);
                PosUtils.logError(e);
            }
        }
        frame = this.otherWindows;
        synchronized (frame) {
            Iterator<Map.Entry<String, JFrame>> windowIterator = this.otherWindows.entrySet().iterator();
            while (windowIterator.hasNext()) {
                Map.Entry<String, JFrame> entry = windowIterator.next();
                this.diposeOtherWindow(entry.getValue());
                windowIterator.remove();
            }
        }
        try {
            VoucherGatewayManager.clearInstance();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        try {
            this.sParams.dispose();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        try {
            PersonCrypt.clearInstance();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        try {
            ErrorHandler.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JcpApi.getInstance().unparkMainThread();
    }

    public boolean removeAll(boolean exit) {
        for (int i = 0; i < this.frames.size(); ++i) {
            if (this.frames.elementAt(i).checkExit()) continue;
            return false;
        }
        if (exit && !this.frames.elementAt(0).checkUsers()) {
            return false;
        }
        while (this.frames.size() > 0) {
            this.frames.elementAt(0).dispose(exit);
        }
        return true;
    }

    public PosFrame getOpenFrame() {
        return this.openFrame;
    }

    public void setOpenFrame(PosFrame frame) {
        this.openFrame = frame;
    }

    public PosFrame openFrame(int item, boolean requestSignIn, User origUser) {
        return this.openFrame(item, false, requestSignIn, origUser);
    }

    private PosFrame openFrame(int item, boolean posStartup, boolean requestSignIn, User origUser) {
        PosFrame newFrame = null;
        if (!Settings.isScreenEnabled(item)) {
            DlgMessage.showMessage(this.openFrame, StoreParams.res.getString("screen_unavailable"), PosMenuController.getScreenName(item), 1);
            return null;
        }
        boolean found = false;
        for (int i = 0; i < this.frames.size(); ++i) {
            if (this.frames.elementAt((int)i).frameType != item) continue;
            this.frames.elementAt(i).toFront();
            this.frames.elementAt(i).requestFocus();
            this.frames.elementAt(i).setFocus();
            newFrame = this.frames.elementAt(i);
            found = true;
            break;
        }
        if (!found) {
            switch (item) {
                case 1: {
                    this.frames.add(new FrSales(this, this.sParams));
                    break;
                }
                case 10: {
                    this.frames.add(new FrSales(this, this.sParams, 10, 11112L, StoreParams.res.getString("Debtor_Sale")));
                    break;
                }
                case 2: {
                    this.frames.add(new FrTransferOut(this, this.sParams));
                    break;
                }
                case 3: {
                    if (SP.sParams.isStockReceiptByCarton()) {
                        this.frames.add(new FrStockReceipt(this, this.sParams));
                        break;
                    }
                    this.frames.add(new FrTransferIn(this, this.sParams));
                    break;
                }
                case 9: {
                    this.frames.add(new FrTransferRequest(this, this.sParams));
                    break;
                }
                case 4: {
                    this.frames.add(new FrStkEnquiry(this, this.sParams));
                    break;
                }
                case 11: {
                    this.frames.add(new FrReservations(this, this.sParams));
                    break;
                }
                case 5: {
                    this.frames.add(new FrStkTake(this, this.sParams));
                    break;
                }
                case 6: {
                    this.frames.add(new FrTillBalance(this, this.sParams, TillBalanceUtils.TillBalanceType.TILL_BALANCE));
                    break;
                }
                case 14: {
                    this.frames.add(new FrTillBalance(this, this.sParams, TillBalanceUtils.TillBalanceType.START_OF_DAY));
                    break;
                }
                case 15: {
                    this.frames.add(new FrTillBalance(this, this.sParams, TillBalanceUtils.TillBalanceType.END_OF_DAY));
                    break;
                }
                case 16: {
                    DlgManifestShipments manifest = new DlgManifestShipments(this.openFrame);
                    manifest.setVisible(true);
                    break;
                }
                case 17: {
                    DlgReprintManifest manifest = new DlgReprintManifest(this.openFrame);
                    manifest.setVisible(true);
                    break;
                }
                case 7: {
                    this.frames.add(new FrWithDrawal(this, this.sParams));
                    break;
                }
                case 8: {
                    this.frames.add(new FrExpense(this, this.sParams));
                    break;
                }
                case 12: {
                    this.frames.add(new FrSales(this, this.sParams, 12, 11156L, StoreParams.res.getString("Customer_Order")));
                    break;
                }
                case 13: {
                    this.frames.add(new FrQuickReceipts(this, this.sParams));
                    break;
                }
                default: {
                    this.frames.add(new FrSales(this, this.sParams));
                }
            }
            newFrame = this.frames.elementAt(this.frames.size() - 1);
            Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            newFrame.setLocation(0, 0);
            newFrame.setSize(screenSize.width, screenSize.height);
            newFrame.validate();
            newFrame.setVisible(true);
        }
        this.openFrame = newFrame;
        if (requestSignIn) {
            this.attemptSignIn(newFrame, origUser);
        }
        return this.openFrame;
    }

    private void attemptSignIn(final PosFrame newFrame, final User origUser) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!newFrame.autoSignIn(origUser)) {
                    newFrame.paHead.signIn();
                }
            }
        });
    }

    public void setStatus(boolean status) {
        for (int i = 0; i < this.frames.size(); ++i) {
            this.frames.elementAt(i).setStatus(status);
        }
    }

    public void logoff(long memidx) {
        for (int i = 0; i < this.frames.size(); ++i) {
            this.frames.elementAt(i).logoff(memidx);
        }
    }

    public boolean populate(PosFrame origFrame, int transType, String docknum) {
        int frameType = this.getFrameType(transType, docknum);
        Reference trans = null;
        trans = new Reference(transType);
        if (frameType == 0) {
            DlgMessage.showMessage(origFrame, StoreParams.res.getString("display_unavailable"), trans.getName(), 1);
            return false;
        }
        PosFrame transFrameOrig = null;
        PosFrame transFrame = null;
        if (frameType > 0) {
            transFrameOrig = this.getFrame(frameType);
            transFrame = this.openFrame(frameType, false, origFrame.getUser());
            if (transFrame != null) {
                if (transFrame instanceof FrTillBalance) {
                    ((FrTillBalance)transFrame).setHistory(true);
                }
                if (!transFrame.autoSignIn(origFrame.getUser()) && !transFrame.paHead.signIn()) {
                    return false;
                }
                if (!transFrame.isVoid()) {
                    Object[] objs = new Object[]{trans.getName(), "\n"};
                    if (DlgMessage.showMessage(transFrame, MessageFormat.format(StoreParams.res.getString("uncompleted_trans"), objs), trans.getName(), 0, 2) != 0) {
                        return false;
                    }
                }
                if (transFrame.populate(docknum)) {
                    transFrame.setFocus();
                    return true;
                }
            }
        }
        if (transFrameOrig == null && transFrame != null) {
            transFrame.dispose(false);
        }
        this.openFrame(origFrame.frameType, false, origFrame.getUser());
        return false;
    }

    public boolean addReservation(PosFrame origFrame, SkuReservation reservation) {
        FrSales salesFrame = (FrSales)this.openFrame(1, false, origFrame.getUser());
        if (salesFrame != null) {
            if (!salesFrame.autoSignIn(origFrame.getUser()) && !salesFrame.paHead.signIn()) {
                return false;
            }
            if (!salesFrame.isVoid()) {
                Reference trans = new Reference(239L);
                Object[] objs = new Object[]{trans.getName(), "\n"};
                if (DlgMessage.showMessage(salesFrame, MessageFormat.format(StoreParams.res.getString("uncompleted_trans"), objs), trans.getName(), 0, 2) == 1) {
                    return false;
                }
                salesFrame.voidTrans(false);
            }
            if (salesFrame.addReservation(reservation)) {
                salesFrame.setFocus();
                return true;
            }
        }
        return false;
    }

    public static String getScreenName(int screen) {
        switch (screen) {
            case 1: {
                return StoreParams.res.getString("Sales");
            }
            case 2: {
                return StoreParams.res.getString("Transfers_Out");
            }
            case 3: {
                return StoreParams.res.getString("Transfers_In");
            }
            case 4: {
                return StoreParams.res.getString("Stock_Enquiry");
            }
            case 5: {
                return StoreParams.res.getString("Stock_Take");
            }
            case 6: {
                return TillBalanceUtils.TillBalanceType.TILL_BALANCE.getDisplayValue();
            }
            case 14: {
                return TillBalanceUtils.TillBalanceType.START_OF_DAY.getDisplayValue();
            }
            case 15: {
                return TillBalanceUtils.TillBalanceType.END_OF_DAY.getDisplayValue();
            }
            case 16: {
                return StoreParams.res.getString("Generate_Manifest");
            }
            case 17: {
                return StoreParams.res.getString("Reprint_Manifest");
            }
            case 7: {
                return StoreParams.res.getString("Withdrawal");
            }
            case 8: {
                return StoreParams.res.getString("Expense");
            }
            case 9: {
                return StoreParams.res.getString("Transfer_Requests");
            }
            case 10: {
                return StoreParams.res.getString("Debtor_Sale");
            }
            case 11: {
                return StoreParams.res.getString("Stock_Reservations");
            }
            case 12: {
                return StoreParams.res.getString("Customer_Orders");
            }
            case 13: {
                return StoreParams.res.getString("Quick_Receipts");
            }
        }
        return "";
    }

    public int getFrameType(int transType, String docketNumber) {
        int nRet = 0;
        switch (transType) {
            case 239: {
                nRet = 1;
                break;
            }
            case 240: {
                nRet = 1;
                break;
            }
            case 242: {
                nRet = 1;
                break;
            }
            case 241: {
                nRet = 1;
                break;
            }
            case 614: {
                nRet = 1;
                break;
            }
            case 556: {
                nRet = 10;
                break;
            }
            case 558: {
                nRet = 10;
                break;
            }
            case 250: {
                nRet = 3;
                break;
            }
            case 691: {
                nRet = 9;
                break;
            }
            case 248: {
                nRet = 3;
                break;
            }
            case 251: {
                nRet = 3;
                break;
            }
            case 249: {
                nRet = 2;
                break;
            }
            case 252: {
                nRet = 2;
                break;
            }
            case 247: {
                nRet = 5;
                break;
            }
            case 564: {
                nRet = TillBalanceUtils.getTillBalanceType(docketNumber).getFrameType();
                break;
            }
            case 546: {
                nRet = 7;
                break;
            }
            case 547: {
                nRet = 8;
                break;
            }
            case 243: {
                nRet = 1;
                break;
            }
            case 245: {
                nRet = 1;
                break;
            }
            case 244: {
                nRet = 1;
                break;
            }
            case 714: {
                nRet = 12;
                break;
            }
            case 715: {
                nRet = 12;
                break;
            }
            default: {
                nRet = 0;
            }
        }
        return nRet;
    }

    private void closeOwnedWindowsRecursively(Window owner) {
        Window[] ownedWindows;
        for (Window window : ownedWindows = owner.getOwnedWindows()) {
            this.closeOwnedWindowsRecursively(window);
            if (window instanceof PersonDlg || !window.isShowing()) continue;
            if (window instanceof PosDialog) {
                ((PosDialog)window).cancelDialog();
                continue;
            }
            window.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timer_actionPerformed(ActionEvent e) {
        this.timerActionFailed = false;
        long now = new Date().getTime();
        for (PosFrame frame : this.frames) {
            if (!frame.isLoggedIn(false) || !SignInSettings.getInstance().isTimeoutEnabled() || SignInSettings.getInstance().getAutoSignOutInactivitySeconds() * 1000L >= now - frame.getLastAction()) continue;
            if (!PosFrame.isTimeoutDisabled(frame)) {
                this.closeOwnedWindowsRecursively(frame);
                frame.paHead.logoff(this.openFrame == frame);
                continue;
            }
            frame.setLastAction();
        }
        try (Connection connection = StoreParams.createNewConnection();){
            if (Settings.autoRestartPosComms()) {
                this.startPosCommsIfNotRunning(connection);
            }
            if (this.sParams.pollInterval != 0.0 && (double)(now - this.lastPollTime) > Math.min(this.sParams.pollInterval * 1000.0, 20000.0)) {
                System.gc();
                this.lastPollTime = now;
                boolean bHO_Error = false;
                boolean displayMismatchMsgOnce = false;
                HeadOfficeError hoError = HeadOfficeError.None;
                try (SqlQuery sql = new SqlQuery(connection, "SELECT LINE_STATUS, COALESCE(HO_ERROR,0) FROM STOREPARAMS");){
                    if (sql.next()) {
                        hoError = HeadOfficeError.getErrorType(sql.getInt(2));
                        this.sParams.misMatchVersion = false;
                        if (hoError != HeadOfficeError.None && hoError != HeadOfficeError.PosVersionGreaterThanHeadOffice) {
                            bHO_Error = true;
                        } else {
                            if (hoError == HeadOfficeError.None) {
                                this.displayMismatchMsg = false;
                            }
                            if (hoError == HeadOfficeError.PosVersionGreaterThanHeadOffice) {
                                this.sParams.misMatchVersion = true;
                            }
                            if (hoError == HeadOfficeError.PosVersionGreaterThanHeadOffice && !this.displayMismatchMsg) {
                                this.displayMismatchMsg = true;
                                displayMismatchMsgOnce = true;
                            }
                            if (PosUtils.booleanVal(sql.getInt(1)) != this.sParams.last_line_status) {
                                this.setStatus(PosUtils.booleanVal(sql.getInt(1)));
                                this.sParams.last_line_status = !this.sParams.last_line_status;
                            }
                        }
                    }
                }
                catch (Exception sqle) {
                    this.timerActionFailed = true;
                    this.timerActionLogError(sqle);
                }
                if (bHO_Error) {
                    DlgMessage.showMessage(this.getOpenFrame(), hoError.getErrorMsg(), StoreParams.res.getString("Error"), 0);
                    this.shutdown();
                } else if (displayMismatchMsgOnce) {
                    DlgMessage.showMessage(this.getOpenFrame(), hoError.getErrorMsg(), StoreParams.res.getString("Warning"), 2);
                }
            }
            this.countOrdersToPack(connection);
        }
        catch (Exception e1) {
            this.timerActionFailed = true;
            this.timerActionLogError(e1);
        }
        finally {
            this.timerActionConsecutiveFailCount = this.timerActionFailed ? ++this.timerActionConsecutiveFailCount : 0;
        }
    }

    private void startPosCommsIfNotRunning(Connection connection) {
        ++this.posCommsTimerCount;
        if (this.posCommsTimerCount > 60) {
            try {
                this.posCommsTimerCount = 0;
                String machine = InetAddress.getLocalHost().getHostName().toUpperCase();
                if (this.posCommsShouldRunOnThisMachine(connection, machine) && !this.isProcessRunning(POSCOMMS_EXE)) {
                    this.cleanupPosCommsRunningInstances(connection);
                    this.startPosCommsProcess();
                }
            }
            catch (UnknownHostException e) {
                this.timerActionFailed = true;
                this.timerActionLogError(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean posCommsShouldRunOnThisMachine(Connection connection, String machine) {
        try (SqlQuery sql = new SqlQuery(connection, "SELECT COMPUTER_NAME FROM RUNNING_INSTANCES RI, POSCOMMS_AUTO_RESTART AR WHERE RI.PROCESS_NAME = " + PosUtils.StringToSqlString(POSCOMMS_PROCESS) + " AND AR.DISABLE = 0 ORDER BY RUNNING DESC , START_TIME DESC");){
            if (!sql.next()) return false;
            if (!sql.getString(1).equalsIgnoreCase(machine)) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.timerActionFailed = true;
            this.timerActionLogError(e);
            return false;
        }
    }

    private void cleanupPosCommsRunningInstances(Connection conn) {
        try {
            String machine = InetAddress.getLocalHost().getHostName().toUpperCase();
            PreparedStatement stmt = conn.prepareStatement("UPDATE RUNNING_INSTANCES SET RUNNING = 0 WHERE PROCESS_NAME = ? AND UPPER(COMPUTER_NAME) = ?");
            stmt.setString(1, POSCOMMS_PROCESS);
            stmt.setString(2, machine);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            this.timerActionFailed = true;
            this.timerActionLogError(e);
        }
    }

    private void timerActionLogError(Exception e) {
        if (this.timerActionConsecutiveFailCount < 10) {
            PosUtils.logError(e);
        } else if (this.timerActionConsecutiveFailCount < 50) {
            PosUtils.logError(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessRunning(String processName) {
        Process p = null;
        BufferedReader input = null;
        BufferedReader errorInput = null;
        try {
            String line;
            String psCommand = String.format("Get-CimInstance -ClassName Win32_Process | Where-Object {$_.Name -eq '%s'} | Select-Object -ExpandProperty ExecutablePath", processName);
            String[] command = new String[]{"powershell.exe", "-NoProfile", "-NonInteractive", "-Command", psCommand};
            p = Runtime.getRuntime().exec(command);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            errorInput = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String currentDir = System.getProperty("user.dir").toLowerCase();
            String expectedPath = currentDir + File.separator + processName.toLowerCase();
            while ((line = input.readLine()) != null) {
                if (line.trim().isEmpty() || !line.toLowerCase().contains(expectedPath)) continue;
                boolean bl = true;
                return bl;
            }
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                String errorLine;
                StringBuilder errorMsg = new StringBuilder();
                while ((errorLine = errorInput.readLine()) != null) {
                    errorMsg.append(errorLine).append("\n");
                }
                if (errorMsg.length() > 0) {
                    PosUtils.logError("PowerShell error checking process: " + errorMsg.toString());
                }
            }
        }
        catch (Exception err) {
            this.timerActionFailed = true;
            this.timerActionLogError(err);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (errorInput != null) {
                    errorInput.close();
                }
                if (p != null) {
                    p.destroy();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public void countOrdersToPack(Connection con) {
        int count = 0;
        int priorityCount = 0;
        Urgency urgency = Urgency.NORMAL;
        try (SqlQuery sql = new SqlQuery(con, "SELECT COUNT(1) AS ORDER_COUNT, MIN(WARNING_UTC_DATE) AS WARNING_UTC_DATE, MIN(CRITICAL_UTC_DATE) AS CRITICAL_UTC_DATE, COUNT(CASE WHEN PRIORITY_FLAG = 1 THEN 1 END) AS PRIORITY_COUNT FROM RETAIL_CUST_ORDERS_OUTSTANDING WHERE DELETE_FLAG = 0");){
            if (sql.next()) {
                Timestamp critical;
                count = sql.getInt("ORDER_COUNT");
                priorityCount = sql.getInt("PRIORITY_COUNT");
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                Timestamp warning = sql.getTimestamp("WARNING_UTC_DATE", calendar);
                if (warning != null && Instant.now().isAfter(warning.toInstant())) {
                    urgency = Urgency.ALERT;
                }
                if ((critical = sql.getTimestamp("CRITICAL_UTC_DATE", calendar)) != null && Instant.now().isAfter(critical.toInstant())) {
                    urgency = Urgency.CRITICAL;
                }
            }
            this.sParams.getOrderCountListener().setOrderCount(count, urgency, priorityCount);
        }
        catch (Exception e) {
            this.timerActionFailed = true;
            this.timerActionLogError(e);
        }
    }

    public void clearTillLocks() {
        try {
            try (Statement stmt = this.sParams.conn.prepareStatement("DELETE FROM TRANS_LOCK WHERE TILL_NUMBER = ?");){
                stmt.setString(1, this.sParams.tillnum.toUpperCase());
                stmt.executeUpdate();
            }
            stmt = this.sParams.conn.createStatement();
            var2_3 = null;
            try {
                stmt.executeUpdate("DELETE FROM TRANS_LOCK WHERE LOCK_DATE < CURRENT_TIMESTAMP - 1");
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var2_3 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }
}

