/*
 * Decompiled with CFR 0.152.
 */
package jpos.Promotions;

import java.text.NumberFormat;
import java.util.Locale;
import jpos.DiscLine;
import jpos.PosUtils;
import jpos.Promotions.DataSetHelper;
import jpos.StyleLine;
import jpos.cardfee.CardFeeUtils;
import jpos.voucher.VoucherUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DetailRecord {
    private String itemID = null;
    private String rowType = null;
    private String parentItemID = null;
    private String idx = null;
    private String quantity = null;
    private String percentage = null;
    private String currentUnitPrice = null;
    private String origUnitPrice = null;
    private String rowState = null;
    private String attachedProidx = null;
    private boolean valid = false;
    private NumberFormat percentFormat = NumberFormat.getInstance(Locale.US);
    private NumberFormat priceFormat = NumberFormat.getInstance(Locale.US);

    public DetailRecord() {
        this.percentFormat.setGroupingUsed(false);
        this.percentFormat.setMaximumFractionDigits(8);
        this.priceFormat.setGroupingUsed(false);
        this.priceFormat.setMaximumFractionDigits(4);
    }

    public DetailRecord(Node defaultNode) {
        this();
        this.loadRecordFromNode(defaultNode);
    }

    public DetailRecord(Object row, int rowID) {
        this();
        this.loadRecordFromRow(row, rowID);
    }

    private void loadRecordFromNode(Node defaultNode) {
        this.valid = true;
        for (Node node = defaultNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            String data;
            if (!(node instanceof Element) || (data = ((Text)node.getFirstChild()).getData()) == null) continue;
            if (node.getNodeName().equals("ITEMID")) {
                this.itemID = data;
                continue;
            }
            if (node.getNodeName().equals("ROWTYPE")) {
                this.rowType = data;
                continue;
            }
            if (node.getNodeName().equals("PARENTITEMID")) {
                this.parentItemID = data;
                continue;
            }
            if (node.getNodeName().equals("IDX")) {
                this.idx = data;
                continue;
            }
            if (node.getNodeName().equals("QUANTITY")) {
                this.quantity = data;
                continue;
            }
            if (node.getNodeName().equals("PERCENTAGE")) {
                this.percentage = data;
                continue;
            }
            if (node.getNodeName().equals("CURRENTUNITPRICE")) {
                this.currentUnitPrice = data;
                continue;
            }
            if (node.getNodeName().equals("ORIGINALUNITPRICE")) {
                this.origUnitPrice = data;
                continue;
            }
            if (node.getNodeName().equals("ROWSTATE")) {
                this.rowState = data;
                continue;
            }
            if (!node.getNodeName().equals("ATTACHEDPROIDX")) continue;
            this.attachedProidx = data;
        }
    }

    private void loadRecordFromRow(Object row, int rowID) {
        this.valid = true;
        this.itemID = String.valueOf(rowID);
        this.parentItemID = null;
        this.quantity = null;
        this.percentage = null;
        this.currentUnitPrice = null;
        this.origUnitPrice = null;
        this.rowState = null;
        this.attachedProidx = null;
        if (row instanceof StyleLine && ((StyleLine)row).isNew() && !VoucherUtils.isVoucher(((StyleLine)row).getSkuidx()) && !CardFeeUtils.isCardFee(((StyleLine)row).getSkuidx())) {
            this.rowType = String.valueOf(0);
            this.idx = String.valueOf(((StyleLine)row).getSkuidx());
            this.quantity = String.valueOf(((StyleLine)row).getQty()).toString();
            this.percentage = "0";
            this.currentUnitPrice = this.priceFormat.format(((StyleLine)row).getPrice());
            this.origUnitPrice = this.priceFormat.format(((StyleLine)row).getOrigPrice());
        } else if (row instanceof DiscLine && ((DiscLine)row).isNew() && ((DiscLine)row).isManualDiscount()) {
            this.rowType = String.valueOf(1);
            this.idx = String.valueOf(((DiscLine)row).getDiscParent().getDiscount().getIdx());
            this.percentage = this.percentFormat.format(((DiscLine)row).getDiscParent().getCurrDiscPer());
        } else if (row instanceof DiscLine && ((DiscLine)row).isNew() && ((DiscLine)row).isCoupon()) {
            this.rowType = String.valueOf(4);
            this.idx = String.valueOf(((DiscLine)row).getDiscParent().getPromotionIdx());
            this.percentage = this.percentFormat.format(((DiscLine)row).getDiscParent().getCurrDiscPer());
        } else if (row instanceof DiscLine && ((DiscLine)row).isNew() && ((DiscLine)row).isPromotion()) {
            this.rowType = String.valueOf(2);
            this.idx = String.valueOf(((DiscLine)row).getDiscParent().getPromotionIdx());
            this.percentage = this.percentFormat.format(((DiscLine)row).getDiscParent().getCurrDiscPer());
        } else if (row instanceof DiscLine && ((DiscLine)row).isNew() && ((DiscLine)row).isLoyalty()) {
            this.rowType = String.valueOf(3);
            this.idx = String.valueOf(((DiscLine)row).getDiscParent().getLoyalty().getIdx());
            this.percentage = this.percentFormat.format(((DiscLine)row).getDiscParent().getCurrDiscPer());
        } else {
            this.valid = false;
        }
    }

    public void addRecordToNode(Node parent) {
        try {
            Node defaultNode = DataSetHelper.addNode(parent, "DEFAULT", null);
            if (this.itemID != null) {
                DataSetHelper.addNode(defaultNode, "ITEMID", this.itemID);
            }
            if (this.rowType != null) {
                DataSetHelper.addNode(defaultNode, "ROWTYPE", this.rowType);
            }
            if (this.parentItemID != null) {
                DataSetHelper.addNode(defaultNode, "PARENTITEMID", this.parentItemID);
            }
            if (this.idx != null) {
                DataSetHelper.addNode(defaultNode, "IDX", this.idx);
            }
            if (this.quantity != null) {
                DataSetHelper.addNode(defaultNode, "QUANTITY", this.quantity);
            }
            if (this.percentage != null) {
                DataSetHelper.addNode(defaultNode, "PERCENTAGE", this.percentage);
            }
            if (this.currentUnitPrice != null) {
                DataSetHelper.addNode(defaultNode, "CURRENTUNITPRICE", this.currentUnitPrice);
            }
            if (this.origUnitPrice != null) {
                DataSetHelper.addNode(defaultNode, "ORIGINALUNITPRICE", this.origUnitPrice);
            }
            if (this.rowState != null) {
                DataSetHelper.addNode(defaultNode, "ROWSTATE", this.rowState);
            }
            if (this.attachedProidx != null) {
                DataSetHelper.addNode(defaultNode, "ATTACHEDPROIDX", this.rowState);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public String getItemID() {
        return this.itemID;
    }

    public String getRowType() {
        return this.rowType;
    }

    public String getParentItemID() {
        return this.parentItemID;
    }

    public String getIdx() {
        return this.idx;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public String getPercentage() {
        return this.percentage;
    }

    public String getCurrentUnitPrice() {
        return this.currentUnitPrice;
    }

    public String getOrigUnitPrice() {
        return this.origUnitPrice;
    }

    public String getRowState() {
        return this.rowState;
    }

    public String getAttachedProidx() {
        return this.attachedProidx;
    }

    public boolean isValid() {
        return this.valid;
    }
}

