/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import jpos.RegexOperation;
import jpos.logging.RollingLog;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class RestRequest {
    public static final String SECRET_STRING = "***HIDDEN***";
    private boolean enforceSSL;
    private HttpEntity postData;
    private RequestConfig config;
    private CloseableHttpClient client;
    private RegexOperation[] logMasks;

    public RestRequest() {
        this.enforceSSL = true;
    }

    public RestRequest(boolean enforceSSL) {
        this.enforceSSL = enforceSSL;
    }

    public void setPostFormEncoded(Map<String, String> data) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (data != null) {
            for (Map.Entry<String, String> param : data.entrySet()) {
                builder.addTextBody(param.getKey(), param.getValue());
            }
        }
        this.postData = builder.build();
    }

    public void setPostJson(Object jsonObj) throws UnsupportedEncodingException {
        Gson gson = new Gson();
        String json = gson.toJson(jsonObj);
        this.postData = new StringEntity(json, ContentType.APPLICATION_JSON);
    }

    public void setPostXml(String xml) {
        this.postData = new StringEntity(xml, ContentType.APPLICATION_XML);
    }

    public void setLogMasks(RegexOperation[] logMasks) {
        this.logMasks = logMasks;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setCustomClient(CloseableHttpClient client) throws IOException {
        if (this.client != null) {
            this.client.close();
        }
        this.client = client;
    }

    public void closeCustomClient() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    public Response get(String baseUrl, Map<String, String> urlParamaters, Map<String, String> headers) throws IOException {
        return this.get(baseUrl, urlParamaters, headers, false);
    }

    public Response get(String baseUrl, Map<String, String> urlParamaters, Map<String, String> headers, boolean secret) throws IOException {
        try {
            String url = RestRequest.generateURL(baseUrl, urlParamaters);
            HttpGet get = new HttpGet(url);
            return this.request((HttpRequestBase)get, headers, secret);
        }
        catch (Exception e) {
            RollingLog.log(RollingLog.LogType.REST_API, e.getMessage(), e);
            throw e;
        }
    }

    public Response post(String baseUrl, Map<String, String> urlParamaters, Map<String, String> headers) throws IOException {
        return this.post(baseUrl, urlParamaters, headers, false);
    }

    public Response post(String baseUrl, Map<String, String> urlParamaters, Map<String, String> headers, boolean secret) throws IOException {
        try {
            String url = RestRequest.generateURL(baseUrl, urlParamaters);
            HttpPost post = new HttpPost(url);
            return this.request((HttpRequestBase)post, headers, secret);
        }
        catch (Exception e) {
            RollingLog.log(RollingLog.LogType.REST_API, e.getMessage(), e);
            throw e;
        }
    }

    public Response request(HttpRequestBase request, Map<String, String> headers) throws IOException {
        return this.request(request, headers, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response request(HttpRequestBase request, Map<String, String> headers, boolean secret) throws IOException {
        CloseableHttpClient httpClient;
        CloseableHttpClient closeableHttpClient = this.client != null ? this.client : (httpClient = this.enforceSSL ? RestRequest.httpClientSetCookieStandard() : RestRequest.httpClientTrustingAllSSLCerts());
        if (this.config != null) {
            request.setConfig(this.config);
        }
        String headerString = this.addHeaders(request, headers);
        RollingLog.log(RollingLog.LogType.REST_API, Level.INFO, MessageFormat.format("Request: {0}{1}{2}", request.toString(), headerString.isEmpty() ? "" : "\r\n", headerString));
        if (request.getMethod() == "POST" && this.postData != null) {
            ((HttpPost)request).setEntity(this.postData);
            RollingLog.log(RollingLog.LogType.REST_API, Level.INFO, "Request Body: " + (secret ? SECRET_STRING : RestRequest.cleanLogText(RestRequest.convertStreamToString(this.postData.getContent(), Charset.defaultCharset()), this.logMasks)));
        }
        try {
            Response response = RestRequest.simpleRequest(request, httpClient, secret);
            return response;
        }
        finally {
            if (this.client == null) {
                httpClient.close();
            }
            this.postData = null;
        }
    }

    public static String generateURL(String url, Map<String, String> urlParamaters) {
        StringBuilder urlQuery = RestRequest.deserialiseDictionaryQuery(urlParamaters);
        return url + urlQuery;
    }

    public static Response simpleRequest(HttpRequestBase request, CloseableHttpClient httpClient) throws IOException {
        return RestRequest.simpleRequest(request, httpClient, false);
    }

    public static Response simpleRequest(HttpRequestBase request, CloseableHttpClient httpClient, boolean secret) throws IOException {
        return RestRequest.simpleRequest(request, httpClient, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response simpleRequest(HttpRequestBase request, CloseableHttpClient httpClient, boolean secret, RegexOperation[] logMasks) throws IOException {
        Response result = new Response();
        Charset charset = null;
        Header[] headers = request.getHeaders("Accept-Charset");
        for (int i = 0; i < headers.length; ++i) {
            try {
                charset = Charset.forName(headers[i].getValue());
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            result.StatusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            result.Content = entity != null ? RestRequest.convertStreamToString(entity.getContent(), charset) : "";
            RollingLog.log(RollingLog.LogType.REST_API, Level.INFO, "Response Status Code: " + result.StatusCode + "\nResult String: " + (secret ? SECRET_STRING : RestRequest.cleanLogText(result.Content, logMasks)));
            RollingLog.log(RollingLog.LogType.REST_API, Level.INFO, "Response: " + RestRequest.cleanLogText(response.toString(), logMasks));
        }
        return result;
    }

    private static String convertStreamToString(InputStream inputStream, Charset charset) {
        StringBuffer response = new StringBuffer();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, charset));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
        }
        catch (IOException e) {
            RollingLog.log(RollingLog.LogType.REST_API, e.getMessage(), e);
        }
        return response.toString();
    }

    private static String cleanLogText(String content, RegexOperation[] logMasks) {
        if (logMasks != null) {
            for (RegexOperation regexOperation : logMasks) {
                content = regexOperation.replace(content);
            }
        }
        return content;
    }

    private static StringBuilder deserialiseDictionaryQuery(Map<String, String> dict) {
        StringBuilder request = new StringBuilder();
        if (dict == null) {
            return request;
        }
        for (Map.Entry<String, String> param : dict.entrySet()) {
            if (request.length() != 0) {
                request.append('&');
            } else {
                request.append('?');
            }
            try {
                request.append(URLEncoder.encode(param.getKey() != null ? param.getKey() : "", "UTF-8"));
                request.append('=');
                request.append(URLEncoder.encode(param.getValue() != null ? param.getValue() : "", "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                RollingLog.log(RollingLog.LogType.REST_API, e.getMessage(), e);
            }
        }
        return request;
    }

    private static CloseableHttpClient httpClientTrustingAllSSLCerts() {
        return HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).build();
    }

    private static CloseableHttpClient httpClientSetCookieStandard() {
        return HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).build();
    }

    private String addHeaders(HttpRequestBase request, Map<String, String> headers) {
        if (headers == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> param : headers.entrySet()) {
            request.addHeader(param.getKey(), param.getValue());
            if (builder.length() > 0) {
                builder.append("\r\n");
            }
            builder.append(param.getKey());
            builder.append(": ");
            builder.append(param.getKey().toUpperCase().contains("AUTHORIZATION") ? SECRET_STRING : param.getValue());
        }
        return builder.toString();
    }

    public static String formatBaseURL(String baseUrl) {
        if (baseUrl != null && baseUrl.length() > 1 && baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    public static class Response {
        public int StatusCode;
        public String Content;

        public boolean isSuccess() {
            return this.StatusCode >= 200 && this.StatusCode <= 299;
        }
    }
}

