/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.Connection;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import jpos.ErrorHandler;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.XMLUtils;
import jpos.basscom.utils.Utils;
import jpos.pay.eftpos.EftposUtils;
import jpos.person.Country;
import org.jdom.Element;

public class Settings {
    private static int startupScreen = 1;
    private static ErrorHandler.ErrorLogging errorLogging = ErrorHandler.ErrorLogging.ScreenAndFile;
    private static String screenImage = "Logo.jpg";
    private static String docketImage = "ReceiptLogo.jpg";
    private static String labelLogoImage = "LabelLogo.pcx";
    private static Country country = new Country();
    private static boolean postcodeMandatory = false;
    private static boolean stateValidation = false;
    private static Vector<String> enabledScreens = new Vector();
    private static EftposUtils.EftposDebugMode eftposDebugMode = EftposUtils.EftposDebugMode.OFF;
    private static Level taxLookupLogLevel = Level.SEVERE;
    private static int eftposPaymentDelay = 1500;
    private static boolean onlineQueryWriteToDisk = false;
    private static boolean checkPrinterStatus = false;
    private static String storeNumber;
    private static boolean browserDebugger;
    private static int reactAppPort;
    private static ResourceBundle settings;
    private static boolean injectException;
    private static int afterpayOrderTimeout;
    private static boolean blindReceipt;
    private static boolean forceScanInStockReceipt;
    private static boolean forceScanInTransferOut;
    private static boolean stockReceiptByCarton;
    private static boolean hasSettingForReceiptForceScan;
    private static boolean hasSettingForTransferOutForceScan;
    private static boolean hasSettingForReceiptByCarton;
    private static Boolean doPersonSearchOnline;
    private static int personSearchMaxRows;
    private static boolean legacyPersonMaintenance;
    private static boolean autoRestartPosComms;
    private static boolean logCapillaryPayloads;
    private static boolean usingAusPost;

    public static String getStoreNo() {
        return storeNumber;
    }

    private static String getResourceString(String key) throws Exception {
        if (settings.containsKey(key + "_" + storeNumber)) {
            return settings.getString(key + "_" + storeNumber);
        }
        if (settings.containsKey(key)) {
            return settings.getString(key);
        }
        throw new Exception("Key " + key + " not found");
    }

    public static int getStartupScreen() {
        return startupScreen;
    }

    private static String getStoreNumber() {
        String result = "";
        try (Connection con = StoreParams.createNewConnection();
             SqlQuery sql = new SqlQuery(con, "SELECT STORENO FROM STOREPARAMS");){
            if (sql.next()) {
                result = sql.getString(1);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return result;
    }

    public static ErrorHandler.ErrorLogging getErrorLogging() {
        return errorLogging;
    }

    public static String getScreenImage() {
        return screenImage;
    }

    public static String getDocketImage() {
        return docketImage;
    }

    public static String getLabelLogoImage() {
        return labelLogoImage;
    }

    public static Country getCountry() {
        return country;
    }

    public static boolean isPostcodeMandatory() {
        return postcodeMandatory;
    }

    public static boolean isStateValidation() {
        return stateValidation;
    }

    public static EftposUtils.EftposDebugMode getEftposDebugMode() {
        return eftposDebugMode;
    }

    public static Level getTaxLookupLogLevel() {
        return taxLookupLogLevel;
    }

    public static boolean isScreenEnabled(int screen) {
        if (enabledScreens.size() == 0 || screen == startupScreen) {
            return true;
        }
        for (int i = 0; i < enabledScreens.size(); ++i) {
            if (!enabledScreens.elementAt(i).equals(String.valueOf(screen))) continue;
            return true;
        }
        return false;
    }

    public static int getEftposPaymentDelay() {
        return eftposPaymentDelay;
    }

    public static boolean isOnlineQueryWriteToDisk() {
        return onlineQueryWriteToDisk;
    }

    public static boolean useCheckPrinterStatus() {
        return checkPrinterStatus;
    }

    public static boolean showBrowserDebugger() {
        return browserDebugger;
    }

    public static boolean useLegacyPersonMaintenance() {
        return legacyPersonMaintenance;
    }

    public static int getReactAppPort() {
        return reactAppPort;
    }

    public static boolean needInjectException() {
        return injectException;
    }

    public static int getAfterpayOrderTimeout() {
        return afterpayOrderTimeout <= 0 ? 70000 : afterpayOrderTimeout;
    }

    public static boolean getBlindReceipt() {
        return blindReceipt;
    }

    public static boolean isForceScanInStockReceipt() {
        return forceScanInStockReceipt;
    }

    public static boolean isForceScanInTransferOut() {
        return forceScanInTransferOut;
    }

    public static boolean isStockReceiptByCarton() {
        return stockReceiptByCarton;
    }

    public static boolean hasSettingForReceiptForceScan() {
        return hasSettingForReceiptForceScan;
    }

    public static boolean hasSettingForTransferOutForceScan() {
        return hasSettingForTransferOutForceScan;
    }

    public static boolean hasSettingForReceiptByCarton() {
        return hasSettingForReceiptByCarton;
    }

    public static Boolean isPersonSearchOnline() {
        return doPersonSearchOnline;
    }

    public static int getPersonSearchMaxRows() {
        return personSearchMaxRows;
    }

    public static boolean autoRestartPosComms() {
        return autoRestartPosComms;
    }

    public static boolean isLogCapillaryPayloads() {
        return logCapillaryPayloads;
    }

    public static boolean isUsingAusPostIntegration() {
        return usingAusPost;
    }

    static {
        browserDebugger = false;
        reactAppPort = 0;
        injectException = false;
        afterpayOrderTimeout = 0;
        blindReceipt = false;
        forceScanInStockReceipt = false;
        forceScanInTransferOut = false;
        stockReceiptByCarton = false;
        hasSettingForReceiptForceScan = false;
        hasSettingForTransferOutForceScan = false;
        hasSettingForReceiptByCarton = false;
        doPersonSearchOnline = null;
        personSearchMaxRows = 0;
        legacyPersonMaintenance = false;
        autoRestartPosComms = true;
        logCapillaryPayloads = false;
        usingAusPost = false;
        try {
            storeNumber = SP.sParams != null ? SP.sParams.getStore().getStoreNo() : Settings.getStoreNumber();
            settings = ResourceBundle.getBundle("settings");
            try {
                startupScreen = Integer.parseInt(Settings.getResourceString("startup_screen"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String screens = null;
                try {
                    screens = Settings.getResourceString("enable_screens");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (screens != null && screens.length() > 0) {
                    Utils.stringTokenize(screens, ",", enabledScreens);
                }
            }
            catch (Exception screens) {
                // empty catch block
            }
            try {
                screenImage = Settings.getResourceString("screen_image");
            }
            catch (Exception screens) {
                // empty catch block
            }
            try {
                docketImage = Settings.getResourceString("docket_image");
            }
            catch (Exception screens) {
                // empty catch block
            }
            try {
                labelLogoImage = Settings.getResourceString("label_image_" + storeNumber);
            }
            catch (Exception screens) {
                // empty catch block
            }
            try (Connection con = StoreParams.createNewConnection();){
                country = new Country(Settings.getResourceString("country"), con);
            }
            catch (Exception e) {
                try (Connection con22 = StoreParams.createNewConnection();){
                    country = new Country(Locale.getDefault().getCountry(), con22);
                }
                catch (Exception con22) {
                    // empty catch block
                }
            }
            try {
                postcodeMandatory = Boolean.parseBoolean(Settings.getResourceString("force_pcode"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                stateValidation = Boolean.parseBoolean(Settings.getResourceString("check_state"));
            }
            catch (Exception e) {
                // empty catch block
            }
            int eftposDebug = 0;
            try {
                eftposDebug = Integer.parseInt(Settings.getResourceString("eftpos_debug_mode"));
            }
            catch (Exception con22) {
                // empty catch block
            }
            switch (eftposDebug) {
                case 1: {
                    eftposDebugMode = EftposUtils.EftposDebugMode.SCREEN_ONLY;
                    break;
                }
                case 2: {
                    eftposDebugMode = EftposUtils.EftposDebugMode.FILE_ONLY;
                    break;
                }
                case 3: {
                    eftposDebugMode = EftposUtils.EftposDebugMode.FILE_AND_SCREEN;
                    break;
                }
                default: {
                    eftposDebugMode = EftposUtils.EftposDebugMode.OFF;
                }
            }
            int taxLookupDebug = 1;
            try {
                taxLookupDebug = Integer.parseInt(Settings.getResourceString("tax_lookup_log_level"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (taxLookupDebug) {
                case 0: {
                    taxLookupLogLevel = Level.OFF;
                    break;
                }
                case 1: {
                    taxLookupLogLevel = Level.SEVERE;
                    break;
                }
                case 2: {
                    taxLookupLogLevel = Level.INFO;
                    break;
                }
                default: {
                    taxLookupLogLevel = Level.SEVERE;
                }
            }
            int logging = 1;
            try {
                logging = Integer.parseInt(Settings.getResourceString("error_logging"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (logging) {
                case 1: {
                    errorLogging = ErrorHandler.ErrorLogging.ScreenAndFile;
                    break;
                }
                case 2: {
                    errorLogging = ErrorHandler.ErrorLogging.FileOnly;
                    break;
                }
                case 3: {
                    errorLogging = ErrorHandler.ErrorLogging.NoLogging;
                    break;
                }
                default: {
                    errorLogging = ErrorHandler.ErrorLogging.ScreenAndFile;
                }
            }
            try {
                int delay = Integer.parseInt(Settings.getResourceString("eftpos_payment_delay"));
                if (delay >= 0) {
                    eftposPaymentDelay = delay;
                }
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                onlineQueryWriteToDisk = Boolean.parseBoolean(Settings.getResourceString("online_query_write_to_disk"));
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                checkPrinterStatus = Boolean.parseBoolean(Settings.getResourceString("check_printer_status"));
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                legacyPersonMaintenance = Boolean.parseBoolean(Settings.getResourceString("use_legacy_person_maintenance"));
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                browserDebugger = Boolean.parseBoolean(Settings.getResourceString("browser_debugger"));
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                reactAppPort = Integer.parseInt(Settings.getResourceString("react_app_port"));
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                injectException = Boolean.parseBoolean(Settings.getResourceString("inject_exception"));
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                afterpayOrderTimeout = 1000 * PosUtils.intVal(Settings.getResourceString("afterpay_order_timeout"));
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                blindReceipt = PosUtils.booleanVal(Settings.getResourceString("blind_receipt"));
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                forceScanInStockReceipt = PosUtils.booleanVal(Settings.getResourceString("receipt_force_scan"));
                hasSettingForReceiptForceScan = true;
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                forceScanInTransferOut = PosUtils.booleanVal(Settings.getResourceString("transfer_out_force_scan"));
                hasSettingForTransferOutForceScan = true;
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                stockReceiptByCarton = PosUtils.booleanVal(Settings.getResourceString("stock_receipt_by_carton"));
                hasSettingForReceiptByCarton = true;
            }
            catch (Exception delay) {
                // empty catch block
            }
            try {
                doPersonSearchOnline = PosUtils.booleanVal(Settings.getResourceString("person_search_online"));
            }
            catch (Exception e) {
                doPersonSearchOnline = null;
            }
            try {
                personSearchMaxRows = PosUtils.intVal(Settings.getResourceString("person_search_max_rows"));
            }
            catch (Exception e) {
                personSearchMaxRows = 0;
            }
            try {
                autoRestartPosComms = Boolean.parseBoolean(Settings.getResourceString("auto_restart_poscomms"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                logCapillaryPayloads = Boolean.parseBoolean(Settings.getResourceString("capillary_json_payload_write_to_log_file"));
            }
            catch (Exception exception) {}
        }
        catch (Exception eftposDebug) {
            // empty catch block
        }
        try {
            Element auspost = SP.sParams.OnlineQueryProvider.getOnlineQuery("aps_using_auspost", "").getXML();
            if (auspost != null) {
                boolean value;
                usingAusPost = value = XMLUtils.getBooleanValue(auspost, "usingAusPost");
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }
}

