/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.SQLException;
import java.util.Vector;
import jpos.Clr;
import jpos.PosDouble;
import jpos.PosUtils;
import jpos.Sku;
import jpos.SqlQuery;
import jpos.StoreParams;

public class Style {
    static final int STYLE = 1;
    static final int CLR = 2;
    static final int SKU = 3;
    long idx;
    String code;
    String name;
    int stkFlag = 1;
    double taxPer = 0.0;
    double disc = 0.0;
    Vector<Clr> clrs = new Vector();
    Vector<String> sizes = new Vector(30);
    Vector<PosDouble> sizeSeqs = new Vector(30);
    StoreParams sParams;

    public Style(StoreParams psParams) {
        this.sParams = psParams;
    }

    public Style(long skuidx, double qty, int type, StoreParams psParams) {
        this.sParams = psParams;
        String where = "";
        if (type == 1) {
            where = "S.STYLEIDX = (SELECT CLR.STYLEIDX FROM CLR, SKU WHERE CLR.CLRIDX = SKU.CLRIDX AND SKU.SKUIDX=" + skuidx + ")";
        } else if (type == 2) {
            where = "C.CLRIDX = (SELECT SKU.CLRIDX FROM SKU WHERE SKU.SKUIDX=" + skuidx + ")";
        } else if (type == 3) {
            where = "K.SKUIDX=" + skuidx;
        }
        this.addSkus(where);
        Sku sku = this.getSku(skuidx);
        if (sku != null) {
            sku.setQty(qty);
            sku.setQty(1, qty);
        }
    }

    public Style(String barcode, double qty, int type, StoreParams psParams) {
        this.sParams = psParams;
        String where = "";
        if (type == 1) {
            where = "S.STYLEIDX = (SELECT C.STYLEIDX FROM CLR C, SKU K, BARCODE B WHERE C.CLRIDX = K.CLRIDX AND K.SKUIDX = B.SKUIDX AND B.CODE=" + PosUtils.StringToSqlString(barcode) + ")";
        } else if (type == 2) {
            where = "C.CLRIDX = (SELECT K.CLRIDX FROM SKU K, BARCODE B WHERE K.SKUIDX = B.SKUIDX AND B.CODE = " + PosUtils.StringToSqlString(barcode) + ")";
        } else if (type == 3) {
            where = "K.SKUIDX = (SELECT B.SKUIDX FROM BARCODE B WHERE B.CODE = " + PosUtils.StringToSqlString(barcode) + ")";
        }
        this.addSkus(where);
        Sku sku = this.getSku(barcode);
        if (sku != null) {
            sku.setQty(qty);
        }
    }

    private void addSkus(String where) {
        Clr clr = null;
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT S.STYLEIDX, COALESCE(S.STYLECODE, ''), COALESCE(S.NAME, ''), C.CLRIDX,  COALESCE(C.CLRCODE, ''), K.SKUIDX, COALESCE(K.SIZEVAL, ''), K.PRICE, COALESCE(C.CLRNAME, ''),  S.TAXPER, COALESCE(DB.CODE, ''), S.STKFLAG, K.SIZESEQ, S.EXT_TAXRATE FROM STYLE S, CLR C, SKU K, DEFAULT_BARCODE DB WHERE " + where + " AND DB.SKUIDX = K.SKUIDX AND K.CLRIDX=C.CLRIDX AND C.STYLEIDX=S.STYLEIDX ORDER BY C.CLRCODE, K.SIZESEQ");){
            while (sql.next()) {
                if (sql.getRow() == 1) {
                    this.idx = sql.getLong(1);
                    this.code = sql.getString(2);
                    this.name = sql.getString(3);
                    this.taxPer = sql.getDouble(10);
                    this.stkFlag = sql.getInt(12);
                    clr = new Clr(this, sql.getLong(4), sql.getString(5), sql.getString(9));
                    this.clrs.add(clr);
                } else if (this.clrs.elementAt((int)(this.clrs.size() - 1)).idx != sql.getLong(4)) {
                    clr = new Clr(this, sql.getLong(4), sql.getString(5), sql.getString(9));
                    this.clrs.add(clr);
                }
                Sku sku = new Sku(clr, sql.getLong(6), sql.getString(11), 0.0, sql.getDouble(13));
                String sizeVal = sql.getString(7);
                if (sql.getString(13) == null) {
                    sizeVal = StoreParams.res.getString("Each");
                }
                clr.addSku(sku, sizeVal);
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public boolean hasEAN(String EAN) {
        for (int i = 0; i < this.clrs.size(); ++i) {
            if (this.clrs.elementAt(i).getSku(EAN) == null) continue;
            return true;
        }
        return false;
    }

    public Sku getSku(String EAN) {
        for (int i = 0; i < this.clrs.size(); ++i) {
            Sku sku = this.clrs.elementAt(i).getSku(EAN);
            if (sku == null) continue;
            return sku;
        }
        return null;
    }

    public Sku getSku(long skuidx) {
        for (int i = 0; i < this.clrs.size(); ++i) {
            Sku sku = this.clrs.elementAt(i).getSku(skuidx);
            if (sku == null) continue;
            return sku;
        }
        return null;
    }

    public double getTotQty() {
        double totQty = 0.0;
        for (int i = 0; i < this.clrs.size(); ++i) {
            totQty += this.clrs.elementAt(i).getTotQty();
        }
        return totQty;
    }

    public void addClr(Clr clr) {
        int i;
        for (i = 0; i < this.clrs.size(); ++i) {
            if (this.clrs.elementAt((int)i).code.compareTo(clr.code) <= 0) continue;
            this.clrs.add(i, clr);
            break;
        }
        if (i == this.clrs.size()) {
            this.clrs.add(clr);
        }
        clr.style = this;
    }
}

