/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jpos.DiscLine;
import jpos.Discount;
import jpos.DlgList;
import jpos.DlgMessage;
import jpos.DlgNotes;
import jpos.FrSales;
import jpos.IActionDetailLogWriter;
import jpos.LinkedReturn;
import jpos.MultiLineDisc;
import jpos.Note;
import jpos.NoteType;
import jpos.PosDialog;
import jpos.PosDouble;
import jpos.PosFrame;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.Promotions.PromotionUtils;
import jpos.Reference;
import jpos.SP;
import jpos.SalesRep;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.StyleTableModel;
import jpos.SystemSettings;
import jpos.TransTypes;
import jpos.XMLUtils;
import jpos.cardfee.CardFee;
import jpos.cardfee.CardFeeUtils;
import jpos.rewards.Gift;
import jpos.rewards.RewardsUtils;
import jpos.searchfields.HintTextField;
import jpos.taxlookup.ITaxLookup;
import jpos.taxlookup.TaxLookupDeliveryInfo;
import jpos.taxlookup.TaxLookupFactory;
import jpos.taxlookup.TaxLookupPerson;
import jpos.ui.Colours;
import jpos.voucher.BaseVoucher;
import jpos.voucher.DlgPhysicalDigital;
import jpos.voucher.DlgVoucherIssue;
import jpos.voucher.IVoucherGateway;
import jpos.voucher.Voucher;
import jpos.voucher.VoucherGatewayManager;
import jpos.voucher.VoucherIssueAdapter;
import jpos.voucher.VoucherUtils;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class StyleTable
extends PosTable {
    private static final int MIN_WIDTH_QTY = 70;
    private static final int PREF_WIDTH_QTY = 90;
    private static final int MAX_WIDTH_QTY = 130;
    private static final int MIN_WIDTH_RET_QTY = 130;
    private static final int PREF_WIDTH_RET_QTY = 140;
    private static final int MAX_WIDTH_RET_QTY = 150;
    private static final int MIN_WIDTH_CURR = 70;
    private static final int PREF_WIDTH_CURR = 90;
    private static final int MAX_WIDTH_CURR = 150;
    private static final int PRICE_WIDTH_AFTER_REMOVING_TAX = 110;
    private Vector<MultiLineDisc> discs = new Vector();
    public StyleTableModel model;
    private HintTextField searchField;
    private DefaultCellEditor searchEd;
    protected PosFrame frParent;
    private boolean taxRemoved = false;
    private boolean loadedFromHO = false;
    private Vector<NoteType> styleNoteTypes = new Vector();
    private Vector<NoteType> detailNoteTypes = new Vector();
    private int lockUpdate = 0;
    private double priceVii = 0.0;

    public int beginUpdate() {
        return this.lockUpdate++;
    }

    public int endUpdate() {
        if (this.lockUpdate == 0) {
            PosUtils.logError(new Exception("StyleTable: Update count below 0"));
            this.lockUpdate = 1;
        }
        if (this.lockUpdate == 1) {
            FrSales frSales;
            if (this.frParent instanceof FrSales && (frSales = (FrSales)this.frParent).shouldReturnRewards()) {
                double rewardsReturned = this.getReturnedRewardsTotal();
                frSales.attachedLoyaltyCards.setRewardsReturnAmount(Math.max(rewardsReturned, 0.0));
            }
            this.processPromotions();
            this.externalTaxLookup(false);
        }
        return this.lockUpdate--;
    }

    public StyleTable(PosFrame pFrame, StyleTableModel pmodel) {
        super(pFrame, pmodel);
        this.frParent = (PosFrame)this.getParentWindow();
        try {
            this.jbInit(pmodel);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit(StyleTableModel pmodel) throws Exception {
        this.searchField = new HintTextField(SP.getRS("Search_F12"));
        this.searchField.setCache(this.sParams.cacher, 701L, "", "", "AND (W.\"TYPE\" = 'W' OR W.WIDX = " + this.sParams.getStoreIdx() + ") ", false);
        this.searchField.setSearchKey(123);
        this.searchField.setShowSearchForOneResult(true);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StyleTable.this.RefreshImage();
            }
        });
        this.searchEd = new DefaultCellEditor(this.searchField);
        this.searchEd.setClickCountToStart(1);
        this.setDefaultEditor(String.class, this.searchEd);
        NoteType.readNoteTypes(this.styleNoteTypes, 99L, 0L, this.sParams);
        NoteType.readNoteTypes(this.detailNoteTypes, 315L, 0L, this.sParams);
        this.model = pmodel;
        if (this.model == null) {
            this.model = new StyleTableModel(this.frParent, this.sParams);
        }
        this.setModel(this.model);
        this.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                try {
                    StyleTable.this.beginUpdate();
                    StyleTable.this.checkUpdate(e);
                }
                finally {
                    StyleTable.this.endUpdate();
                }
            }
        });
        switch (this.frParent.frameType) {
            case 1: {
                this.columnModel.getColumn(0).setPreferredWidth(200);
                this.columnModel.getColumn(0).setMinWidth(95);
                this.columnModel.getColumn(0).setMaxWidth(300);
                this.columnModel.getColumn(1).setPreferredWidth(400);
                this.columnModel.getColumn(1).setMinWidth(130);
                this.columnModel.getColumn(1).setMaxWidth(700);
                this.columnModel.getColumn(2).setPreferredWidth(200);
                this.columnModel.getColumn(2).setMinWidth(75);
                this.columnModel.getColumn(2).setMaxWidth(400);
                this.columnModel.getColumn(3).setPreferredWidth(200);
                this.columnModel.getColumn(3).setMinWidth(75);
                this.columnModel.getColumn(3).setMaxWidth(200);
                this.setQtyColumnWidth(4);
                this.setCurrencyColumnWidth(7);
                this.showOrHideRefundQtyColumns();
                this.showOrHideExtendedTaxColumns();
                this.setCurrencyColumnWidth(10);
                this.setCurrencyColumnWidth(11);
                this.columnModel.getColumn(1).setCellEditor(this.stringEd);
                this.columnModel.getColumn(4).setCellEditor(this.qtyEd);
                this.columnModel.getColumn(7).setCellEditor(this.currEd);
                this.columnModel.getColumn(8).setCellEditor(this.extendedTaxEd);
                this.columnModel.getColumn(9).setCellEditor(this.currEd);
                this.columnModel.getColumn(12).setCellEditor(this.searchEd);
                this.columnModel.getColumn(13).setCellEditor(this.currEd);
                this.columnModel.getColumn(0).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(1).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(2).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(3).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(4).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(6).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(5).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(7).setHeaderRenderer(this.headerRightRen);
                this.columnModel.getColumn(8).setHeaderRenderer(this.headerRightRen);
                this.columnModel.getColumn(9).setHeaderRenderer(this.headerRightRen);
                this.columnModel.getColumn(10).setHeaderRenderer(this.headerRightRen);
                this.columnModel.getColumn(11).setHeaderRenderer(this.headerRightRen);
                this.columnModel.getColumn(12).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(13).setHeaderRenderer(this.headerRightRen);
                this.showCostCol(false);
                this.showDelToCol(false);
                this.renderer.setColumnFormat(3, null, 0);
                this.renderer.setColumnFormat(4, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(6, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(5, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(7, this.sParams.currFormat, 4);
                this.renderer.setColumnFormat(8, StoreParams.extendedTaxFormat, 4);
                this.renderer.setColumnFormat(9, this.sParams.currFormat, 4);
                this.renderer.setColumnFormat(10, this.sParams.currFormat, 4);
                this.renderer.setColumnFormat(11, this.sParams.currFormat, 4);
                this.renderer.setColumnFormat(13, this.sParams.currFormat, 4);
                break;
            }
            case 10: {
                this.columnModel.getColumn(0).setPreferredWidth(200);
                this.columnModel.getColumn(0).setMinWidth(95);
                this.columnModel.getColumn(0).setMaxWidth(300);
                this.columnModel.getColumn(1).setPreferredWidth(400);
                this.columnModel.getColumn(1).setMinWidth(130);
                this.columnModel.getColumn(1).setMaxWidth(700);
                this.columnModel.getColumn(2).setPreferredWidth(200);
                this.columnModel.getColumn(2).setMinWidth(75);
                this.columnModel.getColumn(2).setMaxWidth(400);
                this.columnModel.getColumn(3).setPreferredWidth(200);
                this.columnModel.getColumn(3).setMinWidth(75);
                this.columnModel.getColumn(3).setMaxWidth(200);
                this.setQtyColumnWidth(4);
                this.setCurrencyColumnWidth(5);
                this.setCurrencyColumnWidth(6);
                this.setCurrencyColumnWidth(7);
                this.columnModel.getColumn(1).setCellEditor(this.stringEd);
                this.columnModel.getColumn(4).setCellEditor(this.qtyEd);
                this.columnModel.getColumn(5).setCellEditor(this.currEd);
                this.columnModel.getColumn(0).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(1).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(2).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(3).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(4).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(5).setHeaderRenderer(this.headerRightRen);
                this.columnModel.getColumn(6).setHeaderRenderer(this.headerRightRen);
                this.columnModel.getColumn(7).setHeaderRenderer(this.headerRightRen);
                this.renderer.setColumnFormat(3, null, 0);
                this.renderer.setColumnFormat(4, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(5, this.sParams.currFormat, 4);
                this.renderer.setColumnFormat(6, this.sParams.currFormat, 4);
                this.renderer.setColumnFormat(7, this.sParams.currFormat, 4);
                break;
            }
            case 12: {
                this.columnModel.getColumn(0).setPreferredWidth(200);
                this.columnModel.getColumn(0).setMinWidth(95);
                this.columnModel.getColumn(0).setMaxWidth(300);
                this.columnModel.getColumn(1).setPreferredWidth(400);
                this.columnModel.getColumn(1).setMinWidth(130);
                this.columnModel.getColumn(1).setMaxWidth(700);
                this.columnModel.getColumn(2).setPreferredWidth(200);
                this.columnModel.getColumn(2).setMinWidth(75);
                this.columnModel.getColumn(2).setMaxWidth(400);
                this.columnModel.getColumn(3).setPreferredWidth(200);
                this.columnModel.getColumn(3).setMinWidth(75);
                this.columnModel.getColumn(3).setMaxWidth(200);
                this.setQtyColumnWidth(4);
                this.setQtyColumnWidth(6);
                this.setQtyColumnWidth(7);
                this.showPickupCol(false);
                this.setCurrencyColumnWidth(9);
                this.showOrHideRefundQtyColumns();
                this.showOrHideExtendedTaxColumns();
                this.setCurrencyColumnWidth(12);
                this.setCurrencyColumnWidth(13);
                this.columnModel.getColumn(1).setCellEditor(this.stringEd);
                this.columnModel.getColumn(4).setCellEditor(this.qtyEd);
                this.columnModel.getColumn(6).setCellEditor(this.qtyEd);
                this.columnModel.getColumn(7).setCellEditor(this.qtyEd);
                this.columnModel.getColumn(8).setCellEditor(this.qtyEd);
                this.columnModel.getColumn(9).setCellEditor(this.currEd);
                this.columnModel.getColumn(10).setCellEditor(this.extendedTaxEd);
                this.columnModel.getColumn(11).setCellEditor(this.currEd);
                this.columnModel.getColumn(0).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(1).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(2).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(3).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(5).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(6).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(7).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(8).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(9).setHeaderRenderer(this.headerRightRen);
                this.columnModel.getColumn(10).setHeaderRenderer(this.headerRightRen);
                this.columnModel.getColumn(11).setHeaderRenderer(this.headerRightRen);
                this.columnModel.getColumn(12).setHeaderRenderer(this.headerRightRen);
                this.columnModel.getColumn(13).setHeaderRenderer(this.headerRightRen);
                this.renderer.setColumnFormat(3, null, 0);
                this.renderer.setColumnFormat(4, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(6, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(7, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(8, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(5, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(9, this.sParams.currFormat, 4);
                this.renderer.setColumnFormat(10, StoreParams.extendedTaxFormat, 4);
                this.renderer.setColumnFormat(11, this.sParams.currFormat, 4);
                this.renderer.setColumnFormat(12, this.sParams.currFormat, 4);
                this.renderer.setColumnFormat(13, this.sParams.currFormat, 4);
                break;
            }
            case 3: {
                this.columnModel.getColumn(0).setPreferredWidth(200);
                this.columnModel.getColumn(0).setMinWidth(95);
                this.columnModel.getColumn(0).setMaxWidth(300);
                this.columnModel.getColumn(1).setPreferredWidth(400);
                this.columnModel.getColumn(1).setMinWidth(130);
                this.columnModel.getColumn(1).setMaxWidth(700);
                this.columnModel.getColumn(2).setPreferredWidth(200);
                this.columnModel.getColumn(2).setMinWidth(75);
                this.columnModel.getColumn(2).setMaxWidth(400);
                this.columnModel.getColumn(3).setPreferredWidth(200);
                this.columnModel.getColumn(3).setMinWidth(75);
                this.columnModel.getColumn(3).setMaxWidth(200);
                this.setQtyColumnWidth(4);
                this.setQtyColumnWidth(5);
                this.setQtyColumnWidth(6);
                this.columnModel.getColumn(1).setCellEditor(this.stringEd);
                this.columnModel.getColumn(6).setCellEditor(this.qtyEd);
                this.columnModel.getColumn(0).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(1).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(2).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(3).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(4).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(5).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(6).setHeaderRenderer(this.headerCenterRen);
                this.renderer.setPrintZero(true);
                this.renderer.setColumnFormat(3, null, 0);
                this.renderer.setColumnFormat(4, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(5, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(6, StoreParams.qtyFormat, 0);
                break;
            }
            case 2: {
                this.columnModel.getColumn(0).setPreferredWidth(200);
                this.columnModel.getColumn(0).setMinWidth(95);
                this.columnModel.getColumn(0).setMaxWidth(300);
                this.columnModel.getColumn(1).setPreferredWidth(400);
                this.columnModel.getColumn(1).setMinWidth(130);
                this.columnModel.getColumn(1).setMaxWidth(700);
                this.columnModel.getColumn(2).setPreferredWidth(200);
                this.columnModel.getColumn(2).setMinWidth(75);
                this.columnModel.getColumn(2).setMaxWidth(400);
                this.columnModel.getColumn(3).setPreferredWidth(200);
                this.columnModel.getColumn(3).setMinWidth(75);
                this.columnModel.getColumn(3).setMaxWidth(200);
                this.setQtyColumnWidth(4);
                this.setQtyColumnWidth(5);
                this.columnModel.getColumn(1).setCellEditor(this.stringEd);
                this.columnModel.getColumn(5).setCellEditor(this.qtyEd);
                this.columnModel.getColumn(0).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(1).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(2).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(3).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(4).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(5).setHeaderRenderer(this.headerRightRen);
                this.renderer.setColumnFormat(3, null, 0);
                this.renderer.setColumnFormat(4, StoreParams.qtyFormat, 0);
                this.renderer.setColumnFormat(5, StoreParams.qtyFormat, 0);
                this.showTrOutReqCol(false);
                break;
            }
            case 9: {
                this.columnModel.getColumn(0).setPreferredWidth(200);
                this.columnModel.getColumn(0).setMinWidth(95);
                this.columnModel.getColumn(0).setMaxWidth(300);
                this.columnModel.getColumn(1).setPreferredWidth(400);
                this.columnModel.getColumn(1).setMinWidth(130);
                this.columnModel.getColumn(1).setMaxWidth(700);
                this.columnModel.getColumn(2).setPreferredWidth(200);
                this.columnModel.getColumn(2).setMinWidth(75);
                this.columnModel.getColumn(2).setMaxWidth(400);
                this.columnModel.getColumn(3).setPreferredWidth(200);
                this.columnModel.getColumn(3).setMinWidth(75);
                this.columnModel.getColumn(3).setMaxWidth(200);
                this.setQtyColumnWidth(4);
                this.columnModel.getColumn(1).setCellEditor(this.stringEd);
                this.columnModel.getColumn(4).setCellEditor(this.qtyEd);
                this.columnModel.getColumn(0).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(1).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(2).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(3).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(4).setHeaderRenderer(this.headerCenterRen);
                this.renderer.setColumnFormat(3, null, 0);
                this.renderer.setColumnFormat(4, StoreParams.qtyFormat, 0);
                break;
            }
            case 5: {
                this.columnModel.getColumn(0).setPreferredWidth(200);
                this.columnModel.getColumn(0).setMinWidth(95);
                this.columnModel.getColumn(0).setMaxWidth(700);
                this.columnModel.getColumn(1).setPreferredWidth(100);
                this.columnModel.getColumn(1).setMinWidth(100);
                this.columnModel.getColumn(1).setMaxWidth(300);
                this.columnModel.getColumn(2).setPreferredWidth(400);
                this.columnModel.getColumn(2).setMinWidth(100);
                this.columnModel.getColumn(2).setMaxWidth(700);
                this.columnModel.getColumn(3).setPreferredWidth(200);
                this.columnModel.getColumn(3).setMinWidth(75);
                this.columnModel.getColumn(3).setMaxWidth(400);
                this.columnModel.getColumn(4).setPreferredWidth(200);
                this.columnModel.getColumn(4).setMinWidth(75);
                this.columnModel.getColumn(4).setMaxWidth(200);
                this.setQtyColumnWidth(5);
                this.columnModel.getColumn(5).setCellEditor(this.qtyEd);
                this.columnModel.getColumn(0).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(1).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(2).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(3).setHeaderRenderer(this.headerLeftRen);
                this.columnModel.getColumn(4).setHeaderRenderer(this.headerCenterRen);
                this.columnModel.getColumn(5).setHeaderRenderer(this.headerCenterRen);
                this.renderer.setPrintZero(true);
                this.renderer.setColumnFormat(5, StoreParams.qtyFormat, 0);
                break;
            }
        }
        this.sizeColumnsToFit(-1);
    }

    private void showOrHideExtendedTaxColumns() {
        int rateCol = 8;
        int amountCol = 9;
        if (this.frParent.frameType == 12) {
            rateCol = 10;
            amountCol = 11;
        }
        if (this.sParams.bUsingExtendedTax) {
            if (this.sParams.bUsingTaxLookup) {
                this.hideColumn(rateCol);
                this.setCurrencyColumnWidth(amountCol);
            } else {
                this.setCurrencyColumnWidth(rateCol);
                this.hideColumn(amountCol);
            }
        } else {
            this.hideColumn(rateCol);
            this.hideColumn(amountCol);
        }
    }

    public void setReturnVoucherAmount(double price) {
        this.priceVii = price;
    }

    public void showOrHideRefundQtyColumns() {
        if (this.frParent instanceof FrSales) {
            FrSales frSales = (FrSales)this.frParent;
            if (!frSales.isReturningSale()) {
                if (this.frParent.frameType == 12) {
                    this.hideColumn(5);
                }
                if (this.frParent.frameType == 1 || this.frParent.frameType == 10) {
                    this.hideColumn(6);
                    this.hideColumn(5);
                }
            } else {
                this.setReturnQtyColumnWidth(5);
                this.setReturnQtyColumnWidth(6);
            }
        }
    }

    public int addEAN(String EAN) {
        return this.addEAN(EAN, true, true);
    }

    public int addEAN(String EAN, boolean consolidate, boolean showPrice) {
        return this.addEAN(EAN, consolidate, showPrice, false);
    }

    public int addEAN(String EAN, boolean consolidate, boolean showPrice, boolean isGiftVoucherCredNote) {
        double qty = 1.0;
        if (EAN.indexOf(",") != -1) {
            qty = PosUtils.doubleValFormatted(EAN.substring(EAN.indexOf(",") + 1));
            EAN = EAN.substring(0, EAN.indexOf(","));
        }
        if (qty == 0.0) {
            return -1;
        }
        int numlines = this.model.getRowCount() - 1;
        int linenum = this.model.addEAN(this, EAN, qty, consolidate, showPrice);
        try {
            String voucherBarcode = null;
            if (linenum <= -1 && !StringUtils.isNullOrEmpty(voucherBarcode = VoucherGatewayManager.getInstance().getGatewayVoucherScanSkuBarcode(EAN))) {
                linenum = this.model.addEAN(this, voucherBarcode, qty, consolidate, showPrice);
            }
            if (linenum > -1 && this.model.getItemAt(linenum) instanceof StyleLine) {
                StyleLine newLine = (StyleLine)this.model.getItemAt(linenum);
                if (newLine.isGiftOnly() && (this.frParent.frameType == 1 || this.frParent.frameType == 10 || this.frParent.frameType == 12)) {
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(SP.getRS("Gift_Only_Message"), "\n"), SP.getRS("Gift_Only_Title"), 1);
                    this.delLine(linenum, false, false);
                    linenum = -2;
                } else if (VoucherUtils.isVoucher(newLine.getSkuidx())) {
                    if (this.frParent.frameType == 10 || this.frParent.frameType == 12) {
                        DlgMessage.showMessage(this.frParent, this.frParent.frameType == 10 ? SP.getRS("no_giv_debtor") : SP.getRS("no_giv_cust_order"), SP.getRS("Gift_Voucher"), 1);
                        this.delLine(linenum, false, false);
                        linenum = -2;
                    } else if (this.frParent.frameType == 1) {
                        double due;
                        Vector<String> vExistingVouchers = this.getAllVoucherNumbers();
                        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.DEFAULT_VOUCHER_VALUE_TO_REFUND_AMOUNT) && (due = this.getDue()) < 0.0 && newLine.getPrice() == 0.0) {
                            newLine.getPriceBeforeUserChange();
                            double price = VoucherGatewayManager.getInstance().limitVoucherValue(Math.abs(due));
                            if (this.priceVii != 0.0) {
                                price = this.priceVii;
                                this.priceVii = 0.0;
                            }
                            newLine.setPrice(price);
                            this.model.fireTableCellUpdated(linenum, 1);
                        }
                        VoucherIssueAdapter voucherIssueAdapter = new VoucherIssueAdapter(this.frParent, vExistingVouchers);
                        if (voucherBarcode != null) {
                            voucherIssueAdapter.processNumber(EAN);
                        } else if (VoucherUtils.usingCreditNoteGiftCards() && isGiftVoucherCredNote) {
                            String vouchType = VoucherUtils.getCreditNoteGiftVoucherType();
                            String vouchNum = VoucherUtils.getNextVoucherNumber(vouchType).toString();
                            if (vouchNum != "0") {
                                voucherIssueAdapter.processNumber(vouchNum);
                            } else {
                                this.model.delLine(linenum, this.frParent, false, false);
                                linenum = -2;
                            }
                        } else {
                            try {
                                PosDialog d;
                                IVoucherGateway digGatewayCheck = VoucherGatewayManager.getInstance().getGateway();
                                if (digGatewayCheck.hasDigitalVouchers()) {
                                    d = new DlgPhysicalDigital(this.frParent, SP.getRS("Issue_Voucher"), voucherIssueAdapter, true);
                                    d.setVisible(true);
                                    d.dispose();
                                } else {
                                    d = new DlgVoucherIssue(this.frParent, SP.getRS("Issue_Voucher"), voucherIssueAdapter);
                                    d.setVisible(true);
                                    d.dispose();
                                }
                            }
                            catch (Exception e) {
                                DlgVoucherIssue d = new DlgVoucherIssue(this.frParent, SP.getRS("Issue_Voucher"), voucherIssueAdapter);
                                d.setVisible(true);
                                d.dispose();
                            }
                        }
                        BaseVoucher voucher = voucherIssueAdapter.getBaseVoucher();
                        if (voucher == null || voucher.getNumber() == null || voucher.getNumber().equals("")) {
                            this.model.delLine(linenum, this.frParent, false, false);
                            linenum = -2;
                        } else if (voucher instanceof Voucher) {
                            newLine.setVoucher(voucher.getNumber(), ((Voucher)voucher).getVoucherType().calcExpirySold(), null, voucherIssueAdapter.IsDigital(), voucherIssueAdapter.GetRecipientEmail());
                            this.model.fireTableCellUpdated(linenum, 1);
                        } else {
                            try {
                                IVoucherGateway gateway = VoucherGatewayManager.getInstance().getGateway();
                                double limitedPrice = VoucherGatewayManager.getInstance().limitVoucherValue(newLine.getPrice());
                                if (limitedPrice != newLine.getPrice()) {
                                    if (newLine.getPrice() == 0.0) {
                                        newLine.getPriceBeforeUserChange();
                                    }
                                    newLine.setPrice(limitedPrice);
                                }
                                if (voucherIssueAdapter.IsDigital()) {
                                    newLine.setDigitalVoucherDetails(voucherIssueAdapter.GetRecipientFirstName(), voucherIssueAdapter.GetRecipientSurname(), voucherIssueAdapter.GetRecipientEmail(), voucherIssueAdapter.GetMessage());
                                }
                                newLine.setNewGatewayVoucherNum(voucher.getNumber());
                                this.model.fireTableCellUpdated(linenum, 1);
                            }
                            catch (SQLException e) {
                                PosUtils.logError(e);
                                this.model.delLine(linenum, this.frParent, false, false);
                                linenum = -2;
                            }
                        }
                    }
                } else if (CardFeeUtils.isCardFee(newLine.getSkuidx())) {
                    if (this.processCardFee(newLine)) {
                        this.model.fireTableCellUpdated(linenum, 1);
                    } else {
                        this.model.delLine(linenum, this.frParent, false, false);
                        linenum = -2;
                    }
                } else if (this.sParams.useDisplayDevice && this.frParent.frameType == 1) {
                    this.sParams.displayDevice.productChange(newLine.getSkuidx(), newLine.getPrice(), qty > 0.0, this.getDisc());
                }
            }
            if (linenum > -1) {
                for (int col = 0; col < this.getColumnCount(); ++col) {
                    if (!this.getModel().isCellEditable(linenum, col)) continue;
                    this.cellEdit(linenum, col);
                    this.changeSelection(linenum, col, false, false);
                    this.getCellEditor(linenum, col).cancelCellEditing();
                    break;
                }
                if ((this.frParent.frameType == 1 || this.frParent.frameType == 10 || this.frParent.frameType == 12) && linenum > numlines) {
                    this.showStyleNotes(linenum);
                }
            }
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
        return linenum;
    }

    private boolean processCardFee(StyleLine newLine) {
        if (this.frParent.frameType == 12) {
            DlgMessage.showMessage(this.frParent, SP.getRS("no_card_fee_cust_order"), SP.getRS("Card_Fee"), 1);
            return false;
        }
        if (this.frParent.frameType == 1 || this.frParent.frameType == 10) {
            List<CardFee> cardFeesList = CardFeeUtils.getCardFees();
            if (cardFeesList.size() > 0) {
                Object[] cardFees = cardFeesList.toArray();
                CardFee cardFee = (CardFee)DlgList.showDialog(this.frParent, SP.getRS("Select_Card_Fee"), SP.getRS("Card_Fee"), cardFees, cardFees[0]);
                if (cardFee != null) {
                    double due = this.getDue();
                    newLine.getPriceBeforeUserChange();
                    newLine.setPrice(due / 100.0 * cardFee.getFeePercent());
                    newLine.changeStyleDescription(MessageFormat.format(SP.getRS("card_fee_style_desc"), newLine.styledesc.trim(), cardFee.toString()));
                    return true;
                }
            } else {
                DlgMessage.showMessage(this.frParent, SP.getRS("no_card_fees_message"), SP.getRS("no_card_fees_title"), 1);
            }
            return false;
        }
        return true;
    }

    private void showStyleNotes(int linenum) {
        try {
            Vector<Element> notesXml;
            if (linenum > -1 && linenum < this.model.getData().size() && this.model.getItemAt(linenum) instanceof StyleLine && this.styleNoteTypes.size() > 0 && (notesXml = Note.getNotes(((StyleLine)this.model.getItemAt(linenum)).getStyleidx(), "STYLE", this.sParams.conn)).size() > 0) {
                Vector<Note> notes = new Vector<Note>();
                for (int i = 0; i < notesXml.size(); ++i) {
                    Note note = Note.createNote(notesXml.get(i), this.styleNoteTypes);
                    if (note == null) continue;
                    notes.add(note);
                }
                if (notes.size() > 0) {
                    DlgNotes dlgNotes = new DlgNotes(this.frParent, StoreParams.res.getString("Product_Notes"), true, null, notes, this.styleNoteTypes, true);
                    dlgNotes.setVisible(true);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public boolean isEditable() {
        return this.model.isEditable();
    }

    public int addSku(long sku, double qty, boolean oldLine, boolean bMergeQty) {
        int linenum = this.model.addSku(sku, qty, oldLine, bMergeQty);
        return linenum;
    }

    public int addStyleLine(StyleLine row) {
        int rownum = this.model.addStyleLine(row);
        this.selectRow(rownum);
        return rownum;
    }

    public void initOrigQtys() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.model.initOrigQtys(i);
        }
    }

    public void setOrigQtys(double qty) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.model.setOrigQty(i, qty);
        }
    }

    public void setOrigQty(int row, double qty) {
        this.model.setOrigQty(row, qty);
    }

    public void setQtys(double qty) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.model.setQty(i, qty);
        }
    }

    public void setQtysToOrig() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.model.setQty(i, this.model.getOrigQty(i));
        }
    }

    public void setQtys() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.model.setQty(i);
        }
    }

    public void setEditable(boolean ed) {
        this.model.setEditable(ed);
    }

    public void setEditSpecialOrder(boolean pbEditSpecialOrder) {
        this.model.setEditSpecialOrder(pbEditSpecialOrder);
    }

    public boolean canEditSpecialOrder() {
        return this.model.canEditSpecialOrder();
    }

    public void setNewRow(int row, boolean pnew) {
        this.model.setNewRow(row, pnew);
    }

    public double getDue() {
        double total = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            total += this.model.getDue(i);
        }
        return this.sParams.rnd(total);
    }

    public double getDueAvailableForManualLoyalty() {
        double total = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            total += this.model.getDueAvailableForManualLoyalty(i);
        }
        return this.sParams.rnd(total);
    }

    public double getDueApplicableForRewardsAccrual() {
        double total = 0.0;
        boolean accrueOnFullPriceOnly = false;
        if (this.frParent instanceof FrSales) {
            FrSales sales = (FrSales)this.frParent;
            accrueOnFullPriceOnly = RewardsUtils.usingAp21RetailRewards() && sales.rewardsApiManager.getAccount() != null && sales.rewardsApiManager.getAccount().getCurrentTier().isAccrualOnFullPriceOnly();
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            total += this.model.getDueApplicableForRewardsAccrual(i, accrueOnFullPriceOnly);
        }
        return this.sParams.rnd(total);
    }

    public double getPickupDue() {
        double total = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            total += this.model.getPickupDue(i);
        }
        return this.sParams.rnd(total);
    }

    public double getNonStockedDue() {
        double total = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).getStkFlag() != 0) continue;
            total += this.model.getPickupDue(i);
        }
        return this.sParams.rnd(total);
    }

    public double getFreightValue() {
        double total = 0.0;
        long skuidx = PosUtils.getFreightSku();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).getSkuidx() != skuidx) continue;
            total += this.model.getPickupDue(i);
        }
        return this.sParams.rnd(total);
    }

    public double getTakenDue() {
        double total = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            total += this.model.getTakenDue(i);
        }
        return this.sParams.rnd(total);
    }

    public double getDelDue() {
        double total = 0.0;
        for (int i = 0; i < this.model.getDelRowCnt(); ++i) {
            total += this.model.getDelDue(i);
        }
        return this.sParams.rnd(total);
    }

    public double getGross() {
        double total = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            total += this.model.getGross(i);
        }
        return this.sParams.rnd(total);
    }

    public double getTax() {
        double total = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            total += this.model.getTax(i);
        }
        return this.sParams.rnd(total);
    }

    public double getDisc() {
        double total = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            total += this.model.getDisc(i);
        }
        return this.sParams.rnd(total);
    }

    public double getQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tot = (int)((double)tot + this.model.getQty(i));
        }
        return tot;
    }

    public double getQtyIgnoreFees() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tot = (int)((double)tot + this.model.getQtyIgnoreFees(i));
        }
        return tot;
    }

    public double getAvailQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tot = (int)((double)tot + this.model.getAvailQty(i));
        }
        return tot;
    }

    public double getInvalidQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).isValid()) continue;
            tot = (int)((double)tot + this.model.getQty(i));
        }
        return tot;
    }

    public double getReqQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tot = (int)((double)tot + this.model.getReqQty(i));
        }
        return tot;
    }

    public double getOrigQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tot = (int)((double)tot + this.model.getOrigQty(i));
        }
        return tot;
    }

    public double getPickUpQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tot = (int)((double)tot + this.model.getPickUpQty(i));
        }
        return tot;
    }

    public int getPackedStockedQty() {
        int tot = 0;
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).getStkFlag() != 1) continue;
                tot = (int)((double)tot + ((StyleLine)this.model.getRow(i)).getPackedQty());
            }
        }
        return tot;
    }

    public int getCustOrdPackedStkQty() {
        int tot = 0;
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).getStkFlag() != 1) continue;
                tot += new BigDecimal(((StyleLine)this.model.getRow(i)).getPackedQty() - ((StyleLine)this.model.getRow(i)).getTakenQty()).setScale(4).intValue();
            }
        }
        return tot;
    }

    public int getCustOrdPackedQty() {
        int tot = 0;
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine)) continue;
                tot += new BigDecimal(((StyleLine)this.model.getRow(i)).getPackedQty() - ((StyleLine)this.model.getRow(i)).getTakenQty()).setScale(4).intValue();
            }
        }
        return tot;
    }

    public int getOutstandingStockedQty() {
        int tot = 0;
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).getStkFlag() != 1) continue;
                tot = (int)((double)tot + ((StyleLine)this.model.getRow(i)).getOutstandingQty());
            }
        }
        return tot;
    }

    public boolean isFullyPacked() {
        boolean fullyPacked = true;
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).getOutstandingQty() == ((StyleLine)this.model.getRow(i)).getOutstandingPackedQty()) continue;
                fullyPacked = false;
            }
        }
        return fullyPacked;
    }

    public int getPickupStockedQty() {
        int tot = 0;
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).getStkFlag() != 1) continue;
                tot = (int)((double)tot + ((StyleLine)this.model.getRow(i)).getPickUpQty());
            }
        }
        return tot;
    }

    public double getPackedQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tot = (int)((double)tot + this.model.getPackedQty(i));
        }
        return tot;
    }

    public double getOutstandingQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tot = (int)((double)tot + this.model.getOutstandingQty(i));
        }
        return tot;
    }

    public double getStockedOutstandingQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getRow(i) instanceof StyleLine)) continue;
            StyleLine line = (StyleLine)this.model.getRow(i);
            if (((StyleLine)this.model.getItemAt(i)).getStkFlag() != 1) continue;
            tot = (int)((double)tot + line.getOutstandingQty());
        }
        return tot;
    }

    public double getOutstandingPackedQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tot = (int)((double)tot + this.model.getOutstandingPackedQty(i));
        }
        return tot;
    }

    public double getTakenQty() {
        int tot = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tot = (int)((double)tot + this.model.getTakenQty(i));
        }
        return tot;
    }

    public double getQty(int row) {
        return this.model.getQty(row);
    }

    public Object getItemAt(int row) {
        return this.model.getItemAt(row);
    }

    public StyleLine getStyle(long skuidx) {
        return this.model.getStyle(skuidx);
    }

    public double getReqQty(int row) {
        return this.model.getReqQty(row);
    }

    public double getOrigQty(int row) {
        return this.model.getOrigQty(row);
    }

    public String getBarcode(int row) {
        return this.model.getBarcode(row);
    }

    public void setColumnName(int col, String name) {
        this.model.setColumnName(col, name);
        TableColumnModel tcm = this.tableHeader.getColumnModel();
        TableColumn tc = tcm.getColumn(col);
        tc.setHeaderValue(name);
        this.tableHeader.repaint();
    }

    protected void db_insertLines() throws SQLException {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.model.db_insertLine(i);
        }
    }

    public void db_insertLines(int transType) throws SQLException {
        int row = 0;
        for (row = 0; row < this.getRowCount(); ++row) {
            this.model.backupQtyBeforeSave(row);
            if (transType == 241 || transType == 244 || transType == 250 || transType == 251 || transType == 248 || transType == 558 || transType == 715) {
                this.model.db_insertLineAdj(row);
                continue;
            }
            if (transType == 242 || transType == 245) continue;
            this.model.db_insertLine(row);
        }
        if (transType == 241 || transType == 244 || transType == 715) {
            for (int j = 0; j < this.model.getDelRowCnt(); ++j) {
                this.model.db_insertDelLineAdj(j);
            }
        }
    }

    protected void db_saveStkTake(long vhidx, long st_vshidx) throws SQLException {
        int i;
        for (i = 0; i < this.getRowCount(); ++i) {
            this.model.db_saveStkTake(i, vhidx, st_vshidx);
        }
        for (i = 0; i < this.model.getDelRowCnt(); ++i) {
            this.model.db_delLine(i);
        }
        this.db_removeInvalidStkTakeLines(vhidx);
        this.model.clearDeleted();
    }

    private void db_removeInvalidStkTakeLines(long vhidx) {
        try (Statement stmt = this.sParams.conn.createStatement();){
            stmt.executeUpdate("DELETE FROM RET_STTD D WHERE D.QTY = 0 AND (D.SKUIDX IS NULL OR NOT EXISTS(SELECT 1 FROM SKU K, CLR C, STYLE S WHERE S.STYLEIDX = C.STYLEIDX AND C.CLRIDX = K.CLRIDX AND K.SKUIDX = D.SKUIDX AND COALESCE(S.STKFLAG,0) = 1 AND K.\"ACTIVE\" = 1)) AND VHIDX = " + vhidx);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    protected void setReason(String reasidx) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.model.setReason(i, reasidx);
        }
        for (int j = 0; j < this.model.getDelRowCnt(); ++j) {
            this.model.setDelReason(j, reasidx);
        }
    }

    public void clear() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        if (this.frParent.frameType == 1) {
            this.showCostCol(false);
            this.showDelToCol(false);
        } else if (this.frParent.frameType == 2) {
            this.showTrOutReqCol(false);
        }
        this.showOrHideRefundQtyColumns();
        this.clearSelection();
        this.model.clear();
        this.discs.clear();
        if (this.taxRemoved) {
            this.taxRemoved = false;
            if (this.frParent.frameType == 1) {
                this.setColumnName(7, SP.getRS("Price"));
                this.setCurrencyColumnWidth(7);
            } else if (this.frParent.frameType == 12) {
                this.setColumnName(9, SP.getRS("Price"));
                this.setCurrencyColumnWidth(9);
            }
        }
    }

    public boolean allZeroQtys() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.model.isNonZeroQty(i)) continue;
            return false;
        }
        return true;
    }

    public boolean hasNegQtys() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.model.isNegQty(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isExchange() {
        double prevSign = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (Math.signum(this.model.getQty(i)) * prevSign == -1.0) {
                return true;
            }
            if (this.model.getQty(i) == 0.0) continue;
            prevSign = Math.signum(this.model.getQty(i));
        }
        return false;
    }

    public Vector<Object> delLines() {
        int[] rows = this.getSelectedRows();
        Vector<Integer> rowList = new Vector<Integer>();
        for (int i = 0; i < rows.length; ++i) {
            rowList.add(new Integer(rows[i]));
        }
        return this.delLines(rowList, true, true);
    }

    public void deleteLine(Object deleteMe) {
        Vector<Integer> deleteList = new Vector<Integer>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.model.getRow(i) != deleteMe) continue;
            deleteList.add(new Integer(i));
        }
        if (deleteList.size() > 0) {
            this.delLines(deleteList, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Object> delLines(Vector<Integer> rows, boolean checkFeeSku, boolean storeDeleted) {
        this.beginUpdate();
        try {
            int i;
            if (this.getCellEditor() != null) {
                this.getCellEditor().cancelCellEditing();
            }
            for (int i2 = rows.size() - 1; i2 >= 0; --i2) {
                Object line = this.getItemAt(rows.elementAt(i2));
                if (!(line instanceof DiscLine)) continue;
                DiscLine discLine = (DiscLine)line;
                if (!discLine.isNew()) {
                    rows.remove(i2);
                    continue;
                }
                if (discLine.isRewardsDiscount() && discLine.getStyleParent().getGift() != null) {
                    rows.remove(i2);
                    continue;
                }
                if (discLine.isManualDiscount()) {
                    for (int j = 0; j < discLine.getDiscParent().getDiscLines().size(); ++j) {
                        Integer discRowNum = new Integer(this.model.rowNumOf(discLine.getDiscParent().getDiscLines().elementAt(j)));
                        if (rows.contains(discRowNum)) continue;
                        rows.add(discRowNum);
                    }
                    this.discs.remove(discLine.getDiscParent());
                    continue;
                }
                rows.remove(i2);
            }
            Object[] sortedRows = rows.toArray();
            Arrays.sort(sortedRows);
            Vector<Object> delLines = new Vector<Object>();
            for (i = sortedRows.length - 1; i >= 0; --i) {
                delLines.addAll(this.model.delLine((Integer)sortedRows[i], this.frParent, checkFeeSku, storeDeleted));
            }
            for (i = 0; i < delLines.size(); ++i) {
                if (!(delLines.elementAt(i) instanceof StyleLine)) continue;
                this.chkDiscRateChg((StyleLine)delLines.elementAt(i));
            }
            Vector<Object> vector = delLines;
            return vector;
        }
        finally {
            this.endUpdate();
        }
    }

    public Vector<Object> delLine(int row, boolean checkFeeSku, boolean storeDeleted) {
        Vector<Integer> rowList = new Vector<Integer>();
        rowList.add(new Integer(row));
        return this.delLines(rowList, checkFeeSku, storeDeleted);
    }

    public void cleanTableForDiscountEngine() {
        this.deleteLoyaltiesAndPromos();
        this.mergeSplitLines();
        this.model.fireTableDataChanged();
    }

    private void deleteLoyaltiesAndPromos() {
        int i;
        Vector<Integer> rowList = new Vector<Integer>();
        for (i = 0; i < this.model.getData().size(); ++i) {
            if (!(this.model.getData().elementAt(i) instanceof DiscLine) || ((DiscLine)this.model.getData().elementAt(i)).isManualDiscount() || !((DiscLine)this.model.getData().elementAt(i)).isNew()) continue;
            rowList.add(new Integer(i));
        }
        if (this.getCellEditor() != null) {
            this.getCellEditor().cancelCellEditing();
        }
        for (i = rowList.size() - 1; i >= 0; --i) {
            DiscLine line = (DiscLine)this.getItemAt((Integer)rowList.elementAt(i));
            line.getStyleParent().removeDisc(line);
            line.getDiscParent().getDiscLines().remove(line);
            this.discs.remove(line.getDiscParent());
            this.model.getData().remove(line);
        }
    }

    public void deleteAllDiscounts() {
        int i;
        Vector<Integer> rowList = new Vector<Integer>();
        for (i = 0; i < this.model.getData().size(); ++i) {
            if (!(this.model.getData().elementAt(i) instanceof DiscLine) || !((DiscLine)this.model.getData().elementAt(i)).isNew()) continue;
            rowList.add(new Integer(i));
        }
        if (this.getCellEditor() != null) {
            this.getCellEditor().cancelCellEditing();
        }
        for (i = rowList.size() - 1; i >= 0; --i) {
            DiscLine line = (DiscLine)this.getItemAt((Integer)rowList.elementAt(i));
            line.getStyleParent().removeDisc(line);
            line.getDiscParent().getDiscLines().remove(line);
            this.discs.remove(line.getDiscParent());
            this.model.getData().remove(line);
        }
    }

    private void mergeSplitLines() {
        StyleLine styleLine = null;
        StyleLine splitFromStyleLine = null;
        for (int i = this.model.getData().size() - 1; i >= 0; --i) {
            if (!(this.model.getData().elementAt(i) instanceof StyleLine) || !((StyleLine)this.model.getData().elementAt(i)).isNew() || (splitFromStyleLine = (styleLine = (StyleLine)this.model.getData().elementAt(i)).getSplitFromStyleLine()) == null || splitFromStyleLine.getPrice() != styleLine.getPrice() || !this.hasSameDiscounts(styleLine, splitFromStyleLine)) continue;
            splitFromStyleLine.setQty(splitFromStyleLine.getQty() + styleLine.getQty());
            splitFromStyleLine.setPackedQty(splitFromStyleLine.getPackedQty() + styleLine.getPackedQty());
            splitFromStyleLine.setPickUpQty(splitFromStyleLine.getPickUpQty() + styleLine.getPickUpQty());
            for (int j = styleLine.getDiscLines().size() - 1; j >= 0; --j) {
                DiscLine line = styleLine.getDiscLines().elementAt(j);
                styleLine.removeDisc(line);
                line.getDiscParent().getDiscLines().remove(line);
                this.model.getData().remove(line);
            }
            this.model.getData().remove(styleLine);
        }
    }

    private boolean hasSameDiscounts(StyleLine styleLine1, StyleLine styleLine2) {
        if (styleLine1.getDiscLines().size() == 0 && styleLine2.getDiscLines().size() == 0) {
            return true;
        }
        return styleLine1.getDiscLines().size() > 0 && styleLine2.getDiscLines().size() > 0 && styleLine1.getDiscLines().elementAt(0).isManualDiscount() && styleLine2.getDiscLines().elementAt(0).isManualDiscount() && styleLine1.getDiscLines().elementAt(0).getDiscParent() == styleLine2.getDiscLines().elementAt(0).getDiscParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populate(Element root) {
        this.beginUpdate();
        try {
            long rootTransactionType = XMLUtils.getLongValue(root, "tr_type");
            long LBcancelIdx = -1L;
            for (Element sub : root.getChildren("subtrans")) {
                if (sub.getAttribute("layby_cancel") == null) continue;
                LBcancelIdx = sub.getAttribute("vhidx").getLongValue();
            }
            for (Element styleshdr : root.getChildren("styles")) {
                Iterator substyles = styleshdr.getChildren().iterator();
                int row = 0;
                boolean bTagAsOld = false;
                while (substyles.hasNext()) {
                    long promoIdx;
                    boolean bMerged = false;
                    Element ele = (Element)substyles.next();
                    if (styleshdr.getAttribute("vhidx") != null && styleshdr.getAttribute("vhidx").getLongValue() == LBcancelIdx && (!ele.getName().equals("style") || !(PosUtils.doubleValInternal(ele.getText()) > 0.0))) continue;
                    if (ele.getAttribute("orig_vshidx") != null && !this.isRecall()) {
                        if (ele.getName().equals("style")) {
                            double qty = PosUtils.doubleValInternal(ele.getText());
                            double taken = ele.getAttribute("taken") != null ? ele.getAttribute("taken").getDoubleValue() : 0.0;
                            double packed = ele.getAttribute("packed") != null ? ele.getAttribute("packed").getDoubleValue() : 0.0;
                            bMerged = this.mergeLines(ele.getAttribute("orig_vshidx").getLongValue(), qty, taken, packed);
                        } else {
                            bMerged = true;
                        }
                    }
                    if (bMerged) continue;
                    boolean oldHeldLine = ele.getAttribute("old_held_value") != null && ele.getAttribute("old_held_value").getIntValue() == 1;
                    double totalReturnQty = 0.0;
                    double origQty = 0.0;
                    if (ele.getName().equals("style")) {
                        ArrayList<LinkedReturn> linkedReturns;
                        double qty = PosUtils.doubleValInternal(ele.getText());
                        if (root.getAttribute("tr_type") != null && (root.getAttribute("tr_type").getLongValue() == 250L || root.getAttribute("tr_type").getLongValue() == 251L || root.getAttribute("tr_type").getLongValue() == 248L)) {
                            qty = ele.getAttribute("descrip2") != null ? ele.getAttribute("descrip2").getDoubleValue() : 0.0;
                        } else if (root.getName().equals("porder")) {
                            qty += ele.getAttribute("trecq").getDoubleValue();
                        }
                        bTagAsOld = root.getAttribute("docket_number") != null || oldHeldLine;
                        row = this.addSku(ele.getAttribute("skuidx").getLongValue(), qty, bTagAsOld, false);
                        if (row == -1) {
                            boolean bl = false;
                            return bl;
                        }
                        List notes = ele.getChildren("note");
                        for (int i = 0; i < notes.size(); ++i) {
                            Note note = Note.createNote((Element)notes.get(i), this.detailNoteTypes);
                            if (note == null) continue;
                            this.model.addNote((StyleLine)this.getItemAt(row), note, row);
                        }
                        if (this.isRecall()) {
                            if (ele.getAttribute("orig_vshidx") != null) {
                                ((StyleLine)this.model.getRow(row)).setVshidx(ele.getAttribute("orig_vshidx").getLongValue());
                            }
                        } else if (ele.getAttribute("vshidx") != null) {
                            ((StyleLine)this.model.getRow(row)).setVshidx(ele.getAttribute("vshidx").getLongValue());
                        }
                        if (ele.getAttribute("pos_vshidx") != null) {
                            ((StyleLine)this.model.getRow(row)).setPosVshidx(ele.getAttribute("pos_vshidx").getLongValue());
                            this.loadedFromHO = true;
                        } else {
                            ((StyleLine)this.model.getRow(row)).setPosVshidx(((StyleLine)this.model.getRow(row)).getVshidx());
                        }
                        if (TransTypes.isLayby(rootTransactionType)) {
                            ((StyleLine)this.model.getRow(row)).setUseDiscountAdjustmentFlag(true);
                        }
                        if (this.loadedFromHO) {
                            ((StyleLine)this.model.getRow(row)).setLoadFromHOFlag(true);
                        }
                        if (ele.getAttribute("pozdidx") != null) {
                            ((StyleLine)this.model.getRow(row)).setPozdidx(ele.getAttribute("pozdidx").getLongValue());
                        }
                        if (ele.getAttribute("descrip1") != null) {
                            switch (this.frParent.frameType) {
                                case 1: {
                                    this.model.setValueAt(ele.getAttribute("descrip1").getValue(), row, 1);
                                    break;
                                }
                                case 10: {
                                    this.model.setValueAt(ele.getAttribute("descrip1").getValue(), row, 1);
                                    break;
                                }
                                case 12: {
                                    this.model.setValueAt(ele.getAttribute("descrip1").getValue(), row, 1);
                                    break;
                                }
                                case 5: {
                                    this.model.setValueAt(ele.getAttribute("descrip1").getValue(), row, 2);
                                    break;
                                }
                                case 3: {
                                    this.model.setValueAt(ele.getAttribute("descrip1").getValue(), row, 1);
                                    break;
                                }
                                case 2: {
                                    this.model.setValueAt(ele.getAttribute("descrip1").getValue(), row, 1);
                                    break;
                                }
                                case 9: {
                                    this.model.setValueAt(ele.getAttribute("descrip1").getValue(), row, 1);
                                    break;
                                }
                            }
                            if (ele.getAttribute("gvnum") != null) {
                                Date dExpiry = null;
                                if (ele.getAttribute("expiry_date") != null) {
                                    dExpiry = new Date(Timestamp.valueOf(ele.getAttribute("expiry_date").getValue()).getTime());
                                }
                                ((StyleLine)this.model.getRow(row)).setVoucher(ele.getAttribute("gvnum").getValue(), dExpiry, XMLUtils.getValue(ele, "voucher_gateway_idx"), XMLUtils.getBooleanValue(ele, "gvgate_isdigital"), XMLUtils.getValue(ele, "gvgate_rec_email"));
                            }
                        }
                        if (ele.getAttribute("ret_reasidx") != null) {
                            ((StyleLine)this.model.getRow((int)row)).reasonIdx.setLength(0);
                            ((StyleLine)this.model.getRow((int)row)).reasonIdx.append(ele.getAttribute("ret_reasidx").getValue());
                        }
                        if (ele.getAttribute("override_srepidx") != null) {
                            ((StyleLine)this.model.getRow(row)).setReturnOverrideSalesRep(new SalesRep(ele.getAttribute("override_srepidx").getLongValue(), this.sParams));
                        }
                        promoIdx = 0L;
                        if (ele.getAttribute("promoidx") != null) {
                            promoIdx = ele.getAttribute("promoidx").getLongValue();
                        }
                        ((StyleLine)this.model.getRow(row)).setAttachedPromoIdx(promoIdx);
                        long giftidx = XMLUtils.getLongValue(ele, "gift_idx");
                        if (giftidx > 0L) {
                            Gift gift = new Gift();
                            gift.setGiftId(giftidx);
                            ((StyleLine)this.model.getRow(row)).setGift(gift);
                        }
                        String eleSkuIdx = ele.getAttribute("skuidx").getValue();
                        String eleCustomisation = "";
                        if (ele.getAttribute("customisation") != null) {
                            eleCustomisation = ele.getAttribute("customisation").getValue();
                        }
                        String sordidx = XMLUtils.getValue(root, "sordidx");
                        String warehouse = XMLUtils.getValue(root, "widx");
                        String transNum = XMLUtils.getValue(root, "trans_number");
                        String docketNum = XMLUtils.getValue(root, "docket_number");
                        String custOrder = XMLUtils.getValue(root, "notes2");
                        String data = docketNum == "" ? transNum : docketNum;
                        ArrayList<LinkedReturn> arrayList = linkedReturns = custOrder.isEmpty() ? PosUtils.getLinkedReturns(warehouse, data) : PosUtils.getLinkedCustOrderReturns(custOrder);
                        if (!linkedReturns.isEmpty()) {
                            for (int i = 0; i < linkedReturns.size(); ++i) {
                                LinkedReturn ret = linkedReturns.get(i);
                                if (!ret.getSkuIdx().equals(eleSkuIdx) || !ret.getCustomisation().equals(eleCustomisation)) continue;
                                double retQty = ret.getReturnedQty() * -1.0;
                                ((StyleLine)this.model.getRow(row)).addReturnData(SP.getRS("Return_Item_Date", retQty, ret.getReturnDate()) + " " + SP.getRS("At_Store", ret.getStore()));
                                totalReturnQty += retQty;
                                if (origQty != 0.0) continue;
                                origQty = ret.getOriginalQty();
                            }
                        }
                        if (totalReturnQty > 0.0) {
                            this.setReturnQtyColumnWidth(6);
                            this.model.setReturnedQty(row, totalReturnQty);
                            this.model.setValueAt(new PosDouble(totalReturnQty, 0), row, 6);
                            this.model.setValueAt(new PosDouble(origQty, 0), row, 5);
                        }
                        double d = origQty = origQty == 0.0 ? PosUtils.doubleValInternal(ele.getText()) : origQty;
                        if (origQty < 0.0) {
                            origQty *= -1.0;
                        }
                        this.model.setOriginalQty(row, origQty);
                        if (this.frParent.frameType == 1) {
                            if (ele.getAttribute("delto") != null && ele.getAttribute("delto").getLongValue() != 0L) {
                                try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT CODE FROM REFCODE WHERE RCIDX = " + ele.getAttribute("delto").getLongValue());){
                                    if (sql.next()) {
                                        ((StyleLine)this.model.getRow(row)).setDelTo(sql.getString(1));
                                        ((StyleLine)this.model.getRow(row)).setDelToIdx(ele.getAttribute("delto").getLongValue());
                                    }
                                }
                            }
                            if (ele.getAttribute("cost") != null && ele.getAttribute("cost").getDoubleValue() > 0.0) {
                                ((StyleLine)this.model.getRow(row)).setCost(ele.getAttribute("cost").getDoubleValue());
                            }
                            if (ele.getAttribute("customisation") != null) {
                                ((StyleLine)this.model.getRow(row)).setCustomisation(ele.getAttribute("customisation").getValue());
                            }
                        }
                        if (this.frParent.frameType == 3 && SP.sParams.bUsingSOHInStockReceipts && ele.getAttribute("soh_qty") != null) {
                            ((StyleLine)this.model.getRow(row)).setQtySoh(ele.getAttribute("soh_qty").getDoubleValue());
                        }
                        if (this.frParent.frameType == 1) {
                            this.model.setValueAt(new PosDouble(PosUtils.doubleValInternal(ele.getAttribute("price").getValue())).toString(), row, 7);
                            if (ele.getAttribute("taxper") != null) {
                                ((StyleLine)this.model.getRow(row)).setTaxPer(ele.getAttribute("taxper").getDoubleValue());
                            }
                            if (this.sParams.bUsingExtendedTax && ele.getAttribute("ext_taxrate") != null) {
                                ((StyleLine)this.model.getRow(row)).setExtTaxPer(ele.getAttribute("ext_taxrate").getDoubleValue());
                                this.model.fireTableCellUpdated(row, 8);
                            }
                            if (ele.getAttribute("tax_donotrefresh_flag") != null && Integer.parseInt(ele.getAttribute("tax_donotrefresh_flag").getValue()) == 1) {
                                ((StyleLine)this.model.getRow(row)).setDoNotRefreshTax(true);
                            }
                            if (((FrSales)this.frParent).ownerCurrency != null) {
                                this.setColumnName(7, MessageFormat.format(StoreParams.res.getString("Price_Currency"), ((FrSales)this.frParent).ownerCurrency));
                            }
                            this.setNewRow(row, !bTagAsOld);
                        } else if (this.frParent.frameType == 12) {
                            this.model.setValueAt(new PosDouble(PosUtils.doubleValInternal(ele.getAttribute("price").getValue())).toString(), row, 9);
                            if (ele.getAttribute("taxper") != null) {
                                ((StyleLine)this.model.getRow(row)).setTaxPer(ele.getAttribute("taxper").getDoubleValue());
                            }
                            if (this.sParams.bUsingExtendedTax && ele.getAttribute("ext_taxrate") != null) {
                                ((StyleLine)this.model.getRow(row)).setExtTaxPer(ele.getAttribute("ext_taxrate").getDoubleValue());
                                this.model.fireTableCellUpdated(row, 10);
                            }
                            if (ele.getAttribute("tax_donotrefresh_flag") != null && Integer.parseInt(ele.getAttribute("tax_donotrefresh_flag").getValue()) == 1) {
                                ((StyleLine)this.model.getRow(row)).setDoNotRefreshTax(true);
                            }
                            if (ele.getAttribute("taken") != null) {
                                ((StyleLine)this.model.getRow(row)).setTakenQty(ele.getAttribute("taken").getDoubleValue());
                            }
                            if (SP.sParams.bUsingSOHInCustOrders && ele.getAttribute("soh_qty") != null) {
                                ((StyleLine)this.model.getRow(row)).setQtySoh(ele.getAttribute("soh_qty").getDoubleValue());
                            }
                            if (ele.getAttribute("packed") != null) {
                                ((StyleLine)this.model.getRow(row)).setPackedQty(ele.getAttribute("packed").getDoubleValue());
                            }
                            if (ele.getAttribute("sozdidx") != null) {
                                ((StyleLine)this.model.getRow(row)).setSozdidx(ele.getAttribute("sozdidx").getLongValue());
                            }
                            if (ele.getAttribute("pickrun") != null) {
                                ((StyleLine)this.model.getRow(row)).setPickSlipRun(ele.getAttribute("pickrun").getValue());
                            }
                            if (((FrSales)this.frParent).ownerCurrency != null) {
                                this.setColumnName(9, MessageFormat.format(StoreParams.res.getString("Price_Currency"), ((FrSales)this.frParent).ownerCurrency));
                            }
                            if (ele.getAttribute("customisation") != null) {
                                ((StyleLine)this.model.getRow(row)).setCustomisation(ele.getAttribute("customisation").getValue());
                            }
                            this.setNewRow(row, !bTagAsOld);
                        } else if (this.frParent.frameType == 10) {
                            double price = ele.getAttribute("price").getDoubleValue();
                            double origPrice = ele.getAttribute("orig_price").getDoubleValue();
                            double taxper = ele.getAttribute("taxper").getDoubleValue();
                            double ext_taxrate = ele.getAttribute("ext_taxrate").getDoubleValue();
                            StyleLine style = (StyleLine)this.model.getRow(row);
                            style.setTaxPer(taxper);
                            style.setExtTaxPer(ext_taxrate);
                            style.setPrice(price + price * style.getTaxPer() / 100.0);
                            style.setOrigPrice(price + origPrice * style.getTaxPer() / 100.0);
                            style.setDebtorAccountSale(true);
                            this.model.fireTableRowsUpdated(row, row);
                        } else if (root.getAttribute("tr_type") != null && (root.getAttribute("tr_type").getLongValue() == 250L || root.getAttribute("tr_type").getLongValue() == 251L || root.getAttribute("tr_type").getLongValue() == 248L)) {
                            this.model.setQty(row, PosUtils.doubleValInternal(ele.getText()));
                        } else if (root.getName().equals("porder")) {
                            this.addSku(ele.getAttribute("skuidx").getLongValue(), ele.getAttribute("trecq").getDoubleValue(), true, true);
                        }
                        this.model.setNonReturnableFlag(row, XMLUtils.getBooleanValue(ele, "non_returnable"));
                        continue;
                    }
                    if (!ele.getName().equals("discount")) continue;
                    boolean bLoyalty = false;
                    if (ele.getAttribute("loyalty") != null && ele.getAttribute("loyalty").getBooleanValue()) {
                        bLoyalty = true;
                    }
                    long pos_vshidx = -1L;
                    if (this.isRecall()) {
                        if (ele.getAttribute("orig_vshidx") != null) {
                            pos_vshidx = ele.getAttribute("orig_vshidx").getLongValue();
                        }
                    } else if (ele.getAttribute("pos_vshidx") != null) {
                        pos_vshidx = ele.getAttribute("pos_vshidx").getLongValue();
                    } else if (ele.getAttribute("vshidx") != null) {
                        pos_vshidx = ele.getAttribute("vshidx").getLongValue();
                    }
                    promoIdx = 0L;
                    if (ele.getAttribute("promoidx") != null) {
                        promoIdx = ele.getAttribute("promoidx").getLongValue();
                    }
                    long overrideSrepidx = 0L;
                    if (ele.getAttribute("override_srepidx") != null) {
                        overrideSrepidx = ele.getAttribute("override_srepidx").getLongValue();
                    }
                    if (this.isRecall() && (promoIdx != 0L || bLoyalty) && !oldHeldLine) continue;
                    this.setDisc(bLoyalty ? ele.getAttribute("line_code").getLongValue() : ele.getAttribute("reasonidx").getLongValue(), PosUtils.doubleValInternal(ele.getText()), row, this.isRecall() && !oldHeldLine, bLoyalty, pos_vshidx, promoIdx, MultiLineDisc.MessageCode.NORMAL, overrideSrepidx, true, XMLUtils.getValue(ele, "descrip1"), XMLUtils.getValue(ele, "descrip2"), XMLUtils.getLongValue(ele, "coupon_idx"));
                }
            }
            this.initOrigQtys();
            this.selectFirstRow();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.endUpdate();
        }
    }

    public boolean balanced() {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (this.model.isBalanced(i)) continue;
            return false;
        }
        return true;
    }

    public void setPriceChangeAllowed(boolean priceChange) {
        this.model.canChangeprice = priceChange;
    }

    public void setPopulatingRecall(boolean bPopulatingRecall) {
        this.model.setPopulatingRecall(bPopulatingRecall);
    }

    public boolean isRecall() {
        return this.model.IsRecall();
    }

    public boolean canAddLoyaltyDisc(Reference loyalty) {
        if (loyalty.getIdx() == 787L) {
            return true;
        }
        Vector<String> compatibles = MultiLineDisc.getCompatibles(loyalty);
        for (int i = 0; i < this.discs.size(); ++i) {
            if (!this.discs.elementAt(i).isLoyalty()) continue;
            Reference prevLoyalty = this.discs.elementAt(i).getLoyalty();
            if (loyalty.getIdx() == prevLoyalty.getIdx()) {
                return false;
            }
            if (prevLoyalty.getIdx() == 787L || compatibles.contains(String.valueOf(prevLoyalty.getIdx())) || MultiLineDisc.getCompatibles(prevLoyalty).contains(String.valueOf(loyalty.getIdx()))) continue;
            Object[] objs = new Object[]{"'" + loyalty.getName() + "'", "'" + this.discs.elementAt(i).getLoyalty().getName() + "'"};
            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("cards_not_compatible"), objs), StoreParams.res.getString("Incompatible_cards"), 1);
            return false;
        }
        return true;
    }

    public void removeAllLoyalyDiscounts() {
        Vector<MultiLineDisc> removeList = new Vector<MultiLineDisc>();
        for (MultiLineDisc disc : this.discs) {
            if (!disc.isLoyalty()) continue;
            removeList.add(disc);
        }
        this.discs.removeAll(removeList);
    }

    public String getIdxs(int level) {
        String idxs = "";
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!(this.model.getData().elementAt(i) instanceof StyleLine)) continue;
            if (level == 1) {
                idxs = idxs + ((StyleLine)this.model.getData().elementAt(i)).getStyleidx() + ",";
                continue;
            }
            if (level == 2) {
                idxs = idxs + ((StyleLine)this.model.getData().elementAt(i)).getClridx() + ",";
                continue;
            }
            if (level != 3) continue;
            idxs = idxs + ((StyleLine)this.model.getData().elementAt(i)).getSkuidx() + ",";
        }
        if (idxs.length() > 0) {
            return idxs.substring(0, idxs.length() - 1);
        }
        return "-1";
    }

    public boolean setPriceDets(long skuidx, double price, double origPrice, double tax, double discount, boolean pAccountSale) {
        boolean priceUpdated = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object line = this.getItemAt(i);
            if (!(line instanceof StyleLine) || ((StyleLine)line).getSkuidx() != skuidx || ((StyleLine)line).getPrice() != 0.0) continue;
            ((StyleLine)line).setPrice(price + price * (tax / 100.0));
            ((StyleLine)line).setOrigPrice(origPrice + origPrice * (tax / 100.0));
            ((StyleLine)line).setTaxPer(tax);
            ((StyleLine)line).setDebtorAccountSale(pAccountSale);
            if (discount > 0.0) {
                this.setDisc(557L, discount, i, true, false, -1L, 0L, MultiLineDisc.MessageCode.NORMAL);
            }
            switch (this.frParent.frameType) {
                case 1: {
                    this.model.fireTableCellUpdated(i, 7);
                    break;
                }
                case 12: {
                    this.model.fireTableCellUpdated(i, 9);
                    break;
                }
                case 10: {
                    this.model.fireTableCellUpdated(i, 5);
                    break;
                }
            }
            priceUpdated = true;
        }
        return priceUpdated;
    }

    public boolean refund(int row, PosFrame owner, SalesRep returnOverrideSalesRep) {
        return this.model.refund(row, owner, returnOverrideSalesRep);
    }

    public boolean isGiftVoucher(int row) {
        return this.model.getItemAt(row) instanceof StyleLine && VoucherUtils.isVoucher(((StyleLine)this.model.getItemAt(row)).getSkuidx());
    }

    public boolean isGatewayGiftVoucher(int row) {
        return this.model.getItemAt(row) instanceof StyleLine && VoucherUtils.isVoucher(((StyleLine)this.model.getItemAt(row)).getSkuidx()) && !StringUtils.isNullOrEmpty(((StyleLine)this.model.getItemAt(row)).getVoucherGatewayIdx());
    }

    public boolean isReturnLine(int row) {
        return this.model.getItemAt(row) instanceof StyleLine && this.getQty(row) < 0.0;
    }

    public void setAllowInvalid(boolean allowInvalid) {
        this.model.setAllowInvalid(allowInvalid);
    }

    public boolean setStkAvailability() {
        if (this.getRowCount() > 0) {
            int i;
            String skus = "";
            for (i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine)) continue;
                skus = skus + "," + ((StyleLine)this.model.getRow(i)).getSkuidx();
            }
            this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("stkavail", this.sParams.getStoreIdx() + "," + skus.substring(1)).getXML();
            if (this.sParams.root != null) {
                List stk = this.sParams.root.getChildren("sku");
                block5: for (int i2 = 0; i2 < stk.size(); ++i2) {
                    for (int j = 0; j < this.getRowCount(); ++j) {
                        try {
                            if (!(this.model.getRow(j) instanceof StyleLine) || ((StyleLine)this.model.getRow(j)).getSkuidx() != ((Element)stk.get(i2)).getAttribute("skuidx").getLongValue()) continue;
                            StyleLine style = (StyleLine)this.model.getRow(j);
                            double availQty = PosUtils.doubleValInternal(((Element)stk.get(i2)).getText());
                            style.setQty(5, Math.min(style.getQty(), Math.max(availQty, 0.0)));
                            continue block5;
                        }
                        catch (DataConversionException e) {
                            PosUtils.logError(e);
                        }
                    }
                }
            } else {
                for (i = 0; i < this.getRowCount(); ++i) {
                    if (!(this.model.getRow(i) instanceof StyleLine)) continue;
                    StyleLine style = (StyleLine)this.model.getRow(i);
                    if (style.getQty() == 1.0) {
                        Object[] objs = new Object[]{"\n", "\n", style.stylecode, style.clrcode, style.size};
                        if (DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("is_available"), objs), StoreParams.res.getString("Offline"), 0, 3) == 0) {
                            style.setQty(5, 1.0);
                            continue;
                        }
                        style.setQty(5, 0.0);
                        continue;
                    }
                    String availQty = "";
                    while (availQty.equals("")) {
                        Object[] objs = new Object[]{"\n", "\n", style.stylecode, style.clrcode, style.size};
                        availQty = JOptionPane.showInputDialog(this.frParent, MessageFormat.format(StoreParams.res.getString("enter_available"), objs), StoreParams.res.getString("Offline"), 3);
                        try {
                            if (availQty == null) {
                                return false;
                            }
                            SP.sParams.currFormat.parse(availQty);
                        }
                        catch (ParseException e) {
                            availQty = "";
                        }
                    }
                    style.setQty(5, Math.min(style.getQty(), Math.max(PosUtils.doubleValFormatted(availQty), 0.0)));
                }
            }
            return true;
        }
        return false;
    }

    public void removeDiscounts() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            if (!(this.model.getRow(i) instanceof DiscLine)) continue;
            this.delLine(i, true, false);
        }
    }

    public void setNotes() {
        if (this.detailNoteTypes.size() > 0 && this.getRowCount() > 0) {
            int row = this.getSelectedRow();
            if (row == -1) {
                row = this.getRowCount() - 1;
            }
            Object style = this.getItemAt(row);
            while (!(style instanceof StyleLine)) {
                style = this.getItemAt(--row);
            }
            if (this.model.isEditable() || ((StyleLine)style).getNotes().size() > 0) {
                DlgNotes dlgNotes = new DlgNotes(this.frParent, StoreParams.res.getString("Notes"), true, this.frParent.getUser(), ((StyleLine)style).getNotes(), this.detailNoteTypes, !this.model.isEditable());
                dlgNotes.setVisible(true);
                for (int i = 0; i < ((StyleLine)style).getNotes().size(); ++i) {
                    if (((StyleLine)style).getNotes().elementAt((int)i).styleParent != null) continue;
                    this.model.addNote((StyleLine)style, ((StyleLine)style).getNotes().elementAt(i), row);
                }
            }
        }
    }

    @Override
    public Color getDisplayForegroundAt(Object value, int row, int column) {
        if (row < 0) {
            return this.renderer.defaultColour;
        }
        Object line = this.getItemAt(row);
        if (line instanceof DiscLine) {
            if (((DiscLine)line).getDiscParent().isDiscValid()) {
                return Colours.BLUE;
            }
            return Colours.RED;
        }
        if (line instanceof StyleLine) {
            if (!((StyleLine)line).isValid()) {
                if (((StyleLine)line).getStkFlag() == 0) {
                    return Colours.BLUE;
                }
                return Colours.RED;
            }
            if (this.getQty(row) < 0.0) {
                return Colours.RED;
            }
        } else if (line instanceof Note) {
            return Colours.GREY;
        }
        return this.renderer.defaultColour;
    }

    protected boolean addDiscLine(DiscLine disc) {
        return this.model.addDiscLine(disc);
    }

    public void addDisc(Discount discType, Vector<StyleLine> lines, SalesRep overrideSalesRep) {
        int nSelectedLine;
        Object selectedLine = null;
        if (this.getSelectedRowCount() == 1 && (nSelectedLine = this.getSelectedRow()) > -1) {
            selectedLine = this.model.getItemAt(nSelectedLine);
        }
        this.clearSelection();
        MultiLineDisc discount = new MultiLineDisc(this, discType, lines, overrideSalesRep);
        if (discount.getDiscLines().size() > 0) {
            this.discs.add(discount);
        }
        if (selectedLine != null) {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                if (this.model.getRow(i) != selectedLine) continue;
                this.setRowSelectionInterval(i, i);
                break;
            }
        }
    }

    public void setDisc(long discIdx, double rate, int row, boolean newDisc, boolean bLoyalty, long pos_vshidx, long promoIdx, MultiLineDisc.MessageCode messageCode) {
        this.setDisc(discIdx, rate, row, newDisc, bLoyalty, pos_vshidx, promoIdx, messageCode, 0L, true, null, null, 0L);
    }

    public void setDisc(long discIdx, double rate, int row, boolean newDisc, boolean bLoyalty, long pos_vshidx, long promoIdx, MultiLineDisc.MessageCode messageCode, long overrideSalesRepIdx, boolean mergeWherePossible, String description1) {
        this.setDisc(discIdx, rate, row, newDisc, bLoyalty, pos_vshidx, promoIdx, messageCode, 0L, true, description1, null, 0L);
    }

    public void setDisc(long discIdx, double rate, int row, boolean newDisc, boolean bLoyalty, long pos_vshidx, long promoIdx, MultiLineDisc.MessageCode messageCode, long overrideSalesRepIdx, boolean mergeWherePossible, String description1, String description2, long couponIdx) {
        Object style = this.getItemAt(row);
        if (style instanceof DiscLine) {
            style = ((DiscLine)style).getStyleParent();
        } else if (style instanceof Note) {
            style = ((Note)style).styleParent;
        }
        if (!bLoyalty && promoIdx == 0L && mergeWherePossible) {
            for (int i = 0; i < this.discs.size(); ++i) {
                MultiLineDisc disc = this.discs.elementAt(i);
                if (disc.getDiscount().getIdx() != discIdx || PosUtils.scale(disc.getCurrDiscPer(), 8) != PosUtils.scale(rate / 100.0, 8)) continue;
                disc.addDiscLine((StyleLine)style, pos_vshidx);
                return;
            }
        }
        MultiLineDisc disc = new MultiLineDisc(this, new Discount(discIdx, true), newDisc, bLoyalty, promoIdx, messageCode);
        disc.setFinalRate(PosUtils.scale(rate / 100.0, 8), MultiLineDisc.DiscountType.PERCENTAGE);
        if (overrideSalesRepIdx > 0L) {
            disc.setOverrideSalesRep(new SalesRep(overrideSalesRepIdx, this.sParams));
        }
        disc.setDescription(description1, description2);
        if (!newDisc && discIdx == 849L) {
            disc.setCoupon(couponIdx, description2);
        }
        if (this.frParent instanceof FrSales) {
            FrSales sales = (FrSales)this.frParent;
            if (RewardsUtils.usingAp21RetailRewards() && discIdx == 787L && sales.rewardsApiManager.getAccount() != null && sales.rewardsApiManager.getAccount().getRewardsProgram() != null) {
                disc.setRewardsProgramName(sales.rewardsApiManager.getAccount().getRewardsProgram().getName());
            } else if (newDisc && discIdx == 849L && sales.getCoupon() != null) {
                disc.setCoupon(sales.getCoupon().getId(), sales.getCoupon().getCode());
            } else if (RewardsUtils.usingCapillaryRewards() && discIdx == 787L && sales.rewardsApiManager.getAccount() != null && sales.rewardsApiManager.getAccount().getRewardsProgram() != null) {
                disc.setRewardsProgramName(sales.rewardsApiManager.getAccount().getRewardsProgram().getName());
            }
        }
        disc.reEvalDiscAmt();
        disc.addDiscLine((StyleLine)style, pos_vshidx);
        this.discs.add(disc);
    }

    private void checkUpdate(TableModelEvent e) {
        block5: {
            block6: {
                if (this.frParent.frameType != 1 && this.frParent.frameType != 10 && this.frParent.frameType != 12) break block5;
                if (e.getType() != 0) break block6;
                if ((this.frParent.frameType != 1 || e.getColumn() != 4 && e.getColumn() != 7 && e.getColumn() != 8 && e.getColumn() != 9) && (this.frParent.frameType != 10 || e.getColumn() != 4 && e.getColumn() != 5) && (this.frParent.frameType != 12 || e.getColumn() != 4 && e.getColumn() != 6 && e.getColumn() != 7 && e.getColumn() != 8 && e.getColumn() != 9 && e.getColumn() != 10 && e.getColumn() != 11)) break block5;
                for (int row = e.getFirstRow(); row <= e.getLastRow(); ++row) {
                    Object line = this.getItemAt(row);
                    if (!(line instanceof StyleLine) || this.chkDiscRateChg((StyleLine)line)) continue;
                    if (this.frParent.frameType == 1) {
                        this.model.fireTableCellUpdated(row, 11);
                        continue;
                    }
                    if (this.frParent.frameType == 10) {
                        this.model.fireTableCellUpdated(row, 7);
                        continue;
                    }
                    if (this.frParent.frameType != 12) continue;
                    this.model.fireTableCellUpdated(row, 13);
                }
                break block5;
            }
            if (e.getType() == 1) {
                for (int row = e.getFirstRow(); row <= e.getLastRow(); ++row) {
                    if (!(this.getItemAt(row) instanceof StyleLine)) continue;
                    this.chkDiscRateChg((StyleLine)this.getItemAt(row));
                }
            }
        }
    }

    public void processPromotions() {
        if (this.frParent.frameType == 1 || this.frParent.frameType == 10 || this.frParent.frameType == 12) {
            Object selectedObject = null;
            int selectedRow = -1;
            if (this.getSelectedRowCount() >= 1 && this.getSelectedRow() < this.model.getData().size() && this.getSelectedRow() > -1) {
                selectedRow = this.getSelectedRow();
                selectedObject = this.model.getData().elementAt(selectedRow);
            }
            String perIdx = ((FrSales)this.frParent).person.getAttribute("peridx") != null ? ((FrSales)this.frParent).person.getAttribute("peridx").getValue() : "";
            PromotionUtils.processTransaction(this, perIdx, this.frParent.getPromotionsEnabled(), ((FrSales)this.frParent).generatePromoEngineExtraProperties());
            if (this.getSelectedRowCount() == 0) {
                int row = -1;
                if (selectedObject != null) {
                    row = this.model.getData().indexOf(selectedObject);
                }
                if (row < 0) {
                    row = selectedRow;
                }
                if (row < 0) {
                    row = 0;
                }
                if (row >= this.getRowCount()) {
                    row = this.getRowCount() - 1;
                }
                if (row > -1 && row < this.getRowCount()) {
                    this.setRowSelectionInterval(row, row);
                }
            }
            ((FrSales)this.frParent).attachedLoyaltyCards.fixUpAmounts((FrSales)this.frParent);
        }
    }

    private boolean chkDiscRateChg(StyleLine style) {
        boolean retVal = false;
        for (DiscLine discLine : style.getDiscLines()) {
            if (!discLine.isManualDiscount() || !discLine.isNew()) continue;
            discLine.setValidated(false);
        }
        for (DiscLine discLine : style.getDiscLines()) {
            if (!discLine.isManualDiscount() || !discLine.isNew()) continue;
            MultiLineDisc discount = discLine.getDiscParent();
            if (discount.reEvalDiscAmt()) {
                retVal = true;
                for (int i = 0; i < discount.getDiscLines().size(); ++i) {
                    int discIndex = this.model.rowNumOf(discount.getDiscLines().elementAt(i));
                    int styleIndex = this.model.rowNumOf(discount.getDiscLines().elementAt(i).getStyleParent());
                    if (styleIndex > -1) {
                        if (this.frParent.frameType == 1) {
                            this.model.fireTableCellUpdated(styleIndex, 11);
                        } else if (this.frParent.frameType == 10) {
                            this.model.fireTableCellUpdated(styleIndex, 7);
                        } else if (this.frParent.frameType == 12) {
                            this.model.fireTableCellUpdated(styleIndex, 13);
                        }
                    }
                    if (discIndex <= -1) continue;
                    this.model.fireTableRowsUpdated(discIndex, discIndex);
                }
            } else {
                int discIndex = this.model.rowNumOf(discLine);
                if (discIndex > -1) {
                    this.model.fireTableRowsUpdated(discIndex, discIndex);
                }
            }
            discLine.setValidated(true);
        }
        return retVal;
    }

    public void showTrOutReqCol(boolean bShow) {
        if (bShow) {
            this.model.setTransferRequest(true);
            this.setQtyColumnWidth(4);
        } else {
            this.model.setTransferRequest(false);
            this.hideColumn(4);
        }
    }

    public void showReceivedCols(boolean bShow) {
        if (bShow) {
            this.model.setShowReceivedCols(true);
            this.setQtyColumnWidth(6);
        } else {
            this.model.setShowReceivedCols(false);
            this.hideColumn(6);
        }
    }

    public void showRequiredCols(boolean bShow) {
        if (bShow) {
            this.setQtyColumnWidth(4);
        } else {
            this.hideColumn(4);
        }
    }

    public void showPrevReceivedCols(boolean bShow) {
        if (bShow) {
            this.setQtyColumnWidth(5);
        } else {
            this.hideColumn(5);
        }
    }

    public void showDelToCol(boolean bShow) {
        if (bShow) {
            this.model.bShowDelToCol = true;
            this.columnModel.getColumn(12).setMinWidth(150);
            this.columnModel.getColumn(12).setMaxWidth(500);
            this.columnModel.getColumn(12).setPreferredWidth(250);
        } else {
            this.model.bShowDelToCol = false;
            this.hideColumn(12);
        }
    }

    public void showCostCol(boolean bShow) {
        if (bShow) {
            this.model.bShowCostCol = true;
            this.setCurrencyColumnWidth(13);
        } else {
            this.model.bShowCostCol = false;
            this.hideColumn(13);
        }
    }

    public void showPickupCol(boolean bShow) {
        if (bShow) {
            this.setQtyColumnWidth(8);
        } else {
            this.hideColumn(8);
        }
    }

    public void checkShowSpecialOrderCols() {
        boolean bCostCol = false;
        boolean bDelToCol = false;
        if (this.frParent.docknum != null && !TransTypes.isSpecialOrder(this.frParent.transType)) {
            bCostCol = false;
            bDelToCol = false;
        } else {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getItemAt(i) instanceof StyleLine)) continue;
                if (((StyleLine)this.model.getItemAt(i)).getChangeCost()) {
                    bCostCol = true;
                }
                if (!((StyleLine)this.model.getItemAt(i)).getGenPurchaseOrder()) continue;
                bDelToCol = true;
            }
        }
        this.showCostCol(bCostCol);
        this.showDelToCol(bDelToCol);
    }

    public int checkTableForSpecialOrder() {
        if (this.frParent.transType == 243 || this.frParent.transType == 245 || this.frParent.transType == 244) {
            return 1;
        }
        int nCountGenProd = 0;
        int nCountGenPurchOrd = 0;
        int nCountGenTransferOrd = 0;
        int nCountNormal = 0;
        boolean bFound = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            bFound = false;
            if (!(this.model.getItemAt(i) instanceof StyleLine)) continue;
            if (((StyleLine)this.model.getItemAt(i)).getGenProduct()) {
                ++nCountGenProd;
                bFound = true;
            }
            if (((StyleLine)this.model.getItemAt(i)).getGenPurchaseOrder()) {
                ++nCountGenPurchOrd;
                bFound = true;
            }
            if (((StyleLine)this.model.getItemAt(i)).getGenTransferOrder()) {
                ++nCountGenTransferOrd;
                bFound = true;
            }
            if (bFound || ((StyleLine)this.model.getItemAt(i)).getSkuidx() == this.sParams.specOrdAdminFeeSku || ((StyleLine)this.model.getItemAt(i)).getSkuidx() == this.sParams.specOrdCancFeeSku) continue;
            ++nCountNormal;
        }
        if (nCountNormal > 0 && nCountGenProd > 0) {
            return 3;
        }
        if (nCountGenPurchOrd > 0 && nCountGenTransferOrd > 0) {
            return 3;
        }
        if (nCountNormal > 0) {
            return 0;
        }
        if (nCountGenProd > 0) {
            return 1;
        }
        if (nCountGenPurchOrd > 0 || nCountGenTransferOrd > 0) {
            return 2;
        }
        return 0;
    }

    public boolean checkTableForGiftVouchers() {
        boolean bGift = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.isGiftVoucher(i)) continue;
            bGift = true;
            break;
        }
        return bGift;
    }

    public boolean checkTableForGiftVouchers(int[] rows) {
        boolean bGift = false;
        for (int i = 0; i < rows.length; ++i) {
            if (!this.isGiftVoucher(rows[i])) continue;
            bGift = true;
            break;
        }
        return bGift;
    }

    public boolean checkTableForReturns(int[] rows) {
        boolean bReturnLine = false;
        for (int i = 0; i < rows.length; ++i) {
            if (!this.isReturnLine(rows[i])) continue;
            bReturnLine = true;
            break;
        }
        return bReturnLine;
    }

    public List<StyleLine> getNewGatewayVoucherLines() {
        Vector<StyleLine> lines = new Vector<StyleLine>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getItemAt(i) instanceof StyleLine) || !this.isGatewayGiftVoucher(i) || !((StyleLine)this.model.getItemAt(i)).isNew()) continue;
            lines.add((StyleLine)this.model.getItemAt(i));
        }
        return lines;
    }

    public Vector<String> getAllVoucherNumbers() {
        Vector<String> vExistingVouchers = new Vector<String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getItemAt(i) instanceof StyleLine) || ((StyleLine)this.model.getItemAt(i)).getGvNum() == null) continue;
            vExistingVouchers.add(((StyleLine)this.model.getItemAt(i)).getGvNum());
        }
        return vExistingVouchers;
    }

    public boolean checkForRecalledProduct() {
        boolean bRecall = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getItemAt(i) instanceof StyleLine) || !((StyleLine)this.model.getItemAt(i)).isRecallProd() || !(((StyleLine)this.model.getItemAt(i)).getQty() > 0.0)) continue;
            bRecall = true;
            String sReason = "";
            if (((StyleLine)this.model.getItemAt(i)).getRecalLogIdx() > 0L) {
                try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT B.BLOBTEXT FROM BLOBTEXT B, AP21LOG L WHERE L.NOTES_BLOBIDX = B.BLOBIDX AND L.LOGIDX = " + ((StyleLine)this.model.getItemAt(i)).getRecalLogIdx());){
                    if (sql.next()) {
                        sReason = sql.getString(1);
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
            Object[] objs = new Object[]{((StyleLine)this.model.getItemAt((int)i)).styledesc, "\n", sReason};
            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("ProdRecallMsg"), objs), StoreParams.res.getString("ProdRecall"), 0);
            break;
        }
        return bRecall;
    }

    public boolean checkForGiftVouchersWithZeroPrice() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getItemAt(i) instanceof StyleLine) || !this.isGiftVoucher(i) || ((StyleLine)this.model.getItemAt(i)).getPrice() != 0.0) continue;
            return true;
        }
        return false;
    }

    public void RefreshImage() {
        if (this.getSelectedRow() > -1 && this.getSelectedRow() < this.getRowCount() && this.model.getItemAt(this.getSelectedRow()) instanceof StyleLine) {
            this.frParent.ChangeImage(((StyleLine)this.model.getItemAt((int)this.getSelectedRow())).stylecode, ((StyleLine)this.model.getItemAt((int)this.getSelectedRow())).styledesc);
        } else {
            this.frParent.ChangeImage("", "");
        }
    }

    private boolean mergeLines(long vshidx, double qty, double taken, double packed) {
        boolean bMerged = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).getVshidx() != vshidx) continue;
            ((StyleLine)this.model.getRow(i)).setQty(((StyleLine)this.model.getRow(i)).getQty() + qty);
            ((StyleLine)this.model.getRow(i)).setTakenQty(((StyleLine)this.model.getRow(i)).getTakenQty() + taken);
            ((StyleLine)this.model.getRow(i)).setPackedQty(((StyleLine)this.model.getRow(i)).getPackedQty() + packed);
            bMerged = true;
            this.model.fireTableRowsUpdated(i, i);
            break;
        }
        return bMerged;
    }

    public void packRemaining() {
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).getQty() == ((StyleLine)this.model.getRow(i)).getPackedQty()) continue;
                ((StyleLine)this.model.getRow(i)).setPackedQty(((StyleLine)this.model.getRow(i)).getQty());
                this.model.fireTableRowsUpdated(i, i);
            }
        }
    }

    public void packNonStocked() {
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).getQty() == ((StyleLine)this.model.getRow(i)).getPackedQty() || ((StyleLine)this.model.getRow(i)).getStkFlag() != 0) continue;
                ((StyleLine)this.model.getRow(i)).setPackedQty(((StyleLine)this.model.getRow(i)).getQty());
                this.model.fireTableRowsUpdated(i, i);
            }
        }
    }

    public void cancelNonStocked() {
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                StyleLine line;
                if (!(this.model.getRow(i) instanceof StyleLine) || !((line = (StyleLine)this.model.getRow(i)).getQty() > 0.0) || line.getStkFlag() != 0 || line.getGvNum() != null && !line.getGvNum().isEmpty()) continue;
                ((StyleLine)this.model.getRow(i)).setQty(0.0);
                this.model.fireTableRowsUpdated(i, i);
            }
        }
    }

    public void pickupRemaining() {
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine) || ((StyleLine)this.model.getRow(i)).getPackedQty() == ((StyleLine)this.model.getRow(i)).getTakenQty()) continue;
                ((StyleLine)this.model.getRow(i)).setPickUpQty(((StyleLine)this.model.getRow(i)).getPackedQty() - ((StyleLine)this.model.getRow(i)).getTakenQty());
                this.model.fireTableRowsUpdated(i, i);
            }
        }
    }

    public void clearPickUp() {
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine)) continue;
                ((StyleLine)this.model.getRow(i)).setPickUpQty(0.0);
                this.model.fireTableRowsUpdated(i, i);
            }
        }
    }

    public void clearPacked() {
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine)) continue;
                StyleLine line = (StyleLine)this.model.getRow(i);
                line.setPickUpQty(0.0);
                line.setPackedQty(line.getQty(7));
                this.model.fireTableRowsUpdated(i, i);
            }
        }
    }

    public void cancelRemaining() {
        if (TransTypes.isCustOrder(this.frParent.transType)) {
            Vector<Integer> deleteList = new Vector<Integer>();
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.model.getRow(i) instanceof StyleLine)) continue;
                StyleLine styleRow = (StyleLine)this.model.getRow(i);
                if (styleRow.isNew() && styleRow.getTakenQty() == 0.0) {
                    deleteList.add(new Integer(i));
                    continue;
                }
                if (styleRow.getPickUpQty() != 0.0) {
                    styleRow.setPickUpQty(0.0);
                    this.model.fireTableRowsUpdated(i, i);
                }
                if (styleRow.getPackedQty() != styleRow.getTakenQty()) {
                    styleRow.setPackedQty(styleRow.getTakenQty());
                    this.model.fireTableRowsUpdated(i, i);
                }
                if (styleRow.getQty() == styleRow.getTakenQty()) continue;
                styleRow.setQty(styleRow.getTakenQty());
                this.model.fireTableRowsUpdated(i, i);
            }
            if (deleteList.size() > 0) {
                this.delLines(deleteList, false, true);
            }
        }
    }

    private void setQtyColumnWidth(int col) {
        this.columnModel.getColumn(col).setMinWidth(0);
        this.columnModel.getColumn(col).setMaxWidth(0);
        this.columnModel.getColumn(col).setPreferredWidth(0);
        this.columnModel.getColumn(col).setMaxWidth(130);
        this.columnModel.getColumn(col).setPreferredWidth(90);
        this.columnModel.getColumn(col).setMinWidth(70);
    }

    private void setReturnQtyColumnWidth(int col) {
        this.columnModel.getColumn(col).setMinWidth(0);
        this.columnModel.getColumn(col).setMaxWidth(0);
        this.columnModel.getColumn(col).setPreferredWidth(0);
        this.columnModel.getColumn(col).setMaxWidth(150);
        this.columnModel.getColumn(col).setPreferredWidth(140);
        this.columnModel.getColumn(col).setMinWidth(130);
    }

    private void setCurrencyColumnWidth(int col) {
        this.columnModel.getColumn(col).setMinWidth(70);
        this.columnModel.getColumn(col).setPreferredWidth(90);
        this.columnModel.getColumn(col).setMaxWidth(150);
        this.columnModel.getColumn(col).setMaxWidth(150);
        this.columnModel.getColumn(col).setPreferredWidth(90);
        this.columnModel.getColumn(col).setMinWidth(70);
    }

    private void hideColumn(int col) {
        this.columnModel.getColumn(col).setMinWidth(0);
        this.columnModel.getColumn(col).setPreferredWidth(0);
        this.columnModel.getColumn(col).setMaxWidth(0);
    }

    public Vector<IActionDetailLogWriter> getRowsToLog() {
        Vector<IActionDetailLogWriter> logRows = new Vector<IActionDetailLogWriter>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getItemAt(i) instanceof StyleLine)) continue;
            logRows.add((StyleLine)this.model.getItemAt(i));
        }
        return logRows;
    }

    public Vector<StyleLine> getStyleLines() {
        Vector<StyleLine> lines = new Vector<StyleLine>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getRow(i) instanceof StyleLine)) continue;
            lines.add((StyleLine)this.model.getRow(i));
        }
        return lines;
    }

    public Vector<StyleLine> getTaxLookupStyleLines() {
        Vector<StyleLine> lines = new Vector<StyleLine>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            StyleLine line;
            if (!(this.model.getRow(i) instanceof StyleLine) || !(line = (StyleLine)this.model.getRow(i)).requiresTaxLookup()) continue;
            lines.add(line);
        }
        return lines;
    }

    public void setCanEditTax(boolean canEditTax) {
        this.model.setCanEditTax(canEditTax);
    }

    public boolean externalTaxLookup(boolean allowLogging) {
        block3: {
            ITaxLookup taxLookup;
            Vector<StyleLine> styleLines;
            if (!(this.frParent.frameType != 1 && this.frParent.frameType != 12 || this.frParent.isTaxLookupDisabled() || (styleLines = this.getTaxLookupStyleLines()).size() <= 0 || (taxLookup = TaxLookupFactory.getTaxLookup()) == null)) {
                block4: {
                    int response;
                    do {
                        TaxLookupDeliveryInfo taxDelivInfo;
                        TaxLookupPerson taxPerson;
                        if (taxLookup.calculateTax(styleLines, taxPerson = new TaxLookupPerson(((FrSales)this.frParent).getPerson()), taxDelivInfo = new TaxLookupDeliveryInfo(((FrSales)this.frParent).deliveryInfo, ((FrSales)this.frParent).despatchInfo), allowLogging)) {
                            this.model.fireTableDataChanged();
                            break block3;
                        }
                        String errorMessage = taxLookup.getLastErrorMessage();
                        if (errorMessage.length() <= 0) break block4;
                        DlgMessage dlgMessage = new DlgMessage(this.frParent, SP.getRS("Tax_Lookup_Failed"), errorMessage, 1, 0);
                        dlgMessage.getYesButton().setText(SP.getRS("Tax_Lookup_Retry"));
                        dlgMessage.getNoButton().setText(SP.getRS("Tax_Lookup_Disable"));
                        dlgMessage.getCancelButton().setText(SP.getRS("Tax_Lookup_Close"));
                        dlgMessage.setCloseAction(2);
                        response = dlgMessage.showMessage();
                        if (response != 1) continue;
                        this.frParent.setTaxLookupDisabledForTransaction(true);
                        return false;
                    } while (response != 2);
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public double getLoyaltyTotal(long loyaltyIdx) {
        double total = 0.0;
        for (int i = 0; i < this.model.getData().size(); ++i) {
            DiscLine disc;
            if (!(this.model.getData().elementAt(i) instanceof DiscLine) || !(disc = (DiscLine)this.model.getData().elementAt(i)).isLoyalty() || disc.getDiscParent().getLoyalty().getIdx() != loyaltyIdx || !disc.isNew()) continue;
            total += disc.getNetUnrounded();
        }
        return this.sParams.rnd(total);
    }

    public double getReturnedRewardsTotal() {
        double total = 0.0;
        for (int i = 0; i < this.model.getData().size(); ++i) {
            DiscLine disc;
            if (!(this.model.getData().elementAt(i) instanceof DiscLine) || (disc = (DiscLine)this.model.getData().elementAt(i)).isNew() || !disc.isRewardsLoyalty() && (!disc.isRewardsDiscount() || disc.getStyleParent().getGift() != null)) continue;
            total -= disc.getNetUnrounded();
        }
        return this.sParams.rnd(total);
    }

    public Vector<Gift> getGifts() {
        Vector<Gift> gifts = new Vector<Gift>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            StyleLine line;
            if (!(this.model.getRow(i) instanceof StyleLine) || !(line = (StyleLine)this.model.getRow(i)).isNew() || line.getGift() == null) continue;
            gifts.add(line.getGift());
        }
        return gifts;
    }

    public Vector<StyleLine> getGiftLines() {
        Vector<StyleLine> giftLines = new Vector<StyleLine>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            StyleLine line;
            if (!(this.model.getRow(i) instanceof StyleLine) || !(line = (StyleLine)this.model.getRow(i)).isNew() || line.getGift() == null) continue;
            giftLines.add(line);
        }
        return giftLines;
    }

    public boolean isCouponUsed() {
        for (int i = 0; i < this.model.getData().size(); ++i) {
            DiscLine disc;
            if (!(this.model.getData().elementAt(i) instanceof DiscLine) || !(disc = (DiscLine)this.model.getData().elementAt(i)).isNew() || !disc.isCoupon()) continue;
            return true;
        }
        return false;
    }

    private void setPriceColumnWidthAfterRemovingTax(int col) {
        this.columnModel.getColumn(col).setMinWidth(70);
        this.columnModel.getColumn(col).setPreferredWidth(110);
        this.columnModel.getColumn(col).setMaxWidth(150);
    }

    public void removeTax() {
        if (!this.taxRemoved) {
            this.model.removeTax();
            if (this.frParent.frameType == 1) {
                this.setColumnName(7, SP.getRS("Price_no_tax"));
                this.setPriceColumnWidthAfterRemovingTax(7);
            } else if (this.frParent.frameType == 12) {
                this.setColumnName(9, SP.getRS("Price_no_tax"));
                this.setPriceColumnWidthAfterRemovingTax(9);
            }
            this.taxRemoved = true;
        }
    }

    public boolean validateTransactionForOverReturns() {
        if (this.frParent.transnum != null && this.frParent.transnum != "") {
            for (int i = 0; i < this.getRowCount(); ++i) {
                double retQuant;
                double qty;
                StyleLine line;
                double origiqty;
                double quantityBalance;
                if (!(this.model.getRow(i) instanceof StyleLine) || !((quantityBalance = (origiqty = (line = (StyleLine)this.model.getRow(i)).getOriginalQuantity()) + ((qty = line.getQty()) - (retQuant = line.getReturnedQuantity()))) < 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public Map<String, Vector<String>> getAllTransactionReturnErrors() {
        HashMap<String, Vector<String>> returns = new HashMap<String, Vector<String>>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!(this.model.getRow(i) instanceof StyleLine)) continue;
            StyleLine line = (StyleLine)this.model.getRow(i);
            double origiqty = line.getOriginalQuantity();
            double qty = line.getQty();
            double retQuant = line.getReturnedQuantity();
            double quantityBalance = origiqty + (qty - retQuant);
            String skucode = line.getSkuCode().replace('.', ' ');
            if (!(quantityBalance < 0.0) || !(qty < 0.0)) continue;
            if (line.getOverReturns().isEmpty()) {
                returns.put(skucode, new Vector());
                continue;
            }
            returns.put(skucode, line.getOverReturns());
        }
        return returns;
    }

    public boolean isQtyValid() {
        boolean isValid = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            StyleLine line;
            double qty;
            if (!(this.model.getRow(i) instanceof StyleLine) || (qty = (line = (StyleLine)this.model.getRow(i)).getQty()) == 0.0) continue;
            isValid = true;
        }
        return isValid;
    }

    public boolean confirmReturnMode() {
        boolean isReturn = false;
        int width = this.columnModel.getColumn(6).getWidth();
        if (width != 0) {
            isReturn = true;
        }
        return isReturn;
    }

    static {
        PromotionUtils.preInitialiseDiscountEngine();
    }
}

