/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.Connection;
import java.util.ArrayList;
import jpos.PosUtils;
import jpos.SqlQuery;
import jpos.StoreParams;

public class SystemSettings {
    private ArrayList<SystemParameter> systemParameters = new ArrayList();
    private static SystemSettings instance;

    private SystemSettings() {
        this.loadSystemSettings();
    }

    public static SystemSettings getInstance() {
        if (instance == null) {
            try {
                instance = new SystemSettings();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }

    public static void reload() {
        try {
            instance = new SystemSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadSystemSettings() {
        try (Connection con = StoreParams.createNewConnection();
             SqlQuery sql = new SqlQuery(con, "SELECT paridx, parlnkidx, parstr FROM SYSPARAM");){
            while (sql.next()) {
                SystemSetting systemSetting = SystemSetting.getSystemSetting(sql.getLong(1));
                if (systemSetting == null) continue;
                this.systemParameters.add(new SystemParameter(systemSetting, sql.getLong(2), sql.getString(3)));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public boolean getBoolean(SystemSetting setting) {
        return this.getNumber(setting) == 1L;
    }

    public long getNumber(SystemSetting setting) {
        for (SystemParameter s : this.systemParameters) {
            if (s.systemSetting != setting) continue;
            return s.parlnkidx;
        }
        return 0L;
    }

    public String getText(SystemSetting setting) {
        for (SystemParameter s : this.systemParameters) {
            if (s.systemSetting != setting) continue;
            return s.parstr == null ? "" : s.parstr;
        }
        return "";
    }

    private class SystemParameter {
        private SystemSetting systemSetting;
        private long parlnkidx;
        private String parstr;

        public SystemParameter(SystemSetting systemSetting, long parlnkidx, String parstr) {
            this.systemSetting = systemSetting;
            this.parlnkidx = parlnkidx;
            this.parstr = parstr;
        }
    }

    public static enum SystemSetting {
        DEFAULT_COMPANY(27L),
        AUTO_FREIGHT_CALCULATION(245L),
        DEFAULT_SKUS(477L),
        CONSOLIDATE_STOCK_TAKE_LINES(502L),
        AUTO_INTER_COMPANY_TRANS(531L),
        LB_SO_POSTING_METHOD(537L),
        EDIT_LOALTY_AT_STORE(562L),
        SALES_PERSON_WORKGROUP(563L),
        TRAINING_USERS(566L),
        MADE_TO_MEASURE(592L),
        PROMPT_FOR_CUST_ENTRY_SCREEN(593L),
        MAIL_ORDER_SETUP(598L),
        REFERENCES_TO_PROMPT_FOR(613L),
        ENFORCE_FORMATTING_IN_PERSON_MAINT(621L),
        CREDIT_NOTE_AND_GIFT_VOUCHER_SETUP(627L),
        MAX_SALES_REPS_IN_LIST(647L),
        PROMPT_FOR_ACCOUNT_PAYMENT(652L),
        USE_EXTENDED_TAX(653L),
        RETAIL_PLANNING_PERIODS(660L),
        BUDGETS(662L),
        STOCK_ENQUIRY_SETUP(675L),
        DISPLAY_POS_PERSON_SPENDING(685L),
        TRANS_OUT_CONNOTE_MANDATORY(693L),
        DEFAULT_VOUCHER_VALUE_TO_REFUND_AMOUNT(695L),
        FORCE_CUSTOMER_ENTRY_FOR_RETURNS(696L),
        PROMPT_FOR_DIGITAL_RECEIPT(699L),
        DEFAULT_STOCK_ADJ_REFERENCES(701L),
        LABEL_PRINTING(702L),
        EMAIL_VALIDATION_FORMULA(703L),
        PROMPT_FOR_PRICE_OVERRIDE_REASON(705L),
        PRINT_DOCKET_ON_OPEN_TILL(706L),
        PROMPT_FOR_BANK_BAG_NUMBER(707L),
        ENFORCE_START_OF_DAY_TILL_BALANCE(708L),
        ENFORCE_PHONE_NUM_VALIDATION(710L),
        EXTENDED_LOYALTY_PROGRAM(711L),
        POS_PERSON_REFERENCES(712L),
        SHIP_FROM_STORE(714L),
        EXTENDED_SIGNATURE_PANEL_ON_RETURN_DOCKETS(716L),
        MANDATORY_PERSON_EMAIL(728L),
        SHOW_SOH_IN_CUST_ORDERS(729L),
        SHOW_PERSON_MAINT_ON_LOYALTY_SCAN(733L),
        OMNEO_LOYALTY_SETUP(734L),
        AUTO_PROMPT_FOR_LOYALTY_AMOUNT(735L),
        SHOW_SALES_REP_ON_DOCKET(737L),
        SAVE_SPACE_ON_DOCKET(738L),
        PREVENT_TRANSFER_OF_INELIGIBLE_PRODUCTS(740L),
        CREATE_FLOOR_TO_DOOR_ORDERS(747L),
        AUTO_ROUNDING_FOR_ORDER_PAYMENT_VARIANCE(749L),
        OUTSTANDING_ORDER_DIALOG(753L),
        RETAIL_REWARDS(760L),
        RECEIVING_PO_BY_ASN(762L),
        PROMPT_FOR_BAGS(763L),
        STOCK_RECEIPT_BY_CARTON(765L),
        STOCK_RECEIPT_FORCE_SCAN(766L),
        AUTO_PRINT_DISPLAY_LABELS_ON_RECEIPT(768L),
        TRANSFER_OUT_FORCE_SCAN(769L),
        PICKLIST_REFERENCE(773L),
        PERSON_SEARCH(774L),
        KLEBER_DATA_VERIFICATION(779L),
        TRANSFER_OUT_UNDER_TRANSFER_WARNING(782L),
        AP21_INSIGHT(786L),
        UPDATE_TRANSFER_CONNOTE(790L),
        ORDER_REASSIGNMENT_REASON_REQUIRED(800L),
        PROMPT_MANAGER_OVERRIDE_FOR_REWARDS_PROGRAM(801L),
        REDEEM_COUPONS_AT_POS(805L),
        CAPILLARY_LOYALTY_SETUP(806L),
        SHOW_SOH_IN_STOCK_RECEIPTS(808L),
        RECEIPT_PER_CARTON(809L),
        EMAIL_MANDATORY_WHEN_MARKETING_TICKED(810L);

        private long paridx;

        private SystemSetting(long paridx) {
            this.paridx = paridx;
        }

        public long getParidx() {
            return this.paridx;
        }

        public static SystemSetting getSystemSetting(long paridx) throws Exception {
            for (SystemSetting s : SystemSetting.values()) {
                if (s.getParidx() != paridx) continue;
                return s;
            }
            return null;
        }
    }
}

