/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.PreparedStatement;
import jpos.SP;
import jpos.StoreParams;
import jpos.pay.PayTypes;

public class Tender {
    private long typeidx = 0L;
    private double amt = 0.0;
    StoreParams sParams;

    public Tender(long ptypeidx, double pamt, StoreParams psParams) {
        this.sParams = psParams;
        this.typeidx = ptypeidx;
        this.amt = pamt;
    }

    public String toString() {
        if (SP.sParams == null) {
            return "";
        }
        try {
            return PayTypes.getPayType((long)this.typeidx).code;
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setAmt(double pAmt) {
        this.amt = pAmt;
    }

    public long getIdx() {
        return this.typeidx;
    }

    public void db_insert_tender() throws Exception {
        if (this.amt != 0.0) {
            try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("INSERT INTO RET_TRANP(VSHIDX, VHIDX, \"ACTIVE\", PAYMENT_AMOUNT, PAYMENT_TYPEIDX, SEQUENCE_NUMBER)  SELECT ?, ?, 1, ?, ?, COALESCE(MAX(SEQUENCE_NUMBER), -1)+1  FROM RET_TRANP WHERE VHIDX = ?");){
                prepStmt.setLong(1, this.sParams.nextVal("XRET_TRANP"));
                prepStmt.setLong(2, this.sParams.currVal("XRET_TRANH"));
                prepStmt.setDouble(3, this.amt);
                prepStmt.setLong(4, this.typeidx);
                prepStmt.setLong(5, this.sParams.currVal("XRET_TRANH"));
                prepStmt.executeUpdate();
            }
        }
    }
}

