/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import jpos.Note;
import jpos.PosDateFormatter;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.XMLUtils;
import jpos.basscom.utils.Utils;
import jpos.crypt.PersonCrypt;
import jpos.crypt.StringTransform;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class XMLLocal {
    public static StoreParams sParams = null;

    public static Element getElement(Connection conn, String type, String params) throws Exception {
        if (type.equals("person")) {
            return XMLLocal.getPerson(conn, params);
        }
        if (type.equals("loyalty")) {
            return XMLLocal.getLoyalty(conn, params);
        }
        if (type.equals("saveperson")) {
            return XMLLocal.savePersonXML(conn, params);
        }
        if (type.equals("saveofflineperson")) {
            return XMLLocal.saveOfflinePersonXML(conn, params);
        }
        throw new Exception("XMLLocal type not found - " + type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Element getPerson(Connection conn, String peridx) {
        String perSql = "select P.PERIDX, P.CODE, P.FIRSTNAME, P.SURNAME, P.CUSTIDX,\n P.PHONE, P.EMAIL, P.POSTCODE, \n P.REF1, P.REF2, P.REF3, P.REF4, P.REF5, P.REF6, P.REF7, P.REF8, P.REF9, P.REF10, \n P.TAX_EXEMPTIDX, P.TAX_EXEMPT_CERTIFICATE,\n PO.MAIN_PHONE as OFFLINE_PHONE, PO.EMAIL as OFFLINE_EMAIL,\n PL.LOYALIDX, PL.RCIDX, PL.EXPIRY, PL.LTOT, PL.CARDNO, PL.CREDIT_STATUS,\n LR.CODE as LOYALTYCODE,\n MEM.MEMIDX, MEM.MEMNAME, MEM.MEMPWD,\n C.CODE as CUSTCODE, C.NAME, \n CURRENT_DATE \n from PERSON P\n left outer join PERSON_OFFLINE PO on PO.PERIDX = P.PERIDX\n left outer join PERLOYALTY PL on PL.PERIDX = P.PERIDX and PL.\"ACTIVE\"=1\n left outer join REFCODE LR on LR.RCIDX = PL.RCIDX\n left outer join MEMBER MEM on MEM.MEMIDX = P.MEMIDX and MEM.\"ACTIVE\" = 1\n left outer join CUST C on C.CUSTIDX = P.CUSTIDX\n where P.\"ACTIVE\" = 1 and P.PERIDX = " + peridx + "\n order by PL.EXPIRY";
        try (SqlQuery sql = new SqlQuery(conn, perSql);){
            Element person = new Element("person");
            if (sql.next()) {
                person.setAttribute("peridx", peridx);
                person.setAttribute("loaded_offline", "true");
                if (sql.getString("CODE") != null) {
                    person.setAttribute("code", sql.getString("CODE"));
                }
                if (sql.getString("FIRSTNAME") != null) {
                    person.setAttribute("firstname", sql.getString("FIRSTNAME"));
                }
                if (sql.getString("SURNAME") != null) {
                    person.setAttribute("surname", sql.getString("SURNAME"));
                }
                if (sql.getString("CUSTIDX") != null) {
                    person.setAttribute("custidx", sql.getString("CUSTIDX"));
                }
                if (sql.getString("CUSTCODE") != null) {
                    person.setAttribute("custcode", sql.getString("CUSTCODE"));
                }
                if (sql.getString("NAME") != null) {
                    person.setAttribute("custname", sql.getString("NAME"));
                }
                if (sql.getString("TAX_EXEMPTIDX") != null) {
                    person.setAttribute("tax_exemptidx", sql.getString("TAX_EXEMPTIDX"));
                }
                if (sql.getString("TAX_EXEMPT_CERTIFICATE") != null) {
                    person.setAttribute("tax_exempt_certificate", sql.getString("TAX_EXEMPT_CERTIFICATE"));
                }
                Element refs = new Element("references");
                for (int i = 1; i <= 10; ++i) {
                    String value = sql.getString("ref" + i);
                    if (StringUtils.isNullOrEmpty(value)) continue;
                    refs.setAttribute("ref" + i, value);
                }
                person.addContent((Content)refs);
                Vector<Element> notes = Note.getNotes(PosUtils.longVal(peridx), "PERSON", conn);
                for (int i = 0; i < notes.size(); ++i) {
                    person.addContent((Content)notes.get(i));
                }
                if (sql.getString("MEMIDX") != null) {
                    Element member = new Element("member");
                    member.setAttribute("memidx", sql.getString("MEMIDX"));
                    member.setAttribute("memname", StringUtils.nullToEmpty(sql.getString("MEMNAME")).toUpperCase());
                    member.setAttribute("mempwd", sql.getString("MEMPWD"));
                    person.addContent((Content)member);
                }
                Element locn = new Element("locn");
                if (sql.getString("POSTCODE") != null) {
                    locn.setAttribute("postcode", sql.getString("POSTCODE"));
                }
                person.addContent((Content)locn);
                Element phone = new Element("phonenum");
                String mainPhone = "";
                if (sql.getBytes("PHONE") != null && sql.getBytes("PHONE").length > 0) {
                    if (PersonCrypt.getInstance().keyExists()) {
                        try {
                            mainPhone = new String(PersonCrypt.getInstance().decryptValue(sql.getBytes("PHONE")));
                        }
                        catch (GeneralSecurityException gse) {
                            phone.setAttribute("encrypted_state", "Decryption_Error");
                        }
                    } else {
                        phone.setAttribute("encrypted_state", "Encrypted");
                    }
                    phone.setText(mainPhone);
                    phone.setAttribute("phonetyidx", "154");
                } else if (sql.getString("OFFLINE_PHONE") != null) {
                    mainPhone = sql.getString("OFFLINE_PHONE");
                    phone.setText(mainPhone);
                    phone.setAttribute("phonetyidx", "154");
                } else {
                    phone.setText("");
                    phone.setAttribute("phonetyidx", "154");
                }
                locn.addContent((Content)phone);
                phone = new Element("phonenum");
                String email = "";
                if (sql.getBytes("EMAIL") != null && sql.getBytes("EMAIL").length > 0) {
                    if (PersonCrypt.getInstance().keyExists()) {
                        try {
                            email = new String(PersonCrypt.getInstance().decryptValue(sql.getBytes("EMAIL")));
                        }
                        catch (GeneralSecurityException gse) {
                            phone.setAttribute("encrypted_state", "Decryption_Error");
                        }
                    } else {
                        phone.setAttribute("encrypted_state", "Encrypted");
                    }
                    phone.setText(email);
                    phone.setAttribute("phonetyidx", "159");
                    locn.addContent((Content)phone);
                } else if (sql.getString("OFFLINE_EMAIL") != null) {
                    email = sql.getString("OFFLINE_EMAIL");
                    phone.setText(email);
                    phone.setAttribute("phonetyidx", "159");
                    locn.addContent((Content)phone);
                }
                if (sql.getString("LOYALIDX") != null) {
                    Element loyalty = new Element("perloyalty");
                    loyalty.setAttribute("loyalidx", sql.getString("LOYALIDX"));
                    if (sql.getString("RCIDX") != null) {
                        loyalty.setAttribute("rcidx", sql.getString("RCIDX"));
                    }
                    if (sql.getString("EXPIRY") != null) {
                        loyalty.setAttribute("expiry", sql.getTimestamp("EXPIRY").toString());
                    }
                    if (sql.getString("LTOT") != null) {
                        loyalty.setAttribute("ltot", sql.getString("LTOT"));
                    }
                    if (sql.getString("CARDNO") != null) {
                        loyalty.setAttribute("cardno", sql.getString("CARDNO"));
                    }
                    if (sql.getString("CREDIT_STATUS") != null) {
                        loyalty.setAttribute("credit_status", sql.getString("CREDIT_STATUS"));
                    }
                    loyalty.setText(sql.getString("LOYALTYCODE"));
                    person.addContent((Content)loyalty);
                    while (sql.next()) {
                        loyalty = new Element("perloyalty");
                        loyalty.setAttribute("loyalidx", sql.getString("LOYALIDX"));
                        if (sql.getString("RCIDX") != null) {
                            loyalty.setAttribute("rcidx", sql.getString("RCIDX"));
                        }
                        if (sql.getString("EXPIRY") != null) {
                            loyalty.setAttribute("expiry", sql.getTimestamp("EXPIRY").toString());
                        }
                        if (sql.getString("LTOT") != null) {
                            loyalty.setAttribute("ltot", sql.getString("LTOT"));
                        }
                        if (sql.getString("CARDNO") != null) {
                            loyalty.setAttribute("cardno", sql.getString("CARDNO"));
                        }
                        if (sql.getString("CREDIT_STATUS") != null) {
                            loyalty.setAttribute("credit_status", sql.getString("CREDIT_STATUS"));
                        }
                        loyalty.setText(sql.getString("LOYALTYCODE"));
                        person.addContent((Content)loyalty);
                    }
                }
            }
            Element element = person;
            return element;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return new Element("error").setAttribute("desc", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Element getLoyalty(Connection conn, String sData) {
        StringTokenizer toks = new StringTokenizer(sData, "@");
        String cardNo = toks.nextToken();
        try (SqlQuery sql = new SqlQuery(conn, "SELECT L.PERIDX FROM PERLOYALTY L, PERSON P WHERE P.PERIDX = L.PERIDX AND L.CARDNO = " + PosUtils.StringToSqlString(cardNo) + " AND L.\"ACTIVE\" = 1 " + XMLLocal.sParams.sWhseRefSecWherePERSON);){
            String peridx = "";
            if (sql.next()) {
                peridx = sql.getString(1);
                Element element2 = XMLLocal.getPerson(conn, peridx);
                return element2;
            }
            Element element = null;
            return element;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return null;
        }
    }

    private static Element getPeopleXML(Connection conn, String idxs) {
        StringTokenizer toks = new StringTokenizer(idxs, ",");
        Element people = new Element("people");
        people.setAttribute("version", PosUtils.getAp21VersionNumber(false));
        while (toks.hasMoreTokens()) {
            Element person = XMLLocal.getPerson(conn, toks.nextToken());
            if (person.getAttribute("peridx") == null) continue;
            people.addContent((Content)person);
        }
        return people;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Element savePersonXML(Connection conn, String spPersondets) {
        StringTokenizer toks = new StringTokenizer(spPersondets, "\u0003");
        String sPersondets = toks.nextToken();
        try {
            Serializable sb;
            boolean bInsertPerson;
            Statement stmt;
            Throwable throwable;
            String memidx;
            String postcode;
            String email;
            String mainPhone;
            Element retIdxs;
            Element person;
            block183: {
                SAXBuilder builder = new SAXBuilder(false);
                person = builder.build((Reader)new StringReader(sPersondets)).getRootElement();
                retIdxs = new Element("person");
                retIdxs.setAttribute("version", PosUtils.getAp21VersionNumber(false));
                List<Object> peridxs = new ArrayList();
                mainPhone = "";
                email = "";
                postcode = "";
                if (person.getChild("locn") != null) {
                    if (person.getChild("locn").getAttribute("postcode") != null) {
                        postcode = person.getChild("locn").getAttribute("postcode").getValue();
                    }
                    List phonenums = person.getChild("locn").getChildren("phonenum");
                    for (int i = 0; i < phonenums.size(); ++i) {
                        if (((Element)phonenums.get(i)).getAttribute("phonetyidx").getValue().equals("154")) {
                            mainPhone = ((Element)phonenums.get(i)).getText();
                            continue;
                        }
                        if (!((Element)phonenums.get(i)).getAttribute("phonetyidx").getValue().equals("159")) continue;
                        email = ((Element)phonenums.get(i)).getText();
                    }
                }
                if (!sParams.checkIConn() && person.getAttribute("peridx") == null && (peridxs = XMLLocal.localPersonCheck(conn, email, mainPhone, person)).size() > 0) {
                    return XMLLocal.getPeopleXML(conn, String.join((CharSequence)",", peridxs));
                }
                memidx = "null";
                if (person.getChild("member") != null) {
                    try {
                        Element member = person.getChild("member");
                        retIdxs.addContent((Content)new Element("member"));
                        if (XMLLocal.isMemberNameInUse(conn, member)) {
                            retIdxs.getChild("member").setAttribute("error", "MEMNAME_IN_USE");
                            break block183;
                        }
                        boolean bInsertMember = false;
                        if (member.getAttribute("memidx") != null) {
                            memidx = member.getAttribute("memidx").getValue();
                            if (member.getAttribute("memfull") != null) {
                                String mSql = "UPDATE MEMBER SET MEMNAME = " + PosUtils.StringToSqlString(member.getAttribute("memname").getValue()).toUpperCase() + ", MEMFULL = " + PosUtils.StringToSqlString(member.getAttribute("memfull").getValue()) + ", MEMPWD = " + PosUtils.StringToSqlString(member.getAttribute("mempwd").getValue()) + ", EMAIL = " + PosUtils.StringToSqlString(member.getAttribute("email").getValue()) + ", UPMEMIDX = " + person.getAttribute("upmemidx").getValue() + ", UPDT = CURRENT_TIMESTAMP\n WHERE MEMIDX = " + memidx;
                                throwable = null;
                                try (Statement stmt2 = conn.createStatement();){
                                    stmt2.execute(mSql);
                                    bInsertMember = stmt2.getUpdateCount() == 0;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                if (bInsertMember) {
                                    stmt2 = conn.createStatement();
                                    throwable = null;
                                    try {
                                        stmt2.executeUpdate("INSERT INTO MEMBER(MEMIDX, MEMNAME, MEMFULL, MEMPWD, EMAIL, LOGIDX, \"ACTIVE\", UPMEMIDX, UPDT) VALUES (" + memidx + ", " + PosUtils.StringToSqlString(member.getAttribute("memname").getValue()).toUpperCase() + ", " + PosUtils.StringToSqlString(member.getAttribute("memfull").getValue()) + ", " + PosUtils.StringToSqlString(member.getAttribute("mempwd").getValue()) + ", " + PosUtils.StringToSqlString(member.getAttribute("email").getValue()) + ", " + String.valueOf(PosUtils.longVal(memidx) * 23L + 51L) + ", 1, " + person.getAttribute("upmemidx").getValue() + ", CURRENT_TIMESTAMP)");
                                    }
                                    catch (Throwable throwable3) {
                                        throwable = throwable3;
                                        throw throwable3;
                                    }
                                    finally {
                                        if (stmt2 != null) {
                                            if (throwable != null) {
                                                try {
                                                    stmt2.close();
                                                }
                                                catch (Throwable throwable4) {
                                                    throwable.addSuppressed(throwable4);
                                                }
                                            } else {
                                                stmt2.close();
                                            }
                                        }
                                    }
                                    long workgrp = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.SALES_PERSON_WORKGROUP);
                                    if (workgrp > 0L) {
                                        stmt = conn.createStatement();
                                        Throwable throwable5 = null;
                                        try {
                                            stmt.executeUpdate("INSERT INTO GRPMEM(GRPIDX, MEMIDX) VALUES(" + workgrp + ", " + memidx + ")");
                                        }
                                        catch (Throwable throwable6) {
                                            throwable5 = throwable6;
                                            throw throwable6;
                                        }
                                        finally {
                                            if (stmt != null) {
                                                if (throwable5 != null) {
                                                    try {
                                                        stmt.close();
                                                    }
                                                    catch (Throwable throwable7) {
                                                        throwable5.addSuppressed(throwable7);
                                                    }
                                                } else {
                                                    stmt.close();
                                                }
                                            }
                                        }
                                        retIdxs.getChild("member").addContent((Content)new Element("grp").setAttribute("grpidx", String.valueOf(workgrp)));
                                    }
                                }
                            }
                            retIdxs.getChild("member").setAttribute("memidx", memidx);
                            break block183;
                        }
                        retIdxs.getChild("member").setAttribute("error", "CANT_CREATE_MEMBER");
                    }
                    catch (SQLException e) {
                        retIdxs.getChild("member").setAttribute("error", "MEMNAME_IN_USE");
                    }
                }
            }
            if (retIdxs.getAttribute("error") != null || retIdxs.getChild("member") != null && retIdxs.getChild("member").getAttribute("error") != null) return retIdxs;
            String retail_rep = person.getChild("member") != null && person.getChild("member").getAttribute("memfull") != null ? ", RETAIL_REP = 1 " : "";
            boolean bExistingPerson = person.getAttribute("peridx") != null;
            boolean bl = bInsertPerson = !bExistingPerson;
            if (bInsertPerson) {
                if (person.getAttribute("prefetch_peridx") == null) throw new IllegalStateException("PERIDX need to be prefetched before being inserted into the local database");
                person.setAttribute("peridx", person.getAttributeValue("prefetch_peridx"));
            } else {
                throwable = null;
                try (Statement stmt3 = conn.createStatement();){
                    String sql = (person.getAttribute("code") != null ? ", CODE = " + PosUtils.StringToSqlString(person.getAttribute("code").getValue()) : "") + (person.getAttribute("firstname") != null ? ", FIRSTNAME = " + PosUtils.StringToSqlString(person.getAttribute("firstname").getValue()) : "") + (person.getAttribute("surname") != null ? ", SURNAME = " + PosUtils.StringToSqlString(person.getAttribute("surname").getValue()) : "") + (person.getAttribute("active") != null ? ", \"ACTIVE\" = " + PosUtils.intVal(person.getAttribute("active").getValue()) : "") + ", POSTCODE =" + PosUtils.StringToSqlString(postcode) + retail_rep + ", MEMIDX = " + memidx + (person.getAttribute("custidx") != null ? ", CUSTIDX = " + person.getAttribute("custidx").getValue() : "") + (person.getAttribute("tax_exemptidx") != null ? ", TAX_EXEMPTIDX = " + PosUtils.StringToSqlString(person.getAttribute("tax_exemptidx").getValue()) : "") + (person.getAttribute("tax_exempt_certificate") != null ? ", TAX_EXEMPT_CERTIFICATE = " + PosUtils.StringToSqlString(person.getAttribute("tax_exempt_certificate").getValue()) : "") + (person.getAttribute("widx") != null ? ", WIDX = " + PosUtils.StringToSqlString(person.getAttribute("widx").getValue()) : "") + (person.getAttribute("updt") != null ? ", UPDT = " + PosUtils.StringToSqlString(person.getAttribute("updt").getValue()) : "") + "\n WHERE PERIDX = " + person.getAttributeValue("peridx");
                    sql = sql.substring(1);
                    stmt3.execute("UPDATE PERSON SET " + sql);
                    bInsertPerson = stmt3.getUpdateCount() == 0;
                }
                catch (Throwable sql) {
                    throwable = sql;
                    throw sql;
                }
                if (!bInsertPerson && person.getChild("references") != null) {
                    Object ref;
                    Element refs = person.getChild("references");
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append("UPDATE PERSON SET ");
                    for (int i = 1; i <= 10; ++i) {
                        ref = refs.getAttribute("ref" + i);
                        if (ref != null) {
                            sb2.append(String.format(" REF%s = %s,", String.valueOf(i), PosUtils.StringToSqlString(ref.getValue())));
                            continue;
                        }
                        sb2.append(String.format(" REF%s = NULL,", String.valueOf(i)));
                    }
                    sb2.delete(sb2.length() - 1, sb2.length());
                    sb2.append(" WHERE PERIDX = " + person.getAttribute("peridx").getValue());
                    stmt = conn.createStatement();
                    ref = null;
                    try {
                        stmt.execute(sb2.toString());
                    }
                    catch (Throwable throwable8) {
                        ref = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (stmt != null) {
                            if (ref != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable9) {
                                    ((Throwable)ref).addSuppressed(throwable9);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
            }
            if (bInsertPerson) {
                Element refs;
                String custidx = "NULL";
                if (person.getAttribute("custidx") != null) {
                    custidx = person.getAttribute("custidx").getValue();
                }
                String createdDate = "CURRENT_TIMESTAMP";
                String widx = PosUtils.StringToSqlString(String.valueOf(sParams.getStoreIdx()));
                if (bExistingPerson) {
                    String origCreatedDate = XMLUtils.getValue(person, "cdat");
                    if (!StringUtils.isNullOrEmpty(origCreatedDate)) {
                        createdDate = PosUtils.StringToSqlString(origCreatedDate);
                    }
                    widx = !StringUtils.isNullOrEmpty(widx = XMLUtils.getValue(person, "widx")) ? PosUtils.StringToSqlString(widx) : "NULL";
                } else {
                    person.setAttribute("widx", widx);
                }
                try (Statement stmt4 = conn.createStatement();){
                    String sqlValues = person.getAttribute("peridx").getValue() + ", " + PosUtils.intVal(person.getAttribute("active") != null ? person.getAttribute("active").getValue() : "1") + ", " + PosUtils.StringToSqlString(person.getAttribute("code") != null ? person.getAttribute("code").getValue() : "") + ", " + PosUtils.StringToSqlString(person.getAttribute("firstname") != null ? person.getAttribute("firstname").getValue() : "") + ", " + PosUtils.StringToSqlString(person.getAttribute("surname") != null ? person.getAttribute("surname").getValue() : "") + ", " + PosUtils.StringToSqlString(postcode) + ", " + (retail_rep.isEmpty() ? "0" : "1") + ", " + memidx + ", " + custidx + ", " + PosUtils.StringToSqlString(person.getAttribute("tax_exemptidx") != null ? person.getAttribute("tax_exemptidx").getValue() : "") + ", " + PosUtils.StringToSqlString(person.getAttribute("tax_exempt_certificate") != null ? person.getAttribute("tax_exempt_certificate").getValue() : "") + ", " + PosUtils.StringToSqlString(person.getAttribute("widx") != null ? person.getAttribute("widx").getValue() : "") + ", " + PosUtils.StringToSqlString(person.getAttribute("updt") != null ? person.getAttribute("updt").getValue() : "");
                    stmt4.executeUpdate(" INSERT INTO PERSON (PERIDX, ACTIVE, CODE, FIRSTNAME, SURNAME, POSTCODE, RETAIL_REP, MEMIDX, CUSTIDX , TAX_EXEMPTIDX, TAX_EXEMPT_CERTIFICATE, WIDX, UPDT)  VALUES (" + sqlValues + ")");
                }
                if (!bExistingPerson) {
                    Utils.CopyLikeReferences(conn, 18L, "WHSE", "WIDX", sParams.getStoreIdx(), 12L, "PERSON", "PERIDX", person.getAttribute("peridx").getLongValue());
                }
                if ((refs = person.getChild("references")) != null) {
                    Object ref;
                    sb = new StringBuilder();
                    for (int i = 1; i <= 10; ++i) {
                        ref = refs.getAttribute("ref" + i);
                        if (ref == null || StringUtils.isNullOrEmpty(ref.getValue())) continue;
                        ((StringBuilder)sb).append(String.format(" REF%s = %s,", String.valueOf(i), PosUtils.StringToSqlString(ref.getValue())));
                    }
                    if (((StringBuilder)sb).length() > 0) {
                        ((StringBuilder)sb).delete(((StringBuilder)sb).length() - 1, ((StringBuilder)sb).length());
                        ((StringBuilder)sb).insert(0, "UPDATE PERSON SET ");
                        ((StringBuilder)sb).append(" WHERE PERIDX = " + person.getAttribute("peridx").getValue());
                        Statement stmt5 = conn.createStatement();
                        ref = null;
                        try {
                            stmt5.execute(((StringBuilder)sb).toString());
                        }
                        catch (Throwable throwable10) {
                            ref = throwable10;
                            throw throwable10;
                        }
                        finally {
                            if (stmt5 != null) {
                                if (ref != null) {
                                    try {
                                        stmt5.close();
                                    }
                                    catch (Throwable throwable11) {
                                        ((Throwable)ref).addSuppressed(throwable11);
                                    }
                                } else {
                                    stmt5.close();
                                }
                            }
                        }
                    }
                }
            }
            if (PersonCrypt.getInstance().keyExists()) {
                SqlQuery.executeUpdate(conn, "UPDATE PERSON SET PHONE = ?, EMAIL = ? WHERE PERIDX = ?", PersonCrypt.getInstance().encryptValue(mainPhone), PersonCrypt.getInstance().encryptValue(email), person.getAttribute("peridx").getValue());
                PersonCrypt.getInstance().generateBlindIndexes(SP.sParams.conn, "EMAIL", person.getAttribute("peridx").getLongValue(), email, PersonCrypt.EMAIL_TRANSFORMS);
                PersonCrypt.getInstance().generateBlindIndexes(SP.sParams.conn, "PHONE", person.getAttribute("peridx").getLongValue(), mainPhone, PersonCrypt.PHONE_TRANSFORMS);
            }
            retIdxs.setAttribute((Attribute)person.getAttribute("peridx").clone());
            List loyaltys = person.getChildren("perloyalty");
            for (int i = 0; i < loyaltys.size(); ++i) {
                Throwable throwable12;
                PreparedStatement prepStmt;
                boolean bInsertLoyalty;
                Element loyalty = (Element)loyaltys.get(i);
                if (loyalty.getAttribute("loyalidx") != null && loyalty.getAttribute("rcidx") == null) {
                    Statement stmt6 = conn.createStatement();
                    sb = null;
                    try {
                        stmt6.executeUpdate("UPDATE PERLOYALTY SET \"ACTIVE\"=0 WHERE LOYALIDX = " + loyalty.getAttribute("loyalidx").getValue());
                        continue;
                    }
                    catch (Throwable stmt5) {
                        sb = stmt5;
                        throw stmt5;
                    }
                    finally {
                        if (stmt6 != null) {
                            if (sb != null) {
                                try {
                                    stmt6.close();
                                }
                                catch (Throwable stmt5) {
                                    ((Throwable)sb).addSuppressed(stmt5);
                                }
                            } else {
                                stmt6.close();
                            }
                        }
                    }
                }
                if (loyalty.getAttribute("cardno") == null) {
                    String sPeridx = person.getAttribute("peridx").getValue();
                    if (sPeridx.startsWith("-")) {
                        loyalty.setAttribute("cardno", "L" + loyalty.getText() + "S" + sParams.getStore().getStoreNo() + sPeridx.substring(1));
                    } else {
                        loyalty.setAttribute("cardno", "L" + loyalty.getText() + sPeridx);
                    }
                }
                boolean cardAlreadyExists = false;
                try (SqlQuery sql = new SqlQuery(conn, "SELECT LOYALIDX FROM PERLOYALTY  WHERE CARDNO = " + PosUtils.StringToSqlString(loyalty.getAttribute("cardno").getValue()) + " AND PERIDX <> " + retIdxs.getAttribute("peridx").getValue() + " AND \"ACTIVE\"=1");){
                    if (sql.next()) {
                        cardAlreadyExists = true;
                        retIdxs.addContent((Content)new Element("perloyalty").setAttribute("error", "CardNo already in use").setAttribute((Attribute)loyalty.getAttribute("cardno").clone()));
                    }
                }
                if (cardAlreadyExists) continue;
                Date dExpiry = null;
                PosDateFormatter dateFormatter = new PosDateFormatter(null, 3, 3, 0);
                if (loyalty.getAttribute("expiry") != null && !loyalty.getAttribute("expiry").getValue().equals("")) {
                    try {
                        dateFormatter.setTimestampInternal(loyalty.getAttribute("expiry").getValue());
                    }
                    catch (Exception ref) {
                        // empty catch block
                    }
                    if (dateFormatter.getTimestamp() != null) {
                        dExpiry = new Date(dateFormatter.getTimestamp().getTime());
                    }
                }
                boolean bl2 = bInsertLoyalty = loyalty.getAttribute("loyalidx") == null;
                if (bInsertLoyalty) {
                    if (loyalty.getAttribute("prefetch_loyalidx") != null) {
                        loyalty.setAttribute("loyalidx", loyalty.getAttributeValue("prefetch_loyalidx"));
                    } else {
                        loyalty.setAttribute("loyalidx", "-" + sParams.nextVal("XPERLOYALTY"));
                    }
                } else {
                    prepStmt = conn.prepareStatement("UPDATE PERLOYALTY SET RCIDX = ?, EXPIRY = ?, CARDNO = ?  WHERE (LOYALIDX = ?) OR (LOYALIDX = ? AND WIDX = ?) ");
                    throwable12 = null;
                    try {
                        prepStmt.setLong(1, PosUtils.longVal(loyalty.getAttribute("rcidx").getValue()));
                        prepStmt.setDate(2, dExpiry);
                        prepStmt.setString(3, loyalty.getAttribute("cardno").getValue());
                        prepStmt.setLong(4, PosUtils.longVal(loyalty.getAttribute("loyalidx").getValue()));
                        if (loyalty.getAttribute("pos_idx") != null) {
                            prepStmt.setLong(5, PosUtils.longVal(loyalty.getAttribute("pos_idx").getValue()));
                        } else {
                            prepStmt.setNull(5, 2);
                        }
                        if (loyalty.getAttribute("widx") != null) {
                            prepStmt.setLong(6, PosUtils.longVal(loyalty.getAttribute("widx").getValue()));
                        } else {
                            prepStmt.setNull(6, 2);
                        }
                        prepStmt.execute();
                        bInsertLoyalty = prepStmt.getUpdateCount() == 0;
                    }
                    catch (Throwable throwable13) {
                        throwable12 = throwable13;
                        throw throwable13;
                    }
                    finally {
                        if (prepStmt != null) {
                            if (throwable12 != null) {
                                try {
                                    prepStmt.close();
                                }
                                catch (Throwable throwable14) {
                                    throwable12.addSuppressed(throwable14);
                                }
                            } else {
                                prepStmt.close();
                            }
                        }
                    }
                }
                if (bInsertLoyalty) {
                    prepStmt = conn.prepareStatement("INSERT INTO PERLOYALTY (LOYALIDX, PERIDX, RCIDX, EXPIRY, CARDNO, WIDX, \"ACTIVE\") VALUES (?, ?, ?, ?, ?, ?, 1)");
                    throwable12 = null;
                    try {
                        prepStmt.setLong(1, PosUtils.longVal(loyalty.getAttribute("loyalidx").getValue()));
                        prepStmt.setLong(2, PosUtils.longVal(person.getAttribute("peridx").getValue()));
                        prepStmt.setLong(3, PosUtils.longVal(loyalty.getAttribute("rcidx").getValue()));
                        prepStmt.setDate(4, dExpiry);
                        prepStmt.setString(5, loyalty.getAttribute("cardno").getValue());
                        if (loyalty.getAttribute("loyalidx").getValue().startsWith("-")) {
                            prepStmt.setLong(6, sParams.getStoreIdx());
                        } else {
                            prepStmt.setNull(6, 2);
                        }
                        prepStmt.executeUpdate();
                    }
                    catch (Throwable throwable15) {
                        throwable12 = throwable15;
                        throw throwable15;
                    }
                    finally {
                        if (prepStmt != null) {
                            if (throwable12 != null) {
                                try {
                                    prepStmt.close();
                                }
                                catch (Throwable throwable16) {
                                    throwable12.addSuppressed(throwable16);
                                }
                            } else {
                                prepStmt.close();
                            }
                        }
                    }
                }
                retIdxs.addContent((Content)new Element("perloyalty").setAttribute((Attribute)loyalty.getAttribute("loyalidx").clone()).setAttribute((Attribute)loyalty.getAttribute("cardno").clone()));
            }
            return retIdxs;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            Element elem = new Element("error");
            return elem.setAttribute("desc", e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMemberNameInUse(Connection connection, Element member) {
        if (member == null) return false;
        if (member.getAttribute("memname") == null) {
            return false;
        }
        String memidx = member.getAttribute("memidx") == null ? "0" : StringUtils.nullToValue(member.getAttribute("memidx").getValue(), "0");
        try (PreparedStatement stmt = connection.prepareStatement("SELECT MEMIDX FROM MEMBER WHERE MEMIDX != ? AND UPPER(MEMNAME) = ?");){
            stmt.setString(1, memidx);
            stmt.setString(2, StringUtils.nullToEmpty(member.getAttribute("memname").getValue()).toUpperCase());
            try (ResultSet result = stmt.executeQuery();){
                if (!result.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    private static Element saveOfflinePersonXML(Connection conn, String spPersondets) {
        StringTokenizer toks = new StringTokenizer(spPersondets, "\u0003");
        String sPersondets = toks.nextToken();
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Element person = builder.build((Reader)new StringReader(sPersondets)).getRootElement();
            Element retIdxs = new Element("person");
            retIdxs.setAttribute("version", PosUtils.getAp21VersionNumber(false));
            List<Object> peridxs = new ArrayList();
            String mainPhone = "";
            String email = "";
            List phonenums = person.getChild("locn").getChildren("phonenum");
            for (int i = 0; i < phonenums.size(); ++i) {
                if (((Element)phonenums.get(i)).getAttribute("phonetyidx").getValue().equals("154")) {
                    mainPhone = ((Element)phonenums.get(i)).getText();
                    continue;
                }
                if (!((Element)phonenums.get(i)).getAttribute("phonetyidx").getValue().equals("159")) continue;
                email = ((Element)phonenums.get(i)).getText();
            }
            if (person.getAttribute("peridx") == null) {
                peridxs = XMLLocal.localPersonCheck(conn, email, mainPhone, person);
                if (peridxs == null) {
                    return null;
                }
                if (peridxs.size() > 0) {
                    return XMLLocal.getPeopleXML(conn, String.join((CharSequence)",", peridxs));
                }
            }
            if (retIdxs.getAttribute("error") == null && (retIdxs.getChild("member") == null || retIdxs.getChild("member").getAttribute("error") == null)) {
                Object other_phone2;
                Object new_email;
                boolean bInsertPerson;
                boolean bExistingPerson = person.getAttribute("peridx") != null;
                boolean bl = bInsertPerson = !bExistingPerson;
                if (!bInsertPerson) {
                    throw new IllegalStateException("Cannot modify people offline");
                }
                person.setAttribute("peridx", "-" + sParams.nextVal("XPERSON"));
                if (bInsertPerson) {
                    Element customDataElement;
                    Element refs;
                    Throwable phonenum;
                    String widx = PosUtils.StringToSqlString(String.valueOf(sParams.getStoreIdx()));
                    if (bExistingPerson) {
                        throw new IllegalStateException("Cannot modify people offline");
                    }
                    person.setAttribute("widx", widx);
                    Element locn = null;
                    if (person.getChild("locn") != null) {
                        locn = person.getChild("locn");
                    }
                    String main_phone = "";
                    new_email = "";
                    other_phone2 = "";
                    String work_phone = "";
                    if (locn != null) {
                        List phonenumbers = locn.getChildren("phonenum");
                        for (int i = 0; i < phonenumbers.size(); ++i) {
                            phonenum = (Element)phonenums.get(i);
                            if (phonenum.getAttribute("phonetyidx").getValue().equals("154")) {
                                main_phone = phonenum.getText();
                                continue;
                            }
                            if (phonenum.getAttribute("phonetyidx").getValue().equals("159")) {
                                new_email = phonenum.getText();
                                continue;
                            }
                            if (phonenum.getAttribute("phonetyidx").getValue().equals("536")) {
                                work_phone = phonenum.getText();
                                continue;
                            }
                            if (!phonenum.getAttribute("phonetyidx").getValue().equals("631")) continue;
                            other_phone2 = phonenum.getText();
                        }
                    }
                    phonenum = null;
                    try (Statement stmt = conn.createStatement();){
                        String sql = "INSERT INTO PERSON( PERIDX, ACTIVE, FIRSTNAME, SURNAME, POSTCODE )  VALUES ( " + person.getAttribute("peridx").getValue() + ", 1, " + PosUtils.StringToSqlString(person.getAttribute("firstname").getValue()) + ", " + PosUtils.StringToSqlString(person.getAttribute("surname").getValue()) + ", " + PosUtils.StringToSqlString(locn.getAttribute("postcode").getValue()) + " ) ";
                        stmt.executeUpdate(sql);
                    }
                    catch (Throwable sql) {
                        phonenum = sql;
                        throw sql;
                    }
                    stmt = conn.createStatement();
                    phonenum = null;
                    try {
                        stmt.executeUpdate("INSERT INTO PERSON_OFFLINE  ( PERIDX, CREATED_MEMIDX, CDAT, DOB, JOBTITLE,  SEX, PRIVACY, ADRS1, ADRS2, CITY, STATE, COUNTRY,  MAIN_PHONE, EMAIL, WORK_PHONE, OTHER_PHONE,  WIDX ) VALUES (" + person.getAttribute("peridx").getValue() + ", " + person.getAttribute("upmemidx").getValue() + ",  CURRENT_TIMESTAMP , " + PosUtils.StringToSqlString(person.getAttribute("dob").getValue()) + ", " + PosUtils.StringToSqlString(person.getAttribute("jobtitle").getValue()) + ", " + PosUtils.StringToSqlString(person.getAttribute("sex").getValue()) + ", " + PosUtils.StringToSqlString(person.getAttribute("privacy").getValue()) + ", " + PosUtils.StringToSqlString(locn.getAttribute("adrs1").getValue()) + ", " + PosUtils.StringToSqlString(locn.getAttribute("adrs2").getValue()) + ", " + PosUtils.StringToSqlString(locn.getAttribute("city").getValue()) + ", " + PosUtils.StringToSqlString(locn.getAttribute("state").getValue()) + ", " + PosUtils.StringToSqlString(locn.getAttribute("country").getValue()) + ", " + PosUtils.StringToSqlString(main_phone) + ", " + PosUtils.StringToSqlString((String)new_email) + ", " + PosUtils.StringToSqlString(work_phone) + ", " + PosUtils.StringToSqlString((String)other_phone2) + ", " + sParams.getStoreIdx() + " ) ");
                    }
                    catch (Throwable sql) {
                        phonenum = sql;
                        throw sql;
                    }
                    finally {
                        if (stmt != null) {
                            if (phonenum != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable sql) {
                                    phonenum.addSuppressed(sql);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                    if (!bExistingPerson) {
                        Utils.CopyLikeReferences(conn, 18L, "WHSE", "WIDX", sParams.getStoreIdx(), 12L, "PERSON", "PERIDX", person.getAttribute("peridx").getLongValue());
                    }
                    if ((refs = person.getChild("references")) != null) {
                        Object ref;
                        StringBuilder sb = new StringBuilder();
                        for (int i = 1; i <= 10; ++i) {
                            ref = refs.getAttribute("ref" + i);
                            if (ref == null || StringUtils.isNullOrEmpty(ref.getValue())) continue;
                            sb.append(String.format(" REF%s = %s,", String.valueOf(i), PosUtils.StringToSqlString(ref.getValue())));
                        }
                        if (sb.length() > 0) {
                            sb.delete(sb.length() - 1, sb.length());
                            sb.insert(0, "UPDATE PERSON SET ");
                            sb.append(" WHERE PERIDX = " + person.getAttribute("peridx").getValue());
                            Statement stmt = conn.createStatement();
                            ref = null;
                            try {
                                stmt.execute(sb.toString());
                            }
                            catch (Throwable throwable) {
                                ref = throwable;
                                throw throwable;
                            }
                            finally {
                                if (stmt != null) {
                                    if (ref != null) {
                                        try {
                                            stmt.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)ref).addSuppressed(throwable);
                                        }
                                    } else {
                                        stmt.close();
                                    }
                                }
                            }
                        }
                    }
                    if ((customDataElement = person.getChild("custom_data")) != null) {
                        for (Object template : customDataElement.getChildren("card")) {
                            Element templateElement = (Element)template;
                            if (!XMLUtils.hasValue(templateElement, "template_idx")) continue;
                            for (Object field : templateElement.getChildren("field")) {
                                String value;
                                Element fieldElement = (Element)field;
                                if (!XMLUtils.hasValue(fieldElement, "field_idx")) continue;
                                if ("TagList".equals(XMLUtils.getValue(fieldElement, "type"))) {
                                    ArrayList<String> tagList = new ArrayList<String>();
                                    for (Object tag : fieldElement.getChildren("tag")) {
                                        String tagIdx = XMLUtils.getValue((Element)tag, "idx");
                                        if (StringUtils.isNullOrEmpty(tagIdx)) continue;
                                        tagList.add(tagIdx);
                                    }
                                    value = String.join((CharSequence)",", tagList);
                                } else {
                                    value = XMLUtils.getValue(fieldElement, "value");
                                }
                                SqlQuery.executeUpdate(conn, "INSERT INTO PERSON_OFFLINE_CUSTOM_DATA(PERIDX, FIELDIDX, TEMPLATEIDX, FIELD_VALUE) VALUES (?, ?, ?, ?)", XMLUtils.getValue(person, "peridx"), XMLUtils.getValue(fieldElement, "field_idx"), XMLUtils.getValue(templateElement, "template_idx"), value);
                            }
                        }
                    }
                }
                retIdxs.setAttribute((Attribute)person.getAttribute("peridx").clone());
                List loyaltys = person.getChildren("perloyalty");
                for (int i = 0; i < loyaltys.size(); ++i) {
                    Throwable throwable;
                    PreparedStatement prepStmt;
                    boolean bInsertLoyalty;
                    Element loyalty = (Element)loyaltys.get(i);
                    if (loyalty.getAttribute("loyalidx") != null && loyalty.getAttribute("rcidx") == null) {
                        Statement stmt = conn.createStatement();
                        new_email = null;
                        try {
                            stmt.executeUpdate("UPDATE PERLOYALTY SET \"ACTIVE\"=0 WHERE LOYALIDX = " + loyalty.getAttribute("loyalidx").getValue());
                            continue;
                        }
                        catch (Throwable other_phone2) {
                            new_email = other_phone2;
                            throw other_phone2;
                        }
                        finally {
                            if (stmt != null) {
                                if (new_email != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable other_phone2) {
                                        ((Throwable)new_email).addSuppressed(other_phone2);
                                    }
                                } else {
                                    stmt.close();
                                }
                            }
                        }
                    }
                    if (loyalty.getAttribute("cardno") == null) {
                        String sPeridx = person.getAttribute("peridx").getValue();
                        if (sPeridx.startsWith("-")) {
                            loyalty.setAttribute("cardno", "L" + loyalty.getText() + "S" + sParams.getStore().getStoreNo() + sPeridx.substring(1));
                        } else {
                            loyalty.setAttribute("cardno", "L" + loyalty.getText() + sPeridx);
                        }
                    }
                    boolean cardAlreadyExists = false;
                    SqlQuery sql = new SqlQuery(conn, "SELECT LOYALIDX FROM PERLOYALTY  WHERE CARDNO = " + PosUtils.StringToSqlString(loyalty.getAttribute("cardno").getValue()) + " AND PERIDX <> " + retIdxs.getAttribute("peridx").getValue() + " AND \"ACTIVE\"=1");
                    other_phone2 = null;
                    try {
                        if (sql.next()) {
                            cardAlreadyExists = true;
                            retIdxs.addContent((Content)new Element("perloyalty").setAttribute("error", "CardNo already in use").setAttribute((Attribute)loyalty.getAttribute("cardno").clone()));
                        }
                    }
                    catch (Throwable work_phone) {
                        other_phone2 = work_phone;
                        throw work_phone;
                    }
                    finally {
                        if (sql != null) {
                            if (other_phone2 != null) {
                                try {
                                    sql.close();
                                }
                                catch (Throwable work_phone) {
                                    ((Throwable)other_phone2).addSuppressed(work_phone);
                                }
                            } else {
                                sql.close();
                            }
                        }
                    }
                    if (cardAlreadyExists) continue;
                    Date dExpiry = null;
                    PosDateFormatter dateFormatter = new PosDateFormatter(null, 3, 3, 0);
                    if (!loyalty.getAttribute("expiry").getValue().equals("")) {
                        try {
                            dateFormatter.setTimestampInternal(loyalty.getAttribute("expiry").getValue());
                        }
                        catch (Exception work_phone) {
                            // empty catch block
                        }
                        if (dateFormatter.getTimestamp() != null) {
                            dExpiry = new Date(dateFormatter.getTimestamp().getTime());
                        }
                    }
                    boolean bl2 = bInsertLoyalty = loyalty.getAttribute("loyalidx") == null;
                    if (bInsertLoyalty) {
                        if (loyalty.getAttribute("prefetch_loyalidx") != null) {
                            loyalty.setAttribute("loyalidx", loyalty.getAttributeValue("prefetch_loyalidx"));
                        } else {
                            loyalty.setAttribute("loyalidx", "-" + sParams.nextVal("XPERLOYALTY"));
                        }
                    } else {
                        prepStmt = conn.prepareStatement("UPDATE PERLOYALTY SET RCIDX = ?, EXPIRY = ?, CARDNO = ? WHERE LOYALIDX = ?");
                        throwable = null;
                        try {
                            prepStmt.setLong(1, PosUtils.longVal(loyalty.getAttribute("rcidx").getValue()));
                            prepStmt.setDate(2, dExpiry);
                            prepStmt.setString(3, loyalty.getAttribute("cardno").getValue());
                            prepStmt.setLong(4, PosUtils.longVal(loyalty.getAttribute("loyalidx").getValue()));
                            prepStmt.execute();
                            bInsertLoyalty = prepStmt.getUpdateCount() == 0;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (prepStmt != null) {
                                if (throwable != null) {
                                    try {
                                        prepStmt.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    prepStmt.close();
                                }
                            }
                        }
                    }
                    if (bInsertLoyalty) {
                        prepStmt = conn.prepareStatement("INSERT INTO PERLOYALTY (LOYALIDX, PERIDX, RCIDX, EXPIRY, CARDNO, WIDX, \"ACTIVE\") VALUES (?, ?, ?, ?, ?, ?, 1)");
                        throwable = null;
                        try {
                            prepStmt.setLong(1, PosUtils.longVal(loyalty.getAttribute("loyalidx").getValue()));
                            prepStmt.setLong(2, PosUtils.longVal(person.getAttribute("peridx").getValue()));
                            prepStmt.setLong(3, PosUtils.longVal(loyalty.getAttribute("rcidx").getValue()));
                            prepStmt.setDate(4, dExpiry);
                            prepStmt.setString(5, loyalty.getAttribute("cardno").getValue());
                            if (loyalty.getAttribute("loyalidx").getValue().startsWith("-")) {
                                prepStmt.setLong(6, sParams.getStoreIdx());
                            } else {
                                prepStmt.setNull(6, 2);
                            }
                            prepStmt.executeUpdate();
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (prepStmt != null) {
                                if (throwable != null) {
                                    try {
                                        prepStmt.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    prepStmt.close();
                                }
                            }
                        }
                    }
                    retIdxs.addContent((Content)new Element("perloyalty").setAttribute((Attribute)loyalty.getAttribute("loyalidx").clone()).setAttribute((Attribute)loyalty.getAttribute("cardno").clone()));
                }
                try (Statement stmt = conn.createStatement();){
                    stmt.executeUpdate("INSERT into YPERSON(YPERIDX, PERIDX)values(" + sParams.nextVal("XYPERSON") + ", " + person.getAttribute("peridx").getValue() + ")");
                }
            }
            return retIdxs;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            Element elem = new Element("error");
            return elem.setAttribute("desc", e.toString());
        }
    }

    public static List<String> localPersonCheck(Connection conn, String email, String mainPhone, Element person) throws SQLException {
        ArrayList<String> peridxs = new ArrayList<String>();
        String matchingIdx = "";
        String emailUniqueFilter = "";
        if (!PersonCrypt.getInstance().keyExists()) {
            return peridxs;
        }
        XMLLocal.checkBlindIndexes(emailUniqueFilter, matchingIdx, email, mainPhone);
        String sql = " SELECT P.PERIDX  FROM PERSON P  WHERE P.\"ACTIVE\" = 1  AND ( UPPER(P.FIRSTNAME) = UPPER(" + PosUtils.StringToSqlString(person.getAttribute("firstname").getValue()) + ")  AND UPPER(P.SURNAME) = UPPER(" + PosUtils.StringToSqlString(person.getAttribute("surname").getValue()) + ") " + matchingIdx + emailUniqueFilter + " ) " + XMLLocal.sParams.sWhseRefSecWherePERSON;
        try (SqlQuery sqlQuery = new SqlQuery(conn, sql);){
            while (sqlQuery.next()) {
                peridxs.add(sqlQuery.getString(1));
            }
        }
        return peridxs;
    }

    public static void checkBlindIndexes(String emailUniqueFilter, String matchingIdxs, String email, String phone) {
        List<String> emailPeridxs;
        if (!email.isEmpty() && (emailPeridxs = PersonCrypt.getInstance().searchEmail(SP.sParams.conn, email, StringTransform.NO_TRANSFORMATION)).size() > 0) {
            emailUniqueFilter = " OR P.PERIDX IN ( " + String.join((CharSequence)",", emailPeridxs) + " ) ";
        }
        ArrayList matchingPeridxs = new ArrayList();
        ArrayList phonePeridxs = !phone.isEmpty() ? PersonCrypt.getInstance().searchPhone(SP.sParams.conn, phone, PersonCrypt.PHONE_TRANSFORM_LAST9) : new ArrayList();
        matchingPeridxs.addAll(phonePeridxs);
        HashSet uniqueIdxs = new HashSet(matchingPeridxs);
        matchingIdxs = "";
        if (uniqueIdxs.size() > 0) {
            matchingIdxs = " AND P.PERIDX IN ( " + String.join((CharSequence)",", uniqueIdxs) + " ) ";
        } else if (phone.isEmpty()) {
            matchingIdxs = " AND COALESCE(P.PHONE, '') = '' ";
        }
    }
}

