/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.utils;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import jpos.basscom.AXGen;
import jpos.basscom.utils.TypConv;

public class Utils {
    static ResourceBundle res = ResourceBundle.getBundle("TransJavaCommon");
    public static final int AC_R = 1;
    public static final int AC_A = 2;
    public static final int AC_E = 4;
    public static final int AC_D = 8;
    public static final int AC_All = 15;
    public static final int REFOBJ_PERSON = 12;
    public static final int REFOBJ_WHSE = 18;
    public static final int REFOBJ_RETAIL = 23;
    public static final int REFOBJ_SUPPLIER = 10;
    public static final int RETAIL_CUSTOMER_WORKGRPS = 0;
    public static final int RETAIL_TRANSACTION_WORKGRPS = 1;
    public static final int STOCK_ENQUIRY_WORKGRPS = 2;
    public static final int TRANSFER_OUT_WORKGRPS = 3;
    public static final int STOCK_RECEIPT_WORKGRPS = 4;
    public static final int TRANSFER_REQUEST_WORKGRPS = 5;
    public static final int SUPPLIER_WORKGRPS = 6;
    public static final int ORACLE = 0;
    public static final int FIREBIRD = 1;
    static final String subs = "5739";

    public static String getPassword(String schema) {
        if (schema.equalsIgnoreCase("BASS")) {
            return "saab5";
        }
        StringBuffer password = new StringBuffer(subs.length() + schema.length());
        int i = 0;
        while (i < schema.length() | i < subs.length()) {
            if (i < schema.length()) {
                password.append(schema.charAt(i));
            }
            if (i < subs.length()) {
                password.append(subs.charAt(i));
            }
            ++i;
        }
        return password.toString();
    }

    public static String StrToDBX(String sCode) {
        if (sCode == null) {
            return "NULL";
        }
        String slOutStr = new String();
        int nlLen = sCode.length();
        if (nlLen == 0) {
            return "NULL";
        }
        while (nlLen > 0) {
            int nlPos = sCode.indexOf(39);
            if (nlPos < 0) {
                nlPos = nlLen;
            }
            slOutStr = slOutStr + sCode.substring(0, nlPos);
            if ((nlLen -= nlPos) == 0) break;
            slOutStr = slOutStr + "''";
            sCode = sCode.substring(sCode.length() - --nlLen);
        }
        return '\'' + slOutStr + '\'';
    }

    public static String encrypt(String pwd) {
        int i;
        int LENGTH = 10;
        int[] key = new int[]{7, 5, 2, 9, 4, 1, 0, 3, 8, 6};
        int[] copy = new int[10];
        String retval = new String();
        for (i = 0; i < 10; ++i) {
            try {
                copy[key[i]] = pwd.charAt(9 - i) + 40 - i;
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                copy[key[i]] = 72 - i;
            }
        }
        for (i = 0; i < 10; ++i) {
            String hex1 = Integer.toHexString((copy[i] & 0xF0) / 16);
            String hex2 = Integer.toHexString(copy[i] & 0xF);
            retval = retval + hex1 + hex2;
        }
        return retval.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queryStmt(Connection connpDB, String spSQL, int npCols, Vector<Vector<String>> vResult) {
        if (!vResult.isEmpty()) {
            vResult.clear();
        }
        Statement stmt = null;
        try {
            stmt = connpDB.createStatement();
            ResultSet result = null;
            try {
                result = stmt.executeQuery(spSQL);
                while (result.next()) {
                    Vector<String> vRowData = new Vector<String>();
                    for (int nCnt = 1; nCnt <= npCols; ++nCnt) {
                        String sResult = result.getClass().equals("java.lang.String") ? TypConv.toString(result.getBytes(nCnt)) : result.getString(nCnt);
                        if (sResult == null) {
                            vRowData.addElement("");
                            continue;
                        }
                        vRowData.addElement(sResult);
                    }
                    vResult.addElement(vRowData);
                }
            }
            finally {
                Utils.closeResultSet(result);
            }
        }
        catch (Exception e) {
            Utils.logError(e);
            vResult.clear();
            Vector<String> vData = new Vector<String>();
            vData.addElement(e.getMessage());
            vResult.addElement(vData);
            boolean bl = false;
            return bl;
        }
        finally {
            Utils.closeStatement(stmt);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execStmt(Connection connpDB, String spSQL, Vector<String> vError) {
        if (!vError.isEmpty()) {
            vError.clear();
        }
        vError.setSize(1);
        Statement stmt = null;
        try {
            stmt = connpDB.createStatement();
            stmt.executeUpdate(spSQL);
            connpDB.commit();
        }
        catch (Exception e) {
            vError.setElementAt(e.getMessage(), 0);
            boolean bl = false;
            return bl;
        }
        finally {
            Utils.closeStatement(stmt);
        }
        return true;
    }

    public static String getBLOBText(Connection connDB, long nBlobidx) {
        String sTmp = "";
        Vector<Vector<String>> vTmp = new Vector<Vector<String>>();
        String sSql = "SELECT BLOBTEXT FROM BLOBTEXT WHERE BLOBIDX = " + nBlobidx;
        if (Utils.queryStmt(connDB, sSql, 1, vTmp) && vTmp.size() > 0) {
            sTmp = vTmp.elementAt(0).elementAt(0);
        }
        return sTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long insertBLOBText(Connection connDB, long nType, long nKey, String sBLOB) {
        long nBlobidx = 0L;
        nBlobidx = Utils.getMax(connDB, "BLOBTEXT", "BLOBIDX");
        if (nBlobidx == 0L) {
            return 0L;
        }
        PreparedStatement stmt = null;
        try {
            stmt = connDB.prepareStatement("INSERT INTO BLOBTEXT ( BLOBIDX, BLOBTYPE, KEYIDX, BLOBTEXT )VALUES (" + nBlobidx + ", " + nType + ", " + nKey + ",?)");
            StringReader reader = new StringReader(sBLOB);
            stmt.setCharacterStream(1, (Reader)reader, sBLOB.length());
            if (!stmt.execute() && stmt.getUpdateCount() == 1) {
                long l = nBlobidx;
                Utils.closeStatement(stmt);
                return l;
            }
            Utils.closeStatement(stmt);
        }
        catch (SQLException e) {
            Utils.logError(e);
        }
        finally {
            Utils.closeStatement(stmt);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateBLOBText(Connection connDB, long nBLOB, String sBLOB) {
        PreparedStatement stmt = null;
        try {
            stmt = connDB.prepareStatement("UPDATE BLOBTEXT SET BLOBTEXT = ? WHERE BLOBIDX = ?");
            StringReader reader = new StringReader(sBLOB);
            stmt.setCharacterStream(1, (Reader)reader, sBLOB.length());
            stmt.setLong(2, nBLOB);
            if (!stmt.execute() && stmt.getUpdateCount() == 1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            Utils.logError(e);
        }
        finally {
            Utils.closeStatement(stmt);
        }
        return false;
    }

    public static boolean deleteBLOBText(Connection connDB, long nBLOB) {
        Vector<String> vTmp = new Vector<String>();
        return Utils.execStmt(connDB, "DELETE BLOBTEXT WHERE BLOBIDX = " + nBLOB, vTmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBLOB(Connection connpDB, long nBlobidx) {
        byte[] byteArr = new byte[4096];
        String sSQL = "SELECT BLOBDATA FROM BLOBTBL WHERE BLOBIDX = " + nBlobidx;
        Statement stmt = null;
        try {
            stmt = connpDB.createStatement();
            ResultSet result = null;
            try {
                result = stmt.executeQuery(sSQL);
                if (result.next()) {
                    byteArr = result.getBytes(1);
                }
            }
            finally {
                Utils.closeResultSet(result);
            }
        }
        catch (SQLException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            Utils.closeStatement(stmt);
        }
        return byteArr;
    }

    public static long insertBLOB(Connection connDB, long nType, long nKey, double nPos, int nFlag, String sDescrip, String sBLOB) {
        long nBlobidx = 0L;
        Vector<String> vTmp = new Vector<String>();
        nBlobidx = Utils.getMax(connDB, "BLOBTBL", "BLOBIDX");
        if (nBlobidx == 0L) {
            return 0L;
        }
        if (!Utils.execStmt(connDB, "INSERT INTO BLOBTBL ( BLOBDATA, BLOBIDX, BLOBTYPE, KEYIDX, POS, FLAG, DESCRIP ) VALUES ( RAWTOHEX(" + Utils.StrToDBX(sBLOB) + "), " + nBlobidx + ", " + nType + ", " + nKey + ", " + nPos + ", " + nFlag + ", '" + sDescrip + "' ) ", vTmp)) {
            return 0L;
        }
        return nBlobidx;
    }

    public static boolean updateBLOB(Connection connDB, long nBLOB, String sBLOB) {
        Vector<String> vTmp = new Vector<String>();
        return Utils.execStmt(connDB, "UPDATE BLOBTBL SET BLOBDATA = RAWTOHEX(" + Utils.StrToDBX(sBLOB) + ") WHERE BLOBIDX = " + nBLOB, vTmp);
    }

    public static boolean deleteBLOB(Connection connDB, long nBLOB) {
        Vector<String> vTmp = new Vector<String>();
        return Utils.execStmt(connDB, "DELETE BLOBTBL WHERE BLOBIDX = " + nBLOB, vTmp);
    }

    public static int stringTokenize(String strSource, String strDelim, Vector<String> vecToken) {
        int cnt = 0;
        vecToken.clear();
        if (strSource == null) {
            return 0;
        }
        int nPrevTmp = 0 - strDelim.length();
        int nTmp = strSource.indexOf(strDelim);
        while (nTmp > -1 && nTmp < strSource.length()) {
            if (nTmp == nPrevTmp + strDelim.length()) {
                vecToken.addElement("");
            } else {
                vecToken.addElement(strSource.substring(nPrevTmp + strDelim.length(), nTmp));
            }
            nPrevTmp = nTmp;
            nTmp = strSource.indexOf(strDelim, nPrevTmp + strDelim.length());
            ++cnt;
        }
        if (nTmp == -1 & nPrevTmp + strDelim.length() < strSource.length()) {
            vecToken.addElement(strSource.substring(nPrevTmp + strDelim.length()));
            ++cnt;
        }
        return cnt;
    }

    public static int stringTTokenize(String strSource, String strDelim, Vector<String> vecToken) {
        int nCnt = 0;
        vecToken.clear();
        if (strSource != null && !strSource.equals("")) {
            int nDelPosn = strSource.indexOf(strDelim);
            int nPrevDelPosn = -strDelim.length();
            while (nDelPosn > -1) {
                vecToken.addElement(strSource.substring(nPrevDelPosn + strDelim.length(), nDelPosn));
                nPrevDelPosn = nDelPosn;
                nDelPosn = strSource.indexOf(strDelim, nPrevDelPosn + strDelim.length());
                ++nCnt;
            }
            vecToken.addElement(strSource.substring(nPrevDelPosn + strDelim.length()));
            ++nCnt;
        }
        return nCnt;
    }

    public static int stringTokenize(String strSource, String strDelim, String[] saToken) {
        int cnt = 0;
        Utils.arrayFill(saToken, "");
        if (strSource == null) {
            return 0;
        }
        int nPrevTmp = 0 - strDelim.length();
        int nTmp = strSource.indexOf(strDelim);
        while (nTmp > -1 && nTmp < strSource.length()) {
            saToken[cnt] = nTmp == nPrevTmp + strDelim.length() ? "" : strSource.substring(nPrevTmp + strDelim.length(), nTmp);
            nPrevTmp = nTmp;
            nTmp = strSource.indexOf(strDelim, nPrevTmp + strDelim.length());
            ++cnt;
        }
        if (nTmp == -1 & nPrevTmp + strDelim.length() < strSource.length()) {
            saToken[cnt] = strSource.substring(nPrevTmp + strDelim.length());
            ++cnt;
        }
        return cnt;
    }

    public static String stringLeft(String spSource, int npLength) {
        return spSource.substring(0, npLength);
    }

    public static String stringMid(String spSource, int npStart, int npLength) {
        return spSource.substring(npStart, npStart + npLength);
    }

    public static String stringRight(String spSource, int npLength) {
        return spSource.substring(spSource.length() - npLength);
    }

    public static String stringReplace(String sSource, String sReplaceF, String sReplaceT) {
        String sTmp = "";
        String sTmp2 = sSource;
        int nTmp = sTmp2.indexOf(sReplaceF);
        while (nTmp > -1) {
            sTmp = sTmp + sTmp2.substring(0, nTmp) + sReplaceT;
            sTmp2 = sTmp2.substring(nTmp + sReplaceF.length());
            nTmp = sTmp2.indexOf(sReplaceF);
        }
        sTmp = sTmp + sTmp2;
        return sTmp;
    }

    public static String stringWrap(String sSource, int nNumOfChars, boolean bBreakWord) {
        String sTmp = "";
        int nCnt = 0;
        int nChars = 0;
        while (nCnt < sSource.length()) {
            if (bBreakWord) {
                if (nChars == nNumOfChars) {
                    sTmp = sTmp + '\n';
                    nChars = 0;
                }
            } else if (nChars >= nNumOfChars && sSource.charAt(nCnt) == ' ') {
                sTmp = sTmp + '\n';
                nChars = 0;
                while (sSource.charAt(nCnt) == ' ') {
                    ++nCnt;
                }
            }
            sTmp = sTmp + sSource.charAt(nCnt);
            ++nCnt;
            ++nChars;
        }
        return sTmp;
    }

    public static int arrayFind(String[] spArray, String spFind) {
        Vector<String> vTmp = new Vector<String>();
        for (int nCnt = 0; nCnt < spArray.length; ++nCnt) {
            vTmp.addElement(spArray[nCnt]);
        }
        return vTmp.indexOf(spFind);
    }

    public static int arrayFind(int[] npArray, int npFind) {
        for (int nCnt = 0; nCnt < npArray.length; ++nCnt) {
            if (npArray[nCnt] != npFind) continue;
            return nCnt;
        }
        return -1;
    }

    public static int arrayFind(long[] npArray, long npFind) {
        for (int nCnt = 0; nCnt < npArray.length; ++nCnt) {
            if (npArray[nCnt] != npFind) continue;
            return nCnt;
        }
        return -1;
    }

    public static int arrayFind(char[] cpArray, char cpFind) {
        for (int nCnt = 0; nCnt < cpArray.length; ++nCnt) {
            if (cpArray[nCnt] != cpFind) continue;
            return nCnt;
        }
        return -1;
    }

    public static void arrayFill(String[] spArray, String spFill) {
        for (int nCnt = 0; nCnt < spArray.length; ++nCnt) {
            spArray[nCnt] = spFill;
        }
    }

    public static void arrayFill(int[] npArray, int npFill) {
        for (int nCnt = 0; nCnt < npArray.length; ++nCnt) {
            npArray[nCnt] = npFill;
        }
    }

    public static void arrayFill(long[] npArray, long npFill) {
        for (int nCnt = 0; nCnt < npArray.length; ++nCnt) {
            npArray[nCnt] = npFill;
        }
    }

    public static void arrayFill(float[] npArray, float npFill) {
        for (int nCnt = 0; nCnt < npArray.length; ++nCnt) {
            npArray[nCnt] = npFill;
        }
    }

    public static boolean isValidInteger(String sInt) {
        try {
            Integer.valueOf(sInt);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String formatNumber(double num, String fmt) {
        return new DecimalFormat(fmt).format(num);
    }

    public static String formatNumber(float num, String fmt) {
        return new DecimalFormat(fmt).format(num);
    }

    public static String toDecodeStr(String sBase, String sCompare, String sValue, String sDefValue) {
        return "DECODE(" + sBase + ", " + sCompare + ", " + sValue + ", " + sDefValue + ")";
    }

    public static String longToDBX(long val) {
        String sTmp = "NULL";
        if (val != 0L) {
            sTmp = "" + val;
        }
        return sTmp;
    }

    public static boolean getSysParam(Connection connDB, long parIdx, long[] parLnkidx, String[] parStr) {
        Vector<Vector<String>> vTmp;
        parLnkidx[0] = 0L;
        parStr[0] = "";
        String sSql = "SELECT COALESCE(PARLNKIDX,0), PARSTR FROM SYSPARAM WHERE PARIDX = " + parIdx;
        if (Utils.queryStmt(connDB, sSql, 2, vTmp = new Vector<Vector<String>>()) && vTmp.size() > 0) {
            parLnkidx[0] = TypConv.toLong(vTmp.elementAt(0).elementAt(0));
            parStr[0] = vTmp.elementAt(0).elementAt(1);
            return true;
        }
        return false;
    }

    public static int getSecX(Connection connDB, long memID, long secID) {
        Vector<Vector<String>> vTmp;
        int retVal = 0;
        String sSql = "SELECT NVL(SUM(S.READ),0), NVL(SUM(S.WRITE),0), NVL(SUM(S.EDIT),0), NVL(SUM(S.DEL),0) FROM   GRPMEM M, GRPSEC S WHERE  M.MEMIDX = " + memID + " AND M.GRPIDX = S.GRPIDX AND S.SECIDX = " + secID;
        if (Utils.queryStmt(connDB, sSql, 4, vTmp = new Vector<Vector<String>>()) && vTmp.size() > 0) {
            if (!vTmp.elementAt(0).elementAt(0).equals("0")) {
                ++retVal;
            }
            if (!vTmp.elementAt(0).elementAt(1).equals("0")) {
                retVal += 2;
            }
            if (!vTmp.elementAt(0).elementAt(2).equals("0")) {
                retVal += 4;
            }
            if (!vTmp.elementAt(0).elementAt(3).equals("0")) {
                retVal += 8;
            }
        }
        return retVal;
    }

    public static long getMax(Connection connDB, String sTblName, String sTblCol) {
        long nMax = 0L;
        Vector<Vector<String>> vTmp = new Vector<Vector<String>>();
        if (Utils.queryStmt(connDB, "SELECT X" + sTblName + ".NEXTVAL FROM DUAL", 1, vTmp) && vTmp.size() > 0) {
            nMax = TypConv.toLong(vTmp.elementAt(0).elementAt(0));
        }
        if (nMax == 0L && Utils.queryStmt(connDB, "SELECT MAX(" + sTblCol + ") FROM " + sTblName, 1, vTmp)) {
            if (vTmp.size() > 0) {
                nMax = TypConv.toLong(vTmp.elementAt(0).elementAt(0));
            }
            ++nMax;
        }
        return nMax;
    }

    public static String removeInvalidChars(String sIn) {
        StringBuffer sOut = new StringBuffer();
        try {
            sOut.append(sIn);
            int nLength = sOut.length();
            for (int i = 0; i < nLength; ++i) {
                if (sOut.charAt(i) >= ' ' && sOut.charAt(i) <= '~') continue;
                sOut.deleteCharAt(i);
                nLength = sOut.length();
            }
        }
        catch (Exception e) {
            Utils.logError(e);
            sOut.setLength(0);
        }
        return sOut.toString();
    }

    public static String padLeft(String sSource, String sPad, int nLength) {
        int len;
        if (sSource == null) {
            sSource = "";
        }
        if ((len = sSource.length()) > nLength) {
            sSource = sSource.substring(0, nLength);
        } else if (sPad != null && !sPad.equals("")) {
            for (int count = len; count < nLength; ++count) {
                sSource = sSource + sPad;
            }
        }
        return sSource;
    }

    public static void logError(Throwable e) {
        System.out.print(AXGen.getStackTrace(e));
    }

    public static void logError(String s) {
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetWhseSecWhereSQL(Connection con, long pWidx, int pWorkgroupType, String pSecAlias, int pDatabase) {
        String sSecSQL;
        block43: {
            boolean bCurrencyByCompany = false;
            long nRgidx = 0L;
            String sColName = "";
            sSecSQL = "";
            int refTblidx = Utils.getRefObjectForWorkgroupType(pWorkgroupType);
            if (refTblidx != 12 && refTblidx != 18 && refTblidx != 23 && refTblidx != 10) {
                return "";
            }
            String sWorkGrps = null;
            String sCol = Utils.getColumnForWorkgroupType(pWorkgroupType);
            String sCurrency = null;
            Statement stmt = null;
            try {
                ResultSet rAllGrp;
                block44: {
                    block42: {
                        stmt = con.createStatement();
                        ResultSet rWhse = null;
                        try {
                            rWhse = stmt.executeQuery("Select " + sCol + ", RZ.\"EXTEND\"  from WHSE W, REFCODE RW, REFCODE RZ where W.WIDX = " + pWidx + " and RW.RCIDX =  W.WIDX and RZ.RCIDX = RW.RPCIDX");
                            if (rWhse.next()) {
                                sWorkGrps = rWhse.getString(1);
                                sCurrency = rWhse.getString(2);
                            }
                        }
                        catch (Throwable throwable) {
                            Utils.closeResultSet(rWhse);
                            throw throwable;
                        }
                        Utils.closeResultSet(rWhse);
                        ResultSet rSec = null;
                        try {
                            rSec = stmt.executeQuery("Select 1 from SYSPARAM where PARIDX = 626 and PARSTR = 'Yes'");
                            bCurrencyByCompany = rSec.next();
                        }
                        finally {
                            Utils.closeResultSet(rSec);
                        }
                        if (!bCurrencyByCompany && sCurrency != null && !sCurrency.equalsIgnoreCase("15")) {
                            sCurrency = "0";
                        }
                        if (sCurrency != null && refTblidx == 23 && sCurrency == "15") {
                            sSecSQL = pSecAlias + ".WIDX not in (Select RW.WIDX  from WHSE RW where RW.CURRIDX != '" + sCurrency + "')";
                        }
                        try {
                            if (sCurrency == null || refTblidx != 10) break block42;
                            String sSelect = null;
                            sSelect = pDatabase == 1 ? "Select cast('REF' || T.RG_ORD as varchar(25)), T.RGIDX from REFTBL T, REFGRP G where G.RGIDX = T.RGIDX and G.RGIDX = 22 and T.TBLIDX = " + refTblidx + " union  select cast(T.COLNAME as varchar(25)), T.RGIDX from REFTBLINT T, REFGRP G where G.RGIDX = T.RGIDX and G.RGIDX = 22 and T.TBLIDX = " + refTblidx : "Select 'REF' || T.RG_ORD, T.RGIDX from REFTBL T, REFGRP G where G.RGIDX = T.RGIDX and G.RGIDX = 22 and T.TBLIDX = " + refTblidx + " union select T.COLNAME, T.RGIDX from REFTBLINT T, REFGRP G where G.RGIDX = T.RGIDX and G.RGIDX = 22 and T.TBLIDX = " + refTblidx;
                            ResultSet rSelect = null;
                            try {
                                rSelect = stmt.executeQuery(sSelect);
                                if (rSelect.next()) {
                                    String sColumName = rSelect.getString(1);
                                    sSecSQL = pSecAlias + "." + sColumName + " in (Select C.COMPIDX from COMPANY C where C.AXCURIDX = " + sCurrency + ")";
                                }
                            }
                            finally {
                                Utils.closeResultSet(rSelect);
                            }
                        }
                        catch (Exception e) {
                            Utils.logError(e);
                        }
                    }
                    if (sWorkGrps == null || sWorkGrps.length() <= 0) break block43;
                    String sSelect1 = null;
                    sSelect1 = pDatabase == 1 ? "SELECT CAST('REF' || t.rg_ord AS VARCHAR(25)), T.RGIDX FROM REFTBL T, REFGRP G WHERE G.RGIDX = T.RGIDX AND G.SECENABLE = 1 AND T.TBLIDX = " + refTblidx + " UNION SELECT CAST(T.COLNAME AS VARCHAR(25)), T.RGIDX FROM REFTBLINT T, REFGRP G WHERE G.RGIDX = T.RGIDX AND G.SECENABLE = 1 AND T.TBLIDX = " + refTblidx : "SELECT 'REF' || t.rg_ord, T.RGIDX FROM REFTBL T, REFGRP G WHERE G.RGIDX = T.RGIDX AND G.SECENABLE = 1 AND T.TBLIDX = " + refTblidx + " UNION SELECT T.COLNAME, T.RGIDX FROM REFTBLINT T, REFGRP G WHERE G.RGIDX = T.RGIDX AND G.SECENABLE = 1 AND T.TBLIDX = " + refTblidx;
                    rAllGrp = null;
                    try {
                        rAllGrp = stmt.executeQuery("SELECT 1 FROM DEFSEC  WHERE GRPIDX IN (" + sWorkGrps + ") AND RGIDX_FLAG = -1");
                        if (rAllGrp.next()) break block44;
                        Statement stmtSelect1 = null;
                        try {
                            stmtSelect1 = con.createStatement();
                            ResultSet rSelect1 = null;
                            try {
                                rSelect1 = stmtSelect1.executeQuery(sSelect1);
                                while (rSelect1.next()) {
                                    sColName = rSelect1.getString(1);
                                    nRgidx = rSelect1.getLong(2);
                                    Statement stmtCheck1 = null;
                                    try {
                                        ResultSet rCheck1;
                                        block45: {
                                            stmtCheck1 = con.createStatement();
                                            rCheck1 = null;
                                            try {
                                                rCheck1 = stmtCheck1.executeQuery("SELECT 1 FROM DEFSEC WHERE GRPIDX IN (" + sWorkGrps + ") AND RGIDX_FLAG = " + nRgidx + " AND RCIDX_FLAG = -1");
                                                if (rCheck1.next()) break block45;
                                                if (sSecSQL.length() > 0) {
                                                    sSecSQL = sSecSQL + " AND ";
                                                }
                                                Statement stmtCheck2 = null;
                                                try {
                                                    ResultSet rCheck2;
                                                    block46: {
                                                        stmtCheck2 = con.createStatement();
                                                        rCheck2 = null;
                                                        try {
                                                            rCheck2 = stmt.executeQuery("SELECT 1 FROM REFSEC WHERE GRPIDX IN (" + sWorkGrps + ") AND RGIDX = " + nRgidx + " AND RCIDX IS NULL ");
                                                            if (rCheck2.next()) {
                                                                sSecSQL = sSecSQL + " (" + pSecAlias + "." + sColName + " IS NULL ";
                                                                sSecSQL = sSecSQL + "OR " + pSecAlias + "." + sColName + " IN( SELECT DISTINCT(RCIDX) FROM REFSEC WHERE GRPIDX IN (" + sWorkGrps + ") AND RGIDX = " + nRgidx + " AND RCIDX IS NOT NULL)) ";
                                                                break block46;
                                                            }
                                                            sSecSQL = sSecSQL + " ( " + pSecAlias + "." + sColName + " IN(SELECT DISTINCT(RCIDX) FROM REFSEC WHERE GRPIDX IN (" + sWorkGrps + ")  AND RGIDX = " + nRgidx + " AND RCIDX IS NOT NULL ) ) ";
                                                        }
                                                        catch (Throwable throwable) {
                                                            Utils.closeResultSet(rCheck2);
                                                            throw throwable;
                                                        }
                                                    }
                                                    Utils.closeResultSet(rCheck2);
                                                }
                                                finally {
                                                    Utils.closeStatement(stmtCheck2);
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Utils.closeResultSet(rCheck1);
                                                throw throwable;
                                            }
                                        }
                                        Utils.closeResultSet(rCheck1);
                                    }
                                    finally {
                                        Utils.closeStatement(stmtCheck1);
                                    }
                                }
                            }
                            finally {
                                Utils.closeResultSet(rSelect1);
                            }
                        }
                        finally {
                            Utils.closeStatement(stmtSelect1);
                        }
                    }
                    catch (Throwable throwable) {
                        Utils.closeResultSet(rAllGrp);
                        throw throwable;
                    }
                }
                Utils.closeResultSet(rAllGrp);
            }
            catch (Exception e) {
                Utils.logError(e);
            }
            finally {
                Utils.closeStatement(stmt);
            }
        }
        return sSecSQL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long getWhseReference(Statement stmt, long widx, long rgidx) {
        try (ResultSet reftbl = stmt.executeQuery("select 'ref' || rg_ord from reftbl where tblidx = 18 and rgidx = " + rgidx);){
            if (!reftbl.next()) return null;
            String refCol = reftbl.getString(1);
            try (ResultSet refResult = stmt.executeQuery("select " + refCol + " from whse where widx = " + widx);){
                if (!refResult.next()) return null;
                Long l = refResult.getLong(1);
                return l;
            }
        }
        catch (SQLException e) {
            Utils.logError(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetWhseRGSecWhereSQL(Statement stmt, long pWidx, long pRgIdx, int pWorkgroupType, String pSecAlias) {
        String sSecSQL;
        block16: {
            long nRgidx = 0L;
            sSecSQL = "";
            int refTblidx = Utils.getRefObjectForWorkgroupType(pWorkgroupType);
            if (refTblidx != 12 && refTblidx != 18 && refTblidx != 23) {
                return "";
            }
            String sWorkGrps = null;
            String sCol = Utils.getColumnForWorkgroupType(pWorkgroupType);
            try {
                ResultSet rSecEnabled;
                block17: {
                    ResultSet rWhse = null;
                    try {
                        rWhse = stmt.executeQuery("SELECT " + sCol + " FROM WHSE W WHERE W.WIDX = " + pWidx);
                        if (rWhse.next()) {
                            sWorkGrps = rWhse.getString(1);
                        }
                    }
                    catch (Throwable throwable) {
                        Utils.closeResultSet(rWhse);
                        throw throwable;
                    }
                    Utils.closeResultSet(rWhse);
                    if (sWorkGrps == null || sWorkGrps.length() <= 0) break block16;
                    rSecEnabled = null;
                    try {
                        ResultSet rAllGrp;
                        block18: {
                            rSecEnabled = stmt.executeQuery("SELECT 1 FROM REFGRP WHERE SECENABLE = 1 AND RGIDX = " + pRgIdx);
                            if (!rSecEnabled.next()) break block17;
                            rAllGrp = null;
                            try {
                                ResultSet rCheck1;
                                block19: {
                                    rAllGrp = stmt.executeQuery("SELECT 1 FROM DEFSEC WHERE GRPIDX IN (" + sWorkGrps + ") AND RGIDX_FLAG = -1");
                                    if (rAllGrp.next()) break block18;
                                    nRgidx = pRgIdx;
                                    rCheck1 = null;
                                    try {
                                        ResultSet rCheck2;
                                        block20: {
                                            rCheck1 = stmt.executeQuery("SELECT 1 FROM DEFSEC WHERE GRPIDX IN (" + sWorkGrps + ") AND RGIDX_FLAG = " + nRgidx + " AND RCIDX_FLAG = -1");
                                            if (rCheck1.next()) break block19;
                                            if (sSecSQL.length() > 0) {
                                                sSecSQL = sSecSQL + " AND ";
                                            }
                                            rCheck2 = null;
                                            try {
                                                rCheck2 = stmt.executeQuery("SELECT 1 FROM REFSEC WHERE GRPIDX IN (" + sWorkGrps + ") AND RGIDX = " + nRgidx + " AND RCIDX IS NULL ");
                                                if (rCheck2.next()) {
                                                    sSecSQL = sSecSQL + " (" + pSecAlias + ".RCIDX IS NULL ";
                                                    sSecSQL = sSecSQL + "OR " + pSecAlias + ".RCIDX IN( SELECT DISTINCT(RCIDX) FROM REFSEC WHERE GRPIDX IN (" + sWorkGrps + ") AND RGIDX = " + nRgidx + " AND RCIDX IS NOT NULL)) ";
                                                    break block20;
                                                }
                                                sSecSQL = sSecSQL + " ( " + pSecAlias + ".RCIDX IN( SELECT DISTINCT(RCIDX) FROM REFSEC WHERE GRPIDX IN (" + sWorkGrps + ")  AND RGIDX = " + nRgidx + " AND RCIDX IS NOT NULL ) ) ";
                                            }
                                            catch (Throwable throwable) {
                                                Utils.closeResultSet(rCheck2);
                                                throw throwable;
                                            }
                                        }
                                        Utils.closeResultSet(rCheck2);
                                    }
                                    catch (Throwable throwable) {
                                        Utils.closeResultSet(rCheck1);
                                        throw throwable;
                                    }
                                }
                                Utils.closeResultSet(rCheck1);
                            }
                            catch (Throwable throwable) {
                                Utils.closeResultSet(rAllGrp);
                                throw throwable;
                            }
                        }
                        Utils.closeResultSet(rAllGrp);
                    }
                    catch (Throwable throwable) {
                        Utils.closeResultSet(rSecEnabled);
                        throw throwable;
                    }
                }
                Utils.closeResultSet(rSecEnabled);
            }
            catch (Exception e) {
                Utils.logError(e);
            }
        }
        return sSecSQL;
    }

    private static String getColumnForWorkgroupType(int workgroupType) {
        switch (workgroupType) {
            case 0: {
                return "W.CUST_WORKGRPS";
            }
            case 1: {
                return "W.TRANS_WORKGRPS";
            }
            case 2: {
                return "W.STOCK_WORKGRPS";
            }
            case 3: {
                return "W.STOCK_TRANS_WORKGRPS";
            }
            case 4: {
                return "W.STOCK_RECEIPT_WORKGRPS";
            }
            case 5: {
                return "W.TRANS_REQUEST_WORKGRPS";
            }
            case 6: {
                return "NULL";
            }
        }
        return "W.STOCK_WORKGRPS";
    }

    private static int getRefObjectForWorkgroupType(int workgroupType) {
        switch (workgroupType) {
            case 0: {
                return 12;
            }
            case 1: {
                return 23;
            }
            case 6: {
                return 10;
            }
        }
        return 18;
    }

    public static int getWorkgroupTypeForRefObject(int refTblidx) {
        switch (refTblidx) {
            case 12: {
                return 0;
            }
            case 23: {
                return 1;
            }
            case 10: {
                return 6;
            }
            case 18: {
                return 2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CopyLikeReferences(Connection con, long nFromTblIdx, String sFromTbl, String sFromPrimaryKey, long nFromIdx, long nToTblIdx, String sToTbl, String sToPrimaryKey, long nToIdx) {
        String sLinked = "SELECT '" + sToTbl + ".REF' || R_TO.RG_ORD, '" + sFromTbl + ".REF' || R_FROM.RG_ORD FROM REFTBL R_TO, REFTBL R_FROM WHERE R_TO.TBLIDX = " + nToTblIdx + " AND R_FROM.TBLIDX = " + nFromTblIdx + " AND R_TO.RGIDX = R_FROM.RGIDX AND R_TO.RGIDX IS NOT NULL ";
        String sToColName = "";
        String sFromColName = "";
        String sUpdateStmt = "";
        boolean bFound = false;
        Statement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.createStatement();
            try {
                result = stmt.executeQuery(sLinked);
                while (result.next()) {
                    sToColName = result.getString(1);
                    sFromColName = result.getString(2);
                    if (!bFound) {
                        sUpdateStmt = sToColName + " = (SELECT COALESCE(" + sFromColName + ", " + sToColName + ") FROM " + sFromTbl + " WHERE " + sFromTbl + "." + sFromPrimaryKey + " = " + nFromIdx + ")";
                        bFound = true;
                        continue;
                    }
                    sUpdateStmt = sUpdateStmt + ", " + sToColName + " = (SELECT COALESCE(" + sFromColName + ", " + sToColName + ") FROM " + sFromTbl + " WHERE " + sFromTbl + "." + sFromPrimaryKey + " = " + nFromIdx + ")";
                }
            }
            finally {
                Utils.closeResultSet(result);
            }
            if (bFound) {
                sUpdateStmt = "UPDATE " + sToTbl + " SET " + sUpdateStmt + " WHERE " + sToTbl + "." + sToPrimaryKey + " = " + nToIdx;
                stmt.executeUpdate(sUpdateStmt);
            }
        }
        catch (Exception e) {
            Utils.logError(e);
        }
        finally {
            Utils.closeStatement(stmt);
        }
    }

    public static boolean createDirectory(String directoryName) {
        File dir = new File(directoryName);
        if (dir.exists()) {
            return true;
        }
        return dir.mkdirs();
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.getConnection().clearWarnings();
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

