/*
 * Decompiled with CFR 0.152.
 */
package jpos.browser;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.InjectJsCallback;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.logging.Level;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import jpos.Settings;
import jpos.browser.BrowserEngine;
import jpos.browser.JSPosUtils;

public class BrowserControl
extends JPanel {
    private BrowserEngine browserEngine;
    private Browser browser;
    private BrowserView view;
    private Browser debugBrowser;
    private BrowserView debugView;
    private JSplitPane splitPane;
    private Map<String, Object> binds = new HashMap<String, Object>();

    public BrowserControl() {
        this.init(false);
    }

    public BrowserControl(boolean injectJSUtils) {
        this.init(injectJSUtils);
    }

    private void init(boolean injectJSUtils) {
        this.setLayout(new BorderLayout());
        Logger.level((Level)Level.OFF);
        this.browserEngine = BrowserEngine.getInstance();
        try {
            this.browser = this.browserEngine.newBrowser();
        }
        catch (IllegalStateException e) {
            this.browserEngine.close();
            this.browserEngine = BrowserEngine.getInstance();
            this.browser = this.browserEngine.newBrowser();
        }
        if (injectJSUtils) {
            this.binds.put("pos", new JSPosUtils());
        }
        this.browser.set(InjectJsCallback.class, (Callback)((InjectJsCallback)params -> {
            if (this.binds.size() > 0) {
                JsObject window = (JsObject)params.frame().executeJavaScript("window");
                for (Map.Entry<String, Object> bind : this.binds.entrySet()) {
                    window.putProperty(bind.getKey(), bind.getValue());
                }
            }
            return InjectJsCallback.Response.proceed();
        }));
        this.view = BrowserView.newInstance((Browser)this.browser);
        if (Settings.showBrowserDebugger()) {
            this.debugBrowser = this.browserEngine.newBrowser();
            this.debugBrowser.navigation().loadUrl(this.browser.devTools().remoteDebuggingUrl().orElse(""));
            this.debugView = BrowserView.newInstance((Browser)this.debugBrowser);
            this.splitPane = new JSplitPane();
            this.splitPane.setOrientation(0);
            this.splitPane.setTopComponent((Component)this.view);
            this.splitPane.setBottomComponent((Component)this.debugView);
            this.add((Component)this.splitPane, "Center");
        } else {
            this.add((Component)this.view, "Center");
        }
    }

    public void requestViewFocus() {
        this.view.requestFocusInWindow();
    }

    public void setBoundObject(String name, Object object) {
        this.binds.put(name, object);
    }

    public Object getBoundObject(String name) {
        return this.binds.get(name);
    }

    public void loadURL(String url) {
        this.browser.navigation().loadUrl(url);
    }

    public void loadHTML(String html) {
        this.browser.mainFrame().ifPresent(frame -> frame.loadHtml(html));
    }

    public void loadFromJar(String path) {
        this.browser.navigation().loadUrl(this.getClass().getResource(path).toString());
    }

    public void reload() {
        this.browser.navigation().reload();
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Browser getDebugBrowser() {
        return this.debugBrowser;
    }

    public void disposeBrowserObjects() {
        if (this.browser != null) {
            try {
                this.browser.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.browser = null;
        }
        this.view = null;
        if (this.debugBrowser != null) {
            try {
                this.debugBrowser.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.debugBrowser = null;
        }
        this.debugView = null;
        if (this.browserEngine != null) {
            try {
                this.browserEngine.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.browserEngine = null;
        }
    }

    public void initialiseSplitterPosition(int windowHeight) {
        if (Settings.showBrowserDebugger() && this.splitPane != null) {
            this.splitPane.setDividerLocation(windowHeight * 2 / 3);
        }
    }

    public void initialiseSplitterPosition(int orientation, int dividePoint) {
        if (Settings.showBrowserDebugger() && this.splitPane != null) {
            this.splitPane.setOrientation(orientation);
            this.splitPane.setDividerLocation(dividePoint);
        }
    }
}

