/*
 * Decompiled with CFR 0.152.
 */
package jpos.capillary;

import java.sql.SQLException;
import jpos.PosUtils;
import jpos.RestRequest;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.SystemSettings;
import org.jdom.Element;

public class CapillaryLoyaltySetup {
    private static final String PERSON_SCREEN = "/index.php";
    private static final String REDEMPTION_SCREEN = "/redeemPoints.php";
    private String loyaltyApiUrl;
    private String baseSiteUrl;
    private String personScreenUrl;
    private String redemptionScreenUrl;
    private String username;
    private String password;
    public static String ApiAuthV1 = "v1.1";
    public static String ApiAuthV2 = "v2";

    public CapillaryLoyaltySetup() {
        this.loadSettings();
    }

    private void loadSettings() {
        String select = "SELECT PARSTR FROM SYSPARAM WHERE PARIDX = " + SystemSettings.SystemSetting.CAPILLARY_LOYALTY_SETUP.getParidx();
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, select);){
            String[] parser;
            if (sql.next() && (parser = sql.getString(1).split("@")).length > 0) {
                this.baseSiteUrl = parser[0];
                if (parser.length == 2) {
                    this.loyaltyApiUrl = parser[1];
                }
                if (SP.sParams.checkIConn()) {
                    SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("capillary_storesetup", Long.toString(SP.sParams.getStoreIdx())).getXML();
                    if (SP.sParams.root != null) {
                        Element root = (Element)SP.sParams.root.clone();
                        if (root.getAttribute("username") != null) {
                            this.username = root.getAttribute("username").getValue();
                        }
                        if (root.getAttribute("password") != null) {
                            this.password = root.getAttribute("password").getValue();
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public String getLoyaltyApiUrl() {
        return StringUtils.nullToEmpty(this.loyaltyApiUrl);
    }

    public String getPersonScreenUrl() {
        this.personScreenUrl = StringUtils.nullToEmpty(this.baseSiteUrl);
        if (this.personScreenUrl.length() > 0) {
            this.personScreenUrl = RestRequest.formatBaseURL(this.personScreenUrl) + PERSON_SCREEN;
        }
        return this.personScreenUrl;
    }

    public String getRedemptionScreenUrl() {
        this.redemptionScreenUrl = StringUtils.nullToEmpty(this.baseSiteUrl);
        if (this.redemptionScreenUrl.length() > 0) {
            this.redemptionScreenUrl = RestRequest.formatBaseURL(this.redemptionScreenUrl) + REDEMPTION_SCREEN;
        }
        return this.redemptionScreenUrl;
    }

    public String getUsername() {
        return StringUtils.nullToEmpty(this.username);
    }

    public String getPassword() {
        return StringUtils.nullToEmpty(this.password);
    }

    public String getApiAuthVersion1() {
        return ApiAuthV1;
    }

    public String getApiAuthVersion2() {
        return ApiAuthV2;
    }

    public boolean isUsingLoyaltyApi() {
        return this.getLoyaltyApiUrl().length() > 0;
    }

    public boolean isUsingCapillaryMicrositeScreen() {
        return this.getPersonScreenUrl().length() > 0 && this.getUsername().length() > 0 && this.getPassword().length() > 0;
    }
}

