/*
 * Decompiled with CFR 0.152.
 */
package jpos.capillary;

import com.google.gson.Gson;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import jpos.PosUtils;
import jpos.SP;
import jpos.capillary.CapillaryCustomer;
import jpos.capillary.CapillaryRedemption;
import jpos.capillary.CapillaryResult;
import jpos.logging.RollingLog;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class CapillaryUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCardNumberFromDatabase(long peridx) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT CARDNO FROM PERLOYALTY WHERE PERIDX = ? AND \"ACTIVE\" = 1 ORDER BY CARDNO");){
            stmt.setLong(1, peridx);
            try (ResultSet result = stmt.executeQuery();){
                if (!result.next()) return null;
                String string = result.getString("CARDNO");
                return string;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getPeridxFromDatabase(String externalID) {
        if (externalID == null) return -1L;
        if (externalID.length() == 0) {
            return -1L;
        }
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT PERIDX FROM PERLOYALTY WHERE CARDNO = ? AND \"ACTIVE\" = 1");){
            stmt.setString(1, externalID);
            try (ResultSet result = stmt.executeQuery();){
                if (!result.next()) return 0L;
                long l = result.getLong("PERIDX");
                return l;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return 0L;
    }

    public static boolean redeemRewards() {
        return true;
    }

    public static String getEncodeBasicAuth(String username, String password, boolean isHashRequired) {
        String result = null;
        try {
            String hashpassword = password;
            if (isHashRequired) {
                hashpassword = DigestUtils.md5Hex((String)password);
            }
            String baseStr = username + ":" + hashpassword;
            result = new String(Base64.encodeBase64((byte[])baseStr.getBytes()));
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return result;
    }

    public static String getMd5Password(String password) {
        String result = null;
        try {
            result = DigestUtils.md5Hex((String)password);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return result;
    }

    public static CapillaryResult loadCapillaryResult(String capillaryJson) {
        CapillaryResult capillaryResult = null;
        try {
            Gson gson = new Gson();
            capillaryResult = (CapillaryResult)gson.fromJson(capillaryJson, CapillaryResult.class);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return capillaryResult;
    }

    public static CapillaryCustomer getCapillaryCustomer(CapillaryResult capillaryResult) {
        CapillaryCustomer capillaryCustomer = new CapillaryCustomer();
        try {
            CapillaryResult.CapillaryResponse.Customers.Customer cust = capillaryResult.response.customers.customer.get(0);
            if (cust != null) {
                capillaryCustomer.setExternalId(cust.external_id);
                capillaryCustomer.setFirstName(cust.firstname);
                capillaryCustomer.setLastName(cust.lastname);
                capillaryCustomer.setMobile(cust.mobile);
                capillaryCustomer.setEmail(cust.email);
                capillaryCustomer.setCustomerType(cust.current_slab);
                capillaryCustomer.setPointsBalance(cust.loyalty_points);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return capillaryCustomer;
    }

    public static CapillaryRedemption loadCapillaryRedemptionData(String capillaryJson) {
        CapillaryRedemption capillaryRedemption = null;
        try {
            Gson gson = new Gson();
            capillaryRedemption = (CapillaryRedemption)gson.fromJson(capillaryJson, CapillaryRedemption.class);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return capillaryRedemption;
    }

    public static void LogCapillaryPayload(boolean request, Object jsonObj) {
        Gson gson = new Gson();
        String json = gson.toJson(jsonObj);
        RollingLog.log(RollingLog.LogType.CAPILLARY, Level.INFO, String.format("Capillary %s : %s", request ? "Request" : "Response", json));
    }
}

