/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import jpos.PosDouble;
import jpos.PosUtils;
import jpos.StringUtils;

public class DeliveryMethod
implements Comparable<DeliveryMethod> {
    private long id;
    private PosDouble price = new PosDouble(0.0);
    private String code;
    private String name;
    private long carrierId;
    private long serviceTypeId;
    private boolean defaultFlag = false;

    public DeliveryMethod() {
    }

    public DeliveryMethod(long id, String code, String name, String extend) {
        this.populateFromRefcode(id, code, name, extend);
    }

    @Override
    public int compareTo(DeliveryMethod o) {
        int comparison = Boolean.compare(o.defaultFlag, this.defaultFlag);
        if (comparison == 0) {
            comparison = this.price.compareTo(o.price);
        }
        return comparison;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof DeliveryMethod) {
            return this.id == ((DeliveryMethod)o).getId();
        }
        return false;
    }

    public PosDouble getPrice() {
        return this.price;
    }

    public void setPrice(PosDouble price) {
        this.price = price;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCarrierId() {
        return this.carrierId;
    }

    public void setCarrierId(long carrierId) {
        this.carrierId = carrierId;
    }

    public long getServiceTypeId() {
        return this.serviceTypeId;
    }

    public void setServiceTypeId(long serviceTypeId) {
        this.serviceTypeId = serviceTypeId;
    }

    public boolean isDefault() {
        return this.defaultFlag;
    }

    public void populateFromRefcode(long id, String code, String name, String extend) {
        this.id = id;
        this.code = StringUtils.nullToEmpty(code);
        this.name = StringUtils.nullToEmpty(name);
        if (!StringUtils.isNullOrEmpty(extend)) {
            String[] values = extend.split("@");
            if (values.length > 1) {
                this.carrierId = PosUtils.longVal(values[1]);
            }
            if (values.length > 2) {
                this.serviceTypeId = PosUtils.longVal(values[2]);
            }
            if (values.length > 3) {
                this.price = new PosDouble(PosUtils.doubleValInternal(values[3]));
            }
            if (values.length > 4) {
                this.defaultFlag = PosUtils.booleanVal(values[4]);
            }
        }
    }
}

