/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.custorder.CurrentOrder;
import jpos.custorder.Pack;
import jpos.custorder.Product;
import jpos.custorder.ServiceLevelAgreement;
import jpos.custorder.UnattendedDeliveryOptions;
import jpos.person.Country;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class DespatchInfo {
    private DespatchType despatchType = DespatchType.getDefault();
    private String orderNumber;
    private String customerOrderNumber;
    private String customerName;
    private boolean despatchSuccessful = false;
    private String readyDateTime;
    private String deliveryLocnidx;
    private String billingLocnidx;
    private String companyName;
    private String addressLine1;
    private String addressLine2;
    private String city;
    private String state;
    private String postcode;
    private Country country = new Country();
    private String phone;
    private String mobile;
    private double goodsValue = 6.66;
    private String email;
    private String despatchLocation;
    private String dateLastModified;
    private String originalDocketNumber;
    private boolean returnAddressExists;
    private String returnCompanyName;
    private String returnContactName;
    private String returnAddressLine1;
    private String returnAddressLine2;
    private String returnCity;
    private String returnState;
    private String returnPostcode;
    private Country returnCountry = new Country();
    private Country countryOfOrigin = new Country();
    private String returnPhone;
    private String returnEmail;
    private boolean poBox;
    private long originalVhidx;
    private UnattendedDeliveryOptions unattendedDeliveryOption;
    private String deliveryInstructions;
    private Vector<Pack> packs;
    private Vector<Product> products;
    private String connoteNumber = null;
    private String carrierName = "";
    private double nonStockedDue;
    private double freightValue = 0.0;
    private String carrierIdx;
    private String serviceTypeIdx;
    private String finalServiceTypeIdx;
    private String origin;
    private Pattern poBoxPattern;
    private String trackingNumber;
    private ServiceLevelAgreement serviceLevelAgreement = null;
    private String finalCarrierIdx;
    private LocalDate expectedDeliveryDate;
    private boolean shipFromCurrent = false;

    public DespatchInfo() {
        this.loadPackTypes();
        this.loadDespatchLocation();
        this.LoadReturnLocation();
        this.loadCountryOfOrigin();
        this.poBoxPattern = Pattern.compile("p[\\.]*o[\\.]*[\\s]+box", 2);
    }

    private void loadPackTypes() {
        this.packs = new Vector();
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT R.RCIDX, R.CODE, R.NAME, R.LINKIDX as WEIGHT, P.\"LENGTH\", P.WIDTH, P.DEPTH, P.ALT_NAME FROM REFCODE R, PACK_TYPE_EXTEND P WHERE R.RGIDX = 29 AND R.RCIDX = P.RCIDX AND R.\"ACTIVE\" = 1 ORDER BY R.NAME");){
            while (sql.next()) {
                this.packs.add(new Pack(sql.getLong("RCIDX"), sql.getString("CODE"), sql.getString("NAME"), sql.getString("ALT_NAME"), sql.getDouble("WEIGHT"), sql.getDouble("LENGTH"), sql.getDouble("WIDTH"), sql.getDouble("DEPTH")));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void loadDespatchLocation() {
        this.despatchLocation = SP.sParams.getStore().getCode();
    }

    public DespatchType getDespatchType() {
        return this.despatchType;
    }

    public void setDespatchType(DespatchType despatchType) {
        this.despatchType = despatchType;
    }

    public String getCompanyName() {
        return StringUtils.nullToEmpty(this.companyName);
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getDeliveryLocnidx() {
        return this.deliveryLocnidx;
    }

    public void setDeliveryLocnidx(String deliveryLocnidx) {
        this.deliveryLocnidx = deliveryLocnidx;
    }

    public String getBillingLocnidx() {
        return this.billingLocnidx;
    }

    public void setBillingLocnidx(String billingLocnidx) {
        this.billingLocnidx = billingLocnidx;
    }

    public String getAddressLine1() {
        return StringUtils.nullToEmpty(this.addressLine1);
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        this.checkForPoBox();
    }

    public String getAddressLine2() {
        return StringUtils.nullToEmpty(this.addressLine2);
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        this.checkForPoBox();
    }

    public String getCity() {
        return StringUtils.nullToEmpty(this.city);
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return StringUtils.nullToEmpty(this.state);
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostcode() {
        return StringUtils.nullToEmpty(this.postcode);
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public String getPhone() {
        return StringUtils.nullToEmpty(this.phone);
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMobile() {
        return StringUtils.nullToEmpty(this.mobile);
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getBestPhoneNumber() {
        String validatedNumber = DespatchInfo.validateAndReturnPhoneNumber(this.getMobile(), this.getCountry().getCode(), PhoneNumberUtil.PhoneNumberType.MOBILE);
        if (validatedNumber.length() > 0) {
            return validatedNumber;
        }
        validatedNumber = DespatchInfo.validateAndReturnPhoneNumber(this.getPhone(), this.getCountry().getCode(), PhoneNumberUtil.PhoneNumberType.MOBILE);
        if (validatedNumber.length() > 0) {
            return validatedNumber;
        }
        validatedNumber = DespatchInfo.validateAndReturnPhoneNumber(this.getMobile(), this.getCountry().getCode(), PhoneNumberUtil.PhoneNumberType.FIXED_LINE_OR_MOBILE);
        if (validatedNumber.length() > 0) {
            return validatedNumber;
        }
        validatedNumber = DespatchInfo.validateAndReturnPhoneNumber(this.getPhone(), this.getCountry().getCode(), PhoneNumberUtil.PhoneNumberType.FIXED_LINE_OR_MOBILE);
        if (validatedNumber.length() > 0) {
            return validatedNumber;
        }
        return this.getMobile().length() > 0 ? this.getMobile() : this.getPhone();
    }

    private static String validateAndReturnPhoneNumber(String phone, String isoCountryCode, PhoneNumberUtil.PhoneNumberType type) {
        if (StringUtils.isNullOrEmpty(phone) || StringUtils.isNullOrEmpty(isoCountryCode)) {
            return "";
        }
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        try {
            Phonenumber.PhoneNumber phoneNumber = phoneUtil.parse((CharSequence)phone, isoCountryCode);
            if (phoneUtil.isValidNumber(phoneNumber) && phoneUtil.getNumberType(phoneNumber) == type) {
                return phoneUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
            }
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
        return "";
    }

    public Vector<Pack> getPacks() {
        return this.packs;
    }

    public Vector<Product> getProducts() {
        if (this.products == null) {
            this.products = new Vector();
        }
        return this.products;
    }

    public String getOrderNumber() {
        return StringUtils.nullToEmpty(this.orderNumber);
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getCustomerOrderNumber() {
        return StringUtils.nullToEmpty(this.customerOrderNumber);
    }

    public void setCustomerOrderNumber(String customerOrderNumber) {
        this.customerOrderNumber = customerOrderNumber;
    }

    public String getCustomerName() {
        return StringUtils.nullToEmpty(this.customerName);
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCarrierName() {
        return StringUtils.nullToEmpty(this.carrierName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getCarrierIdxFromName() {
        if (StringUtils.isNullOrEmpty(this.carrierName)) {
            return 0L;
        }
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT R.RCIDX FROM REFCODE R WHERE R.RGIDX = 202 AND R.\"ACTIVE\" = 1   AND (UPPER(R.CODE) = UPPER(?) OR UPPER(R.NAME) = UPPER(?))");){
            stmt.setString(1, this.carrierName.length() > 15 ? this.carrierName.substring(0, 15) : this.carrierName);
            stmt.setString(2, this.carrierName.length() > 40 ? this.carrierName.substring(0, 40) : this.carrierName);
            try (ResultSet result = stmt.executeQuery();){
                if (!result.next()) return 0L;
                long l = result.getLong(1);
                return l;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return 0L;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public String getEmail() {
        return StringUtils.nullToEmpty(this.email);
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getConnoteNumber() {
        return StringUtils.nullToEmpty(this.connoteNumber);
    }

    public double getGoodsValue() {
        return this.goodsValue;
    }

    public void setGoodsValue(double goodsValue) {
        this.goodsValue = goodsValue;
    }

    public void setConnoteNumber(String connoteNumber) {
        this.connoteNumber = connoteNumber;
    }

    public String getDespatchLocation() {
        return StringUtils.nullToEmpty(this.despatchLocation);
    }

    public boolean getDespatchSuccessful() {
        return this.despatchSuccessful;
    }

    public void setDespatchSuccessful(boolean success) {
        this.despatchSuccessful = success;
    }

    public void setReadyDateTime(String readyDate) {
        this.readyDateTime = readyDate;
    }

    public String getReadyDateTime() {
        return StringUtils.nullToEmpty(this.readyDateTime);
    }

    public void setNonStockedValue(double nonStockedDue) {
        this.nonStockedDue = nonStockedDue;
    }

    public void setFreightValue(double freightValue) {
        this.freightValue = freightValue;
    }

    public void setDateLastModified(String lastModified) {
        this.dateLastModified = lastModified;
    }

    public String getDateLastModified() {
        return this.dateLastModified;
    }

    public void setOriginalDocketNumber(String originalDocketNumber) {
        this.originalDocketNumber = originalDocketNumber;
    }

    public String getOriginalDocketNumber() {
        return this.originalDocketNumber;
    }

    public double getNonStockedValue() {
        return this.nonStockedDue;
    }

    public double getFreightValue() {
        return this.freightValue;
    }

    public OrderModifiedStatus getTransactionModifiedStatus() {
        if (this.getOriginalDocketNumber() == null) {
            return OrderModifiedStatus.ORDER_NOT_MODIFIED;
        }
        SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("trans", this.getOriginalDocketNumber()).getXML();
        if (SP.sParams.root == null) {
            return OrderModifiedStatus.ONLINE_QUERY_FAILED;
        }
        Element trans = new Element("transaction");
        List attributes = SP.sParams.root.getAttributes();
        while (attributes.size() > 0) {
            trans.setAttribute(((Attribute)attributes.get(0)).detach());
        }
        if (trans.getAttribute("last_updated") == null || trans.getAttribute("last_updated").getValue() == null) {
            return OrderModifiedStatus.ONLINE_QUERY_FAILED;
        }
        try {
            if (trans.getAttribute("change_pending_widx") != null && trans.getAttribute("change_pending_widx").getLongValue() != SP.sParams.getStoreIdx()) {
                return OrderModifiedStatus.ORDER_MODIFIED;
            }
        }
        catch (DataConversionException e) {
            return OrderModifiedStatus.ONLINE_QUERY_FAILED;
        }
        if (trans.getAttribute("last_updated").getValue().equals(this.getDateLastModified())) {
            return OrderModifiedStatus.ORDER_NOT_MODIFIED;
        }
        return OrderModifiedStatus.ORDER_MODIFIED;
    }

    public CurrentOrder getCurrentOrder() {
        CurrentOrder currentOrder = new CurrentOrder();
        try {
            long vhidx = this.getOriginalVhidx();
            if (vhidx != 0L) {
                SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("current_order", Long.toString(vhidx)).getXML();
                if (SP.sParams.root == null) {
                    currentOrder.Error = "Online query failed";
                    return currentOrder;
                }
                Element currentOrderElm = new Element("current_order");
                List attrib = SP.sParams.root.getAttributes();
                while (attrib.size() > 0) {
                    currentOrderElm.setAttribute(((Attribute)attrib.get(0)).detach());
                }
                String sVhidx = currentOrderElm.getAttribute("vhidx").getValue();
                String sTimestamp = currentOrderElm.getAttribute("timestamp").getValue();
                String sError = currentOrderElm.getAttribute("error").getValue();
                currentOrder.Vhidx = sVhidx;
                currentOrder.Timestamp = sTimestamp;
                currentOrder.Error = sError;
            }
        }
        catch (Exception e) {
            String errorDetails = e.getMessage();
            if (errorDetails != null && errorDetails.length() > 500) {
                errorDetails = errorDetails.substring(0, 499);
            }
            currentOrder.Error = errorDetails == null ? "" : errorDetails;
        }
        return currentOrder;
    }

    public Lock getLock(long memidx) {
        Lock lock = new Lock();
        lock.Error = "";
        long vhidx = this.getOriginalVhidx();
        if (vhidx == 0L) {
            lock.OrderLockStatus = OrderLockingStatus.LOCKED;
            return lock;
        }
        if (!SP.sParams.checkIConn()) {
            lock.OrderLockStatus = OrderLockingStatus.OFFLINE;
            return lock;
        }
        SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("lock", Long.toString(vhidx) + "," + Long.toString(memidx)).getXML();
        if (SP.sParams.root == null) {
            lock.OrderLockStatus = OrderLockingStatus.ONLINE_QUERY_FAILED;
            return lock;
        }
        Element lockElm = new Element("lock");
        List attrib = SP.sParams.root.getAttributes();
        while (attrib.size() > 0) {
            lockElm.setAttribute(((Attribute)attrib.get(0)).detach());
        }
        try {
            if (lockElm.getAttribute("haveLock").getBooleanValue()) {
                lock.OrderLockStatus = OrderLockingStatus.LOCKED;
            } else if (lockElm.getAttribute("error").getValue().length() == 0) {
                lock.lockedByName = lockElm.getAttribute("lockedByName").getValue();
                lock.LockedBySystem = lockElm.getAttribute("lockedBySystem").getValue();
                lock.OrderLockStatus = OrderLockingStatus.ALREADY_LOCKED;
            } else {
                lock.Error = lockElm.getAttribute("error").getValue();
                lock.ErrorDontContinue = lockElm.getAttribute("dontContinue").getBooleanValue();
                if (lock.Error.equals("OrderNotFound")) {
                    lock.Error = SP.getRS("Order_Not_Found_For_Locking");
                }
                if (lock.Error.equals("OrderHasPendingUpdates")) {
                    lock.Error = SP.getRS("Order_Has_Pending_Updates");
                }
                lock.OrderLockStatus = OrderLockingStatus.ONLINE_QUERY_FAILED;
            }
        }
        catch (DataConversionException e) {
            lock.OrderLockStatus = OrderLockingStatus.ONLINE_QUERY_FAILED;
        }
        return lock;
    }

    public void getUnlock(boolean modified) {
        Long vhidx = this.getOriginalVhidx();
        if (vhidx == 0L) {
            return;
        }
        if (SP.sParams.checkIConn()) {
            SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("unlock", Long.toString(vhidx) + "," + Boolean.toString(modified)).getXML();
        }
    }

    private void LoadReturnLocation() {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("select l.contact, l.tradename, l.adrs1, l.adrs2, l.city, l.state, l.postcode, l.country, main.phonenum as main_num, email.phonenum as email_num from whse w join refcode r on w.sfs_return_widx = r.rcidx and r.\"ACTIVE\" = 1 join locn l on l.locnidx = r.linkidx and l.\"ACTIVE\" = 1 left join phonenum main on main.locnidx = l.locnidx and main.phonetyidx = 154 and main.\"ACTIVE\" = 1 left join phonenum email on email.locnidx = l.locnidx and email.phonetyidx = 159 and email.\"ACTIVE\" = 1 where w.widx = ?");){
            stmt.setLong(1, SP.sParams.getStoreIdx());
            try (ResultSet result = stmt.executeQuery();){
                if (result.next()) {
                    this.returnAddressExists = true;
                    this.returnCompanyName = result.getString("TRADENAME");
                    this.returnContactName = result.getString("CONTACT");
                    this.returnAddressLine1 = result.getString("ADRS1");
                    this.returnAddressLine2 = result.getString("ADRS2");
                    this.returnCity = result.getString("CITY");
                    this.returnState = result.getString("STATE");
                    this.returnPostcode = result.getString("POSTCODE");
                    this.returnCountry = new Country(result.getString("COUNTRY"));
                    this.returnPhone = result.getString("MAIN_NUM");
                    this.returnEmail = result.getString("EMAIL_NUM");
                } else {
                    this.returnAddressExists = false;
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void loadCountryOfOrigin() {
        this.countryOfOrigin = PosUtils.getCountryOfOrigin();
    }

    public String getReturnCompanyName() {
        return StringUtils.nullToEmpty(this.returnCompanyName);
    }

    public String getReturnContactName() {
        return StringUtils.nullToEmpty(this.returnContactName);
    }

    public String getReturnAddressLine1() {
        return StringUtils.nullToEmpty(this.returnAddressLine1);
    }

    public String getReturnAddressLine2() {
        return StringUtils.nullToEmpty(this.returnAddressLine2);
    }

    public String getReturnCity() {
        return StringUtils.nullToEmpty(this.returnCity);
    }

    public String getReturnState() {
        return StringUtils.nullToEmpty(this.returnState);
    }

    public String getReturnPostcode() {
        return StringUtils.nullToEmpty(this.returnPostcode);
    }

    public Country getReturnCountry() {
        return this.returnCountry;
    }

    public String getReturnPhone() {
        return StringUtils.nullToEmpty(this.returnPhone);
    }

    public String getReturnEmail() {
        return StringUtils.nullToEmpty(this.returnEmail);
    }

    public boolean getReturnAddressExists() {
        return this.returnAddressExists;
    }

    public Country getCountryOfOrigin() {
        return this.countryOfOrigin;
    }

    public boolean isPoBox() {
        return this.poBox;
    }

    public void setPoBox(boolean poBox) {
        this.poBox = poBox;
    }

    public void setCarrierIdx(String carrierIdx) {
        this.carrierIdx = carrierIdx;
    }

    public void setServiceTypeIdx(String serviceTypeIdx) {
        this.serviceTypeIdx = serviceTypeIdx;
        this.finalServiceTypeIdx = serviceTypeIdx;
    }

    public void setFinalServiceTypeIdx(String serviceTypeIdx) {
        this.finalServiceTypeIdx = serviceTypeIdx;
    }

    public void setFinalCarrierIdx(String carrierIdx) {
        this.finalCarrierIdx = carrierIdx;
    }

    public String getCarrierIdx() {
        return this.carrierIdx;
    }

    public String getServiceTypeIdx() {
        return this.serviceTypeIdx;
    }

    public String getFinalServiceTypeIdx() {
        return this.finalServiceTypeIdx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDynamicServiceType(String serviceTypeIdx) {
        if (StringUtils.isNullOrEmpty(serviceTypeIdx)) {
            return false;
        }
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT COALESCE(R.EXTEND, '0') FROM REFCODE R WHERE R.RCIDX = " + serviceTypeIdx);){
            if (!sql.next()) return false;
            if (!sql.getString(1).startsWith("1")) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean printCustomsInvoice() {
        if (StringUtils.isNullOrEmpty(this.serviceTypeIdx)) {
            return true;
        }
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT COALESCE(R.EXTEND, '0') FROM REFCODE R WHERE R.RCIDX = " + this.serviceTypeIdx);){
            if (!sql.next()) return true;
            String extend = sql.getString(1);
            String[] serviceTypeSettings = extend.split("@");
            if (serviceTypeSettings.length < 3) return true;
            boolean bl = serviceTypeSettings[2].startsWith("0");
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean allowMultipleCartons() {
        if (StringUtils.isNullOrEmpty(this.serviceTypeIdx)) {
            return true;
        }
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT COALESCE(R.EXTEND, '0') FROM REFCODE R WHERE R.RCIDX = " + this.serviceTypeIdx);){
            if (!sql.next()) return true;
            String extend = sql.getString(1);
            String[] serviceTypeSettings = extend.split("@");
            if (serviceTypeSettings.length < 4) return true;
            boolean bl = serviceTypeSettings[3].startsWith("1");
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return true;
    }

    public Long getFinalCarrierIdx() {
        if (this.finalCarrierIdx != null && !this.finalCarrierIdx.isEmpty()) {
            return PosUtils.longVal(this.finalCarrierIdx);
        }
        return this.getCarrierIdxFromName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getRefName(String rcidx) {
        if (StringUtils.isNullOrEmpty(rcidx)) {
            return "";
        }
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT R.NAME FROM REFCODE R WHERE R.RCIDX = ? AND R.\"ACTIVE\" = 1 ");){
            stmt.setString(1, rcidx);
            try (ResultSet result = stmt.executeQuery();){
                if (!result.next()) return "";
                String string = result.getString(1);
                return string;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return "";
    }

    public String getCarrierDescription() {
        return this.getRefName(this.carrierIdx);
    }

    public String getServiceTypeDescription() {
        return this.getRefName(this.serviceTypeIdx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getThirdPartyRefocde(String thirdPartyCode, String rcidx) {
        if (StringUtils.isNullOrEmpty(thirdPartyCode)) return "";
        if (StringUtils.isNullOrEmpty(rcidx)) {
            return "";
        }
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT E.EXT_CODE FROM REFCODE_EXTERNAL E, REFCODE R1, REFCODE R2 WHERE E.EXT_RCIDX = R1.RCIDX AND R1.RGIDX = 440 AND R1.\"ACTIVE\" = 1 AND UPPER(R1.CODE) = UPPER(?) AND E.RCIDX = R2.RCIDX AND R2.\"ACTIVE\" = 1 AND R2.RCIDX = ?");){
            stmt.setString(1, thirdPartyCode);
            stmt.setString(2, rcidx);
            try (ResultSet result = stmt.executeQuery();){
                if (!result.next()) return "";
                String string = result.getString(1);
                return string;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return "";
    }

    private void checkForPoBox() {
        String fullAddress = StringUtils.nullToEmpty(this.getAddressLine1()) + " " + StringUtils.nullToEmpty(this.getAddressLine2());
        this.setPoBox(this.poBoxPattern.matcher(fullAddress).find());
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getDeliveryInstructions() {
        return StringUtils.nullToEmpty(this.deliveryInstructions);
    }

    public void setDeliveryInstructions(String deliveryInstructions) {
        this.deliveryInstructions = deliveryInstructions;
    }

    public UnattendedDeliveryOptions getUnattendedDeliveryOption() {
        return this.unattendedDeliveryOption;
    }

    public void setUnattendedDeliveryOption(UnattendedDeliveryOptions unattendedDeliveryOption) {
        this.unattendedDeliveryOption = unattendedDeliveryOption;
    }

    public ServiceLevelAgreement getServiceLevelAgreement() {
        return this.serviceLevelAgreement;
    }

    public void setServiceLevelAgreement(ServiceLevelAgreement serviceLevelAgreement) {
        this.serviceLevelAgreement = serviceLevelAgreement;
    }

    public long getOriginalVhidx() {
        return this.originalVhidx;
    }

    public void setOriginalVhidx(long originalVhidx) {
        this.originalVhidx = originalVhidx;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public LocalDate getExpectedDeliveryDate() {
        return this.expectedDeliveryDate;
    }

    public void setExpectedDeliveryDate(LocalDate expectedDeliveryDate) {
        this.expectedDeliveryDate = expectedDeliveryDate;
    }

    public void setShipFromCurrent(boolean shipFromcurrent) {
        this.shipFromCurrent = shipFromcurrent;
    }

    public boolean getShipFromCurrent() {
        return this.shipFromCurrent;
    }

    public class Lock {
        public OrderLockingStatus OrderLockStatus;
        public String lockedByName;
        public String LockedBySystem;
        public Date LockedSince;
        public String Error;
        public boolean ErrorDontContinue;
    }

    public static enum OrderLockingStatus {
        UNLOCKED,
        LOCKED,
        ALREADY_LOCKED,
        ONLINE_QUERY_FAILED,
        OFFLINE;

    }

    public static enum OrderModifiedStatus {
        ORDER_NOT_MODIFIED,
        ORDER_MODIFIED,
        ONLINE_QUERY_FAILED;

    }

    public static enum DespatchType {
        CUSTOMER_PICKUP(0),
        STORE_DESPATCH(1);

        private int integerValue = 0;

        private DespatchType(int integerValue) {
            this.integerValue = integerValue;
        }

        public int getIntegerValue() {
            return this.integerValue;
        }

        public static DespatchType mapDespatchType(int integerValue) {
            for (DespatchType t : DespatchType.values()) {
                if (t.getIntegerValue() != integerValue) continue;
                return t;
            }
            return DespatchType.getDefault();
        }

        public static DespatchType getDefault() {
            return CUSTOMER_PICKUP;
        }
    }
}

