/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.custorder.DespatchInfo;
import jpos.custorder.IDespatcher;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.TouchTextArea;

public class DlgBookingSummary
extends PosDialog {
    DespatchInfo despatchInfo = null;
    IDespatcher despatcher;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private TouchTextArea taBookingSummary = new TouchTextArea();
    private LabelNormal lOrderNumber = new LabelNormal();
    private LabelNormal lBookingInformation = new LabelNormal();
    private DialogButton bPrintLabels = new DialogButton("");
    private DialogButton bClose = new DialogButton("");
    private boolean printed = false;

    public DlgBookingSummary(PosFrame frame, DespatchInfo despatchInfo, IDespatcher despatcher) {
        super(frame, SP.getRS("Booking_Confirmation"), true);
        this.frParent = frame;
        this.despatchInfo = despatchInfo;
        this.despatcher = despatcher;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.lOrderNumber.setHorizontalAlignment(2);
        this.lOrderNumber.setText(MessageFormat.format(SP.getRS("Order_X"), this.despatchInfo.getOrderNumber()));
        this.lBookingInformation.setHorizontalAlignment(2);
        this.lBookingInformation.setText(SP.getRS("Booking_Information"));
        this.taBookingSummary.setEditable(false);
        this.taBookingSummary.setText(this.despatcher.getBookingSummary(this.despatchInfo));
        this.taBookingSummary.setLineWrap(true);
        this.taBookingSummary.setWrapStyleWord(true);
        this.bPrintLabels.setText(StoreParams.res.getString("Print_Labels"));
        this.bPrintLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBookingSummary.this.okDialog();
            }
        });
        this.bClose.setText(StoreParams.res.getString("Close"));
        this.bClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBookingSummary.this.cancelDialog();
            }
        });
        this.setLayout(this.gridBagLayout);
        this.getContentPane().add((Component)this.lOrderNumber, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.lBookingInformation, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.taBookingSummary, new GridBagConstraints(0, 2, 1, 1, 1.0, 2.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.bPrintLabels, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.bClose, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.taBookingSummary);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.setSize(new Dimension(315, 420));
        PosUtils.centreWindow(this);
    }

    @Override
    public void cancelDialog() {
        if (this.printed || 0 == DlgMessage.showMessage(this, SP.getRS("labels_not_printed_message"), SP.getRS("labels_not_printed_title"), 0, 3)) {
            this.dispose();
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void okDialog() {
        this.printLabels();
    }

    private void printLabels() {
        if (!this.despatcher.printLabels(this.despatchInfo)) {
            DlgMessage.showMessage(this.frParent, this.despatcher.getPrintError());
        } else {
            this.printed = true;
        }
    }
}

