/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.TotalsTable;
import jpos.custorder.scanpack.ScanPackLine;
import jpos.custorder.scanpack.ScanPackTable;
import jpos.custorder.scanpack.ScanPackTableModel;
import jpos.custorder.scanpack.ScanPackTotalsTableModel;
import jpos.ui.DialogButton;

public class DlgCancelItems
extends PosDialog {
    private ScanPackTable scanPackTable;
    private TotalsTable totalsTable;
    private ScanPackTotalsTableModel scanPackTotalsTableModel;
    private DialogButton cancelAllButton = new DialogButton("");
    private DialogButton okButton = new DialogButton("");
    private List<StyleLine> styleLines;
    private boolean result = false;

    public DlgCancelItems(PosFrame frame, List<StyleLine> styleLines) {
        super(frame, SP.getRS("Cancel_dlg"), true);
        this.styleLines = styleLines;
        this.setAcceptOnEnter(false);
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        ScanPackTableModel scanPackTableModel = new ScanPackTableModel(true){

            @Override
            public boolean canChangeCancelValue(ScanPackLine line) {
                if (line.getPickSlipRun() != null && !line.getPickSlipRun().equals("")) {
                    DlgMessage.showMessage(DlgCancelItems.this, StoreParams.res.getString("Cannot_refund_product_line"), StoreParams.res.getString("Error"), 0);
                    return false;
                }
                return true;
            }
        };
        this.scanPackTable = new ScanPackTable((Window)this, scanPackTableModel);
        this.scanPackTotalsTableModel = new ScanPackTotalsTableModel(scanPackTableModel);
        this.totalsTable = new TotalsTable(this, this.scanPackTable, this.scanPackTotalsTableModel);
        this.scanPackTable.populate(this.styleLines);
        this.scanPackTable.getScrollPane().setPreferredSize(new Dimension(600, 402));
        this.cancelAllButton.setText(SP.getRS("Cancel_dlg_cancel_all"));
        this.cancelAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgCancelItems.this.cancelAllButton.setEnabled(false);
                DlgCancelItems.this.scanPackTable.cancelRemaining();
                DlgCancelItems.this.cancelAllButton.setEnabled(true);
            }
        });
        this.okButton.setText(StoreParams.res.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgCancelItems.this.okDialog();
            }
        });
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelHeader = new JPanel(new GridBagLayout());
        JPanel panelBody = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panelMain, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelBody, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelHeader.add((Component)new JLabel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(7, 10, 0, 10), 0, 0));
        panelBody.add((Component)this.scanPackTable.getScrollPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 0, 10), 0, 0));
        panelBody.add((Component)this.totalsTable.getScrollPane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        panelFooter.add((Component)this.cancelAllButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        panelFooter.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 10, 20), 0, 0));
        panelFooter.add((Component)this.okButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.scanPackTable);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        this.totalsTable.getColumnModel().getColumn(1).setPreferredWidth(0);
        this.totalsTable.getColumnModel().getColumn(2).setPreferredWidth(0);
        PosUtils.centreWindow(this);
    }

    public boolean getResult() {
        return this.result && ((ScanPackTableModel)this.scanPackTable.getModel()).getTotalCancelled() > 0;
    }

    public boolean isFullyCancelled() {
        return this.scanPackTable.isFullyCancelled();
    }

    @Override
    public void cancelDialog() {
        this.scanPackTable.undoCancel();
        this.result = false;
        this.dispose();
    }

    @Override
    public void okDialog() {
        this.result = true;
        this.dispose();
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 116 && this.cancelAllButton.isVisible() && this.cancelAllButton.isEnabled()) {
            this.cancelAllButton.doClick();
            return true;
        }
        return false;
    }

    public int getRowCount() {
        return this.scanPackTable.getModel().getRowCount();
    }
}

