/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PaSales;
import jpos.PosCheckBox;
import jpos.PosDialog;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.RefCombo;
import jpos.Reference;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.basscom.swing.BJTextField;
import jpos.custorder.DespatchInfo;
import jpos.custorder.IDespatcher;
import jpos.custorder.Pack;
import jpos.custorder.Product;
import jpos.custorder.UnattendedDeliveryOptions;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextArea;
import jpos.ui.TouchTextField;
import org.jdom.Element;

public class DlgPacking
extends PosDialog {
    private boolean processing = false;
    private boolean messageShowing = false;
    private boolean cancelProcessing = false;
    private boolean retryOkDialog = false;
    private static final String PACK_TYPE_HEADING = SP.getRS("Pack_Type");
    private static final String QTY_HEADING = SP.getRS("Quantity");
    DespatchInfo despatchInfo = null;
    IDespatcher despatcher;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private PosScrollPane scrollPane = new PosScrollPane();
    private PosTable tblPacks;
    private AbstractTableModel tableModel;
    private TouchTextArea taAddress = new TouchTextArea();
    private PosCheckBox isPoBox = new PosCheckBox();
    private PosCheckBox authorityToLeave = new PosCheckBox();
    private LabelSubHeading lOrderNumber = new LabelSubHeading();
    private LabelNormal lAddress = new LabelNormal();
    private LabelNormal lConsignmentNote = new LabelNormal();
    private LabelNormal lCarrierSelection = new LabelNormal();
    private LabelNormal lServiceTypeSelection = new LabelNormal();
    private LabelNormal lTotalPacks = new LabelNormal();
    private LabelNormal lTotalWeight = new LabelNormal();
    private LabelNormal lCarrier = new LabelNormal();
    private LabelNormal lServiceType = new LabelNormal();
    private LabelNormal lCarrierName = new LabelNormal();
    private LabelNormal lServiceTypeName = new LabelNormal();
    private LabelNormal lTotalPacksValue = new LabelNormal();
    private LabelNormal lTotalWeightValue = new LabelNormal();
    private DecimalField dfTotalPacks = new DecimalField(StoreParams.qtyFormat, 0, TouchTextField.FontSize.LARGE);
    private DecimalField dfTotalWeight;
    private RefCombo cmbCarrierSelection;
    private RefCombo cmbServiceTypeSelection;
    private BJTextField dfConsignmentNote;
    private DialogButton bOK;
    private DialogButton bCancel;
    private DialogButton bToggleDespatchMode;

    public DlgPacking(PosFrame frame, DespatchInfo despatchInfo, IDespatcher despatcher) {
        super(frame, SP.getRS("Packing_Information") + " - " + despatcher.getDespatcherTitle(), true);
        this.dfTotalWeight = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.dfConsignmentNote = new BJTextField();
        this.bOK = new DialogButton("");
        this.bCancel = new DialogButton("");
        this.bToggleDespatchMode = new DialogButton(""){

            @Override
            public int getButtonWidth() {
                return 150;
            }
        };
        this.frParent = frame;
        this.despatchInfo = despatchInfo;
        this.despatcher = despatcher;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.addProducts();
        this.lOrderNumber.setHorizontalAlignment(2);
        this.lOrderNumber.setText(MessageFormat.format(SP.getRS("Order_X"), this.despatchInfo.getOrderNumber()));
        this.lAddress.setHorizontalAlignment(2);
        this.lAddress.setText(SP.getRS("Deliver_To_Address"));
        this.taAddress.setText(this.formatAddress());
        this.taAddress.setEditable(false);
        this.isPoBox.setText(SP.getRS("PO_Box_Address"));
        this.isPoBox.setSelected(this.despatchInfo.isPoBox());
        this.isPoBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DlgPacking.this.despatchInfo.setPoBox(DlgPacking.this.isPoBox.isSelected());
            }
        });
        this.authorityToLeave.setText(SP.getRS("Auth_To_Leave"));
        this.authorityToLeave.setEnabled(false);
        this.authorityToLeave.setSelected(this.despatchInfo.getUnattendedDeliveryOption() == UnattendedDeliveryOptions.AuthorityToLeave);
        this.tableModel = new PackTableModel(this);
        this.tblPacks = new PosTable(this, this.tableModel);
        this.tblInit();
        this.lTotalPacks.setHorizontalAlignment(2);
        this.lTotalPacks.setText(SP.getRS("Total_Packs"));
        this.lTotalWeight.setHorizontalAlignment(2);
        this.lTotalWeight.setText(SP.getRS("Total_Weight"));
        this.lCarrierSelection.setHorizontalAlignment(2);
        this.lCarrierSelection.setText(SP.getRS("Carrier_Label"));
        this.lServiceTypeSelection.setHorizontalAlignment(2);
        this.lServiceTypeSelection.setText(SP.getRS("ServiceType_Label"));
        this.lConsignmentNote.setHorizontalAlignment(2);
        this.lConsignmentNote.setText(SP.getRS("Consignment_Note_Number"));
        this.lCarrier.setHorizontalAlignment(2);
        this.lCarrier.setText(SP.getRS("Carrier_Label"));
        this.lCarrierName.setHorizontalAlignment(2);
        this.lCarrierName.setText("SomeOne");
        this.lServiceType.setHorizontalAlignment(2);
        this.lServiceType.setText(SP.getRS("ServiceType_Label"));
        this.lServiceTypeName.setHorizontalAlignment(2);
        this.lServiceTypeName.setText("SomeOne");
        this.cmbCarrierSelection = new RefCombo();
        this.cmbServiceTypeSelection = new RefCombo();
        this.dfConsignmentNote.setEnabled(true);
        this.dfConsignmentNote.setFieldWidth(300);
        this.dfConsignmentNote.setMaximumCharacters(50);
        this.bOK.setText(StoreParams.res.getString("OK"));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPacking.this.okDialog();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPacking.this.cancelDialog();
            }
        });
        this.bToggleDespatchMode.setText(this.despatcher.getSwitchModeButtonText());
        this.bToggleDespatchMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPacking.this.toggleDespatchMode();
            }
        });
        this.scrollPane.setMinimumSize(new Dimension(400, 190));
        this.scrollPane.setPreferredSize(new Dimension(400, 190));
        this.setLayout(this.gridBagLayout);
        this.scrollPane.getViewport().add((Component)this.tblPacks, null);
        int currentRow = 0;
        this.getContentPane().add((Component)this.lOrderNumber, new GridBagConstraints(0, currentRow++, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.lAddress, new GridBagConstraints(0, currentRow++, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.taAddress, new GridBagConstraints(0, currentRow++, 2, 1, 1.0, 2.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (!this.despatcher.isManualMode()) {
            this.getContentPane().add((Component)this.isPoBox, new GridBagConstraints(0, currentRow, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            if (this.despatchInfo.getUnattendedDeliveryOption() == UnattendedDeliveryOptions.AuthorityToLeave) {
                this.getContentPane().add((Component)this.authorityToLeave, new GridBagConstraints(0, currentRow, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
            }
            int n = ++currentRow;
            ++currentRow;
            this.getContentPane().add((Component)this.scrollPane, new GridBagConstraints(0, n, 2, 1, 1.0, 2.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            boolean hideCarrierInfo = StringUtils.isNullOrEmpty(this.despatchInfo.getCarrierIdx());
            boolean bl = hideCarrierInfo = hideCarrierInfo || this.despatcher.canDoDynamicCarrierAllocation() && this.despatchInfo.isDynamicServiceType(this.despatchInfo.getServiceTypeIdx());
            if (!hideCarrierInfo) {
                this.getContentPane().add((Component)this.lCarrier, new GridBagConstraints(0, currentRow, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.getContentPane().add((Component)this.lCarrierName, new GridBagConstraints(1, currentRow, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
                ++currentRow;
                this.lCarrierName.setText(this.despatchInfo.getCarrierDescription());
            }
            if (!StringUtils.isNullOrEmpty(this.despatchInfo.getServiceTypeIdx())) {
                this.getContentPane().add((Component)this.lServiceType, new GridBagConstraints(0, currentRow, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.getContentPane().add((Component)this.lServiceTypeName, new GridBagConstraints(1, currentRow, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.lServiceTypeName.setText(this.despatchInfo.getServiceTypeDescription());
                ++currentRow;
            }
            this.getContentPane().add((Component)this.lTotalPacks, new GridBagConstraints(0, currentRow, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.lTotalPacksValue, new GridBagConstraints(1, currentRow, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.lTotalWeight, new GridBagConstraints(0, ++currentRow, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.lTotalWeightValue, new GridBagConstraints(1, currentRow, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            ++currentRow;
        } else {
            if (this.despatchInfo.getUnattendedDeliveryOption() == UnattendedDeliveryOptions.AuthorityToLeave) {
                this.getContentPane().add((Component)this.authorityToLeave, new GridBagConstraints(0, currentRow++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            }
            this.cmbCarrierSelection = new RefCombo(202L, "", "R.NAME");
            this.cmbCarrierSelection.setShowName(true);
            this.cmbCarrierSelection.setFieldWidth(200);
            this.cmbServiceTypeSelection = new RefCombo(259L, "", "R.NAME");
            this.cmbServiceTypeSelection.setShowName(true);
            this.cmbServiceTypeSelection.setFieldWidth(200);
            this.getContentPane().add((Component)this.lCarrierSelection, new GridBagConstraints(0, currentRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.cmbCarrierSelection, new GridBagConstraints(1, currentRow, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.lServiceTypeSelection, new GridBagConstraints(0, ++currentRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.cmbServiceTypeSelection, new GridBagConstraints(1, currentRow, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.lConsignmentNote, new GridBagConstraints(0, ++currentRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.dfConsignmentNote, new GridBagConstraints(1, currentRow, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            ++currentRow;
        }
        if (this.despatcher.allowManualOverride()) {
            JPanel buttonToggleDespatchPanel = new JPanel(new GridBagLayout());
            buttonToggleDespatchPanel.add((Component)this.bToggleDespatchMode, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)buttonToggleDespatchPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.bOK, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)buttonPanel, new GridBagConstraints(0, currentRow, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        if (!this.despatcher.isManualMode()) {
            v.add(this.tblPacks);
        } else {
            v.add(this.cmbCarrierSelection);
            v.add(this.cmbServiceTypeSelection);
            v.add(this.dfConsignmentNote);
            if (!this.despatchInfo.getConnoteNumber().isEmpty()) {
                this.dfConsignmentNote.setText(this.despatchInfo.getConnoteNumber());
            }
            if (this.despatchInfo.getCarrierName().isEmpty() && StringUtils.isNullOrEmpty(this.despatchInfo.getCarrierIdx())) {
                this.cmbCarrierSelection.setSelectedIndex(-1);
            } else {
                long carrierIdx = !this.despatchInfo.getCarrierName().isEmpty() ? this.despatchInfo.getCarrierIdxFromName() : PosUtils.longVal(this.despatchInfo.getCarrierIdx());
                Reference ref = this.cmbCarrierSelection.getRef(carrierIdx);
                this.cmbCarrierSelection.setSelectedItem(ref);
            }
            this.cmbCarrierSelection.requestFocus();
            if (PosUtils.longVal(this.despatchInfo.getFinalServiceTypeIdx()) == 0L) {
                this.cmbServiceTypeSelection.setSelectedIndex(-1);
            } else {
                Reference ref = this.cmbServiceTypeSelection.getRef(PosUtils.longVal(this.despatchInfo.getFinalServiceTypeIdx()));
                this.cmbServiceTypeSelection.setSelectedItem(ref);
            }
        }
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
        this.populate();
    }

    private void addProducts() {
        this.despatchInfo.getProducts().clear();
        Product product = null;
        Element tran = ((FrSales)this.frParent).transRoot;
        Vector<Object> detailLines = ((PaSales)this.frParent.paBody).tblStyles.model.getData();
        List styles = tran.getChild("styles").getChildren("style");
        for (int i = 0; i < detailLines.size(); ++i) {
            StyleLine line;
            Double qty;
            if (!(detailLines.get(i) instanceof StyleLine) || (qty = Double.valueOf((line = (StyleLine)detailLines.get(i)).getOutstandingPackedQty())) == null || line.getStkFlag() != 1) continue;
            String title = line.getSkuDescription();
            double price = line.getNet() / line.getQty();
            String sku = line.getBarcode();
            String skuidx = String.valueOf(line.getSkuidx());
            String tariffCode = "";
            String originCountryCode = "";
            double weight = line.getWeight();
            for (int j = 0; j < styles.size(); ++j) {
                Element style = (Element)styles.get(j);
                if (!style.getAttributeValue("skuidx").equals(skuidx)) continue;
                tariffCode = style.getAttributeValue("hs_code");
                originCountryCode = style.getAttributeValue("country_of_origin");
                if (style.getAttributeValue("shipping_prod_desc") == null || style.getAttributeValue("shipping_prod_desc").isEmpty()) continue;
                title = style.getAttributeValue("shipping_prod_desc");
            }
            product = new Product((double)qty, title, price, sku, tariffCode, weight, originCountryCode);
            this.despatchInfo.getProducts().add(product);
        }
    }

    private void tblInit() {
        this.tblPacks.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.tblPacks.getColumnModel().getColumn(0).setMinWidth(95);
        this.tblPacks.getColumnModel().getColumn(0).setMaxWidth(700);
        this.tblPacks.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.tblPacks.getColumnModel().getColumn(1).setMinWidth(95);
        this.tblPacks.getColumnModel().getColumn(1).setMaxWidth(700);
        this.tblPacks.getColumnModel().getColumn(0).setHeaderRenderer(this.tblPacks.headerLeftRen);
        this.tblPacks.getColumnModel().getColumn(1).setHeaderRenderer(this.tblPacks.headerRightRen);
        this.tblPacks.renderer.setColumnFormat(0, null, 2);
        this.tblPacks.renderer.setColumnFormat(1, StoreParams.qtyFormat, 4);
        ((DecimalField)this.tblPacks.qtyEd.getComponent()).setHorizontalAlignment(4);
        this.tblPacks.getColumnModel().getColumn(1).setCellEditor(this.tblPacks.qtyEd);
        this.tblPacks.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                DlgPacking.this.setTotals();
            }
        });
    }

    private void populate() {
        this.dfTotalWeight.setText("0");
        ((PackTableModel)this.tableModel).data = this.despatchInfo.getPacks();
        this.tableModel.fireTableDataChanged();
        if (this.tblPacks.getRowCount() > 0) {
            this.tblPacks.setRowSelectionInterval(0, 0);
            this.tblPacks.setColumnSelectionInterval(1, 1);
        }
    }

    private String formatAddress() {
        StringBuilder address = new StringBuilder();
        if (!StringUtils.isNullOrEmpty(this.despatchInfo.getCustomerName())) {
            address.append(String.format("%s\n", this.despatchInfo.getCustomerName()));
        }
        if (!StringUtils.isNullOrEmpty(this.despatchInfo.getCompanyName())) {
            address.append(String.format("%s\n", this.despatchInfo.getCompanyName()));
        }
        if (!StringUtils.isNullOrEmpty(this.despatchInfo.getAddressLine1())) {
            address.append(String.format("%s\n", this.despatchInfo.getAddressLine1()));
        }
        if (!StringUtils.isNullOrEmpty(this.despatchInfo.getAddressLine2())) {
            address.append(String.format("%s\n", this.despatchInfo.getAddressLine2()));
        }
        if (!StringUtils.isNullOrEmpty(this.despatchInfo.getCity())) {
            address.append(String.format("%s\n", this.despatchInfo.getCity()));
        }
        if (!StringUtils.isNullOrEmpty(this.despatchInfo.getState())) {
            address.append(String.format("%s, ", this.despatchInfo.getState()));
        }
        address.append(String.format("%s\n", this.despatchInfo.getPostcode()));
        address.append(this.despatchInfo.getCountry().getCode());
        if (!StringUtils.isNullOrEmpty(this.despatchInfo.getPhone())) {
            address.append(String.format("\n\nPhone: %s", this.despatchInfo.getPhone()));
        }
        if (!StringUtils.isNullOrEmpty(this.despatchInfo.getMobile())) {
            address.append(String.format("\nMobile: %s", this.despatchInfo.getMobile()));
        }
        if (!StringUtils.isNullOrEmpty(this.despatchInfo.getEmail())) {
            address.append(String.format("\nEmail: %s", this.despatchInfo.getEmail()));
        }
        if (!StringUtils.isNullOrEmpty(this.despatchInfo.getDeliveryInstructions())) {
            address.append(String.format("\nDelivery Instructions: %s", this.despatchInfo.getDeliveryInstructions()));
        }
        return address.toString();
    }

    @Override
    public void cancelDialog() {
        if (this.despatcher.isManualMode()) {
            this.saveManualDetails();
        }
        this.dispose();
    }

    public void toggleDespatchMode() {
        if (this.despatcher.isManualMode()) {
            this.saveManualDetails();
        }
        this.despatcher.setManualMode(!this.despatcher.isManualMode());
        this.dispose();
        DlgPacking dlgPacking = new DlgPacking(this.frParent, this.despatchInfo, this.despatcher);
        dlgPacking.setVisible(true);
    }

    private void saveManualDetails() {
        this.despatchInfo.setConnoteNumber(this.dfConsignmentNote.getText());
        if (this.cmbCarrierSelection.getSelectedIndex() > -1) {
            Reference selectedCarrier = (Reference)this.cmbCarrierSelection.getSelectedItem();
            this.despatchInfo.setCarrierName(selectedCarrier.getName());
        } else {
            this.despatchInfo.setCarrierName("");
        }
        if (this.cmbServiceTypeSelection.getSelectedIndex() > -1) {
            Reference selectedServiceType = (Reference)this.cmbServiceTypeSelection.getSelectedItem();
            this.despatchInfo.setFinalServiceTypeIdx(String.valueOf(selectedServiceType.getIdx()));
        } else {
            this.despatchInfo.setFinalServiceTypeIdx("");
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void okDialog() {
        if (this.processing) {
            return;
        }
        if (this.messageShowing) {
            this.retryOkDialog = true;
            return;
        }
        this.processing = true;
        this.bOK.setEnabled(false);
        try {
            if (this.tblPacks.isEditing()) {
                this.tblPacks.getCellEditor().stopCellEditing();
                if (this.cancelProcessing) {
                    return;
                }
            }
            switch (this.despatchInfo.getTransactionModifiedStatus()) {
                case ORDER_MODIFIED: {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Order_Modified_Message"), StoreParams.res.getString("Order_Modified"), 0);
                    this.despatchInfo.setDespatchSuccessful(false);
                    this.dispose();
                    this.frParent.voidTrans(false);
                    return;
                }
                case ONLINE_QUERY_FAILED: {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Order_Modified_Check_Failed"), StoreParams.res.getString("Order_Modified_Check"), 0);
                    this.despatchInfo.setDespatchSuccessful(false);
                    this.dispose();
                    this.frParent.voidTrans(false);
                    return;
                }
            }
            if (this.despatchInfo.getServiceLevelAgreement() != null && !this.despatchInfo.getServiceLevelAgreement().authoriseDespatch(this.frParent)) {
                return;
            }
            if (!this.despatcher.isManualMode()) {
                if (this.dfTotalPacks.getDouble() > 0.0) {
                    this.requestBooking();
                } else {
                    DlgMessage.showMessage(this, SP.getRS("Nothing_to_despatch_message"), SP.getRS("Nothing_to_despatch_title"), 0);
                }
            } else {
                if (this.cmbCarrierSelection.getSelectedIndex() < 0) {
                    DlgMessage.showMessage(this, SP.getRS("No_Carrier_Message"), SP.getRS("No_Carrier"), 0);
                    this.despatchInfo.setDespatchSuccessful(false);
                    return;
                }
                if (this.cmbServiceTypeSelection.getSelectedIndex() < 0) {
                    DlgMessage.showMessage(this, SP.getRS("No_ServType_Message"), SP.getRS("No_ServType"), 0);
                    this.despatchInfo.setDespatchSuccessful(false);
                    return;
                }
                if (this.dfConsignmentNote.getText().length() == 0) {
                    DlgMessage.showMessage(this, SP.getRS("No_Connote_Message"), SP.getRS("No_Connote"), 0);
                    this.despatchInfo.setDespatchSuccessful(false);
                    return;
                }
                this.saveManualDetails();
                this.despatchInfo.setDespatchSuccessful(true);
                this.dispose();
            }
        }
        finally {
            this.processing = false;
            this.cancelProcessing = false;
            this.bOK.setEnabled(true);
        }
    }

    private void requestBooking() {
        this.setCursor(StoreParams.waitCursor);
        try {
            if (this.despatcher.requestDespatch(this.despatchInfo)) {
                this.dispose();
            } else {
                DlgMessage.showMessage(this.frParent, this.despatcher.getPrintError(), SP.getRS("Error"), 0);
            }
        }
        finally {
            this.setCursor(StoreParams.normalCursor);
        }
    }

    private void setTotals() {
        Object p;
        int i;
        int totalCount = 0;
        double totalWeight = 0.0;
        for (i = 0; i < ((PackTableModel)this.tableModel).data.size(); ++i) {
            p = ((PackTableModel)this.tableModel).data.elementAt(i);
            totalCount += ((Pack)p).getCount();
            totalWeight += (double)((Pack)p).getCount() * ((Pack)p).getWeight();
        }
        for (i = 0; i < this.despatchInfo.getProducts().size(); ++i) {
            p = this.despatchInfo.getProducts().elementAt(i);
            totalWeight += ((Product)p).getWeight() * ((Product)p).getQuantity();
        }
        this.dfTotalPacks.setText(totalCount);
        this.dfTotalWeight.setText(PosDouble.valueOf(totalWeight).toString());
        this.lTotalPacksValue.setText(this.dfTotalPacks.getText());
        this.lTotalWeightValue.setText(this.dfTotalWeight.getText());
    }

    private class PackTableModel
    extends AbstractTableModel {
        private DlgPacking parentDialog;
        private static final int CODE_COLUMN = 0;
        private static final int COUNT_COLUMN = 1;
        private static final int COL_COUNT = 2;
        Vector<Pack> data = new Vector();

        public PackTableModel(DlgPacking parent) {
            this.parentDialog = parent;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.data.size() || row < 0) {
                return "";
            }
            switch (col) {
                case 0: {
                    return this.data.elementAt(row);
                }
                case 1: {
                    return new Integer(this.data.elementAt(row).getCount());
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 1: {
                    return Integer.class;
                }
            }
            return super.getColumnClass(column);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row >= this.data.size() || row < 0 || value == null) {
                return;
            }
            switch (col) {
                case 1: {
                    int count = PosUtils.intVal(((String)value).replaceAll(",", ""));
                    if (count == this.data.elementAt(row).getCount()) {
                        return;
                    }
                    if (count < 0) break;
                    if (count >= 10) {
                        DlgPacking.this.messageShowing = true;
                        try {
                            if (DlgMessage.showMessage(this.parentDialog, SP.getRS("Double_Digit_Pack_Count_Warning", count), SP.getRS("Warning"), 0, 3, 1) != 0) {
                                DlgPacking.this.retryOkDialog = false;
                                if (DlgPacking.this.processing) {
                                    DlgPacking.this.cancelProcessing = true;
                                }
                                return;
                            }
                        }
                        finally {
                            DlgPacking.this.messageShowing = false;
                        }
                    }
                    this.data.elementAt(row).setCount(count);
                    break;
                }
            }
            this.fireTableCellUpdated(row, col);
            if (DlgPacking.this.retryOkDialog) {
                DlgPacking.this.retryOkDialog = false;
                DlgPacking.this.okDialog();
            }
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return PACK_TYPE_HEADING;
                }
                case 1: {
                    return QTY_HEADING;
                }
            }
            return "";
        }
    }
}

