/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import jpos.DlgMessage;
import jpos.IOrderCountListener;
import jpos.PosFrame;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.Urgency;
import jpos.custorder.outstanding.OutstandingOrderDlg;
import jpos.ui.ColourPanel;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelStrong;
import jpos.ui.PulseBorder;

public class OrdersToPackPanel
extends ColourPanel
implements IOrderCountListener,
AutoCloseable {
    private LabelStrong label = new LabelStrong();
    private DialogButton buttonShow;
    private final String ordersToPackTooltip = StoreParams.res.getString("x_orders_to_pack");
    private final String orderToPackTooltip = StoreParams.res.getString("x_order_to_pack");
    private final String priorityOrdersText = StoreParams.res.getString("x_priority_orders");
    private final String priorityOrderText = StoreParams.res.getString("x_priority_order");
    private PosFrame frParent;
    private PulseBorder border;

    public OrdersToPackPanel(PosFrame frParent) {
        super(Colours.CHART_DARK_BLUE);
        this.frParent = frParent;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.border = new PulseBorder(this, 3);
        this.setBorder(this.border);
        this.buttonShow = new DialogButton(""){

            @Override
            public int getButtonWidth() {
                return 80;
            }
        };
        this.buttonShow.setFocusable(false);
        this.buttonShow.setText(SP.getRS("Show"));
        this.buttonShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrdersToPackPanel.this.openCustOrdersToPack();
            }
        });
        this.label.setHorizontalAlignment(4);
        this.label.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.label.setForeground(Colours.WHITE);
        this.label.setIconTextGap(15);
        this.label.setIcon(new ImageIcon(SP.sParams.imagepath + "OutstandingOrders.png"));
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    OrdersToPackPanel.this.openCustOrdersToPack();
                }
            }
        });
        this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(7, 10, 7, 0), 0, 0));
        this.add((Component)this.buttonShow, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(7, 10, 7, 15), 0, 0));
        SP.sParams.getOrderCountListener().registerListener(this);
    }

    @Override
    public void orderCountChanged(int orderCount, Urgency urgency, int priorityOrderCount) {
        this.setLabelText(orderCount, priorityOrderCount);
        if (orderCount > 0) {
            this.setVisible(true, urgency);
        } else {
            this.setVisible(false, urgency);
        }
    }

    public void openCustOrdersToPack() {
        if (!this.frParent.isLoggedIn(true)) {
            return;
        }
        if (!SP.sParams.checkIConn()) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            return;
        }
        final PosFrame custOrders = this.frParent.menu.openFrame(12, false, this.frParent.getUser());
        if (custOrders != null) {
            if (!custOrders.autoSignIn(this.frParent.getUser()) && !custOrders.paHead.signIn()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try (OutstandingOrderDlg orderDlg = new OutstandingOrderDlg(custOrders);){
                        orderDlg.setVisible(true);
                        if (!StringUtils.isNullOrEmpty(orderDlg.getSelection())) {
                            custOrders.menu.populate(custOrders, 714, orderDlg.getSelection());
                        }
                    }
                }
            });
        }
    }

    public void setButtonsEnabled(boolean enabled) {
        this.buttonShow.setEnabled(enabled);
    }

    private void setLabelText(int orderCount, int priorityOrderCount) {
        if (orderCount > 0) {
            String priorityOrders = "";
            if (priorityOrderCount > 0) {
                priorityOrders = priorityOrderCount == 1 ? this.priorityOrderText : MessageFormat.format(this.priorityOrdersText, priorityOrderCount);
            }
            String ordersToPack = orderCount == 1 ? this.orderToPackTooltip : MessageFormat.format(this.ordersToPackTooltip, orderCount);
            this.label.setText(MessageFormat.format("<html>{0}{1}{2}</html>", priorityOrders, priorityOrders.length() > 0 ? "<br />" : "", ordersToPack));
        } else {
            this.label.setText("");
        }
    }

    public void setVisible(boolean visible, Urgency urgency) {
        if (visible) {
            int pulseFrequency;
            Color newColour;
            if (urgency == Urgency.CRITICAL) {
                newColour = Colours.CHART_RED;
                pulseFrequency = 60;
            } else if (urgency == Urgency.ALERT) {
                newColour = Colours.CHART_AMBER;
                pulseFrequency = 20;
            } else {
                newColour = Colours.CHART_DARK_BLUE;
                pulseFrequency = 6;
            }
            if (this.border.getPulsesPerMinute() > 0.0) {
                this.changePanelColour(newColour);
            } else {
                this.setBaseColour(newColour);
            }
            this.border.pulse(pulseFrequency);
        } else {
            this.border.stopPulse(false);
        }
        super.setVisible(visible);
    }

    @Override
    public void close() {
        if (this.border != null) {
            this.border.close();
        }
        SP.sParams.getOrderCountListener().unregisterListener(this);
    }
}

