/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import jpos.DlgMessage;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.custorder.DespatchInfo;
import jpos.custorder.Despatcher;
import jpos.custorder.Pack;
import jpos.custorder.Product;
import jpos.custorder.ShippItProvider;
import jpos.custorder.ShippingLabelFilePurge;
import jpos.custorder.ShippingOptions;
import jpos.custorder.UnattendedDeliveryOptions;
import jpos.logging.RollingLog;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class ShippIt
extends Despatcher {
    private static String shippit = "shippit";
    private static int downloadRetry = 10;
    String apiUrl = "";
    String apiKey = "";
    Map<String, ShippingOptions> freightTypes;
    boolean autoManifest;

    public ShippIt(String apiUrl, String apiKey, Map<String, ShippingOptions> freightTypes, String autoManifest) {
        this.apiUrl = apiUrl;
        this.apiKey = apiKey;
        this.freightTypes = freightTypes;
        this.autoManifest = autoManifest.equals("1");
    }

    private String requestLogging(Request request) {
        Gson prettyJson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return prettyJson.toJson((Object)request);
    }

    private String resultLogging(ShipmentResult result) {
        try {
            if (result == null) {
                return "null";
            }
            Gson prettyJson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            for (String key : result.RequestResponseLog.keySet()) {
                if (!key.toLowerCase().contains("body") && !key.toLowerCase().equals("delete response")) continue;
                JsonElement jElement = (JsonElement)prettyJson.fromJson((String)result.RequestResponseLog.get(key), JsonElement.class);
                result.RequestResponseLog.replace(key, jElement);
            }
            return prettyJson.toJson((Object)result);
        }
        catch (Exception e) {
            return new Gson().toJson((Object)result);
        }
    }

    private boolean order(DespatchInfo despatchInfo) {
        boolean manifest;
        Request order = this.buildOrder(despatchInfo);
        if (order == null) {
            return false;
        }
        Gson json = new Gson();
        String orderJson = json.toJson((Object)order);
        String result = "";
        try {
            RollingLog.log(RollingLog.LogType.SHIPPIT, Level.INFO, "Shipment Request" + System.lineSeparator() + this.requestLogging(order));
            result = ShippItProvider.ProcessTransaction(shippit, orderJson);
        }
        catch (Exception e) {
            RollingLog.log(RollingLog.LogType.SHIPPIT, orderJson, e);
            return false;
        }
        ShipmentResult shipmentResult = (ShipmentResult)json.fromJson(result, ShipmentResult.class);
        RollingLog.log(RollingLog.LogType.SHIPPIT, Level.INFO, "Shipment Request Result" + System.lineSeparator() + this.resultLogging(shipmentResult));
        if (!shipmentResult.Successful.booleanValue()) {
            this.printError = "ShippIt Error: " + shipmentResult.ErrorMessage + "\n" + shipmentResult.ErrorDetails;
            if (!StringUtils.isNullOrEmpty(shipmentResult.TrackingNumber)) {
                this.DeleteOrder(shipmentResult.TrackingNumber);
            }
            return false;
        }
        despatchInfo.setConnoteNumber(shipmentResult.ConsigmentNote);
        String serviceTypeIdx = "";
        String carrierIdx = "";
        for (Map.Entry<String, ShippingOptions> pair : this.freightTypes.entrySet()) {
            if (!pair.getValue().getName().equals(shipmentResult.Courier)) continue;
            String[] keyParts = pair.getKey().split("\\+", 2);
            carrierIdx = keyParts[0];
            serviceTypeIdx = keyParts[1];
            break;
        }
        if (despatchInfo.isDynamicServiceType(despatchInfo.getServiceTypeIdx())) {
            serviceTypeIdx = despatchInfo.getServiceTypeIdx();
        }
        despatchInfo.setCarrierName(shipmentResult.Courier);
        despatchInfo.setFinalCarrierIdx(carrierIdx);
        despatchInfo.setFinalServiceTypeIdx(serviceTypeIdx);
        despatchInfo.setTrackingNumber(shipmentResult.TrackingNumber);
        DateFormat format = DateFormat.getDateTimeInstance();
        despatchInfo.setReadyDateTime(format.format(new Date()));
        this.lastGeneratedLabelFilename = this.generateLabelsFilename(despatchInfo);
        boolean shipping = this.DownloadFileRetry(shipmentResult.Labels.get("Shipping"), this.lastGeneratedLabelFilename);
        if (!shipping) {
            DlgMessage.showMessage(null, SP.getRS("Cannot_Download_Label"), StoreParams.res.getString("Stop"), 1);
        }
        if (shipmentResult.Labels.containsKey("CustomsInvoice")) {
            this.lastGeneratedInvoiceFilename = this.generateInvoiceFilename(despatchInfo);
            boolean invoice = this.DownloadFileRetry(shipmentResult.Labels.get("CustomsInvoice"), this.lastGeneratedInvoiceFilename);
            if (!invoice) {
                DlgMessage.showMessage(null, SP.getRS("Cannot_Download_CustomsInvoice"), StoreParams.res.getString("Stop"), 1);
            }
        }
        boolean bl = manifest = shipmentResult.LatestStatus == TrackingStatus.ReadyForPickup;
        if (shipmentResult.Labels.containsKey("Manifest")) {
            this.lastGeneratedConsignmentFilename = this.generateConsignmentFilename(despatchInfo);
            boolean downloaded = this.DownloadFileRetry(shipmentResult.Labels.get("Manifest"), this.lastGeneratedConsignmentFilename);
            if (!manifest) {
                manifest = downloaded;
            }
        } else {
            this.lastGeneratedConsignmentFilename = null;
        }
        if (!manifest && this.autoManifest) {
            this.lastGeneratedConsignmentFilename = null;
            if (this.autoManifest) {
                DlgMessage.showMessage(null, SP.getRS("Cannot_Download_Manifest"), StoreParams.res.getString("Stop"), 1);
            }
        }
        despatchInfo.setDespatchSuccessful(shipmentResult.Successful);
        return shipmentResult.Successful;
    }

    private boolean DeleteOrder(String trackingNumber) {
        Request deleteRequest = new Request();
        deleteRequest.ApiUrl = this.apiUrl;
        deleteRequest.Credentials.Apikey = this.apiKey;
        deleteRequest.TrackingNumber = trackingNumber;
        Gson json = new Gson();
        String responseTransaction = "";
        String deleteJson = json.toJson((Object)deleteRequest);
        try {
            RollingLog.log(RollingLog.LogType.SHIPPIT, Level.INFO, "Delete Shipment " + System.lineSeparator() + this.requestLogging(deleteRequest));
            responseTransaction = ShippItProvider.DeleteTransaction("shippit", deleteJson);
        }
        catch (Exception e) {
            RollingLog.log(RollingLog.LogType.SHIPPIT, deleteJson, e);
            return false;
        }
        ShipmentResult shipmentResult = (ShipmentResult)json.fromJson(responseTransaction, ShipmentResult.class);
        RollingLog.log(RollingLog.LogType.SHIPPIT, Level.INFO, "Delete Shipment Result" + System.lineSeparator() + this.resultLogging(shipmentResult));
        return shipmentResult.Successful;
    }

    private Boolean DownloadFileRetry(String url, String filePath) {
        if (StringUtils.isNullOrEmpty(url)) {
            return false;
        }
        for (int count = 0; count < downloadRetry; ++count) {
            Boolean result = count == downloadRetry - 1 ? Boolean.valueOf(this.DownloadFile(url, filePath, false)) : Boolean.valueOf(this.DownloadFile(url, filePath, true));
            if (!result.booleanValue()) continue;
            return result;
        }
        return false;
    }

    private boolean DownloadFile(String url, String filePath, boolean suppressErrors) {
        CloseableHttpResponse response;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            if (suppressErrors) {
                PosUtils.logError("Failed to get " + url);
                PosUtils.logError(e);
            }
            return false;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null && response.getStatusLine().getStatusCode() == 200) {
            try {
                FileOutputStream file = new FileOutputStream(filePath);
                BufferedHttpEntity inputStream = new BufferedHttpEntity(entity);
                inputStream.writeTo((OutputStream)file);
                file.flush();
                file.close();
            }
            catch (IOException e) {
                if (suppressErrors) {
                    PosUtils.logError("Failed to save " + url + " to  " + filePath);
                    PosUtils.logError(e);
                }
                return false;
            }
        } else {
            RollingLog.log(RollingLog.LogType.SHIPPIT, Level.WARNING, "Saving File: " + url + " " + filePath);
            return false;
        }
        return true;
    }

    private Request buildOrder(DespatchInfo despatchInfo) {
        Request request = new Request();
        boolean dynamicCarrier = despatchInfo.isDynamicServiceType(despatchInfo.getServiceTypeIdx());
        ShippingOptions freight = null;
        if (!dynamicCarrier && !StringUtils.isNullOrEmpty(despatchInfo.getCarrierIdx())) {
            freight = this.freightTypes.get(despatchInfo.getCarrierIdx() + "+" + despatchInfo.getServiceTypeIdx());
            if (freight != null) {
                request.Courier = freight.getName();
                request.DeliveryWindow = freight.getDeliveryWindow();
            }
        } else if (!StringUtils.isNullOrEmpty(despatchInfo.getServiceTypeIdx()) && (freight = this.freightTypes.get("+" + despatchInfo.getServiceTypeIdx())) != null) {
            request.Service = freight.getName();
            request.DeliveryWindow = freight.getDeliveryWindow();
        }
        request.CourierIdx = despatchInfo.getCarrierIdx();
        request.ServiceIdx = despatchInfo.getServiceTypeIdx();
        request.StoreId = String.valueOf(SP.sParams.getStoreIdx());
        request.Credentials.Apikey = this.apiKey;
        request.ApiUrl = this.apiUrl;
        request.OrderReference = despatchInfo.getCustomerOrderNumber();
        request.AutomaticOrderManifesting = this.autoManifest;
        request.PrintCustomsInvoice = despatchInfo.printCustomsInvoice();
        request.AllowMultipleCartons = despatchInfo.allowMultipleCartons();
        request.ToAddress.Contact = despatchInfo.getCustomerName();
        request.ToAddress.Phone = despatchInfo.getBestPhoneNumber();
        request.ToAddress.Email = despatchInfo.getEmail();
        request.ToAddress.Address1 = despatchInfo.getAddressLine1();
        request.ToAddress.Address2 = despatchInfo.getAddressLine2();
        request.ToAddress.Postcode = despatchInfo.getPostcode();
        request.ToAddress.Suburb = despatchInfo.getCity();
        request.ToAddress.State = despatchInfo.getState();
        request.ToAddress.Company = despatchInfo.getCompanyName();
        request.ToAddress.DeliveryInstructions = despatchInfo.getDeliveryInstructions();
        request.ToAddress.Country = despatchInfo.getCountry().getCode();
        request.CustomerShippingFeePaid = despatchInfo.getFreightValue();
        request.ToAddress.IsPOBox = despatchInfo.isPoBox();
        request.ToAddress.AuthorityToLeave = despatchInfo.getUnattendedDeliveryOption() == UnattendedDeliveryOptions.AuthorityToLeave;
        request.FromAddress.Country = despatchInfo.getCountryOfOrigin().getCode();
        if (despatchInfo.getExpectedDeliveryDate() != null) {
            request.DeliveryDate = despatchInfo.getExpectedDeliveryDate().format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        double totWeight = 0.0;
        for (Product product : despatchInfo.getProducts()) {
            totWeight += product.getWeight() * product.getQuantity();
        }
        int totalPacks = 0;
        for (Pack pack : despatchInfo.getPacks()) {
            totalPacks += pack.getCount();
        }
        double d = totalPacks > 0 ? totWeight / (double)totalPacks : 0.0;
        for (Pack pack : despatchInfo.getPacks()) {
            if (pack.getCount() <= 0) continue;
            if (!(pack.getLength() > 0.0 && pack.getWidth() > 0.0 && pack.getDepth() > 0.0 && pack.getWeight() > 0.0)) {
                this.printError = SP.getRS("Pack_Type_X_is_not_configured_correctly_it_must_have_length_width_depth_and_weight_setup", pack.getName());
                return null;
            }
            Carton parcelAttributes = new Carton();
            parcelAttributes.Length = pack.getLength() / 100.0;
            parcelAttributes.Width = pack.getWidth() / 100.0;
            parcelAttributes.Height = pack.getDepth() / 100.0;
            parcelAttributes.Weight = PosUtils.scale(d + pack.getWeight(), 4);
            parcelAttributes.Quantity = pack.getCount();
            parcelAttributes.Name = pack.getAlternativeName();
            request.Cartons.addElement(parcelAttributes);
        }
        for (Product product : despatchInfo.getProducts()) {
            if (!(product.getQuantity() > 0.0)) continue;
            ProductAttributes productAttributes = new ProductAttributes();
            productAttributes.Quantity = product.getQuantity();
            productAttributes.Price = product.getPrice();
            productAttributes.Weight = product.getWeight();
            productAttributes.Title = product.getTitle();
            productAttributes.Sku = product.getSku();
            productAttributes.TariffCode = product.getTariffCode();
            productAttributes.OriginCountryCode = product.getOriginCountryCode();
            request.Products.addElement(productAttributes);
        }
        return request;
    }

    @Override
    public String getDespatcherTitle() {
        if (this.isManualMode()) {
            return SP.getRS("Manual_Despatch");
        }
        return SP.getRS("ShippIt_Despatch");
    }

    @Override
    public String getSwitchModeButtonText() {
        if (!this.isManualMode()) {
            return SP.getRS("Manual_Switch");
        }
        return SP.getRS("ShippIt_Switch");
    }

    @Override
    public boolean requestDespatch(DespatchInfo despatchInfo) {
        try {
            boolean bl = this.order(despatchInfo);
            return bl;
        }
        finally {
            ShippingLabelFilePurge.getDefault().purgeFolder(SP.sParams.getDeliveryLabelLogDirectory(), 180);
            ShippingLabelFilePurge.getDefault().purgeFolder(SP.sParams.getDeliveryLabelDirectory(), 180);
        }
    }

    @Override
    public boolean hasCredentials() {
        return !StringUtils.isNullOrEmpty(this.apiKey) && !StringUtils.isNullOrEmpty(this.apiUrl);
    }

    @Override
    public boolean canDoDynamicCarrierAllocation() {
        return true;
    }

    public static enum TrackingStatus {
        Unknown,
        OrderPlaced,
        DespatchInProgress,
        ReadyForPickup,
        InTransit,
        WithDriver,
        Completed,
        DeliveryAttempted,
        AwaitingCollection,
        ReturnedToSender,
        Cancelled;

    }

    public class ShipmentResult {
        public Boolean Successful;
        public String ErrorMessage;
        public String ErrorDetails;
        public Map<String, Object> RequestResponseLog;
        public Boolean CanRetry;
        public Map<String, String> Labels;
        public String TrackingNumber;
        public String ConsigmentNote;
        public String TrackingUrl;
        public String Courier;
        public TrackingStatus LatestStatus;
        public String PickupAt;
    }

    public class PlatformCredentials {
        public String User;
        public String Password;
        public String Apikey;
    }

    public class Address {
        public String Description;
        public String Contact;
        public String Phone;
        public String Email;
        public String Address1;
        public String Address2;
        public String Postcode;
        public String State;
        public String Suburb;
        public String Company;
        public String DeliveryInstructions;
        public String Country;
        public Boolean IsResidence;
        public Boolean IsPOBox;
        public Boolean AuthorityToLeave;
    }

    public class ProductAttributes {
        public double Quantity;
        public double Price;
        public double Weight;
        public String Title;
        public String Sku;
        public String TariffCode;
        public String OriginCountryCode;
    }

    public class Carton {
        public int Quantity;
        public double Weight;
        public double Width;
        public double Height;
        public double Length;
        public String Name;
    }

    public class Request {
        public String ApiUrl;
        public String Courier;
        public String Service;
        public String CourierIdx;
        public String ServiceIdx;
        public String StoreId;
        public String OrderReference;
        public Boolean ValidateAddress = true;
        public String TrackingNumber;
        public PlatformCredentials Credentials;
        public Address ToAddress;
        public Vector<Carton> Cartons;
        public Vector<ProductAttributes> Products;
        public Boolean AutomaticOrderManifesting;
        public Boolean PrintCustomsInvoice;
        public Boolean AllowMultipleCartons;
        public Boolean InternationalShipping;
        public Address FromAddress;
        public String DeliveryDate;
        public double CustomerShippingFeePaid;
        public String DeliveryWindow;

        public Request() {
            this.ToAddress = new Address();
            this.Cartons = new Vector();
            this.Products = new Vector();
            this.Credentials = new PlatformCredentials();
            this.FromAddress = new Address();
        }
    }
}

