/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.auspost;

import com.google.gson.Gson;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.custorder.auspost.ShipmentTable;
import jpos.custorder.auspost.ShipmentTableModel;
import jpos.logging.RollingLog;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class DlgManifestShipments
extends PosDialog {
    private LabelSubHeading headingLabel;
    private ShipmentTable manifestTable;
    private DialogButton selectAllButton = new DialogButton("");
    private DialogButton okButton = new DialogButton("");
    private boolean result = false;

    public DlgManifestShipments(PosFrame frame) {
        super(frame, SP.getRS("Manifest_Header"), true);
        this.setAcceptOnEnter(false);
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.headingLabel = new LabelSubHeading(SP.getRS("Manifest_SubHeader"));
        ShipmentTableModel manifestTableModel = new ShipmentTableModel();
        this.manifestTable = new ShipmentTable((Window)this, manifestTableModel);
        this.manifestTable.populate();
        this.manifestTable.getScrollPane().setPreferredSize(new Dimension(600, 402));
        this.selectAllButton.setText(StoreParams.res.getString("F8_Select_All"));
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgManifestShipments.this.selectAllButton.setEnabled(false);
                DlgManifestShipments.this.selectAll();
                DlgManifestShipments.this.selectAllButton.setEnabled(true);
            }
        });
        this.okButton.setText(StoreParams.res.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgManifestShipments.this.okDialog();
            }
        });
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelHeader = new JPanel(new GridBagLayout());
        JPanel panelBody = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panelMain, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelBody, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelHeader.add((Component)this.headingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(7, 10, 0, 10), 0, 0));
        panelHeader.add((Component)new JLabel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(7, 10, 0, 10), 0, 0));
        panelBody.add((Component)this.manifestTable.getScrollPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 0, 10), 0, 0));
        panelFooter.add((Component)this.selectAllButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        panelFooter.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 10, 20), 0, 0));
        panelFooter.add((Component)this.okButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.manifestTable);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    public boolean getResult() {
        return this.result;
    }

    @Override
    public void cancelDialog() {
        this.result = false;
        this.dispose();
    }

    @Override
    public void okDialog() {
        if (this.manifestSelectedOrders()) {
            this.result = true;
            this.dispose();
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 119 && this.selectAllButton.isVisible() && this.selectAllButton.isEnabled()) {
            this.selectAllButton.doClick();
            return true;
        }
        return false;
    }

    private void selectAll() {
        this.manifestTable.selectAll();
    }

    public int getRowCount() {
        return this.manifestTable.getModel().getRowCount();
    }

    private boolean manifestSelectedOrders() {
        Vector<ShipmentTable.CarrierShipments> shipmentIds = this.manifestTable.getSelectedShipmentId();
        for (int i = 0; i < shipmentIds.size(); ++i) {
            Gson gson = new Gson();
            String json = gson.toJson((Object)shipmentIds.elementAt(i));
            RollingLog.LogType log = RollingLog.LogType.AUSPOST;
            if (((String)this.manifestTable.model.getValueAt(i, 5)).equals("StarTrack Express")) {
                log = RollingLog.LogType.STARTRACK;
            }
            RollingLog.log(log, Level.INFO, "Manifest Request" + System.lineSeparator() + json);
            try {
                RollingLog.log(log, Level.INFO, "Shipment Booking Request" + System.lineSeparator() + "Manifest ID: " + json);
                Element shipmentResult = SP.sParams.OnlineQueryProvider.getOnlineQuery("aps_finalise_packing_order", json).getXML();
                String manifestId = XMLUtils.getValue(shipmentResult, "manifestId");
                String base64Content = XMLUtils.getValue(shipmentResult, "base64Content");
                if (StringUtils.isNullOrEmpty(manifestId)) {
                    DlgMessage.showMessage(this, "No manifest ID was returned from Carrier");
                    return false;
                }
                if (StringUtils.isNullOrEmpty(base64Content)) {
                    DlgMessage.showMessage(this, "No Manifest was returned from Carrier");
                    return false;
                }
                byte[] data = this.decodeBase64String(base64Content);
                String filename = this.generateFileName(manifestId);
                RollingLog.log(log, Level.INFO, "Manifest Generated Successfully." + System.lineSeparator() + "Manifest ID: " + manifestId);
                boolean fileCreated = this.createPDFFromByteArray(data, filename);
                if (fileCreated) {
                    this.printManifest(filename);
                    for (int j = 0; j < shipmentIds.get((int)i).shipments.size(); ++j) {
                        this.updateDatabaseEntry(shipmentIds.get((int)i).shipments.elementAt(j), manifestId);
                    }
                    continue;
                }
                DlgMessage.showMessage(this, "Unable to create manifest file");
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private void updateDatabaseEntry(String shipmentId, String manifestId) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE AUSPOST_MANIFEST SET MANIFEST_ID = ?, MANIFEST_DATE = CURRENT_TIMESTAMP(2), MANIFESTED = 1 WHERE SHIPMENT_ID = ?");){
            stmt.setString(1, manifestId);
            stmt.setString(2, shipmentId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void handleForceManifesting() {
        Vector<String> freightOptions = this.getFreightOptionsToForceManifesting();
        if (freightOptions.size() > 0) {
            for (String option : freightOptions) {
                this.selectByFreightOption(option);
            }
            int selected = this.getSelectedCount();
            if (selected > 0) {
                DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Manifesting_Orders"), selected));
                this.manifestSelectedOrders();
            }
        }
    }

    public void handleOptionalManifesting() {
        int result;
        if (this.getRowCount() > 0 && (result = DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Unmanifested_Orders"), this.manifestTable.model.getRowCount()), SP.getRS("Unmanifested_Orders_Title"), 0, 2)) == 0) {
            this.selectAll();
            this.manifestSelectedOrders();
        }
    }

    private int getSelectedCount() {
        return this.manifestTable.getSelectedCount();
    }

    private Vector<String> getFreightOptionsToForceManifesting() {
        Vector<String> options = new Vector<String>();
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT DISTINCT FREIGHT_OPTION FROM AUSPOST_MANIFEST WHERE MANIFESTED = 0");){
            while (qry.next()) {
                String option = qry.getString("FREIGHT_OPTION");
                Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("aps_get_automanifest", option).getXML();
                boolean manifest = response.getAttribute("automanifest").getBooleanValue();
                if (!manifest) continue;
                options.add(qry.getString("FREIGHT_OPTION"));
            }
        }
        catch (SQLException | DataConversionException e) {
            PosUtils.logError(e);
        }
        return options;
    }

    public boolean printManifest(String fileToPrint) {
        String printError = null;
        try {
            String labelError = SP.sParams.PrinterProvider.openDocument(fileToPrint);
            if (!StringUtils.isNullOrEmpty(labelError)) {
                printError = labelError;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return StringUtils.isNullOrEmpty(printError);
    }

    public byte[] decodeBase64String(String base64String) {
        return Base64.getDecoder().decode(base64String);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createPDFFromByteArray(byte[] data, String outputFilePath) {
        try (FileOutputStream fos = new FileOutputStream(outputFilePath);){
            fos.write(data);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String generateFileName(String manifestId) {
        return SP.sParams.getDeliveryLabelDirectory() + File.separator + manifestId + "_manifest_" + new Date().getTime() + ".pdf";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasUnmanifestedOrders() {
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT * FROM AUSPOST_MANIFEST WHERE MANIFESTED = 0");){
            boolean bl = qry.next();
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
    }

    private void selectByFreightOption(String freightoption) {
        int rowcount = this.manifestTable.model.getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            String rowFreightOption = (String)this.manifestTable.model.getValueAt(i, 2);
            if (!rowFreightOption.equals(freightoption)) continue;
            this.manifestTable.model.setValueAt(true, i, 7);
        }
    }

    class Shipment {
        private String shipment_id;

        public Shipment(String shipmentid) {
            this.shipment_id = shipmentid;
        }
    }

    class Shipments {
        private List<Shipment> shipments = new Vector<Shipment>();

        public void add(Shipment shipment) {
            this.shipments.add(shipment);
        }
    }

    class Payload {
        Shipments shipments;

        public Payload() {
            this.shipments = new Shipments();
        }
    }
}

