/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.auspost;

import java.sql.SQLException;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.custorder.auspost.ManifestLine;

public class ReprintManifestTableModel
extends AbstractTableModel {
    public static final int CARRIERIDX_COLUMN = 0;
    public static final int MANIFEST_ID_COLUMN = 1;
    public static final int MANIFEST_DATE_COLUMN = 2;
    public static final int CARRIER_NAME_COLUMN = 3;
    public static final int MANIFEST_COLUMN = 4;
    private static final int COL_COUNT = 5;
    private static final String MANIFEST_ID_HEADER = SP.getRS("ManifestId_Header");
    private static final String MANIFEST_DATE_HEADER = SP.getRS("Manifest_Date_Header");
    private static final String CARRIER_NAME_HEADER = SP.getRS("Carrier_Name_Header");
    private Vector<ManifestLine> data = new Vector();

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: {
                return false;
            }
            case 1: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.data.size() || row < 0) {
            return "";
        }
        switch (col) {
            case 0: {
                return this.data.elementAt(row).getCarrierIdx();
            }
            case 1: {
                return this.data.elementAt(row).getManifestId();
            }
            case 2: {
                return this.data.elementAt(row).getManifestDate();
            }
            case 3: {
                return this.data.elementAt(row).getCarrierName();
            }
            case 4: {
                return this.data.elementAt(row).isManifested();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row >= this.data.size() || row < 0 || value == null) {
            return;
        }
        switch (col) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.data.get(row).setIsManifested((Boolean)value);
                this.fireTableCellUpdated(row, col);
                break;
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 2: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return MANIFEST_ID_HEADER;
            }
            case 2: {
                return MANIFEST_DATE_HEADER;
            }
            case 3: {
                return CARRIER_NAME_HEADER;
            }
        }
        return "";
    }

    public void populate() {
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT Manifest_ID, carrieridx, manifest_date, carrier_name FROM AUSPOST_MANIFEST WHERE MANIFESTED = 1 AND MANIFEST_DATE > CURRENT_DATE - 7 GROUP BY Manifest_ID, carrieridx, carrier_name, manifest_date ORDER BY MANIFEST_DATE DESC");){
            while (qry.next()) {
                ManifestLine line = new ManifestLine();
                line.setCarrierIdx(qry.getString("carrierIdx"));
                line.setManifestId(qry.getString("manifest_id"));
                line.setManifestDate(qry.getString("manifest_date"));
                line.setCarrierName(qry.getString("carrier_name"));
                this.data.add(line);
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public void selectAll() {
        boolean hasChanged = false;
        for (ManifestLine line : this.data) {
            if (line.isManifested()) continue;
            line.setIsManifested(true);
            hasChanged = true;
        }
        if (hasChanged) {
            this.fireTableDataChanged();
        }
    }

    public void unselectAll() {
        boolean hasChanged = false;
        for (ManifestLine line : this.data) {
            if (!line.isManifested()) continue;
            line.setIsManifested(false);
            hasChanged = true;
        }
        if (hasChanged) {
            this.fireTableDataChanged();
        }
    }
}

