/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.PosComboBox;
import jpos.PosDateField;
import jpos.PosDialog;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.labelprinting.ILabelDialog;
import jpos.labelprinting.LabelDialogType;
import jpos.labelprinting.LabelFormat;
import jpos.labelprinting.LabelFormats;
import jpos.labelprinting.PrinterLabelFactory;
import jpos.labelprinting.SkuLabel;
import jpos.searchfields.ProductClrSizeSearch;
import jpos.searchfields.SearchButton;
import jpos.searchfields.SearchPanel;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class LabelPrintingDlg
extends PosDialog
implements ILabelDialog {
    private SkuLabel skuLabel;
    private long currentSkuidx;
    private LabelDialogType nextDialog = LabelDialogType.NONE;
    private LabelSubHeading headingLabel;
    private LabelNormal productBarcodeLabel;
    private LabelNormal productCodeLabel;
    private LabelNormal productDescriptionLabel;
    private LabelNormal colourCodeLabel;
    private LabelNormal sizeValueLabel;
    private LabelNormal origPriceLabel;
    private LabelNormal priceLabel;
    private LabelNormal quantityLabel;
    private LabelNormal labelFormat;
    private PosComboBox<LabelFormat> cmbFormat = new PosComboBox<LabelFormat>(new LabelFormats());
    private ProductClrSizeSearch search;
    private TouchTextField productBarcodeField;
    private TouchTextField productCodeField;
    private TouchTextField productDescriptionField;
    private TouchTextField colourCodeField;
    private TouchTextField sizeValueField;
    private DecimalField origPriceField;
    private PosDateField priceDate;
    private DecimalField priceField;
    private TouchTextField quantityField;
    private DialogButton scanButton;
    private DialogButton bulkButton;
    private DialogButton printButton;
    private DialogButton closeButton;

    public LabelPrintingDlg(PosFrame parentFrame) {
        super(parentFrame, StoreParams.res.getString("Label_Printing"), true);
        try {
            this.initialiseScreen();
            this.pack();
            PosUtils.centreWindow(this);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void initialiseScreen() {
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelHeader = new JPanel(new GridBagLayout());
        JPanel panelBody = new JPanel(new GridBagLayout());
        JPanel panelPrice = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        this.headingLabel = new LabelSubHeading(this.getTitle());
        this.labelFormat = new LabelNormal(SP.getRS("Label_Print_Format"));
        this.productBarcodeLabel = new LabelNormal(StoreParams.res.getString("Label_Printing_Product_Barcode"));
        this.productCodeLabel = new LabelNormal(StoreParams.res.getString("Label_Printing_Product_Code"));
        this.productDescriptionLabel = new LabelNormal(StoreParams.res.getString("Label_Printing_Product_Description"));
        this.colourCodeLabel = new LabelNormal(StoreParams.res.getString("Label_Printing_Colour_Code"));
        this.sizeValueLabel = new LabelNormal(StoreParams.res.getString("Label_Printing_Size_Value"));
        this.origPriceLabel = new LabelNormal(StoreParams.res.getString("Label_Printing_Original_Price"));
        this.priceLabel = new LabelNormal(StoreParams.res.getString("Label_Printing_Price"));
        this.quantityLabel = new LabelNormal(StoreParams.res.getString("Label_Printing_Quantity"));
        if (this.cmbFormat.getItemCount() > 0) {
            this.cmbFormat.setSelectedIndex(0);
        }
        if (this.cmbFormat.getItemCount() <= 1) {
            this.labelFormat.setVisible(false);
            this.cmbFormat.setVisible(false);
        }
        this.cmbFormat.setFieldWidth(240);
        this.search = new ProductClrSizeSearch(this, TouchTextField.FontSize.LARGE){

            @Override
            public boolean processSku(long skuidx, String barcode) {
                LabelPrintingDlg.this.currentSkuidx = skuidx;
                return LabelPrintingDlg.this.populate();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean processBarcodeScan(String barcode) {
                boolean foundSku = super.processBarcodeScan(barcode);
                if (foundSku) return foundSku;
                try (PreparedStatement stmtStyle = SP.sParams.conn.prepareStatement("select s.STYLEIDX, count(distinct c.CLRIDX), min(c.CLRIDX), min(c.CLRCODE), count(distinct u.SKUIDX), min(u.SKUIDX), min(db.code) \r\nfrom style s join clr c on s.STYLEIDX = c.STYLEIDX and c.\"ACTIVE\" = 1\r\njoin sku u on u.\"ACTIVE\" = 1 and u.CLRIDX = c.CLRIDX\r\njoin DEFAULT_BARCODE db on u.skuidx = db.skuidx\r\nwhere s.STYLECODE = ? and s.\"ACTIVE\" = 1\r\ngroup by s.styleidx");){
                    if (barcode.length() > 40) {
                        barcode = barcode.substring(0, 40);
                    }
                    stmtStyle.setString(1, barcode);
                    try (ResultSet resultStyle = stmtStyle.executeQuery();){
                        if (!resultStyle.next()) return foundSku;
                        final String styleCode = barcode;
                        final long styleidx = resultStyle.getLong(1);
                        int clrCount = resultStyle.getInt(2);
                        final long clrIdx = resultStyle.getLong(3);
                        final String clrCode = resultStyle.getString(4);
                        int skuCount = resultStyle.getInt(5);
                        final long skuIdx = resultStyle.getLong(6);
                        final String skuBarcode = resultStyle.getString(7);
                        if (clrCount > 1) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LabelPrintingDlg.this.search.getBarcodeSearchField().setText(styleCode);
                                    LabelPrintingDlg.this.search.getClrSearchField().search(styleidx, styleCode);
                                }
                            });
                        } else if (clrCount == 1 && skuCount > 1) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LabelPrintingDlg.this.search.getBarcodeSearchField().setText(styleCode);
                                    LabelPrintingDlg.this.search.getSizeSearchField().search(clrIdx, styleCode, clrCode);
                                }
                            });
                        } else {
                            LabelPrintingDlg.this.search.getBarcodeSearchField().setText(skuBarcode);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (!this.processSku(skuIdx, skuBarcode)) {
                                        LabelPrintingDlg.this.search.getBarcodeSearchField().setText(StoreParams.invalidBarcode);
                                        LabelPrintingDlg.this.search.getBarcodeSearchField().selectAll();
                                    } else {
                                        LabelPrintingDlg.this.search.getBarcodeSearchField().clear();
                                    }
                                }
                            });
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (SQLException e) {
                    PosUtils.logError(e);
                }
                return foundSku;
            }
        };
        this.priceDate = new PosDateField(this){

            @Override
            public void valueChanged() {
                LabelPrintingDlg.this.populate();
            }
        };
        this.setupFieldProperties(this.search.getBarcodeSearchField(), 344, true);
        this.productCodeField = new TouchTextField("");
        this.setupFieldProperties(this.productCodeField, 240, false);
        this.productBarcodeField = new TouchTextField("");
        this.setupFieldProperties(this.productBarcodeField, 240, false);
        this.productCodeField = new TouchTextField("");
        this.setupFieldProperties(this.productCodeField, 240, false);
        this.productDescriptionField = new TouchTextField("");
        this.setupFieldProperties(this.productDescriptionField, 240, false);
        this.colourCodeField = new TouchTextField("");
        this.setupFieldProperties(this.colourCodeField, 240, false);
        this.sizeValueField = new TouchTextField("");
        this.setupFieldProperties(this.sizeValueField, 240, false);
        this.origPriceField = new DecimalField(SP.sParams.storeCurrency);
        this.setupFieldProperties(this.origPriceField, 100, false);
        SearchPanel priceDateSearchPanel = new SearchPanel(this.priceDate, SearchButton.SearchIcon.CALENDAR);
        this.setupFieldProperties(this.priceDate, 95, true);
        this.priceDate.setValue(new Timestamp(new Date().getTime()));
        boolean overridePrice = this.frParent.getUser().hasSecurity(11117L, 0);
        this.priceField = new DecimalField(SP.sParams.storeCurrency);
        this.setupFieldProperties(this.priceField, 100, overridePrice);
        if (overridePrice) {
            this.priceField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    LabelPrintingDlg.this.updatePrice();
                }

                @Override
                public void focusGained(FocusEvent e) {
                    LabelPrintingDlg.this.priceField.selectAll();
                }
            });
            this.priceField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabelPrintingDlg.this.updatePrice();
                }
            });
        }
        this.quantityField = new TouchTextField("");
        this.setupFieldProperties(this.quantityField, 100, true);
        this.quantityField.setDocument(PosUtils.createIntegerValidationDocument(false));
        this.quantityField.setHorizontalAlignment(4);
        this.quantityField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LabelPrintingDlg.this.quantityField.selectAll();
            }
        });
        this.quantityField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                LabelPrintingDlg.this.updatePrintQuantity();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LabelPrintingDlg.this.updatePrintQuantity();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LabelPrintingDlg.this.updatePrintQuantity();
            }
        });
        this.scanButton = new DialogButton("");
        this.scanButton.setText(StoreParams.res.getString("Label_Print_Scan_Button"));
        this.scanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelPrintingDlg.this.nextDialog = LabelDialogType.SCAN;
                LabelPrintingDlg.this.cancelDialog();
            }
        });
        this.bulkButton = new DialogButton("");
        this.bulkButton.setText(StoreParams.res.getString("Label_Print_Bulk_Button"));
        this.bulkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LabelPrintingDlg.this.sParams.checkIConn()) {
                    DlgMessage.showMessage(LabelPrintingDlg.this, SP.getRS("must_be_online"), SP.getRS("Offline"), -1, 0);
                    return;
                }
                LabelPrintingDlg.this.nextDialog = LabelDialogType.BULK;
                LabelPrintingDlg.this.cancelDialog();
            }
        });
        this.printButton = new DialogButton("");
        this.printButton.setText(StoreParams.res.getString("Alt+P_Print"));
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelPrintingDlg.this.print();
            }
        });
        this.closeButton = new DialogButton("");
        this.closeButton.setText(StoreParams.res.getString("Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelPrintingDlg.this.cancelDialog();
            }
        });
        this.getContentPane().add(panelMain);
        panelMain.add((Component)panelHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelBody, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelHeader.add((Component)this.headingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 20, 0, 20), 0, 0));
        panelHeader.add((Component)this.scanButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(10, 20, 0, 0), 0, 0));
        panelHeader.add((Component)this.bulkButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(10, 5, 0, 20), 0, 0));
        panelHeader.add((Component)this.search.getSearchPanel(), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 2, new Insets(10, 20, 20, 20), 0, 0));
        panelPrice.add((Component)this.priceField, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelPrice.add((Component)priceDateSearchPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        panelBody.add((Component)this.productBarcodeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.productCodeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.productDescriptionLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.colourCodeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.sizeValueLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.origPriceLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.priceLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.labelFormat, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.quantityLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.productBarcodeField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.productCodeField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.productDescriptionField, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.colourCodeField, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.sizeValueField, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.origPriceField, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)panelPrice, new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add(this.cmbFormat, new GridBagConstraints(1, 7, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 20, 5, 20), 0, 0));
        panelBody.add((Component)this.quantityField, new GridBagConstraints(1, 8, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        panelFooter.add((Component)this.printButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 0, 10, 15), 0, 0));
        panelFooter.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 15, 10, 0), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.search.getBarcodeSearchField());
        tabOrder.add(this.priceField);
        tabOrder.add(this.priceDate);
        tabOrder.add(this.cmbFormat);
        tabOrder.add(this.quantityField);
        tabOrder.add(this.printButton);
        tabOrder.add(this.closeButton);
        tabOrder.add(this.bulkButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
    }

    private boolean populate() {
        this.skuLabel = PrinterLabelFactory.createSkuLabel(this.currentSkuidx, this.priceDate.getValue());
        if (this.skuLabel == null) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Label_Print_Cant_Find_Style"), this.getTitle(), 0);
            return false;
        }
        this.productBarcodeField.setText(this.skuLabel.getDefaultBarcode());
        this.productCodeField.setText(this.skuLabel.getStyleCode());
        this.productDescriptionField.setText(this.skuLabel.getStyleName());
        this.colourCodeField.setText(this.skuLabel.getColourCode());
        this.sizeValueField.setText(this.skuLabel.getSizeValue());
        this.origPriceField.setText(new PosDouble(this.skuLabel.getOrigPrice(), SP.sParams.storeCurrency.getPrecision()).toString());
        this.priceField.setText(new PosDouble(this.skuLabel.getPrice(), SP.sParams.storeCurrency.getPrecision()).toString());
        this.quantityField.setText(String.valueOf(this.skuLabel.getPrintQuantity()));
        this.productDescriptionField.setCaretPosition(0);
        return true;
    }

    private boolean writeToDisk() {
        if (this.skuLabel == null) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Label_Print_Select_Product"), this.getTitle(), 0);
            this.search.getBarcodeSearchField().requestFocus();
            return false;
        }
        if (!this.skuLabel.getLabelFormat().validate()) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Label_Print_Template_File_Doesnt_Exist"), this.getTitle(), 0);
            this.search.getBarcodeSearchField().requestFocus();
            return false;
        }
        this.skuLabel.setLabelFormat((LabelFormat)this.cmbFormat.getSelectedItem());
        long printQty = this.skuLabel.getPrintQuantity();
        if (printQty <= 0L) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Label_Print_Enter_Quantity"), this.getTitle(), 0);
            this.quantityField.requestFocus();
            return false;
        }
        if (printQty > 100L) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Label_Print_Max_Quantity"), this.getTitle(), 0);
            this.quantityField.requestFocus();
            return false;
        }
        try {
            if (!this.skuLabel.writeLabelToFile()) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Label_Print_Failed_to_Print"), this.getTitle(), 0);
                this.search.getBarcodeSearchField().requestFocus();
                return false;
            }
            if (printQty == 1L) {
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("Label_Print_X_label_sent_to_printer"), String.valueOf(printQty)), this.getTitle(), 1);
            } else {
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("Label_Print_X_labels_sent_to_printer"), String.valueOf(printQty)), this.getTitle(), 1);
            }
            return true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    private void setupFieldProperties(TouchTextField field, int width, boolean editable) {
        field.setFieldWidth(width);
        field.setEditable(editable);
    }

    private void updatePrintQuantity() {
        if (this.skuLabel != null) {
            this.skuLabel.setPrintQuantity(PosUtils.intVal(this.quantityField.getText()));
        }
    }

    private void updatePrice() {
        if (this.skuLabel != null) {
            this.skuLabel.setPrice(this.priceField.getDouble());
            this.priceField.setText(this.skuLabel.getPrice());
        }
    }

    private void print() {
        boolean result = this.writeToDisk();
        if (result) {
            this.search.getBarcodeSearchField().requestFocus();
        }
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }

    @Override
    public void okDialog() {
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 80 && e.isAltDown()) {
            this.printButton.doClick();
            return true;
        }
        return false;
    }

    @Override
    public LabelDialogType getNextDialogType() {
        return this.nextDialog;
    }

    @Override
    public void showDialog() {
        this.setVisible(true);
    }
}

