/*
 * Decompiled with CFR 0.152.
 */
package jpos.logging;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;

public class RollingLog
implements Closeable {
    private LogType logType;
    private Logger logger;
    private FileHandler fh;

    private RollingLog(LogType logType) {
        this.logType = logType;
        this.initialiseLogger();
    }

    private void initialiseLogger() {
        if (this.logType.getLevel() == Level.OFF) {
            return;
        }
        this.logger = Logger.getLogger(this.logType.getName());
        this.logger.setLevel(this.logType.getLevel());
        try {
            this.fh = new FileHandler(this.logType.getLogPath() + this.logType.getName() + "_%g.log", 0x100000 * this.logType.getFileSizeMb(), this.logType.getNumberOfFiles(), true);
            this.fh.setFormatter(new LogFormatter());
            this.logger.addHandler(this.fh);
            this.logger.setUseParentHandlers(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void log(String message, Level messageLogLevel) {
        try {
            if (this.logType.getLevel() == Level.OFF) {
                return;
            }
            if (message == null) {
                message = "";
            }
            message = message.replace("\r\n", "\n").replace("\n", "\r\n");
            this.logger.log(messageLogLevel, message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.fh != null) {
                this.logger.removeHandler(this.fh);
                this.fh.close();
                this.fh = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(LogType logType, Level messageLogLevel, String message) {
        LogType logType2 = logType;
        synchronized (logType2) {
            try (RollingLog logger = new RollingLog(logType);){
                logger.log(message, messageLogLevel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void log(LogType logType, String message, Exception e) {
        String stackTrace = PosUtils.getStackTrace(e);
        if (stackTrace != null && stackTrace.length() > 2000) {
            stackTrace = stackTrace.substring(0, 2000);
        }
        if (message == null) {
            message = "";
        }
        message = String.format("%s\n%s\n%s\n", message, e.getMessage(), stackTrace);
        RollingLog.log(logType, Level.SEVERE, message);
    }

    private class LogFormatter
    extends Formatter {
        private static final String format = "%s\r\n%s: %s\r\n%s\r\n";
        private final Date date = new Date();

        private LogFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            this.date.setTime(record.getMillis());
            String message = this.formatMessage(record);
            String throwable = "";
            if (record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                record.getThrown().printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            }
            return String.format(format, this.date, record.getLevel().getLocalizedName(), message, throwable);
        }
    }

    public static enum LogType {
        AVATAX("avatax", Settings.getTaxLookupLogLevel(), 10, 5, SP.sParams.getLogpath()),
        REST_API("rest_api", Level.INFO, 10, 5, SP.sParams.getLogpath()),
        OMNEO("omneo", Level.INFO, 10, 5, SP.sParams.getLogpath()),
        TRANSACTION("transaction", Level.INFO, 10, 10, SP.sParams.getLogpath()),
        SHIPPIT("shippit", Level.INFO, 10, 10, SP.sParams.getDeliveryLabelLogDirectory() + File.separator),
        ZIP("zip", Level.INFO, 10, 10, SP.sParams.getLogpath()),
        BRAINTREE("braintree", Level.INFO, 10, 10, SP.sParams.getLogpath()),
        PAYPAL("paypal", Level.INFO, 10, 10, SP.sParams.getLogpath()),
        KLEBER("kleber", Level.INFO, 10, 10, SP.sParams.getLogpath()),
        OPENPAY("openpay", Level.INFO, 10, 10, SP.sParams.getLogpath()),
        CAPILLARY("capillary", Level.INFO, 10, 5, SP.sParams.getLogpath()),
        AUSPOST("australiapost", Level.INFO, 10, 10, SP.sParams.getDeliveryLabelLogDirectory() + File.separator),
        STARTRACK("startrackexpress", Level.INFO, 10, 10, SP.sParams.getDeliveryLabelLogDirectory() + File.separator);

        private String name;
        private Level level;
        private int fileSizeMb;
        private int numberOfFiles;
        private String logPath;

        private LogType(String name, Level level, int fileSizeMb, int numberOfFiles, String logPath) {
            this.name = name;
            this.level = level;
            this.fileSizeMb = fileSizeMb;
            this.numberOfFiles = numberOfFiles;
            this.logPath = logPath;
            if (level != Level.OFF && level != Level.INFO && level != Level.SEVERE) {
                throw new UnsupportedOperationException("Supported logging levels are OFF, INFO and SEVERE");
            }
        }

        public String getName() {
            return this.name;
        }

        public Level getLevel() {
            return this.level;
        }

        public int getFileSizeMb() {
            return this.fileSizeMb;
        }

        public int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public String getLogPath() {
            return this.logPath;
        }
    }
}

