/*
 * Decompiled with CFR 0.152.
 */
package jpos.omneo;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import jpos.AttachedLoyaltyManager;
import jpos.DecimalField;
import jpos.DlgManualLoyaltyDiscount;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.LoyaltyRedemptionPanel;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.XMLUtils;
import jpos.person.PersonUtils;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import org.jdom.Element;

public class ApiLoyaltyRedemptionPanel
extends LoyaltyRedemptionPanel {
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private LabelNormal lblDiscountTitle = new LabelNormal();
    private LabelNormal lblDiscountName = new LabelNormal();
    private LabelNormal lblPersonTitle = new LabelNormal();
    private LabelNormal lblPersonName = new LabelNormal();
    private LabelNormal lblAvailableRewards = new LabelNormal();
    private LabelNormal lblAvailableRewardsValue = new LabelNormal();
    private LabelNormal lblCurrentTransaction = new LabelNormal();
    private LabelNormal lblCurrenttransactionValue = new LabelNormal();
    private LabelNormal lblLoyaltyAmountTitle = new LabelNormal();
    private DecimalField dfLoyaltyAmount;
    private DialogButton bOK;
    private double availableRewards;
    private DlgManualLoyaltyDiscount parentDlg;

    public ApiLoyaltyRedemptionPanel(DlgManualLoyaltyDiscount parentDlg) {
        super(parentDlg);
        this.dfLoyaltyAmount = new DecimalField(SP.sParams.storeCurrency);
        this.bOK = new DialogButton("");
        this.availableRewards = 0.0;
        this.parentDlg = parentDlg;
        try {
            this.init();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void init() {
        this.lblDiscountTitle.setText(SP.getRS("Loyalty_Program"));
        this.lblPersonTitle.setText(SP.getRS("Person"));
        this.lblAvailableRewards.setText(SP.getRS("Available_Rewards"));
        this.lblCurrentTransaction.setText(SP.getRS("Current_Transaction"));
        this.lblLoyaltyAmountTitle.setText(SP.getRS("Redeem"));
        this.dfLoyaltyAmount.setFieldWidth(110);
        this.dfLoyaltyAmount.setText("0");
        this.bOK.setText(StoreParams.res.getString("OK"));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApiLoyaltyRedemptionPanel.this.getParentDlg().okDialog();
            }
        });
        this.lblDiscountTitle.setLabelWidth(150);
        this.lblDiscountName.setLabelWidth(250);
        this.lblPersonTitle.setLabelWidth(150);
        this.lblPersonName.setLabelWidth(250);
        this.lblAvailableRewards.setLabelWidth(150);
        this.lblAvailableRewardsValue.setLabelWidth(250);
        this.lblCurrentTransaction.setLabelWidth(150);
        this.lblCurrenttransactionValue.setLabelWidth(250);
        this.lblLoyaltyAmountTitle.setLabelWidth(150);
        this.setLayout(this.gridBagLayout);
        this.add((Component)this.lblDiscountTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblDiscountName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblPersonTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblPersonName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblAvailableRewards, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblAvailableRewardsValue, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblCurrentTransaction, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblCurrenttransactionValue, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblLoyaltyAmountTitle, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.dfLoyaltyAmount, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.bOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfLoyaltyAmount);
        v.add(this.bOK);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    @Override
    public double getAmount() {
        return this.dfLoyaltyAmount.getDouble();
    }

    @Override
    public void setPerson(Element person) {
        super.setPerson(person);
        this.lblPersonName.setText(PersonUtils.getPerName(person));
    }

    @Override
    public void setLoyaltyInfo(AttachedLoyaltyManager.LoyaltyInfo loyaltyInfo) {
        super.setLoyaltyInfo(loyaltyInfo);
        this.lblDiscountName.setText(loyaltyInfo.getLoyaltyDetails().getDiscount().getName());
    }

    @Override
    public void load() {
        this.lblCurrenttransactionValue.setText(PosDouble.valueOf(this.getTransactionTotal()).toString());
        this.lblAvailableRewardsValue.setText("");
        this.availableRewards = 0.0;
        try {
            if (this.parentDlg.frParent instanceof FrSales) {
                FrSales sales = (FrSales)this.parentDlg.frParent;
                if (sales.rewardsApiManager.requestBalance(this.getLoyaltyInfo().getCardNo(), XMLUtils.getLongValue(sales.getPerson(), "peridx"))) {
                    this.availableRewards = sales.rewardsApiManager.getBalance();
                    this.lblAvailableRewardsValue.setText(PosDouble.valueOf(this.availableRewards).toString());
                } else {
                    DlgMessage.showMessage(this.getParentDlg(), sales.rewardsApiManager.getLastError(), SP.getRS("omneo_failed_title"), 1);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.dfLoyaltyAmount.setText(Math.min(this.availableRewards, this.getTransactionTotal()));
        this.getParentDlg().setTitle(SP.getRS("Loyalty_Redemption"));
    }

    @Override
    public boolean validateInputs() {
        if (this.dfLoyaltyAmount.getDouble() < 0.0) {
            this.dfLoyaltyAmount.setText(0.0);
        }
        if (this.getAmount() > this.availableRewards) {
            DlgMessage.showMessage(this.getParentDlg(), SP.getRS("Redemption_exceeds_available_rewards"), SP.getRS("Invalid_Redemption_Amount"), 0);
            return false;
        }
        if (this.getAmount() > this.getTransactionTotal()) {
            DlgMessage.showMessage(this.getParentDlg(), SP.getRS("Redemption_exceeds_transaction_total"), SP.getRS("Invalid_Redemption_Amount"), 0);
            return false;
        }
        return true;
    }
}

