/*
 * Decompiled with CFR 0.152.
 */
package jpos.onlinereports;

import JCP.JcpApi;
import JCP.JcpObject;
import JCP.JcpRequestResult;
import java.io.Reader;
import java.io.StringReader;
import jpos.DlgMessage;
import jpos.PosUtils;
import jpos.StoreParams;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class OnlineReportProvider
extends JcpObject {
    private int onlineReportProviderID = -1;
    private StoreParams storeparams;

    public OnlineReportProvider(StoreParams sparams) {
        this.storeparams = sparams;
    }

    private int getOnlineReportProviderInstance() {
        if (this.onlineReportProviderID == -1) {
            try {
                JcpRequestResult result = JcpApi.CreateObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (String)"Bass.Ap21.Pos.PosPlatformExchange.OnlineReportProvider", (Object[])new Object[0]);
                if (!result.getSuccess()) {
                    throw new Exception(result.getCustomMessage() + "\r\n" + result.getErrorMessage() + "\r\n" + result.getStackTrace());
                }
                this.onlineReportProviderID = result.getRequestResultAsInt();
            }
            catch (Exception e) {
                PosUtils.logError(e);
                this.onlineReportProviderID = -1;
            }
        }
        return this.onlineReportProviderID;
    }

    public String executeAndReturnReport(String onlineReportName, String reportCriteria) throws Exception {
        if (this.getOnlineReportProviderInstance() > 0 && !this.storeparams.misMatchVersion) {
            JcpRequestResult result = JcpApi.InvokeMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.onlineReportProviderID, (String)"ExecuteReport", (Object[])new Object[]{onlineReportName, reportCriteria = reportCriteria.replace("\u0003", "#{CHR3};")});
            if (result.getSuccess()) {
                return this.processResult(result).replace("#{CHR3};", "\u0003");
            }
            throw new Exception(result.getErrorMessage());
        }
        return null;
    }

    private String processResult(JcpRequestResult result) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(result.getRequestResultAsXmlString()));
            Element returnXml = doc.getRootElement();
            if (returnXml.getName().equals("Error")) {
                if (returnXml.getAttribute("desc").getValue().equals("LinkDown")) {
                    this.storeparams.getStatusListener().setStatus(false);
                    return null;
                }
                if (!returnXml.getAttribute("desc").getValue().equals("No Docket")) {
                    if (returnXml.getChild("Exception") != null) {
                        String error_message = returnXml.getChild("Exception").getAttributeValue("error_message").replace("\n", "\r\n");
                        PosUtils.logError(String.format("%s\r\n%s", returnXml.getAttribute("desc").getValue(), error_message));
                    } else {
                        DlgMessage.showMessage(null, returnXml.getAttribute("desc").getValue(), StoreParams.res.getString("Error"), -1, 0);
                    }
                }
                return null;
            }
            return returnXml.getText();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.onlineReportProviderID > 0) {
            JcpApi.ReleaseObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.onlineReportProviderID);
            this.onlineReportProviderID = -1;
        }
    }
}

