/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JPanel;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.basscom.DecBuffer;
import jpos.pay.PayDialog;
import jpos.pay.RetTranP;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class AccountRemitDlg
extends PayDialog {
    private LabelNormal lBalance = new LabelNormal();
    private TouchTextField dfBalance = new TouchTextField();
    private LabelSubHeading lDesc = new LabelSubHeading();
    private LabelNormal lAmount = new LabelNormal();
    private DecimalField dfAmount;
    private DialogButton bOk;
    private DialogButton bCancel;
    private GridBagLayout gridBagLayoutAll;
    private GridBagLayout gridBagLayoutFooter;
    private JPanel panelFooter;
    private RetTranP retTranP;
    private DecBuffer custBalance;

    public AccountRemitDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfAmount = new DecimalField(SP.sParams.storeCurrency);
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        this.gridBagLayoutAll = new GridBagLayout();
        this.gridBagLayoutFooter = new GridBagLayout();
        this.panelFooter = new JPanel(this.gridBagLayoutFooter);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayoutAll);
        this.panelFooter.setLayout(this.gridBagLayoutFooter);
        this.lBalance.setText(SP.getRS("current_account_balance"));
        this.setAmtFieldProp(this.dfBalance);
        this.dfBalance.setDisabledTextColor(Colours.BLACK);
        this.dfBalance.setEnabled(false);
        this.dfBalance.setHorizontalAlignment(4);
        this.lDesc.setText(SP.getRS("pay_off_account"));
        this.lAmount.setText(SP.getRS("enter_amount_to_remit"));
        this.setAmtFieldProp(this.dfAmount);
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.dfAmount.setText("");
        this.getContentPane().add(this.panelAll);
        this.panelAll.add((Component)this.lDesc, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.lBalance, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelAll.add((Component)this.dfBalance, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(20, 10, 10, 20), 0, 0));
        this.panelAll.add((Component)this.lAmount, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.dfAmount, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelFooter, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 20, 10, 20), 0, 0));
        this.panelFooter.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelFooter.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfAmount);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    public void setRetTranP(RetTranP pRetTranP) {
        this.retTranP = pRetTranP;
    }

    public void setCustBalance(DecBuffer pCustBalance) {
        this.custBalance = pCustBalance;
    }

    @Override
    public boolean initDialog() {
        this.dfAmount.setText(this.retTranP.getAmount());
        boolean bShowAccountBalance = this.frSales.hasSecurity(11149L, 0);
        this.lBalance.setVisible(bShowAccountBalance);
        this.dfBalance.setVisible(bShowAccountBalance);
        if (this.custBalance.isNull() || !bShowAccountBalance) {
            this.dfBalance.setText(SP.getRS("not_available"));
        } else {
            this.dfBalance.setText(SP.sParams.storeCurrency.formatDetailNoScale(this.custBalance.doubleValue()));
        }
        return super.initDialog();
    }

    @Override
    public void okDialog() {
        double amountRnd = this.retTranP.getPayType().roundAmt(this.dfAmount.getDouble());
        if (amountRnd == this.dfAmount.getDouble()) {
            if (amountRnd < 0.0) {
                DlgMessage.showMessage(this, SP.getRS("negative_account_amount"), SP.getRS("Error"), 0);
                this.dfAmount.setText(0.0);
                this.dfAmount.selectAll();
            } else {
                this.retTranP.setAmount(-amountRnd);
                if (this.retTranP.getAmount() == 0.0) {
                    super.cancelDialog();
                } else {
                    super.okDialog();
                }
            }
        } else {
            this.dfAmount.setText(amountRnd);
        }
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }
}

