/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import jpos.DlgMessage;
import jpos.PosUtils;
import jpos.SP;
import jpos.StringUtils;
import jpos.basscom.DecBuffer;
import jpos.basscom.LongBuffer;
import jpos.pay.PayTypeFilter;

public class PayType {
    public static final long LAYBY = 456L;
    public static final long LAYBY_DEPOSIT = 457L;
    public static final long WITHDRAWAL = 548L;
    public static final long SPECIAL_ORDER = 642L;
    public static final long SPECORD_DEPOSIT = 643L;
    public static final long ACCOUNT_PAYMENT = 647L;
    public static final long ROUND = 518L;
    public static final int DEBTOR_ACCOUNT = 420;
    public static final int LAYBYADJUSTMENT = 568;
    public static final int LAYBYCANCELLATION = 569;
    public static final int SPECIALORDERADJUSTMENT = 644;
    public static final int SPECIALORDERCANCELLATION = 645;
    public static final int CUST_ORDER_PAYMENT = 716;
    public static final int CUST_ORDER_PICKUP = 730;
    public static final int AFTERPAY_POS = 776;
    public static final int ZIPPAY = 795;
    public static final int PAYPAL_REST = 847;
    public static final int BRAINTREE = 848;
    public static final int OPENPAY = 850;
    public static final int CREDIT_NOTE = 418;
    public static final int GIFT_VOUCHER = 419;
    public static final int VII_RETURN_VOUCHER = 862;
    public long idx;
    public String code;
    public String desc;
    public String intCode;
    public boolean round;
    public DecBuffer roundMultiple = new DecBuffer();
    public int roundDirection;
    private boolean bTillCounting;
    public DecBuffer tillMaxAmt = new DecBuffer();
    public LongBuffer tillCount = new LongBuffer();
    public boolean openTill;
    public String tillMsg;
    public DecBuffer minPayment = new DecBuffer();
    public DecBuffer maxPayment = new DecBuffer();
    public DecBuffer maxOverridePayment = new DecBuffer();
    public DecBuffer maxCashout = new DecBuffer();
    public Vector<String> changeTypeIdxs = new Vector();
    public Hashtable<String, DecBuffer> changeTypeMaxAmts = new Hashtable();
    public Vector<String> refundTypeIdxs = new Vector();
    public Hashtable<String, DecBuffer> refundTypeMaxAmts = new Hashtable();
    public boolean isCash;
    public boolean isEFT;
    public boolean isVoucher;
    public boolean isAccount;
    public boolean isCreditNote;
    public boolean isCheque;
    public boolean isViiVoucher;
    public boolean isExcluded;
    public long totalCount;
    public long userWarnedAtCount;
    public DecBuffer totalAmount = new DecBuffer();
    public boolean totalCheck;
    public boolean isEftposWltPay;
    public String wltPayCode;

    public PayType(long pIdx, String pCode) {
        this.idx = pIdx;
        this.code = pCode;
        this.totalCount = 0L;
        this.userWarnedAtCount = 0L;
        this.totalCheck = false;
    }

    public PayType(PayType payType) {
        this.idx = payType.idx;
        this.code = payType.code;
        this.desc = payType.desc;
        this.intCode = payType.intCode;
        this.roundMultiple = payType.roundMultiple;
        this.round = payType.round;
        this.roundDirection = payType.roundDirection;
        this.bTillCounting = payType.bTillCounting;
        this.tillMaxAmt = payType.tillMaxAmt;
        this.tillCount = payType.tillCount;
        this.tillMsg = payType.tillMsg;
        this.openTill = payType.openTill;
        this.minPayment = payType.minPayment;
        this.maxPayment = payType.maxPayment;
        this.maxOverridePayment = payType.maxOverridePayment;
        this.maxCashout = payType.maxCashout;
        this.changeTypeIdxs = payType.changeTypeIdxs;
        this.changeTypeMaxAmts = payType.changeTypeMaxAmts;
        this.refundTypeIdxs = payType.refundTypeIdxs;
        this.refundTypeMaxAmts = payType.refundTypeMaxAmts;
        this.isCash = payType.isCash;
        this.isEFT = payType.isEFT;
        this.isVoucher = payType.isVoucher;
        this.isAccount = payType.isAccount;
        this.isCreditNote = payType.isCreditNote;
        this.isCheque = payType.isCheque;
        this.isExcluded = payType.isExcluded;
        this.totalCount = payType.totalCount;
        this.userWarnedAtCount = payType.userWarnedAtCount;
        this.totalAmount = payType.totalAmount;
        this.totalCheck = payType.totalCheck;
        this.isEftposWltPay = payType.isEftposWltPay;
        this.wltPayCode = payType.wltPayCode;
    }

    public boolean isViiRefundVoucher() {
        return this.idx == 862L;
    }

    public void setChangeTypes(String idxs, String amts) {
        if (!StringUtils.isNullOrEmpty(idxs)) {
            try (PreparedStatement prepStmtActiveRefcode = SP.sParams.conn.prepareStatement("SELECT \"ACTIVE\" FROM REFCODE WHERE RCIDX = ?");){
                int idxPos = 0;
                int lastIdxPos = 0;
                int amtPos = 0;
                int lastAmtPos = 0;
                while (idxPos < idxs.length()) {
                    DecBuffer amt;
                    idxPos = idxs.indexOf(",", lastIdxPos);
                    amtPos = amts.indexOf(",", lastAmtPos);
                    if (idxPos == -1) {
                        idxPos = idxs.length();
                    }
                    if (amtPos == -1) {
                        amtPos = amts.length();
                    }
                    String cidx = idxs.substring(lastIdxPos, idxPos);
                    String sAmt = amts.substring(lastAmtPos, amtPos);
                    if (sAmt.equals("") || sAmt.equals(" ")) {
                        amt = new DecBuffer();
                    } else {
                        try {
                            amt = new DecBuffer(PosUtils.doubleValInternal(sAmt));
                        }
                        catch (Exception e) {
                            amt = new DecBuffer();
                        }
                    }
                    if (!cidx.equals("") && !cidx.equals(" ")) {
                        prepStmtActiveRefcode.setLong(1, PosUtils.longVal(cidx));
                        try (ResultSet result = prepStmtActiveRefcode.executeQuery();){
                            if (result.next() && result.getInt(1) == 1) {
                                this.changeTypeIdxs.add(cidx);
                                this.changeTypeMaxAmts.put(cidx, amt);
                            }
                        }
                    }
                    lastIdxPos = idxPos + 1;
                    lastAmtPos = amtPos + 1;
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public void setRefundTypes(String idxs, String amts) {
        if (!StringUtils.isNullOrEmpty(idxs)) {
            try (PreparedStatement prepStmtActiveRefcode = SP.sParams.conn.prepareStatement("SELECT \"ACTIVE\" FROM REFCODE WHERE RCIDX = ?");){
                int idxPos = 0;
                int lastIdxPos = 0;
                int amtPos = 0;
                int lastAmtPos = 0;
                while (idxPos < idxs.length()) {
                    DecBuffer amt;
                    idxPos = idxs.indexOf(",", lastIdxPos);
                    amtPos = amts.indexOf(",", lastAmtPos);
                    if (idxPos == -1) {
                        idxPos = idxs.length();
                    }
                    if (amtPos == -1) {
                        amtPos = amts.length();
                    }
                    String ridx = idxs.substring(lastIdxPos, idxPos);
                    String sAmt = amts.substring(lastAmtPos, amtPos);
                    if (sAmt.equals("") || sAmt.equals(" ")) {
                        amt = new DecBuffer();
                    } else {
                        try {
                            amt = new DecBuffer(PosUtils.doubleValInternal(sAmt));
                        }
                        catch (Exception e) {
                            amt = new DecBuffer();
                        }
                    }
                    if (!ridx.equals("") && !ridx.equals(" ")) {
                        prepStmtActiveRefcode.setLong(1, PosUtils.longVal(ridx));
                        try (ResultSet result = prepStmtActiveRefcode.executeQuery();){
                            if (result.next() && result.getInt(1) == 1) {
                                this.refundTypeIdxs.add(ridx);
                                this.refundTypeMaxAmts.put(ridx, amt);
                            }
                        }
                    }
                    lastIdxPos = idxPos + 1;
                    lastAmtPos = amtPos + 1;
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public double roundAmt(double amt) {
        boolean bIsNeg = amt < 0.0;
        amt = PayType.roundDec(Math.abs(amt));
        if (this.round) {
            double rndMultiple = this.roundMultiple.doubleValue();
            double ieeeRemainder = PayType.roundDec(Math.IEEEremainder(amt, rndMultiple));
            if (ieeeRemainder < 0.0) {
                ieeeRemainder = PayType.roundDec(ieeeRemainder + rndMultiple);
            }
            double quotient = PayType.roundDec((amt - ieeeRemainder) / rndMultiple);
            if (ieeeRemainder != 0.0) {
                switch (this.roundDirection) {
                    case 1: {
                        amt = (quotient + 1.0) * rndMultiple;
                        break;
                    }
                    case 0: {
                        amt = (double)Math.round(PayType.roundDec(amt / rndMultiple)) * rndMultiple;
                        break;
                    }
                    case -1: {
                        amt = quotient * rndMultiple;
                    }
                }
            }
        }
        if (bIsNeg) {
            return PayType.roundDec(-amt);
        }
        return PayType.roundDec(amt);
    }

    public boolean filter(PayTypeFilter pPayTypeFilter, boolean pbChange) {
        if (this.idx == 420L) {
            return pPayTypeFilter.bDebtor;
        }
        if (pPayTypeFilter.bDebtorOnly) {
            return false;
        }
        if (this.idx == 776L) {
            return pPayTypeFilter.bAfterpay && pbChange;
        }
        if (pbChange && this.isEFT && SP.sParams.isEFTPOSLoggedIn && SP.sParams.eftpos.disableRefund()) {
            return false;
        }
        return !this.isAccount && !this.isEFT && !this.isExcluded && !this.isVoucher || this.isAccount && pPayTypeFilter.bAccount && !this.isExcluded || this.isEFT && SP.sParams.isEFTPOSLoggedIn && !this.isExcluded || this.isVoucher && !pbChange;
    }

    public static double roundDec(double amt) {
        return SP.sParams.rnd(amt);
    }

    public void addTotal(boolean count, double amount) {
        if (count) {
            ++this.totalCount;
        }
        if (this.totalAmount.isNull()) {
            this.initTotalAmount();
        }
        this.totalAmount.setValue(this.totalAmount.doubleValue() + amount);
        this.totalCheck = true;
    }

    private void initTotalAmount() {
        double tillTot = 0.0;
        try {
            Throwable throwable;
            ResultSet result;
            try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT SUM(PAYMENT_AMOUNT) FROM RET_TRANP P, RET_TRANH RH WHERE P.PAYMENT_TYPEIDX = ? AND RH.VHIDX = P.VHIDX AND RH.COMPLETE IN (1, 4) AND RH.TILL_NUMBER = ? AND P.\"ACTIVE\" = 1 AND RH.\"ACTIVE\" = 1 GROUP BY P.PAYMENT_TYPEIDX");){
                stmt.setLong(1, this.idx);
                stmt.setString(2, SP.sParams.tillnum);
                result = stmt.executeQuery();
                throwable = null;
                try {
                    if (result.next()) {
                        tillTot += result.getDouble(1);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            stmt = SP.sParams.conn.prepareStatement("SELECT FLOATAMT FROM TILL_BALANCES WHERE TYPEIDX = ? AND TILL_NUMBER = ? ORDER BY UPDT DESC");
            var4_4 = null;
            try {
                stmt.setLong(1, this.idx);
                stmt.setString(2, SP.sParams.tillnum);
                result = stmt.executeQuery();
                throwable = null;
                try {
                    if (result.next()) {
                        tillTot += result.getDouble(1);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var4_4 = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (var4_4 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            var4_4.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        this.totalAmount.setValue(tillTot);
    }

    public void doTotalCheck(JFrame frame) {
        if (this.totalCheck && this.isTillCounting()) {
            if (this.tillMaxAmt.isNotNull() && this.tillMaxAmt.doubleValue() > 0.0 && this.totalAmount.doubleValue() > this.tillMaxAmt.doubleValue() && (this.tillCount.isNull() || this.userWarnedAtCount == 0L || this.totalCount - this.userWarnedAtCount >= this.tillCount.longValue())) {
                DlgMessage.showMessage(frame, this.tillMsg.length() > 0 ? this.tillMsg : MessageFormat.format(SP.getRS("tillLimitAmountMsg"), this.code), MessageFormat.format(SP.getRS("tillLimitAmountTitle"), this.code), -1, 2);
                this.userWarnedAtCount = this.totalCount;
            }
            this.totalCheck = false;
        }
    }

    public boolean isTillCounting() {
        return this.bTillCounting;
    }

    public void setTillCounting(boolean tillCounting) {
        this.bTillCounting = tillCounting;
    }
}

