/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JPanel;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.PayType;
import jpos.pay.PayTypeFilter;
import jpos.pay.PayTypes;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchList;

public class PayTypeDlg
extends PayDialog {
    private JPanel panel1 = new JPanel();
    private LabelSubHeading lPrompt = new LabelSubHeading();
    private TouchList<String> tendersList = new TouchList();
    private DialogButton bOk = new DialogButton("", this);
    private DialogButton bCancel = new DialogButton("", this);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private PosScrollPane scrollPane = new PosScrollPane(this.tendersList);
    private Vector<String> payTypeCodes;
    private Vector<PayType> payTypes;
    private PayType payType;

    public PayTypeDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.tendersList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    PayTypeDlg.this.bOk.doClick();
                }
            }
        });
        this.panel1.setLayout(this.gridBagLayout1);
        this.lPrompt.setText(SP.getRS("select_a_payment_type"));
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.scrollPane.setMinimumSize(new Dimension(200, 300));
        this.scrollPane.setPreferredSize(new Dimension(200, 300));
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.lPrompt, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 20, 10, 20), 0, 0));
        this.panel1.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 20, 10, 20), 0, 0));
        this.panel1.add((Component)this.bOk, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panel1.add((Component)this.bCancel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tendersList);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    public void setupSaleTenderList(PayTypeFilter pPayTypeFilter) throws Exception {
        this.payTypes = PayTypes.getSalePayTypes(pPayTypeFilter);
        this.setPayTypeCodes();
        if (this.payTypeCodes.size() == 0) {
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("no_valid_tenders"), objs), SP.getRS("Stop"), 2);
        }
        this.tendersList.setListData(this.payTypeCodes);
        this.tendersList.setSelectedIndex(0);
        this.pack();
    }

    public void setupRefundTenderList(PayTypeFilter pPayTypeFilter) throws Exception {
        this.payTypes = PayTypes.getRefundPayTypes(pPayTypeFilter);
        this.setPayTypeCodes();
        if (this.payTypeCodes.size() == 0) {
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("no_valid_tenders"), "\n"), SP.getRS("Stop"), 2);
        }
        this.tendersList.setListData(this.payTypeCodes);
        this.tendersList.setSelectedIndex(0);
        this.tendersList.revalidate();
        this.pack();
    }

    private void setPayTypeCodes() {
        this.payTypeCodes = new Vector(this.payTypes.size());
        for (int i = 0; i < this.payTypes.size(); ++i) {
            this.payTypeCodes.add(this.payTypes.get((int)i).code);
        }
    }

    @Override
    public void okDialog() {
        int i;
        if (this.payTypeCodes.size() > 0 && (i = this.tendersList.getSelectedIndex()) >= 0 && i < this.payTypes.size()) {
            this.payType = this.payTypes.get(i);
            super.okDialog();
        }
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    public PayType getPayType() throws Exception {
        return this.payType;
    }
}

