/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.basscom.DecBuffer;
import jpos.basscom.IntBuffer;
import jpos.basscom.LongBuffer;
import jpos.basscom.SqlSel;
import jpos.pay.PayType;
import jpos.pay.PayTypeFilter;
import jpos.pay.RetTranP;

public class PayTypes {
    public static Vector<PayType> vPayTypes = new Vector();
    public static Vector<PayType> vSalePayTypes = new Vector();
    static Vector<PayType> vRefundPayTypes = new Vector();
    public static PayType cashPayType = null;
    private static Vector<PayType> vWalletTypes = new Vector();

    public static Vector<PayType> getPayTypes() {
        return vPayTypes;
    }

    public static Vector<PayType> getSalePayTypes(PayTypeFilter pPayTypeFilter) {
        return PayTypes.filterPayTypes(vSalePayTypes, pPayTypeFilter, false);
    }

    public static Vector<PayType> getRefundPayTypes(PayTypeFilter pPayTypeFilter) {
        return PayTypes.filterPayTypes(vRefundPayTypes, pPayTypeFilter, true);
    }

    public static PayType getPayType(long idx) throws Exception {
        for (int i = 0; i < vPayTypes.size(); ++i) {
            if (PayTypes.vPayTypes.get((int)i).idx != idx || PayTypes.vPayTypes.get((int)i).isEftposWltPay) continue;
            return vPayTypes.get(i);
        }
        throw new Exception("Payment Type idx=" + idx + " not found");
    }

    private static void loadWalletPayTypes(PayType payType) {
        try (PreparedStatement wltPayStmt = SP.sParams.conn.prepareStatement("SELECT R.CODE, W.CODE AS WALLET_CODE, W.POS_PAYTYPE FROM REFCODE R JOIN WALLET_PAYTYPES W ON R.RCIDX = W.RCIDX WHERE R.RGIDX = 457 AND R.ACTIVE = 1");
             ResultSet result = wltPayStmt.executeQuery();){
            while (result.next()) {
                PayType walletPayType = new PayType(payType);
                walletPayType.code = result.getString("CODE");
                walletPayType.isEftposWltPay = true;
                walletPayType.wltPayCode = result.getString("WALLET_CODE");
                vWalletTypes.add(walletPayType);
                if (result.getInt("POS_PAYTYPE") != 1) continue;
                vPayTypes.add(walletPayType);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static Vector<RetTranP> getChangeRetTranPs(double pChangeTotal, Vector<RetTranP> pVPayments, PayTypeFilter pPayTypeFilter, boolean pbOverride) {
        Vector<RetTranP> vChangeRetTranPs = new Vector<RetTranP>();
        Hashtable<PayType, RetTranP> hChangeRetTranPs = new Hashtable<PayType, RetTranP>();
        if (pVPayments != null) {
            block11: {
                try {
                    boolean prioritiseCash = false;
                    for (RetTranP retTranP : pVPayments) {
                        if (!(retTranP.getAmount() > 0.0)) continue;
                        for (String changeIdx : retTranP.getPayType().changeTypeIdxs) {
                            RetTranP changeRetTranP;
                            if (changeIdx.trim().isEmpty()) continue;
                            DecBuffer changeMaxAmt = retTranP.getPayType().changeTypeMaxAmts.get(changeIdx);
                            PayType changePayType = PayTypes.getPayType(Long.parseLong(changeIdx));
                            if (!PayTypes.getSalePayTypes(pPayTypeFilter).contains(changePayType) || !changePayType.filter(pPayTypeFilter, true)) continue;
                            if (retTranP.getPayType().isCash && changePayType.isCash) {
                                prioritiseCash = true;
                            }
                            if ((changeRetTranP = hChangeRetTranPs.get(changePayType)) == null) {
                                changeRetTranP = new RetTranP(changePayType, 0.0);
                                changeRetTranP.setChange();
                                hChangeRetTranPs.put(changePayType, changeRetTranP);
                                vChangeRetTranPs.add(changeRetTranP);
                            }
                            if (pbOverride) {
                                changeRetTranP.allowedChangeAmount = pChangeTotal;
                                continue;
                            }
                            if (changeMaxAmt.isNull() || PayType.roundDec(changeMaxAmt.doubleValue()) > retTranP.getAmount()) {
                                changeRetTranP.allowedChangeAmount += retTranP.getAmount();
                                continue;
                            }
                            changeRetTranP.allowedChangeAmount += changeMaxAmt.doubleValue();
                        }
                    }
                    if (!prioritiseCash || vChangeRetTranPs.size() <= 1) break block11;
                    for (RetTranP change : vChangeRetTranPs) {
                        if (!change.getPayType().isCash) continue;
                        vChangeRetTranPs.remove(change);
                        vChangeRetTranPs.add(0, change);
                        break;
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
            if (pbOverride) {
                PayTypes.addOverrideChangeTypes(vChangeRetTranPs, hChangeRetTranPs, pChangeTotal, pPayTypeFilter);
            }
        }
        return vChangeRetTranPs;
    }

    public static void addOverrideChangeTypes(Vector<RetTranP> pvChangeRetTranPs, Hashtable<PayType, RetTranP> phChangeRetTranPs, double pChangeTotal, PayTypeFilter pPayTypeFilter) {
        Vector<PayType> vPayTypes = PayTypes.getSalePayTypes(pPayTypeFilter);
        for (int i = 0; i < vPayTypes.size(); ++i) {
            PayType payType = vPayTypes.get(i);
            if (!payType.filter(pPayTypeFilter, true) || payType.isEftposWltPay) continue;
            RetTranP retTranP = phChangeRetTranPs.get(payType);
            if (retTranP == null) {
                retTranP = new RetTranP(payType, 0.0);
                retTranP.setChange();
                retTranP.allowedChangeAmount = pChangeTotal;
                phChangeRetTranPs.put(payType, retTranP);
                pvChangeRetTranPs.add(retTranP);
                continue;
            }
            retTranP.allowedChangeAmount = pChangeTotal;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector<RetTranP> getRefundRetTranPs(double pChangeTotal, Vector<RetTranP> pVPayments, PayTypeFilter pPayTypeFilter, boolean pbOverride) {
        Hashtable<PayType, RetTranP> hRefundRetTranPs;
        Vector<RetTranP> vRefundRetTranPs;
        block11: {
            block12: {
                vRefundRetTranPs = new Vector<RetTranP>();
                hRefundRetTranPs = new Hashtable<PayType, RetTranP>();
                if (pVPayments != null && pVPayments.size() != 0) break block12;
                Vector<PayType> vRPayTypes = PayTypes.getRefundPayTypes(pPayTypeFilter);
                for (int i = 0; i < vRPayTypes.size(); ++i) {
                    PayType refundPayType = vRPayTypes.get(i);
                    RetTranP refundRetTranP = new RetTranP(refundPayType, 0.0);
                    refundRetTranP.allowedChangeAmount = pChangeTotal;
                    refundRetTranP.setChange();
                    hRefundRetTranPs.put(refundPayType, refundRetTranP);
                    vRefundRetTranPs.add(refundRetTranP);
                }
                break block11;
            }
            try {
                RetTranP rtpLastRound = null;
                int i = 0;
                while (true) {
                    block15: {
                        RetTranP retTranP;
                        block16: {
                            block13: {
                                block14: {
                                    if (i >= pVPayments.size()) break block13;
                                    retTranP = pVPayments.elementAt(i);
                                    if (retTranP.getPayType().idx != 518L) break block14;
                                    rtpLastRound = retTranP;
                                    break block15;
                                }
                                if (!(retTranP.getAmount() > 0.0)) break block15;
                                break block16;
                            }
                            if (rtpLastRound != null && rtpLastRound.getAmount() > 0.0) {
                                for (i = 0; i < vRefundRetTranPs.size(); refundRetTranP.allowedChangeAmount += rtpLastRound.getAmount(), ++i) {
                                    RetTranP refundRetTranP = vRefundRetTranPs.get(i);
                                }
                            }
                            break;
                        }
                        for (int j = 0; j < retTranP.getPayType().refundTypeIdxs.size(); ++j) {
                            RetTranP refundRetTranP;
                            DecBuffer refundMaxAmt;
                            block18: {
                                PayType refundPayType;
                                block17: {
                                    String refundIdx = retTranP.getPayType().refundTypeIdxs.get(j);
                                    if (refundIdx.trim().equals("")) continue;
                                    refundMaxAmt = retTranP.getPayType().refundTypeMaxAmts.get(refundIdx);
                                    refundPayType = PayTypes.getPayType(Long.parseLong(refundIdx));
                                    if (refundPayType.idx == 776L && retTranP.getPayType().idx != 776L || refundPayType.idx == 795L && retTranP.getPayType().idx != 795L || refundPayType.idx == 848L && retTranP.getPayType().idx != 848L || refundPayType.idx == 847L && retTranP.getPayType().idx != 847L || SP.sParams.isEftposProviderAdyen() && refundPayType.isEFT && !retTranP.getPayType().isEFT || !refundPayType.filter(pPayTypeFilter, true)) continue;
                                    refundRetTranP = hRefundRetTranPs.get(refundPayType);
                                    if (refundRetTranP != null) break block17;
                                    refundRetTranP = new RetTranP(refundPayType, 0.0);
                                    refundRetTranP.setChange();
                                    hRefundRetTranPs.put(refundPayType, refundRetTranP);
                                    vRefundRetTranPs.add(refundRetTranP);
                                    if (refundRetTranP.getPayType().isEFT || refundRetTranP.getPayType().idx == 776L || refundPayType.idx == 795L || refundPayType.idx == 847L || refundPayType.idx == 848L || refundPayType.idx == 850L) {
                                        PayType eftWallet;
                                        refundRetTranP.origRetTranP = retTranP;
                                        if (refundRetTranP.getPayType().isEFT && SP.sParams.isEftposProviderAdyen() && (eftWallet = PayTypes.getEftposWalletPayType(refundRetTranP.origRetTranP)) != null) {
                                            refundRetTranP.setPayType(eftWallet);
                                        }
                                    }
                                    break block18;
                                }
                                if (refundRetTranP.getPayType().isEFT && SP.sParams.isEftposProviderAdyen()) {
                                    refundRetTranP.setPayType(refundPayType);
                                    refundRetTranP.origRetTranP = null;
                                }
                            }
                            refundRetTranP.allowedChangeAmount = refundMaxAmt.isNull() || refundMaxAmt.doubleValue() > retTranP.getAmount() ? (refundRetTranP.allowedChangeAmount += retTranP.getAmount()) : (refundRetTranP.allowedChangeAmount += refundMaxAmt.doubleValue());
                            refundRetTranP.setCardType(retTranP.getCardType());
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        if (pbOverride) {
            PayTypes.addOverrideChangeTypes(vRefundRetTranPs, hRefundRetTranPs, pChangeTotal, pPayTypeFilter);
        }
        return vRefundRetTranPs;
    }

    public static PayType getEftposWalletPayType(RetTranP retTranP) {
        String cardType;
        if (retTranP != null && retTranP.getETran() != null && !(cardType = retTranP.getETran().getCardType()).isEmpty()) {
            for (int i = 0; i < vWalletTypes.size(); ++i) {
                if (!PayTypes.vWalletTypes.get((int)i).wltPayCode.equals(cardType)) continue;
                return vWalletTypes.get(i);
            }
        }
        return null;
    }

    public static Vector<PayType> filterPayTypes(Vector<PayType> pvPayTypes, PayTypeFilter pPayTypeFilter, boolean pbChange) {
        Vector<PayType> vFilteredSalePayTypes = new Vector<PayType>();
        for (int i = 0; i < pvPayTypes.size(); ++i) {
            PayType pt = pvPayTypes.get(i);
            if (!pt.filter(pPayTypeFilter, pbChange)) continue;
            vFilteredSalePayTypes.add(pt);
        }
        return vFilteredSalePayTypes;
    }

    public static void checkTotals(JFrame frame) {
        for (int i = 0; i < vPayTypes.size(); ++i) {
            PayType payType = vPayTypes.get(i);
            payType.doTotalCheck(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            StringBuffer idx = new StringBuffer();
            StringBuffer intCode = new StringBuffer();
            StringBuffer desc = new StringBuffer();
            StringBuffer code = new StringBuffer();
            StringBuffer round = new StringBuffer();
            DecBuffer roundMultiple = new DecBuffer();
            IntBuffer roundDirection = new IntBuffer();
            StringBuffer tillEODCounting = new StringBuffer();
            DecBuffer tillMaxAmt = new DecBuffer();
            LongBuffer tillCount = new LongBuffer();
            StringBuffer tillMsg = new StringBuffer();
            StringBuffer openTill = new StringBuffer();
            DecBuffer minPayment = new DecBuffer();
            DecBuffer maxPayment = new DecBuffer();
            DecBuffer maxOverridePayment = new DecBuffer();
            DecBuffer maxCashout = new DecBuffer();
            StringBuffer changeTypeIdxs = new StringBuffer();
            StringBuffer changeTypeAmts = new StringBuffer();
            StringBuffer refundTypeIdxs = new StringBuffer();
            StringBuffer refundTypeAmts = new StringBuffer();
            StringBuffer isCash = new StringBuffer();
            StringBuffer isEFT = new StringBuffer();
            StringBuffer isVoucher = new StringBuffer();
            StringBuffer isAccount = new StringBuffer();
            StringBuffer isCheque = new StringBuffer();
            StringBuffer isExcluded = new StringBuffer();
            StringBuffer isCreditNote = new StringBuffer();
            try (SqlSel sql = new SqlSel(SP.sParams.conn, "SELECT T.RCIDX, R.CODE, R.NAME,  T.ALT_CODE, T.ROUND, T.ROUND_MULTIPLE, T.ROUND_DIRECTION, T.TILL_EOD_COUNTING, T.TILL_MAX_AMT, T.TILL_COUNT, T.TILL_MSG, T.OPEN_TILL, T.MIN_PAYMENT, T.MAX_PAYMENT, T.MAX_OVERRIDE_PAYMENT, T.MAX_CASHOUT, T.CHANGE_TYP_IDXS, T.CHANGE_TYP_AMTS, T.REFUND_TYP_IDXS, T.REFUND_TYP_AMTS, T.EXCLUDE, T.IS_CASH, T.IS_EFT, T.IS_VOUCHER, T.IS_ACCOUNT, T.IS_CREDIT_NOTE, T.IS_CHEQUE FROM RET_PAY_TYPES T LEFT OUTER JOIN REFCODE R ON T.RCIDX = R.RCIDX and R.RGIDX = 39 ORDER BY R.RCIDX ");){
                PayType pt;
                String sIdx;
                sql.appendInto(idx);
                sql.appendInto(intCode);
                sql.appendInto(desc);
                sql.appendInto(code);
                sql.appendInto(round);
                sql.appendInto(roundMultiple);
                sql.appendInto(roundDirection);
                sql.appendInto(tillEODCounting);
                sql.appendInto(tillMaxAmt);
                sql.appendInto(tillCount);
                sql.appendInto(tillMsg);
                sql.appendInto(openTill);
                sql.appendInto(minPayment);
                sql.appendInto(maxPayment);
                sql.appendInto(maxOverridePayment);
                sql.appendInto(maxCashout);
                sql.appendInto(changeTypeIdxs);
                sql.appendInto(changeTypeAmts);
                sql.appendInto(refundTypeIdxs);
                sql.appendInto(refundTypeAmts);
                sql.appendInto(isExcluded);
                sql.appendInto(isCash);
                sql.appendInto(isEFT);
                sql.appendInto(isVoucher);
                sql.appendInto(isAccount);
                sql.appendInto(isCreditNote);
                sql.appendInto(isCheque);
                while (sql.next()) {
                    PayType payType = new PayType(Long.parseLong(idx.toString()), code.toString());
                    payType.desc = desc.toString().equals("") ? code.toString() : desc.toString();
                    String string = payType.intCode = intCode.toString().equals("") ? code.toString() : intCode.toString();
                    if (payType.code == null || payType.code.equals("")) {
                        payType.code = payType.desc;
                    }
                    payType.roundMultiple.setValue(roundMultiple.doubleValue());
                    payType.round = round.toString().equals("1");
                    payType.roundDirection = roundDirection.intValue();
                    payType.setTillCounting(tillEODCounting.toString().equals("1"));
                    payType.tillMaxAmt.setValue(tillMaxAmt.doubleValue());
                    payType.tillCount.setValue(tillCount.longValue());
                    payType.tillMsg = tillMsg.toString();
                    payType.openTill = openTill.toString().equals("1");
                    payType.minPayment.setValue(minPayment);
                    payType.maxPayment.setValue(maxPayment);
                    payType.maxOverridePayment.setValue(maxOverridePayment);
                    payType.maxCashout.setValue(maxCashout);
                    payType.setChangeTypes(changeTypeIdxs.toString(), changeTypeAmts.toString());
                    payType.setRefundTypes(refundTypeIdxs.toString(), refundTypeAmts.toString());
                    payType.isCash = isCash.toString().equals("1");
                    payType.isEFT = isEFT.toString().equals("1");
                    payType.isVoucher = isVoucher.toString().equals("1");
                    payType.isAccount = isAccount.toString().equals("1");
                    payType.isCreditNote = isCreditNote.toString().equals("1");
                    payType.isCheque = isCheque.toString().equals("1");
                    payType.isExcluded = isExcluded.toString().equals("1");
                    payType.isEftposWltPay = false;
                    payType.wltPayCode = "";
                    vPayTypes.add(payType);
                    if (payType.idx != 625L || !SP.sParams.isEftposProviderAdyen()) continue;
                    PayTypes.loadWalletPayTypes(payType);
                }
                StringTokenizer tok = new StringTokenizer(SP.sParams.saleTypeIdxs, ",");
                while (tok.hasMoreTokens()) {
                    sIdx = tok.nextToken();
                    if (sIdx.trim().equals("")) continue;
                    pt = PayTypes.getPayType(Long.parseLong(sIdx));
                    vSalePayTypes.add(pt);
                    if (pt.idx == 625L && SP.sParams.isEftposProviderAdyen()) {
                        for (int i = 0; i < vPayTypes.size(); ++i) {
                            if (!PayTypes.vPayTypes.get((int)i).isEftposWltPay) continue;
                            vSalePayTypes.add(vPayTypes.get(i));
                        }
                    }
                    if (cashPayType != null || !pt.isCash) continue;
                    cashPayType = pt;
                }
                if (cashPayType == null) {
                    throw new Exception("No cash payment types");
                }
                tok = new StringTokenizer(SP.sParams.refundTypeIdxs, ",");
                while (tok.hasMoreTokens()) {
                    sIdx = tok.nextToken();
                    if (sIdx.trim().equals("")) continue;
                    pt = PayTypes.getPayType(Long.parseLong(sIdx));
                    vRefundPayTypes.add(pt);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }
}

