/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import bass.eftpos.StringUtils;
import bass.eftpos.adyen.AdyenEftpos;
import com.braintreegateway.exceptions.AuthenticationException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.ExceptionInjector;
import jpos.FrSales;
import jpos.PaSales;
import jpos.PosDateFormatter;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.SignInSettings;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.SystemSettings;
import jpos.TransTypes;
import jpos.XMLUtils;
import jpos.basscom.DecBuffer;
import jpos.basscom.IntBuffer;
import jpos.basscom.LongBuffer;
import jpos.custorder.DespatchInfo;
import jpos.pay.AccountPaymentDlg;
import jpos.pay.AccountRemitDlg;
import jpos.pay.ChangeDlg;
import jpos.pay.ChangeDueDlg;
import jpos.pay.PayDialog;
import jpos.pay.PayDlgs;
import jpos.pay.PayType;
import jpos.pay.PayTypeDlg;
import jpos.pay.PayTypeFilter;
import jpos.pay.PayTypes;
import jpos.pay.PayUtils;
import jpos.pay.PaymentHistoryDlg;
import jpos.pay.PaymentTM;
import jpos.pay.PaymentTbl;
import jpos.pay.Printer;
import jpos.pay.RetTranP;
import jpos.pay.TenderEFTValsDlg;
import jpos.pay.TenderValDlg;
import jpos.pay.afterpay.AfterpayTran;
import jpos.pay.braintree.BraintreeTran;
import jpos.pay.eftpos.EftposUtils;
import jpos.pay.openpay.Openpay;
import jpos.pay.openpay.OpenpayTran;
import jpos.pay.paypal.PaypalTran;
import jpos.pay.zip.Order;
import jpos.pay.zip.ZipPay;
import jpos.pay.zip.ZipPayTran;
import jpos.pay.zip.ZipStatus;
import jpos.rewards.RewardsUtils;
import jpos.ui.Colours;
import jpos.ui.FormButton;
import jpos.ui.LabelHeading;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import jpos.ui.TouchToggleButton;
import jpos.voucher.DlgVoucherIssue;
import jpos.voucher.GatewayVoucher;
import jpos.voucher.GatewayVoucherTran;
import jpos.voucher.VoucherGatewayException;
import jpos.voucher.VoucherGatewayManager;
import jpos.voucher.VoucherIssueAdapter;

public class PaymentDlg
extends PayDialog {
    private PayDlgs payDlgs;
    private Vector<PayDialog> vInsPaymentDlgs = new Vector();
    private int transType;
    private boolean roundingVariancePay = false;
    private LabelHeading lPayment = new LabelHeading();
    private LabelSubHeading lTotalDue = new LabelSubHeading();
    private DecimalField dfTotalDue;
    private PaymentTM paymentTM;
    private PaymentTbl paymentTbl;
    private PosScrollPane paymentSP;
    private FormButton bPmtInsert;
    private FormButton bPmtDelete;
    private FormButton bPmtSetChange;
    private FormButton bAcntPayment;
    private GridBagLayout gridBagLayoutPmt;
    private JPanel pPayment;
    private LabelSubHeading lBalanceDue;
    private DecimalField dfBalanceDue;
    private double totalDue;
    private double balanceDue;
    private boolean eftposInProgress;
    private TouchToggleButton bPrintGift;
    private TouchToggleButton bCustAddr;
    private FormButton bBack;
    private FormButton bHistory;
    private FormButton bComplete;
    private GridBagLayout gridBagLayoutAll;
    private Vector<RetTranP> vOldRetTranPs;
    private List<?> lOldXML;
    private String sOldDocketNumber;
    private PayTypeFilter payTypeFilter;
    private PosDateFormatter nextPayDate;
    private PosDateFormatter finalPayDate;
    private RetTranP insertingRetTranP;
    private DecBuffer custBalance;
    private LongBuffer savedVHIdx;
    private Printer printer;
    private boolean bPromptForAccountPayment;

    public PaymentDlg(FrSales pFrSales, String title, PayDlgs payDlgs) {
        super((Frame)pFrSales, title);
        this.dfTotalDue = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.paymentTM = new PaymentTM();
        this.paymentTbl = new PaymentTbl(this.paymentTM);
        this.paymentSP = new PosScrollPane(this.paymentTbl);
        this.bPmtInsert = new FormButton("", this);
        this.bPmtDelete = new FormButton("", this);
        this.bPmtSetChange = new FormButton("", this);
        this.bAcntPayment = new FormButton("", this);
        this.gridBagLayoutPmt = new GridBagLayout();
        this.pPayment = new JPanel(this.gridBagLayoutPmt);
        this.lBalanceDue = new LabelSubHeading();
        this.dfBalanceDue = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.eftposInProgress = false;
        this.bPrintGift = new TouchToggleButton();
        this.bCustAddr = new TouchToggleButton();
        this.bBack = new FormButton("", this);
        this.bHistory = new FormButton(SP.getRS("F8_payment_history"));
        this.bComplete = new FormButton("", this);
        this.gridBagLayoutAll = new GridBagLayout();
        this.nextPayDate = new PosDateFormatter(null, 3, 3, 0);
        this.finalPayDate = new PosDateFormatter(null, 3, 3, 0);
        this.savedVHIdx = new LongBuffer();
        this.printer = new Printer();
        this.bPromptForAccountPayment = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PROMPT_FOR_ACCOUNT_PAYMENT);
        this.payDlgs = payDlgs;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public FrSales getParentFrame() {
        return this.frSales;
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayoutAll);
        this.lPayment.setText(SP.getRS("payment"));
        this.lTotalDue.setText(SP.getRS("total_due"));
        this.dfTotalDue.setBorder(SP.bdrTF);
        this.dfTotalDue.setEditable(false);
        this.initPaymentPanel();
        this.lBalanceDue.setText(SP.getRS("balance_due"));
        this.dfBalanceDue.setBorder(SP.bdrTF);
        this.dfBalanceDue.setEditable(false);
        this.bPrintGift.setText(SP.getRS("F6_print_gift_docket"));
        this.bCustAddr.setText(SP.getRS("F4_PrintCustAddr"));
        this.bAcntPayment.setText(SP.getRS("F3_account_payment"));
        this.bAcntPayment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PaymentDlg.this.isRunning && PaymentDlg.this.isVisible()) {
                    PaymentDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PaymentDlg.this.accountRemit();
                            PaymentDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.bBack.setText(SP.getRS("cancel"));
        this.bBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PaymentDlg.this.isRunning && PaymentDlg.this.isVisible()) {
                    PaymentDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PaymentDlg.this.cancelDialog();
                            PaymentDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.bHistory.setText(SP.getRS("F8_payment_history"));
        this.bHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PaymentDlg.this.isRunning && PaymentDlg.this.isVisible()) {
                    PaymentDlg.this.isRunning = true;
                    PaymentDlg.this.paymentHistory();
                    PaymentDlg.this.isRunning = false;
                }
            }
        });
        this.bComplete.setText(SP.getRS("complete"));
        this.bComplete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PaymentDlg.this.isRunning && PaymentDlg.this.isVisible()) {
                    PaymentDlg.this.frSales.setCursor(StoreParams.waitCursor);
                    PaymentDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PaymentDlg.this.okDialog();
                            PaymentDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.getContentPane().add(this.panelAll);
        this.panelAll.add((Component)this.lPayment, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.lTotalDue, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 20, 10, 5), 0, 0));
        this.panelAll.add((Component)this.dfTotalDue, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(10, 10, 10, 20), 100, 0));
        this.panelAll.add((Component)this.pPayment, new GridBagConstraints(0, 2, 4, 1, 0.0, 1.0, 13, 1, new Insets(10, 20, 10, 20), 100, 200));
        this.panelAll.add((Component)this.bHistory, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 5), 0, 0));
        this.panelAll.add((Component)this.bCustAddr, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.panelAll.add((Component)this.lBalanceDue, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 10, 5), 0, 0));
        this.panelAll.add((Component)this.dfBalanceDue, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(10, 10, 10, 20), 100, 0));
        this.panelAll.add((Component)this.bBack, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 20, 5), 0, 0));
        this.panelAll.add((Component)this.bPrintGift, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 20, 5), 0, 0));
        this.panelAll.add((Component)this.bAcntPayment, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 20, 5), 0, 0));
        this.panelAll.add((Component)this.bComplete, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.paymentTbl);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.bPmtInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PaymentDlg.this.isRunning && PaymentDlg.this.isVisible()) {
                    PaymentDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PaymentDlg.this.pmtInsert();
                            PaymentDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.bPmtDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PaymentDlg.this.isRunning && PaymentDlg.this.isVisible()) {
                    PaymentDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PaymentDlg.this.pmtDelete();
                            PaymentDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.bPmtSetChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PaymentDlg.this.isRunning && PaymentDlg.this.isVisible()) {
                    PaymentDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PaymentDlg.this.pmtSetChange();
                            PaymentDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
    }

    private void initPaymentPanel() {
        this.paymentTbl.revalidate();
        this.paymentSP.setPreferredSize(new Dimension(700, 100));
        this.bPmtInsert.setText(SP.getRS("F5_insert"));
        this.bPmtDelete.setText(SP.getRS("F2_delete"));
        this.pPayment.add((Component)this.paymentSP, new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.pPayment.add((Component)this.bPmtInsert, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.pPayment.add((Component)this.bPmtDelete, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.pPayment.add((Component)this.bPmtSetChange, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
    }

    private void revalidatePayments() {
        boolean enableCompleate;
        this.balanceDue = PayType.roundDec(this.totalDue - this.paymentTM.getTotal());
        if (this.payTypeFilter.bAccount) {
            this.bAcntPayment.setEnabled(this.paymentTM.getTotal(647L) == 0.0);
        }
        this.dfBalanceDue.setText(this.balanceDue);
        if (this.balanceDue < 0.0) {
            this.dfBalanceDue.setForeground(Colours.RED);
        } else {
            this.dfBalanceDue.setForeground(Colours.BLACK);
        }
        boolean bl = enableCompleate = this.balanceDue == 0.0;
        if (enableCompleate && this.totalDue == 0.0 && this.transType == 239 && this.bAcntPayment.isEnabled() && ((PaSales)this.frSales.paBody).tblStyles.getRowCount() == 0) {
            enableCompleate = false;
        }
        if (enableCompleate && this.totalDue == 0.0 && this.transType == 242) {
            enableCompleate = false;
        }
        this.bComplete.setEnabled(enableCompleate);
        if (this.transType == 556) {
            this.bPmtSetChange.setEnabled(false);
        } else if (this.isRefund()) {
            double refundAmt = PayType.roundDec(this.totalDue - this.paymentTM.getTotal(647L));
            this.bPmtSetChange.setEnabled(refundAmt < 0.0);
        } else {
            double changeAmt = this.totalDue;
            for (int line = this.paymentTM.getRowCount() - 1; line >= 0; --line) {
                RetTranP pmt = this.paymentTM.getRetTranP(line);
                if (pmt.isChange()) continue;
                changeAmt -= pmt.getAmount();
            }
            this.bPmtSetChange.setEnabled((changeAmt = PayType.roundDec(changeAmt)) < 0.0);
        }
        Vector<RetTranP> vSel = this.paymentTbl.getSelection();
        this.paymentTbl.tblModel.fireTableDataChanged();
        this.paymentTbl.setSelection(vSel);
        this.paymentTbl.revalidate();
    }

    private void pmtAutoRoundingVariance() {
        try {
            RetTranP retTranPRoundingVariance = new RetTranP(PayTypes.getPayType(518L), this.totalDue);
            this.paymentTM.appendPayment(retTranPRoundingVariance);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void pmtAutoChange() {
        this.balanceDue = this.totalDue;
        PayType ptChange = null;
        this.paymentTbl.deleteChgRnd();
        double cashout = this.paymentTM.getTotalCashout();
        this.balanceDue -= this.paymentTM.getTotal() - cashout;
        this.balanceDue = PayType.roundDec(this.balanceDue);
        Vector<RetTranP> vRetTranPs = this.isRefund() ? this.vOldRetTranPs : this.paymentTM.getRetTranPs();
        PayType ptRoundRule = null;
        for (int line = vRetTranPs.size() - 1; line >= 0; --line) {
            RetTranP pmt = vRetTranPs.get(line);
            if (pmt.isChange() || pmt.isRounding() || !pmt.getPayType().round) continue;
            ptRoundRule = pmt.getPayType();
            break;
        }
        Vector<RetTranP> vChangeRetTranPs = this.isRefund() ? PayTypes.getRefundRetTranPs(-this.balanceDue, vRetTranPs, this.payTypeFilter, false) : PayTypes.getChangeRetTranPs(-this.balanceDue, vRetTranPs, this.payTypeFilter, false);
        if (ptRoundRule == null) {
            for (int line = vChangeRetTranPs.size() - 1; line >= 0; --line) {
                RetTranP pmt = vChangeRetTranPs.get(line);
                if (pmt.isRounding() || !pmt.getPayType().round) continue;
                ptRoundRule = pmt.getPayType();
                break;
            }
        }
        this.testRounding(ptRoundRule);
        double changeLimit = PayType.roundDec(this.isRefund() ? -this.totalDue : this.paymentTM.getTotal() - cashout);
        for (RetTranP retTranPChange : vChangeRetTranPs) {
            double roundError;
            double rndBalanceDue;
            ptChange = retTranPChange.getPayType();
            if (ptChange != null && ptRoundRule == null && ptChange.round) {
                ptRoundRule = ptChange;
            }
            if (!((rndBalanceDue = PayType.roundDec(this.balanceDue - (roundError = this.getRoundError(ptRoundRule)))) < 0.0) || !(this.balanceDue < 0.0)) continue;
            if (!retTranPChange.getPayType().round && ptChange.roundAmt(-this.balanceDue) <= ptChange.roundAmt(retTranPChange.getMaxChangePayment(roundError, changeLimit))) {
                retTranPChange.setAmount(this.balanceDue);
            } else if (ptChange.roundAmt(-rndBalanceDue) <= ptChange.roundAmt(retTranPChange.getMaxChangePayment(roundError, changeLimit))) {
                retTranPChange.setAmount(rndBalanceDue);
            }
            if (retTranPChange.getAmount() == 0.0) continue;
            if (cashout != 0.0 && ptChange == PayTypes.cashPayType) {
                retTranPChange.setAmount(retTranPChange.getAmount() - cashout);
                cashout = 0.0;
            }
            this.paymentTM.appendPayment(retTranPChange);
            this.balanceDue -= retTranPChange.getAmount();
            this.balanceDue = PayType.roundDec(this.balanceDue);
            this.testRounding(ptRoundRule);
        }
        if (this.balanceDue < 0.0 && ptChange == null) {
            DlgMessage.showMessage(this, SP.getRS(this.isRefund() ? "no_valid_pay_types_refund" : "no_valid_pay_types_change"), SP.getRS("Stop"), 2);
        }
        if (cashout != 0.0 && PayTypes.cashPayType != null) {
            RetTranP retTranPCashChange = new RetTranP(PayTypes.cashPayType, -cashout);
            retTranPCashChange.setChange();
            this.paymentTM.appendPayment(retTranPCashChange);
        }
    }

    private void testRounding(PayType ptRoundRule) {
        if (ptRoundRule != null) {
            double roundError = this.getRoundError(ptRoundRule);
            try {
                if (roundError != 0.0 && PayType.roundDec(this.balanceDue) == roundError) {
                    RetTranP rounding = new RetTranP(PayTypes.getPayType(518L), roundError);
                    rounding.setRounding();
                    this.paymentTM.appendPayment(rounding);
                    this.balanceDue -= rounding.getAmount();
                    this.balanceDue = PayType.roundDec(this.balanceDue);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    private double getRoundError(PayType ptRoundRule) {
        double roundError = 0.0;
        if (ptRoundRule != null) {
            double rndErrPrice = PayType.roundDec(this.totalDue - ptRoundRule.roundAmt(this.totalDue));
            double paid = PayType.roundDec(this.totalDue - this.balanceDue);
            double rndErrPaid = PayType.roundDec(paid - ptRoundRule.roundAmt(paid));
            double requiredChangeTotal = PayType.roundDec(this.paymentTM.getTotalNoChange() - this.totalDue);
            double rndChange = requiredChangeTotal < 0.0 ? ptRoundRule.roundAmt(requiredChangeTotal) : PayType.roundDec(ptRoundRule.roundAmt(-1000000.0 + requiredChangeTotal) + 1000000.0);
            double rndErrChange = PayType.roundDec(rndChange - requiredChangeTotal);
            roundError = rndErrPaid == 0.0 ? rndErrPrice : rndErrChange;
        }
        return roundError;
    }

    public void setPaymentDetails(String pTitle, double pTotalDue, int pTransType, PayTypeFilter pPayTypeFilter) {
        this.paymentTbl.tblModel.deleteAllRows();
        this.paymentTbl.clearSelection();
        this.setTitle(pTitle);
        this.transType = pTransType;
        this.payTypeFilter = pPayTypeFilter;
        this.totalDue = PayType.roundDec(pTotalDue);
        this.dfTotalDue.setText(this.totalDue);
        if (this.isRefund()) {
            this.lPayment.setText(SP.getRS("refund"));
        } else {
            this.lPayment.setText(SP.getRS("payment"));
        }
        this.revalidatePayments();
    }

    public void setRoundVariancePay(boolean flag) {
        this.roundingVariancePay = flag;
    }

    public void setOldRetTranPs(String pOldDocketNumber, Vector<RetTranP> pVOldRetTranPs, List<?> pLOldXML) {
        this.sOldDocketNumber = pOldDocketNumber;
        this.vOldRetTranPs = pVOldRetTranPs;
        this.lOldXML = pLOldXML;
    }

    public void setNextPayDate(PosDateFormatter pNextPayDate) {
        this.nextPayDate = pNextPayDate;
    }

    public void setFinalPayDate(PosDateFormatter pFinalPayDate) {
        this.finalPayDate = pFinalPayDate;
    }

    public boolean isRefund() {
        return this.totalDue < 0.0;
    }

    private boolean isRoundingVariance() {
        return this.roundingVariancePay;
    }

    private void accountRemitLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PaymentDlg.this.accountRemit();
            }
        });
    }

    private void accountRemit() {
        if (this.payTypeFilter.bAccount) {
            try {
                RetTranP retTranP = new RetTranP(PayTypes.getPayType(647L), 0.0);
                AccountRemitDlg dAccountRemitDlg = this.payDlgs.addAccountRemitDlg();
                dAccountRemitDlg.setRetTranP(retTranP);
                dAccountRemitDlg.setCustBalance(this.custBalance);
                dAccountRemitDlg.setVisible(true);
                if (dAccountRemitDlg.getResult()) {
                    this.paymentTM.appendPayment(retTranP);
                    this.paymentTbl.setRowSelectionInterval(this.paymentTM.getRowCount() - 1, this.paymentTM.getRowCount() - 1);
                    this.pmtAutoChange();
                    this.revalidatePayments();
                }
                this.pmtAutoInsertLater();
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    private void pmtInsertDebtorTender() {
        try {
            PayType payType = PayTypes.getPayType(420L);
            this.insertingRetTranP = new RetTranP(payType, this.balanceDue);
            this.paymentTM.appendPayment(this.insertingRetTranP);
            this.paymentTbl.setRowSelection(this.insertingRetTranP);
            this.pmtAutoInsertLater();
            this.pmtAutoChange();
            this.revalidatePayments();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void pmtAutoInsertLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PaymentDlg.this.balanceDue > 0.0) {
                    PaymentDlg.this.pmtInsert();
                }
            }
        });
    }

    private void pmtInsert() {
        if (this.isRefund()) {
            return;
        }
        boolean allOk = true;
        int step = 0;
        PayTypeDlg dPayTypeDlg = null;
        while (allOk) {
            if (step == 0) {
                this.vInsPaymentDlgs.removeAllElements();
                dPayTypeDlg = this.payDlgs.addPayTypeDlg(this.vInsPaymentDlgs);
                try {
                    if (this.isRefund()) {
                        dPayTypeDlg.setupRefundTenderList(this.payTypeFilter);
                    } else if (!this.payTypeFilter.bAccount) {
                        dPayTypeDlg.setupSaleTenderList(this.payTypeFilter);
                    } else {
                        boolean bAccount;
                        boolean bl = bAccount = this.totalDue > 0.0;
                        if (bAccount) {
                            bAccount = !this.paymentTM.getAccountLineExists();
                        }
                        PayTypeFilter checkedPayTypeFilter = this.payTypeFilter.cloneMe();
                        checkedPayTypeFilter.bAccount = bAccount;
                        checkedPayTypeFilter.bAfterpay = !bAccount && !this.paymentTM.getAccountLineExists();
                        dPayTypeDlg.setupSaleTenderList(checkedPayTypeFilter);
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                    break;
                }
            }
            PayDialog dlgPay = this.vInsPaymentDlgs.get(step);
            if (this.frSales.isLoggedIn(false)) {
                dlgPay.setVisible(true);
            }
            if (this.frSales.isLoggedIn(false) && dlgPay.getResult()) {
                try {
                    PayType payType = dPayTypeDlg.getPayType();
                    if (step == 0) {
                        this.insertingRetTranP = new RetTranP(payType, 0.0);
                    }
                    if (payType.idx == 776L) {
                        if (this.paymentTM.getPayTypeLineExists(776L)) {
                            DlgMessage.showMessage(this, SP.getRS("afterpay_existing_line"), SP.getRS("error_add_payment"), -1, 64);
                            --step;
                        } else if (SP.sParams.isEftposProviderAdyen() && this.paymentTM.getWalletPayLineExists()) {
                            DlgMessage.showMessage(this, payType.code + " " + SP.getRS("wallet_payment_existing_line"), SP.getRS("invalid_tender_type"), -1, 64);
                            --step;
                        } else if (!this.procAfterpay(payType, step)) {
                            --step;
                        }
                    } else if (payType.idx == 795L) {
                        if (this.paymentTM.getPayTypeLineExists(795L) || !this.isRefund() && this.prevPaymentExist(795L)) {
                            DlgMessage.showMessage(this, SP.getRS("zippay_existing_line"), SP.getRS("error_add_payment"), -1, 64);
                            --step;
                        } else if (SP.sParams.isEftposProviderAdyen() && this.paymentTM.getWalletPayLineExists()) {
                            DlgMessage.showMessage(this, payType.code + " " + SP.getRS("wallet_payment_existing_line"), SP.getRS("invalid_tender_type"), -1, 64);
                            --step;
                        } else if (!this.procZipPay(payType, step)) {
                            --step;
                        }
                    } else if (payType.idx == 850L) {
                        if (this.paymentTM.getPayTypeLineExists(850L) || !this.isRefund() && this.prevPaymentExist(850L)) {
                            DlgMessage.showMessage(this, SP.getRS("openpay_existing_line"), SP.getRS("error_add_payment"), -1, 64);
                            --step;
                        } else if (SP.sParams.isEftposProviderAdyen() && this.paymentTM.getWalletPayLineExists()) {
                            DlgMessage.showMessage(this, payType.code + " " + SP.getRS("wallet_payment_existing_line"), SP.getRS("invalid_tender_type"), -1, 64);
                            --step;
                        } else if (!this.procOpenpay(payType, step)) {
                            --step;
                        }
                    } else if (payType.isCash) {
                        this.procCash(payType, step);
                    } else if (payType.isEFT) {
                        if (SP.sParams.isEftposProviderAdyen()) {
                            if (SP.sParams.eftpos instanceof AdyenEftpos && !SP.sParams.checkIConn() && !((AdyenEftpos)SP.sParams.eftpos).getHOConfig().usingLocalComms()) {
                                DlgMessage.showMessage(this, SP.getRS("offline_cannot_use_cloud_communication"), SP.getRS("error_add_payment"), -1, 64);
                                --step;
                            }
                            if (payType.isEftposWltPay && (this.paymentTM.getPayTypeLineExists(795L) || this.paymentTM.getPayTypeLineExists(850L) || this.paymentTM.getPayTypeLineExists(776L) || this.paymentTM.getEFTLineExists())) {
                                DlgMessage.showMessage(this, SP.getRS("wallet_payment_cannot_combine"), SP.getRS("invalid_tender_type"), -1, 64);
                                --step;
                            } else if (this.paymentTM.getWalletPayLineExists()) {
                                DlgMessage.showMessage(this, payType.code + " " + SP.getRS("wallet_payment_existing_line"), SP.getRS("invalid_tender_type"), -1, 64);
                                --step;
                            }
                        }
                        this.procEFT(payType, step);
                    } else if (payType.isVoucher) {
                        this.procVoucher(payType, step);
                    } else if (payType.isCreditNote) {
                        this.procCreditNote(payType, step);
                    } else if (payType.isAccount) {
                        this.procAccountPayment(payType, step);
                    } else {
                        this.procCash(payType, step);
                    }
                    ++step;
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                    --step;
                }
            } else {
                --step;
            }
            if (step < 0) {
                allOk = false;
                continue;
            }
            if (step != this.vInsPaymentDlgs.size()) continue;
            this.paymentTM.appendPayment(this.insertingRetTranP);
            this.paymentTbl.setRowSelection(this.insertingRetTranP);
            this.pmtAutoInsertLater();
            break;
        }
        this.pmtAutoChange();
        this.revalidatePayments();
    }

    @Override
    public boolean initDialog() {
        this.eftposInProgress = false;
        this.savedVHIdx.setValue();
        this.bPrintGift.setVisible(this.transType == 239 && !this.isRefund());
        this.bCustAddr.setVisible(this.frSales.frameType != 10 && this.frSales.getPerson() != null && this.frSales.getPerson().getAttribute("peridx") != null);
        this.bAcntPayment.setEnabled(this.payTypeFilter.bAccount);
        this.bHistory.setEnabled(this.lOldXML != null);
        if (this.payTypeFilter.bAccount) {
            this.custBalance = PayUtils.getBalance(this, this.frSales);
        }
        this.bPmtInsert.setEnabled(!this.isRefund() && this.transType != 556);
        this.bPmtDelete.setEnabled(!this.isRefund() && this.transType != 556);
        if (this.isRefund()) {
            this.bPmtSetChange.setText(SP.getRS("F7_set_refund"));
        } else {
            this.bPmtSetChange.setText(SP.getRS("F7_set_change"));
        }
        if (this.isRoundingVariance()) {
            this.pmtAutoRoundingVariance();
        } else if (this.isRefund()) {
            if (this.transType == 556) {
                this.pmtInsertDebtorTender();
            } else {
                this.pmtAutoChange();
            }
        } else if (this.payTypeFilter.bAccount && !this.isRefund() && this.transType == 239 && (this.custBalance != null && this.custBalance.doubleValue() > 0.0 && this.bPromptForAccountPayment || this.balanceDue == 0.0 && ((PaSales)this.frSales.paBody).tblStyles.getRowCount() == 0)) {
            this.accountRemitLater();
        } else if (this.balanceDue > 0.0) {
            if (this.transType == 556) {
                this.pmtInsertDebtorTender();
            } else {
                this.pmtAutoInsertLater();
            }
        }
        this.revalidatePayments();
        if (this.isRefund() && this.balanceDue != 0.0) {
            this.bPmtSetChange.doClick();
        }
        this.bPrintGift.setSelected(false);
        this.bCustAddr.setSelected(false);
        return super.initDialog();
    }

    private boolean pmtDelete() {
        RetTranP pmt;
        int i;
        int[] selRows = this.paymentTbl.getSelectedRows();
        for (i = selRows.length - 1; i >= 0; --i) {
            ZipPayTran zipTran;
            if (selRows[i] >= this.paymentTbl.getRowCount()) continue;
            pmt = this.paymentTM.getRetTranP(selRows[i]);
            if (pmt.getEFTStatus() == 3) {
                DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("approved_eftpos_trans_no_delete"), pmt.getPayType().code), SP.getRS("Continue_"), -1, 1);
                return false;
            }
            if (pmt.getPayType().idx != 795L || (zipTran = (ZipPayTran)pmt.getETran()).getStan() == null || zipTran.getStan().isEmpty() || zipTran.getZipStatus() != ZipStatus.Pending) continue;
            DlgMessage.showMessage(this, SP.getRS("zippay_payment_delete_confirm"), SP.getRS("Continue_"), -1, 1);
        }
        for (i = selRows.length - 1; i >= 0; --i) {
            pmt = this.paymentTM.getRetTranP(selRows[i]);
            if (pmt.getEFTStatus() == 3) continue;
            this.paymentTbl.deleteRow(selRows[i]);
        }
        this.pmtAutoChange();
        this.revalidatePayments();
        return true;
    }

    private boolean pmtSetChange() {
        ChangeDlg changeDlg = this.payDlgs.addSetChangeDlg();
        if (this.isRefund()) {
            double refundAmt = PayType.roundDec(this.totalDue - this.paymentTM.getTotal(647L));
            changeDlg.setRefundDets(this.totalDue, -refundAmt, this.vOldRetTranPs, this.payTypeFilter);
        } else {
            double changeAmt = this.totalDue;
            for (int line = this.paymentTM.getRowCount() - 1; line >= 0; --line) {
                RetTranP pmt = this.paymentTM.getRetTranP(line);
                if (pmt.isChange() || pmt.isRounding()) continue;
                changeAmt -= pmt.getAmount();
            }
            changeAmt = PayType.roundDec(changeAmt);
            changeDlg.setChangeDets(this.totalDue, -changeAmt, this.paymentTbl.tblModel.getRetTranPs(), this.payTypeFilter);
        }
        changeDlg.setVisible(true);
        if (changeDlg.getResult()) {
            this.paymentTbl.deleteChgRnd();
            changeDlg.getChange(this.paymentTM.getRetTranPs());
            this.revalidatePayments();
        }
        return true;
    }

    private void procCash(PayType payType, int step) throws Exception {
        if (step == 0) {
            TenderValDlg tenderValDlg = this.payDlgs.addTenderValDlg(this.vInsPaymentDlgs);
            tenderValDlg.setRetTranP(this.insertingRetTranP);
            tenderValDlg.setPaymentTM(this.paymentTM);
            this.insertingRetTranP.setAmount(this.balanceDue > 0.0 ? this.balanceDue : 0.0);
        }
    }

    private void procEFT(PayType payType, int step) throws Exception {
        if (step == 0) {
            TenderEFTValsDlg tenderEFTValsDlg = this.payDlgs.addTenderEFTValsDlg(this.vInsPaymentDlgs);
            this.insertingRetTranP.setAmount(this.balanceDue > 0.0 ? this.balanceDue : 0.0);
            tenderEFTValsDlg.setRetTranP(this.insertingRetTranP);
            tenderEFTValsDlg.setPaymentTM(this.paymentTM);
        } else if (step == 1) {
            this.insertingRetTranP.setEFTStatus(1);
        }
    }

    private void procVoucher(PayType payType, int step) throws Exception {
        if (step == 0) {
            this.insertingRetTranP.setAmount(this.balanceDue > 0.0 ? this.balanceDue : 0.0);
            this.payDlgs.addVoucherNumDlg(this.vInsPaymentDlgs).setRetTranPs(this.paymentTM.getRetTranPs(), this.insertingRetTranP);
        }
    }

    private boolean procAfterpay(PayType payType, int step) {
        DlgMessage.showMessage(this, "TODO: Probably remove or fix up if this appears", "DEV", -1, 0);
        return false;
    }

    private boolean procZipPay(PayType payType, int step) throws Exception {
        if (step == 0) {
            this.insertingRetTranP.setAmount(this.balanceDue > 0.0 ? this.balanceDue : 0.0);
            ZipPay zipPay = SP.sParams.getZipPay();
            if (zipPay != null) {
                TenderValDlg dlg = this.payDlgs.addZipPayDlg(this.vInsPaymentDlgs);
                dlg.setPaymentTM(this.paymentTM);
                dlg.setRetTranP(this.insertingRetTranP);
                if (this.insertingRetTranP.getETran() == null) {
                    ZipPayTran zipTran = new ZipPayTran(this.balanceDue < 0.0, 0.0);
                    if (this.frSales != null) {
                        zipTran.setOrder(new Order(((PaSales)this.frSales.paBody).tblStyles.getStyleLines()));
                        zipTran.setSalesRepName(this.frSales.salesRep.getName());
                    }
                    this.insertingRetTranP.setEFTTran(zipTran);
                    this.insertingRetTranP.setEFTStatus(1);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean procOpenpay(PayType payType, int step) throws Exception {
        if (step == 0) {
            this.insertingRetTranP.setAmount(this.balanceDue > 0.0 ? this.balanceDue : 0.0);
            Openpay openPay = SP.sParams.getOpenpay();
            if (openPay != null) {
                TenderValDlg dlg = this.payDlgs.addOpenpayDlg(this.vInsPaymentDlgs);
                dlg.setPaymentTM(this.paymentTM);
                dlg.setRetTranP(this.insertingRetTranP);
                if (this.insertingRetTranP.getETran() == null) {
                    OpenpayTran openpayTran = new OpenpayTran(this.balanceDue < 0.0, 0.0);
                    if (this.frSales != null) {
                        openpayTran.setCart(((PaSales)this.frSales.paBody).tblStyles.getStyleLines());
                    }
                    this.insertingRetTranP.setEFTTran(openpayTran);
                    this.insertingRetTranP.setEFTStatus(1);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private void procCreditNote(PayType payType, int step) throws Exception {
        if (step == 0) {
            this.payDlgs.addCreditNoteNumDlg(this.vInsPaymentDlgs).setRetTranPs(this.paymentTM.getRetTranPs(), this.insertingRetTranP);
        }
    }

    private void procAccountPayment(PayType payType, int step) throws Exception {
        if (step == 0) {
            AccountPaymentDlg accountPaymentDlg = this.payDlgs.addAccountPaymentDlg(this.vInsPaymentDlgs);
            accountPaymentDlg.setRetTranP(this.insertingRetTranP);
            accountPaymentDlg.setMaxAmt(this.totalDue);
            this.insertingRetTranP.setAmount(this.balanceDue < this.totalDue ? this.balanceDue : this.totalDue);
        }
    }

    public boolean dbInsertRetTranPs(Connection con, IntBuffer sequence) {
        long vhIdx = this.savedVHIdx.isNull() ? SP.sParams.currVal("XRET_TRANH") : this.savedVHIdx.longValue();
        return this.paymentTM.dbInsertRetTranPs(this, con, vhIdx, sequence);
    }

    public Vector<RetTranP> getRetTranPs() {
        return this.paymentTM.getRetTranPs();
    }

    public boolean isPrintingGiftDocket() {
        return this.bPrintGift.isSelected();
    }

    public boolean isPrintingCustAddr() {
        return this.bCustAddr.isSelected();
    }

    @Override
    public void okDialog() {
        if (this.balanceDue == 0.0) {
            try {
                this.panelAll.setEnabled(false);
                SignInSettings.getInstance().setTimeoutEnabled(false);
                if (this.doComplete()) {
                    super.okDialog();
                }
            }
            finally {
                this.frSales.setLastAction();
                if (!this.eftposInProgress) {
                    SignInSettings.getInstance().setTimeoutEnabled(true);
                }
                this.panelAll.setEnabled(true);
                this.frSales.setCursor(StoreParams.normalCursor);
            }
        }
    }

    @Override
    public void cancelDialog() {
        this.frSales.setCursor(StoreParams.waitCursor);
        try {
            this.panelAll.setEnabled(false);
            if (this.doUncomplete()) {
                super.cancelDialog();
            }
        }
        finally {
            this.panelAll.setEnabled(true);
            this.frSales.setCursor(StoreParams.normalCursor);
        }
    }

    private boolean doComplete() {
        boolean isPrinterOnline;
        boolean bOk = true;
        boolean bEFTExists = this.paymentTM.getEFTLineExists();
        if (Settings.useCheckPrinterStatus() && bEFTExists && !(isPrinterOnline = this.printer.checkPrinter().booleanValue())) {
            DlgMessage.showMessage(this, StoreParams.res.getString("Printer_offline_message"), StoreParams.res.getString("Printer_offline"), 0);
            this.toFront();
            this.bComplete.requestFocusInWindow();
            return false;
        }
        try {
            if (this.transType == 242 || this.transType == 240) {
                this.frSales.nextPayDate.setTime(this.nextPayDate.getTime());
                this.frSales.dueDate.setTime(this.finalPayDate.getTime());
            }
            if (this.savedVHIdx.isNull()) {
                Vector<StyleLine> giftLines = ((PaSales)this.frSales.paBody).tblStyles.getGiftLines();
                if (RewardsUtils.usingAp21RetailRewards() && giftLines.size() > 0) {
                    this.frSales.rewardsApiManager.setPerIdx(XMLUtils.getLongValue(this.frSales.getPerson(), "peridx"));
                    this.frSales.rewardsApiManager.setRequestGifts(giftLines);
                }
                if (bOk && !this.frSales.getUser().isTraningUser() && this.frSales.rewardsApiManager.hasRequestedRedemption() && !this.frSales.rewardsApiManager.redeem(this.frSales.getUser())) {
                    DlgMessage.showMessage(this, SP.getRS("Error_Redeeming_Loyalty"), SP.getRS("Error_Redeeming_Loyalty_Title"), 0);
                    this.toFront();
                    this.bComplete.requestFocusInWindow();
                    bOk = false;
                }
                if (!this.frSales.getUser().isTraningUser() && bOk && TransTypes.isCustOrder(this.transType) && !this.frSales.prepareOwnerSaleDocket()) {
                    this.bComplete.requestFocusInWindow();
                    return false;
                }
                if (!this.frSales.getUser().isTraningUser() && bOk && this.transType == 239 && this.frSales.isReturningSale() && !this.frSales.prepareOwnerReturnDocket()) {
                    this.bComplete.requestFocusInWindow();
                    return false;
                }
                if (bOk) {
                    SP.sParams.bDoingNewSave = true;
                    bOk = this.frSales.completeTrans();
                    SP.sParams.bDoingNewSave = false;
                }
                if (!this.frSales.getUser().isTraningUser() && bOk) {
                    this.savedVHIdx.setValue(SP.sParams.currVal("XRET_TRANH"));
                }
            } else {
                bOk = this.paymentTM.dbUpdateRetTranPs(this, SP.sParams.conn, this.savedVHIdx.longValue());
            }
            if (!this.frSales.getUser().isTraningUser() && bOk) {
                bOk = this.doGatewayVoucherRedemptions();
            }
            if (!this.frSales.getUser().isTraningUser() && bOk) {
                bOk = this.doBraintree();
            }
            if (!this.frSales.getUser().isTraningUser() && bOk) {
                bOk = this.doPaypal();
            }
            if (!this.frSales.getUser().isTraningUser() && bOk) {
                bOk = this.doOpenpay();
            }
            if (!this.frSales.getUser().isTraningUser() && bOk) {
                bOk = this.doZipPay();
            }
            if (!this.frSales.getUser().isTraningUser() && bOk && bEFTExists) {
                bOk = this.doEFTs();
            }
            if (!this.frSales.getUser().isTraningUser() && bOk) {
                bOk = this.doAfterpays();
            }
            if (!this.frSales.getUser().isTraningUser() && bOk) {
                bOk = this.loadGatewayVouchers();
            }
            ExceptionInjector.Inject(ExceptionInjector.Process.PAYMENTDLG_END_OF_COMPLETE);
            if (bOk) {
                if (!this.frSales.getUser().isTraningUser()) {
                    this.frSales.finishTransaction(true, true);
                }
                this.frSales.finishTransaction(false);
                if (!this.frSales.getUser().isTraningUser()) {
                    bOk = this.removeEFTPOSInProgress();
                }
            }
            if (bOk) {
                PaymentHistoryDlg dPaymentHistoryDlg = this.payDlgs.addPaymentHistoryDlg();
                dPaymentHistoryDlg.setLastSaleDets(SP.getRS("last_transaction"), this.paymentTM.getRetTranPs());
                Vector<RetTranP> changePayments = new Vector<RetTranP>();
                for (RetTranP payment : this.paymentTM.getRetTranPs()) {
                    if (!payment.isChange() || !payment.getPayType().openTill) continue;
                    changePayments.add(payment);
                }
                if (changePayments.size() > 0) {
                    ChangeDueDlg changeDueDlg = new ChangeDueDlg(this.frSales, changePayments);
                    changeDueDlg.setVisible(true);
                    changeDueDlg.dispose();
                }
                this.frSales.paHead.voidTrans(true);
            }
        }
        catch (Exception e) {
            SP.sParams.bDoingNewSave = false;
            PosUtils.logError(e);
            bOk = false;
        }
        return bOk;
    }

    private boolean removeEFTPOSInProgress() {
        if (this.eftposInProgress && this.savedVHIdx.isNotNull()) {
            try {
                PayUtils.deleteEftposIncompleteHdr(this, this.savedVHIdx.longValue());
                this.eftposInProgress = false;
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        return !this.eftposInProgress;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void paymentHistory() {
        try {
            PaymentHistoryDlg dPaymentHistoryDlg = this.payDlgs.addPaymentHistoryDlg();
            dPaymentHistoryDlg.setSaleDets(this.sOldDocketNumber, this.lOldXML);
            dPaymentHistoryDlg.setVisible(true);
            if (!dPaymentHistoryDlg.getResult()) return;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        if (k.getKeyCode() == 113) {
            this.bPmtDelete.doClick();
        } else if (k.getKeyCode() == 114) {
            this.bAcntPayment.doClick();
        } else if (k.getKeyCode() == 115) {
            this.bCustAddr.doClick();
        } else if (k.getKeyCode() == 116) {
            this.bPmtInsert.doClick();
        } else if (k.getKeyCode() == 117) {
            this.bPrintGift.doClick();
        } else if (k.getKeyCode() == 118) {
            this.bPmtSetChange.doClick();
        } else if (k.getKeyCode() == 119) {
            this.bHistory.doClick();
        } else if (k.getKeyCode() == 120) {
            this.bComplete.doClick();
        } else if (k.getKeyCode() == 10) {
            this.bComplete.doClick();
        } else if (k.getKeyCode() == 27) {
            this.bBack.doClick();
        } else {
            return false;
        }
        return true;
    }

    public boolean doEFTs() throws Exception {
        StringBuffer pRetMessage = new StringBuffer();
        EftposUtils.debugPoint(this, "Starting eftpos transaction");
        if (!this.eftposInProgress) {
            EftposUtils.debugPoint(this, "Inserting into EFTPOS_INCOMPLETE_HDR table\nVHIDX: " + this.savedVHIdx.longValue());
            try (PreparedStatement stmtInsert = SP.sParams.conn.prepareStatement("Insert into EFTPOS_INCOMPLETE_HDR(VHIDX, TILL_NUMBER, CRDT) values (?, ?, CURRENT_TIMESTAMP)");){
                stmtInsert.setLong(1, this.savedVHIdx.longValue());
                stmtInsert.setString(2, SP.sParams.tillnum);
                stmtInsert.execute();
            }
            this.eftposInProgress = true;
        }
        Vector<RetTranP> vRetTranPs = this.getRetTranPs();
        int i = 0;
        boolean firstEftposPayment = true;
        while (i < vRetTranPs.size()) {
            RetTranP retTranP = vRetTranPs.get(i);
            if (retTranP.getPayType().isEFT && retTranP.getEFTStatus() != 3) {
                retTranP.setEFTStatus(2);
                this.paymentTbl.setRowSelection(retTranP);
                StringBuffer retMessage = new StringBuffer();
                this.updatePaymentTbl(retTranP, i);
                retMessage.setLength(0);
                if (!firstEftposPayment) {
                    EftposUtils.eftposPaymentDelay();
                }
                firstEftposPayment = false;
                if (!retTranP.doEFT(this, retMessage)) {
                    if (retTranP.getEFTStatus() == 5) {
                        DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("eftpos_is_in_unknown_state"), SP.sParams.eftpos.getProviderName(), "\n"), SP.getRS("Error"), -1, 0);
                        super.cancelDialog();
                        SP.sParams.reverseIncompleteEFTs(this);
                        return false;
                    }
                    if (retTranP.getEFTStatus() == 6) {
                        DlgMessage.showMessage(this, retMessage.toString(), SP.getRS("Error"), -1, 0);
                        super.cancelDialog();
                        SP.sParams.reverseIncompleteEFTs(this);
                    }
                    retTranP.setEFTDeclined(retMessage.toString());
                    this.updatePaymentTbl(retTranP, i);
                    Object[] objs = new Object[]{"\n", retMessage.toString()};
                    if (DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("eftpos_try_again_yes_no"), objs), SP.getRS("eftpos_retry"), 3, 3) != 2) continue;
                    EftposUtils.logInfo(SP.sParams.conn, Long.toString(retTranP.vshIdx.longValue()), EftposUtils.Action.INFORMATION, "Eftpos retry cancelled by user.");
                    pRetMessage.append(retMessage);
                    return false;
                }
                retTranP.setEFTStatus(3);
                this.updatePaymentTbl(retTranP, i);
                RetTranP reversingRetTranP = retTranP.getReversingRetTranP();
                if (reversingRetTranP != null) {
                    this.paymentTM.deleteRow(retTranP);
                    this.paymentTM.deleteRow(reversingRetTranP);
                    i = 0;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        return true;
    }

    public boolean doAfterpays() throws Exception {
        Vector<RetTranP> vRetTranPs = this.getRetTranPs();
        int i = 0;
        while (i < vRetTranPs.size()) {
            RetTranP retTranP = vRetTranPs.get(i);
            if (retTranP.getPayType().idx == 776L && retTranP.getEFTStatus() != 3) {
                AfterpayTran afterpayTran;
                if (retTranP.eftposTran != null) {
                    afterpayTran = (AfterpayTran)retTranP.eftposTran;
                } else {
                    afterpayTran = new AfterpayTran(retTranP.getAmount() < 0.0, Math.abs(retTranP.getAmount()));
                    retTranP.eftposTran = afterpayTran;
                }
                afterpayTran.setReference(this.frSales.transnum);
                if (retTranP.isChange() && retTranP.origRetTranP != null) {
                    afterpayTran.setOrigStan(retTranP.origRetTranP.eftposTran.getStan());
                    afterpayTran.setOrigReference(retTranP.origRetTranP.eftposTran.getReference());
                } else if (retTranP.getReversingRetTranP() != null) {
                    afterpayTran.setOrigStan(retTranP.getReversingRetTranP().eftposTran.getStan());
                    afterpayTran.setOrigReference(retTranP.getReversingRetTranP().eftposTran.getReference());
                }
                StringBuffer retMessage = new StringBuffer();
                if (!retTranP.doAfterpay(this, retMessage)) {
                    DlgMessage.showMessage(this, retMessage.toString(), SP.getRS("afterpay_dlg_error"), -1, 0);
                    this.updatePaymentTbl(retTranP, i);
                    return false;
                }
                retTranP.setEFTStatus(3);
                this.updatePaymentTbl(retTranP, i);
                ++i;
                continue;
            }
            ++i;
        }
        return true;
    }

    public boolean doGatewayVoucherRedemptions() throws Exception {
        Vector<RetTranP> vRetTranPs = this.getRetTranPs();
        for (int i = 0; i < vRetTranPs.size(); ++i) {
            GatewayVoucherTran tran;
            RetTranP retTranP = vRetTranPs.get(i);
            if (!retTranP.isGatewayVoucherRedemption() || retTranP.getEFTStatus() == 3) continue;
            if (retTranP.eftposTran != null) {
                tran = (GatewayVoucherTran)retTranP.eftposTran;
            } else {
                if (retTranP.getAmount() < 0.0) {
                    throw new IllegalStateException("Gateway Vouchers can not be used as a refund transaction type.");
                }
                GatewayVoucher voucher = retTranP.getVoucherAdapter().getGatewayVoucher();
                tran = new GatewayVoucherTran(voucher.getNumber(), voucher.getPin(), retTranP.getAmount());
                retTranP.eftposTran = tran;
            }
            tran.setReference(this.frSales.generateExternalReference());
            StringBuffer retMessage = new StringBuffer();
            if (!retTranP.doGatewayVoucherRedemption(this, retMessage)) {
                DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("voucher_gateway_redeem_error"), "\n", retTranP.getVoucherAdapter().getGatewayVoucher().getNumber(), retMessage.toString()), SP.getRS("voucher_redemption"), -1, 0);
                this.updatePaymentTbl(retTranP, i);
                return false;
            }
            retTranP.setEFTStatus(3);
            this.updatePaymentTbl(retTranP, i);
        }
        return true;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadGatewayVouchers() {
        if (!VoucherGatewayManager.isGatewayInUse()) return true;
        List<StyleLine> voucherLines = ((PaSales)this.frSales.paBody).tblStyles.getNewGatewayVoucherLines();
        if (voucherLines.isEmpty()) {
            return true;
        }
        if (!VoucherGatewayManager.isGatewayReady(this)) {
            return false;
        }
        try {
            for (StyleLine voucherLine : voucherLines) {
                GatewayVoucher voucher;
                if (!voucherLine.IsDigitalVoucher()) {
                    boolean loaded = false;
                    while (!loaded) {
                        try {
                            voucher = VoucherGatewayManager.getInstance().getGateway().loadVoucher(this.savedVHIdx.longValue(), voucherLine.getVshidx(), voucherLine.getGvNum(), voucherLine.getGross(2), this.frSales.generateExternalReference());
                            if (voucher.isDeferred()) {
                                DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("vii_defer_load"), "\n", voucher.getNumber()), SP.getRS("voucher_gateway"), 1);
                            }
                            voucherLine.setGatewayVoucherLoadDetails(voucher);
                            loaded = true;
                        }
                        catch (VoucherGatewayException e) {
                            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("voucher_gateway_load_error"), "\n", voucherLine.getGvNum(), e.getMessage()), SP.getRS("Stop"), 0);
                        }
                        if (loaded) continue;
                        VoucherIssueAdapter voucherIssueAdapter = new VoucherIssueAdapter(this.frSales, ((PaSales)this.frSales.paBody).tblStyles.getAllVoucherNumbers());
                        DlgVoucherIssue d = new DlgVoucherIssue((PosFrame)this.frSales, SP.getRS("Issue_Voucher"), voucherIssueAdapter);
                        d.setVisible(true);
                        d.dispose();
                        if (voucherIssueAdapter.getGatewayVoucher() == null) {
                            this.reverseGatewayVoucherLoadRequests();
                            return false;
                        }
                        voucherLine.setNewGatewayVoucherNum(voucherIssueAdapter.getGatewayVoucher().getNumber());
                        ((PaSales)this.frSales.paBody).tblStyles.model.fireTableDataChanged();
                    }
                    continue;
                }
                try {
                    voucher = VoucherGatewayManager.getInstance().getGateway().orderVoucher(this.savedVHIdx.longValue(), voucherLine.getVshidx(), voucherLine.GetVoucherRecipientName(), voucherLine.GetVoucherRecipientSurname(), voucherLine.GetVoucherRecipientEmail(), voucherLine.GetMessage(), voucherLine.getGross(2), this.frSales.generateExternalReference(), voucherLine.getQty(), voucherLine.IsRefundVoucher());
                    if (voucher.isDeferred()) {
                        DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("vii_defer_new"), "\n", voucher.getNumber()), SP.getRS("voucher_gateway"), 1);
                    }
                    voucherLine.setGatewayVoucherLoadDetails(voucher);
                }
                catch (VoucherGatewayException e) {
                    DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("voucher_gateway_new_order_error"), "\n", voucherLine.getGvNum(), e.getMessage()), SP.getRS("Stop"), 0);
                    VoucherGatewayManager.getInstance().getGateway().cancelNewOrderRequests(this.savedVHIdx.longValue());
                    return false;
                    return true;
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            this.reverseGatewayVoucherLoadRequests();
            return false;
        }
    }

    private void reverseGatewayVoucherLoadRequests() {
        VoucherGatewayManager.getInstance().getGateway().cancelAllLoadRequests(this.savedVHIdx.longValue());
        for (StyleLine voucherLine : ((PaSales)this.frSales.paBody).tblStyles.getNewGatewayVoucherLines()) {
            try {
                voucherLine.setGatewayVoucherLoadDetails(null);
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }
    }

    public boolean doPaypal() throws Exception {
        Vector<RetTranP> vRetTranPs = this.getRetTranPs();
        boolean success = false;
        for (int i = 0; i < vRetTranPs.size(); ++i) {
            RetTranP retTranP = vRetTranPs.get(i);
            if (retTranP.getPayType().idx != 847L || retTranP.getEFTStatus() == 3) continue;
            StringBuffer retMessage = new StringBuffer();
            if (retTranP.getETran() == null && retTranP.origRetTranP != null && retTranP.getAmount() < 0.0) {
                if (!StringUtils.isNullOrEmpty((String)retTranP.origRetTranP.getETran().getStan())) {
                    PaypalTran paypalTran = new PaypalTran(true, 0.0);
                    paypalTran.setOrigStan(retTranP.origRetTranP.getETran().getStan());
                    paypalTran.setOrigCardType(retTranP.origRetTranP.getETran().getCardType());
                    retTranP.setEFTTran(paypalTran);
                } else {
                    DlgMessage.showMessage(this, SP.getRS("paypal_orig_pay_id_not_found"), SP.getRS("paypal_dlg_error"), -1, 0);
                    return false;
                }
            }
            success = retTranP.doPaypal(this, retMessage);
            this.updatePaymentTbl(retTranP, i);
            if (!success && retMessage.length() > 0) {
                DlgMessage.showMessage(this, retMessage.toString(), SP.getRS("paypal_dlg_error"), -1, 0);
            }
            return success;
        }
        return true;
    }

    public boolean doBraintree() throws Exception {
        Vector<RetTranP> vRetTranPs = this.getRetTranPs();
        boolean success = false;
        for (int i = 0; i < vRetTranPs.size(); ++i) {
            RetTranP retTranP = vRetTranPs.get(i);
            if (retTranP.getPayType().idx != 848L || retTranP.getEFTStatus() == 3) continue;
            StringBuffer retMessage = new StringBuffer();
            if (retTranP.getETran() == null && retTranP.origRetTranP != null && retTranP.getAmount() < 0.0) {
                if (!StringUtils.isNullOrEmpty((String)retTranP.origRetTranP.getETran().getStan())) {
                    BraintreeTran braintreeTran = new BraintreeTran(true, 0.0);
                    braintreeTran.setOrigStan(retTranP.origRetTranP.getETran().getStan());
                    braintreeTran.setOrigCardType(retTranP.origRetTranP.getETran().getCardType());
                    retTranP.setEFTTran(braintreeTran);
                } else {
                    DlgMessage.showMessage(this, SP.getRS("braintree_orig_pay_id_not_found"), SP.getRS("braintree_dlg_error"), -1, 0);
                    return false;
                }
            }
            try {
                success = retTranP.doBraintree(this, retMessage);
            }
            catch (AuthenticationException e) {
                DlgMessage.showMessage(this, SP.getRS("braintree_auth_failed"), SP.getRS("braintree_dlg_error"), -1, 0);
                return false;
            }
            this.updatePaymentTbl(retTranP, i);
            if (!success && retMessage.length() > 0) {
                DlgMessage.showMessage(this, retMessage.toString(), SP.getRS("braintree_dlg_error"), -1, 0);
            }
            return success;
        }
        return true;
    }

    public boolean doZipPay() throws Exception {
        Vector<RetTranP> vRetTranPs = this.getRetTranPs();
        boolean success = false;
        for (int i = 0; i < vRetTranPs.size(); ++i) {
            RetTranP retTranP = vRetTranPs.get(i);
            if (retTranP.getPayType().idx != 795L || retTranP.getEFTStatus() == 3) continue;
            StringBuffer retMessage = new StringBuffer();
            if (retTranP.getETran() == null && retTranP.origRetTranP != null && retTranP.getAmount() < 0.0) {
                if (!StringUtils.isNullOrEmpty((String)retTranP.origRetTranP.getETran().getReference())) {
                    ZipPayTran zipPayTran = new ZipPayTran(true, 0.0);
                    zipPayTran.setOrigReference(retTranP.origRetTranP.getETran().getReference());
                    zipPayTran.setOrigStan(retTranP.origRetTranP.getETran().getStan());
                    zipPayTran.setSalesRepName(this.frSales.salesRep.getMemName());
                    retTranP.setEFTTran(zipPayTran);
                } else {
                    DlgMessage.showMessage(this, retMessage.toString(), SP.getRS("zippay_original_payment_id_not_found"), -1, 0);
                    return false;
                }
            }
            success = retTranP.doZipPay(this, retMessage);
            this.updatePaymentTbl(retTranP, i);
            if (!success && retMessage.length() > 0) {
                DlgMessage.showMessage(this, retMessage.toString(), SP.getRS("zippay_dlg_error"), -1, 0);
            }
            return success;
        }
        return true;
    }

    public boolean doOpenpay() throws Exception {
        Vector<RetTranP> vRetTranPs = this.getRetTranPs();
        boolean success = false;
        for (int i = 0; i < vRetTranPs.size(); ++i) {
            RetTranP retTranP = vRetTranPs.get(i);
            if (retTranP.getPayType().idx != 850L || retTranP.getEFTStatus() == 3) continue;
            StringBuffer retMessage = new StringBuffer();
            if (retTranP.getETran() == null && retTranP.origRetTranP != null && retTranP.getAmount() < 0.0) {
                if (!StringUtils.isNullOrEmpty((String)retTranP.origRetTranP.getETran().getStan())) {
                    OpenpayTran openpayTran = new OpenpayTran(true, 0.0);
                    openpayTran.setOrigReference(retTranP.origRetTranP.getETran().getReference());
                    openpayTran.setOrigStan(retTranP.origRetTranP.getETran().getStan());
                    openpayTran.setSalesRepName(this.frSales.salesRep.getMemName());
                    retTranP.setEFTTran(openpayTran);
                } else {
                    DlgMessage.showMessage(this, retMessage.toString(), SP.getRS("openpay_original_payment_id_not_found"), -1, 0);
                    return false;
                }
            }
            success = retTranP.doOpenpay(this, retMessage);
            this.updatePaymentTbl(retTranP, i);
            if (!success && retMessage.length() > 0) {
                DlgMessage.showMessage(this, retMessage.toString(), SP.getRS("openpay_dlg_error"), -1, 0);
            }
            return success;
        }
        return true;
    }

    private void updatePaymentTbl(RetTranP retTranP, int i) {
        this.paymentTbl.setRowSelection(retTranP);
        this.paymentTM.fireTableRowsUpdated(i, i);
        this.paymentTbl.invalidate();
        this.paymentTbl.repaint();
        this.paymentSP.repaint();
    }

    private boolean doUncomplete() {
        boolean bOk = true;
        try {
            for (int i = 0; i < this.paymentTbl.getRowCount(); ++i) {
                ZipPayTran zipTran;
                RetTranP pmt = this.paymentTM.getRetTranP(i);
                if (pmt.getEFTStatus() == 3) {
                    bOk = DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("approved_eftpos_trans_reverse"), pmt.getPayType().code, "\n"), SP.getRS("Continue_"), 0, 3) == 0 ? this.reverseApprovedEFTs() : false;
                    break;
                }
                if (pmt.getPayType().idx != 795L || (zipTran = (ZipPayTran)pmt.getETran()) == null || zipTran.getStan() == null || zipTran.getStan().isEmpty() || zipTran.getZipStatus() != ZipStatus.Pending) continue;
                DlgMessage.showMessage(this, SP.getRS("zippay_payment_delete_confirm"), SP.getRS("Continue_"), -1, 1);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            bOk = false;
        }
        if (bOk) {
            bOk = this.removeEFTPOSInProgress();
        }
        if (bOk && this.frSales.rewardsApiManager.hasUncommittedRedemption()) {
            this.frSales.rewardsApiManager.reverseTransaction();
        }
        if (bOk && this.savedVHIdx.isNotNull()) {
            try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT 1 FROM RET_TRANH H WHERE H.COMPLETE = 0 AND H.DOCKET_NUMBER IS NULL AND H.VHIDX = " + this.savedVHIdx.longValue());){
                if (query.next()) {
                    bOk = this.frSales.deactivateTrans(this.savedVHIdx.longValue());
                    this.printAllEftposReceipts(this.savedVHIdx.longValue());
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
                bOk = false;
            }
            if (this.transType != 239) {
                this.frSales.voidTrans(true);
                this.frSales.paHead.logoff(true);
            }
        }
        return bOk;
    }

    private void printAllEftposReceipts(long vhidx) {
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT B.BLOBTEXT FROM RET_TRANP P JOIN BLOBTEXT B ON P.EFTPOS_BLOBIDX = B.BLOBIDX WHERE P.VHIDX = " + this.savedVHIdx.longValue() + " ORDER BY P.VSHIDX");){
            while (query.next()) {
                String receipt = query.getString(1);
                if (receipt == null || receipt.isEmpty()) continue;
                SP.sParams.eftposListener.printReceipt(false, false, receipt);
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private boolean reverseApprovedEFTs() {
        RetTranP pmt;
        int line;
        Vector<RetTranP> vToBeRevered = new Vector<RetTranP>();
        for (line = this.paymentTbl.getRowCount() - 1; line >= 0; --line) {
            pmt = this.paymentTM.getRetTranP(line);
            if (pmt.getEFTStatus() == 3) {
                StringBuffer retMessage;
                if (pmt.getPayType().idx == 795L) {
                    retMessage = new StringBuffer();
                    try {
                        if (pmt.reverseZipPay(this, retMessage)) {
                            DlgMessage.showMessage(this, SP.getRS("zippay_payment_reversed"), SP.getRS("zippay_dlg"), -1, 1);
                            this.paymentTbl.deleteRow(line);
                            continue;
                        }
                        DlgMessage.showMessage(this, retMessage.toString(), SP.getRS("zippay_dlg_error"), -1, 0);
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                    continue;
                }
                if (pmt.getPayType().idx == 850L) {
                    retMessage = new StringBuffer();
                    try {
                        if (pmt.reverseOpenPay(this, retMessage)) {
                            DlgMessage.showMessage(this, SP.getRS("openpay_payment_reversed"), SP.getRS("openpay_dlg"), -1, 1);
                            this.paymentTbl.deleteRow(line);
                            continue;
                        }
                        DlgMessage.showMessage(this, retMessage.toString(), SP.getRS("openpay_dlg_error"), -1, 0);
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                    continue;
                }
                if (pmt.isGatewayVoucherRedemption()) {
                    pmt.reverseGatewayVoucherRedemption();
                    continue;
                }
                vToBeRevered.add(pmt);
                continue;
            }
            this.paymentTbl.deleteRow(line);
        }
        for (line = 0; line < vToBeRevered.size(); ++line) {
            pmt = (RetTranP)vToBeRevered.get(line);
            RetTranP revPmt = new RetTranP(pmt.getPayType(), -pmt.getAmount());
            revPmt.setCashout(-pmt.getCashout());
            if (!pmt.isChange()) {
                revPmt.setChange();
            }
            revPmt.setReversingRetTranP(pmt);
            revPmt.dbInsert(this, SP.sParams.conn, this.savedVHIdx.longValue(), new IntBuffer(pmt.sequenceNumber));
            revPmt.vhIdx.setValue(pmt.vhIdx.longValue());
            revPmt.setEFTStatus(1);
            this.paymentTM.appendPayment(revPmt);
        }
        this.revalidatePayments();
        try {
            if (this.doEFTs() && this.doAfterpays() && this.doZipPay()) {
                return true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    @Override
    protected boolean inStealthMode() {
        return this.frSales.despatchInfo != null && this.frSales.despatchInfo.getDespatchType() == DespatchInfo.DespatchType.STORE_DESPATCH && this.totalDue == 0.0;
    }

    private boolean prevPaymentExist(long payType) {
        if (this.vOldRetTranPs != null) {
            for (int line = 0; line < this.vOldRetTranPs.size(); ++line) {
                if (this.vOldRetTranPs.get((int)line).getPayType().idx != payType) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void stealthModeAction() {
        this.setStealthModeDone(true);
        this.okDialog();
    }

    public PaymentTM getPaymentTM() {
        return this.paymentTM;
    }
}

