/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Vector;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.PayType;
import jpos.pay.PaymentTM;
import jpos.pay.RetTranP;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;

public class TenderValDlg
extends PayDialog {
    private LabelSubHeading lAmount = new LabelSubHeading();
    private DecimalField dfAmount;
    private DialogButton bOk;
    private DialogButton bCancel;
    private GridBagLayout gridBagLayout1;
    private RetTranP retTranP;
    private PaymentTM paymentTM;
    private PayType payType;

    public TenderValDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfAmount = new DecimalField(SP.sParams.storeCurrency);
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        this.gridBagLayout1 = new GridBagLayout();
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayout1);
        this.lAmount.setText("");
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.dfAmount.setText("");
        this.getContentPane().add(this.panelAll);
        this.panelAll.add((Component)this.lAmount, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.dfAmount, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 10, 20), 100, 0));
        this.panelAll.add((Component)this.bOk, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelAll.add((Component)this.bCancel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfAmount);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    public void setPaymentTM(PaymentTM pPaymentTM) {
        this.paymentTM = pPaymentTM;
    }

    public void setRetTranP(RetTranP pRetTranP) {
        this.retTranP = pRetTranP;
        this.payType = pRetTranP.getPayType();
    }

    @Override
    public boolean initDialog() {
        this.dfAmount.setText(this.retTranP.getAmount());
        Object[] objs = new Object[]{this.retTranP.getPayType().code};
        this.lAmount.setText(MessageFormat.format(SP.getRS("enter_amt_to_pay"), objs));
        this.pack();
        return super.initDialog();
    }

    @Override
    public void okDialog() {
        if (this.dfAmount.getDouble() > 9.9999999999E10) {
            DlgMessage.showMessage(this, SP.getRS("amount_too_large"), SP.getRS("Stop"), 0);
            return;
        }
        double amountRnd = this.payType.roundAmt(this.dfAmount.getDouble());
        if (amountRnd != this.dfAmount.getDouble()) {
            this.dfAmount.setText(amountRnd);
            return;
        }
        if (amountRnd < 0.0) {
            return;
        }
        if (this.dfAmount.getDouble() == 0.0) {
            return;
        }
        if (this.payType.maxOverridePayment.isNotNull() && PayType.roundDec(amountRnd + this.paymentTM.getTotalNoChange(this.payType)) > this.payType.maxOverridePayment.doubleValue() && !this.frSales.hasSecurity(11127L, 0)) {
            Object[] objs = new Object[]{SP.sParams.currFormat.format(this.payType.maxOverridePayment.doubleValue()), this.retTranP.getPayType().code};
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("max_payment_noman"), objs), SP.getRS("Stop"), 0);
            return;
        }
        if (this.payType.maxPayment.isNotNull() && PayType.roundDec(amountRnd + this.paymentTM.getTotalNoChange(this.payType)) > this.payType.maxPayment.doubleValue()) {
            Object[] objs = new Object[]{SP.sParams.currFormat.format(this.payType.maxPayment.doubleValue()), this.retTranP.getPayType().code};
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("max_payment_man"), objs), SP.getRS("Stop"), 0);
            return;
        }
        if (this.payType.minPayment.isNotNull() && amountRnd < this.payType.minPayment.doubleValue()) {
            Object[] objs = new Object[]{SP.sParams.currFormat.format(this.payType.minPayment.doubleValue()), this.retTranP.getPayType().code};
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("min_payment"), objs), SP.getRS("Stop"), 0);
            return;
        }
        this.retTranP.setAmount(amountRnd);
        super.okDialog();
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }
}

